Reuse Requests
==============

This FAQ is an attempt to collect answers to your common questions surrounding reusing content from arXiv in your materials. 

- [Can I reuse figures from an arXiv paper?](#figures) 
- [Do I need arXiv's permission to repost the full text?](#full_text)
- [How can I determine what license the version was assigned?](#what_license)
- [I want to include a paper of mine from arXiv in my thesis, do I need specific permission?](#thesis)
- [I want to include a paper of mine from arXiv in an institutional repository, do I need permission?](#ir)
- [Can I harvest the full text of works?](#bulk_data)

<span id="figures"></span>
## Can I reuse figures from an arXiv paper?

The short answer is "it depends". More specifically: 
  - If the [license](/help/license) applied to the work allows for remixing or reuse with citation, then yes. 
  - If not, then the version is assigned one of the [arXiv perpetual non-exclusive licenses](https://arxiv.org/licenses/nonexclusive-distrib/1.0/), and you will need to contact the submitter or copyright holder (if published) to determine applicable permissions. 

<span id="full_text"></span>
## Do I need arXiv's permission to repost the full text?

**Note:** All e-prints submitted to arXiv are subject to copyright protections. arXiv is not the copyright holder on any of the e-prints in our corpus. 

In some cases, submitters have provided permission in advance by submitting their e-print under a permissive [Creative Commons license](/help/license#licenses-available). The overwhelming majority of e-prints are submitted using the [arXiv perpetual non-exclusive license](https://arxiv.org/licenses/nonexclusive-distrib/1.0/), which does not grant further reuse permissions directly. In these cases you will need to contact the author directly with your request.

<span id="what_license"></span>
## How can I determine what license the version was assigned?

All arXiv abstract pages indicate an [assigned license](/help/license) underneath the "Download:" options. 

The link may appear as just the text `(license)`, such as at [arXiv:2201.14176](https://arxiv.org/abs/2103.14176v2). Articles between 1991 and 2003 have an [assumed license](https://arxiv.org/licenses/assumed-1991-2003/license.html). These are functionally equivalent to the arXiv non-exclusive license.  

If the license applied by the submitter is one of the Creative Commons licenses, then a "CC" logo will appear, such as at [arXiv:2201.04182](https://arxiv.org/abs/2201.04182v1). 

<span id="thesis"></span>
## I want to include a paper of mine from arXiv in my thesis, do I need specific permission?

If you are the copyright holder of the work, you do not need arXiv's permission to reuse the full text. 

<span id="ir"></span>
## I want to include a paper of mine from arXiv in an institutional repository, do I need permission?

You do not need arXiv's permission to deposit arXiv's version of *your* work into an institutional repository. For all other institutional repository cases, [see our help page on institutional repositories](/help/ir). 

<span id="bulk_data"></span>
## Can I harvest the full text of works? 

Plase see our [bulk data](/help/bulk_data) help page, and the [API Terms of Use](/help/api/tou) for specific options. Note that the license for the full text is not a part of the current search API schema. The license is, however, provided within arXiv's output from the [OAI-PMH](/help/oa) in either `arXiv` or `arXivRaw` formats. 
