# Appealing a moderation decision 

It is possible to appeal the classification of an announced article or the decision to decline a submission. In some cases, we may require that a paper be accepted for publication in a conventional journal before an appeal is considered. Note that some works that have been published or accepted by a journal may still be declined at arXiv’s discretion.

If you disagree with a [moderation](/help/moderation) decision, you may appeal for your desired outcome. The appeals process allows moderators time to reconsider a submission, but repeated requests with no additional information cannot be considered.

Appeals should be sent through our [user support portal](https://arxiv.org/support/moderation_help).  

- [What is a moderation appeal?](#what-is)
- [What happens when I appeal?](#what-happens)
- [What happens if my appeal is accepted?](#accepted)
- [What if my appeal is denied?](#denied)
- [Can all decisions be appealed?](#final)

<span id="what-is"></span>
## What is a moderation appeal?

An appeal is a request sent to arXiv staff. In general, appeals reconsider moderation [decisions before](/help/moderation#what-policies) and [after announcement](/help/moderation#policies-after). Appeals regarding declined works may only be made by authors: third-party appeals for inclusion cannot be considered.

Your appeal message must include all relevant details, such as submission or arXiv identifiers, former correspondence, etc. It must also include your rationale for why the moderators should reconsider the work, including a detailed description of the research content of your article, and how the content of your paper directly applies to your requested category (see the [category taxonomy](/category_taxonomy) for specific category descriptions). For declined submissions, it may be desirable for you to include a pdf copy of your work when appealing, as they are not retained in perpetuity. 

Appeals will only be considered if they are made through the appropriate channels: [user support portal](https://arxiv.org/support/moderation_help). Please do not attempt to contact moderators directly.  

<span id="what-happens"></span>
## What happens when I appeal?

You will receive a response from arXiv staff when your appeal has been sent to our appellate moderators for consideration. This response will include a ticket identifier that we will use to keep track of your appeal. 

The appeals process begins after acknowledgment of your appeal. If your submission was recently declined, arXiv staff will restore your submission to [on hold](/help/submit_status#on_hold) status, if possible.  

The appellate moderator will be sent your appeal and any correspondence related to the work, and will begin to consider the content of your appeal as well as the original moderation decision. Please be patient, as moderation appeals may be complicated and take some time. Appeals are handled in addition to the moderators’ daily duties, professional work, etc. Most appeals are resolved within a two week period, but some may take longer. If you have not heard from arXiv within two weeks of receiving the notification that your appeal has been received, please feel free to reach out to us for a status update through our [user support portal](https://arxiv.org/support/moderation_help).

When a decision is made by the appellate moderators, you will receive a follow-up message from arXiv staff with the results of your appeal. 

<span id="accepted"></span>
## What happens if my appeal is accepted? 

If your appeal is accepted, the message you receive from arXiv staff will have instructions for resubmission (if needed) or will provide you with the [status](/help/submit_status) of your submission. In some instances, you may be asked to make changes to the submission as directed by appellate moderators. 

*Note:* Articles that have already been made public and have been reclassified will not receive an announcement within the new category. 

<span id="denied"></span>
## What if my appeal is denied?

If your appeal is denied you will receive a message from arXiv staff regarding the decision. Detailed feedback about moderation decisions or appeals will not be provided.

<span id="final"></span>
## Can all decisions be appealed? 

When an appeal is denied by appellate moderators, no further appeal is possible. arXiv staff will not provide detailed feedback regarding the decision and will not enter into extended back and forth regarding a denied appeal. Extreme cases may be addressed to The arXiv [Leadership Team](/about/people/leadership_team), who may consult the appellate moderators or subject area advisory committees as needed. 

The decision to decline a submission, or the article's ultimate classification within our corpus, lies wholly with arXiv.
