# arXiv moderation

arXiv is a forum for professional members of the scientific community, providing rapid distribution of new research and maintaining a permanent collection of scientific work. As part of the service all submissions are subject to moderation. For more general information about the moderation process please [see our 2019 blog post](https://blog.arxiv.org/2019/08/29/our-moderation-process/).

- [Why does arXiv moderate submissions?](#why-moderate) 
- [What policies guide moderation before public announcement?](#what-policies)
    - [Reclassification of works](#reclassification)
    - [Declined Submissions](#declined)
    - [Scholarly interest](#scholarly-interest)
    - [Inappropriate format](#format)
    - [On a topic not covered, or a community not currently served](#out-of-scope)
    - [Duplicated content](#duplicated-content)
    - [Rights to submit material](#rights-to-submit)
    - [Excessive submission rate](#submission-rate)
- [What policies guide moderation after public announcement?](#policies-after)
- [Can I appeal a moderation decision?](#appeal)
- [Who are arXiv moderators?](#who-are-the-moderators)


<span id="why-moderate"></span>
## Why does arXiv moderate submissions?

arXiv is an openly accessible, moderated repository for scholarly papers in specific scientific disciplines. Material submitted to arXiv is expected to be of interest, relevance, and value to those disciplines. arXiv reserves the right to decline or reclassify any submission.

<span id="what-policies"></span>
## What policies guide moderation before public announcement?

This section describes the moderation process after a user submits a work and before the work is made public. As submissions are subject to the arXiv moderation process they may be reclassified or declined. Each work is considered on its content. arXiv moderation decisions may be influenced by the publication status of the submission, but prior publication does not guarantee acceptance in arXiv. Submitters who have had works previously delayed or rejected should anticipate closer scrutiny on future submissions. 

<span id="reclassification"></span>
### Reclassification of works

Reclassification by our moderators helps make sure that submissions are posted to the most [relevant category](/category_taxonomy) based on the assessment of the content by the moderators. Cross-lists may be added to other related categories, or they may be removed by moderators when the classification is deemed inappropriate. A submission that is cross-listed to a category will be announced in the mailings to that category.

<span id="declined"></span>
### Declined submissions

Some works submitted to arXiv may not be accepted. What follows are some example arXiv policies that could lead to a submission being declined. This is not an exhaustive list, and some works that have been published or accepted by a journal may still be declined at arXiv’s discretion.

Please note that the arXiv moderation process is not a peer-review process. arXiv staff and moderators cannot give feedback on the submission.


<span id="scholarly-interest"></span>
#### Scholarly interest

arXiv moderators expect submissions to be of scholarly archival interest to the communities they represent. A submission may be declined if the moderators determine it lacks originality, novelty, or significance.

Submissions that do not contain original or substantive research, including undergraduate research, course projects, and research proposals, news, or information about political causes (even those with potential special interest to the academic community) may be declined. Papers that contain inflammatory or fictitious content (see also [Code of Conduct](../policies/code_of_conduct)), or papers that use highly dramatic and misrepresentative titles/abstracts/introductions may be declined. Papers in need of significant review and revision may also be declined.

<span id="format"></span>
#### Inappropriate format

Submissions in a format deemed inappropriate, such as abstract-only submissions, presentations, book announcements, book reviews, submissions without references, calls for papers, articles containing advertisements or links to other repositories, may be rejected. We do not accept submissions with line numbers or submissions with watermarks. Germane "Comment on" and "Reply to" articles must still conform to normal scholarly discourse.  arXiv limits these submissions to a single "reply to" and "comment on" per original paper, and updates to the discourse can be made through [replacements](/help/replace). 


<span id="out-of-scope"></span>
#### On a topic not covered, or a community not currently served

While arXiv serves a variety of scientific communities, not all subjects are currently covered. Submissions that do not fit well into our current classification scheme, or whose intended audience is not a community we currently serve, may be declined.

<span id="duplicated-content"></span>
#### Duplicated content

If we notice that an author has made multiple similar submissions, or that a new submission appears to be a revision of a recent submission, then we may request that the submissions be consolidated. This helps ensure that arXiv is as useful as possible for all of the various communities submitting and reading articles, and it can often help the author present a more unified body of research.

<span id="rights-to-submit"></span>
#### Rights to submit material

Submissions to arXiv must be the author’s original work, and/or submitters must have the legal authority to grant the [selected license](/help/license). Authors must ensure the submission does not, to the best of their knowledge, infringe upon anyone's copyright. arXiv does not accept work containing verbatim comments by referees, plagiarized content, or other works barred by third party copyright.

<span id="submission-rate"></span>
#### Excessive submission rate

Articles submitted to arXiv must be of original, novel, and significant self-contained research and there is a practical limit to the rate at which appropriate, independent submissions can be produced by any one person. We may request that a particular author limit their submission rate. 

If an author has a back catalog of work to submit to arXiv, we ask that they submit no more than three papers per day.

<span id="policies-after"></span>
## What policies guide moderation after public announcement?

Once a paper is announced it becomes part of the permanent scholarly record. While arXiv reserves the right to remove any content, arXiv will only consider requests for removal if the submitter did not have the legal right to [agree to the license](/help/license).

In cases where public papers are found to violate arXiv policy, we may [withdraw the paper](/help/withdraw). arXiv may also indicate the concern in the Comments metadata.

arXiv may reclassify already announced papers if the moderators determine there is a more appropriate category.


<span id="appeal"></span>
## Can I appeal a moderation decision?

It is possible to appeal the classification of an announced article or the decision to decline a submission. In some cases, we may require that a paper be accepted for publication in a conventional journal before an appeal is considered. Note that some works that have been published or accepted by a journal may still be declined at arXiv’s discretion.

If you disagree with a moderation decision, you may appeal. Please be sure to carefully [read through the appeals process](appeals) to ensure your request is fully considered. Please note that decisions upon [appeal are final](appeals#final), and that no feedback will be provided with the decision.



<span id="who-are-the-moderators"></span>
## Who are arXiv moderators?

arXiv moderators are volunteer subject matter experts with terminal degrees in their field. They evaluate each submission’s content and category, following arXiv policies. [arXiv moderators](/moderators) are approved by their discipline-level [advisory committees](/about/people/scientific_ad_board#advisory_committees) and by arXiv staff.

Moderation is a professional responsibility. Moderators consider the submissions to arXiv as privileged information, as they would with a paper being refereed for a journal. We respect the confidentiality of the process and refrain from sharing information gathered during submission review.

Although the moderators may be publicly acknowledged, it is inappropriate to contact any moderator directly regarding your submission. 

All communication about moderation decisions should be through our [user support portal](/support/moderation_help). In extreme cases, the appropriate advisory committee chair may be contacted. Moderators are encouraged not to reply to personal correspondence regarding arXiv submissions. Neither arXiv staff nor moderators discuss submission status or moderation decisions with third parties.
