Why isn't a Person "Registered as an Author?"
=============================================

arXiv now maintains [authority records](authority), which link a
person's arXiv account with the papers that they have written. We say
that a person is "registered as an author" if there is an authority
record that links that person's account to a paper. Just as arXiv
submitters are responsible for papers they submit, arXiv users are
responsible for maintaining authority records for their papers.

There are several reasons why a person might not be registered as an
author:

1.  **The user might not have a user account on arXiv:** Some arXiv
    authors do not have an account for arXiv because other people have
    submitted all of the papers that they have authored. For instance,
    some professors have graduate students submit their own papers --
    such a professor will not be automatically "registered as an author"
    for all of their papers.

    Prior to 6 July 2003, it was possible to submit papers to arXiv via
    e-mail *without* creating a user account. Thus, some people who are
    quite prolific do not have arXiv accounts and are not "registered as
    an author". If such a person [creates a new
    account](https://arxiv.org/user/register) with the *same e-mail
    address* used for past submissions, we will automatically link their
    papers with their new account.

2.  **The user might not have claimed ownership of the papers:** People
    who submit papers to arXiv are automatically registered as paper
    owners who have the right to make changes to papers they submit.
    Currently, most people who are "registered as author(s)" are
    submitters, but co-authors can claim ownership of papers by using
    the [paper password](passwords#twotypes) given to the submitters.

    Submitters should share the paper password with their co-authors so
    that we can correctly register all of the authors of a paper. You
    can [claim ownership of a
    paper](http://arxiv.org/auth/need-paper-password) immediately if
    you have the paper password. If you cannot find the paper password,
    you can [request that our administrators grant you ownership of a
    paper](http://arxiv.org/auth/request-ownership). Because it may
    take several days for administrators to get around to your request,
    this procedure should only be a last resort if you absolutely cannot
    get the paper password.

3.  **The user might not have claimed authorship of the papers;**
    Although we encourage authors to submit their own papers, some
    papers are submitted by persons other than the authors. For
    instance, at some research institutes, an administrative assistant
    makes all of the submissions for a single department. When you
    submit a paper we will ask if you are an author, and we will also
    ask you when you claim ownership of a paper. A user will not be
    "registered as an author" if they enter incorrect information at
    this point.

4.  **We may have failed to have matched the user name:** Prior to 17
    Jan. 2003, we did not ask people if they were authors of the papers
    that they owned or submitted. During the upgrade, we had an
    automated process compare the names of paper owners and submitters
    to the authors of a paper. We made the user an author of a paper if
    the names matched, otherwise the user was registered as a
    non-author. Names can be ambiguous for many reasons, so no system of
    name matching can be perfect; although we have made some effort to
    tolerate alternate spelling and typographic errors and added
    heuristics for some common nicknames ("Bob" could really be
    "Robert"), our system has certainly made some mistakes.

    If you *own* a paper but are incorrectly registered as an author or
    non author, you can [change the authorship
    status](http://arxiv.org/auth/change-author-status) of your
    papers.
