# arXiv Code of Conduct Enforcement

arXiv is a platform where researchers engage with one another to participate in science, software development, and scholarly communications. It is also a community.

Our valued community of authors, readers, moderators, advisors, staff, collaborators, and supporters expects and deserves a respectful environment, which is why we adhere to a [Code of Conduct](code_of_conduct), [moderation standards](/help/moderation), and other policies. 

There are several actions that if taken, may result in a Code of Conduct violation. Such actions include but are not limited to utilizing inappropriate means of communication, abusive emails directed toward staff, repeatedly submitting inappropriate material, and may occur on any of arXiv’s channels. The Code of Conduct does not address issues concerning the acceptance of research articles. Any issues concerning moderation can utilize the appeals process described on the [arXiv moderation page](/help/moderation#appeal). 

## Reporting
If a community member feels that a violation has occurred, the violation can be reported via the [Code of Conduct reporting form](https://cornell.ca1.qualtrics.com/jfe/form/SV_6FgHTrYs5JT30wZ). Please note that any communication received through this form is treated confidentially in keeping with arXiv’s privacy policies. 

A committee formed of a combination of arXiv staff, leadership, and/or advisors will then determine whether or not a violation has occurred. 

## Potential Enforcement Actions

If it is determined that a violation of the Code of Conduct has occurred, arXiv will take enforcement actions. The enforcement will depend on a number of factors, including the channel where the violation happened, whether it was directed at a specific individual or a group of people, if it is part of a pattern of repeated violations, and the severity of the violation. 

The following are examples of possible enforcement actions, which may be taken alone, in combination, or with additional measures not listed here.

### Email Notification

* In all cases, the violator will receive a written warning explaining the violation.
* If additional enforcement actions are required, the email will also explain the enforcement action and its duration. 
    
### Account Level Enforcement

* Verifying account identity: arXiv staff may take extra steps to ensure that the user is representing themselves accurately.
* Suspending submission privileges: the user may not be allowed to submit papers for a designated period.
* Flagged account: the user’s account may be flagged, notifying administrators and moderators to more closely monitor the user’s activity.
* Suspending user account:  the user will not be able to access their account.

### Submission Level Enforcement

* If a submission (or the user’s related arXiv offense) violates arXiv policy or legal requirements, the submission may be removed, withdrawn, or redacted. Similarly, a violator’s ownership of a submission may be removed, or arXiv could require replacement of the submission. 
* arXiv may edit the submission’s metadata, including adding metadata notes.
  
If legal issues arise from a violation, Cornell’s Office of University Counsel and/or relevant law enforcement will be contacted.

If a user disagrees with arXiv’s enforcement decision, there may be an opportunity to appeal. However, the option to appeal will not always be available depending on the type of infraction and limited staff time.

The vast majority of arXiv’s community is engaged and respectful, and for that we are grateful. The above enforcement actions are available to ensure that arxiv remains safe and productive for all. 






