To replace an article
=====================

You can replace a publicly announced article by selecting the Replace
(![replace icon](https://arxiv.org/images/replace.png)) icon for the article you want to
replace on your [user page](/replace). We ask that articles be replaced no more than once 
per week.

Note that if your article or replacement has not yet been publicly
announced you may select the Unsubmit (![unsubmit
icon](https://arxiv.org/images/unsubmit.png)) icon next to the submission on your [user
page](http://arxiv.org/user) to return it to the [incomplete
status](submit_status#incomplete) allowing modification and later
resubmission via the Update (![update icon](/images/update.png)) icon.

<span id="consider"></span>

Considerations for replacing articles
-------------------------------------

-   [It is not possible to make changes without generating a new
    version.](#minorchanges)
-   [Indicate the nature of the changes.](#nature)
-   [Same day edits do not generate a new date/version
    stamp, but may delay the replacement.](#sameday)
-   [Previous versions of your article will remain publicly
    available.](#versions)
-   [Replacements will be posted based on the regular announcement schedule](availability)    
-   [Revisions after version 5 are not listed in the daily email subscriptions.](#announcements)

<span id="minorchanges"></span>

It is not possible to make changes without generating a new version
-------------------------------------------------------------------

Why? To allow authors to make changes to the comments and other metadata
fields of publicly announced articles without generating a new version,
and hence date stamp, would effectively mean that all changes would be
backdated to the time the last version was submitted. This is open to
abuse and thus not allowed.

The exceptions to this rule are the addition of [journal reference,
DOI, and report number information](jref). The journal reference field may contain only
full publication information for the article; the DOI field may contain
only a DOI.

<span id="nature"></span>

Indicate the nature of the changes
----------------------------------

Readers like to know why an article has been replaced. Often, changes
are of a minor nature, but if the author does not indicate this then
readers will generally assume the worst. Therefore, you should give some
reason for the replacement. This should appear in the `Comments:` field
of the new submission.

Some typical reasons for replacing an article:

-   Added references.
-   Corrected typos.
-   Revised argument in section 3, results unchanged.

Example comments upon replacement:

-   `Comments: 32 pages harvmac; added references for section 5`
-   `Comments: 8 pages, LaTeX; typos corrected, references added`

Remember to merge your original comments with the new ones. If you do
not, then the old comments will be lost. For instance, in the examples
above, the TeX related comments and page counts were copied from the
previous versions of the comments, since they are still valid and
useful.

<span id="sameday"></span>

Same day edits do not generate a new version stamp.
---------------------------------------------------

Edits made during the same day before 14:00 US Eastern Time (EDT/EST)
Monday to Friday will not generate a new version stamp in the archives
and will not delay announcement.

Edits made during the same day after 14:00 US Eastern Time (EDT/EST) but
before public announcement will not generate a new version stamp in the
archives but **will irrevocably delay announcement**.

You may wish to check [current local time](http://arxiv.org/localtime)
at the main site. Note that for these purposes Friday 14:00 to Monday
14:00 is considered "one day". This allows you to immediately check your
article and correct any trivial mistakes, especially mistakes in the
title/abstract itself, without a "penalty". **Check your submissions!**

<span id="versions"></span>

Previous versions of your article will remain publicly available.
-----------------------------------------------------------------

arXiv provides public access to all previous versions of submitted
articles. See the discussion on [availability of previous
versions](versions).

<span id="announcements"></span>

Revisions after version 5 are not listed in the daily mailings
--------------------------------------------------------------

This policy is to avoid unnecessary noise in the email announcements. We ask that submitters
refrain from replacing more frequently than once per week. 
