Utilities for the E-Print World
===============================

arXiv users, independent of what platform they choose, should install a
handful of utilities and applications so that they can derive the
maximal benefit from the archives. They should install or have access to
the following:

### Tools for Browsing

-   An up-to-date Web browser
-   [A PDF viewer](config_browser#pdf)
-   [A PostScript viewer](config_browser#ps)
-   JPEG, PNG, GIF, MPEG viewers

### Tools for Submitting

-   [TeX, with a dvi previewer](#tex)
-   [A utility for creating and extracting 'tar' or 'zip'
    archives](#taretc)
-   [A utility for uncompressing and compressing files](#taretc)
-   [Tools for bitmapping PostScript](bitmap)

If you do not have a full set of tools, you can still function with the
e-print archives, but their usefulness may be somewhat limited for you.
In time you will discover which tools are necessary for your usage
patterns.

<span id="tex"></span>
### TeX

Most authors will submit the [TeX](tex) source for their documents.
There are some [important technical reasons](faq/whytex) for this.

The TeX system used by arXiv is based on the [TeXLive
distribution](http://www.tug.org/texlive/), which is a freely available,
high-quality distribution of TeX/LaTeX for Unix-compatible systems.

Lots of TeX information is available on the Web from the TeX User Group
at <http://www.tug.org>.

Access to a worldwide TeX repository is available from the [CTAN
site](http://ctan.org).

RevTeX and other APS-related TeX information can be found at
<http://aps.org/>.

See <https://arxiv.org/hypertex/> for HyperTeX utilities and Hyperdvi
viewers.

<span id="taretc"></span>
### tar and gzip

You can obtain excellent versions of tar, gzip from the [GNU
Project](http://www.gnu.org/). The source code is freely redistributable
and supports a very wide range of platforms.

<span id="extensions"></span>
### Filename extensions

To avoid unnecessary confusion, you are strongly urged to use the
standard file name extensions when submitting your files. In most cases
arXiv can detect the file type without recourse to the extension but
following convention makes life easier, and is necessary in a some cases
(for example, to tell between a .zip and a .docx). Here are some
conventions you should use:

-   **.gz** = GNU's gzip compression
-   **.tar.gz** = gzipped tar archive
-   **.tgz** = Acceptable PC alternative to .tar.gz
-   **.tex** = TeX
-   **.sty** = LaTeX style files
-   **.cls** = LaTeX2e class files
-   **.dvi** = DVI file
-   **.png** = PNG graphics
-   **.ps** = PostScript
-   **.ps.gz** = gzipped PostScript
-   **.pdf** = PDF portable document format
-   **.eps** = Encapsulated PostScript
-   **.gif** = GIF graphics
-   **.jpg** = JPEG graphics
-   **.mpg** = MPEG animations
-   **.hqx** = Macintosh bin-hexed files (not recommended)
-   **.bbl** = latex bibliographic files
-   **.zip** = ZIP archive
-   **.docx** = Microsoft DOCX document
-   **.txt, .asc** = plain ASCII text
