# Submission Version Availability

arXiv is intended as a historical collection of research works. Once made public, each version of a work is considered a permanent part of the scientific record and may not be removed.

If an author needs to update the article after announcement, they may replace or withdraw the article, which creates a new version. This increments the version portion of the arXiv identifier. An example article with multiple versions is [arXiv:1710.02185](https://arxiv.org/abs/1710.02185).

Making previous versions of submitted papers publicly available archives the historical record of research work. As such, it is a useful aid to peer review and verification of intellectual priority.

- [What does arXiv mean by versions?](#versions)
- [Citing versions](#citing)
- [What constitutes a version?](#makeup)
- [Situations when arXiv typically requires versioning](#versioning_required)
	- [Articles in stages of the publication process](#stages)
	- [Related works with various content](#related)
	- [Famous Proofs](#famous)
	- [Splitting or merging works](#split)
	- [Withdrawals](#withdraw)
	- [Translations or multiple languages of already posted articles](#translation)
	- [Living reviews, annual updates](#reviews)
	- [Comments and Reply to Comments](#comments)

<span id="versions"></span>
## What does arXiv mean by versions?

All submissions receive a "date stamp", recorded as the time the submitter clicks "Submit article" at the end of the submission process. Once a submission is made public, it receives a permanent  [arXiv identifier](arxiv_identifier). Any replacement or withdrawal of that article generates a new version. This will increment its version number by one, with the most recent version always being displayed, even when the Abstract page is viewed without a version number at the end, such as the above example, https://arxiv.org/abs/1710.02185. 

<span id="citing"></span>
## Citing versions

Authors can cite each version with the full identifier that includes the version number. arXiv:YYMM.NNNNNvX

Authors can also use the Comments metadata to describe the different versions.

Ex:
> For the longer conference version see: arXiv:YYMM.NNNNNvv1. For the shortened summary see arXiv:YYMM.NNNNNvv2, for the journal version that includes extended data in the appendix see arXiv:YYMM.NNNNNv3

Please see the [references and citations help page](./faq/references) for details on citing works in arXiv.

<span id="makeup"></span>
## What constitutes a version?

A version will be created once a [replacement](replace) or
[withdrawal](withdraw) submission is made public. The _Submission history_ section of the Abstract page indicates the version number being viewed, as well as all available versions.

Replacements will contain the full text of the article. Withdrawals will display the reason for withdrawal entered as a comment, without any content download options for that version.

<span id="versioning_required"></span>
## Situations when arXiv typically requires versioning

Below are cases where arXiv authors are asked to version their work under a single arXiv identifier rather than submit related works as new arXiv identifier.

<span id="stages"></span>
### Articles in stages of the publication process

A version in many people’s minds represents various stages along publication status:

- Submitted version
- Revised version
- Accepted version
- Published version
  - Includes journal, conferences or other venues, even if each has their own version of record, DOI, and citation.

Note that during these stages a paper may have changes to the Title as well as to the Author list that are different in each version. These changes can be noted in the metadata.

<span id="related"></span> 
### Related works with various content

Versions in arXiv may also represent a set of related works that includes various content types. There can be versions of the work that include:

- Supplemental content (appendix, data, videos, code)
- Errata, either appended or corrected within the text
- Expanded versions
- Short or condensed versions for different reader groups
- Full version
 
### Other cases

<span id="famous"></span> 
#### Famous proofs

<span id="split"></span>
Versions in arXiv are also used in cases of an author making various attempts to work through a famous proof, even if the content of the work changes entirely between attempts. Authors who attempt multiple famous proofs may also be asked by moderators to submit the different theorems as versions of an existing arXiv identifier.
 
#### Splitting or Merging works

*Splitting* - A long work that is posted on arXiv may be split into two or more shorter works. In arXiv the current practice is to replace the previous long version with one of the new shorter works. Then the other shorter works can be posted as new arXiv papers with a new arXiv identifier.

*Merging* - Two or more short works that are posted on arXiv may be merged into a longer work. In arXiv the current practice is to replace one of the existing short works with the longer work. Then the other short work is withdrawn with a note that it has been superceded by the longer arXiv paper. The arXiv identifier of the longer paper is included in the note so that readers can link between the works.

*Similarity* - Moderators may ask authors to combine similar submissions into a single submission or into multiple versions of an existing arXiv identifier. This may be the case even if there is not significant verbatim text overlap, but the concepts and results of the work are closely related and the moderators decide that combining the works would benefit the readers.

<span id="withdraw"></span>
### Withdrawals

A withdrawal creates a new version of an arXiv work that contains no link to the full text. Previous versions are still accessible in the version history. More information see the [Withdrawal help page](withdraw).
 
<span id="translation"></span>
### Translations or multiple languages of already posted articles

A translation of an already posted article should be a version of the existing article. That new version can be just the text in translation or can include the full text for both languages. We do not allow multiple new arXiv identifiers for the same work displayed in various languages. The different language versions can be cited by using the version number under the same arXiv identifier.

For more information please see the help page for [submissions that are not in English](./faq/multilang)

<span id="reviews"></span> 
### Living reviews, annual updates

This type of content has information regularly added to keep it current and relevant. Even if these are of interest to the community as updates, they will only appear as versions of the original submission that may have been posted several years ago. 

<span id="comments"></span>
### Comments and Reply to Comments
arXiv will assign one arXiv identifier per "Comment" and per “Reply to Comment”. After that, further discussion must be done through replacements, creating versions of the original Comment or Reply.



 
