Accessibility at arXiv
======================

<style>
blockquote {
  border-left: 0;
  -webkit-box-shadow: 0px 3px 8px 0px rgba(0,0,0,0.12);
  -moz-box-shadow: 0px 3px 8px 0px rgba(0,0,0,0.12);
  box-shadow: 0px 3px 8px 0px rgba(0,0,0,0.12);
  padding:1em;
  margin-bottom:1.5em;
}
@media (min-width: 576px) {
  blockquote {
    padding: 2em;
  }
}
</style>

arXiv is committed to creating an accessible experience for all users. Below is our thinking behind this commitment and our roadmap for reaching and sustainably maintaining an accessible platform for the entire arXiv community.

## Table of contents

- [Important Terms](#terms)
- [Accessible arXiv](#business-case)
- [Roadmap to Accessibility](#roadmap)
- [How the arXiv community can help](#help)

<span id="terms"></span>
## Important terms

**Accessibility** = The practice of making a website functional for as many people as possible, including those using assistive technologies.

**ADA** = The Americans with Disabilities Act of 1990 is established federal law. It was written two years before the first website was launched and lacks specific digital guidelines, but the Supreme Court and the Department of Justice have confirmed that the ADA applies to the websites of &quot;covered entities&quot; such as Cornell University and arXiv.

**WCAG** = The Web Content Accessibility Guidelines are developed and maintained by the W3C, who also develop international web standards for HTML, CSS, and more. The WCAG, while not law, are the most widely recognized set of guidelines to address web access for people with disabilities, and WCAG level 2.0 compliance is mandated by Cornell University.

<span id="business-case"></span>
## Accessible arXiv

The arXiv community is diverse in every way and includes users with visual or other impairments, those who use assistive technology, and many other factors that can affect one's ability navigate the internet. Maintaining, expanding, and improving access for all users is our prime directive and must necessarily include accessibility.

The reasons for prioritizing accessibility are vast but below are the top ten we have identified for our platform and users:

1. arXiv's body of research papers is free and open to everyone from all over the world. A fully accessible website actively demonstrates arXiv's commitment to open access knowledge.
2. A commitment to accessibility will positively reflect on and strengthen arXiv's reputation over the long term and puts arXiv on the right side of history.
3. Accessible design offers clear and direct benefits to arXiv's extremely diverse and international user base. Accessible design is by its nature flexible, allowing content to faithfully render across a broad spectrum of devices, platforms, assistive technologies, operating systems, and bandwidths. We dont know what the future holds in terms of technology and device proliferation but maintaining accessible and standards compliant code will natively communicate with assistive technologies in a reliable and predictable manner over the long-term.
4. Accessible websites, through their emphasis on core content and meaning and rejection of superfluous and bandwidth-hogging padding, greatly benefit those with a slow internet connection or limited bandwidth.
5. The number of people with disabilities is large and growing. At least one billion people – 15% of the world’s population – have a recognized disability ([WHO global report](https://apps.who.int/iris/bitstream/handle/10665/44575/9789240685215_eng.pdf)). In the USA it's one in four adults ([CDC report](https://www.cdc.gov/media/releases/2018/p0816-disability.html)) and rising ([2018 DHS national report](https://disabilitycompendium.org/sites/default/files/user-uploads/2018_Compendium_Accessible_AbobeReaderFriendly.pdf)). In addition there are many more who do not formally identify as having a disability but have permanent, temporary, or situational impairments that affect one's ability to fully interact with many web interfaces. Some examples are visual impairments (blind, requiring magnification, screen glare, and more), mobility impairments (physical injuries, paralysis, and more), and cognitive and learning disabilities (requiring additional time, use of highlighting tools, and more). Providing open access to arXiv for all users includes deploying and maintaining an accessible codebase that is flexible and communicates reliably with assistive technologies.
6. Moderators and administrators are a critical part of arXiv's longevity and success. To ensure arXiv is open to all qualified moderators and administrators the interfaces that they use must be accessible.
7. arXiv's user base is international and accessibility laws in countries besides the USA will become increasingly relevant and urgent in the future. Compliance with existing guidelines and a firm commitment to clean semantic markup will limit risk for arXiv and provide the best foundation for future accessibility compliance.
8. arXiv has an established history of being in compliance with international HTML standards. Current semantic HTML5 standards are the next logical step in maintaining a compliant codebase, and are closely linked to accessibility.
9. Studies have shown that an [accessibility-focused development mindset leads to more innovation](https://habengirma.com/2017/09/13/people-with-disabilities-drive-innovation/) and higher levels of satisfaction for all users. When we shift our thinking away from the minimum legal compliance to focus instead on the opportunity and creative challenge of building better experiences for everyone, we create a more sustainable, user experience-oriented approach to development. Accessible thinking - which emphasizes clarity of content and meaning - has far-reaching positive impacts on the overall user experience.
10. Last but not least accessibility is not just a great business practice and the right thing to do, it is a legal requirement and Cornell University policy.

<span id="roadmap"></span>
## Roadmap to accessibility

We are currently making significant strides to improve access for those using assistive technologies on arXiv's classic codebase, while the new arXiv NG platform is "born accessible"&mdash;built with accessibility in mind from the ground up. Deploying arXiv NG is our top accessibility goal. Accessible browsing is the initial priority of the NG platform, and accessible moderator and administrative interfaces will follow. In addition another high priority goal at arXiv is to assist users in making their research content as accessible as possible upon submittal.

> “Cornell University is committed to providing an environment in which all people have an equal opportunity to participate in the university’s programs, activities and services.”
>
> _Shannon Osborn, assistant director of Cornell IT_

<span id="help"></span>
## How the arXiv community can help

A fully accessible arXiv is important, meaningful, and ambitious. Significant development resources and user testing are needed to reach our targets and the arXiv community may wish to help in the following ways:

- Making user uploaded research accessible, including TeX, is an ambitious and exciting goal that benefits users of assistive technology, mobile devices, those on slow internet connections, and translation services. Learn more about how you or your team can contribute development time to making arXiv TeX research papers accessible by emailing nextgen@arxiv.org.
- [Donate](https://arxiv.org/about/give) and support creation of an accessible arXiv.
- Additional opportunities for contributing to cutting edge projects are coming soon.
- Join the arXiv usability email list where opportunities to participate in accessibility testing are announced. Send an email message to arxiv-usability-testing-l-request@cornell.edu. In the subject type the single word: join. Leave the body of the message blank.
