# Member Advisory Board (MAB) Bylaws

The arXiv Bylaws were established in 2012 and may be amended, or new articles adopted, by the consensual agreement of the Board members.

## Current composition of MAB: Member Advisory Board

## 1. Member Advisory Board

1.1 Cornell University (CU) holds the overall responsibility for arXiv’s operation and development, with strategic and operational guidance from its Member Advisory Board (MAB) and its Scientific Advisory Board (SAB).

1.2 The arXiv principles delineate the respective roles of CU, SAB, and MAB.  See the arXiv [Governance Model](/about/governance) for a summary of each group's role.

1.3 Representation on MAB is reserved for libraries, research institutions, laboratories, and foundations that are members of arXiv and contribute to the financial support of the service (“Contributing Organizations”).

1.4 MAB is elected from arXiv’s membership and serves as a consultative body.

## 2. MAB Membership

2.1   Board Composition

2.1.1   MAB will have 13 voting members in three categories:

1) High-Contributing Organizations: Up to five voting members from Contributing Organizations that are preexisting consortia or national organizations and contribute 5% or more of arXiv’s annual income generated by member fees (set at $15,000 per year for 2013).
2) Contributing Organizations: At least seven voting members from other Contributing Organizations. The exact number of members depends on how many members from High-Contributing Organizations are elected.
3) One voting member from the Simons Foundation.

2.1.2   MAB will have five non-voting ex officio members in three categories:

1) The arXiv Program Director & Scientific Director.
2) Other leads from the CU arXiv team as appointed by Cornell’s University Librarian. The role of these members is to provide information and participate in Board discussions.
3) Two SAB representatives. The SAB and MAB operate in parallel, complementing each other and providing essential input for CU. To this end, the SAB appoints two members to serve as non-voting ex officio members of MAB; MAB appoints two members to serve as non-voting ex officio members of the SAB.

2.1.3 Board Officers

a)  Chair. The presiding officer of the MAB annual meeting is the arXiv Program Director.

b)  Other Officers. The Board may elect other officers as it deems necessary.

2.2 Member Qualifications

Each voting member of MAB will be an employee or an officer of a Contributing or High-Contributing Organization. No Contributing or High-Contributing Organization may be represented by more than one candidate for election to the Board in any given election or have two representatives at the same time on the Board.

2.3 Term of Office

2.3.1 Elected members of MAB will serve staggered four-year terms. Board members will be divided into two types of approximately equal size. The first MAB appointments during December 2012 will include seven voting members with six-year appointments and six voting members with four-year appointments.

2.3.2 No Board member representing Contributing or High-Contributing Organizations may serve more than one consecutive four-year term.

2.4 Powers and Duties

a) Chair. The Chair shall preside at all meetings of the Board to exercise general charge and supervision of the affairs of the MAB. The Chair shall see that all notices are duly given in accordance with the provisions of these Bylaws. The Chair shall facilitate open and inclusive discussion and decision-making and shall attempt to state clearly the “sense of the Board” when he or she determines that all Voting Board members are generally united in their judgment (in mutual concordance). The Chair shall perform such other duties as may be assigned by the Board.

b) Other Officers. Other officers elected by the Board shall have the authority prescribed to them by the Board.

## 3. MAB Operation

3.1 MAB represents participating institutions’ interests and advises CU on issues related to repository management and development, standards implementation, interoperability, development priorities, business planning, and outreach and advocacy. MAB also reviews and comments on arXiv budgets proposed by CU. For agenda items that require decisions, MAB will review and comment on proposals submitted by CU and may request additional information in support of their deliberations. MAB members can propose agenda items for discussion on topics within the scope of the group’s role. Some topics will require open discussion, and some matters with action items will necessitate decision-making.

3.2 A quorum requires the participation of a minimum eight voting Board members out of 13 (not including ex officio members).

3.3 When the Board considers any matter that requires a decision, the opinion of any Board member who wishes to express an opinion will be considered by the Board. As deemed useful and needed, Roberts’ Rules will be used in running meetings, moderating discussions, and approving decisions.

3.4 If the Board cannot agree on a decision, either the previous policy remains unchanged or no decision will be reached on the new business. Depending on the urgency of the matter, CU reserves the right to make a decision or leave the issue unsolved to be reconsidered in a future Board meeting. If there is a deadlock, either within MAB or in deliberations between MAB and the SAB, Cornell’s University Librarian bears responsibility for dispute resolution.

3.5 The Board will have authority to adopt policies and procedures governing Board activities. The Board may form subcommittees as needed and delegate to committees such powers as it deems fit, as long as those powers do not impinge on the rights reserved to CU or to any other members.

3.6 With regard to MAB and SAB communication, Board agendas and discussion outcomes will be shared with the SAB for their review and comments. The SAB representatives in MAB will act as liaisons and may seek input from their colleagues as needed prior to or after the Board deliberations.

## 4. MAB Meetings

4.1 Meeting Frequency

4.1.1 Meeting dates, times, and places will be designated by the Board’s Chair. The frequency and duration of meetings will be based on agenda items and their urgency.

4.1.2 There will be an Annual Meeting of the Board (ideally full-day and in-person), supplemented with regular update conference calls as needed (maximum two hours in duration).

4.1.3 Special meetings of the Board may be called at any time by the Chair or by a majority of voting Board members.

4.1.4 For board members who need assistance with their travel expenses to attend the in-person meetings, Cornell will provide $1,000 per person for U.S. participants and $1,500 for the oversees participants (assuming the meeting will be held in the U.S.).

4.2 Meeting Attendance

4.2.1 Any Board member who cannot participate in an in-person meeting may participate remotely via conference phone or web conferencing.

4.2.2 Depending on the nature of agenda items, deliberations — including reaching a consensus — can be carried out on the Board’s mailing list.

4.2.3  A Board member who fails to attend or fails to have a designated alternate attend three consecutive regularly scheduled Board meetings may be deemed by the consensual agreement of the Board to have resigned. The resulting vacancy may be filled in accordance with the provisions of 4.3.

4.2.4 A quorum is required for the transaction of business at any meeting of the Board (minimum eight Board members, not including ex officio members).

4.2.5 The Chair will preside at all meetings of the Board and will exercise general charge and supervision of MAB’s affairs. The Chair will facilitate open and inclusive discussion and decision-making.

4.2.6 CU will assign a staff member as Secretary to take notes during meetings and prepare meeting minutes. MAB members will review and approve the minutes. The Board agendas and discussion outcomes will be shared with the SAB for their review and comments. A synopsis of the meeting outcomes will be shared with the arXiv members.

4.3 Designating Alternates: If an MAB member is unable to attend a meeting, he or she may designate an alternate to act as a Board member. The alternate must be an employee or officer of a Contributing or High-Contributing Organization. An alternate may attend Board meetings and will be deemed a member of the Board for all purposes for the duration of the designation.

## 5. Committees

5.1  Elections Committee

5.1.1 The arXiv Program Director will initially appoint an Elections Committee of between three and five representatives from Contributing Organizations. The purpose of the first Elections Committee is to oversee the initial elections process.

5.1.2 Every two years after the initial election, the MAB Chair will submit for the Board’s approval a list of members to serve on the Election Committee. This list will contain no less than three and no more than five individuals and representatives from Contributing Organizations that do not currently have a representative serving on the Board.

5.1.3 The Elections Committee will determine the voting process, gather nominations, review the candidates proposed by the member institutions, and oversee voting.

5.1.4  Elections Committee members will serve for one election term or until their successors have been appointed.

5.2 Other Committees and Task Forces

5.2.1 The Board may create and appoint members to such other committees and task forces as the Board deems appropriate. Such committees and task forces will have the powers and duties designated by the Board, and they will give advice and make non-binding recommendations to the Board.

5.2.3 Each committee will consist of at least one Board member and will operate for the term designated by the Board.

5.3 Vacancies and Rules: The Board Chair may fill vacancies on committees. Each committee and task force may adopt rules for its meetings that are consistent with these Bylaws or with any rules adopted by the Board.

## 6. MAB Member Election

6.1 Board members representing Contributing Organizations and High-Contributing Organizations will be selected through an election by a majority vote of the member organizations.

6.2 Members will be elected from the candidates proposed by the Elections Committee or recommended in writing by any Contributing or High-Contributing Organizations, provided that such written nominations are accompanied by the consent of the nominee and submitted to the Board at least 30 days prior to the Annual Meeting of the Board. Submitted nominations must include a statement about the qualifications of a candidate.

6.3 Voting for representatives to MAB is open to all eligible member institutions, each of which shall have one vote for their category of candidates.

6.4 If an election is being held for filling High-Contributing Organizations seats and if there are more than five candidates, members in the High-Contributing Organizations category have two voting options:

They may delegate their representation to a consortium or other proxy, with the voting representation of such proxies being equal to the number of members represented.
A High-Contributing Organization may opt to ask each member cast a vote during an election. This process needs to be coordinated by the consortia liaison and each member organization will have one vote.

## 7. Resignation, Removal, or Replacement of a Board Member

7.1 Any Board member or designated alternate may resign at any time by giving written notice to the Board. If any Board member or designated alternate ceases to be employed by or affiliated with the Contributing or High-Contributing Organization that he or she represented at the time of his or her election, that member will be deemed to have resigned from the Board. The Board vacancy created will be filled in accordance with the provisions of Clause 7.2, below. If the Contributing or High-Contributing Organization that a Board member represents ceases to be a member of arXiv, then that Board member will be deemed to have resigned from the Board, and the Board vacancy created will be filled in accordance with the provisions of Clause 7.3, below.

7.2 In the event of a deemed resignation, the Contributing or High-Contributing Organization that was represented by the resigning Board member will have the right to designate a successor to serve the remainder of the resigning Board member’s term. The Contributing or High-Contributing Organization may decline to name a successor, in which case the vacancy will be filled in accordance with the provisions of Clause 7.3.

7.3 A vacancy on the Board not filled in accordance with the procedures for a deemed resignation (Clause 7.2) may be filled by the consensual agreement of the Board at any meeting where a quorum is present. A Board member elected to fill a vacancy will be eligible to serve full, consecutive four-year terms.

## 8. Annual Fees

To be considered a Contributing or High-Contributing Organization, organizations must pay annual membership fees by July 1 of each calendar year. Budgetary inability to meet a single year’s membership fees will not terminate membership, provided that the member commits to making up the deficit within an agreed upon period not to exceed two years.

## 9. Amendments

Within the confinement of arXiv principles, these Bylaws may be amended, or new articles adopted, by the consent of two-thirds of the Voting members of the Board then in office. Depending on the assessment of the arXiv Program Director, the changes may need to be reviewed by the SAB, Cornell’s University Librarian, or the Cornell Counsel.   

### History of Revisions

_Revision on August 4, 2015_ The initial idea of 2-4 year staggering terms did not take into consideration the time needed for the group to come together as a team around a common set of goals and identify productive ways of contributing to arXiv.  Given the fact that MAB is a new governance unit, we feel that the first couple of years were spent in clarifying and better formulating the actual role of MAB in arXiv's governance. MAB unanimously decided to modify 2.3.1: Elected members of MAB will serve staggered four-year terms. Board members will be divided into two types of approximately equal size. The first MAB appointments during December 2012 will include seven voting members with six-year four-year appointments and six voting members with four-year two-year appointments.

_Revision on May 26, 2016_ Chair position added as Jim Mullins, MAB Member and Dean of Libraries, Purdue University Libraries volunteered to assume the role, which was approved by MAB as a pilot implementation.

_Revision on December 4, 2017_ References to Chair have been modified as a decision was made during the 2017 MAB Annual Meeting for the arXiv Program Director to play the role, as originally included in the Bylaws.

_Revision on February 26, 2018_ Section 9. Amendments, corrected to parallel SAB (by the two-thirds of Voting Members, not by the consensual agreement of all Board members then in office.).

_Revision on April 13, 2018_ 2.1.2   MAB will have five non-voting ex officio members in three categories: The arXiv Program Director & Scientific Director (Scientific Director added).
