2011 Institutional arXiv Usage Data
===================================

The following table is a compilation of arXiv downloads for calendar
year 2011 for the 200 heaviest user institutions. See also [arXiv
Support](../support).

**Caveats:** While we have taken considerable effort to extract reliable
download data representing unique full-text downloads by real users,
there are many factors which affect accuracy. These factors include: 1)
the data is from the main arXiv site and the arXiv mirrors, though some
mirror data is incomplete; 2) we have counted downloads according to the
COUNTER algorithm which excludes rapid repeat downloads (this is a
change from the 2009 statistics, which counted one download per host per
month, and increases the number of downloads counted); 3) we have
attempted to identify and remove robot or automated downloads from the
count (false positives lead to undercounting, failing to identify robots
leads to overcounting); and 4) we include here only downloads that
appear to be from an institution based on the DNS name of the client for
patterns that we recognize (we have significantly increased the number
institutions recognized which means that some institutions appear in the
top 200 list that were erroneously omitted from the 2009 statistics. A
large fraction of downloads come from commercial ISPs which are not
included. Clients with host names that don't resolve or off-campus
accesses will lead to undercounting, failure to recognize institutional
domain names will exclude those institutions and undercount the total
institutional downloads). We have identified 12.4 million downloads from
institutional domain names out of a total of 50 million downloads in
2011.

<table>
<thead>
<tr class="header">
<th>Rank</th>
<th>Institutional domain</th>
<th>Percentage of total<br />
institutional downloads</th>
<th>Number of article downloads</th>
</tr>
</thead>
<tbody>
<tr class="odd">
<td>1</td>
<td>mpg.de(*)</td>
<td>2.19%</td>
<td>271016</td>
</tr>
<tr class="even">
<td>2</td>
<td>cern.ch</td>
<td>1.93%</td>
<td>239494</td>
</tr>
<tr class="odd">
<td>3</td>
<td>u-tokyo.ac.jp</td>
<td>1.35%</td>
<td>167057</td>
</tr>
<tr class="even">
<td>4</td>
<td>cam.ac.uk</td>
<td>1.35%</td>
<td>166994</td>
</tr>
<tr class="odd">
<td>5</td>
<td>harvard.edu</td>
<td>1.16%</td>
<td>143299</td>
</tr>
<tr class="even">
<td>6</td>
<td>ox.ac.uk</td>
<td>1.08%</td>
<td>133597</td>
</tr>
<tr class="odd">
<td>7</td>
<td>kyoto-u.ac.jp</td>
<td>0.99%</td>
<td>122816</td>
</tr>
<tr class="even">
<td>8</td>
<td>princeton.edu</td>
<td>0.87%</td>
<td>108141</td>
</tr>
<tr class="odd">
<td>9</td>
<td>berkeley.edu</td>
<td>0.84%</td>
<td>103738</td>
</tr>
<tr class="even">
<td>10</td>
<td>in2p3.fr</td>
<td>0.83%</td>
<td>102605</td>
</tr>
<tr class="odd">
<td>11</td>
<td>ethz.ch</td>
<td>0.79%</td>
<td>98095</td>
</tr>
<tr class="even">
<td>12</td>
<td>mit.edu</td>
<td>0.77%</td>
<td>94857</td>
</tr>
<tr class="odd">
<td>13</td>
<td>caltech.edu</td>
<td>0.76%</td>
<td>94680</td>
</tr>
<tr class="even">
<td>14</td>
<td>ucsb.edu</td>
<td>0.70%</td>
<td>86876</td>
</tr>
<tr class="odd">
<td>15</td>
<td>desy.de</td>
<td>0.67%</td>
<td>83277</td>
</tr>
<tr class="even">
<td>16</td>
<td>uni-bonn.de</td>
<td>0.65%</td>
<td>80004</td>
</tr>
<tr class="odd">
<td>17</td>
<td>bnl.gov</td>
<td>0.61%</td>
<td>76026</td>
</tr>
<tr class="even">
<td>18</td>
<td>columbia.edu</td>
<td>0.61%</td>
<td>75283</td>
</tr>
<tr class="odd">
<td>19</td>
<td>ic.ac.uk</td>
<td>0.58%</td>
<td>71943</td>
</tr>
<tr class="even">
<td>20</td>
<td>umich.edu</td>
<td>0.58%</td>
<td>71405</td>
</tr>
<tr class="odd">
<td>21</td>
<td>inaf.it(*)</td>
<td>0.57%</td>
<td>70176</td>
</tr>
<tr class="even">
<td>22</td>
<td>cea.fr</td>
<td>0.56%</td>
<td>68750</td>
</tr>
<tr class="odd">
<td>23</td>
<td>uni-heidelberg.de</td>
<td>0.55%</td>
<td>68626</td>
</tr>
<tr class="even">
<td>24</td>
<td>washington.edu</td>
<td>0.55%</td>
<td>68415</td>
</tr>
<tr class="odd">
<td>25</td>
<td>fnal.gov</td>
<td>0.54%</td>
<td>67289</td>
</tr>
<tr class="even">
<td>26</td>
<td>sissa.it</td>
<td>0.53%</td>
<td>65788</td>
</tr>
<tr class="odd">
<td>27</td>
<td>utexas.edu</td>
<td>0.53%</td>
<td>65234</td>
</tr>
<tr class="even">
<td>28</td>
<td>epfl.ch</td>
<td>0.52%</td>
<td>64977</td>
</tr>
<tr class="odd">
<td>29</td>
<td>tsinghua.edu.cn</td>
<td>0.52%</td>
<td>64580</td>
</tr>
<tr class="even">
<td>30</td>
<td>dur.ac.uk</td>
<td>0.51%</td>
<td>62514</td>
</tr>
<tr class="odd">
<td>31</td>
<td>stanford.edu</td>
<td>0.50%</td>
<td>62198</td>
</tr>
<tr class="even">
<td>32</td>
<td>wisc.edu</td>
<td>0.50%</td>
<td>61398</td>
</tr>
<tr class="odd">
<td>33</td>
<td>perimeterinstitute.ca</td>
<td>0.48%</td>
<td>59733</td>
</tr>
<tr class="even">
<td>34</td>
<td>stonybrook.edu(*)</td>
<td>0.48%</td>
<td>59593</td>
</tr>
<tr class="odd">
<td>35</td>
<td>ohio-state.edu</td>
<td>0.48%</td>
<td>58839</td>
</tr>
<tr class="even">
<td>36</td>
<td>uchicago.edu</td>
<td>0.47%</td>
<td>58616</td>
</tr>
<tr class="odd">
<td>37</td>
<td>nus.edu.sg</td>
<td>0.47%</td>
<td>57681</td>
</tr>
<tr class="even">
<td>38</td>
<td>cornell.edu</td>
<td>0.46%</td>
<td>57542</td>
</tr>
<tr class="odd">
<td>39</td>
<td>ihep.ac.cn</td>
<td>0.46%</td>
<td>56963</td>
</tr>
<tr class="even">
<td>40</td>
<td>kek.jp</td>
<td>0.44%</td>
<td>54619</td>
</tr>
<tr class="odd">
<td>41</td>
<td>colorado.edu</td>
<td>0.43%</td>
<td>53620</td>
</tr>
<tr class="even">
<td>42</td>
<td>uv.es</td>
<td>0.43%</td>
<td>53258</td>
</tr>
<tr class="odd">
<td>43</td>
<td>univie.ac.at</td>
<td>0.42%</td>
<td>52362</td>
</tr>
<tr class="even">
<td>44</td>
<td>utoronto.ca</td>
<td>0.40%</td>
<td>49358</td>
</tr>
<tr class="odd">
<td>45</td>
<td>uwaterloo.ca</td>
<td>0.40%</td>
<td>48977</td>
</tr>
<tr class="even">
<td>46</td>
<td>ictp.it</td>
<td>0.39%</td>
<td>48787</td>
</tr>
<tr class="odd">
<td>47</td>
<td>osaka-u.ac.jp</td>
<td>0.39%</td>
<td>48476</td>
</tr>
<tr class="even">
<td>48</td>
<td>usp.br</td>
<td>0.39%</td>
<td>48054</td>
</tr>
<tr class="odd">
<td>49</td>
<td>umd.edu</td>
<td>0.38%</td>
<td>47348</td>
</tr>
<tr class="even">
<td>50</td>
<td>nagoya-u.ac.jp</td>
<td>0.38%</td>
<td>46847</td>
</tr>
<tr class="odd">
<td>51</td>
<td>uiuc.edu</td>
<td>0.38%</td>
<td>46719</td>
</tr>
<tr class="even">
<td>52</td>
<td>ucsd.edu</td>
<td>0.38%</td>
<td>46669</td>
</tr>
<tr class="odd">
<td>53</td>
<td>weizmann.ac.il</td>
<td>0.37%</td>
<td>45778</td>
</tr>
<tr class="even">
<td>54</td>
<td>jinr.ru</td>
<td>0.37%</td>
<td>45479</td>
</tr>
<tr class="odd">
<td>55</td>
<td>cmu.edu</td>
<td>0.37%</td>
<td>45381</td>
</tr>
<tr class="even">
<td>56</td>
<td>umn.edu</td>
<td>0.36%</td>
<td>44795</td>
</tr>
<tr class="odd">
<td>57</td>
<td>tamu.edu</td>
<td>0.36%</td>
<td>44548</td>
</tr>
<tr class="even">
<td>58</td>
<td>yale.edu</td>
<td>0.36%</td>
<td>44492</td>
</tr>
<tr class="odd">
<td>59</td>
<td>ens.fr</td>
<td>0.35%</td>
<td>43209</td>
</tr>
<tr class="even">
<td>60</td>
<td>ntu.edu.tw</td>
<td>0.35%</td>
<td>43165</td>
</tr>
<tr class="odd">
<td>61</td>
<td>psu.edu</td>
<td>0.34%</td>
<td>42394</td>
</tr>
<tr class="even">
<td>62</td>
<td>tohoku.ac.jp</td>
<td>0.34%</td>
<td>41906</td>
</tr>
<tr class="odd">
<td>63</td>
<td>ubc.ca</td>
<td>0.34%</td>
<td>41874</td>
</tr>
<tr class="even">
<td>64</td>
<td>jussieu.fr</td>
<td>0.34%</td>
<td>41535</td>
</tr>
<tr class="odd">
<td>65</td>
<td>lanl.gov</td>
<td>0.33%</td>
<td>41405</td>
</tr>
<tr class="even">
<td>66</td>
<td>u-psud.fr</td>
<td>0.33%</td>
<td>41233</td>
</tr>
<tr class="odd">
<td>67</td>
<td>uni-frankfurt.de</td>
<td>0.33%</td>
<td>41067</td>
</tr>
<tr class="even">
<td>68</td>
<td>slac.stanford.edu</td>
<td>0.33%</td>
<td>40882</td>
</tr>
<tr class="odd">
<td>69</td>
<td>unige.ch</td>
<td>0.33%</td>
<td>40551</td>
</tr>
<tr class="even">
<td>70</td>
<td>mcgill.ca</td>
<td>0.33%</td>
<td>40509</td>
</tr>
<tr class="odd">
<td>71</td>
<td>ucla.edu</td>
<td>0.32%</td>
<td>39865</td>
</tr>
<tr class="even">
<td>72</td>
<td>uni-mainz.de</td>
<td>0.32%</td>
<td>39845</td>
</tr>
<tr class="odd">
<td>73</td>
<td>uni-karlsruhe.de</td>
<td>0.32%</td>
<td>39318</td>
</tr>
<tr class="even">
<td>74</td>
<td>rutgers.edu</td>
<td>0.32%</td>
<td>39050</td>
</tr>
<tr class="odd">
<td>75</td>
<td>uci.edu</td>
<td>0.31%</td>
<td>38339</td>
</tr>
<tr class="even">
<td>76</td>
<td>csic.es</td>
<td>0.30%</td>
<td>37741</td>
</tr>
<tr class="odd">
<td>77</td>
<td>helsinki.fi</td>
<td>0.30%</td>
<td>37142</td>
</tr>
<tr class="even">
<td>78</td>
<td>nasa.gov</td>
<td>0.30%</td>
<td>36805</td>
</tr>
<tr class="odd">
<td>79</td>
<td>upenn.edu</td>
<td>0.30%</td>
<td>36701</td>
</tr>
<tr class="even">
<td>80</td>
<td>nyu.edu</td>
<td>0.29%</td>
<td>35986</td>
</tr>
<tr class="odd">
<td>81</td>
<td>uni-hamburg.de</td>
<td>0.29%</td>
<td>35967</td>
</tr>
<tr class="even">
<td>82</td>
<td>uni-wuerzburg.de</td>
<td>0.29%</td>
<td>35356</td>
</tr>
<tr class="odd">
<td>83</td>
<td>uva.nl</td>
<td>0.28%</td>
<td>35027</td>
</tr>
<tr class="even">
<td>84</td>
<td>uni-regensburg.de</td>
<td>0.28%</td>
<td>34102</td>
</tr>
<tr class="odd">
<td>85</td>
<td>rwth-aachen.de</td>
<td>0.27%</td>
<td>33911</td>
</tr>
<tr class="even">
<td>86</td>
<td>ed.ac.uk</td>
<td>0.27%</td>
<td>33778</td>
</tr>
<tr class="odd">
<td>87</td>
<td>tau.ac.il</td>
<td>0.27%</td>
<td>33757</td>
</tr>
<tr class="even">
<td>88</td>
<td>leidenuniv.nl</td>
<td>0.27%</td>
<td>33601</td>
</tr>
<tr class="odd">
<td>89</td>
<td>hu-berlin.de</td>
<td>0.27%</td>
<td>33224</td>
</tr>
<tr class="even">
<td>90</td>
<td>ub.es</td>
<td>0.26%</td>
<td>32487</td>
</tr>
<tr class="odd">
<td>91</td>
<td>uni-hannover.de</td>
<td>0.26%</td>
<td>32193</td>
</tr>
<tr class="even">
<td>92</td>
<td>imsc.res.in</td>
<td>0.26%</td>
<td>32162</td>
</tr>
<tr class="odd">
<td>93</td>
<td>purdue.edu</td>
<td>0.26%</td>
<td>32061</td>
</tr>
<tr class="even">
<td>94</td>
<td>huji.ac.il</td>
<td>0.26%</td>
<td>31970</td>
</tr>
<tr class="odd">
<td>95</td>
<td>utl.pt</td>
<td>0.26%</td>
<td>31710</td>
</tr>
<tr class="even">
<td>96</td>
<td>ulb.ac.be</td>
<td>0.26%</td>
<td>31646</td>
</tr>
<tr class="odd">
<td>97</td>
<td>nottingham.ac.uk</td>
<td>0.26%</td>
<td>31645</td>
</tr>
<tr class="even">
<td>98</td>
<td>northwestern.edu</td>
<td>0.25%</td>
<td>31063</td>
</tr>
<tr class="odd">
<td>99</td>
<td>gatech.edu</td>
<td>0.25%</td>
<td>30880</td>
</tr>
<tr class="even">
<td>100</td>
<td>arizona.edu</td>
<td>0.25%</td>
<td>30634</td>
</tr>
<tr class="odd">
<td>101</td>
<td>pd.infn.it</td>
<td>0.25%</td>
<td>30380</td>
</tr>
<tr class="even">
<td>102</td>
<td>soton.ac.uk</td>
<td>0.24%</td>
<td>30234</td>
</tr>
<tr class="odd">
<td>103</td>
<td>ujf-grenoble.fr</td>
<td>0.24%</td>
<td>29704</td>
</tr>
<tr class="even">
<td>104</td>
<td>uu.nl</td>
<td>0.24%</td>
<td>29684</td>
</tr>
<tr class="odd">
<td>105</td>
<td>usyd.edu.au</td>
<td>0.24%</td>
<td>29509</td>
</tr>
<tr class="even">
<td>106</td>
<td>riken.jp(*)</td>
<td>0.24%</td>
<td>29318</td>
</tr>
<tr class="odd">
<td>107</td>
<td>ucm.es</td>
<td>0.24%</td>
<td>29306</td>
</tr>
<tr class="even">
<td>108</td>
<td>ucl.ac.uk</td>
<td>0.24%</td>
<td>29116</td>
</tr>
<tr class="odd">
<td>109</td>
<td>unimelb.edu.au</td>
<td>0.23%</td>
<td>29049</td>
</tr>
<tr class="even">
<td>110</td>
<td>tuwien.ac.at</td>
<td>0.23%</td>
<td>28989</td>
</tr>
<tr class="odd">
<td>111</td>
<td>chalmers.se</td>
<td>0.23%</td>
<td>28933</td>
</tr>
<tr class="even">
<td>112</td>
<td>uni-bielefeld.de</td>
<td>0.23%</td>
<td>28348</td>
</tr>
<tr class="odd">
<td>113</td>
<td>obspm.fr</td>
<td>0.22%</td>
<td>27665</td>
</tr>
<tr class="even">
<td>114</td>
<td>bris.ac.uk</td>
<td>0.22%</td>
<td>27613</td>
</tr>
<tr class="odd">
<td>115</td>
<td>uu.se</td>
<td>0.22%</td>
<td>27600</td>
</tr>
<tr class="even">
<td>116</td>
<td>cnrs.fr(*)</td>
<td>0.22%</td>
<td>27515</td>
</tr>
<tr class="odd">
<td>117</td>
<td>nctu.edu.tw</td>
<td>0.22%</td>
<td>27476</td>
</tr>
<tr class="even">
<td>118</td>
<td>uibk.ac.at</td>
<td>0.22%</td>
<td>27449</td>
</tr>
<tr class="odd">
<td>119</td>
<td>uzh.ch</td>
<td>0.22%</td>
<td>27215</td>
</tr>
<tr class="even">
<td>120</td>
<td>nbi.dk</td>
<td>0.22%</td>
<td>27157</td>
</tr>
<tr class="odd">
<td>121</td>
<td>uni-freiburg.de</td>
<td>0.22%</td>
<td>26984</td>
</tr>
<tr class="even">
<td>122</td>
<td>navy.mil</td>
<td>0.22%</td>
<td>26979</td>
</tr>
<tr class="odd">
<td>123</td>
<td>unam.mx</td>
<td>0.22%</td>
<td>26977</td>
</tr>
<tr class="even">
<td>124</td>
<td>rug.nl</td>
<td>0.21%</td>
<td>26389</td>
</tr>
<tr class="odd">
<td>125</td>
<td>jhu.edu</td>
<td>0.21%</td>
<td>26305</td>
</tr>
<tr class="even">
<td>126</td>
<td>lbl.gov</td>
<td>0.21%</td>
<td>26192</td>
</tr>
<tr class="odd">
<td>127</td>
<td>uni-koeln.de</td>
<td>0.21%</td>
<td>26185</td>
</tr>
<tr class="even">
<td>128</td>
<td>ufl.edu</td>
<td>0.21%</td>
<td>26016</td>
</tr>
<tr class="odd">
<td>129</td>
<td>uni-tuebingen.de</td>
<td>0.21%</td>
<td>25509</td>
</tr>
<tr class="even">
<td>130</td>
<td>kuleuven.be</td>
<td>0.21%</td>
<td>25499</td>
</tr>
<tr class="odd">
<td>131</td>
<td>sns.it</td>
<td>0.21%</td>
<td>25496</td>
</tr>
<tr class="even">
<td>132</td>
<td>bu.edu</td>
<td>0.20%</td>
<td>25272</td>
</tr>
<tr class="odd">
<td>133</td>
<td>roma1.infn.it</td>
<td>0.20%</td>
<td>24961</td>
</tr>
<tr class="even">
<td>134</td>
<td>nist.gov</td>
<td>0.20%</td>
<td>24914</td>
</tr>
<tr class="odd">
<td>135</td>
<td>indiana.edu</td>
<td>0.20%</td>
<td>24890</td>
</tr>
<tr class="even">
<td>136</td>
<td>hawaii.edu</td>
<td>0.20%</td>
<td>24869</td>
</tr>
<tr class="odd">
<td>137</td>
<td>cuhk.edu.hk</td>
<td>0.20%</td>
<td>24841</td>
</tr>
<tr class="even">
<td>138</td>
<td>upc.es</td>
<td>0.20%</td>
<td>24613</td>
</tr>
<tr class="odd">
<td>139</td>
<td>prl.res.in</td>
<td>0.19%</td>
<td>24132</td>
</tr>
<tr class="even">
<td>140</td>
<td>polytechnique.fr</td>
<td>0.19%</td>
<td>24050</td>
</tr>
<tr class="odd">
<td>141</td>
<td>titech.ac.jp</td>
<td>0.19%</td>
<td>23043</td>
</tr>
<tr class="even">
<td>142</td>
<td>uj.edu.pl</td>
<td>0.19%</td>
<td>22960</td>
</tr>
<tr class="odd">
<td>143</td>
<td>ku.dk</td>
<td>0.18%</td>
<td>22415</td>
</tr>
<tr class="even">
<td>144</td>
<td>duke.edu</td>
<td>0.18%</td>
<td>22354</td>
</tr>
<tr class="odd">
<td>145</td>
<td>tifr.res.in</td>
<td>0.18%</td>
<td>22245</td>
</tr>
<tr class="even">
<td>146</td>
<td>tu-darmstadt.de</td>
<td>0.18%</td>
<td>22052</td>
</tr>
<tr class="odd">
<td>147</td>
<td>uni-muenchen.de(*)</td>
<td>0.18%</td>
<td>21757</td>
</tr>
<tr class="even">
<td>148</td>
<td>postech.ac.kr</td>
<td>0.18%</td>
<td>21725</td>
</tr>
<tr class="odd">
<td>149</td>
<td>uq.edu.au</td>
<td>0.18%</td>
<td>21695</td>
</tr>
<tr class="even">
<td>150</td>
<td>uni-erlangen.de</td>
<td>0.17%</td>
<td>21578</td>
</tr>
<tr class="odd">
<td>151</td>
<td>uio.no</td>
<td>0.17%</td>
<td>21397</td>
</tr>
<tr class="even">
<td>152</td>
<td>qmul.ac.uk</td>
<td>0.17%</td>
<td>20944</td>
</tr>
<tr class="odd">
<td>153</td>
<td>kaist.ac.kr</td>
<td>0.17%</td>
<td>20835</td>
</tr>
<tr class="even">
<td>154</td>
<td>kth.se</td>
<td>0.17%</td>
<td>20652</td>
</tr>
<tr class="odd">
<td>155</td>
<td>gla.ac.uk</td>
<td>0.17%</td>
<td>20499</td>
</tr>
<tr class="even">
<td>156</td>
<td>au.dk</td>
<td>0.16%</td>
<td>20414</td>
</tr>
<tr class="odd">
<td>157</td>
<td>uni-jena.de</td>
<td>0.16%</td>
<td>20317</td>
</tr>
<tr class="even">
<td>158</td>
<td>fu-berlin.de</td>
<td>0.16%</td>
<td>20240</td>
</tr>
<tr class="odd">
<td>159</td>
<td>utah.edu</td>
<td>0.16%</td>
<td>20114</td>
</tr>
<tr class="even">
<td>160</td>
<td>ehu.es</td>
<td>0.16%</td>
<td>20063</td>
</tr>
<tr class="odd">
<td>161</td>
<td>univ-mrs.fr</td>
<td>0.16%</td>
<td>20048</td>
</tr>
<tr class="even">
<td>162</td>
<td>tkk.fi(*)</td>
<td>0.16%</td>
<td>20013</td>
</tr>
<tr class="odd">
<td>163</td>
<td>virginia.edu</td>
<td>0.16%</td>
<td>19875</td>
</tr>
<tr class="even">
<td>164</td>
<td>uni-bochum.de</td>
<td>0.16%</td>
<td>19763</td>
</tr>
<tr class="odd">
<td>165</td>
<td>unibas.ch</td>
<td>0.16%</td>
<td>19550</td>
</tr>
<tr class="even">
<td>166</td>
<td>anl.gov</td>
<td>0.16%</td>
<td>19467</td>
</tr>
<tr class="odd">
<td>167</td>
<td>msu.ru</td>
<td>0.16%</td>
<td>19386</td>
</tr>
<tr class="even">
<td>168</td>
<td>anu.edu.au</td>
<td>0.16%</td>
<td>19356</td>
</tr>
<tr class="odd">
<td>169</td>
<td>lancs.ac.uk</td>
<td>0.16%</td>
<td>19307</td>
</tr>
<tr class="even">
<td>170</td>
<td>ugent.be</td>
<td>0.16%</td>
<td>19297</td>
</tr>
<tr class="odd">
<td>171</td>
<td>tudelft.nl(*)</td>
<td>0.16%</td>
<td>19238</td>
</tr>
<tr class="even">
<td>172</td>
<td>iac.es</td>
<td>0.15%</td>
<td>19080</td>
</tr>
<tr class="odd">
<td>173</td>
<td>uam.es</td>
<td>0.15%</td>
<td>18797</td>
</tr>
<tr class="even">
<td>174</td>
<td>ntnu.no</td>
<td>0.15%</td>
<td>18730</td>
</tr>
<tr class="odd">
<td>175</td>
<td>msu.edu</td>
<td>0.15%</td>
<td>18711</td>
</tr>
<tr class="even">
<td>176</td>
<td>kfa-juelich.de</td>
<td>0.15%</td>
<td>18702</td>
</tr>
<tr class="odd">
<td>177</td>
<td>uct.ac.za</td>
<td>0.15%</td>
<td>18628</td>
</tr>
<tr class="even">
<td>178</td>
<td>fi.infn.it</td>
<td>0.15%</td>
<td>18587</td>
</tr>
<tr class="odd">
<td>179</td>
<td>ucdavis.edu</td>
<td>0.15%</td>
<td>18464</td>
</tr>
<tr class="even">
<td>180</td>
<td>tu-muenchen.de</td>
<td>0.15%</td>
<td>18459</td>
</tr>
<tr class="odd">
<td>181</td>
<td>uniroma1.it</td>
<td>0.15%</td>
<td>18388</td>
</tr>
<tr class="even">
<td>182</td>
<td>unibe.ch</td>
<td>0.15%</td>
<td>18348</td>
</tr>
<tr class="odd">
<td>183</td>
<td>ugr.es</td>
<td>0.15%</td>
<td>18345</td>
</tr>
<tr class="even">
<td>184</td>
<td>ualberta.ca</td>
<td>0.15%</td>
<td>18328</td>
</tr>
<tr class="odd">
<td>185</td>
<td>man.ac.uk</td>
<td>0.15%</td>
<td>18133</td>
</tr>
<tr class="even">
<td>186</td>
<td>susx.ac.uk</td>
<td>0.15%</td>
<td>18132</td>
</tr>
<tr class="odd">
<td>187</td>
<td>jyu.fi</td>
<td>0.15%</td>
<td>18042</td>
</tr>
<tr class="even">
<td>188</td>
<td>iastate.edu</td>
<td>0.14%</td>
<td>17934</td>
</tr>
<tr class="odd">
<td>189</td>
<td>ups-tlse.fr</td>
<td>0.14%</td>
<td>17864</td>
</tr>
<tr class="even">
<td>190</td>
<td>to.infn.it</td>
<td>0.14%</td>
<td>17758</td>
</tr>
<tr class="odd">
<td>191</td>
<td>kyushu-u.ac.jp</td>
<td>0.14%</td>
<td>17717</td>
</tr>
<tr class="even">
<td>192</td>
<td>hiroshima-u.ac.jp</td>
<td>0.14%</td>
<td>17445</td>
</tr>
<tr class="odd">
<td>193</td>
<td>ukzn.ac.za</td>
<td>0.14%</td>
<td>17413</td>
</tr>
<tr class="even">
<td>194</td>
<td>tu-berlin.de</td>
<td>0.14%</td>
<td>17283</td>
</tr>
<tr class="odd">
<td>195</td>
<td>eso.org</td>
<td>0.14%</td>
<td>17269</td>
</tr>
<tr class="even">
<td>196</td>
<td>pitt.edu</td>
<td>0.14%</td>
<td>17248</td>
</tr>
<tr class="odd">
<td>197</td>
<td>fuw.edu.pl</td>
<td>0.14%</td>
<td>17223</td>
</tr>
<tr class="even">
<td>198</td>
<td>usc.edu</td>
<td>0.14%</td>
<td>17176</td>
</tr>
<tr class="odd">
<td>199</td>
<td>kcl.ac.uk</td>
<td>0.14%</td>
<td>17078</td>
</tr>
<tr class="even">
<td>200</td>
<td>ens-lyon.fr</td>
<td>0.14%</td>
<td>17052</td>
</tr>
</tbody>
</table>

(\*) Some institutions' downloads come from multiple domains which have
been combined to report an aggregate number:

-   cnrs.fr includes downloads from cnrs-orleans.fr.
-   inaf.it includes downloads from astro.it.
-   mpg.de includes downloads from aei.mpg.de, bgc-jena.mpg.de,
    biochem.mpg.de, biophys.mpg.de, cbs.mpg.de, coll.mpg.de,
    cpfs.mpg.de, demogr.mpg.de, ds.mpg.de, econ.mpg.de, eva.mpg.de,
    fkf.mpg.de, harnackhaus-berlin.mpg.de, hll.mpg.de, ice.mpg.de,
    immunbio.mpg.de, ip.mpg.de, ipp-hgw.mpg.de, ipp.mpg.de, mis.mpg.de,
    molgen.mpg.de, mpa-garching.mpg.de, mpdl.mpg.de,
    mpe-garching.mpg.de, mpe.mpg.de, mpi-dortmund.mpg.de,
    mpi-fg-koeln.mpg.de, mpi-halle.mpg.de, mpi-hd.mpg.de,
    mpi-inf.mpg.de, mpi-magdeburg.mpg.de, mpi-muelheim.mpg.de,
    mpi-sb.mpg.de, mpi-stuttgart.mpg.de, mpi-sws.mpg.de, mpia-hd.mpg.de,
    mpib-berlin.mpg.de, mpibpc.mpg.de, mpie-duesseldorf.mpg.de,
    mpifr-bonn.mpg.de, mpih-frankfurt.mpg.de, mpiib-berlin.mpg.de,
    mpikg.mpg.de, mpim-bonn.mpg.de, mpimf-heidelberg.mpg.de,
    mpimp-golm.mpg.de, mpip-mainz.mpg.de, mpipks-dresden.mpg.de,
    mpipsykl.mpg.de, mpipz.mpg.de, mpisoc.mpg.de, mpiwg-berlin.mpg.de,
    mpl.mpg.de, mppmu.mpg.de, mpq.mpg.de, mps.mpg.de, mucam.mpg.de,
    neuro.mpg.de, nf.mpg.de, orn.mpg.de, rz-berlin.mpg.de, rzg.mpg.de,
    tuebingen.mpg.de, vw-alt.mpg.de, vw.mpg.de.
-   riken.jp includes downloads from riken.go.jp.
-   stonybrook.edu includes downloads from sunysb.edu.
-   tkk.fi includes downloads from hut.fi.
-   tudelft.nl includes downloads from tudelft.net.
-   uni-muenchen.de includes downloads from lmu.de.

Update history:  
2012-02-03 - Usage data for 2011 first posted.
