2012 Institutional arXiv Usage Data
===================================

The following table is a compilation of arXiv downloads for calendar
year 2012 for the 200 heaviest user institutions. See also [arXiv
Support](../support).

**Caveats:** While we have taken considerable effort to extract reliable
download data representing unique full-text downloads by real users,
there are many factors which affect accuracy. These factors include: 1)
the data is from the main arXiv site and the arXiv mirrors, though some
mirror data is incomplete; 2) we have counted downloads according to the
COUNTER algorithm which excludes rapid repeat downloads (this is a
change from the 2009 statistics, which counted one download per host per
month, and increases the number of downloads counted); 3) we have
attempted to identify and remove robot or automated downloads from the
count (false positives lead to undercounting, failing to identify robots
leads to overcounting); and 4) we include here only downloads that
appear to be from an institution based on the DNS name of the client for
patterns that we recognize (A large fraction of downloads come from
commercial ISPs which are not included. Clients with host names that
don't resolve or off-campus accesses will lead to undercounting, failure
to recognize institutional domain names will exclude those institutions
and undercount the total institutional downloads.) We have identified
13.8 million downloads from institutional domain names out of a total of
63.8 million downloads in 2012.

<table>
<thead>
<tr class="header">
<th>Rank</th>
<th>Institional domain</th>
<th>Percentage of total<br />
institutional downloads</th>
<th>Number of article downloads</th>
</tr>
</thead>
<tbody>
<tr class="odd">
<td>1</td>
<td>mpg.de(*)</td>
<td>2.18%</td>
<td>307266</td>
</tr>
<tr class="even">
<td>2</td>
<td>cern.ch</td>
<td>1.94%</td>
<td>273198</td>
</tr>
<tr class="odd">
<td>3</td>
<td>u-tokyo.ac.jp</td>
<td>1.41%</td>
<td>199363</td>
</tr>
<tr class="even">
<td>4</td>
<td>cam.ac.uk</td>
<td>1.30%</td>
<td>182595</td>
</tr>
<tr class="odd">
<td>5</td>
<td>harvard.edu</td>
<td>1.10%</td>
<td>155675</td>
</tr>
<tr class="even">
<td>6</td>
<td>ox.ac.uk</td>
<td>1.03%</td>
<td>144847</td>
</tr>
<tr class="odd">
<td>7</td>
<td>kyoto-u.ac.jp</td>
<td>1.02%</td>
<td>143883</td>
</tr>
<tr class="even">
<td>8</td>
<td>princeton.edu</td>
<td>0.93%</td>
<td>130443</td>
</tr>
<tr class="odd">
<td>9</td>
<td>ethz.ch</td>
<td>0.89%</td>
<td>125417</td>
</tr>
<tr class="even">
<td>10</td>
<td>berkeley.edu</td>
<td>0.87%</td>
<td>122895</td>
</tr>
<tr class="odd">
<td>11</td>
<td>desy.de(*)</td>
<td>0.86%</td>
<td>120948</td>
</tr>
<tr class="even">
<td>12</td>
<td>caltech.edu</td>
<td>0.75%</td>
<td>105862</td>
</tr>
<tr class="odd">
<td>13</td>
<td>mit.edu</td>
<td>0.74%</td>
<td>104023</td>
</tr>
<tr class="even">
<td>14</td>
<td>in2p3.fr</td>
<td>0.72%</td>
<td>101492</td>
</tr>
<tr class="odd">
<td>15</td>
<td>uni-bonn.de</td>
<td>0.63%</td>
<td>88552</td>
</tr>
<tr class="even">
<td>16</td>
<td>columbia.edu</td>
<td>0.62%</td>
<td>87961</td>
</tr>
<tr class="odd">
<td>17</td>
<td>ic.ac.uk</td>
<td>0.61%</td>
<td>85734</td>
</tr>
<tr class="even">
<td>18</td>
<td>ucsb.edu</td>
<td>0.60%</td>
<td>84739</td>
</tr>
<tr class="odd">
<td>19</td>
<td>washington.edu</td>
<td>0.58%</td>
<td>81254</td>
</tr>
<tr class="even">
<td>20</td>
<td>umich.edu</td>
<td>0.57%</td>
<td>79848</td>
</tr>
<tr class="odd">
<td>21</td>
<td>cea.fr</td>
<td>0.55%</td>
<td>76870</td>
</tr>
<tr class="even">
<td>22</td>
<td>bnl.gov</td>
<td>0.54%</td>
<td>76785</td>
</tr>
<tr class="odd">
<td>23</td>
<td>perimeterinstitute.ca</td>
<td>0.54%</td>
<td>75776</td>
</tr>
<tr class="even">
<td>24</td>
<td>dur.ac.uk</td>
<td>0.52%</td>
<td>74001</td>
</tr>
<tr class="odd">
<td>25</td>
<td>cornell.edu</td>
<td>0.51%</td>
<td>71813</td>
</tr>
<tr class="even">
<td>26</td>
<td>sissa.it</td>
<td>0.50%</td>
<td>70988</td>
</tr>
<tr class="odd">
<td>27</td>
<td>tsinghua.edu.cn</td>
<td>0.50%</td>
<td>70251</td>
</tr>
<tr class="even">
<td>28</td>
<td>uni-heidelberg.de</td>
<td>0.49%</td>
<td>68920</td>
</tr>
<tr class="odd">
<td>29</td>
<td>illinois.edu(*)</td>
<td>0.49%</td>
<td>68669</td>
</tr>
<tr class="even">
<td>30</td>
<td>utexas.edu</td>
<td>0.49%</td>
<td>68475</td>
</tr>
<tr class="odd">
<td>31</td>
<td>inaf.it(*)</td>
<td>0.48%</td>
<td>68300</td>
</tr>
<tr class="even">
<td>32</td>
<td>usp.br</td>
<td>0.48%</td>
<td>67543</td>
</tr>
<tr class="odd">
<td>33</td>
<td>epfl.ch</td>
<td>0.48%</td>
<td>66969</td>
</tr>
<tr class="even">
<td>34</td>
<td>uchicago.edu</td>
<td>0.46%</td>
<td>64881</td>
</tr>
<tr class="odd">
<td>35</td>
<td>ictp.it</td>
<td>0.46%</td>
<td>64608</td>
</tr>
<tr class="even">
<td>36</td>
<td>stonybrook.edu(*)</td>
<td>0.45%</td>
<td>63130</td>
</tr>
<tr class="odd">
<td>37</td>
<td>stanford.edu</td>
<td>0.45%</td>
<td>62743</td>
</tr>
<tr class="even">
<td>38</td>
<td>umd.edu</td>
<td>0.44%</td>
<td>62121</td>
</tr>
<tr class="odd">
<td>39</td>
<td>uwaterloo.ca</td>
<td>0.43%</td>
<td>61299</td>
</tr>
<tr class="even">
<td>40</td>
<td>fnal.gov</td>
<td>0.43%</td>
<td>59992</td>
</tr>
<tr class="odd">
<td>41</td>
<td>osaka-u.ac.jp</td>
<td>0.41%</td>
<td>57704</td>
</tr>
<tr class="even">
<td>42</td>
<td>ohio-state.edu</td>
<td>0.41%</td>
<td>57162</td>
</tr>
<tr class="odd">
<td>43</td>
<td>unc.edu</td>
<td>0.40%</td>
<td>56720</td>
</tr>
<tr class="even">
<td>44</td>
<td>nagoya-u.ac.jp</td>
<td>0.40%</td>
<td>56522</td>
</tr>
<tr class="odd">
<td>45</td>
<td>kek.jp</td>
<td>0.40%</td>
<td>56409</td>
</tr>
<tr class="even">
<td>46</td>
<td>utoronto.ca</td>
<td>0.40%</td>
<td>56290</td>
</tr>
<tr class="odd">
<td>47</td>
<td>colorado.edu</td>
<td>0.40%</td>
<td>56236</td>
</tr>
<tr class="even">
<td>48</td>
<td>wisc.edu</td>
<td>0.39%</td>
<td>55039</td>
</tr>
<tr class="odd">
<td>49</td>
<td>psu.edu</td>
<td>0.39%</td>
<td>54370</td>
</tr>
<tr class="even">
<td>50</td>
<td>ntu.edu.tw</td>
<td>0.38%</td>
<td>54275</td>
</tr>
<tr class="odd">
<td>51</td>
<td>umn.edu</td>
<td>0.38%</td>
<td>53813</td>
</tr>
<tr class="even">
<td>52</td>
<td>univie.ac.at</td>
<td>0.38%</td>
<td>53589</td>
</tr>
<tr class="odd">
<td>53</td>
<td>tohoku.ac.jp</td>
<td>0.38%</td>
<td>53466</td>
</tr>
<tr class="even">
<td>54</td>
<td>unige.ch</td>
<td>0.38%</td>
<td>53239</td>
</tr>
<tr class="odd">
<td>55</td>
<td>slac.stanford.edu</td>
<td>0.37%</td>
<td>52475</td>
</tr>
<tr class="even">
<td>56</td>
<td>mcgill.ca</td>
<td>0.37%</td>
<td>52406</td>
</tr>
<tr class="odd">
<td>57</td>
<td>uv.es</td>
<td>0.36%</td>
<td>51365</td>
</tr>
<tr class="even">
<td>58</td>
<td>weizmann.ac.il</td>
<td>0.35%</td>
<td>49377</td>
</tr>
<tr class="odd">
<td>59</td>
<td>jussieu.fr</td>
<td>0.35%</td>
<td>48941</td>
</tr>
<tr class="even">
<td>60</td>
<td>cuhk.edu.hk</td>
<td>0.34%</td>
<td>48614</td>
</tr>
<tr class="odd">
<td>61</td>
<td>jinr.ru</td>
<td>0.34%</td>
<td>48382</td>
</tr>
<tr class="even">
<td>62</td>
<td>uva.nl</td>
<td>0.34%</td>
<td>48355</td>
</tr>
<tr class="odd">
<td>63</td>
<td>ucsd.edu(*)</td>
<td>0.34%</td>
<td>48336</td>
</tr>
<tr class="even">
<td>64</td>
<td>nus.edu.sg</td>
<td>0.34%</td>
<td>47413</td>
</tr>
<tr class="odd">
<td>65</td>
<td>uci.edu</td>
<td>0.33%</td>
<td>47154</td>
</tr>
<tr class="even">
<td>66</td>
<td>rutgers.edu</td>
<td>0.32%</td>
<td>45792</td>
</tr>
<tr class="odd">
<td>67</td>
<td>ucla.edu</td>
<td>0.32%</td>
<td>45600</td>
</tr>
<tr class="even">
<td>68</td>
<td>ubc.ca</td>
<td>0.32%</td>
<td>44964</td>
</tr>
<tr class="odd">
<td>69</td>
<td>u-psud.fr</td>
<td>0.32%</td>
<td>44580</td>
</tr>
<tr class="even">
<td>70</td>
<td>soton.ac.uk</td>
<td>0.32%</td>
<td>44462</td>
</tr>
<tr class="odd">
<td>71</td>
<td>lanl.gov</td>
<td>0.31%</td>
<td>44322</td>
</tr>
<tr class="even">
<td>72</td>
<td>uni-mainz.de</td>
<td>0.31%</td>
<td>43904</td>
</tr>
<tr class="odd">
<td>73</td>
<td>helsinki.fi</td>
<td>0.31%</td>
<td>43692</td>
</tr>
<tr class="even">
<td>74</td>
<td>ucl.ac.uk</td>
<td>0.31%</td>
<td>43066</td>
</tr>
<tr class="odd">
<td>75</td>
<td>tamu.edu</td>
<td>0.30%</td>
<td>42988</td>
</tr>
<tr class="even">
<td>76</td>
<td>yale.edu</td>
<td>0.30%</td>
<td>42958</td>
</tr>
<tr class="odd">
<td>77</td>
<td>csic.es</td>
<td>0.30%</td>
<td>42676</td>
</tr>
<tr class="even">
<td>78</td>
<td>huji.ac.il</td>
<td>0.30%</td>
<td>42665</td>
</tr>
<tr class="odd">
<td>79</td>
<td>upenn.edu</td>
<td>0.30%</td>
<td>42523</td>
</tr>
<tr class="even">
<td>80</td>
<td>uni-frankfurt.de</td>
<td>0.30%</td>
<td>41952</td>
</tr>
<tr class="odd">
<td>81</td>
<td>ens.fr</td>
<td>0.30%</td>
<td>41757</td>
</tr>
<tr class="even">
<td>82</td>
<td>ed.ac.uk</td>
<td>0.29%</td>
<td>41149</td>
</tr>
<tr class="odd">
<td>83</td>
<td>riken.jp(*)</td>
<td>0.29%</td>
<td>41138</td>
</tr>
<tr class="even">
<td>84</td>
<td>gatech.edu</td>
<td>0.29%</td>
<td>40456</td>
</tr>
<tr class="odd">
<td>85</td>
<td>uni-hamburg.de</td>
<td>0.29%</td>
<td>40332</td>
</tr>
<tr class="even">
<td>86</td>
<td>leidenuniv.nl</td>
<td>0.29%</td>
<td>40286</td>
</tr>
<tr class="odd">
<td>87</td>
<td>uni-regensburg.de</td>
<td>0.28%</td>
<td>39841</td>
</tr>
<tr class="even">
<td>88</td>
<td>rwth-aachen.de</td>
<td>0.28%</td>
<td>39490</td>
</tr>
<tr class="odd">
<td>89</td>
<td>uni-hannover.de</td>
<td>0.28%</td>
<td>39478</td>
</tr>
<tr class="even">
<td>90</td>
<td>nottingham.ac.uk</td>
<td>0.28%</td>
<td>39067</td>
</tr>
<tr class="odd">
<td>91</td>
<td>purdue.edu</td>
<td>0.27%</td>
<td>38340</td>
</tr>
<tr class="even">
<td>92</td>
<td>nbi.dk</td>
<td>0.27%</td>
<td>38088</td>
</tr>
<tr class="odd">
<td>93</td>
<td>northwestern.edu</td>
<td>0.27%</td>
<td>37982</td>
</tr>
<tr class="even">
<td>94</td>
<td>hu-berlin.de</td>
<td>0.27%</td>
<td>37978</td>
</tr>
<tr class="odd">
<td>95</td>
<td>bu.edu</td>
<td>0.27%</td>
<td>37735</td>
</tr>
<tr class="even">
<td>96</td>
<td>uni-bielefeld.de</td>
<td>0.26%</td>
<td>36725</td>
</tr>
<tr class="odd">
<td>97</td>
<td>uni-freiburg.de</td>
<td>0.26%</td>
<td>36374</td>
</tr>
<tr class="even">
<td>98</td>
<td>nyu.edu</td>
<td>0.26%</td>
<td>36318</td>
</tr>
<tr class="odd">
<td>99</td>
<td>uni-wuerzburg.de</td>
<td>0.25%</td>
<td>35553</td>
</tr>
<tr class="even">
<td>100</td>
<td>navy.mil</td>
<td>0.25%</td>
<td>35201</td>
</tr>
<tr class="odd">
<td>101</td>
<td>cmu.edu</td>
<td>0.25%</td>
<td>34937</td>
</tr>
<tr class="even">
<td>102</td>
<td>uibk.ac.at</td>
<td>0.25%</td>
<td>34546</td>
</tr>
<tr class="odd">
<td>103</td>
<td>arizona.edu</td>
<td>0.24%</td>
<td>34476</td>
</tr>
<tr class="even">
<td>104</td>
<td>uni-muenchen.de(*)</td>
<td>0.24%</td>
<td>34269</td>
</tr>
<tr class="odd">
<td>105</td>
<td>bris.ac.uk</td>
<td>0.24%</td>
<td>33930</td>
</tr>
<tr class="even">
<td>106</td>
<td>tau.ac.il</td>
<td>0.24%</td>
<td>33750</td>
</tr>
<tr class="odd">
<td>107</td>
<td>unimelb.edu.au</td>
<td>0.24%</td>
<td>33738</td>
</tr>
<tr class="even">
<td>108</td>
<td>lbl.gov</td>
<td>0.24%</td>
<td>33713</td>
</tr>
<tr class="odd">
<td>109</td>
<td>usyd.edu.au</td>
<td>0.24%</td>
<td>33619</td>
</tr>
<tr class="even">
<td>110</td>
<td>uni-koeln.de</td>
<td>0.24%</td>
<td>33600</td>
</tr>
<tr class="odd">
<td>111</td>
<td>ust.hk</td>
<td>0.24%</td>
<td>33287</td>
</tr>
<tr class="even">
<td>112</td>
<td>indiana.edu</td>
<td>0.23%</td>
<td>32711</td>
</tr>
<tr class="odd">
<td>113</td>
<td>fu-berlin.de</td>
<td>0.23%</td>
<td>32362</td>
</tr>
<tr class="even">
<td>114</td>
<td>tuwien.ac.at</td>
<td>0.23%</td>
<td>32358</td>
</tr>
<tr class="odd">
<td>115</td>
<td>ulb.ac.be</td>
<td>0.23%</td>
<td>32303</td>
</tr>
<tr class="even">
<td>116</td>
<td>utl.pt</td>
<td>0.23%</td>
<td>32131</td>
</tr>
<tr class="odd">
<td>117</td>
<td>tum.de(*)</td>
<td>0.23%</td>
<td>31897</td>
</tr>
<tr class="even">
<td>118</td>
<td>chalmers.se</td>
<td>0.23%</td>
<td>31842</td>
</tr>
<tr class="odd">
<td>119</td>
<td>uu.se</td>
<td>0.22%</td>
<td>31593</td>
</tr>
<tr class="even">
<td>120</td>
<td>upc.es</td>
<td>0.22%</td>
<td>31497</td>
</tr>
<tr class="odd">
<td>121</td>
<td>ucm.es</td>
<td>0.22%</td>
<td>31387</td>
</tr>
<tr class="even">
<td>122</td>
<td>prl.res.in</td>
<td>0.22%</td>
<td>30717</td>
</tr>
<tr class="odd">
<td>123</td>
<td>kuleuven.be</td>
<td>0.22%</td>
<td>30640</td>
</tr>
<tr class="even">
<td>124</td>
<td>rug.nl</td>
<td>0.21%</td>
<td>30172</td>
</tr>
<tr class="odd">
<td>125</td>
<td>polytechnique.fr</td>
<td>0.21%</td>
<td>29686</td>
</tr>
<tr class="even">
<td>126</td>
<td>titech.ac.jp</td>
<td>0.21%</td>
<td>29639</td>
</tr>
<tr class="odd">
<td>127</td>
<td>roma1.infn.it</td>
<td>0.21%</td>
<td>29070</td>
</tr>
<tr class="even">
<td>128</td>
<td>ub.es</td>
<td>0.21%</td>
<td>28931</td>
</tr>
<tr class="odd">
<td>129</td>
<td>jhu.edu</td>
<td>0.20%</td>
<td>28850</td>
</tr>
<tr class="even">
<td>130</td>
<td>postech.ac.kr</td>
<td>0.20%</td>
<td>28668</td>
</tr>
<tr class="odd">
<td>131</td>
<td>cnrs.fr(*)</td>
<td>0.20%</td>
<td>28115</td>
</tr>
<tr class="even">
<td>132</td>
<td>nasa.gov</td>
<td>0.20%</td>
<td>27823</td>
</tr>
<tr class="odd">
<td>133</td>
<td>sns.it</td>
<td>0.20%</td>
<td>27797</td>
</tr>
<tr class="even">
<td>134</td>
<td>obspm.fr</td>
<td>0.19%</td>
<td>27364</td>
</tr>
<tr class="odd">
<td>135</td>
<td>ku.dk(*)</td>
<td>0.19%</td>
<td>27364</td>
</tr>
<tr class="even">
<td>136</td>
<td>uzh.ch</td>
<td>0.19%</td>
<td>27112</td>
</tr>
<tr class="odd">
<td>137</td>
<td>pd.infn.it</td>
<td>0.19%</td>
<td>27105</td>
</tr>
<tr class="even">
<td>138</td>
<td>uni-tuebingen.de</td>
<td>0.19%</td>
<td>26756</td>
</tr>
<tr class="odd">
<td>139</td>
<td>ufl.edu</td>
<td>0.19%</td>
<td>26683</td>
</tr>
<tr class="even">
<td>140</td>
<td>uni-bochum.de</td>
<td>0.19%</td>
<td>26218</td>
</tr>
<tr class="odd">
<td>141</td>
<td>nist.gov</td>
<td>0.18%</td>
<td>25765</td>
</tr>
<tr class="even">
<td>142</td>
<td>unam.mx</td>
<td>0.18%</td>
<td>25411</td>
</tr>
<tr class="odd">
<td>143</td>
<td>tu-berlin.de</td>
<td>0.18%</td>
<td>25387</td>
</tr>
<tr class="even">
<td>144</td>
<td>tudelft.nl(*)</td>
<td>0.18%</td>
<td>25279</td>
</tr>
<tr class="odd">
<td>145</td>
<td>hawaii.edu</td>
<td>0.18%</td>
<td>25062</td>
</tr>
<tr class="even">
<td>146</td>
<td>kcl.ac.uk</td>
<td>0.18%</td>
<td>25032</td>
</tr>
<tr class="odd">
<td>147</td>
<td>utah.edu</td>
<td>0.18%</td>
<td>25001</td>
</tr>
<tr class="even">
<td>148</td>
<td>uni-muenster.de</td>
<td>0.18%</td>
<td>24981</td>
</tr>
<tr class="odd">
<td>149</td>
<td>uni-erlangen.de</td>
<td>0.18%</td>
<td>24981</td>
</tr>
<tr class="even">
<td>150</td>
<td>uu.nl</td>
<td>0.18%</td>
<td>24944</td>
</tr>
<tr class="odd">
<td>151</td>
<td>msu.edu</td>
<td>0.18%</td>
<td>24788</td>
</tr>
<tr class="even">
<td>152</td>
<td>tu-darmstadt.de</td>
<td>0.17%</td>
<td>24430</td>
</tr>
<tr class="odd">
<td>153</td>
<td>uni-stuttgart.de</td>
<td>0.17%</td>
<td>24207</td>
</tr>
<tr class="even">
<td>154</td>
<td>unibas.ch</td>
<td>0.17%</td>
<td>24186</td>
</tr>
<tr class="odd">
<td>155</td>
<td>duke.edu</td>
<td>0.17%</td>
<td>23879</td>
</tr>
<tr class="even">
<td>156</td>
<td>kyushu-u.ac.jp</td>
<td>0.17%</td>
<td>23863</td>
</tr>
<tr class="odd">
<td>157</td>
<td>ehu.es</td>
<td>0.17%</td>
<td>23625</td>
</tr>
<tr class="even">
<td>158</td>
<td>nao.ac.jp</td>
<td>0.17%</td>
<td>23559</td>
</tr>
<tr class="odd">
<td>159</td>
<td>waseda.ac.jp</td>
<td>0.16%</td>
<td>23242</td>
</tr>
<tr class="even">
<td>160</td>
<td>tifr.res.in</td>
<td>0.16%</td>
<td>23224</td>
</tr>
<tr class="odd">
<td>161</td>
<td>adelaide.edu.au</td>
<td>0.16%</td>
<td>23126</td>
</tr>
<tr class="even">
<td>162</td>
<td>uj.edu.pl</td>
<td>0.16%</td>
<td>23096</td>
</tr>
<tr class="odd">
<td>163</td>
<td>au.dk</td>
<td>0.16%</td>
<td>22895</td>
</tr>
<tr class="even">
<td>164</td>
<td>ups-tlse.fr</td>
<td>0.16%</td>
<td>22573</td>
</tr>
<tr class="odd">
<td>165</td>
<td>anu.edu.au</td>
<td>0.16%</td>
<td>22496</td>
</tr>
<tr class="even">
<td>166</td>
<td>tkk.fi(*)</td>
<td>0.16%</td>
<td>22454</td>
</tr>
<tr class="odd">
<td>167</td>
<td>nctu.edu.tw</td>
<td>0.16%</td>
<td>22430</td>
</tr>
<tr class="even">
<td>168</td>
<td>uq.edu.au</td>
<td>0.16%</td>
<td>22393</td>
</tr>
<tr class="odd">
<td>169</td>
<td>qmul.ac.uk</td>
<td>0.16%</td>
<td>22375</td>
</tr>
<tr class="even">
<td>170</td>
<td>ujf-grenoble.fr</td>
<td>0.16%</td>
<td>22217</td>
</tr>
<tr class="odd">
<td>171</td>
<td>kth.se</td>
<td>0.16%</td>
<td>22214</td>
</tr>
<tr class="even">
<td>172</td>
<td>uio.no</td>
<td>0.16%</td>
<td>22114</td>
</tr>
<tr class="odd">
<td>173</td>
<td>uic.edu</td>
<td>0.16%</td>
<td>22054</td>
</tr>
<tr class="even">
<td>174</td>
<td>uni-karlsruhe.de(*)</td>
<td>0.16%</td>
<td>22031</td>
</tr>
<tr class="odd">
<td>175</td>
<td>pitt.edu</td>
<td>0.16%</td>
<td>22009</td>
</tr>
<tr class="even">
<td>176</td>
<td>uct.ac.za</td>
<td>0.16%</td>
<td>21997</td>
</tr>
<tr class="odd">
<td>177</td>
<td>kaist.ac.kr</td>
<td>0.15%</td>
<td>21851</td>
</tr>
<tr class="even">
<td>178</td>
<td>uam.es</td>
<td>0.15%</td>
<td>21747</td>
</tr>
<tr class="odd">
<td>179</td>
<td>umass.edu</td>
<td>0.15%</td>
<td>21657</td>
</tr>
<tr class="even">
<td>180</td>
<td>port.ac.uk</td>
<td>0.15%</td>
<td>21561</td>
</tr>
<tr class="odd">
<td>181</td>
<td>ualberta.ca</td>
<td>0.15%</td>
<td>21344</td>
</tr>
<tr class="even">
<td>182</td>
<td>asu.edu</td>
<td>0.15%</td>
<td>21139</td>
</tr>
<tr class="odd">
<td>183</td>
<td>uni-goettingen.de</td>
<td>0.15%</td>
<td>21082</td>
</tr>
<tr class="even">
<td>184</td>
<td>utwente.nl</td>
<td>0.15%</td>
<td>21016</td>
</tr>
<tr class="odd">
<td>185</td>
<td>ntnu.no</td>
<td>0.15%</td>
<td>20988</td>
</tr>
<tr class="even">
<td>186</td>
<td>tsukuba.ac.jp</td>
<td>0.15%</td>
<td>20928</td>
</tr>
<tr class="odd">
<td>187</td>
<td>unibe.ch</td>
<td>0.15%</td>
<td>20888</td>
</tr>
<tr class="even">
<td>188</td>
<td>fuw.edu.pl</td>
<td>0.15%</td>
<td>20714</td>
</tr>
<tr class="odd">
<td>189</td>
<td>ugent.be</td>
<td>0.15%</td>
<td>20630</td>
</tr>
<tr class="even">
<td>190</td>
<td>uniroma1.it</td>
<td>0.15%</td>
<td>20572</td>
</tr>
<tr class="odd">
<td>191</td>
<td>sinica.edu.tw</td>
<td>0.15%</td>
<td>20568</td>
</tr>
<tr class="even">
<td>192</td>
<td>uni-jena.de</td>
<td>0.14%</td>
<td>20390</td>
</tr>
<tr class="odd">
<td>193</td>
<td>fi.infn.it</td>
<td>0.14%</td>
<td>20364</td>
</tr>
<tr class="even">
<td>194</td>
<td>kfa-juelich.de</td>
<td>0.14%</td>
<td>20287</td>
</tr>
<tr class="odd">
<td>195</td>
<td>ugr.es</td>
<td>0.14%</td>
<td>20270</td>
</tr>
<tr class="even">
<td>196</td>
<td>hokudai.ac.jp</td>
<td>0.14%</td>
<td>20259</td>
</tr>
<tr class="odd">
<td>197</td>
<td>susx.ac.uk</td>
<td>0.14%</td>
<td>20251</td>
</tr>
<tr class="even">
<td>198</td>
<td>gla.ac.uk</td>
<td>0.14%</td>
<td>20231</td>
</tr>
<tr class="odd">
<td>199</td>
<td>u-strasbg.fr</td>
<td>0.14%</td>
<td>20089</td>
</tr>
<tr class="even">
<td>200</td>
<td>univ-mrs.fr</td>
<td>0.14%</td>
<td>20064</td>
</tr>
</tbody>
</table>

(\*) Some institutions' downloads come from multiple domains which have
been combined to report an aggregate number:

-   cnrs.fr includes downloads from cnrs-orleans.fr.
-   desy.de includes downloads from ifh.de.
-   illinois.edu includes downloads from uiuc.edu.
-   inaf.it includes downloads from astro.it.
-   ku.dk includes downloads from dark-cosmology.dk.
-   mpg.de includes downloads from aei.mpg.de, bgc-jena.mpg.de,
    biochem.mpg.de, biophys.mpg.de, cbs.mpg.de, coll.mpg.de,
    cpfs.mpg.de, demogr.mpg.de, ds.mpg.de, econ.mpg.de,
    enzyme-halle.mpg.de, eva.mpg.de, fkf.mpg.de, gwdg.de,
    harnackhaus-berlin.mpg.de, hll.mpg.de, ice.mpg.de, immunbio.mpg.de,
    ip.mpg.de, ipp-hgw.mpg.de, ipp.mpg.de, is.mpg.de, mis.mpg.de,
    mmg.mpg.de, molgen.mpg.de, mpa-garching.mpg.de, mpdl.mpg.de,
    mpe-garching.mpg.de, mpe.mpg.de, mpg.mpg.de, mpi-dortmund.mpg.de,
    mpi-fg-koeln.mpg.de, mpi-halle.mpg.de, mpi-hd.mpg.de,
    mpi-inf.mpg.de, mpi-magdeburg.mpg.de, mpi-muelheim.mpg.de,
    mpi-sb.mpg.de, mpi-stuttgart.mpg.de, mpi-sws.mpg.de, mpia-hd.mpg.de,
    mpib-berlin.mpg.de, mpibpc.mpg.de, mpie-duesseldorf.mpg.de,
    mpifr-bonn.mpg.de, mpih-frankfurt.mpg.de, mpiib-berlin.mpg.de,
    mpikg.mpg.de, mpim-bonn.mpg.de, mpimf-heidelberg.mpg.de,
    mpimp-golm.mpg.de, mpip-mainz.mpg.de, mpipks-dresden.mpg.de,
    mpipriv-hh.mpg.de, mpipsykl.mpg.de, mpipz.mpg.de,
    mpiwg-berlin.mpg.de, mpl.mpg.de, mppmu.mpg.de, mpq.mpg.de,
    mps.mpg.de, neuro.mpg.de, orn.mpg.de, rz-berlin.mpg.de, rzg.mpg.de,
    tuebingen.mpg.de, vw-alt.mpg.de, vw.mpg.de.
-   riken.jp includes downloads from riken.go.jp.
-   stonybrook.edu includes downloads from sunysb.edu.
-   tkk.fi includes downloads from hut.fi.
-   tudelft.nl includes downloads from tudelft.net.
-   tum.de includes downloads from tu-muenchen.de.
-   ucsd.edu includes downloads from sdsc.edu.
-   uni-karlsruhe.de includes downloads from fzk.de, kit.edu.
-   uni-muenchen.de includes downloads from lmu.de.

Update history:  
2012-02-01 - Usage data for 2012 first posted.  
2013-05-30 - Data update due to merging domains.
