2013 Institutional arXiv Usage Data
===================================

The following table is a compilation of arXiv downloads for calendar
year 2013 for the 200 heaviest user institutions. See also [arXiv
Support](../support).

**Caveats:** While we have taken considerable effort to extract reliable
download data representing unique full-text downloads by real users,
there are many factors which affect accuracy. These factors include: 1)
the data is from the main arXiv site and the arXiv mirrors, though some
mirror data is incomplete; 2) we have counted downloads according to the
COUNTER algorithm which excludes rapid repeat downloads; 3) we have
attempted to identify and remove robot or automated downloads from the
count (false positives lead to undercounting, failing to identify robots
leads to overcounting); and 4) we include here only downloads that
appear to be from an institution based on the DNS name of the client for
patterns that we recognize (A large fraction of downloads come from
commercial ISPs which are not included. Clients with host names that
don't resolve or off-campus accesses will lead to undercounting, failure
to recognize institutional domain names will exclude those institutions
and undercount the total institutional downloads.) We have identified
15.5 million downloads from institutional domain names out of a total of
66.8 million downloads in 2013.

<table>
<thead>
<tr class="header">
<th>Rank</th>
<th>Institional domain</th>
<th>Percentage of total<br />
institutional downloads</th>
<th>Number of article downloads</th>
</tr>
</thead>
<tbody>
<tr class="odd">
<td>1</td>
<td>mpg.de(*)</td>
<td>2.09%</td>
<td>324116</td>
</tr>
<tr class="even">
<td>2</td>
<td>cern.ch</td>
<td>1.69%</td>
<td>261533</td>
</tr>
<tr class="odd">
<td>3</td>
<td>u-tokyo.ac.jp</td>
<td>1.48%</td>
<td>229780</td>
</tr>
<tr class="even">
<td>4</td>
<td>cam.ac.uk</td>
<td>1.43%</td>
<td>221278</td>
</tr>
<tr class="odd">
<td>5</td>
<td>kyoto-u.ac.jp</td>
<td>1.05%</td>
<td>162690</td>
</tr>
<tr class="even">
<td>6</td>
<td>ox.ac.uk</td>
<td>1.03%</td>
<td>159458</td>
</tr>
<tr class="odd">
<td>7</td>
<td>princeton.edu</td>
<td>1.01%</td>
<td>156924</td>
</tr>
<tr class="even">
<td>8</td>
<td>ethz.ch</td>
<td>0.95%</td>
<td>147186</td>
</tr>
<tr class="odd">
<td>9</td>
<td>berkeley.edu</td>
<td>0.87%</td>
<td>134426</td>
</tr>
<tr class="even">
<td>10</td>
<td>mit.edu</td>
<td>0.83%</td>
<td>128086</td>
</tr>
<tr class="odd">
<td>11</td>
<td>caltech.edu</td>
<td>0.82%</td>
<td>126991</td>
</tr>
<tr class="even">
<td>12</td>
<td>desy.de(*)</td>
<td>0.76%</td>
<td>117750</td>
</tr>
<tr class="odd">
<td>13</td>
<td>harvard.edu</td>
<td>0.71%</td>
<td>110677</td>
</tr>
<tr class="even">
<td>14</td>
<td>columbia.edu</td>
<td>0.71%</td>
<td>109391</td>
</tr>
<tr class="odd">
<td>15</td>
<td>in2p3.fr</td>
<td>0.70%</td>
<td>108377</td>
</tr>
<tr class="even">
<td>16</td>
<td>cornell.edu</td>
<td>0.64%</td>
<td>99312</td>
</tr>
<tr class="odd">
<td>17</td>
<td>ic.ac.uk</td>
<td>0.62%</td>
<td>96036</td>
</tr>
<tr class="even">
<td>18</td>
<td>ucsb.edu</td>
<td>0.61%</td>
<td>93963</td>
</tr>
<tr class="odd">
<td>19</td>
<td>tsinghua.edu.cn</td>
<td>0.60%</td>
<td>92223</td>
</tr>
<tr class="even">
<td>20</td>
<td>uni-bonn.de</td>
<td>0.58%</td>
<td>90219</td>
</tr>
<tr class="odd">
<td>21</td>
<td>umich.edu</td>
<td>0.57%</td>
<td>88184</td>
</tr>
<tr class="even">
<td>22</td>
<td>sissa.it</td>
<td>0.56%</td>
<td>86622</td>
</tr>
<tr class="odd">
<td>23</td>
<td>umd.edu</td>
<td>0.55%</td>
<td>85858</td>
</tr>
<tr class="even">
<td>24</td>
<td>illinois.edu(*)</td>
<td>0.55%</td>
<td>85351</td>
</tr>
<tr class="odd">
<td>25</td>
<td>cea.fr</td>
<td>0.54%</td>
<td>83214</td>
</tr>
<tr class="even">
<td>26</td>
<td>uni-heidelberg.de</td>
<td>0.53%</td>
<td>82078</td>
</tr>
<tr class="odd">
<td>27</td>
<td>epfl.ch</td>
<td>0.52%</td>
<td>81027</td>
</tr>
<tr class="even">
<td>28</td>
<td>utexas.edu</td>
<td>0.52%</td>
<td>79982</td>
</tr>
<tr class="odd">
<td>29</td>
<td>dur.ac.uk</td>
<td>0.50%</td>
<td>77043</td>
</tr>
<tr class="even">
<td>30</td>
<td>utoronto.ca</td>
<td>0.49%</td>
<td>76478</td>
</tr>
<tr class="odd">
<td>31</td>
<td>inaf.it(*)</td>
<td>0.49%</td>
<td>75222</td>
</tr>
<tr class="even">
<td>32</td>
<td>stonybrook.edu(*)</td>
<td>0.48%</td>
<td>74913</td>
</tr>
<tr class="odd">
<td>33</td>
<td>soton.ac.uk</td>
<td>0.48%</td>
<td>74642</td>
</tr>
<tr class="even">
<td>34</td>
<td>ictp.it</td>
<td>0.47%</td>
<td>72800</td>
</tr>
<tr class="odd">
<td>35</td>
<td>uchicago.edu</td>
<td>0.46%</td>
<td>71125</td>
</tr>
<tr class="even">
<td>36</td>
<td>uwaterloo.ca</td>
<td>0.44%</td>
<td>68723</td>
</tr>
<tr class="odd">
<td>37</td>
<td>colorado.edu</td>
<td>0.44%</td>
<td>67813</td>
</tr>
<tr class="even">
<td>38</td>
<td>wisc.edu</td>
<td>0.43%</td>
<td>66333</td>
</tr>
<tr class="odd">
<td>39</td>
<td>umn.edu</td>
<td>0.43%</td>
<td>66332</td>
</tr>
<tr class="even">
<td>40</td>
<td>jinr.ru</td>
<td>0.42%</td>
<td>65682</td>
</tr>
<tr class="odd">
<td>41</td>
<td>stanford.edu</td>
<td>0.41%</td>
<td>64059</td>
</tr>
<tr class="even">
<td>42</td>
<td>usp.br</td>
<td>0.41%</td>
<td>63753</td>
</tr>
<tr class="odd">
<td>43</td>
<td>ucl.ac.uk</td>
<td>0.41%</td>
<td>63165</td>
</tr>
<tr class="even">
<td>44</td>
<td>ohio-state.edu</td>
<td>0.41%</td>
<td>63141</td>
</tr>
<tr class="odd">
<td>45</td>
<td>lanl.gov</td>
<td>0.40%</td>
<td>62193</td>
</tr>
<tr class="even">
<td>46</td>
<td>ntu.edu.tw</td>
<td>0.40%</td>
<td>61846</td>
</tr>
<tr class="odd">
<td>47</td>
<td>cuhk.edu.hk</td>
<td>0.40%</td>
<td>61430</td>
</tr>
<tr class="even">
<td>48</td>
<td>uni-karlsruhe.de(*)</td>
<td>0.39%</td>
<td>60906</td>
</tr>
<tr class="odd">
<td>49</td>
<td>osaka-u.ac.jp</td>
<td>0.39%</td>
<td>60558</td>
</tr>
<tr class="even">
<td>50</td>
<td>yale.edu</td>
<td>0.39%</td>
<td>60068</td>
</tr>
<tr class="odd">
<td>51</td>
<td>nagoya-u.ac.jp</td>
<td>0.39%</td>
<td>59703</td>
</tr>
<tr class="even">
<td>52</td>
<td>kek.jp</td>
<td>0.38%</td>
<td>58568</td>
</tr>
<tr class="odd">
<td>53</td>
<td>tohoku.ac.jp</td>
<td>0.37%</td>
<td>57572</td>
</tr>
<tr class="even">
<td>54</td>
<td>mcgill.ca</td>
<td>0.37%</td>
<td>57523</td>
</tr>
<tr class="odd">
<td>55</td>
<td>univie.ac.at</td>
<td>0.37%</td>
<td>57335</td>
</tr>
<tr class="even">
<td>56</td>
<td>uci.edu</td>
<td>0.37%</td>
<td>56923</td>
</tr>
<tr class="odd">
<td>57</td>
<td>rutgers.edu</td>
<td>0.36%</td>
<td>56153</td>
</tr>
<tr class="even">
<td>58</td>
<td>bnl.gov</td>
<td>0.36%</td>
<td>55665</td>
</tr>
<tr class="odd">
<td>59</td>
<td>upenn.edu</td>
<td>0.36%</td>
<td>55570</td>
</tr>
<tr class="even">
<td>60</td>
<td>uv.es</td>
<td>0.36%</td>
<td>55456</td>
</tr>
<tr class="odd">
<td>61</td>
<td>uni-mainz.de</td>
<td>0.36%</td>
<td>55181</td>
</tr>
<tr class="even">
<td>62</td>
<td>weizmann.ac.il</td>
<td>0.35%</td>
<td>54448</td>
</tr>
<tr class="odd">
<td>63</td>
<td>perimeterinstitute.ca</td>
<td>0.35%</td>
<td>54406</td>
</tr>
<tr class="even">
<td>64</td>
<td>ed.ac.uk</td>
<td>0.34%</td>
<td>52134</td>
</tr>
<tr class="odd">
<td>65</td>
<td>riken.jp(*)</td>
<td>0.34%</td>
<td>52059</td>
</tr>
<tr class="even">
<td>66</td>
<td>u-psud.fr</td>
<td>0.33%</td>
<td>51319</td>
</tr>
<tr class="odd">
<td>67</td>
<td>gatech.edu</td>
<td>0.33%</td>
<td>51191</td>
</tr>
<tr class="even">
<td>68</td>
<td>washington.edu</td>
<td>0.33%</td>
<td>51110</td>
</tr>
<tr class="odd">
<td>69</td>
<td>leidenuniv.nl</td>
<td>0.33%</td>
<td>50551</td>
</tr>
<tr class="even">
<td>70</td>
<td>manchester.ac.uk(*)</td>
<td>0.32%</td>
<td>50321</td>
</tr>
<tr class="odd">
<td>71</td>
<td>ust.hk</td>
<td>0.32%</td>
<td>50296</td>
</tr>
<tr class="even">
<td>72</td>
<td>uva.nl</td>
<td>0.32%</td>
<td>49240</td>
</tr>
<tr class="odd">
<td>73</td>
<td>nus.edu.sg</td>
<td>0.31%</td>
<td>48538</td>
</tr>
<tr class="even">
<td>74</td>
<td>rwth-aachen.de</td>
<td>0.31%</td>
<td>48530</td>
</tr>
<tr class="odd">
<td>75</td>
<td>tamu.edu</td>
<td>0.31%</td>
<td>48485</td>
</tr>
<tr class="even">
<td>76</td>
<td>tu-graz.ac.at</td>
<td>0.31%</td>
<td>47865</td>
</tr>
<tr class="odd">
<td>77</td>
<td>ubc.ca</td>
<td>0.31%</td>
<td>47502</td>
</tr>
<tr class="even">
<td>78</td>
<td>ens.fr</td>
<td>0.30%</td>
<td>47063</td>
</tr>
<tr class="odd">
<td>79</td>
<td>nyu.edu</td>
<td>0.30%</td>
<td>46717</td>
</tr>
<tr class="even">
<td>80</td>
<td>nottingham.ac.uk</td>
<td>0.30%</td>
<td>46175</td>
</tr>
<tr class="odd">
<td>81</td>
<td>jussieu.fr</td>
<td>0.29%</td>
<td>45170</td>
</tr>
<tr class="even">
<td>82</td>
<td>helsinki.fi</td>
<td>0.29%</td>
<td>45055</td>
</tr>
<tr class="odd">
<td>83</td>
<td>ucla.edu</td>
<td>0.29%</td>
<td>45012</td>
</tr>
<tr class="even">
<td>84</td>
<td>psu.edu</td>
<td>0.29%</td>
<td>44270</td>
</tr>
<tr class="odd">
<td>85</td>
<td>sydney.edu.au(*)</td>
<td>0.29%</td>
<td>44160</td>
</tr>
<tr class="even">
<td>86</td>
<td>uni-hannover.de</td>
<td>0.28%</td>
<td>43991</td>
</tr>
<tr class="odd">
<td>87</td>
<td>uni-hamburg.de</td>
<td>0.28%</td>
<td>43484</td>
</tr>
<tr class="even">
<td>88</td>
<td>bris.ac.uk</td>
<td>0.28%</td>
<td>43371</td>
</tr>
<tr class="odd">
<td>89</td>
<td>uni-regensburg.de</td>
<td>0.28%</td>
<td>43190</td>
</tr>
<tr class="even">
<td>90</td>
<td>uni-frankfurt.de</td>
<td>0.28%</td>
<td>42963</td>
</tr>
<tr class="odd">
<td>91</td>
<td>csic.es</td>
<td>0.27%</td>
<td>42561</td>
</tr>
<tr class="even">
<td>92</td>
<td>unige.ch</td>
<td>0.27%</td>
<td>41122</td>
</tr>
<tr class="odd">
<td>93</td>
<td>northwestern.edu</td>
<td>0.26%</td>
<td>40745</td>
</tr>
<tr class="even">
<td>94</td>
<td>ulb.ac.be</td>
<td>0.26%</td>
<td>39960</td>
</tr>
<tr class="odd">
<td>95</td>
<td>purdue.edu</td>
<td>0.25%</td>
<td>39388</td>
</tr>
<tr class="even">
<td>96</td>
<td>uni-freiburg.de</td>
<td>0.25%</td>
<td>39117</td>
</tr>
<tr class="odd">
<td>97</td>
<td>tum.de(*)</td>
<td>0.25%</td>
<td>39052</td>
</tr>
<tr class="even">
<td>98</td>
<td>tuwien.ac.at</td>
<td>0.24%</td>
<td>37853</td>
</tr>
<tr class="odd">
<td>99</td>
<td>tau.ac.il</td>
<td>0.24%</td>
<td>37840</td>
</tr>
<tr class="even">
<td>100</td>
<td>unimelb.edu.au</td>
<td>0.24%</td>
<td>37814</td>
</tr>
<tr class="odd">
<td>101</td>
<td>ucsd.edu(*)</td>
<td>0.24%</td>
<td>37623</td>
</tr>
<tr class="even">
<td>102</td>
<td>rug.nl</td>
<td>0.24%</td>
<td>37295</td>
</tr>
<tr class="odd">
<td>103</td>
<td>hu-berlin.de</td>
<td>0.24%</td>
<td>37127</td>
</tr>
<tr class="even">
<td>104</td>
<td>arizona.edu</td>
<td>0.24%</td>
<td>37085</td>
</tr>
<tr class="odd">
<td>105</td>
<td>ku.dk(*)</td>
<td>0.24%</td>
<td>36988</td>
</tr>
<tr class="even">
<td>106</td>
<td>huji.ac.il</td>
<td>0.24%</td>
<td>36941</td>
</tr>
<tr class="odd">
<td>107</td>
<td>uu.se</td>
<td>0.24%</td>
<td>36782</td>
</tr>
<tr class="even">
<td>108</td>
<td>msu.edu</td>
<td>0.23%</td>
<td>36167</td>
</tr>
<tr class="odd">
<td>109</td>
<td>uni-wuerzburg.de</td>
<td>0.23%</td>
<td>36009</td>
</tr>
<tr class="even">
<td>110</td>
<td>utl.pt</td>
<td>0.23%</td>
<td>35935</td>
</tr>
<tr class="odd">
<td>111</td>
<td>upc.es</td>
<td>0.23%</td>
<td>35823</td>
</tr>
<tr class="even">
<td>112</td>
<td>uibk.ac.at</td>
<td>0.23%</td>
<td>35789</td>
</tr>
<tr class="odd">
<td>113</td>
<td>uni-bielefeld.de</td>
<td>0.23%</td>
<td>35778</td>
</tr>
<tr class="even">
<td>114</td>
<td>fu-berlin.de</td>
<td>0.23%</td>
<td>35301</td>
</tr>
<tr class="odd">
<td>115</td>
<td>slac.stanford.edu</td>
<td>0.23%</td>
<td>35223</td>
</tr>
<tr class="even">
<td>116</td>
<td>polytechnique.fr</td>
<td>0.23%</td>
<td>34974</td>
</tr>
<tr class="odd">
<td>117</td>
<td>mephi.ru</td>
<td>0.22%</td>
<td>34812</td>
</tr>
<tr class="even">
<td>118</td>
<td>navy.mil</td>
<td>0.22%</td>
<td>33878</td>
</tr>
<tr class="odd">
<td>119</td>
<td>fnal.gov</td>
<td>0.22%</td>
<td>33816</td>
</tr>
<tr class="even">
<td>120</td>
<td>cmu.edu</td>
<td>0.22%</td>
<td>33656</td>
</tr>
<tr class="odd">
<td>121</td>
<td>nbi.dk</td>
<td>0.22%</td>
<td>33571</td>
</tr>
<tr class="even">
<td>122</td>
<td>kuleuven.be</td>
<td>0.21%</td>
<td>33069</td>
</tr>
<tr class="odd">
<td>123</td>
<td>nasa.gov</td>
<td>0.21%</td>
<td>31950</td>
</tr>
<tr class="even">
<td>124</td>
<td>uni-muenchen.de(*)</td>
<td>0.21%</td>
<td>31827</td>
</tr>
<tr class="odd">
<td>125</td>
<td>unibas.ch</td>
<td>0.20%</td>
<td>31740</td>
</tr>
<tr class="even">
<td>126</td>
<td>uni-koeln.de</td>
<td>0.20%</td>
<td>31644</td>
</tr>
<tr class="odd">
<td>127</td>
<td>chalmers.se</td>
<td>0.20%</td>
<td>31613</td>
</tr>
<tr class="even">
<td>128</td>
<td>roma1.infn.it</td>
<td>0.20%</td>
<td>31551</td>
</tr>
<tr class="odd">
<td>129</td>
<td>postech.ac.kr</td>
<td>0.20%</td>
<td>31438</td>
</tr>
<tr class="even">
<td>130</td>
<td>uni-muenster.de</td>
<td>0.20%</td>
<td>30822</td>
</tr>
<tr class="odd">
<td>131</td>
<td>tu-darmstadt.de</td>
<td>0.20%</td>
<td>30822</td>
</tr>
<tr class="even">
<td>132</td>
<td>imsc.res.in</td>
<td>0.20%</td>
<td>30741</td>
</tr>
<tr class="odd">
<td>133</td>
<td>tu-berlin.de</td>
<td>0.20%</td>
<td>30540</td>
</tr>
<tr class="even">
<td>134</td>
<td>ub.es</td>
<td>0.20%</td>
<td>30434</td>
</tr>
<tr class="odd">
<td>135</td>
<td>uzh.ch</td>
<td>0.20%</td>
<td>30392</td>
</tr>
<tr class="even">
<td>136</td>
<td>kth.se</td>
<td>0.20%</td>
<td>30327</td>
</tr>
<tr class="odd">
<td>137</td>
<td>nctu.edu.tw</td>
<td>0.19%</td>
<td>30111</td>
</tr>
<tr class="even">
<td>138</td>
<td>indiana.edu</td>
<td>0.19%</td>
<td>29718</td>
</tr>
<tr class="odd">
<td>139</td>
<td>uni-tuebingen.de</td>
<td>0.19%</td>
<td>29600</td>
</tr>
<tr class="even">
<td>140</td>
<td>cnrs.fr(*)</td>
<td>0.19%</td>
<td>29533</td>
</tr>
<tr class="odd">
<td>141</td>
<td>pd.infn.it</td>
<td>0.19%</td>
<td>29485</td>
</tr>
<tr class="even">
<td>142</td>
<td>tudelft.nl(*)</td>
<td>0.19%</td>
<td>29452</td>
</tr>
<tr class="odd">
<td>143</td>
<td>ucm.es</td>
<td>0.19%</td>
<td>29411</td>
</tr>
<tr class="even">
<td>144</td>
<td>duke.edu</td>
<td>0.19%</td>
<td>29284</td>
</tr>
<tr class="odd">
<td>145</td>
<td>uj.edu.pl</td>
<td>0.19%</td>
<td>29196</td>
</tr>
<tr class="even">
<td>146</td>
<td>lbl.gov</td>
<td>0.19%</td>
<td>29140</td>
</tr>
<tr class="odd">
<td>147</td>
<td>anu.edu.au</td>
<td>0.19%</td>
<td>28896</td>
</tr>
<tr class="even">
<td>148</td>
<td>ufl.edu</td>
<td>0.19%</td>
<td>28832</td>
</tr>
<tr class="odd">
<td>149</td>
<td>jhu.edu</td>
<td>0.19%</td>
<td>28815</td>
</tr>
<tr class="even">
<td>150</td>
<td>utah.edu</td>
<td>0.18%</td>
<td>28622</td>
</tr>
<tr class="odd">
<td>151</td>
<td>prl.res.in</td>
<td>0.18%</td>
<td>28511</td>
</tr>
<tr class="even">
<td>152</td>
<td>asu.edu</td>
<td>0.18%</td>
<td>28417</td>
</tr>
<tr class="odd">
<td>153</td>
<td>hawaii.edu</td>
<td>0.18%</td>
<td>28287</td>
</tr>
<tr class="even">
<td>154</td>
<td>uni-goettingen.de</td>
<td>0.18%</td>
<td>28169</td>
</tr>
<tr class="odd">
<td>155</td>
<td>titech.ac.jp</td>
<td>0.18%</td>
<td>27968</td>
</tr>
<tr class="even">
<td>156</td>
<td>pitt.edu</td>
<td>0.18%</td>
<td>27618</td>
</tr>
<tr class="odd">
<td>157</td>
<td>utwente.nl</td>
<td>0.18%</td>
<td>27595</td>
</tr>
<tr class="even">
<td>158</td>
<td>kcl.ac.uk</td>
<td>0.18%</td>
<td>27418</td>
</tr>
<tr class="odd">
<td>159</td>
<td>ehu.es</td>
<td>0.18%</td>
<td>27372</td>
</tr>
<tr class="even">
<td>160</td>
<td>bu.edu</td>
<td>0.18%</td>
<td>27334</td>
</tr>
<tr class="odd">
<td>161</td>
<td>uni-bochum.de</td>
<td>0.18%</td>
<td>27151</td>
</tr>
<tr class="even">
<td>162</td>
<td>uni-erlangen.de</td>
<td>0.18%</td>
<td>27109</td>
</tr>
<tr class="odd">
<td>163</td>
<td>ugent.be</td>
<td>0.17%</td>
<td>26778</td>
</tr>
<tr class="even">
<td>164</td>
<td>obspm.fr</td>
<td>0.17%</td>
<td>26433</td>
</tr>
<tr class="odd">
<td>165</td>
<td>sinica.edu.tw</td>
<td>0.17%</td>
<td>26289</td>
</tr>
<tr class="even">
<td>166</td>
<td>sns.it</td>
<td>0.17%</td>
<td>26063</td>
</tr>
<tr class="odd">
<td>167</td>
<td>uni-stuttgart.de</td>
<td>0.17%</td>
<td>25786</td>
</tr>
<tr class="even">
<td>168</td>
<td>nist.gov</td>
<td>0.17%</td>
<td>25719</td>
</tr>
<tr class="odd">
<td>169</td>
<td>susx.ac.uk</td>
<td>0.16%</td>
<td>25452</td>
</tr>
<tr class="even">
<td>170</td>
<td>uu.nl</td>
<td>0.16%</td>
<td>25445</td>
</tr>
<tr class="odd">
<td>171</td>
<td>ualberta.ca</td>
<td>0.16%</td>
<td>25359</td>
</tr>
<tr class="even">
<td>172</td>
<td>tkk.fi(*)</td>
<td>0.16%</td>
<td>25259</td>
</tr>
<tr class="odd">
<td>173</td>
<td>uq.edu.au</td>
<td>0.16%</td>
<td>25258</td>
</tr>
<tr class="even">
<td>174</td>
<td>au.dk</td>
<td>0.16%</td>
<td>25185</td>
</tr>
<tr class="odd">
<td>175</td>
<td>cuni.cz</td>
<td>0.16%</td>
<td>25091</td>
</tr>
<tr class="even">
<td>176</td>
<td>uio.no</td>
<td>0.16%</td>
<td>24948</td>
</tr>
<tr class="odd">
<td>177</td>
<td>usc.edu</td>
<td>0.16%</td>
<td>24862</td>
</tr>
<tr class="even">
<td>178</td>
<td>nao.ac.jp</td>
<td>0.16%</td>
<td>24676</td>
</tr>
<tr class="odd">
<td>179</td>
<td>uic.edu</td>
<td>0.16%</td>
<td>24597</td>
</tr>
<tr class="even">
<td>180</td>
<td>uam.es</td>
<td>0.16%</td>
<td>24421</td>
</tr>
<tr class="odd">
<td>181</td>
<td>ucdavis.edu</td>
<td>0.16%</td>
<td>24239</td>
</tr>
<tr class="even">
<td>182</td>
<td>kfa-juelich.de</td>
<td>0.16%</td>
<td>24193</td>
</tr>
<tr class="odd">
<td>183</td>
<td>ntnu.no</td>
<td>0.16%</td>
<td>24071</td>
</tr>
<tr class="even">
<td>184</td>
<td>uni-jena.de</td>
<td>0.16%</td>
<td>24019</td>
</tr>
<tr class="odd">
<td>185</td>
<td>unibe.ch</td>
<td>0.15%</td>
<td>23983</td>
</tr>
<tr class="even">
<td>186</td>
<td>adelaide.edu.au</td>
<td>0.15%</td>
<td>23784</td>
</tr>
<tr class="odd">
<td>187</td>
<td>unlp.edu.ar</td>
<td>0.15%</td>
<td>23769</td>
</tr>
<tr class="even">
<td>188</td>
<td>leeds.ac.uk</td>
<td>0.15%</td>
<td>23713</td>
</tr>
<tr class="odd">
<td>189</td>
<td>tifr.res.in</td>
<td>0.15%</td>
<td>23507</td>
</tr>
<tr class="even">
<td>190</td>
<td>isical.ac.in</td>
<td>0.15%</td>
<td>23357</td>
</tr>
<tr class="odd">
<td>191</td>
<td>u-strasbg.fr</td>
<td>0.15%</td>
<td>23263</td>
</tr>
<tr class="even">
<td>192</td>
<td>unam.mx</td>
<td>0.15%</td>
<td>23207</td>
</tr>
<tr class="odd">
<td>193</td>
<td>waseda.ac.jp</td>
<td>0.15%</td>
<td>23123</td>
</tr>
<tr class="even">
<td>194</td>
<td>umontreal.ca</td>
<td>0.15%</td>
<td>22845</td>
</tr>
<tr class="odd">
<td>195</td>
<td>uni-ulm.de</td>
<td>0.15%</td>
<td>22778</td>
</tr>
<tr class="even">
<td>196</td>
<td>uniroma1.it</td>
<td>0.15%</td>
<td>22678</td>
</tr>
<tr class="odd">
<td>197</td>
<td>kyushu-u.ac.jp</td>
<td>0.15%</td>
<td>22646</td>
</tr>
<tr class="even">
<td>198</td>
<td>qmul.ac.uk</td>
<td>0.15%</td>
<td>22478</td>
</tr>
<tr class="odd">
<td>199</td>
<td>to.infn.it</td>
<td>0.14%</td>
<td>22383</td>
</tr>
<tr class="even">
<td>200</td>
<td>ornl.gov</td>
<td>0.14%</td>
<td>22259</td>
</tr>
</tbody>
</table>

(\*) Some institutions' downloads come from multiple domains which have
been combined to report an aggregate number:

-   cnrs.fr includes downloads from cnrs-orleans.fr.
-   desy.de includes downloads from ifh.de.
-   illinois.edu includes downloads from uiuc.edu.
-   inaf.it includes downloads from astro.it.
-   ku.dk includes downloads from dark-cosmology.dk.
-   manchester.ac.uk includes downloads from man.ac.uk.
-   mpg.de includes downloads from aei.mpg.de, age.mpg.de,
    archiv-berlin.mpg.de, bgc-jena.mpg.de, biochem.mpg.de,
    biophys.mpg.de, brain.mpg.de, cbs.mpg.de, cec.mpg.de, coll.mpg.de,
    cpfs.mpg.de, demogr.mpg.de, ds.mpg.de, econ.mpg.de, em.mpg.de,
    enzyme-halle.mpg.de, eva.mpg.de, fkf.mpg.de, gwdg.de, hll.mpg.de,
    ice.mpg.de, immunbio.mpg.de, ip.mpg.de, ipp-hgw.mpg.de, ipp.mpg.de,
    is.mpg.de, mis.mpg.de, mmg.mpg.de, molgen.mpg.de,
    mpa-garching.mpg.de, mpdl.mpg.de, mpe-garching.mpg.de, mpe.mpg.de,
    mpg-gv.mpg.de, mpi-dortmund.mpg.de, mpi-fg-koeln.mpg.de,
    mpi-halle.mpg.de, mpi-hd.mpg.de, mpi-inf.mpg.de, mpi-klsb.mpg.de,
    mpi-magdeburg.mpg.de, mpi-muelheim.mpg.de, mpi-sb.mpg.de,
    mpi-stuttgart.mpg.de, mpi-sws.mpg.de, mpia-hd.mpg.de,
    mpib-berlin.mpg.de, mpibpc.mpg.de, mpie-duesseldorf.mpg.de,
    mpifr-bonn.mpg.de, mpih-frankfurt.mpg.de, mpiib-berlin.mpg.de,
    mpikg.mpg.de, mpim-bonn.mpg.de, mpimf-heidelberg.mpg.de,
    mpimp-golm.mpg.de, mpip-mainz.mpg.de, mpipks-dresden.mpg.de,
    mpipsykl.mpg.de, mpipz.mpg.de, mpiwg-berlin.mpg.de, mpl.mpg.de,
    mppmu.mpg.de, mpq.mpg.de, mps.mpg.de, neuro.mpg.de, orn.mpg.de,
    rz-berlin.mpg.de, rzg.mpg.de, tuebingen.mpg.de, vw.mpg.de.
-   riken.jp includes downloads from riken.go.jp.
-   stonybrook.edu includes downloads from sunysb.edu.
-   sydney.edu.au includes downloads from usyd.edu.au.
-   tkk.fi includes downloads from hut.fi.
-   tudelft.nl includes downloads from tudelft.net.
-   tum.de includes downloads from tu-muenchen.de.
-   ucsd.edu includes downloads from sdsc.edu.
-   uni-karlsruhe.de includes downloads from fzk.de, kit.edu.
-   uni-muenchen.de includes downloads from lmu.de.

Update history:  
2014-01-06 - Usage data for 2013 first posted.  
2014-02-07 - Updated with merge of multiple domains for Sydney and
Manchester.
