2014 Institutional arXiv Usage Data
===================================

The following table is a compilation of arXiv downloads for calendar
year 2014 for the 200 heaviest user institutions. See also [arXiv
Support](../support).

**Caveats:** While we have taken considerable effort to extract reliable
download data representing unique full-text downloads by real users,
there are many factors which affect accuracy. These factors include: 1)
the data is from the main arXiv site and the arXiv mirrors, though some
mirror data is incomplete; 2) we have counted downloads according to the
COUNTER algorithm which excludes rapid repeat downloads; 3) we have
attempted to identify and remove robot or automated downloads from the
count (false positives lead to undercounting, failing to identify robots
leads to overcounting); and 4) we include here only downloads that
appear to be from an institution based on the DNS name of the client for
patterns that we recognize (A large fraction of downloads come from
commercial ISPs which are not included. Clients with host names that
don't resolve or off-campus accesses will lead to undercounting, failure
to recognize institutional domain names will exclude those institutions
and undercount the total institutional downloads.) We have identified
16.1 million downloads from institutional domain names out of a total of
91.2 million downloads in 2014.

<table>
<thead>
<tr class="header">
<th>Rank</th>
<th>Institional domain</th>
<th>Percentage of total<br />
institutional downloads</th>
<th>Number of article downloads</th>
</tr>
</thead>
<tbody>
<tr class="odd">
<td>1</td>
<td>cern.ch</td>
<td>1.79%</td>
<td>288089</td>
</tr>
<tr class="even">
<td>2</td>
<td>mpg.de(*)</td>
<td>1.77%</td>
<td>285175</td>
</tr>
<tr class="odd">
<td>3</td>
<td>epfl.ch</td>
<td>1.64%</td>
<td>264200</td>
</tr>
<tr class="even">
<td>4</td>
<td>lanl.gov</td>
<td>1.56%</td>
<td>251259</td>
</tr>
<tr class="odd">
<td>5</td>
<td>cam.ac.uk</td>
<td>1.50%</td>
<td>241580</td>
</tr>
<tr class="even">
<td>6</td>
<td>u-tokyo.ac.jp</td>
<td>1.31%</td>
<td>210698</td>
</tr>
<tr class="odd">
<td>7</td>
<td>ox.ac.uk</td>
<td>1.12%</td>
<td>180569</td>
</tr>
<tr class="even">
<td>8</td>
<td>kyoto-u.ac.jp</td>
<td>1.00%</td>
<td>160939</td>
</tr>
<tr class="odd">
<td>9</td>
<td>ethz.ch</td>
<td>0.98%</td>
<td>157575</td>
</tr>
<tr class="even">
<td>10</td>
<td>harvard.edu</td>
<td>0.88%</td>
<td>141483</td>
</tr>
<tr class="odd">
<td>11</td>
<td>caltech.edu</td>
<td>0.80%</td>
<td>129858</td>
</tr>
<tr class="even">
<td>12</td>
<td>columbia.edu</td>
<td>0.77%</td>
<td>124730</td>
</tr>
<tr class="odd">
<td>13</td>
<td>mit.edu</td>
<td>0.76%</td>
<td>122595</td>
</tr>
<tr class="even">
<td>14</td>
<td>cornell.edu</td>
<td>0.75%</td>
<td>120793</td>
</tr>
<tr class="odd">
<td>15</td>
<td>desy.de(*)</td>
<td>0.73%</td>
<td>118331</td>
</tr>
<tr class="even">
<td>16</td>
<td>in2p3.fr</td>
<td>0.70%</td>
<td>112173</td>
</tr>
<tr class="odd">
<td>17</td>
<td>ic.ac.uk</td>
<td>0.69%</td>
<td>110625</td>
</tr>
<tr class="even">
<td>18</td>
<td>princeton.edu</td>
<td>0.62%</td>
<td>100270</td>
</tr>
<tr class="odd">
<td>19</td>
<td>perimeterinstitute.ca</td>
<td>0.59%</td>
<td>95298</td>
</tr>
<tr class="even">
<td>20</td>
<td>berkeley.edu</td>
<td>0.58%</td>
<td>93381</td>
</tr>
<tr class="odd">
<td>21</td>
<td>uni-bonn.de</td>
<td>0.57%</td>
<td>92494</td>
</tr>
<tr class="even">
<td>22</td>
<td>illinois.edu(*)</td>
<td>0.57%</td>
<td>92491</td>
</tr>
<tr class="odd">
<td>23</td>
<td>soton.ac.uk</td>
<td>0.56%</td>
<td>90761</td>
</tr>
<tr class="even">
<td>24</td>
<td>nus.edu.sg</td>
<td>0.55%</td>
<td>88973</td>
</tr>
<tr class="odd">
<td>25</td>
<td>cea.fr</td>
<td>0.54%</td>
<td>87366</td>
</tr>
<tr class="even">
<td>26</td>
<td>umd.edu</td>
<td>0.54%</td>
<td>86396</td>
</tr>
<tr class="odd">
<td>27</td>
<td>utexas.edu</td>
<td>0.52%</td>
<td>84115</td>
</tr>
<tr class="even">
<td>28</td>
<td>ucsb.edu</td>
<td>0.52%</td>
<td>83874</td>
</tr>
<tr class="odd">
<td>29</td>
<td>yale.edu</td>
<td>0.50%</td>
<td>80914</td>
</tr>
<tr class="even">
<td>30</td>
<td>uni-heidelberg.de</td>
<td>0.50%</td>
<td>80415</td>
</tr>
<tr class="odd">
<td>31</td>
<td>utoronto.ca</td>
<td>0.49%</td>
<td>79355</td>
</tr>
<tr class="even">
<td>32</td>
<td>umn.edu</td>
<td>0.49%</td>
<td>79199</td>
</tr>
<tr class="odd">
<td>33</td>
<td>ucl.ac.uk</td>
<td>0.49%</td>
<td>78831</td>
</tr>
<tr class="even">
<td>34</td>
<td>dur.ac.uk</td>
<td>0.49%</td>
<td>78474</td>
</tr>
<tr class="odd">
<td>35</td>
<td>stanford.edu</td>
<td>0.48%</td>
<td>77401</td>
</tr>
<tr class="even">
<td>36</td>
<td>sissa.it</td>
<td>0.48%</td>
<td>76846</td>
</tr>
<tr class="odd">
<td>37</td>
<td>colorado.edu</td>
<td>0.47%</td>
<td>75247</td>
</tr>
<tr class="even">
<td>38</td>
<td>nagoya-u.ac.jp</td>
<td>0.47%</td>
<td>75103</td>
</tr>
<tr class="odd">
<td>39</td>
<td>inaf.it(*)</td>
<td>0.46%</td>
<td>74647</td>
</tr>
<tr class="even">
<td>40</td>
<td>upmc.fr(*)</td>
<td>0.46%</td>
<td>74013</td>
</tr>
<tr class="odd">
<td>41</td>
<td>uchicago.edu</td>
<td>0.45%</td>
<td>73060</td>
</tr>
<tr class="even">
<td>42</td>
<td>stonybrook.edu(*)</td>
<td>0.44%</td>
<td>70964</td>
</tr>
<tr class="odd">
<td>43</td>
<td>tsinghua.edu.cn</td>
<td>0.44%</td>
<td>70936</td>
</tr>
<tr class="even">
<td>44</td>
<td>uwaterloo.ca</td>
<td>0.44%</td>
<td>70784</td>
</tr>
<tr class="odd">
<td>45</td>
<td>wisc.edu</td>
<td>0.42%</td>
<td>68411</td>
</tr>
<tr class="even">
<td>46</td>
<td>usp.br</td>
<td>0.42%</td>
<td>67761</td>
</tr>
<tr class="odd">
<td>47</td>
<td>uva.nl</td>
<td>0.42%</td>
<td>67602</td>
</tr>
<tr class="even">
<td>48</td>
<td>cuhk.edu.hk</td>
<td>0.40%</td>
<td>65156</td>
</tr>
<tr class="odd">
<td>49</td>
<td>ohio-state.edu</td>
<td>0.40%</td>
<td>63770</td>
</tr>
<tr class="even">
<td>50</td>
<td>nthu.edu.tw</td>
<td>0.39%</td>
<td>63050</td>
</tr>
<tr class="odd">
<td>51</td>
<td>univie.ac.at</td>
<td>0.39%</td>
<td>62520</td>
</tr>
<tr class="even">
<td>52</td>
<td>riken.jp(*)</td>
<td>0.38%</td>
<td>61926</td>
</tr>
<tr class="odd">
<td>53</td>
<td>ntu.edu.tw</td>
<td>0.38%</td>
<td>61352</td>
</tr>
<tr class="even">
<td>54</td>
<td>weizmann.ac.il</td>
<td>0.38%</td>
<td>61090</td>
</tr>
<tr class="odd">
<td>55</td>
<td>ed.ac.uk</td>
<td>0.38%</td>
<td>60734</td>
</tr>
<tr class="even">
<td>56</td>
<td>uni-karlsruhe.de(*)</td>
<td>0.38%</td>
<td>60667</td>
</tr>
<tr class="odd">
<td>57</td>
<td>uni-mainz.de</td>
<td>0.37%</td>
<td>60488</td>
</tr>
<tr class="even">
<td>58</td>
<td>ictp.it</td>
<td>0.37%</td>
<td>59613</td>
</tr>
<tr class="odd">
<td>59</td>
<td>umich.edu</td>
<td>0.37%</td>
<td>59069</td>
</tr>
<tr class="even">
<td>60</td>
<td>tamu.edu</td>
<td>0.36%</td>
<td>58707</td>
</tr>
<tr class="odd">
<td>61</td>
<td>tohoku.ac.jp</td>
<td>0.36%</td>
<td>57787</td>
</tr>
<tr class="even">
<td>62</td>
<td>manchester.ac.uk(*)</td>
<td>0.36%</td>
<td>57663</td>
</tr>
<tr class="odd">
<td>63</td>
<td>kek.jp</td>
<td>0.35%</td>
<td>57038</td>
</tr>
<tr class="even">
<td>64</td>
<td>rutgers.edu</td>
<td>0.35%</td>
<td>56699</td>
</tr>
<tr class="odd">
<td>65</td>
<td>osaka-u.ac.jp</td>
<td>0.35%</td>
<td>55821</td>
</tr>
<tr class="even">
<td>66</td>
<td>gatech.edu</td>
<td>0.34%</td>
<td>55659</td>
</tr>
<tr class="odd">
<td>67</td>
<td>upenn.edu</td>
<td>0.34%</td>
<td>55634</td>
</tr>
<tr class="even">
<td>68</td>
<td>ust.hk</td>
<td>0.34%</td>
<td>55128</td>
</tr>
<tr class="odd">
<td>69</td>
<td>rwth-aachen.de</td>
<td>0.34%</td>
<td>54694</td>
</tr>
<tr class="even">
<td>70</td>
<td>uci.edu</td>
<td>0.34%</td>
<td>54430</td>
</tr>
<tr class="odd">
<td>71</td>
<td>ubc.ca</td>
<td>0.33%</td>
<td>53783</td>
</tr>
<tr class="even">
<td>72</td>
<td>rug.nl</td>
<td>0.33%</td>
<td>53493</td>
</tr>
<tr class="odd">
<td>73</td>
<td>leidenuniv.nl</td>
<td>0.32%</td>
<td>51972</td>
</tr>
<tr class="even">
<td>74</td>
<td>bris.ac.uk</td>
<td>0.32%</td>
<td>51668</td>
</tr>
<tr class="odd">
<td>75</td>
<td>ucla.edu</td>
<td>0.32%</td>
<td>51356</td>
</tr>
<tr class="even">
<td>76</td>
<td>uv.es</td>
<td>0.32%</td>
<td>51165</td>
</tr>
<tr class="odd">
<td>77</td>
<td>bnl.gov</td>
<td>0.31%</td>
<td>50505</td>
</tr>
<tr class="even">
<td>78</td>
<td>washington.edu</td>
<td>0.31%</td>
<td>49320</td>
</tr>
<tr class="odd">
<td>79</td>
<td>u-psud.fr</td>
<td>0.29%</td>
<td>46292</td>
</tr>
<tr class="even">
<td>80</td>
<td>ens.fr</td>
<td>0.28%</td>
<td>45061</td>
</tr>
<tr class="odd">
<td>81</td>
<td>jinr.ru</td>
<td>0.27%</td>
<td>44278</td>
</tr>
<tr class="even">
<td>82</td>
<td>ku.dk(*)</td>
<td>0.27%</td>
<td>44114</td>
</tr>
<tr class="odd">
<td>83</td>
<td>uni-hamburg.de</td>
<td>0.27%</td>
<td>44051</td>
</tr>
<tr class="even">
<td>84</td>
<td>tuwien.ac.at</td>
<td>0.27%</td>
<td>43496</td>
</tr>
<tr class="odd">
<td>85</td>
<td>tau.ac.il</td>
<td>0.27%</td>
<td>43496</td>
</tr>
<tr class="even">
<td>86</td>
<td>uni-frankfurt.de</td>
<td>0.27%</td>
<td>43348</td>
</tr>
<tr class="odd">
<td>87</td>
<td>cvut.cz</td>
<td>0.27%</td>
<td>43216</td>
</tr>
<tr class="even">
<td>88</td>
<td>uni-regensburg.de</td>
<td>0.27%</td>
<td>43183</td>
</tr>
<tr class="odd">
<td>89</td>
<td>helsinki.fi</td>
<td>0.26%</td>
<td>42311</td>
</tr>
<tr class="even">
<td>90</td>
<td>uni-hannover.de</td>
<td>0.26%</td>
<td>42229</td>
</tr>
<tr class="odd">
<td>91</td>
<td>uni-koeln.de</td>
<td>0.26%</td>
<td>41888</td>
</tr>
<tr class="even">
<td>92</td>
<td>bu.edu</td>
<td>0.26%</td>
<td>41858</td>
</tr>
<tr class="odd">
<td>93</td>
<td>uzh.ch</td>
<td>0.26%</td>
<td>41370</td>
</tr>
<tr class="even">
<td>94</td>
<td>ulb.ac.be</td>
<td>0.26%</td>
<td>41349</td>
</tr>
<tr class="odd">
<td>95</td>
<td>mcgill.ca</td>
<td>0.26%</td>
<td>41238</td>
</tr>
<tr class="even">
<td>96</td>
<td>uu.se</td>
<td>0.25%</td>
<td>40684</td>
</tr>
<tr class="odd">
<td>97</td>
<td>northwestern.edu</td>
<td>0.25%</td>
<td>40521</td>
</tr>
<tr class="even">
<td>98</td>
<td>hu-berlin.de</td>
<td>0.25%</td>
<td>40125</td>
</tr>
<tr class="odd">
<td>99</td>
<td>unimelb.edu.au</td>
<td>0.25%</td>
<td>39669</td>
</tr>
<tr class="even">
<td>100</td>
<td>huji.ac.il</td>
<td>0.24%</td>
<td>38873</td>
</tr>
<tr class="odd">
<td>101</td>
<td>uibk.ac.at</td>
<td>0.24%</td>
<td>38247</td>
</tr>
<tr class="even">
<td>102</td>
<td>slac.stanford.edu</td>
<td>0.23%</td>
<td>37904</td>
</tr>
<tr class="odd">
<td>103</td>
<td>psu.edu</td>
<td>0.23%</td>
<td>37826</td>
</tr>
<tr class="even">
<td>104</td>
<td>tum.de(*)</td>
<td>0.23%</td>
<td>37766</td>
</tr>
<tr class="odd">
<td>105</td>
<td>su.se</td>
<td>0.23%</td>
<td>37436</td>
</tr>
<tr class="even">
<td>106</td>
<td>csic.es</td>
<td>0.23%</td>
<td>37254</td>
</tr>
<tr class="odd">
<td>107</td>
<td>sydney.edu.au(*)</td>
<td>0.23%</td>
<td>37134</td>
</tr>
<tr class="even">
<td>108</td>
<td>ucsd.edu(*)</td>
<td>0.23%</td>
<td>37003</td>
</tr>
<tr class="odd">
<td>109</td>
<td>tu-berlin.de</td>
<td>0.23%</td>
<td>36724</td>
</tr>
<tr class="even">
<td>110</td>
<td>ias.edu</td>
<td>0.22%</td>
<td>36088</td>
</tr>
<tr class="odd">
<td>111</td>
<td>arizona.edu</td>
<td>0.22%</td>
<td>35998</td>
</tr>
<tr class="even">
<td>112</td>
<td>chalmers.se</td>
<td>0.22%</td>
<td>35951</td>
</tr>
<tr class="odd">
<td>113</td>
<td>uni-freiburg.de</td>
<td>0.22%</td>
<td>35634</td>
</tr>
<tr class="even">
<td>114</td>
<td>upc.es</td>
<td>0.22%</td>
<td>35485</td>
</tr>
<tr class="odd">
<td>115</td>
<td>unibas.ch</td>
<td>0.22%</td>
<td>35357</td>
</tr>
<tr class="even">
<td>116</td>
<td>purdue.edu</td>
<td>0.22%</td>
<td>34891</td>
</tr>
<tr class="odd">
<td>117</td>
<td>asu.edu</td>
<td>0.22%</td>
<td>34712</td>
</tr>
<tr class="even">
<td>118</td>
<td>kuleuven.be</td>
<td>0.21%</td>
<td>34376</td>
</tr>
<tr class="odd">
<td>119</td>
<td>roma1.infn.it</td>
<td>0.21%</td>
<td>34160</td>
</tr>
<tr class="even">
<td>120</td>
<td>fu-berlin.de</td>
<td>0.21%</td>
<td>34087</td>
</tr>
<tr class="odd">
<td>121</td>
<td>monash.edu.au</td>
<td>0.21%</td>
<td>33715</td>
</tr>
<tr class="even">
<td>122</td>
<td>tu-darmstadt.de</td>
<td>0.21%</td>
<td>33377</td>
</tr>
<tr class="odd">
<td>123</td>
<td>susx.ac.uk</td>
<td>0.21%</td>
<td>33187</td>
</tr>
<tr class="even">
<td>124</td>
<td>usc.edu</td>
<td>0.20%</td>
<td>32937</td>
</tr>
<tr class="odd">
<td>125</td>
<td>polytechnique.fr</td>
<td>0.20%</td>
<td>32880</td>
</tr>
<tr class="even">
<td>126</td>
<td>nyu.edu</td>
<td>0.20%</td>
<td>32464</td>
</tr>
<tr class="odd">
<td>127</td>
<td>tudelft.nl(*)</td>
<td>0.20%</td>
<td>32155</td>
</tr>
<tr class="even">
<td>128</td>
<td>msu.edu</td>
<td>0.20%</td>
<td>32074</td>
</tr>
<tr class="odd">
<td>129</td>
<td>kcl.ac.uk</td>
<td>0.20%</td>
<td>31993</td>
</tr>
<tr class="even">
<td>130</td>
<td>nasa.gov</td>
<td>0.20%</td>
<td>31969</td>
</tr>
<tr class="odd">
<td>131</td>
<td>postech.ac.kr</td>
<td>0.20%</td>
<td>31537</td>
</tr>
<tr class="even">
<td>132</td>
<td>navy.mil</td>
<td>0.19%</td>
<td>31406</td>
</tr>
<tr class="odd">
<td>133</td>
<td>ufl.edu</td>
<td>0.19%</td>
<td>31289</td>
</tr>
<tr class="even">
<td>134</td>
<td>nao.ac.jp</td>
<td>0.19%</td>
<td>31199</td>
</tr>
<tr class="odd">
<td>135</td>
<td>duke.edu</td>
<td>0.19%</td>
<td>30929</td>
</tr>
<tr class="even">
<td>136</td>
<td>ugent.be</td>
<td>0.19%</td>
<td>30727</td>
</tr>
<tr class="odd">
<td>137</td>
<td>obspm.fr</td>
<td>0.19%</td>
<td>30560</td>
</tr>
<tr class="even">
<td>138</td>
<td>utah.edu</td>
<td>0.19%</td>
<td>30426</td>
</tr>
<tr class="odd">
<td>139</td>
<td>uni-erlangen.de</td>
<td>0.19%</td>
<td>30102</td>
</tr>
<tr class="even">
<td>140</td>
<td>waseda.ac.jp</td>
<td>0.18%</td>
<td>29692</td>
</tr>
<tr class="odd">
<td>141</td>
<td>uni-wuerzburg.de</td>
<td>0.18%</td>
<td>29466</td>
</tr>
<tr class="even">
<td>142</td>
<td>uni-bielefeld.de</td>
<td>0.18%</td>
<td>29266</td>
</tr>
<tr class="odd">
<td>143</td>
<td>cmu.edu</td>
<td>0.18%</td>
<td>29220</td>
</tr>
<tr class="even">
<td>144</td>
<td>cnrs.fr(*)</td>
<td>0.18%</td>
<td>29211</td>
</tr>
<tr class="odd">
<td>145</td>
<td>uni-stuttgart.de</td>
<td>0.18%</td>
<td>28983</td>
</tr>
<tr class="even">
<td>146</td>
<td>kth.se</td>
<td>0.18%</td>
<td>28734</td>
</tr>
<tr class="odd">
<td>147</td>
<td>uni-tuebingen.de</td>
<td>0.18%</td>
<td>28584</td>
</tr>
<tr class="even">
<td>148</td>
<td>anu.edu.au</td>
<td>0.18%</td>
<td>28347</td>
</tr>
<tr class="odd">
<td>149</td>
<td>ens-lyon.fr</td>
<td>0.17%</td>
<td>28160</td>
</tr>
<tr class="even">
<td>150</td>
<td>uj.edu.pl</td>
<td>0.17%</td>
<td>28147</td>
</tr>
<tr class="odd">
<td>151</td>
<td>ru.nl</td>
<td>0.17%</td>
<td>28007</td>
</tr>
<tr class="even">
<td>152</td>
<td>titech.ac.jp</td>
<td>0.17%</td>
<td>27813</td>
</tr>
<tr class="odd">
<td>153</td>
<td>ehu.es</td>
<td>0.17%</td>
<td>27784</td>
</tr>
<tr class="even">
<td>154</td>
<td>indiana.edu</td>
<td>0.17%</td>
<td>27777</td>
</tr>
<tr class="odd">
<td>155</td>
<td>uni-bochum.de</td>
<td>0.17%</td>
<td>27690</td>
</tr>
<tr class="even">
<td>156</td>
<td>unige.ch</td>
<td>0.17%</td>
<td>27592</td>
</tr>
<tr class="odd">
<td>157</td>
<td>nottingham.ac.uk</td>
<td>0.17%</td>
<td>27547</td>
</tr>
<tr class="even">
<td>158</td>
<td>uni-ulm.de</td>
<td>0.17%</td>
<td>27334</td>
</tr>
<tr class="odd">
<td>159</td>
<td>unibe.ch</td>
<td>0.17%</td>
<td>27228</td>
</tr>
<tr class="even">
<td>160</td>
<td>leeds.ac.uk</td>
<td>0.17%</td>
<td>26925</td>
</tr>
<tr class="odd">
<td>161</td>
<td>u-strasbg.fr</td>
<td>0.17%</td>
<td>26827</td>
</tr>
<tr class="even">
<td>162</td>
<td>pd.infn.it</td>
<td>0.17%</td>
<td>26729</td>
</tr>
<tr class="odd">
<td>163</td>
<td>uni-goettingen.de</td>
<td>0.16%</td>
<td>26614</td>
</tr>
<tr class="even">
<td>164</td>
<td>hawaii.edu</td>
<td>0.16%</td>
<td>26519</td>
</tr>
<tr class="odd">
<td>165</td>
<td>tkk.fi(*)</td>
<td>0.16%</td>
<td>26447</td>
</tr>
<tr class="even">
<td>166</td>
<td>ualberta.ca</td>
<td>0.16%</td>
<td>26391</td>
</tr>
<tr class="odd">
<td>167</td>
<td>unlp.edu.ar</td>
<td>0.16%</td>
<td>26333</td>
</tr>
<tr class="even">
<td>168</td>
<td>adelaide.edu.au</td>
<td>0.16%</td>
<td>26253</td>
</tr>
<tr class="odd">
<td>169</td>
<td>to.infn.it</td>
<td>0.16%</td>
<td>26211</td>
</tr>
<tr class="even">
<td>170</td>
<td>ucm.es</td>
<td>0.16%</td>
<td>26054</td>
</tr>
<tr class="odd">
<td>171</td>
<td>umass.edu</td>
<td>0.16%</td>
<td>26028</td>
</tr>
<tr class="even">
<td>172</td>
<td>ucdavis.edu</td>
<td>0.16%</td>
<td>26018</td>
</tr>
<tr class="odd">
<td>173</td>
<td>warwick.ac.uk</td>
<td>0.16%</td>
<td>25794</td>
</tr>
<tr class="even">
<td>174</td>
<td>uni-muenchen.de(*)</td>
<td>0.16%</td>
<td>25733</td>
</tr>
<tr class="odd">
<td>175</td>
<td>nbi.dk</td>
<td>0.16%</td>
<td>25664</td>
</tr>
<tr class="even">
<td>176</td>
<td>uio.no</td>
<td>0.16%</td>
<td>25622</td>
</tr>
<tr class="odd">
<td>177</td>
<td>pitt.edu</td>
<td>0.16%</td>
<td>25193</td>
</tr>
<tr class="even">
<td>178</td>
<td>sns.it</td>
<td>0.16%</td>
<td>25155</td>
</tr>
<tr class="odd">
<td>179</td>
<td>qmul.ac.uk</td>
<td>0.16%</td>
<td>25122</td>
</tr>
<tr class="even">
<td>180</td>
<td>univ-paris-diderot.fr</td>
<td>0.15%</td>
<td>24920</td>
</tr>
<tr class="odd">
<td>181</td>
<td>nist.gov</td>
<td>0.15%</td>
<td>24807</td>
</tr>
<tr class="even">
<td>182</td>
<td>kfa-juelich.de</td>
<td>0.15%</td>
<td>24776</td>
</tr>
<tr class="odd">
<td>183</td>
<td>kyushu-u.ac.jp</td>
<td>0.15%</td>
<td>24669</td>
</tr>
<tr class="even">
<td>184</td>
<td>jhu.edu</td>
<td>0.15%</td>
<td>24538</td>
</tr>
<tr class="odd">
<td>185</td>
<td>ub.es</td>
<td>0.15%</td>
<td>24460</td>
</tr>
<tr class="even">
<td>186</td>
<td>ntnu.no</td>
<td>0.15%</td>
<td>24426</td>
</tr>
<tr class="odd">
<td>187</td>
<td>unc.edu</td>
<td>0.15%</td>
<td>24412</td>
</tr>
<tr class="even">
<td>188</td>
<td>unicamp.br</td>
<td>0.15%</td>
<td>24358</td>
</tr>
<tr class="odd">
<td>189</td>
<td>sinica.edu.tw</td>
<td>0.15%</td>
<td>23938</td>
</tr>
<tr class="even">
<td>190</td>
<td>cuni.cz</td>
<td>0.15%</td>
<td>23881</td>
</tr>
<tr class="odd">
<td>191</td>
<td>uni-jena.de</td>
<td>0.15%</td>
<td>23739</td>
</tr>
<tr class="even">
<td>192</td>
<td>tifr.res.in</td>
<td>0.15%</td>
<td>23562</td>
</tr>
<tr class="odd">
<td>193</td>
<td>uwo.ca</td>
<td>0.15%</td>
<td>23475</td>
</tr>
<tr class="even">
<td>194</td>
<td>ornl.gov</td>
<td>0.15%</td>
<td>23412</td>
</tr>
<tr class="odd">
<td>195</td>
<td>ups-tlse.fr</td>
<td>0.14%</td>
<td>23304</td>
</tr>
<tr class="even">
<td>196</td>
<td>shef.ac.uk</td>
<td>0.14%</td>
<td>23246</td>
</tr>
<tr class="odd">
<td>197</td>
<td>uniroma1.it</td>
<td>0.14%</td>
<td>23084</td>
</tr>
<tr class="even">
<td>198</td>
<td>nikhef.nl</td>
<td>0.14%</td>
<td>23066</td>
</tr>
<tr class="odd">
<td>199</td>
<td>gla.ac.uk</td>
<td>0.14%</td>
<td>22690</td>
</tr>
<tr class="even">
<td>200</td>
<td>vt.edu</td>
<td>0.14%</td>
<td>22683</td>
</tr>
</tbody>
</table>

(\*) Some institutions' downloads come from multiple domains which have
been combined to report an aggregate number:

-   cnrs.fr includes downloads from cnrs-orleans.fr.
-   desy.de includes downloads from ifh.de.
-   illinois.edu includes downloads from uiuc.edu.
-   inaf.it includes downloads from astro.it.
-   ku.dk includes downloads from dark-cosmology.dk.
-   manchester.ac.uk includes downloads from man.ac.uk.
-   mpg.de includes downloads from aei.mpg.de, aesthetics.mpg.de,
    age.mpg.de, archiv-berlin.mpg.de, bgc-jena.mpg.de, biochem.mpg.de,
    biophys.mpg.de, brain.mpg.de, cbs.mpg.de, cec.mpg.de, coll.mpg.de,
    cpfs.mpg.de, demogr.mpg.de, ds.mpg.de, econ.mpg.de, em.mpg.de,
    enzyme-halle.mpg.de, eva.mpg.de, fkf.mpg.de, gwdg.de,
    harnackhaus-berlin.mpg.de, hll.mpg.de, ice.mpg.de,
    ie-freiburg.mpg.de, immunbio.mpg.de, ip.mpg.de, ipp-hgw.mpg.de,
    ipp.mpg.de, is.mpg.de, mis.mpg.de, molgen.mpg.de,
    mpa-garching.mpg.de, mpdl.mpg.de, mpe-garching.mpg.de, mpe.mpg.de,
    mpi-dortmund.mpg.de, mpi-fg-koeln.mpg.de, mpi-halle.mpg.de,
    mpi-hd.mpg.de, mpi-inf.mpg.de, mpi-klsb.mpg.de,
    mpi-magdeburg.mpg.de, mpi-muelheim.mpg.de, mpi-sb.mpg.de,
    mpi-stuttgart.mpg.de, mpia-hd.mpg.de, mpib-berlin.mpg.de,
    mpibpc.mpg.de, mpie-duesseldorf.mpg.de, mpifr-bonn.mpg.de,
    mpih-frankfurt.mpg.de, mpiib-berlin.mpg.de, mpikg.mpg.de,
    mpim-bonn.mpg.de, mpimf-heidelberg.mpg.de, mpimp-golm.mpg.de,
    mpip-mainz.mpg.de, mpipks-dresden.mpg.de, mpipriv-hh.mpg.de,
    mpipsykl.mpg.de, mpipz.mpg.de, mpiwg-berlin.mpg.de, mppmu.mpg.de,
    mpq.mpg.de, mps.mpg.de, neuro.mpg.de, nf.mpg.de, orn.mpg.de,
    rz-berlin.mpg.de, rzg.mpg.de, tuebingen.mpg.de, vw.mpg.de.
-   riken.jp includes downloads from riken.go.jp.
-   stonybrook.edu includes downloads from sunysb.edu.
-   sydney.edu.au includes downloads from usyd.edu.au.
-   tkk.fi includes downloads from hut.fi.
-   tudelft.nl includes downloads from tudelft.net.
-   tum.de includes downloads from tu-muenchen.de.
-   ucsd.edu includes downloads from sdsc.edu.
-   uni-karlsruhe.de includes downloads from fzk.de, kit.edu.
-   uni-muenchen.de includes downloads from lmu.de.
-   upmc.fr includes downloads from jussieu.fr.

Update history:  
2015-01-13 - Usage data for 2014 first posted.  
2015-08-14 - Merge jussieu.fr and upmc.fr downloads.
