2015 Institutional arXiv Usage Data
===================================

The following table is a compilation of arXiv downloads for calendar
year 2015 for the 200 heaviest user institutions. See also [arXiv
Support](../support).

**Caveats:** While we have taken considerable effort to extract reliable
download data representing unique full-text downloads by real users,
there are many factors which affect accuracy. These factors include: 1)
the data is from the main arXiv site and the arXiv mirrors, though some
mirror data is incomplete; 2) we have counted downloads according to the
COUNTER algorithm which excludes rapid repeat downloads; 3) we have
attempted to identify and remove robot or automated downloads from the
count (false positives lead to undercounting, failing to identify robots
leads to overcounting); and 4) we include here only downloads that
appear to be from an institution based on the DNS name of the client for
patterns that we recognize (A large fraction of downloads come from
commercial ISPs which are not included. Clients with host names that
don't resolve or off-campus accesses will lead to undercounting, failure
to recognize institutional domain names will exclude those institutions
and undercount the total institutional downloads.) We have identified
18.1 million downloads from institutional domain names out of a total of
over 139 million downloads in 2015.

<table>
<thead>
<tr class="header">
<th>Rank</th>
<th>Institional domain</th>
<th>Percentage of total<br />
institutional downloads</th>
<th>Number of article downloads</th>
</tr>
</thead>
<tbody>
<tr class="odd">
<td>1</td>
<td>epfl.ch</td>
<td>2.72%</td>
<td>492218</td>
</tr>
<tr class="even">
<td>2</td>
<td>cern.ch</td>
<td>1.86%</td>
<td>336221</td>
</tr>
<tr class="odd">
<td>3</td>
<td>mpg.de(*)</td>
<td>1.82%</td>
<td>329677</td>
</tr>
<tr class="even">
<td>4</td>
<td>cam.ac.uk</td>
<td>1.60%</td>
<td>290134</td>
</tr>
<tr class="odd">
<td>5</td>
<td>u-tokyo.ac.jp</td>
<td>1.23%</td>
<td>222544</td>
</tr>
<tr class="even">
<td>6</td>
<td>mit.edu</td>
<td>1.14%</td>
<td>207018</td>
</tr>
<tr class="odd">
<td>7</td>
<td>berkeley.edu</td>
<td>1.11%</td>
<td>200597</td>
</tr>
<tr class="even">
<td>8</td>
<td>princeton.edu</td>
<td>1.07%</td>
<td>194616</td>
</tr>
<tr class="odd">
<td>9</td>
<td>ox.ac.uk</td>
<td>1.04%</td>
<td>188810</td>
</tr>
<tr class="even">
<td>10</td>
<td>ethz.ch</td>
<td>1.03%</td>
<td>186117</td>
</tr>
<tr class="odd">
<td>11</td>
<td>kyoto-u.ac.jp</td>
<td>0.86%</td>
<td>156036</td>
</tr>
<tr class="even">
<td>12</td>
<td>caltech.edu</td>
<td>0.78%</td>
<td>140708</td>
</tr>
<tr class="odd">
<td>13</td>
<td>columbia.edu</td>
<td>0.78%</td>
<td>140360</td>
</tr>
<tr class="even">
<td>14</td>
<td>ic.ac.uk</td>
<td>0.76%</td>
<td>138372</td>
</tr>
<tr class="odd">
<td>15</td>
<td>in2p3.fr</td>
<td>0.74%</td>
<td>134146</td>
</tr>
<tr class="even">
<td>16</td>
<td>ucl.ac.uk</td>
<td>0.71%</td>
<td>128760</td>
</tr>
<tr class="odd">
<td>17</td>
<td>desy.de(*)</td>
<td>0.69%</td>
<td>124869</td>
</tr>
<tr class="even">
<td>18</td>
<td>cornell.edu</td>
<td>0.66%</td>
<td>120195</td>
</tr>
<tr class="odd">
<td>19</td>
<td>harvard.edu</td>
<td>0.61%</td>
<td>110546</td>
</tr>
<tr class="even">
<td>20</td>
<td>nus.edu.sg</td>
<td>0.60%</td>
<td>108817</td>
</tr>
<tr class="odd">
<td>21</td>
<td>perimeterinstitute.ca</td>
<td>0.59%</td>
<td>106762</td>
</tr>
<tr class="even">
<td>22</td>
<td>ucla.edu</td>
<td>0.59%</td>
<td>106380</td>
</tr>
<tr class="odd">
<td>23</td>
<td>nyu.edu</td>
<td>0.57%</td>
<td>102974</td>
</tr>
<tr class="even">
<td>24</td>
<td>uni-bonn.de</td>
<td>0.57%</td>
<td>102554</td>
</tr>
<tr class="odd">
<td>25</td>
<td>ucsb.edu</td>
<td>0.56%</td>
<td>102169</td>
</tr>
<tr class="even">
<td>26</td>
<td>illinois.edu(*)</td>
<td>0.56%</td>
<td>102101</td>
</tr>
<tr class="odd">
<td>27</td>
<td>umd.edu</td>
<td>0.56%</td>
<td>101685</td>
</tr>
<tr class="even">
<td>28</td>
<td>umn.edu</td>
<td>0.54%</td>
<td>98024</td>
</tr>
<tr class="odd">
<td>29</td>
<td>cuhk.edu.hk</td>
<td>0.52%</td>
<td>94007</td>
</tr>
<tr class="even">
<td>30</td>
<td>uva.nl</td>
<td>0.51%</td>
<td>92756</td>
</tr>
<tr class="odd">
<td>31</td>
<td>utexas.edu</td>
<td>0.51%</td>
<td>91741</td>
</tr>
<tr class="even">
<td>32</td>
<td>stanford.edu</td>
<td>0.50%</td>
<td>90427</td>
</tr>
<tr class="odd">
<td>33</td>
<td>yale.edu</td>
<td>0.49%</td>
<td>88272</td>
</tr>
<tr class="even">
<td>34</td>
<td>uchicago.edu</td>
<td>0.48%</td>
<td>87408</td>
</tr>
<tr class="odd">
<td>35</td>
<td>uni-heidelberg.de</td>
<td>0.47%</td>
<td>86004</td>
</tr>
<tr class="even">
<td>36</td>
<td>uwaterloo.ca</td>
<td>0.47%</td>
<td>85526</td>
</tr>
<tr class="odd">
<td>37</td>
<td>nthu.edu.tw</td>
<td>0.47%</td>
<td>85036</td>
</tr>
<tr class="even">
<td>38</td>
<td>utoronto.ca</td>
<td>0.46%</td>
<td>82907</td>
</tr>
<tr class="odd">
<td>39</td>
<td>uni-mainz.de</td>
<td>0.45%</td>
<td>82293</td>
</tr>
<tr class="even">
<td>40</td>
<td>colorado.edu</td>
<td>0.45%</td>
<td>81273</td>
</tr>
<tr class="odd">
<td>41</td>
<td>nagoya-u.ac.jp</td>
<td>0.44%</td>
<td>79567</td>
</tr>
<tr class="even">
<td>42</td>
<td>tohoku.ac.jp</td>
<td>0.44%</td>
<td>79114</td>
</tr>
<tr class="odd">
<td>43</td>
<td>ust.hk</td>
<td>0.43%</td>
<td>78772</td>
</tr>
<tr class="even">
<td>44</td>
<td>cea.fr</td>
<td>0.43%</td>
<td>78744</td>
</tr>
<tr class="odd">
<td>45</td>
<td>usp.br</td>
<td>0.43%</td>
<td>77449</td>
</tr>
<tr class="even">
<td>46</td>
<td>wisc.edu</td>
<td>0.43%</td>
<td>77001</td>
</tr>
<tr class="odd">
<td>47</td>
<td>ed.ac.uk</td>
<td>0.42%</td>
<td>76684</td>
</tr>
<tr class="even">
<td>48</td>
<td>gatech.edu</td>
<td>0.42%</td>
<td>75181</td>
</tr>
<tr class="odd">
<td>49</td>
<td>dur.ac.uk</td>
<td>0.41%</td>
<td>74500</td>
</tr>
<tr class="even">
<td>50</td>
<td>inaf.it(*)</td>
<td>0.41%</td>
<td>74314</td>
</tr>
<tr class="odd">
<td>51</td>
<td>sissa.it</td>
<td>0.41%</td>
<td>73973</td>
</tr>
<tr class="even">
<td>52</td>
<td>ias.edu</td>
<td>0.39%</td>
<td>70943</td>
</tr>
<tr class="odd">
<td>53</td>
<td>rutgers.edu</td>
<td>0.39%</td>
<td>70894</td>
</tr>
<tr class="even">
<td>54</td>
<td>upmc.fr(*)</td>
<td>0.39%</td>
<td>70540</td>
</tr>
<tr class="odd">
<td>55</td>
<td>riken.jp(*)</td>
<td>0.39%</td>
<td>70270</td>
</tr>
<tr class="even">
<td>56</td>
<td>upenn.edu</td>
<td>0.38%</td>
<td>69430</td>
</tr>
<tr class="odd">
<td>57</td>
<td>ictp.it</td>
<td>0.38%</td>
<td>68453</td>
</tr>
<tr class="even">
<td>58</td>
<td>stonybrook.edu(*)</td>
<td>0.37%</td>
<td>66446</td>
</tr>
<tr class="odd">
<td>59</td>
<td>manchester.ac.uk(*)</td>
<td>0.37%</td>
<td>66387</td>
</tr>
<tr class="even">
<td>60</td>
<td>uci.edu</td>
<td>0.37%</td>
<td>66153</td>
</tr>
<tr class="odd">
<td>61</td>
<td>tamu.edu</td>
<td>0.36%</td>
<td>65987</td>
</tr>
<tr class="even">
<td>62</td>
<td>weizmann.ac.il</td>
<td>0.36%</td>
<td>65300</td>
</tr>
<tr class="odd">
<td>63</td>
<td>univie.ac.at</td>
<td>0.35%</td>
<td>63992</td>
</tr>
<tr class="even">
<td>64</td>
<td>ubc.ca</td>
<td>0.35%</td>
<td>63766</td>
</tr>
<tr class="odd">
<td>65</td>
<td>washington.edu</td>
<td>0.35%</td>
<td>63728</td>
</tr>
<tr class="even">
<td>66</td>
<td>csic.es</td>
<td>0.35%</td>
<td>62840</td>
</tr>
<tr class="odd">
<td>67</td>
<td>uni-karlsruhe.de(*)</td>
<td>0.34%</td>
<td>61842</td>
</tr>
<tr class="even">
<td>68</td>
<td>mcgill.ca</td>
<td>0.34%</td>
<td>61579</td>
</tr>
<tr class="odd">
<td>69</td>
<td>ntu.edu.tw</td>
<td>0.34%</td>
<td>60985</td>
</tr>
<tr class="even">
<td>70</td>
<td>bris.ac.uk</td>
<td>0.33%</td>
<td>60203</td>
</tr>
<tr class="odd">
<td>71</td>
<td>osaka-u.ac.jp</td>
<td>0.33%</td>
<td>59876</td>
</tr>
<tr class="even">
<td>72</td>
<td>umich.edu</td>
<td>0.32%</td>
<td>58254</td>
</tr>
<tr class="odd">
<td>73</td>
<td>kek.jp</td>
<td>0.32%</td>
<td>57581</td>
</tr>
<tr class="even">
<td>74</td>
<td>rwth-aachen.de</td>
<td>0.31%</td>
<td>56944</td>
</tr>
<tr class="odd">
<td>75</td>
<td>ohio-state.edu</td>
<td>0.31%</td>
<td>56829</td>
</tr>
<tr class="even">
<td>76</td>
<td>rug.nl</td>
<td>0.30%</td>
<td>54974</td>
</tr>
<tr class="odd">
<td>77</td>
<td>bnl.gov</td>
<td>0.29%</td>
<td>52841</td>
</tr>
<tr class="even">
<td>78</td>
<td>cmu.edu</td>
<td>0.29%</td>
<td>52460</td>
</tr>
<tr class="odd">
<td>79</td>
<td>tudelft.nl(*)</td>
<td>0.29%</td>
<td>52190</td>
</tr>
<tr class="even">
<td>80</td>
<td>jinr.ru</td>
<td>0.29%</td>
<td>51930</td>
</tr>
<tr class="odd">
<td>81</td>
<td>unimelb.edu.au</td>
<td>0.29%</td>
<td>51616</td>
</tr>
<tr class="even">
<td>82</td>
<td>u-psud.fr</td>
<td>0.28%</td>
<td>51386</td>
</tr>
<tr class="odd">
<td>83</td>
<td>northwestern.edu</td>
<td>0.28%</td>
<td>50340</td>
</tr>
<tr class="even">
<td>84</td>
<td>leidenuniv.nl</td>
<td>0.28%</td>
<td>50019</td>
</tr>
<tr class="odd">
<td>85</td>
<td>uni-hannover.de</td>
<td>0.28%</td>
<td>50017</td>
</tr>
<tr class="even">
<td>86</td>
<td>uu.se</td>
<td>0.27%</td>
<td>49703</td>
</tr>
<tr class="odd">
<td>87</td>
<td>uv.es</td>
<td>0.27%</td>
<td>49409</td>
</tr>
<tr class="even">
<td>88</td>
<td>soton.ac.uk</td>
<td>0.27%</td>
<td>48968</td>
</tr>
<tr class="odd">
<td>89</td>
<td>helsinki.fi</td>
<td>0.26%</td>
<td>47344</td>
</tr>
<tr class="even">
<td>90</td>
<td>tu-berlin.de</td>
<td>0.26%</td>
<td>46786</td>
</tr>
<tr class="odd">
<td>91</td>
<td>tau.ac.il</td>
<td>0.26%</td>
<td>46596</td>
</tr>
<tr class="even">
<td>92</td>
<td>uni-frankfurt.de</td>
<td>0.25%</td>
<td>46071</td>
</tr>
<tr class="odd">
<td>93</td>
<td>kuleuven.be</td>
<td>0.25%</td>
<td>45584</td>
</tr>
<tr class="even">
<td>94</td>
<td>ku.dk(*)</td>
<td>0.25%</td>
<td>45429</td>
</tr>
<tr class="odd">
<td>95</td>
<td>uec.ac.jp</td>
<td>0.25%</td>
<td>45292</td>
</tr>
<tr class="even">
<td>96</td>
<td>univ-mlv.fr</td>
<td>0.24%</td>
<td>44036</td>
</tr>
<tr class="odd">
<td>97</td>
<td>tum.de(*)</td>
<td>0.24%</td>
<td>43984</td>
</tr>
<tr class="even">
<td>98</td>
<td>uni-freiburg.de</td>
<td>0.24%</td>
<td>43824</td>
</tr>
<tr class="odd">
<td>99</td>
<td>bu.edu</td>
<td>0.24%</td>
<td>42742</td>
</tr>
<tr class="even">
<td>100</td>
<td>uni-koeln.de</td>
<td>0.24%</td>
<td>42640</td>
</tr>
<tr class="odd">
<td>101</td>
<td>tuwien.ac.at</td>
<td>0.23%</td>
<td>42541</td>
</tr>
<tr class="even">
<td>102</td>
<td>chalmers.se</td>
<td>0.23%</td>
<td>42515</td>
</tr>
<tr class="odd">
<td>103</td>
<td>usc.edu</td>
<td>0.23%</td>
<td>42476</td>
</tr>
<tr class="even">
<td>104</td>
<td>su.se</td>
<td>0.23%</td>
<td>42245</td>
</tr>
<tr class="odd">
<td>105</td>
<td>ens.fr</td>
<td>0.23%</td>
<td>42048</td>
</tr>
<tr class="even">
<td>106</td>
<td>uni-hamburg.de</td>
<td>0.23%</td>
<td>41650</td>
</tr>
<tr class="odd">
<td>107</td>
<td>uni-regensburg.de</td>
<td>0.23%</td>
<td>41596</td>
</tr>
<tr class="even">
<td>108</td>
<td>arizona.edu</td>
<td>0.23%</td>
<td>41416</td>
</tr>
<tr class="odd">
<td>109</td>
<td>hu-berlin.de</td>
<td>0.23%</td>
<td>41041</td>
</tr>
<tr class="even">
<td>110</td>
<td>purdue.edu</td>
<td>0.22%</td>
<td>40178</td>
</tr>
<tr class="odd">
<td>111</td>
<td>ulb.ac.be</td>
<td>0.22%</td>
<td>39955</td>
</tr>
<tr class="even">
<td>112</td>
<td>uzh.ch</td>
<td>0.22%</td>
<td>39894</td>
</tr>
<tr class="odd">
<td>113</td>
<td>huji.ac.il</td>
<td>0.22%</td>
<td>39822</td>
</tr>
<tr class="even">
<td>114</td>
<td>fu-berlin.de</td>
<td>0.22%</td>
<td>39802</td>
</tr>
<tr class="odd">
<td>115</td>
<td>lanl.gov</td>
<td>0.22%</td>
<td>39791</td>
</tr>
<tr class="even">
<td>116</td>
<td>duke.edu</td>
<td>0.22%</td>
<td>39325</td>
</tr>
<tr class="odd">
<td>117</td>
<td>ufl.edu</td>
<td>0.22%</td>
<td>39200</td>
</tr>
<tr class="even">
<td>118</td>
<td>susx.ac.uk</td>
<td>0.21%</td>
<td>38316</td>
</tr>
<tr class="odd">
<td>119</td>
<td>slac.stanford.edu</td>
<td>0.21%</td>
<td>38184</td>
</tr>
<tr class="even">
<td>120</td>
<td>unibas.ch</td>
<td>0.21%</td>
<td>37939</td>
</tr>
<tr class="odd">
<td>121</td>
<td>ru.nl</td>
<td>0.21%</td>
<td>37856</td>
</tr>
<tr class="even">
<td>122</td>
<td>tu-darmstadt.de</td>
<td>0.21%</td>
<td>37608</td>
</tr>
<tr class="odd">
<td>123</td>
<td>kth.se</td>
<td>0.21%</td>
<td>37587</td>
</tr>
<tr class="even">
<td>124</td>
<td>uibk.ac.at</td>
<td>0.20%</td>
<td>36719</td>
</tr>
<tr class="odd">
<td>125</td>
<td>anu.edu.au</td>
<td>0.20%</td>
<td>36433</td>
</tr>
<tr class="even">
<td>126</td>
<td>waseda.ac.jp</td>
<td>0.20%</td>
<td>36294</td>
</tr>
<tr class="odd">
<td>127</td>
<td>nao.ac.jp</td>
<td>0.20%</td>
<td>36243</td>
</tr>
<tr class="even">
<td>128</td>
<td>sydney.edu.au(*)</td>
<td>0.20%</td>
<td>35937</td>
</tr>
<tr class="odd">
<td>129</td>
<td>ucdavis.edu</td>
<td>0.20%</td>
<td>35574</td>
</tr>
<tr class="even">
<td>130</td>
<td>navy.mil</td>
<td>0.20%</td>
<td>35558</td>
</tr>
<tr class="odd">
<td>131</td>
<td>psu.edu</td>
<td>0.20%</td>
<td>35552</td>
</tr>
<tr class="even">
<td>132</td>
<td>umass.edu</td>
<td>0.20%</td>
<td>35510</td>
</tr>
<tr class="odd">
<td>133</td>
<td>postech.ac.kr</td>
<td>0.19%</td>
<td>35113</td>
</tr>
<tr class="even">
<td>134</td>
<td>uni-stuttgart.de</td>
<td>0.19%</td>
<td>35091</td>
</tr>
<tr class="odd">
<td>135</td>
<td>ucsd.edu(*)</td>
<td>0.19%</td>
<td>34916</td>
</tr>
<tr class="even">
<td>136</td>
<td>asu.edu</td>
<td>0.19%</td>
<td>34867</td>
</tr>
<tr class="odd">
<td>137</td>
<td>hri.res.in</td>
<td>0.19%</td>
<td>34536</td>
</tr>
<tr class="even">
<td>138</td>
<td>u-strasbg.fr</td>
<td>0.19%</td>
<td>34418</td>
</tr>
<tr class="odd">
<td>139</td>
<td>uni-erlangen.de</td>
<td>0.19%</td>
<td>34241</td>
</tr>
<tr class="even">
<td>140</td>
<td>upc.es</td>
<td>0.19%</td>
<td>33839</td>
</tr>
<tr class="odd">
<td>141</td>
<td>ualberta.ca</td>
<td>0.19%</td>
<td>33664</td>
</tr>
<tr class="even">
<td>142</td>
<td>uq.edu.au</td>
<td>0.19%</td>
<td>33565</td>
</tr>
<tr class="odd">
<td>143</td>
<td>hokudai.ac.jp</td>
<td>0.18%</td>
<td>33283</td>
</tr>
<tr class="even">
<td>144</td>
<td>polytechnique.fr</td>
<td>0.18%</td>
<td>32820</td>
</tr>
<tr class="odd">
<td>145</td>
<td>nctu.edu.tw</td>
<td>0.18%</td>
<td>32362</td>
</tr>
<tr class="even">
<td>146</td>
<td>titech.ac.jp</td>
<td>0.18%</td>
<td>32166</td>
</tr>
<tr class="odd">
<td>147</td>
<td>tifr.res.in</td>
<td>0.18%</td>
<td>32150</td>
</tr>
<tr class="even">
<td>148</td>
<td>uni-muenster.de</td>
<td>0.17%</td>
<td>31633</td>
</tr>
<tr class="odd">
<td>149</td>
<td>utah.edu</td>
<td>0.17%</td>
<td>31366</td>
</tr>
<tr class="even">
<td>150</td>
<td>ugent.be</td>
<td>0.17%</td>
<td>31353</td>
</tr>
<tr class="odd">
<td>151</td>
<td>roma1.infn.it</td>
<td>0.17%</td>
<td>30869</td>
</tr>
<tr class="even">
<td>152</td>
<td>indiana.edu</td>
<td>0.17%</td>
<td>30816</td>
</tr>
<tr class="odd">
<td>153</td>
<td>kfa-juelich.de</td>
<td>0.17%</td>
<td>30313</td>
</tr>
<tr class="even">
<td>154</td>
<td>unibe.ch</td>
<td>0.17%</td>
<td>30206</td>
</tr>
<tr class="odd">
<td>155</td>
<td>uni-wuerzburg.de</td>
<td>0.17%</td>
<td>30114</td>
</tr>
<tr class="even">
<td>156</td>
<td>unc.edu</td>
<td>0.16%</td>
<td>29852</td>
</tr>
<tr class="odd">
<td>157</td>
<td>kcl.ac.uk</td>
<td>0.16%</td>
<td>29682</td>
</tr>
<tr class="even">
<td>158</td>
<td>leeds.ac.uk</td>
<td>0.16%</td>
<td>29192</td>
</tr>
<tr class="odd">
<td>159</td>
<td>af.mil</td>
<td>0.16%</td>
<td>28969</td>
</tr>
<tr class="even">
<td>160</td>
<td>monash.edu.au</td>
<td>0.16%</td>
<td>28885</td>
</tr>
<tr class="odd">
<td>161</td>
<td>umontreal.ca</td>
<td>0.16%</td>
<td>28741</td>
</tr>
<tr class="even">
<td>162</td>
<td>qmul.ac.uk</td>
<td>0.16%</td>
<td>28595</td>
</tr>
<tr class="odd">
<td>163</td>
<td>ens-lyon.fr</td>
<td>0.16%</td>
<td>28553</td>
</tr>
<tr class="even">
<td>164</td>
<td>shef.ac.uk</td>
<td>0.16%</td>
<td>28480</td>
</tr>
<tr class="odd">
<td>165</td>
<td>vt.edu</td>
<td>0.16%</td>
<td>28448</td>
</tr>
<tr class="even">
<td>166</td>
<td>uni-bielefeld.de</td>
<td>0.16%</td>
<td>28360</td>
</tr>
<tr class="odd">
<td>167</td>
<td>obspm.fr</td>
<td>0.16%</td>
<td>28167</td>
</tr>
<tr class="even">
<td>168</td>
<td>gla.ac.uk</td>
<td>0.15%</td>
<td>27908</td>
</tr>
<tr class="odd">
<td>169</td>
<td>uni-ulm.de</td>
<td>0.15%</td>
<td>27903</td>
</tr>
<tr class="even">
<td>170</td>
<td>osti.gov</td>
<td>0.15%</td>
<td>27807</td>
</tr>
<tr class="odd">
<td>171</td>
<td>ornl.gov</td>
<td>0.15%</td>
<td>27662</td>
</tr>
<tr class="even">
<td>172</td>
<td>ntnu.no</td>
<td>0.15%</td>
<td>27599</td>
</tr>
<tr class="odd">
<td>173</td>
<td>nbi.dk</td>
<td>0.15%</td>
<td>27546</td>
</tr>
<tr class="even">
<td>174</td>
<td>unlp.edu.ar</td>
<td>0.15%</td>
<td>27477</td>
</tr>
<tr class="odd">
<td>175</td>
<td>ehu.es</td>
<td>0.15%</td>
<td>27174</td>
</tr>
<tr class="even">
<td>176</td>
<td>tkk.fi(*)</td>
<td>0.15%</td>
<td>27134</td>
</tr>
<tr class="odd">
<td>177</td>
<td>uio.no</td>
<td>0.15%</td>
<td>26955</td>
</tr>
<tr class="even">
<td>178</td>
<td>uni-tuebingen.de</td>
<td>0.15%</td>
<td>26846</td>
</tr>
<tr class="odd">
<td>179</td>
<td>sns.it</td>
<td>0.15%</td>
<td>26773</td>
</tr>
<tr class="even">
<td>180</td>
<td>hawaii.edu</td>
<td>0.15%</td>
<td>26679</td>
</tr>
<tr class="odd">
<td>181</td>
<td>msu.edu</td>
<td>0.15%</td>
<td>26511</td>
</tr>
<tr class="even">
<td>182</td>
<td>ucm.es</td>
<td>0.15%</td>
<td>26422</td>
</tr>
<tr class="odd">
<td>183</td>
<td>cnrs.fr(*)</td>
<td>0.15%</td>
<td>26316</td>
</tr>
<tr class="even">
<td>184</td>
<td>ub.es</td>
<td>0.14%</td>
<td>26130</td>
</tr>
<tr class="odd">
<td>185</td>
<td>nist.gov</td>
<td>0.14%</td>
<td>26075</td>
</tr>
<tr class="even">
<td>186</td>
<td>cuni.cz</td>
<td>0.14%</td>
<td>25998</td>
</tr>
<tr class="odd">
<td>187</td>
<td>uni-jena.de</td>
<td>0.14%</td>
<td>25936</td>
</tr>
<tr class="even">
<td>188</td>
<td>uni-bochum.de</td>
<td>0.14%</td>
<td>25892</td>
</tr>
<tr class="odd">
<td>189</td>
<td>adelaide.edu.au</td>
<td>0.14%</td>
<td>25830</td>
</tr>
<tr class="even">
<td>190</td>
<td>sinica.edu.tw</td>
<td>0.14%</td>
<td>25636</td>
</tr>
<tr class="odd">
<td>191</td>
<td>to.infn.it</td>
<td>0.14%</td>
<td>25581</td>
</tr>
<tr class="even">
<td>192</td>
<td>iastate.edu</td>
<td>0.14%</td>
<td>25526</td>
</tr>
<tr class="odd">
<td>193</td>
<td>unicamp.br</td>
<td>0.14%</td>
<td>25478</td>
</tr>
<tr class="even">
<td>194</td>
<td>anl.gov</td>
<td>0.14%</td>
<td>25333</td>
</tr>
<tr class="odd">
<td>195</td>
<td>kyushu-u.ac.jp</td>
<td>0.14%</td>
<td>25142</td>
</tr>
<tr class="even">
<td>196</td>
<td>sdu.dk</td>
<td>0.14%</td>
<td>25087</td>
</tr>
<tr class="odd">
<td>197</td>
<td>lancs.ac.uk</td>
<td>0.14%</td>
<td>24746</td>
</tr>
<tr class="even">
<td>198</td>
<td>uni-goettingen.de</td>
<td>0.14%</td>
<td>24721</td>
</tr>
<tr class="odd">
<td>199</td>
<td>nikhef.nl</td>
<td>0.14%</td>
<td>24607</td>
</tr>
<tr class="even">
<td>200</td>
<td>pd.infn.it</td>
<td>0.14%</td>
<td>24566</td>
</tr>
</tbody>
</table>

(\*) Some institutions' downloads come from multiple domains which have
been combined to report an aggregate number:

-   cnrs.fr includes downloads from cnrs-orleans.fr.
-   desy.de includes downloads from ifh.de.
-   illinois.edu includes downloads from uiuc.edu.
-   inaf.it includes downloads from astro.it.
-   ku.dk includes downloads from dark-cosmology.dk.
-   manchester.ac.uk includes downloads from man.ac.uk.
-   mpg.de includes downloads from aei.mpg.de, age.mpg.de,
    bgc-jena.mpg.de, biochem.mpg.de, biophys.mpg.de, brain.mpg.de,
    cbs.mpg.de, cec.mpg.de, coll.mpg.de, cpfs.mpg.de, demogr.mpg.de,
    ds.mpg.de, econ.mpg.de, em.mpg.de, enzyme-halle.mpg.de, eva.mpg.de,
    fkf.mpg.de, gwdg.de, hll.mpg.de, ice.mpg.de, ie-freiburg.mpg.de,
    ip.mpg.de, ipp-garching.mpg.de, ipp-hgw.mpg.de, ipp.mpg.de,
    is.mpg.de, iuscrim.mpg.de, mis.mpg.de, mmg.mpg.de, molgen.mpg.de,
    mpa-garching.mpg.de, mpdl.mpg.de, mpe-garching.mpg.de, mpe.mpg.de,
    mpi-dortmund.mpg.de, mpi-fg-koeln.mpg.de, mpi-halle.mpg.de,
    mpi-hd.mpg.de, mpi-inf.mpg.de, mpi-klsb.mpg.de,
    mpi-magdeburg.mpg.de, mpi-muelheim.mpg.de, mpi-sb.mpg.de,
    mpi-stuttgart.mpg.de, mpia-hd.mpg.de, mpibpc.mpg.de,
    mpie-duesseldorf.mpg.de, mpifr-bonn.mpg.de, mpih-frankfurt.mpg.de,
    mpiib-berlin.mpg.de, mpikg.mpg.de, mpim-bonn.mpg.de,
    mpimf-heidelberg.mpg.de, mpimp-golm.mpg.de, mpip-mainz.mpg.de,
    mpipks-dresden.mpg.de, mpipriv-hh.mpg.de, mpipsykl.mpg.de,
    mpipz.mpg.de, mpiwg-berlin.mpg.de, mppmu.mpg.de, mpq.mpg.de,
    mps.mpg.de, neuro.mpg.de, nf.mpg.de, orn.mpg.de, rz-berlin.mpg.de,
    rzg.mpg.de, tuebingen.mpg.de, vw.mpg.de.
-   riken.jp includes downloads from riken.go.jp.
-   stonybrook.edu includes downloads from sunysb.edu.
-   sydney.edu.au includes downloads from usyd.edu.au.
-   tkk.fi includes downloads from hut.fi.
-   tudelft.nl includes downloads from tudelft.net.
-   tum.de includes downloads from tu-muenchen.de.
-   ucsd.edu includes downloads from sdsc.edu.
-   uni-karlsruhe.de includes downloads from fzk.de, kit.edu.
-   upmc.fr includes downloads from jussieu.fr.

Update history:  
2016-01-06 - Usage data for 2015 first posted.  
2016-01-20 - Updated after additional data cleaning.
