2016 Institutional arXiv Usage Data
===================================

The following table is a compilation of arXiv downloads for calendar
year 2016 for the 200 heaviest user institutions. See also [arXiv
Support](../support).

**Caveats:** While we have taken considerable effort to extract reliable
download data representing unique full-text downloads by real users,
there are many factors which affect accuracy. These factors include: 1)
the data is from the main arXiv site and the arXiv mirrors, though some
mirror data is incomplete; 2) we have counted downloads according to the
COUNTER algorithm which excludes rapid repeat downloads; 3) we have
attempted to identify and remove robot or automated downloads from the
count (false positives lead to undercounting, failing to identify robots
leads to overcounting); and 4) we include here only downloads that
appear to be from an institution based on the DNS name of the client for
patterns that we recognize (A large fraction of downloads come from
commercial ISPs which are not included. Clients with host names that
don't resolve or off-campus accesses will lead to undercounting, failure
to recognize institutional domain names will exclude those institutions
and undercount the total institutional downloads.) We have identified
21.2 million downloads from institutional domain names out of a total of
over 162 million downloads in 2016.

<table>
<thead>
<tr class="header">
<th>Rank</th>
<th>Institional domain</th>
<th>Percentage of total<br />
institutional downloads</th>
<th>Number of article downloads</th>
</tr>
</thead>
<tbody>
<tr class="odd">
<td>1</td>
<td>cern.ch</td>
<td>2.18%</td>
<td>462283</td>
</tr>
<tr class="even">
<td>2</td>
<td>u-tokyo.ac.jp</td>
<td>1.88%</td>
<td>400296</td>
</tr>
<tr class="odd">
<td>3</td>
<td>mpg.de(*)</td>
<td>1.85%</td>
<td>393252</td>
</tr>
<tr class="even">
<td>4</td>
<td>cam.ac.uk</td>
<td>1.55%</td>
<td>328921</td>
</tr>
<tr class="odd">
<td>5</td>
<td>mit.edu</td>
<td>1.48%</td>
<td>313570</td>
</tr>
<tr class="even">
<td>6</td>
<td>berkeley.edu</td>
<td>1.34%</td>
<td>284317</td>
</tr>
<tr class="odd">
<td>7</td>
<td>ethz.ch</td>
<td>1.16%</td>
<td>247331</td>
</tr>
<tr class="even">
<td>8</td>
<td>princeton.edu</td>
<td>1.10%</td>
<td>233363</td>
</tr>
<tr class="odd">
<td>9</td>
<td>kyoto-u.ac.jp</td>
<td>1.08%</td>
<td>230047</td>
</tr>
<tr class="even">
<td>10</td>
<td>ox.ac.uk</td>
<td>1.07%</td>
<td>228319</td>
</tr>
<tr class="odd">
<td>11</td>
<td>columbia.edu</td>
<td>0.86%</td>
<td>183097</td>
</tr>
<tr class="even">
<td>12</td>
<td>ic.ac.uk</td>
<td>0.78%</td>
<td>165614</td>
</tr>
<tr class="odd">
<td>13</td>
<td>caltech.edu</td>
<td>0.76%</td>
<td>161805</td>
</tr>
<tr class="even">
<td>14</td>
<td>in2p3.fr</td>
<td>0.76%</td>
<td>161534</td>
</tr>
<tr class="odd">
<td>15</td>
<td>nus.edu.sg</td>
<td>0.74%</td>
<td>157073</td>
</tr>
<tr class="even">
<td>16</td>
<td>illinois.edu(*)</td>
<td>0.73%</td>
<td>155482</td>
</tr>
<tr class="odd">
<td>17</td>
<td>desy.de(*)</td>
<td>0.68%</td>
<td>144630</td>
</tr>
<tr class="even">
<td>18</td>
<td>uva.nl</td>
<td>0.67%</td>
<td>142615</td>
</tr>
<tr class="odd">
<td>19</td>
<td>cornell.edu</td>
<td>0.63%</td>
<td>133649</td>
</tr>
<tr class="even">
<td>20</td>
<td>epfl.ch</td>
<td>0.62%</td>
<td>132233</td>
</tr>
<tr class="odd">
<td>21</td>
<td>uni-bonn.de</td>
<td>0.62%</td>
<td>131815</td>
</tr>
<tr class="even">
<td>22</td>
<td>nyu.edu</td>
<td>0.62%</td>
<td>131427</td>
</tr>
<tr class="odd">
<td>23</td>
<td>harvard.edu</td>
<td>0.62%</td>
<td>131426</td>
</tr>
<tr class="even">
<td>24</td>
<td>ucl.ac.uk</td>
<td>0.61%</td>
<td>129267</td>
</tr>
<tr class="odd">
<td>25</td>
<td>umn.edu</td>
<td>0.57%</td>
<td>121784</td>
</tr>
<tr class="even">
<td>26</td>
<td>ucsb.edu</td>
<td>0.56%</td>
<td>119182</td>
</tr>
<tr class="odd">
<td>27</td>
<td>utexas.edu</td>
<td>0.55%</td>
<td>116681</td>
</tr>
<tr class="even">
<td>28</td>
<td>cuhk.edu.hk</td>
<td>0.54%</td>
<td>115225</td>
</tr>
<tr class="odd">
<td>29</td>
<td>yale.edu</td>
<td>0.54%</td>
<td>115224</td>
</tr>
<tr class="even">
<td>30</td>
<td>stanford.edu</td>
<td>0.54%</td>
<td>114604</td>
</tr>
<tr class="odd">
<td>31</td>
<td>utoronto.ca</td>
<td>0.51%</td>
<td>107752</td>
</tr>
<tr class="even">
<td>32</td>
<td>uwaterloo.ca</td>
<td>0.49%</td>
<td>103920</td>
</tr>
<tr class="odd">
<td>33</td>
<td>gatech.edu</td>
<td>0.49%</td>
<td>103666</td>
</tr>
<tr class="even">
<td>34</td>
<td>uni-heidelberg.de</td>
<td>0.49%</td>
<td>103640</td>
</tr>
<tr class="odd">
<td>35</td>
<td>upenn.edu</td>
<td>0.48%</td>
<td>101901</td>
</tr>
<tr class="even">
<td>36</td>
<td>ust.hk</td>
<td>0.47%</td>
<td>100870</td>
</tr>
<tr class="odd">
<td>37</td>
<td>stonybrook.edu(*)</td>
<td>0.47%</td>
<td>99299</td>
</tr>
<tr class="even">
<td>38</td>
<td>slac.stanford.edu</td>
<td>0.46%</td>
<td>97100</td>
</tr>
<tr class="odd">
<td>39</td>
<td>ed.ac.uk</td>
<td>0.46%</td>
<td>96853</td>
</tr>
<tr class="even">
<td>40</td>
<td>dur.ac.uk</td>
<td>0.44%</td>
<td>94104</td>
</tr>
<tr class="odd">
<td>41</td>
<td>wisc.edu</td>
<td>0.42%</td>
<td>89861</td>
</tr>
<tr class="even">
<td>42</td>
<td>uni-mainz.de</td>
<td>0.42%</td>
<td>88214</td>
</tr>
<tr class="odd">
<td>43</td>
<td>tum.de(*)</td>
<td>0.41%</td>
<td>88112</td>
</tr>
<tr class="even">
<td>44</td>
<td>umd.edu</td>
<td>0.41%</td>
<td>86967</td>
</tr>
<tr class="odd">
<td>45</td>
<td>perimeterinstitute.ca</td>
<td>0.41%</td>
<td>86281</td>
</tr>
<tr class="even">
<td>46</td>
<td>uci.edu</td>
<td>0.40%</td>
<td>84952</td>
</tr>
<tr class="odd">
<td>47</td>
<td>rutgers.edu</td>
<td>0.40%</td>
<td>84788</td>
</tr>
<tr class="even">
<td>48</td>
<td>tohoku.ac.jp</td>
<td>0.40%</td>
<td>84562</td>
</tr>
<tr class="odd">
<td>49</td>
<td>cmu.edu</td>
<td>0.40%</td>
<td>84499</td>
</tr>
<tr class="even">
<td>50</td>
<td>nagoya-u.ac.jp</td>
<td>0.39%</td>
<td>83860</td>
</tr>
<tr class="odd">
<td>51</td>
<td>usp.br</td>
<td>0.39%</td>
<td>83828</td>
</tr>
<tr class="even">
<td>52</td>
<td>ias.edu</td>
<td>0.39%</td>
<td>82651</td>
</tr>
<tr class="odd">
<td>53</td>
<td>colorado.edu</td>
<td>0.39%</td>
<td>82159</td>
</tr>
<tr class="even">
<td>54</td>
<td>uni-karlsruhe.de(*)</td>
<td>0.39%</td>
<td>81826</td>
</tr>
<tr class="odd">
<td>55</td>
<td>sissa.it</td>
<td>0.37%</td>
<td>79487</td>
</tr>
<tr class="even">
<td>56</td>
<td>rug.nl</td>
<td>0.37%</td>
<td>78449</td>
</tr>
<tr class="odd">
<td>57</td>
<td>tamu.edu</td>
<td>0.37%</td>
<td>78333</td>
</tr>
<tr class="even">
<td>58</td>
<td>ubc.ca</td>
<td>0.37%</td>
<td>77607</td>
</tr>
<tr class="odd">
<td>59</td>
<td>ntu.edu.tw</td>
<td>0.36%</td>
<td>77208</td>
</tr>
<tr class="even">
<td>60</td>
<td>bris.ac.uk</td>
<td>0.36%</td>
<td>75921</td>
</tr>
<tr class="odd">
<td>61</td>
<td>inaf.it(*)</td>
<td>0.36%</td>
<td>75895</td>
</tr>
<tr class="even">
<td>62</td>
<td>cea.fr</td>
<td>0.36%</td>
<td>75828</td>
</tr>
<tr class="odd">
<td>63</td>
<td>tkk.fi(*)</td>
<td>0.36%</td>
<td>75621</td>
</tr>
<tr class="even">
<td>64</td>
<td>upmc.fr(*)</td>
<td>0.35%</td>
<td>74728</td>
</tr>
<tr class="odd">
<td>65</td>
<td>osaka-u.ac.jp</td>
<td>0.35%</td>
<td>74570</td>
</tr>
<tr class="even">
<td>66</td>
<td>washington.edu</td>
<td>0.35%</td>
<td>73863</td>
</tr>
<tr class="odd">
<td>67</td>
<td>purdue.edu</td>
<td>0.35%</td>
<td>73527</td>
</tr>
<tr class="even">
<td>68</td>
<td>rwth-aachen.de</td>
<td>0.35%</td>
<td>73464</td>
</tr>
<tr class="odd">
<td>69</td>
<td>psu.edu</td>
<td>0.33%</td>
<td>70804</td>
</tr>
<tr class="even">
<td>70</td>
<td>tudelft.nl(*)</td>
<td>0.33%</td>
<td>70664</td>
</tr>
<tr class="odd">
<td>71</td>
<td>riken.jp(*)</td>
<td>0.33%</td>
<td>70431</td>
</tr>
<tr class="even">
<td>72</td>
<td>ucla.edu</td>
<td>0.33%</td>
<td>69970</td>
</tr>
<tr class="odd">
<td>73</td>
<td>uni-muenchen.de(*)</td>
<td>0.33%</td>
<td>69191</td>
</tr>
<tr class="even">
<td>74</td>
<td>ens.fr</td>
<td>0.32%</td>
<td>68972</td>
</tr>
<tr class="odd">
<td>75</td>
<td>sydney.edu.au(*)</td>
<td>0.31%</td>
<td>66646</td>
</tr>
<tr class="even">
<td>76</td>
<td>northwestern.edu</td>
<td>0.31%</td>
<td>66493</td>
</tr>
<tr class="odd">
<td>77</td>
<td>univie.ac.at</td>
<td>0.31%</td>
<td>66294</td>
</tr>
<tr class="even">
<td>78</td>
<td>ictp.it</td>
<td>0.31%</td>
<td>64919</td>
</tr>
<tr class="odd">
<td>79</td>
<td>csic.es</td>
<td>0.29%</td>
<td>60651</td>
</tr>
<tr class="even">
<td>80</td>
<td>usc.edu</td>
<td>0.29%</td>
<td>60627</td>
</tr>
<tr class="odd">
<td>81</td>
<td>manchester.ac.uk(*)</td>
<td>0.28%</td>
<td>60011</td>
</tr>
<tr class="even">
<td>82</td>
<td>uchicago.edu</td>
<td>0.28%</td>
<td>59935</td>
</tr>
<tr class="odd">
<td>83</td>
<td>tu-berlin.de</td>
<td>0.28%</td>
<td>59102</td>
</tr>
<tr class="even">
<td>84</td>
<td>uni-frankfurt.de</td>
<td>0.28%</td>
<td>58595</td>
</tr>
<tr class="odd">
<td>85</td>
<td>uv.es</td>
<td>0.27%</td>
<td>58300</td>
</tr>
<tr class="even">
<td>86</td>
<td>umass.edu</td>
<td>0.27%</td>
<td>57552</td>
</tr>
<tr class="odd">
<td>87</td>
<td>u-psud.fr</td>
<td>0.27%</td>
<td>56827</td>
</tr>
<tr class="even">
<td>88</td>
<td>bnl.gov</td>
<td>0.27%</td>
<td>56745</td>
</tr>
<tr class="odd">
<td>89</td>
<td>umich.edu</td>
<td>0.26%</td>
<td>55953</td>
</tr>
<tr class="even">
<td>90</td>
<td>warwick.ac.uk</td>
<td>0.26%</td>
<td>55736</td>
</tr>
<tr class="odd">
<td>91</td>
<td>uzh.ch</td>
<td>0.26%</td>
<td>55691</td>
</tr>
<tr class="even">
<td>92</td>
<td>tu-darmstadt.de</td>
<td>0.26%</td>
<td>54419</td>
</tr>
<tr class="odd">
<td>93</td>
<td>uni-muenster.de</td>
<td>0.26%</td>
<td>54364</td>
</tr>
<tr class="even">
<td>94</td>
<td>inria.fr</td>
<td>0.25%</td>
<td>53382</td>
</tr>
<tr class="odd">
<td>95</td>
<td>kek.jp</td>
<td>0.25%</td>
<td>53276</td>
</tr>
<tr class="even">
<td>96</td>
<td>ufl.edu</td>
<td>0.25%</td>
<td>53098</td>
</tr>
<tr class="odd">
<td>97</td>
<td>bu.edu</td>
<td>0.25%</td>
<td>52921</td>
</tr>
<tr class="even">
<td>98</td>
<td>uu.se</td>
<td>0.25%</td>
<td>52685</td>
</tr>
<tr class="odd">
<td>99</td>
<td>ucdavis.edu</td>
<td>0.25%</td>
<td>52632</td>
</tr>
<tr class="even">
<td>100</td>
<td>kth.se</td>
<td>0.25%</td>
<td>52279</td>
</tr>
<tr class="odd">
<td>101</td>
<td>tau.ac.il</td>
<td>0.25%</td>
<td>52069</td>
</tr>
<tr class="even">
<td>102</td>
<td>ucsd.edu(*)</td>
<td>0.24%</td>
<td>51259</td>
</tr>
<tr class="odd">
<td>103</td>
<td>tuwien.ac.at</td>
<td>0.24%</td>
<td>50776</td>
</tr>
<tr class="even">
<td>104</td>
<td>mcgill.ca</td>
<td>0.24%</td>
<td>50710</td>
</tr>
<tr class="odd">
<td>105</td>
<td>chalmers.se</td>
<td>0.24%</td>
<td>50689</td>
</tr>
<tr class="even">
<td>106</td>
<td>uni-hamburg.de</td>
<td>0.24%</td>
<td>50107</td>
</tr>
<tr class="odd">
<td>107</td>
<td>ulb.ac.be</td>
<td>0.23%</td>
<td>49712</td>
</tr>
<tr class="even">
<td>108</td>
<td>uni-koeln.de</td>
<td>0.23%</td>
<td>49655</td>
</tr>
<tr class="odd">
<td>109</td>
<td>uni-regensburg.de</td>
<td>0.23%</td>
<td>49359</td>
</tr>
<tr class="even">
<td>110</td>
<td>unimelb.edu.au</td>
<td>0.23%</td>
<td>48736</td>
</tr>
<tr class="odd">
<td>111</td>
<td>nthu.edu.tw</td>
<td>0.23%</td>
<td>47909</td>
</tr>
<tr class="even">
<td>112</td>
<td>su.se</td>
<td>0.23%</td>
<td>47907</td>
</tr>
<tr class="odd">
<td>113</td>
<td>ohio-state.edu</td>
<td>0.22%</td>
<td>47197</td>
</tr>
<tr class="even">
<td>114</td>
<td>helsinki.fi</td>
<td>0.22%</td>
<td>47153</td>
</tr>
<tr class="odd">
<td>115</td>
<td>duke.edu</td>
<td>0.22%</td>
<td>46925</td>
</tr>
<tr class="even">
<td>116</td>
<td>ru.nl</td>
<td>0.22%</td>
<td>46601</td>
</tr>
<tr class="odd">
<td>117</td>
<td>unige.ch</td>
<td>0.22%</td>
<td>46392</td>
</tr>
<tr class="even">
<td>118</td>
<td>ualberta.ca</td>
<td>0.22%</td>
<td>46061</td>
</tr>
<tr class="odd">
<td>119</td>
<td>soton.ac.uk</td>
<td>0.22%</td>
<td>45992</td>
</tr>
<tr class="even">
<td>120</td>
<td>indiana.edu</td>
<td>0.21%</td>
<td>45604</td>
</tr>
<tr class="odd">
<td>121</td>
<td>af.mil</td>
<td>0.21%</td>
<td>45598</td>
</tr>
<tr class="even">
<td>122</td>
<td>jinr.ru</td>
<td>0.21%</td>
<td>45527</td>
</tr>
<tr class="odd">
<td>123</td>
<td>prl.res.in</td>
<td>0.21%</td>
<td>45404</td>
</tr>
<tr class="even">
<td>124</td>
<td>uni-hannover.de</td>
<td>0.21%</td>
<td>45376</td>
</tr>
<tr class="odd">
<td>125</td>
<td>uni-stuttgart.de</td>
<td>0.21%</td>
<td>44602</td>
</tr>
<tr class="even">
<td>126</td>
<td>unibas.ch</td>
<td>0.21%</td>
<td>44392</td>
</tr>
<tr class="odd">
<td>127</td>
<td>leidenuniv.nl</td>
<td>0.21%</td>
<td>44335</td>
</tr>
<tr class="even">
<td>128</td>
<td>navy.mil</td>
<td>0.20%</td>
<td>43231</td>
</tr>
<tr class="odd">
<td>129</td>
<td>lanl.gov</td>
<td>0.20%</td>
<td>42683</td>
</tr>
<tr class="even">
<td>130</td>
<td>unc.edu</td>
<td>0.20%</td>
<td>42614</td>
</tr>
<tr class="odd">
<td>131</td>
<td>uni-freiburg.de</td>
<td>0.20%</td>
<td>42506</td>
</tr>
<tr class="even">
<td>132</td>
<td>unibe.ch</td>
<td>0.20%</td>
<td>42200</td>
</tr>
<tr class="odd">
<td>133</td>
<td>uibk.ac.at</td>
<td>0.20%</td>
<td>42105</td>
</tr>
<tr class="even">
<td>134</td>
<td>nbi.dk</td>
<td>0.20%</td>
<td>42063</td>
</tr>
<tr class="odd">
<td>135</td>
<td>waseda.ac.jp</td>
<td>0.20%</td>
<td>41913</td>
</tr>
<tr class="even">
<td>136</td>
<td>monash.edu.au</td>
<td>0.20%</td>
<td>41677</td>
</tr>
<tr class="odd">
<td>137</td>
<td>fu-berlin.de</td>
<td>0.20%</td>
<td>41539</td>
</tr>
<tr class="even">
<td>138</td>
<td>umontreal.ca</td>
<td>0.20%</td>
<td>41470</td>
</tr>
<tr class="odd">
<td>139</td>
<td>postech.ac.kr</td>
<td>0.19%</td>
<td>41403</td>
</tr>
<tr class="even">
<td>140</td>
<td>huji.ac.il</td>
<td>0.19%</td>
<td>40610</td>
</tr>
<tr class="odd">
<td>141</td>
<td>u-strasbg.fr</td>
<td>0.19%</td>
<td>40607</td>
</tr>
<tr class="even">
<td>142</td>
<td>nao.ac.jp</td>
<td>0.19%</td>
<td>40500</td>
</tr>
<tr class="odd">
<td>143</td>
<td>hu-berlin.de</td>
<td>0.19%</td>
<td>39801</td>
</tr>
<tr class="even">
<td>144</td>
<td>uni-erlangen.de</td>
<td>0.19%</td>
<td>39797</td>
</tr>
<tr class="odd">
<td>145</td>
<td>susx.ac.uk</td>
<td>0.19%</td>
<td>39527</td>
</tr>
<tr class="even">
<td>146</td>
<td>asu.edu</td>
<td>0.18%</td>
<td>38958</td>
</tr>
<tr class="odd">
<td>147</td>
<td>ku.dk(*)</td>
<td>0.18%</td>
<td>38264</td>
</tr>
<tr class="even">
<td>148</td>
<td>sinica.edu.tw</td>
<td>0.18%</td>
<td>38245</td>
</tr>
<tr class="odd">
<td>149</td>
<td>hri.res.in</td>
<td>0.18%</td>
<td>37746</td>
</tr>
<tr class="even">
<td>150</td>
<td>arizona.edu</td>
<td>0.18%</td>
<td>37570</td>
</tr>
<tr class="odd">
<td>151</td>
<td>titech.ac.jp</td>
<td>0.18%</td>
<td>37567</td>
</tr>
<tr class="even">
<td>152</td>
<td>vt.edu</td>
<td>0.17%</td>
<td>36879</td>
</tr>
<tr class="odd">
<td>153</td>
<td>hokudai.ac.jp</td>
<td>0.17%</td>
<td>36822</td>
</tr>
<tr class="even">
<td>154</td>
<td>shef.ac.uk</td>
<td>0.17%</td>
<td>36669</td>
</tr>
<tr class="odd">
<td>155</td>
<td>uq.edu.au</td>
<td>0.17%</td>
<td>36537</td>
</tr>
<tr class="even">
<td>156</td>
<td>ntnu.no</td>
<td>0.17%</td>
<td>36257</td>
</tr>
<tr class="odd">
<td>157</td>
<td>uni-wuerzburg.de</td>
<td>0.17%</td>
<td>36192</td>
</tr>
<tr class="even">
<td>158</td>
<td>leeds.ac.uk</td>
<td>0.17%</td>
<td>35810</td>
</tr>
<tr class="odd">
<td>159</td>
<td>cuni.cz</td>
<td>0.17%</td>
<td>35763</td>
</tr>
<tr class="even">
<td>160</td>
<td>keio.ac.jp</td>
<td>0.17%</td>
<td>35653</td>
</tr>
<tr class="odd">
<td>161</td>
<td>uni-tuebingen.de</td>
<td>0.17%</td>
<td>35349</td>
</tr>
<tr class="even">
<td>162</td>
<td>ugent.be</td>
<td>0.16%</td>
<td>35026</td>
</tr>
<tr class="odd">
<td>163</td>
<td>uio.no</td>
<td>0.16%</td>
<td>34665</td>
</tr>
<tr class="even">
<td>164</td>
<td>nd.edu</td>
<td>0.16%</td>
<td>34582</td>
</tr>
<tr class="odd">
<td>165</td>
<td>anu.edu.au</td>
<td>0.16%</td>
<td>34480</td>
</tr>
<tr class="even">
<td>166</td>
<td>iastate.edu</td>
<td>0.16%</td>
<td>34110</td>
</tr>
<tr class="odd">
<td>167</td>
<td>tifr.res.in</td>
<td>0.16%</td>
<td>33788</td>
</tr>
<tr class="even">
<td>168</td>
<td>nctu.edu.tw</td>
<td>0.16%</td>
<td>33579</td>
</tr>
<tr class="odd">
<td>169</td>
<td>kcl.ac.uk</td>
<td>0.16%</td>
<td>33533</td>
</tr>
<tr class="even">
<td>170</td>
<td>qmul.ac.uk</td>
<td>0.16%</td>
<td>33430</td>
</tr>
<tr class="odd">
<td>171</td>
<td>unicamp.br</td>
<td>0.15%</td>
<td>32659</td>
</tr>
<tr class="even">
<td>172</td>
<td>uni-jena.de</td>
<td>0.15%</td>
<td>32397</td>
</tr>
<tr class="odd">
<td>173</td>
<td>ens-lyon.fr</td>
<td>0.15%</td>
<td>31872</td>
</tr>
<tr class="even">
<td>174</td>
<td>polytechnique.fr</td>
<td>0.15%</td>
<td>31858</td>
</tr>
<tr class="odd">
<td>175</td>
<td>kyushu-u.ac.jp</td>
<td>0.15%</td>
<td>31514</td>
</tr>
<tr class="even">
<td>176</td>
<td>ucsc.edu</td>
<td>0.15%</td>
<td>31245</td>
</tr>
<tr class="odd">
<td>177</td>
<td>unitn.it</td>
<td>0.15%</td>
<td>31219</td>
</tr>
<tr class="even">
<td>178</td>
<td>lancs.ac.uk</td>
<td>0.15%</td>
<td>31001</td>
</tr>
<tr class="odd">
<td>179</td>
<td>univ-lyon1.fr</td>
<td>0.14%</td>
<td>30640</td>
</tr>
<tr class="even">
<td>180</td>
<td>tu-dortmund.de(*)</td>
<td>0.14%</td>
<td>29865</td>
</tr>
<tr class="odd">
<td>181</td>
<td>utah.edu</td>
<td>0.14%</td>
<td>29652</td>
</tr>
<tr class="even">
<td>182</td>
<td>uni-ulm.de</td>
<td>0.14%</td>
<td>29632</td>
</tr>
<tr class="odd">
<td>183</td>
<td>unsw.edu.au</td>
<td>0.14%</td>
<td>29543</td>
</tr>
<tr class="even">
<td>184</td>
<td>toronto.edu</td>
<td>0.14%</td>
<td>29435</td>
</tr>
<tr class="odd">
<td>185</td>
<td>kfa-juelich.de</td>
<td>0.14%</td>
<td>29411</td>
</tr>
<tr class="even">
<td>186</td>
<td>ehu.es</td>
<td>0.14%</td>
<td>29386</td>
</tr>
<tr class="odd">
<td>187</td>
<td>uni-bochum.de</td>
<td>0.14%</td>
<td>29026</td>
</tr>
<tr class="even">
<td>188</td>
<td>unlp.edu.ar</td>
<td>0.14%</td>
<td>28986</td>
</tr>
<tr class="odd">
<td>189</td>
<td>adelaide.edu.au</td>
<td>0.14%</td>
<td>28951</td>
</tr>
<tr class="even">
<td>190</td>
<td>jhu.edu</td>
<td>0.14%</td>
<td>28898</td>
</tr>
<tr class="odd">
<td>191</td>
<td>jyu.fi</td>
<td>0.14%</td>
<td>28896</td>
</tr>
<tr class="even">
<td>192</td>
<td>uni-saarland.de(*)</td>
<td>0.14%</td>
<td>28895</td>
</tr>
<tr class="odd">
<td>193</td>
<td>msu.edu</td>
<td>0.14%</td>
<td>28860</td>
</tr>
<tr class="even">
<td>194</td>
<td>ub.es</td>
<td>0.14%</td>
<td>28743</td>
</tr>
<tr class="odd">
<td>195</td>
<td>uic.edu</td>
<td>0.13%</td>
<td>28516</td>
</tr>
<tr class="even">
<td>196</td>
<td>uoregon.edu</td>
<td>0.13%</td>
<td>28478</td>
</tr>
<tr class="odd">
<td>197</td>
<td>lu.se</td>
<td>0.13%</td>
<td>28335</td>
</tr>
<tr class="even">
<td>198</td>
<td>tu-graz.ac.at</td>
<td>0.13%</td>
<td>28254</td>
</tr>
<tr class="odd">
<td>199</td>
<td>uni-bielefeld.de</td>
<td>0.13%</td>
<td>28207</td>
</tr>
<tr class="even">
<td>200</td>
<td>uam.es</td>
<td>0.13%</td>
<td>28036</td>
</tr>
</tbody>
</table>

(\*) Some institutions' downloads come from multiple domains which have
been combined to report an aggregate number:

-   desy.de includes downloads from ifh.de.
-   illinois.edu includes downloads from uiuc.edu.
-   inaf.it includes downloads from astro.it.
-   ku.dk includes downloads from dark-cosmology.dk.
-   manchester.ac.uk includes downloads from man.ac.uk.
-   mpg.de includes downloads from aei.mpg.de, age.mpg.de,
    bgc-jena.mpg.de, biochem.mpg.de, biophys.mpg.de, brain.mpg.de,
    cbs.mpg.de, cec.mpg.de, coll.mpg.de, cpfs.mpg.de, demogr.mpg.de,
    ds.mpg.de, econ.mpg.de, em.mpg.de, enzyme-halle.mpg.de, eva.mpg.de,
    fhi-berlin.mpg.de, fkf.mpg.de, gwdg.de, hll.mpg.de, ice.mpg.de,
    ie-freiburg.mpg.de, ip.mpg.de, ipp-hgw.mpg.de, ipp.mpg.de,
    is.mpg.de, mis.mpg.de, mmg.mpg.de, molgen.mpg.de,
    mpa-garching.mpg.de, mpcdf.mpg.de, mpdl.mpg.de, mpe-garching.mpg.de,
    mpe.mpg.de, mpi-dortmund.mpg.de, mpi-fg-koeln.mpg.de,
    mpi-halle.mpg.de, mpi-hd.mpg.de, mpi-inf.mpg.de, mpi-klsb.mpg.de,
    mpi-magdeburg.mpg.de, mpi-muelheim.mpg.de, mpi-sb.mpg.de,
    mpi-stuttgart.mpg.de, mpia-hd.mpg.de, mpibpc.mpg.de,
    mpie-duesseldorf.mpg.de, mpifr-bonn.mpg.de, mpih-frankfurt.mpg.de,
    mpiib-berlin.mpg.de, mpikg.mpg.de, mpim-bonn.mpg.de,
    mpimp-golm.mpg.de, mpip-mainz.mpg.de, mpipks-dresden.mpg.de,
    mpipriv-hh.mpg.de, mpipz.mpg.de, mpiwg-berlin.mpg.de, mppmu.mpg.de,
    mpq.mpg.de, mps.mpg.de, neuro.mpg.de, nf.mpg.de, orn.mpg.de,
    psych.mpg.de, rz-berlin.mpg.de, rzg.mpg.de, shh.mpg.de,
    tuebingen.mpg.de, vw.mpg.de.
-   riken.jp includes downloads from riken.go.jp.
-   stonybrook.edu includes downloads from sunysb.edu.
-   sydney.edu.au includes downloads from usyd.edu.au.
-   tkk.fi includes downloads from aalto.fi, hut.fi.
-   tu-dortmund.de includes downloads from uni-dortmund.de.
-   tudelft.nl includes downloads from tudelft.net.
-   tum.de includes downloads from tu-muenchen.de.
-   ucsd.edu includes downloads from sdsc.edu.
-   uni-karlsruhe.de includes downloads from fzk.de, kit.edu.
-   uni-muenchen.de includes downloads from lmu.de.
-   uni-saarland.de includes downloads from uni-sb.de.
-   upmc.fr includes downloads from jussieu.fr.

Update history:  
2017-02-09 - Usage data for 2016 first posted.
