2017 Institutional arXiv Usage Data
===================================

The following table is a compilation of arXiv downloads for calendar
year 2017 for the 200 heaviest user institutions. See also [arXiv
Support](../support).

**Caveats:** While we have taken considerable effort to extract reliable
download data representing unique full-text downloads by real users,
there are many factors which affect accuracy. These factors include: 1)
the data is from the main arXiv site and the arXiv mirrors, though some
mirror data is incomplete; 2) we have counted downloads according to the
COUNTER algorithm which excludes rapid repeat downloads; 3) we have
attempted to identify and remove robot or automated downloads from the
count (false positives lead to undercounting, failing to identify robots
leads to overcounting); and 4) we include here only downloads that
appear to be from an institution based on the DNS name of the client for
patterns that we recognize (A large fraction of downloads come from
commercial ISPs which are not included. Clients with host names that
don't resolve or off-campus accesses will lead to undercounting, failure
to recognize institutional domain names will exclude those institutions
and undercount the total institutional downloads.) We have identified
23.3 million downloads from institutional domain names out of a total of
over 180 million downloads in 2017.

<table>
<thead>
<tr class="header">
<th>Rank</th>
<th>Institional domain</th>
<th>Percentage of total<br />
institutional downloads</th>
<th>Number of article downloads</th>
</tr>
</thead>
<tbody>
<tr class="odd">
<td>1</td>
<td>mit.edu</td>
<td>1.77%</td>
<td>412356</td>
</tr>
<tr class="even">
<td>2</td>
<td>berkeley.edu</td>
<td>1.65%</td>
<td>385295</td>
</tr>
<tr class="odd">
<td>3</td>
<td>mpg.de(*)</td>
<td>1.65%</td>
<td>385275</td>
</tr>
<tr class="even">
<td>4</td>
<td>cam.ac.uk</td>
<td>1.64%</td>
<td>382000</td>
</tr>
<tr class="odd">
<td>5</td>
<td>ethz.ch</td>
<td>1.25%</td>
<td>291645</td>
</tr>
<tr class="even">
<td>6</td>
<td>ox.ac.uk</td>
<td>1.20%</td>
<td>280342</td>
</tr>
<tr class="odd">
<td>7</td>
<td>princeton.edu</td>
<td>1.17%</td>
<td>272190</td>
</tr>
<tr class="even">
<td>8</td>
<td>cern.ch</td>
<td>1.15%</td>
<td>267448</td>
</tr>
<tr class="odd">
<td>9</td>
<td>in2p3.fr</td>
<td>1.08%</td>
<td>252652</td>
</tr>
<tr class="even">
<td>10</td>
<td>kyoto-u.ac.jp</td>
<td>1.00%</td>
<td>232023</td>
</tr>
<tr class="odd">
<td>11</td>
<td>u-tokyo.ac.jp</td>
<td>0.99%</td>
<td>230576</td>
</tr>
<tr class="even">
<td>12</td>
<td>columbia.edu</td>
<td>0.98%</td>
<td>228862</td>
</tr>
<tr class="odd">
<td>13</td>
<td>illinois.edu(*)</td>
<td>0.93%</td>
<td>216461</td>
</tr>
<tr class="even">
<td>14</td>
<td>ic.ac.uk</td>
<td>0.92%</td>
<td>215088</td>
</tr>
<tr class="odd">
<td>15</td>
<td>caltech.edu</td>
<td>0.84%</td>
<td>194921</td>
</tr>
<tr class="even">
<td>16</td>
<td>cornell.edu</td>
<td>0.75%</td>
<td>175480</td>
</tr>
<tr class="odd">
<td>17</td>
<td>gatech.edu</td>
<td>0.72%</td>
<td>166693</td>
</tr>
<tr class="even">
<td>18</td>
<td>ucl.ac.uk</td>
<td>0.71%</td>
<td>165715</td>
</tr>
<tr class="odd">
<td>19</td>
<td>epfl.ch</td>
<td>0.70%</td>
<td>162488</td>
</tr>
<tr class="even">
<td>20</td>
<td>umd.edu</td>
<td>0.70%</td>
<td>162369</td>
</tr>
<tr class="odd">
<td>21</td>
<td>cuhk.edu.hk</td>
<td>0.70%</td>
<td>162231</td>
</tr>
<tr class="even">
<td>22</td>
<td>uva.nl</td>
<td>0.68%</td>
<td>159070</td>
</tr>
<tr class="odd">
<td>23</td>
<td>nyu.edu</td>
<td>0.67%</td>
<td>156427</td>
</tr>
<tr class="even">
<td>24</td>
<td>ucsb.edu</td>
<td>0.66%</td>
<td>154003</td>
</tr>
<tr class="odd">
<td>25</td>
<td>umn.edu</td>
<td>0.66%</td>
<td>152652</td>
</tr>
<tr class="even">
<td>26</td>
<td>harvard.edu</td>
<td>0.63%</td>
<td>147905</td>
</tr>
<tr class="odd">
<td>27</td>
<td>utexas.edu</td>
<td>0.62%</td>
<td>144310</td>
</tr>
<tr class="even">
<td>28</td>
<td>utoronto.ca</td>
<td>0.62%</td>
<td>143778</td>
</tr>
<tr class="odd">
<td>29</td>
<td>uwaterloo.ca</td>
<td>0.61%</td>
<td>141945</td>
</tr>
<tr class="even">
<td>30</td>
<td>ed.ac.uk</td>
<td>0.60%</td>
<td>140097</td>
</tr>
<tr class="odd">
<td>31</td>
<td>desy.de(*)</td>
<td>0.60%</td>
<td>139058</td>
</tr>
<tr class="even">
<td>32</td>
<td>ust.hk</td>
<td>0.59%</td>
<td>137766</td>
</tr>
<tr class="odd">
<td>33</td>
<td>uni-bonn.de</td>
<td>0.58%</td>
<td>135097</td>
</tr>
<tr class="even">
<td>34</td>
<td>uni-heidelberg.de</td>
<td>0.55%</td>
<td>128135</td>
</tr>
<tr class="odd">
<td>35</td>
<td>stonybrook.edu(*)</td>
<td>0.54%</td>
<td>125345</td>
</tr>
<tr class="even">
<td>36</td>
<td>upenn.edu</td>
<td>0.54%</td>
<td>125303</td>
</tr>
<tr class="odd">
<td>37</td>
<td>rutgers.edu</td>
<td>0.52%</td>
<td>122013</td>
</tr>
<tr class="even">
<td>38</td>
<td>uni-karlsruhe.de(*)</td>
<td>0.51%</td>
<td>118203</td>
</tr>
<tr class="odd">
<td>39</td>
<td>wisc.edu</td>
<td>0.50%</td>
<td>117469</td>
</tr>
<tr class="even">
<td>40</td>
<td>stanford.edu</td>
<td>0.49%</td>
<td>114604</td>
</tr>
<tr class="odd">
<td>41</td>
<td>yale.edu</td>
<td>0.49%</td>
<td>114384</td>
</tr>
<tr class="even">
<td>42</td>
<td>ucla.edu</td>
<td>0.48%</td>
<td>112951</td>
</tr>
<tr class="odd">
<td>43</td>
<td>cmu.edu</td>
<td>0.48%</td>
<td>112911</td>
</tr>
<tr class="even">
<td>44</td>
<td>ntu.edu.tw</td>
<td>0.45%</td>
<td>105796</td>
</tr>
<tr class="odd">
<td>45</td>
<td>purdue.edu</td>
<td>0.45%</td>
<td>104604</td>
</tr>
<tr class="even">
<td>46</td>
<td>ubc.ca</td>
<td>0.43%</td>
<td>99789</td>
</tr>
<tr class="odd">
<td>47</td>
<td>usc.edu</td>
<td>0.43%</td>
<td>99270</td>
</tr>
<tr class="even">
<td>48</td>
<td>uci.edu</td>
<td>0.42%</td>
<td>98186</td>
</tr>
<tr class="odd">
<td>49</td>
<td>dur.ac.uk</td>
<td>0.42%</td>
<td>97796</td>
</tr>
<tr class="even">
<td>50</td>
<td>nus.edu.sg</td>
<td>0.41%</td>
<td>95481</td>
</tr>
<tr class="odd">
<td>51</td>
<td>tudelft.nl(*)</td>
<td>0.41%</td>
<td>95204</td>
</tr>
<tr class="even">
<td>52</td>
<td>colorado.edu</td>
<td>0.41%</td>
<td>95097</td>
</tr>
<tr class="odd">
<td>53</td>
<td>tohoku.ac.jp</td>
<td>0.40%</td>
<td>93803</td>
</tr>
<tr class="even">
<td>54</td>
<td>uni-mainz.de</td>
<td>0.38%</td>
<td>89546</td>
</tr>
<tr class="odd">
<td>55</td>
<td>washington.edu</td>
<td>0.38%</td>
<td>89197</td>
</tr>
<tr class="even">
<td>56</td>
<td>osaka-u.ac.jp</td>
<td>0.37%</td>
<td>86631</td>
</tr>
<tr class="odd">
<td>57</td>
<td>rwth-aachen.de</td>
<td>0.37%</td>
<td>85717</td>
</tr>
<tr class="even">
<td>58</td>
<td>northwestern.edu</td>
<td>0.37%</td>
<td>85449</td>
</tr>
<tr class="odd">
<td>59</td>
<td>nagoya-u.ac.jp</td>
<td>0.37%</td>
<td>85253</td>
</tr>
<tr class="even">
<td>60</td>
<td>tum.de(*)</td>
<td>0.36%</td>
<td>84471</td>
</tr>
<tr class="odd">
<td>61</td>
<td>cea.fr</td>
<td>0.36%</td>
<td>84083</td>
</tr>
<tr class="even">
<td>62</td>
<td>ias.edu</td>
<td>0.36%</td>
<td>83363</td>
</tr>
<tr class="odd">
<td>63</td>
<td>ucsd.edu(*)</td>
<td>0.36%</td>
<td>82887</td>
</tr>
<tr class="even">
<td>64</td>
<td>usp.br</td>
<td>0.36%</td>
<td>82778</td>
</tr>
<tr class="odd">
<td>65</td>
<td>sissa.it</td>
<td>0.35%</td>
<td>82485</td>
</tr>
<tr class="even">
<td>66</td>
<td>nthu.edu.tw</td>
<td>0.35%</td>
<td>82459</td>
</tr>
<tr class="odd">
<td>67</td>
<td>sydney.edu.au(*)</td>
<td>0.34%</td>
<td>80343</td>
</tr>
<tr class="even">
<td>68</td>
<td>bris.ac.uk</td>
<td>0.34%</td>
<td>80001</td>
</tr>
<tr class="odd">
<td>69</td>
<td>univie.ac.at</td>
<td>0.33%</td>
<td>77543</td>
</tr>
<tr class="even">
<td>70</td>
<td>bu.edu</td>
<td>0.33%</td>
<td>77034</td>
</tr>
<tr class="odd">
<td>71</td>
<td>riken.jp(*)</td>
<td>0.33%</td>
<td>76350</td>
</tr>
<tr class="even">
<td>72</td>
<td>uchicago.edu</td>
<td>0.30%</td>
<td>69970</td>
</tr>
<tr class="odd">
<td>73</td>
<td>ufl.edu</td>
<td>0.29%</td>
<td>68698</td>
</tr>
<tr class="even">
<td>74</td>
<td>upmc.fr(*)</td>
<td>0.29%</td>
<td>68574</td>
</tr>
<tr class="odd">
<td>75</td>
<td>umich.edu</td>
<td>0.29%</td>
<td>68374</td>
</tr>
<tr class="even">
<td>76</td>
<td>umass.edu</td>
<td>0.29%</td>
<td>68313</td>
</tr>
<tr class="odd">
<td>77</td>
<td>ucdavis.edu</td>
<td>0.29%</td>
<td>67379</td>
</tr>
<tr class="even">
<td>78</td>
<td>uv.es</td>
<td>0.29%</td>
<td>66888</td>
</tr>
<tr class="odd">
<td>79</td>
<td>uzh.ch</td>
<td>0.29%</td>
<td>66579</td>
</tr>
<tr class="even">
<td>80</td>
<td>uni-hamburg.de</td>
<td>0.28%</td>
<td>66337</td>
</tr>
<tr class="odd">
<td>81</td>
<td>warwick.ac.uk</td>
<td>0.28%</td>
<td>66213</td>
</tr>
<tr class="even">
<td>82</td>
<td>uni-freiburg.de</td>
<td>0.28%</td>
<td>65903</td>
</tr>
<tr class="odd">
<td>83</td>
<td>inaf.it(*)</td>
<td>0.28%</td>
<td>65654</td>
</tr>
<tr class="even">
<td>84</td>
<td>tu-darmstadt.de</td>
<td>0.27%</td>
<td>63729</td>
</tr>
<tr class="odd">
<td>85</td>
<td>su.se</td>
<td>0.27%</td>
<td>62944</td>
</tr>
<tr class="even">
<td>86</td>
<td>chalmers.se</td>
<td>0.27%</td>
<td>62355</td>
</tr>
<tr class="odd">
<td>87</td>
<td>tu-berlin.de</td>
<td>0.27%</td>
<td>61941</td>
</tr>
<tr class="even">
<td>88</td>
<td>psu.edu</td>
<td>0.26%</td>
<td>61758</td>
</tr>
<tr class="odd">
<td>89</td>
<td>nctu.edu.tw</td>
<td>0.26%</td>
<td>61365</td>
</tr>
<tr class="even">
<td>90</td>
<td>indiana.edu</td>
<td>0.26%</td>
<td>61341</td>
</tr>
<tr class="odd">
<td>91</td>
<td>ictp.it</td>
<td>0.26%</td>
<td>60742</td>
</tr>
<tr class="even">
<td>92</td>
<td>vt.edu</td>
<td>0.26%</td>
<td>60177</td>
</tr>
<tr class="odd">
<td>93</td>
<td>uni-hannover.de</td>
<td>0.26%</td>
<td>59660</td>
</tr>
<tr class="even">
<td>94</td>
<td>kth.se</td>
<td>0.25%</td>
<td>59331</td>
</tr>
<tr class="odd">
<td>95</td>
<td>uu.se</td>
<td>0.25%</td>
<td>59226</td>
</tr>
<tr class="even">
<td>96</td>
<td>rug.nl</td>
<td>0.25%</td>
<td>59167</td>
</tr>
<tr class="odd">
<td>97</td>
<td>monash.edu.au</td>
<td>0.25%</td>
<td>58599</td>
</tr>
<tr class="even">
<td>98</td>
<td>tau.ac.il</td>
<td>0.25%</td>
<td>57633</td>
</tr>
<tr class="odd">
<td>99</td>
<td>u-psud.fr</td>
<td>0.25%</td>
<td>57508</td>
</tr>
<tr class="even">
<td>100</td>
<td>umontreal.ca</td>
<td>0.25%</td>
<td>57207</td>
</tr>
<tr class="odd">
<td>101</td>
<td>manchester.ac.uk(*)</td>
<td>0.24%</td>
<td>57042</td>
</tr>
<tr class="even">
<td>102</td>
<td>kek.jp</td>
<td>0.24%</td>
<td>56851</td>
</tr>
<tr class="odd">
<td>103</td>
<td>tuwien.ac.at</td>
<td>0.24%</td>
<td>56268</td>
</tr>
<tr class="even">
<td>104</td>
<td>uni-frankfurt.de</td>
<td>0.24%</td>
<td>56188</td>
</tr>
<tr class="odd">
<td>105</td>
<td>ualberta.ca</td>
<td>0.24%</td>
<td>55723</td>
</tr>
<tr class="even">
<td>106</td>
<td>unc.edu</td>
<td>0.24%</td>
<td>55184</td>
</tr>
<tr class="odd">
<td>107</td>
<td>csic.es</td>
<td>0.24%</td>
<td>55077</td>
</tr>
<tr class="even">
<td>108</td>
<td>uni-koeln.de</td>
<td>0.23%</td>
<td>54491</td>
</tr>
<tr class="odd">
<td>109</td>
<td>hri.res.in</td>
<td>0.23%</td>
<td>54487</td>
</tr>
<tr class="even">
<td>110</td>
<td>sinica.edu.tw</td>
<td>0.23%</td>
<td>53583</td>
</tr>
<tr class="odd">
<td>111</td>
<td>bnl.gov</td>
<td>0.23%</td>
<td>53518</td>
</tr>
<tr class="even">
<td>112</td>
<td>unibe.ch</td>
<td>0.23%</td>
<td>52695</td>
</tr>
<tr class="odd">
<td>113</td>
<td>uni-regensburg.de</td>
<td>0.22%</td>
<td>52209</td>
</tr>
<tr class="even">
<td>114</td>
<td>nbi.dk</td>
<td>0.22%</td>
<td>52130</td>
</tr>
<tr class="odd">
<td>115</td>
<td>ens.fr</td>
<td>0.22%</td>
<td>51465</td>
</tr>
<tr class="even">
<td>116</td>
<td>helsinki.fi</td>
<td>0.22%</td>
<td>50951</td>
</tr>
<tr class="odd">
<td>117</td>
<td>uni-stuttgart.de</td>
<td>0.22%</td>
<td>50834</td>
</tr>
<tr class="even">
<td>118</td>
<td>jinr.ru</td>
<td>0.22%</td>
<td>50707</td>
</tr>
<tr class="odd">
<td>119</td>
<td>ulb.ac.be</td>
<td>0.22%</td>
<td>50558</td>
</tr>
<tr class="even">
<td>(119)</td>
<td>unige.ch**</td>
<td>--</td>
<td>50311</td>
</tr>
<tr class="odd">
<td>120</td>
<td>postech.ac.kr</td>
<td>0.22%</td>
<td>50110</td>
</tr>
<tr class="even">
<td>121</td>
<td>duke.edu</td>
<td>0.21%</td>
<td>48913</td>
</tr>
<tr class="odd">
<td>122</td>
<td>uibk.ac.at</td>
<td>0.21%</td>
<td>48557</td>
</tr>
<tr class="even">
<td>123</td>
<td>unimelb.edu.au</td>
<td>0.21%</td>
<td>48467</td>
</tr>
<tr class="odd">
<td>124</td>
<td>ru.nl</td>
<td>0.21%</td>
<td>48298</td>
</tr>
<tr class="even">
<td>125</td>
<td>huji.ac.il</td>
<td>0.21%</td>
<td>48009</td>
</tr>
<tr class="odd">
<td>126</td>
<td>shef.ac.uk</td>
<td>0.21%</td>
<td>47889</td>
</tr>
<tr class="even">
<td>127</td>
<td>prl.res.in</td>
<td>0.20%</td>
<td>47443</td>
</tr>
<tr class="odd">
<td>128</td>
<td>soton.ac.uk</td>
<td>0.20%</td>
<td>47326</td>
</tr>
<tr class="even">
<td>129</td>
<td>fu-berlin.de</td>
<td>0.20%</td>
<td>46958</td>
</tr>
<tr class="odd">
<td>130</td>
<td>lanl.gov</td>
<td>0.20%</td>
<td>46224</td>
</tr>
<tr class="even">
<td>131</td>
<td>slac.stanford.edu</td>
<td>0.20%</td>
<td>45605</td>
</tr>
<tr class="odd">
<td>132</td>
<td>iastate.edu</td>
<td>0.20%</td>
<td>45562</td>
</tr>
<tr class="even">
<td>133</td>
<td>jhmi.edu</td>
<td>0.19%</td>
<td>44794</td>
</tr>
<tr class="odd">
<td>134</td>
<td>uq.edu.au</td>
<td>0.19%</td>
<td>44384</td>
</tr>
<tr class="even">
<td>135</td>
<td>waseda.ac.jp</td>
<td>0.19%</td>
<td>43549</td>
</tr>
<tr class="odd">
<td>136</td>
<td>susx.ac.uk</td>
<td>0.19%</td>
<td>43499</td>
</tr>
<tr class="even">
<td>137</td>
<td>ucsc.edu</td>
<td>0.19%</td>
<td>43457</td>
</tr>
<tr class="odd">
<td>138</td>
<td>ntnu.no</td>
<td>0.19%</td>
<td>43412</td>
</tr>
<tr class="even">
<td>139</td>
<td>uni-erlangen.de</td>
<td>0.19%</td>
<td>43408</td>
</tr>
<tr class="odd">
<td>140</td>
<td>sfu.ca</td>
<td>0.19%</td>
<td>43208</td>
</tr>
<tr class="even">
<td>141</td>
<td>buffalo.edu</td>
<td>0.18%</td>
<td>43025</td>
</tr>
<tr class="odd">
<td>142</td>
<td>uni-tuebingen.de</td>
<td>0.18%</td>
<td>42308</td>
</tr>
<tr class="even">
<td>143</td>
<td>unibas.ch</td>
<td>0.18%</td>
<td>41888</td>
</tr>
<tr class="odd">
<td>144</td>
<td>unsw.edu.au</td>
<td>0.18%</td>
<td>41827</td>
</tr>
<tr class="even">
<td>145</td>
<td>leidenuniv.nl</td>
<td>0.18%</td>
<td>41808</td>
</tr>
<tr class="odd">
<td>146</td>
<td>cuni.cz</td>
<td>0.18%</td>
<td>41321</td>
</tr>
<tr class="even">
<td>147</td>
<td>leeds.ac.uk</td>
<td>0.18%</td>
<td>41136</td>
</tr>
<tr class="odd">
<td>148</td>
<td>mcgill.ca</td>
<td>0.18%</td>
<td>40982</td>
</tr>
<tr class="even">
<td>149</td>
<td>toronto.edu</td>
<td>0.17%</td>
<td>40268</td>
</tr>
<tr class="odd">
<td>150</td>
<td>keio.ac.jp</td>
<td>0.17%</td>
<td>40182</td>
</tr>
<tr class="even">
<td>151</td>
<td>anu.edu.au</td>
<td>0.17%</td>
<td>40004</td>
</tr>
<tr class="odd">
<td>152</td>
<td>titech.ac.jp</td>
<td>0.17%</td>
<td>39953</td>
</tr>
<tr class="even">
<td>153</td>
<td>fraunhofer.de</td>
<td>0.17%</td>
<td>39950</td>
</tr>
<tr class="odd">
<td>154</td>
<td>uni-wuerzburg.de</td>
<td>0.17%</td>
<td>39846</td>
</tr>
<tr class="even">
<td>155</td>
<td>hu-berlin.de</td>
<td>0.17%</td>
<td>39845</td>
</tr>
<tr class="odd">
<td>(155)</td>
<td>perimeterinstitute.ca**</td>
<td>--</td>
<td>39187</td>
</tr>
<tr class="even">
<td>156</td>
<td>lu.se</td>
<td>0.17%</td>
<td>38987</td>
</tr>
<tr class="odd">
<td>157</td>
<td>qmul.ac.uk</td>
<td>0.17%</td>
<td>38502</td>
</tr>
<tr class="even">
<td>158</td>
<td>ens-lyon.fr</td>
<td>0.16%</td>
<td>38253</td>
</tr>
<tr class="odd">
<td>159</td>
<td>tamu.edu</td>
<td>0.16%</td>
<td>38103</td>
</tr>
<tr class="even">
<td>160</td>
<td>ugent.be</td>
<td>0.16%</td>
<td>37770</td>
</tr>
<tr class="odd">
<td>161</td>
<td>uni-muenster.de</td>
<td>0.16%</td>
<td>37675</td>
</tr>
<tr class="even">
<td>162</td>
<td>uio.no</td>
<td>0.16%</td>
<td>37363</td>
</tr>
<tr class="odd">
<td>163</td>
<td>unicamp.br</td>
<td>0.16%</td>
<td>37027</td>
</tr>
<tr class="even">
<td>164</td>
<td>uni-ulm.de</td>
<td>0.16%</td>
<td>36350</td>
</tr>
<tr class="odd">
<td>165</td>
<td>uni-kl.de</td>
<td>0.15%</td>
<td>35898</td>
</tr>
<tr class="even">
<td>166</td>
<td>uni-saarland.de(*)</td>
<td>0.15%</td>
<td>35896</td>
</tr>
<tr class="odd">
<td>167</td>
<td>nao.ac.jp</td>
<td>0.15%</td>
<td>35786</td>
</tr>
<tr class="even">
<td>168</td>
<td>lancs.ac.uk</td>
<td>0.15%</td>
<td>34879</td>
</tr>
<tr class="odd">
<td>169</td>
<td>u-strasbg.fr</td>
<td>0.15%</td>
<td>34836</td>
</tr>
<tr class="even">
<td>170</td>
<td>kyushu-u.ac.jp</td>
<td>0.15%</td>
<td>34576</td>
</tr>
<tr class="odd">
<td>171</td>
<td>asu.edu</td>
<td>0.15%</td>
<td>34551</td>
</tr>
<tr class="even">
<td>172</td>
<td>tu-graz.ac.at(*)</td>
<td>0.15%</td>
<td>34526</td>
</tr>
<tr class="odd">
<td>173</td>
<td>uni-bielefeld.de</td>
<td>0.15%</td>
<td>34504</td>
</tr>
<tr class="even">
<td>174</td>
<td>rochester.edu</td>
<td>0.15%</td>
<td>34502</td>
</tr>
<tr class="odd">
<td>175</td>
<td>utdallas.edu</td>
<td>0.15%</td>
<td>34229</td>
</tr>
<tr class="even">
<td>176</td>
<td>hokudai.ac.jp</td>
<td>0.15%</td>
<td>33805</td>
</tr>
<tr class="odd">
<td>177</td>
<td>adelaide.edu.au</td>
<td>0.14%</td>
<td>33405</td>
</tr>
<tr class="even">
<td>178</td>
<td>wustl.edu</td>
<td>0.14%</td>
<td>33352</td>
</tr>
<tr class="odd">
<td>179</td>
<td>uic.edu</td>
<td>0.14%</td>
<td>33329</td>
</tr>
<tr class="even">
<td>180</td>
<td>utah.edu</td>
<td>0.14%</td>
<td>32920</td>
</tr>
<tr class="odd">
<td>181</td>
<td>tifr.res.in</td>
<td>0.14%</td>
<td>32842</td>
</tr>
<tr class="even">
<td>182</td>
<td>iap.fr</td>
<td>0.14%</td>
<td>32768</td>
</tr>
<tr class="odd">
<td>183</td>
<td>tue.nl</td>
<td>0.14%</td>
<td>32602</td>
</tr>
<tr class="even">
<td>184</td>
<td>tkk.fi(*)</td>
<td>0.14%</td>
<td>32465</td>
</tr>
<tr class="odd">
<td>185</td>
<td>fsu.edu</td>
<td>0.14%</td>
<td>32302</td>
</tr>
<tr class="even">
<td>186</td>
<td>polytechnique.fr</td>
<td>0.14%</td>
<td>31959</td>
</tr>
<tr class="odd">
<td>187</td>
<td>navy.mil</td>
<td>0.14%</td>
<td>31676</td>
</tr>
<tr class="even">
<td>188</td>
<td>ucf.edu</td>
<td>0.14%</td>
<td>31575</td>
</tr>
<tr class="odd">
<td>189</td>
<td>ugr.es</td>
<td>0.14%</td>
<td>31509</td>
</tr>
<tr class="even">
<td>190</td>
<td>ucm.es</td>
<td>0.13%</td>
<td>31413</td>
</tr>
<tr class="odd">
<td>191</td>
<td>uni-jena.de</td>
<td>0.13%</td>
<td>31389</td>
</tr>
<tr class="even">
<td>192</td>
<td>tu-dortmund.de(*)</td>
<td>0.13%</td>
<td>31302</td>
</tr>
<tr class="odd">
<td>193</td>
<td>inria.fr</td>
<td>0.13%</td>
<td>31243</td>
</tr>
<tr class="even">
<td>194</td>
<td>gla.ac.uk</td>
<td>0.13%</td>
<td>31070</td>
</tr>
<tr class="odd">
<td>195</td>
<td>unitn.it</td>
<td>0.13%</td>
<td>30941</td>
</tr>
<tr class="even">
<td>196</td>
<td>kfa-juelich.de</td>
<td>0.13%</td>
<td>30862</td>
</tr>
<tr class="odd">
<td>197</td>
<td>anl.gov</td>
<td>0.13%</td>
<td>30271</td>
</tr>
<tr class="even">
<td>198</td>
<td>ohio-state.edu</td>
<td>0.13%</td>
<td>30127</td>
</tr>
<tr class="odd">
<td>199</td>
<td>kcl.ac.uk</td>
<td>0.13%</td>
<td>30085</td>
</tr>
<tr class="even">
<td>200</td>
<td>arizona.edu</td>
<td>0.13%</td>
<td>29571</td>
</tr>
</tbody>
</table>

(\*) Some institutions' downloads come from multiple domains which have
been combined to report an aggregate number:

-   desy.de includes downloads from ifh.de.
-   illinois.edu includes downloads from uiuc.edu.
-   inaf.it includes downloads from astro.it.
-   manchester.ac.uk includes downloads from man.ac.uk.
-   mpg.de includes downloads from aei.mpg.de, age.mpg.de,
    bgc-jena.mpg.de, biochem.mpg.de, biophys.mpg.de, brain.mpg.de,
    cbs.mpg.de, cec.mpg.de, coll.mpg.de, cpfs.mpg.de, demogr.mpg.de,
    ds.mpg.de, em.mpg.de, enzyme-halle.mpg.de, eva.mpg.de,
    fhi-berlin.mpg.de, fkf.mpg.de, gwdg.de, hll.mpg.de, ice.mpg.de,
    ie-freiburg.mpg.de, ip.mpg.de, ipp.mpg.de, is.mpg.de, mis.mpg.de,
    mmg.mpg.de, molgen.mpg.de, mpa-garching.mpg.de, mpcdf.mpg.de,
    mpdl.mpg.de, mpe-garching.mpg.de, mpe.mpg.de, mpi-dortmund.mpg.de,
    mpi-fg-koeln.mpg.de, mpi-halle.mpg.de, mpi-hd.mpg.de,
    mpi-inf.mpg.de, mpi-klsb.mpg.de, mpi-magdeburg.mpg.de,
    mpi-muelheim.mpg.de, mpi-sb.mpg.de, mpi-stuttgart.mpg.de,
    mpia-hd.mpg.de, mpib-berlin.mpg.de, mpibpc.mpg.de,
    mpie-duesseldorf.mpg.de, mpifr-bonn.mpg.de, mpih-frankfurt.mpg.de,
    mpiib-berlin.mpg.de, mpikg.mpg.de, mpim-bonn.mpg.de, mpimet.mpg.de,
    mpimp-golm.mpg.de, mpip-mainz.mpg.de, mpipks-dresden.mpg.de,
    mpipriv-hh.mpg.de, mpipz.mpg.de, mpiwg-berlin.mpg.de, mppmu.mpg.de,
    mpq.mpg.de, mps.mpg.de, neuro.mpg.de, nf.mpg.de, orn.mpg.de,
    psych.mpg.de, rz-berlin.mpg.de, rzg.mpg.de, sf.mpg.de, shh.mpg.de,
    tuebingen.mpg.de, vw.mpg.de.
-   riken.jp includes downloads from riken.go.jp.
-   stonybrook.edu includes downloads from sunysb.edu.
-   sydney.edu.au includes downloads from usyd.edu.au.
-   tkk.fi includes downloads from aalto.fi, hut.fi.
-   tu-dortmund.de includes downloads from uni-dortmund.de.
-   tu-graz.ac.at includes downloads from tugraz.at.
-   tudelft.nl includes downloads from tudelft.net.
-   tum.de includes downloads from tu-muenchen.de.
-   ucsd.edu includes downloads from sdsc.edu.
-   uni-karlsruhe.de includes downloads from fzk.de, kit.edu.
-   uni-saarland.de includes downloads from uni-sb.de.
-   upmc.fr includes downloads from jussieu.fr.

(\*\*) Some institutions' downloads were created via an alternative
method due to anomalies. They have been placed at their approximate rank
and are noted by the parentheses around the rank number. Downloads for
these institutions have been left out of the calculation for precentage
of total.
