# arXiv Annual Update, January 2020

_Published January 16, 2020_

arXiv’s free distribution service and open archive continues to grow annually and hosts over 1.6 million e-prints in Physics, Mathematics, Computer Science, Quantitative Biology, Quantitative Finance, Statistics, Electrical Engineering and Systems Science, and Economics. In 2019, the repository received 155,866 [new submissions](/help/stats/2019_by_area), an 11% increase from 2018, and about 260 million downloads from all over the world.

## Leadership and Staffing Changes

arXiv is excited to be recruiting a full time Executive Director. This new full-time position will lead arXiv into the future as a digital archive and open access distribution service for research articles.

After 10 years of leading arXiv Oya Y. Rieger has stepped down from her role as Program Director to join Ithaka S+R as Senior Strategist. Oya has led a constantly evolving organization with a passionate user community, always moving ahead to ensure a sustainable, reliable service. Over her term, Oya has developed a diverse business model for arXiv and facilitated the initiation of the [arXiv Next-Gen](https://blogs.cornell.edu/arxiv/2019/10/31/arxiv-ng-project-explanation/) initiative. From her career as Associate University Librarian at Cornell and arXiv's Program Director, she has developed partnerships and served as an advisor to a broad range of scholarly communication initiatives. Her commitment to community engagement, transparency, open access, fairness, patience, and responsiveness have been embedded in the core values of the arXiv team.

Erick Peirson, arXiv’s Lead Architect, has also moved on from arXiv. Erick’s [technical designs](https://arxiv.github.io/arxiv-arxitecture/) have put arXiv on a solid path to the future for arXiv Next-Gen. He also initiated arXiv’s move towards a more open development environment for external programmers and collaborators to engage with arXiv.

In addition arXiv had 3 other staff positions change over in 2019. This meant that much of the team effort was put towards daily operations and shoring up operational stability. This shift in effort is reflected in some of our goals being deferred.  

## Next Generation arXiv

Our [next-generation arXiv](https://confluence.cornell.edu/display/arxivpub/Next+Generation+arXiv) (arXiv-NG) initiative to improve the service’s core infrastructure by incremental and modular renewal of the existing arXiv system continues to progress. This includes significant effort towards laying the foundations for the NG submission system, which the team hopes to alpha test in Q12020. Existing search, browse, accounts, documentation NG components received incremental improvements.  The team also took the initial and essential steps to improve the overall accessibility of arXiv’s user interfaces, both through behind-the-scenes structural improvements and user-facing changes (e.g. support for a mobile-friendly abstract page).

## Sustainability Update

arXiv's operation and development is funded by grants and a membership program that engages libraries, research institutions, and societies worldwide. [243 members](/about/ourmembers) representing 30 countries supported arXiv in 2019.

We remain grateful for the support from the [Simons Foundation](https://www.simonsfoundation.org/) that has encouraged long-term community support by lowering arXiv membership fees and making participation affordable to a broader range of institutions. Our [2018-2022 sustainability plan](https://confluence.cornell.edu/display/arxivpub/2018-2022%3A+Sustainability+Plan+for+Classic+arXiv) aims to ensure that the ultimate responsibility for sustaining arXiv remains with the research communities and institutions that benefit from the service most directly. We continue to prioritize finding new, sustainable funding avenues to support current operations and development of arXiv’s infrastructure.

## Key Accomplishments in 2019 and Plans for 2020

Key Accomplishments in 2019 and Plans for 2020
Since we started the arXiv sustainability initiative in 2010, an integral part of our work has been assessing the services, technologies, standards, and policies that constitute arXiv. Here are some of our key accomplishments from 2019 to illustrate the range of issues we have been trying to tackle. Please see the [2019 Roadmap](/about/reports/2019_roadmap) for a full account of our work.

- We continue to improve facilities for administrators and moderators in order to streamline their workflows, and to improve clarity and transparency of arXiv communications. During 2019, the arXiv team expanded quality control flags.
- Our development team continued to improve and extend various search, browse, documentation, and other features as we reimplement, test, refine and continue to improve the arXiv platform. The team made significant progress reimplementing the submission user interface towards an alpha release, new and legacy APIs, as well as backend services. Wherever possible, new software components are developed in [public repositories](https://confluence.cornell.edu/display/arxivpub/arXiv-NG+Public+Repositories) and released under permissive open source licenses. With a reduction of effort in Q42019 due to staff departures, the team shifted most of its remaining resources towards improving and maintaining the operational stability of the arXiv services.
- Our Scientific Advisory Board (SAB), under the leadership of Licia Verde, has clarified roles and responsibilities for the arXiv Subject Advisory Committees and the Committee Chairs. The effort for outreach and recruitment of new moderators has increased in 2019 with an aim to increase diversity among moderators.  We have also modified the SAB membership to include greater representation and engagement with the newer fields that have joined arXiv.
- Two major policies were adopted in 2019 including the arXiv [Code of Conduct](/help/policies/code\_of\_conduct) and a [Privacy Policy](/help/policies/privacy\_policy). We thank the staff, moderators, advisory boards, and arXiv users who have contributed to the development of the Code of Conduct.
- The arXiv team wished farewells to Janelle Morano (Community Engagement and Membership Coordinator), Jaimie Murdock (arXiv NG Developer), Erick Peirson (Lead System Architect), Liz Woods (User Experience Specialist) and Matt Bierbaum (arXiv Labs). We were pleased to welcome Shamsi Brinn as our new User Experience Specialist in October 2019 and Alison Fromme as new Community Engagement and Membership Coordinator in January 2020. We also initiated a search for a new Backend Python Developer in the last quarter of 2019.
- We moved information about our governance, business model, and reports to [arXiv.org](https://arxiv.org/), to improve overall accessibility to pertinent information about arXiv&#39;s operations. This information was previously available on the [arXiv Public Wiki](https://confluence.cornell.edu/display/arxivpub/arXiv+Public+Wiki). We continue to regularly update our community at the [arXiv.org blog](https://blogs.cornell.edu/arxiv/).
- As part of the organizational change to Cornell CIS we moved offices in 2019. The arXiv team now has its own dedicated space in historic Uris Library.


The [2020 Roadmap](/about/reports/2020_roadmap) includes our goals as we strive to improve the technical infrastructure, moderation system, user support, and the sustainability framework.

arXiv relies on a wide network of individuals who contribute their expertise and time, and we are grateful for their contributions. Paul Ginsparg, arXiv&#39;s founder, continues to make significant contributions to arXiv through his involvement in the daily moderation process and his development  of automation to the quality control process.

Our moderators are an essential component of arXiv&#39;s success. Our 180 subject experts verify that submissions are topical and of interest to the scientific community, follow accepted standards of scholarly communication, and are classified in the appropriate subject categories. _We salute them!_

We also thank the members of the arXiv advisory groups ([Scientific Advisory Board](/about/people/scientific_ad_board), [Member Advisory Board](/about/people/member_ad_board), and [IT Advisory Group](/about/people/technical_ad_group)) for their consistent and essential contributions as representatives of scientific and library communities. We remain grateful for strong support from [our member organizations](/about/ourmembers) and the [Simons Foundation](https://www.simonsfoundation.org/). We also thank the [Sloan Foundation](https://sloan.org/), [Heising-Simons Foundation](https://www.hsfoundation.org/), and [Allen Institute for Artificial Intelligence](https://allenai.org/) for their generous support of arXiv.

***

**arXiv Management Team**

Jim Entwood (Interim Executive Director, Operations Manager), Steinn Sigurdsson (Scientific Director), Martin Lessmeister (IT Lead), Alison Fromme (Community Engagement & Development Coordinator), Janelle Morano (_Former_ Community Engagement & Development Coordinator)

**Website**: [arXiv Public Wiki](https://confluence.cornell.edu/display/arxivpub/arXiv+Public+Wiki)

**Contact email**:  membership@arXiv.org

**Twitter**: [@arXiv](https://twitter.com/arxiv)

**Updates**: If you are interested in getting updates from the arXiv team and have not yet signed up for the mailing list, send an email message to:  arxiv-support-updates-L-request@cornell.edu. Leave the subject line blank and the body of the message should be a single word: join
