arXiv Sustainability Advisory Group
===================================

Cornell University Library  
August 5, 2010; last updated September 7, 2010  
See also: [arXiv Support](/help/support)  
Contact: <support@arxiv.org>

Purpose of the Sustainability Advisory Group
--------------------------------------------

arXiv is a non-profit e-print repository maintained by Cornell
University Library to advance effective and affordable scholarly
exchange in the fields of physics, mathematics, computer science, and
related disciplines. Cornell University Library is responsible for the
overall management of the repository including its fiscal, service, and
policy oversight. The sustainability advisory group includes
representatives from institutions served by arXiv and provides a
consultative role in developing diverse sustainability strategies for
this critical international resource. The group will also seek input
from the [arXiv Scientific Advisory
Board](http://arxiv.org/help/scientific_ad_board).

The recent Ithaka report on sustainability provides a comprehensive
review of a variety of business models for supporting online academic
resources. This report defines sustainability as "the ability to
generate or gain access to the resources financial or otherwise needed
to protect and increase the value of the content or service for those
who use it." Therefore, managing academic resources such as arXiv
involves not only covering their costs but also continuing to enhance
their value based on the needs of the user community. Such a financial
commitment is likely to be beyond a single institution's resources and
requires the development of a cooperative sustainability plan. Although
we perceive the exploration and planning process to be collaborative
endeavor, Cornell University Library is ultimately responsible for
carrying out the policies and decisions and managing the overall arXiv
operation during the business planning activities.  This is a critical
principle in order to maintain a stable and reliable service point.

Goals
-----

The advisory group's charge includes the following responsibilities:

1.  Assist Cornell in evaluating opportunities and risks associated with
    alternative financial and technological strategies required to
    maintain arXiv as a reliable and innovative service
2.  Provide feedback in setting a time line and strategies for
    transitioning from the current support model that is based solely on
    institutional contributions to longer-term diversified business
    model
3.  Leveraging the existing professional connections and venues, act as
    liaison to the broader community by representing arXiv in related
    forums and gathering input (needs, concerns, suggestions) that is
    required for business planning purposes
4.  Review and provide input for public documentation describing the
    arXiv sustainability plans
5.  Contribute to the communication and promotion of decisions and
    strategies in regard to arXiv business model to key stakeholders 
    (users, libraries, publishers, research institutions, etc.) that
    have interest in the future of arXiv
6.  Recommend an organisational model that will enable the steady
    gathering and incorporation of input from the contributing
    institutions after the 2-year term of the advisory group comes to an
    end

Membership
----------

-   Jun Adachi, Professor and Director, Cyber Science Infrastructure
    Development Department, National Institute of Informatics (NII),
    Japan
-   Miriam Blake, Research Library Director, Los Alamos National
    Laboratory, US
-   Martha Brogan, Associate University Librarian for Collection
    Development and Management, University of Pennsylvania, US
-   Raym Crow, Senior Consultant, SPARC, US
-   Paul Ginsparg, Professor of Physics & Computing and Information
    Science, Cornell University, US (Ex-officio member)
-   Neil Jacobs, Acting Programme Director, Information Environment,
    JISC, UK
-   Cliff Lynch, Executive Director, Coalition for Networked
    Information, US
-   Catherine Mitchell, Director, Publishing Services Program,
    California Digital Library, US
-   Oya Y. Rieger, Associate University Librarian for Digital
    Scholarship Services, Cornell University Library, US (Chair)
-   Irina Sens, Deputy Director, German National Library of Science and
    Technology (TIB) (representing Max Planck, TIB, and HGF), Germany
-   Winston Tabb, Dean of University Libraries and Museums,The Johns
    Hopkins University, US

Appointments
------------

The committee is established as a 2-year transitioning team to help
Cornell develop a diverse business model for arXiv.  The members will
serve a two-year term starting in August 2010. There will be email
exchange and planning work for the first meeting during September and
October prior to the in-person initial meeting.  The terms will run
August 2010-May 2012.

Timing and Location of Meetings
-------------------------------

The initiation meeting will take place in November 2010 during the SPARC
annual meeting at Baltimore. The meetings will be scheduled based on
work plans and the progress registered.  The general plan is to
hold three follow-up meetings during 2011-2012 that will be held in the
form of conference calls. In November 2011, there should be another
in-person meeting to bring the group together and to review progress and
future plans.  There may be additional small-group conference calls as
needed to bring the work of the advisory group to closure.

Tentative Meeting Agenda TBD:

<table>
<tbody>
<tr class="odd">
<td></td>
<td>FORMAT</td>
<td>TIME &amp; LOCATION</td>
</tr>
<tr class="even">
<td>1</td>
<td>in-person</td>
<td>November 2010, Baltimore, MD</td>
</tr>
<tr class="odd">
<td>2</td>
<td>conference call</td>
<td>February 2011</td>
</tr>
<tr class="even">
<td>3</td>
<td>conference call</td>
<td>May 2011</td>
</tr>
<tr class="odd">
<td>4</td>
<td>in-person</td>
<td>October/November 2011</td>
</tr>
<tr class="even">
<td>5</td>
<td>conference call</td>
<td>April 2012</td>
</tr>
</tbody>
</table>

Travel Expenses
---------------

For board members who need assistance with their travel expenses to
attend the in-person meetings, Cornell will provide \$1,000 per person
for the U.S. participants and \$1,500 for the overseas participants. The
in-person meetings will be held in conjunction with related
international conferences such as SPARC meetings.
