# Computer Science Subject Areas and Moderators

Papers in the [Computing Research Repository (CoRR)](./) are classified in two ways: by subject area from a list of subjects listed below and by using the 1998 ACM Computing Classification System. The ACM classification scheme provides us with a relatively stable scheme that covers all of computer science. The subject areas are not mutually exclusive, nor do they (yet) provide complete coverage of the field. On the other hand, we hope that they better reflect the active areas of research in CS. We expect to add more subject areas and subdivide current subject areas according to demand. Authors who cannot find an appropriate subject area should use subject area Other. We welcome constructive [comments and suggestions](/help/contact).

**[AI - Artificial Intelligence](/list/cs.AI/recent)** - Diego Calvanese, Julien Corman, and Ognjen Savkovic

Covers all areas of AI except Vision, Robotics, Machine Learning, Multiagent Systems, and Computation and Language (Natural Language Processing), which have separate subject areas. In particular, includes Expert Systems, Theorem Proving (although this may overlap with Logic in Computer Science), Knowledge Representation, Planning, and Uncertainty in AI. Roughly includes material in ACM Subject Classes I.2.0, I.2.1, I.2.3, I.2.4, I.2.8, and I.2.11.

**[CC - Computational Complexity](/list/cs.CC/recent)** - Christopher Umans

Covers models of computation, complexity classes, structural complexity, complexity tradeoffs, upper and lower bounds. Roughly includes material in ACM Subject Classes F.1 (computation by abstract devices), F.2.3 (tradeoffs among complexity measures), and F.4.3 (formal languages), although some material in formal languages may be more appropriate for Logic in Computer Science. Some material in F.2.1 and F.2.2, may also be appropriate here, but is more likely to have Data Structures and Algorithms as the primary subject area.

**[CG - Computational Geometry](/list/cs.CG/recent)** - Kevin Buchin, Jeff Erickson

Roughly includes material in ACM Subject Classes I.3.5 and F.2.2.

**[CE - Computational Engineering, Finance, and Science](/list/cs.CE/recent)** - Paolo Bientinesi

Covers applications of computer science to the mathematical modeling of complex systems in the fields of science, engineering, and finance. Papers here are interdisciplinary and applications-oriented, focusing on techniques and tools that enable challenging computational simulations to be performed, for which the use of supercomputers or distributed computing platforms is often required. Includes material in ACM Subject Classes J.2, J.3, and J.4 (economics).

**[CL - Computation and Language (Computational Linguistics and Natural Language and Speech Processing)](/list/cs.CL/recent)** (_subsumes cmp-lg_) - Stuart Shieber

Covers natural language processing. Roughly includes material in ACM Subject Class I.2.7. **Note that work on artificial languages (programming languages, logics, formal systems) that does not explicitly address natural-language issues broadly construed (natural-language processing, computational linguistics, speech, text retrieval, etc.) is not appropriate for this area.**

**[CV - Computer Vision and Pattern Recognition](/list/cs.CV/recent)** - David Forsyth

Covers image processing, computer vision, pattern recognition, and scene understanding. Roughly includes material in ACM Subject Classes I.2.10, I.4, and I.5.

**[CY - Computers and Society](/list/cs.CY/recent)** - Aylin Caliskan

Covers impact of computers on society, computer ethics, information technology and public policy, legal aspects of computing, computers and education. Roughly includes material in ACM Subject Classes K.0, K.2, K.3, K.4, K.5, and K.7.

**[CR - Cryptography and Security](/list/cs.CR/recent)** - Jeremiah Blocki

Covers all areas of cryptography and security including authentication, public key cryptosytems, proof-carrying code, etc. Roughly includes material in ACM Subject Classes D.4.6 and E.3.

**[DB - Databases](/list/cs.DB/recent)** - H.V. Jagadish

Covers database management, datamining, and data processing. Roughly includes material in ACM Subject Classes E.2, E.5, H.0, H.2, and J.1.

**[DS - Data Structures and Algorithms](/list/cs.DS/recent)** - David Eppstein

Covers data structures and analysis of algorithms. Roughly includes material in ACM Subject Classes E.1, E.2, F.2.1, and F.2.2.

**[DL - Digital Libraries](/list/cs.DL/recent)** - Michael Lesk

Covers all aspects of the digital library design and document and text creation. Note that there will be some overlap with Information Retrieval (which is a separate subject area). Roughly includes material in ACM Subject Classes H.3.5, H.3.6, H.3.7, I.7.

**[DM - Discrete Mathematics](/list/cs.DM/recent)** - Jeff Erickson, Marcin Pilipczuk

Covers combinatorics, graph theory, applications of probability. Roughly includes material in ACM Subject Classes G.2 and G.3.

**[DC - Distributed, Parallel, and Cluster Computing](/list/cs.DC/recent)** - Shlomi Dolev

Covers fault-tolerance, distributed algorithms, stabilility, parallel computation, and cluster computing. Roughly includes material in ACM Subject Classes C.1.2, C.1.4, C.2.4, D.1.3, D.4.5, D.4.7, E.1.

**[ET - Emerging Technologies](/list/cs.ET/recent)** - Igor Markov, Dmitri Maslov

Covers approaches to information processing (computing, communication, sensing) and bio-chemical analysis based on alternatives to silicon CMOS-based technologies, such as nanoscale electronic, photonic, spin-based, superconducting, mechanical, bio-chemical and quantum technologies (this list is not exclusive). Topics of interest roughly correspond to the "[Hardware/Emerging Technologies](http://dl.acm.org/ccs_flat.cfm#10010786)" branch of the [2012 ACM Computing Classification](http://www.acm.org/about/class/2012) and include (1) building blocks for emerging technologies, their scalability and adoption in larger systems, including integration with traditional technologies, (2) modeling, design and optimization of novel devices and systems, (3) models of computation, algorithm design and programming for emerging technologies. **Note: papers on wireless networks should be submitted to cs.NI. For work on cloud computing, consider cs.DC, cs.AR, cs.NI or cs.CE, depending on the focus. For watermarking, consider cs.MM and cs.CR.**

**[FL - Formal Languages and Automata Theory](/list/cs.FL/recent)** - Michael Domaratzki

Covers automata theory, formal language theory, grammars, and combinatorics on words. This roughly corresponds to ACM Subject Classes F.1.1, and F.4.3. Papers dealing with computational complexity should go to cs.CC; papers dealing with logic should go to cs.LO. Papers that simply make use of automata, transducers, grammars, and so on, are not appropriate unless the automata, transducers, or grammars are the main subjects of study.

**[GT - Computer Science and Game Theory](/list/cs.GT/recent)** - Michal Feldman, David Parkes, Moshe Tennenholtz

Covers all theoretical and applied aspects at the intersection of computer science and game theory, including work in mechanism design, learning in games (which may overlap with Machine Learning), foundations of agent modeling in games (which may overlap with Multiagent systems), coordination, specification and formal methods for non-cooperative computational environments. The area also deals with applications of game theory to areas such as electronic commerce.

**[GL - General Literature](/list/cs.GL/recent)** - Joe Halpern

Covers introductory material, survey material, predictions of future trends, biographies, and miscellaneous computer-science related material. Roughly includes all of ACM Subject Class A, except it does not include conference proceedings (which will be listed in the appropriate subject area).

**[GR - Graphics](/list/cs.GR/recent)** - Stephen Spencer and David Salesin

Covers all aspects of computer graphics. Roughly includes material in all of ACM Subject Class I.3, except that I.3.5 is is likely to have Computational Geometry as the primary subject area.

**[AR - Hardware Architecture](/list/cs.AR/recent)** - Onur Mutlu

Covers systems organization and architecture. Roughly includes material in ACM Subject Classes C.0, C.1, and C.5.

**[HC - Human-Computer Interaction](/list/cs.HC/recent)** - Terry Winograd and Michael Bernstein

Covers human factors, user interfaces, and collaborative computing. Roughly includes material in ACM Subject Classes H.1.2 and all of H.5, except for H.5.1, which is more likely to have Multimedia as the primary subject area.

**[IR - Information Retrieval](/list/cs.IR/recent)** - James Allan

Covers indexing, dictionaries, retrieval, content and analysis. Roughly includes material in ACM Subject Classes H.3.0, H.3.1, H.3.2, H.3.3, and H.3.4.

**[IT - Information Theory](/list/cs.IT/recent)** - Venkat Guruswami and Muriel Medard

Covers theoretical and experimental aspects of information theory and coding. Includes material in ACM Subject Class E.4 and intersects with H.1.1.

**[LG - Machine Learning](/list/cs.LG/recent)** - Tom Dieterrich, Sebastian Raschka and Luis Lamb

Papers on all aspects of machine learning research (supervised,
unsupervised, reinforcement learning, bandit problems, and so on)
including also robustness, explanation, fairness, and
methodology. cs.LG is also an appropriate primary category for
applications of machine learning methods.

*Relationship to other categories*: If the primary domain of the
application is available as another category in arXiv and readers of
that category would be the main audience, that category should be
primary. Examples include applications to computer vision (cs.CV),
natural language processing (cs.CL), speech recognition (eess.AS),
information retrieval (cs.IR; includes document classification and
topic modeling), crowdsourcing (cs.HC), quantitative finance ([q-fin](/archive/q-fin)),
and quantitative biology ([q-bio](/archive/q-bio)). Papers discussing the foundations of
neural network architectures (activation functions, spiking neurons,
etc.) should list cs.NE as primary, as should papers applying
biologically-inspired optimization techniques such as evolutionary
methods. Papers working with the properties of specific signal types
(e.g., sound, EEG, hyperspectral, ultrasound) should consider cs.SD
(sound, including music), eess.IV (images and video), or eess.SP as
primary. cs.LG is not appropriate for papers studying human learning
such as computer-aided instruction, where cs.CY is a better
fit. Papers categorized with cs.LG as primary are automatically
cross-listed as stat.ML and vice versa.

**[LO - Logic in Computer Science](/list/cs.LO/recent)** - Gopalan Nadathur

Covers all aspects of logic in computer science, including finite model theory, logics of programs, modal logic, and program verification. Programming language semantics should have Programming Languages as the primary subject area. Roughly includes material in ACM Subject Classes D.2.4, F.3.1, F.4.0, F.4.1, and F.4.2; some material in F.4.3 (formal languages) may also be appropriate here, although Computational Complexity is typically the more appropriate subject area.

**[MS - Mathematical Software](/list/cs.MS/recent)** - Paolo Bientinesi

Roughly includes material in ACM Subject Class G.4.

**[MA - Multiagent Systems](/list/cs.MA/recent)** - Jose Vidal

Covers multiagent systems, distributed artificial intelligence, intelligent agents, coordinated interactions. and practical applications. Roughly covers ACM Subject Class I.2.11.

**[MM - Multimedia](/list/cs.MM/recent)** - Kishore Ramachandran

Roughly includes material in ACM Subject Class H.5.1.

**[NI - Networking and Internet Architecture](/list/cs.NI/recent)** - Katerina Argyraki

Covers all aspects of computer communication networks, including network architecture and design, wireless communication, network protocols, and internetwork standards (like TCP/IP). Also includes topics, such as web caching, that are directly relevant to Internet architecture and performance. Roughly includes all of ACM Subject Class C.2 except C.2.4, which is more likely to have Distributed, Parallel, and Cluster Computing as the primary subject area.

**[NE - Neural and Evolutionary Computation](/list/cs.NE/recent)** - Jordan Pollack

Covers neural networks, connectionism, genetic algorithms, artificial life, adaptive behavior. Roughly includes some material in ACM Subject Class C.1.3, I.2.6, I.5.

**[NA - Numerical Analysis](/list/cs.NA/recent)** - Paolo Bientinesi

Roughly includes material in ACM Subject Class G.1.

**[OS - Operating Systems](/list/cs.OS/recent)** - William Waite

Roughly includes material in ACM Subject Classes D.4.1, D.4.2., D.4.3, D.4.4, D.4.5, D.4.7, and D.4.9.

**[OH - Other](/list/cs.OH/recent)** - Joe Halpern

This is the classification to use for documents that do not fit anywhere else. This category should not be used if other categories seem appropriate.

**[PF - Performance](/list/cs.PF/recent)** - Leana Golubchik

Covers performance measurement and evaluation, queueing, and simulation. Roughly includes material in ACM Subject Classes D.4.8 and K.6.2.

**[PL - Programming Languages](/list/cs.PL/recent)** - Gopalan Nadathur

Covers programming language semantics, language features, programming approaches (such as object-oriented programming, functional programming, logic programming). Also includes material on compilers oriented towards programming languages; other material on compilers may be more appropriate in Architecture (AR). Roughly includes material in ACM Subject Classes D.1 and D.3.

**[RO - Robotics](/list/cs.RO/recent)** - Damien Chablat

Roughly includes material in ACM Subject Class I.2.9.

**[SI - Social and Information Networks](/list/cs.SI/recent)** - Jure Leskovec and David Gleich

Covers the design, analysis, and modeling of social and information networks, including their applications for on-line information access, communication, and interaction, and their roles as datasets in the exploration of questions in these and other domains, including connections to the social and biological sciences. Analysis and modeling of such networks includes topics in ACM Subject classes F.2, G.2, G.3, H.2, and I.2; applications in computing include topics in H.3, H.4, and H.5; and applications at the interface of computing and other disciplines include topics in J.1--J.7. Papers on computer communication systems and network protocols (e.g. TCP/IP) are generally a closer fit to the Networking and Internet Architecture (cs.NI) category.

**[SE - Software Engineering](/list/cs.SE/recent)** - Stéphane Ducasse and Nicolas Anquetil

Covers design tools, software metrics, testing and debugging, programming environments, etc. Roughly includes material in all of ACM Subject Classes D.2, except that D.2.4 (program verification) should probably have Logics in Computer Science as the primary subject area.

**[SD - Sound](/list/cs.SD/recent)** - Michael O'Donnell

Covers all aspects of computing with sound, and sound as an information channel. Includes models of sound, analysis and synthesis, audio user interfaces, sonification of data, computer music, and sound signal processing. Includes ACM Subject Class H.5.5, and intersects with H.1.2, H.5.1, H.5.2, I.2.7, I.5.4, I.6.3, J.5, K.4.2.

**[SC - Symbolic Computation](/list/cs.SC/recent)** - Rich Zippel

Roughly includes material in ACM Subject Class I.1.

**[SY - Systems and Control](/list/cs.SY/recent)** - Marco Lovera, Guodong Shi, Jan-Willem Van Wingerden, and Yuan Wang

This section includes theoretical and experimental research covering all facets of automatic control systems, having as focal point analysis and design methods using tools of modeling, simulation and optimization. Specific areas of research include nonlinear, distributed, adaptive, stochastic and robust control, hybrid and discrete event systems. Application areas include automotive, aerospace, process control, network control, biological systems, multiagent and cooperative control, sensor networks, control of cyberphysical and energy-related systems, control of computing systems.
