# Authority Records


Since 2005 arXiv has maintained *authority records* that link a person's
arXiv account with the papers that they have written. We currently
use authority records to support the [endorsement system](endorsement),
[ORCID iDs](orcid), and our public [arXiv author
identifiers](author_identifiers).

arXiv can also record third-party *paper owners*, users with rights to
update or replace a paper but who are not authors. All users recorded as
authors are automatically paper owners too. This status is used to
support third-party submission by approved conference organizers and
journals. Users may log-in to see [a list](/user/) of
papers they have written or own.

## For submitters


When you submit a paper, you will automatically be registered as an
*owner* of that paper. At submission time, we will ask if you are an
author, and if you say yes, you will automatically be registered as an
*author*. Your co-authors can become authors by giving them the [paper
password](passwords) for the paper. They can then enter the arXiv
identifier and paper password on the [claim
ownership](/auth/need-paper-password) form. We
recommend that you share the paper password with all of the authors of
each paper you submit and encourage them to register themselves as
owners.

If papers you have submitted are
missing entirely from your [list of papers](/user/), you
should follow the instructions below for *other authors*.

If a paper is on your list of papers you own, but you are not registered as an author,
you can use the [Change Author Status form](/auth/change-author-status).

## For other authors

Since most papers have multiple authors, it is quite likely that you are the author of a paper that you did not submit personally. 

### To claim a paper

If the submitter has provided you with the paper password you can use the [Claim Ownership with a password form](/auth/need-paper-password).

If you do not have the paper password you can use the [Claim Authorship form](/auth/request-ownership). Note that this process involves verification by our staff and may take a couple of days.

<span id="coauthor"></span>
###  A note on authorship in scholarly works

Submitters are responsible for ensuring all co-authors have consented to submission of the work to arXiv. Under U.S. copyright law, a single co-author normally has authority to agree to arXiv's non-exclusive distribution license. Submitters to arXiv are expected to follow normal publishing practices for co-authored submissions (i.e. seeking consent and approval from their co-authors and any other required parties). arXiv will not adjudicate authorship disputes surrounding submission or announcement. Concerns should be directed directly to the submitting author's institution. Findings from an institutional investigation may be [reported](/help/contact) by an institutional officer to arXiv's "help" email address. At that point arXiv will consider what action, if any, may be taken regarding the submission.

### Falsification of Authorship 

Submitters are required to comply with arXiv's [code of conduct](/help/policies/code_of_conduct). If you believe there has been an ethical violation such as falsification of authorship, please [contact](/help/contact) arXiv administrators via the "help" email address with a complete explanation. Note that this will open a dialog with the submitter as well, and cannot be used as an "authorship dispute by proxy".
