# Submissions in Languages Other Than English and Multiple-Language Submissions

We accept submissions in languages other than English but do require
that all submissions have an English version of the abstract. The
principal reason for including an English abstract is to allow effective
search and keyword extraction over all submissions in arXiv.

## Preparation of a multilingual abstract

Please prepare English and alternate language abstracts so that one
follows the other, separated as shown below (if your abstract is long,
you may have to contact us to extend the normal size limit to
accommodate both versions). Do not try to use TeX or HTML formatting
commands to separate the versions—the abstract should be as close to
plain text (ASCII) as possible. Indicate separation as follows:

> 
> 
>     English version of abstract for your important paper.
>     
>     -----
>     
>     Other language version of abstract for your important paper.

Note the blank lines before and after the separator (`-----`). The
abstract will then appear as follows on the web:

> English version of abstract for your important paper.  
> \-----  
> Other language version of abstract for your important paper.

and as follows in the mailings:

> 
> 
>     English version of abstract for your important paper.
>     -----
>     Other language version of abstract for your important paper.

Please also use the Comments field to note the language of the main text
of the submission or that there are multiple versions of the submission
in different languages, for
example:

> 
> 
> ``` 
>   Comments: 24 pages, in French
> ```

## Articles with multiple versions in different languages—TeX submissions

Name the main TeX files for each version something obvious; english.tex,
and italian.tex or italiano.tex would be good choices for a paper
submitted in English and Italian. If the reader selects PostScript, then
they will see the different versions listed. Sensible naming will allow
them to select the version they want. Note that the compiled PDF will
combine the different versions into a single PDF file for readers to
download.

## Articles with multiple versions in different languages—PDF submissions

For PDF submissions, we can currently accept only a single PDF file.
Please combine your different language versions of the paper into a
single PDF file for upload to arXiv.
