To add a journal reference, DOI or report number to an article
==============================================================

When a article is published, the author may wish to indicate this in the
abstract listing for the article. For this reason, the journal reference
and DOI ([Digital Object Identifier](http://www.doi.org/)) fields are
provided for articles. Additionally, a report number field is provided
for institutional report numbers.

You can add journal-ref, DOI and report number information to your
articles via the journal reference facility on your [user
page](http://arxiv.org/jref). Note that no new article version will be
generated when journal reference, DOI or report number information is
added.

Journal reference
-----------------

Note that this is relevant only when the author has the full publication
information. Messages of the form "will appear in..." or "accepted
for..." are *not appropriate* for the journal reference field. Instead,
use the Comments field for this sort of information.

A good bibliographic reference should provide clear and concise
information to allow someone to locate the journal version of the
article. It should include at least the **journal name, volume number,
year and page number(s)**. An example looks like:

> **Nucl.Phys.Proc.Suppl. 109 (2002) 3-9**

See also [journal reference](prep#journal) formatting details.

DOI
---

DOIs are identifiers that provide access to electronic versions of
journal articles. They will be linked from the arXiv abstract page. They
have the form `number.number/something` and you should not include any
prefix such as `doi:`. For example:

> **10.1016/S0550-3213(01)00405-9**

See also [DOI](prep#doi) formatting details.

Report number
-------------

This is for your institution's locally assigned publication number or
numbers. These usually comprise a prefix of a few letters and then
sequence numbers and/or year indication. For example:

> **SU-4240-720**

Multiple report numbers should be separated with a semi-colon and a
space:

> **SU-4240-720; LAUR-01-2140**

See also [report number](prep#report) formatting details.
