# arXiv moderation

arXiv is a forum for professional members of the scientific community. While arXiv prides itself on maintaining a permanent collection of scientific work that is made available to the public quickly and without cost, submissions to arXiv do require a minimal amount of moderation.

## Why does arXiv moderate submissions?

arXiv is an openly accessible, moderated repository for scholarly papers in specific scientific disciplines. Material submitted to arXiv is expected to be of interest, relevance, and value to those disciplines. arXiv reserves the right to reject or reclassify any submission.

## What policies guide moderation?

arXiv moderation may result in the *reclassification* or *removal* of a submission. 
Reclassification by our moderators helps make sure that submissions are posted to the most appropriate archive. Cross-lists may be added to other related archives, or they may be removed by moderators when the classification is deemed inappropriate. A submission that is cross-listed to a category will still be announced in the mailings to that category.

arXiv policies that could lead to the removal of a submission are:

- *Unrefereeable content.* arXiv only accepts submissions in the form of an article that would be refereeable by a conventional publication venue. Papers that do not contain original or substantive research, including undergraduate research, course projects, and research proposals, news, or information about political causes (even those with potential special interest to the academic community) may be removed. Papers that contain inflammatory or fictitious content, papers that use highly dramatic and misrepresentative titles/abstracts/introductions, or papers in need of significant review and revision may be removed. 
- *Inappropriate format.* Abstract-only submissions, presentations, book announcements, book reviews, submissions without references, calls for papers, or advertisements may be removed. We do not accept submissions with line numbers or submissions with watermarks.
- *Inappropriate topic.* While arXiv serves a variety of scientific communities, not all subjects are currently covered. Submissions that do not fit well into our current classification scheme may be removed and, where possible, redirected to a more appropriate repository.
- *Duplicated content.* If moderators notice that a user has made many similar submissions in a short amount of time, or that a new submission appears to be a revision of a recent submission, then moderators may request that the submissions be consolidated. This helps ensure that arXiv is as useful as possible for all of the various communities publishing here, and it can often help the author present a more unified body of research.
- *Rights to submit material.* Submissions to arXiv must be the author’s original work, and users must have the right to grant the rights contained in the [selected license](/help/license). Users must ensure the submission does not, to the best of their knowledge, infringe upon anyone's copyright. Users should not submit comments by referees. Users should not submit plagiarized material.
- *Excessive submission rate.* Articles submitted to arXiv must be of refereeable quality, and there is a practical limit to the rate at which appropriate, independent submissions can be produced by any one person. Moderators may request that a particular author limit their submission rate if this author has a history of many submissions to inappropriate areas or of doubtful refereeability.
If an author has a back catalog of work to submit to arXiv we ask that they submit no more than three papers per day.

<span id="appeal"></span>

## Can I appeal a moderation decision?

If you disagree with a moderation decision, you may submit an appeal. Please carefully follow the directions below.

- Send a precise email, including all relevant details (especially paper IDs, former correspondence, submission summaries, etc.) to moderation@arxiv.org.
- If you receive an automated response to your email, please read all instructions carefully.
- If there is no other identifying information in your message (e.g., paper ID or rejection ID), you may need to address your email with "Dear arXiv-moderation," to bypass our SPAM filter.
You will get an email from arXiv administrators when your appeal has been sent to our appellate moderators for consideration.
- Please be *patient*, as moderation appeals are complicated and take some time.
- When a decision is made by the appellate moderators you will receive a follow up message from arXiv administrators.
- Our moderators are not referees and do not provide detailed feedback on submissions. Administrators cannot provide detailed feedback regarding submissions deemed inappropriate and will not enter into extended discussion regarding submissions.
- In some cases, we may require that a paper be accepted for publication in a conventional journal before an appeal is considered.

The appeals process allows moderators additional time to reconsider a submission, but repeated appeals with no additional information cannot be considered. If you send an appeal and the moderators reach the same decision as they did initially, no further appeal should be submitted. Extreme cases may be addressed to the appropriate advisory committee chair only: [physics](/help/physics/#AdvisoryCommittee);
[mathematics](/help/math/#AdvisoryCommittee); 
[computer science (CoRR)](/corr); 
[quantitative biology](/help/q-bio/#AdvisoryCommittee); 
[quantitative finance](/help/q-fin/#AdvisoryCommittee);
[statistics](/help/statistics/#AdvisoryCommittee);
[electrical engineering and systems science](/help/eess/#AdvisoryCommittee); or [economics](/help/econ/#AdvisoryCommittee) .

## Who are arXiv moderators?

arXiv moderators are volunteers who are experts in their fields and in the types of submissions that are appropriate for their subject classifications. They evaluate based on the content of the submission and the policies of arXiv. Moderators consider the submissions to arXiv as privileged information, as they would with a paper being refereed for a journal.

[arXiv moderators](/moderators) are approved by their discipline-level [advisory committees](/about/people/scientific_ad_board#advisory_committees) and by arXiv staff.

Although the moderators may be publicly acknowledged, it is inappropriate to contact any moderator directly regarding your submission. All communication about moderation decisions should be addressed to moderation@arxiv.org or, in extreme cases, the appropriate advisory committee chair. Moderators are encouraged not to reply to personal correspondence regarding arXiv submissions.

