arXiv Privacy Policy
======================

The following privacy notice describes what information we collect from you when you visit arXiv.org and how we use this information. Please read this privacy notice carefully so that you understand our privacy practices.

## Effective Date of Privacy Notice

The privacy notice was last revised on 2019-02-08.

## What information we gather during your visit

_Information we gather for anonymous browsing:_

We automatically collect certain information from you when you visit arXiv. This data is used to gather metrics on site usage including geographic location of visitors (IP address), pathways navigated through the website, what type of internet browser is used (user-agent). No attempt is made to deanonymize information we collect.

_Information you may provide as registered user:_

We may also collect other information as described in this notice or other specific Cornell University privacy notices. In order to take full advantage of some of our services, including article submission, we may request name, email, username, ORCID, past emails, affiliation, country, additional contact information and/or online identifiers. We may also request a record of affiliation and publication record be provided via email. When a user submits an article to arXiv we also collect author names, affiliation of co-authors (if provided), submitter IP address and submitter remote host.

Information associated with your user account can be viewed on your [user dashboard](/user/).

_Information you may provide when submitting feedback or help request:_

Users who email [arXiv administrators](/help/contact) for technical help or moderation requests should include information relevant to the request.

Users who choose to fill out a feedback form on the website can do so anonymously or by providing personal information, such as name, email, and information about your operating environment.

_Information provided by others:_

Users who submit articles or other content to arXiv must ensure that they have the consent to share personal data contained within the content or the submission may be removed.


## How we use your information

We use gathered information to track user trends and site usage with the goal of improving our visitors’ experience and optimizing our websites. We also use the information to administer this website and prevent abuse.

_Customer support:_

We use your information to resolve technical and moderation issues you encounter, to respond to your requests for assistance, to analyze crash information, and to repair and improve the services.

_For safety and security:_

We use information about you and your service use to verify accounts and activity, to monitor suspicious or fraudulent activity and to identify violations of service policies.


_Daily mailings:_

User-controlled subscriptions for announcements of daily papers include instructions to unsubscribe. More information at: https://arxiv.org/help/subscribe


_Article Submission:_

In the content submission and moderation process we link user accounts, authorship, and submitted content to track and process submissions. More information is at: https://arxiv.org/help/submit; https://arxiv.org/help/registerhelp; https://arxiv.org/help/policies/submission_agreement; https://arxiv.org/help/policies/instructions_for_submission; https://arxiv.org/help/moderation  


Article metadata provided by submitter, including author list, author affiliation (if provided), submitter name is displayed with the article posting, email announcement of articles, and bulk metadata access via API.


The email address that was used to upload each submission is viewable by registered arXiv users to give users the ability to send feedback on papers to the submitter and to help users [contact eligible arXiv endorsers](https://arxiv.org/help/endorsement#request) in order to make their own submissions.

_Fundraising:_

Should you decide to donate to arXiv through the donate page you will be directed to the Cornell giving website and the information you provide will be used to process your donation. Please also see the [Cornell giving privacy policy](https://giving.cornell.edu/privacy-policy/).

_Membership:_

For users who visit arXiv from the IP range of an arXiv member institution, you will see the institution acknowledged on the arXiv.org website. arXiv member institutions also receive anonymous statistics on usage from within their IP range.


## With whom we share your information

Information we gather is shared with vendors we use to support the infrastructure, submission, moderation, and archival requirements of arXiv. However, we will not sell this data to third-parties for their use in direct marketing, advertising, or for the promotion of their products and services.

_Info we share with third party services:_

Atlassian Jira is used for collecting feedback about development features that are sent in voluntarily by users. Users can optionally provide name, email, and information about their current operating environment.

iThenticate is used by arXiv administrators for text analysis on submissions. The name of the submitter is included in the iThenticate report for tracking purposes.

Fastmail is used for email communication with arXiv volunteer moderators that may contain submission metadata, including author names, affiliations, submitter name and email.

GMail is used for email communication of submission and moderator emails that may contain submission metadata, including author names, affiliations, submitter name and email.

Slack is used for email communication of submission and moderator emails that may contain submission metadata, including author names, affiliations, submitter name and email.

Amazon Web Services is used for server infrastructure for components of the arXiv system.


[Astrophysics Data System](http://ads.harvard.edu/) (ADS) is a trusted partner with arXiv who we share anonymized browsing logs associated with arXiv papers for use in ADS search and discovery tools.

_Info we share with moderators as part of submission and moderation:_

As part of the article submission and moderation process arXiv moderators can view author list, submitter name, submitter email, and if the submitter was endorsed by another user moderators can view the name of the endorser.

_Info we share publicly:_

Users with registered arXiv accounts can view the email address that was used to upload each submission to arXiv. Please see the [email protection page](https://arxiv.org/help/email-protection) for more information.

The metadata for arXiv articles is freely accessible and available to any third-party use.


## Cookies

Cookies are text files stored on your computer and accessible only to the websites which create them.

Our websites may use cookies to keep you logged into secure areas of the website and/or to keep track of your preferences as you interact with certain services. It is not necessary to use/permit cookies to read articles on arXiv.org.

To manage cookies in arXiv please see: https://arxiv.org/cookies


## Protecting your information

No method of transmitting over the internet or storing electronic data is 100% secure, but arXiv follows standard practices to protect against the loss, misuse, or alteration of the information that is under our control.

##Fundraising, Update, User Testing, and other notifications
This section explains the choices you have when it comes to receiving email communications from arXiv.

Donors to arXiv may receive future fundraising emails from Cornell University. Those emails will contain options to unsubscribe.

arXiv members will receive annual update emails and direct correspondence relating to membership. Those emails will contain options to unsubscribe.

Sorry™ App is used to notify users about arXiv's operational status. Read [Sorry's privacy page](https://help.sorryapp.com/en/articles/1929467-privacy-and-cookies-policy) for more information. When you sign up for status notifications arXiv will share your contact information with Sorry™ to keep you informed about changes in the availability of our service. You'll have the option to unsubscribe at any time.

If you have joined the user testing list you will receive occasional survey links and other relevant opportunities to review and offer feedback on website changes. We use Mailchimp to manage user testing lists and send emails to our testing groups. Read [Mailchimp’s privacy policy](https://mailchimp.com/legal/privacy/) for more information. You can make changes to your email preferences by utilizing the relevant links noted in our email communications. You may opt out of user testing emails at any time.

We collect a variety of types of information for user testing purposes such as:
Your name and email
Your country
Your primary research field
Your opinions on various aspects of the website.

This information helps us improve the functionality of arXiv for more people and across geographic areas.

Your information is never shared with third party marketing services.

## Social Media Presence

If you share our content through social media, such as tweeting about us on Twitter, those social networks will record that you have done so and may set a cookie for this purpose.

If you wish to opt-out of any of these social interactions please refer to the specific social media platform for instructions on how to do so.

## External Website Links

From time-to-time, we will link to external websites that we neither own nor control. Cornell University is not responsible for the content, privacy practices, or web accessibility needs on these websites.

Contributors to the site, including article submissions and metadata may contain links as well. We are not responsible for the content, privacy practices, or web accessibility needs on these websites.

## Special Notice for EU Residents

If you are located within the European Economic Area (European Union, Norway, Liechtenstein, and Iceland), we acknowledge the rights granted to you under the General Data Protection Regulation (GDPR).

These rights may include:

1. Right to access your information held by us
2. Right to correct inaccurate or incorrect information about you
3. Right to the erasure of your information when it is no longer necessary for us to retain it
4. Right to restrict processing of your personal information in specific situations
5. Right to object to processing your information, including sending you communications that may be considered direct-marketing materials
6. Right to object to automated decision-making and profiling, where applicable
7. Right to complain to a supervisory authority in your jurisdiction within the EU

Please contact us with any questions, concerns, or if you wish to exercise any of these rights: gdpr@cornell.edu


## Contact Information

For questions about arXiv privacy policies or technical support please contact: help@arxiv.org

If you have general questions about Cornell University privacy practices, please contact: privacy@cornell.edu or visit https://privacy.cornell.edu.
