Submission Guidelines
====================

<span id="guidelines"></span> Submissions to arXiv should be topical and refereeable scientific contributions that follow accepted standards of scholarly communication.

-   We only accept submissions from [registered authors](registerhelp). If you are a new user or are submitting to a new category, you may be required to find [endorsements](/help/endorsement).
-   All submissions are subject to a [moderation process](/help/moderation) that verifies material is appropriate and topical. Material that contains offensive language, non-scientific content, or is plagiarized may be removed.  
-   Authors must grant arXiv.org a [non-exclusive and irrevocable
    license to distribute](license) or certify that the work is
    available under another license that conveys these rights.
-   Authors must agree to the [submission terms and agreement](policies/submission_agreement) and [Instructions for submission](policies/instructions_for_submission).

-   Authors are expected to self-submit. Submissions by a third party are accepted under limited conditions. See instructions for [third-party submissions](third_party_submission) and [index submissions](submit_index) for conference proceedings.
-   New submissions received by 14:00 (Eastern Daylight/Standard Time Zone) are generally made [available](/help/versions) at 20:00 (Eastern) but are subject to delays in the moderation process (see the [schedule for details](#availability).) 

Submission Preparation
====================
-   [Formats for text submission](#text)
-   [Formats for figures](#figures)
-   [File names and case sensitivity](#files)
-   [Inclusion of data sets and ancillary files (data, programs,
    etc.)](#datasets)
-   [Title and abstract preparation](#prep)
-   [Verify and correct your submission](#correct)
-   [Edit or replace your submission](#replace)


To submit an article, use the [submit form](http://arxiv.org/submit)
    or select "START NEW SUBMISSION" from your [user
    page](http://arxiv.org/user).

<span id="text"></span>

Formats for text of submission
------------------------------

Accepted submission formats
(in order of preference):

-   [(La)TeX, AMS(La)TeX, PDFLaTeX](submit_tex)
-   [PDF](submit_pdf)
-   [HTML with JPEG/PNG/GIF images](submit_html)

Our goal is to store articles in formats that are highly portable and
stable over time. Currently, the best choice is TeX/LaTeX. 

We do not accept [dvi, PS, or PDF created
from TeX/LaTeX source](/help/faq/whytex), and we
do not accept scanned documents, regardless of format.

<span id="figures"></span>

Formats for figures
-------------------

Accepted figure formats:

-   PostScript (PS, EPS) &mdash; requires [LaTeX processing](submit_tex#latex)
-   JPEG, GIF, PNG or PDF figures &mdash; requires [PDFLaTeX processing](submit_tex#pdflatex) 

We do not accept submissions with omitted figures, even if you provide links to view figures externally. 

If you submit figures with your (La)TeX source, use standard macro
packages (e.g., the `graphics` and `graphicx` packages) to have
figures appear in the document. arXiv administration
cannot provide help with TeX-related issues.

<span id="files"></span>

File names and case sensitivity
-------------------------------

arXiv will accept only the following characters in file names:

> `a-z A-Z 0-9 _ + - . , = `

File names that contain other characters (e.g., spaces, question marks,
asterisks) will be rejected. These restrictions ensure maximum portability of the stored
files and minimize archival risk.

File names and extensions are also case sensitive on our system. The
file names `Figure1.PDF` and `figure1.pdf` are not the same. Whether
your local system is case sensitive (e.g., Unix) or not (e.g., Windows)
you must ensure that internal file references, such as LaTeX figure
inclusion commands, match case exactly.

<span id="datasets"></span>

Inclusion of ancillary files
------------------------------------------

There are limited facilities for including data sets and ancillary files
(data, programs, etc.) that are associated with articles submitted to
arXiv. See [separate instructions](ancillary_files) about including data sets
and ancillary files.

<span id="prep"></span>

Title and abstract preparation
--------------------------

See [separate instructions for preparing the title and abstract](prep) for inclusion in metadata. This information is used on the
abstract pages, in announcements, in RSS feeds, and to support
searching.

<span id="correct"></span>

Verify and correct your submission
---------------------------------------

Before you make the final "Submit Article" step in the submission
process, be sure to carefully check the title and abstract (metadata)
and the processed files, and correct any errors. [Contact arXiv
administrators](/help/contact) for help.

If you discover an error after submission but before public announcement,
select the "Unsubmit" (![unsubmit icon](/images/unsubmit.png)) icon
next to the submission on your [user page](http://arxiv.org/user). This will
return it to [incomplete status](submit_status#incomplete) and allow you to 
modify your files and resubmit.

Unsubmitting an article takes the article out of the processing queue, and announcement will be scheduled based on the later resubmission time. See the schedule of [availability](#availability).

<span id="replace"></span>

Edit or replace your submission
----------------------------

Edits before a submission is publicly announced will not generate additional versions.
The date stamp associated with the submission will
be the time that the final "Submit Article" step is completed. Edits and
final submission before 14:00 US Eastern Time (EDT/EST) Monday through
Friday will not delay announcement. You may wish to check [current local
time](http://arXiv.org/localtime).

We encourage authors to update and to make corrections to their
articles. **DO NOT** make a new submission for a corrected article or
for an erratum. Instead, [replace](replace) the original submission.

<span id="availability"></span>

Availability of submissions and announcement order
--------------------------------------------------

Submissions to arXiv are typically made public Sunday through
Thursday, with no announcements Friday or Saturday. Check the [current
time](https://arxiv.org/localtime) at the arXiv main site, with the
amount of time remaining before the deadline. Submissions are made public as part of the scheduled announcement process. This includes new submissions as well as [replacements](/help/replace), [withdrawal notices](/help/withdraw), [cross listings](/help/cross) and [journal reference](/help/jref). Journal reference submissions do not appear in the mailings, but are still processed at that time. 

The final [arXiv identifier](arxiv_identifier) cannot be assigned until the paper is announced, so please do not ask for it ahead of announcement. It is not possible to make exceptions, nor accelerate the announcement schedule regardless of your circumstance. 

It may be the case that a submission appears in a different identifier month due to various factors. **Note:** The arXiv identifier cannot be back-dated, and identifiers are ordered based on the final timestamp of submitter action (i.e. when "submit" is clicked). 


| Submissions received between<br />(all times Eastern US) | Will be announced<br />(all times Eastern US) | Mailed to subscribers |
|:---:|:---:|:---:|
| Monday 14:00 &ndash; Tuesday 14:00 | Tuesday 20:00 | Tuesday night / Wednesday morning |
| Tuesday 14:00 &ndash; Wednesday 14:00 | Wednesday 20:00 | Wednesday night / Thursday morning | 
| Wednesday 14:00 &ndash; Thursday 14:00 | Thursday 20:00 | Thursday night / Friday morning |
| Thursday 14:00 &ndash; Friday 14:00 | Sunday 20:00 | Sunday night / Monday morning |
| Friday 14:00 &ndash; Monday 14:00 | Monday 20:00 | Monday night / Tuesday morning |
