Submission Status
=================

A new submission or an update to an article (replacement, cross list,
journal reference or DOI addition, or withdrawal) may traverse several
status values while it is in process. The meanings of these status
values are described below:

-   [incomplete](#incomplete) - in process but not submitted
-   [processing](#processing) - already submitted and being analyzed by
    arXiv
-   [submitted](#submitted) - in the queue to be announced
-   [on hold](#on_hold) - delayed pending administrator attention

All submissions and updates associated with your arXiv user account are
shown on the [user page](/user). Upon announcement articles will move
from the "Article Submissions" to the "Articles You Own" section.

<span id="incomplete"></span>

Incomplete
----------

When your submission is in this status, the article is in process, but
not yet [submitted](#submitted). You may still edit it which will update
the [expiration date](#exipred). Submissions left incomplete past the
expiration date will be deleted from arXiv.

<span id="processing"></span>

Processing
----------

When your submission is in this status, the article has been submitted,
but arXiv still needs to process your submission before setting the
status to either \[[submitted](#submitted)\] status, or if issues
requiring administrator attention are detected, to \[[on
hold](#on_hold)\] status. During this time you may not edit the
submission. Generally, submissions will be in this status for a
relatively short time period.

<span id="submitted"></span>

Submitted
---------

Your new submission, replacement, cross list, journal reference, or withdrawal has been submitted. Your submission will be posted based on the [automated announcement schedule](/help/submit#availability ).

**New submissions and replacements**: Once you have verified that your
intended submission appears in the format you desire, and you have
finalized all of the [metadata](/help/prep), this is the final status it
will pass through before it is announced. On your [user page](/user).
You may select the Unsubmit icon (![Unsubmit](https://arxiv.org/images/unsubmit.png)) to
remove it from this status, and return it to [incomplete](submit_status#incomplete) status.

<span id="on_hold"></span>

On Hold
-------

Your submission was identified by arXiv administrators or
[moderators](/help/moderation) as needing further attention.

Submissions may be put on hold for a variety of reasons, ranging from
questions about proper classification, pending moderator approval,
presentation issues, copyrighted PDF, etc., to editorial concerns. Most
of these do not require any further input from the submitter and will be
dealt with in due course. arXiv urges submitters to be patient. Due to
the large volume of submissions, it may take several days before a
resolution is reached.

Note that [oversize](/help/sizes) submissions are automatically put on
hold, and this is one particular circumstance in which submitters should
follow up with [arXiv administrators](/help/contact).

Submissions in this status will not expire. Authors *must not* create a
new submission with the same content when a pending submission is on
hold.

Please be sure to include the submission identifier of the form
*submit/NNNNNNN* when [contacting](/help/contact) arXiv administrators.

<span id="expired"></span>

Expiration
----------

If you neither submit nor update your submission within 14 days, it will
be removed. Any update to your submission will prevent it from being
automatically removed and reset the 14 day expiration period.
