To Subscribe to the E-Mail Alerting Service
===========================================

If you would like to receive regular daily listings of the abstracts of
new submissions by email, then you can subscribe to this service as
follows. Note that the email must be sent as **plain text**. Richtext format 
emails will be ignored by the system.

1.  Determine which archive is of interest to you, and obtain its e-mail
    address from the [list of available archives](#category_list).

2.  **For archives divided into subject classes:**  
    If the archive to which you are subscribing requires distinct
    subject classes (such as the `math`, `physics`, `cs`, `q-bio` and
    `q-fin` archives; but *not `astro-ph`, `cond-mat` or `nlin`*, see
    [handling subscriptions to all physics archives through
    physics](#physics) below), then you (un)subscribe to a specific
    category, indicating the categories in the body of the message. Here
    is an example
```
To: physics@arxiv.org 
Subject: subscribe John Smith 
    
add Biophysics 
del Plasma Physics
```
You may alternatively use the short subject class codes, for example
to subscribe to the Risk Management category (`q-fin.RM`) in
Quantitative Finance:
```
To: q-fin@arxiv.org 
Subject: subscribe John Smith 

add RM
```

3.  **For archives not divided into subject classes:**  
    Send an e-mail message to the archive(s) of interest, in the
    following form
```
To: arch-ive@arxiv.org 
Subject: subscribe Your Full Name
```

You should give your name as you wish it to appear on the
distribution list. Here is an example:
```
To: quant-ph@arxiv.org 
Subject: subscribe John Smith
```
(note that subscribing to subdivided archivies, such as `cond-mat`, in this way will subscribe you to all
subject classes within that archive.)

4.  **<span id="physics">Handling subscriptions to all physics archives
    through `physics`</span>**  
    The `physics` archive can be used to subscribe to any combination of
    existing physics archives, e.g. to something like \`General
    Relativity', \`Astrophysics', and \`High Energy Physics -
    Experimental'. This is also the only way to subscribe to a subset of
    the subject classes within the `astro-ph`, `cond-mat` and `nlin`
    archives. For example, to subscribe only to the `cond-mat` subject
    classes \`Soft Condensed Matter' and \`Superconductivity', the email
    would read:
```
To: physics@arxiv.org 
Subject: subscribe John Smith 

add Soft Condensed Matter 
add Superconductivity
```
If you want to change from, say, subscribing to all of `astro-ph` to
subscribing to just `astro-ph.EP` then you must first
[cancel](#cancel) the subscription to `astro-ph`, and then subscribe
to `EP` through the `physics` archive.

------------------------------------------------------------------------

<span id="cancel"></span>

To Cancel Your Subscription
===========================

If you want to cancel your receipt of the regular listings, you can do
so as follows.

1.  Find the e-mail address of the archive for which you are receiving
    the listings.
2.  Send an e-mail message to the archive, in the following form
```
To: arch-ive@arxiv.org 
Subject: cancel
```
Here is an example:
```
To: quant-ph@arxiv.org 
Subject: cancel
```
If you want to cancel your subscription to a particular subject
class in an archive that supports subject classes, then see the
example use of **`del`** in the **`subscribe`** command above.

Note that you may be subscribed through a remote listserv, or through
some local preprint distribution list at your end. You can determine the
origin of your subscription by examining the header from the daily
mailing you receive. You will have to deal with this through the
administrator of the remote distribution list.

<span id="category_list"></span>

## Archive List


### Computer Science (cs)

*   **Artificial Intelligence (cs.AI)**  
    Covers all areas of AI except Vision, Robotics, Machine Learning, Multiagent Systems, and Computation and Language (Natural Language Processing), which have separate subject areas. In particular, includes Expert Systems, Theorem Proving (although this may overlap with Logic in Computer Science), Knowledge Representation, Planning, and Uncertainty in AI. Roughly includes material in ACM Subject Classes I.2.0, I.2.1, I.2.3, I.2.4, I.2.8, and I.2.11.
*   **Hardware Architecture (cs.AR)**  
    Covers systems organization and hardware architecture. Roughly includes material in ACM Subject Classes C.0, C.1, and C.5.
*   **Computational Complexity (cs.CC)**  
    Covers models of computation, complexity classes, structural complexity, complexity tradeoffs, upper and lower bounds. Roughly includes material in ACM Subject Classes F.1 (computation by abstract devices), F.2.3 (tradeoffs among complexity measures), and F.4.3 (formal languages), although some material in formal languages may be more appropriate for Logic in Computer Science. Some material in F.2.1 and F.2.2, may also be appropriate here, but is more likely to have Data Structures and Algorithms as the primary subject area.
*   **Computational Engineering, Finance, and Science (cs.CE)**  
    Covers applications of computer science to the mathematical modeling of complex systems in the fields of science, engineering, and finance. Papers here are interdisciplinary and applications-oriented, focusing on techniques and tools that enable challenging computational simulations to be performed, for which the use of supercomputers or distributed computing platforms is often required. Includes material in ACM Subject Classes J.2, J.3, and J.4 (economics).
*   **Computational Geometry (cs.CG)**  
    Roughly includes material in ACM Subject Classes I.3.5 and F.2.2.
*   **Computation and Language (cs.CL)**  
    Covers natural language processing. Roughly includes material in ACM Subject Class I.2.7. Note that work on artificial languages (programming languages, logics, formal systems) that does not explicitly address natural-language issues broadly construed (natural-language processing, computational linguistics, speech, text retrieval, etc.) is not appropriate for this area.
*   **Cryptography and Security (cs.CR)**  
    Covers all areas of cryptography and security including authentication, public key cryptosytems, proof-carrying code, etc. Roughly includes material in ACM Subject Classes D.4.6 and E.3.
*   **Computer Vision and Pattern Recognition (cs.CV)**  
    Covers image processing, computer vision, pattern recognition, and scene understanding. Roughly includes material in ACM Subject Classes I.2.10, I.4, and I.5.
*   **Computers and Society (cs.CY)**  
    Covers impact of computers on society, computer ethics, information technology and public policy, legal aspects of computing, computers and education. Roughly includes material in ACM Subject Classes K.0, K.2, K.3, K.4, K.5, and K.7.
*   **Databases (cs.DB)**  
    Covers database management, datamining, and data processing. Roughly includes material in ACM Subject Classes E.2, E.5, H.0, H.2, and J.1.
*   **Distributed, Parallel, and Cluster Computing (cs.DC)**  
    Covers fault-tolerance, distributed algorithms, stabilility, parallel computation, and cluster computing. Roughly includes material in ACM Subject Classes C.1.2, C.1.4, C.2.4, D.1.3, D.4.5, D.4.7, E.1.
*   **Digital Libraries (cs.DL)**  
    Covers all aspects of the digital library design and document and text creation. Note that there will be some overlap with Information Retrieval (which is a separate subject area). Roughly includes material in ACM Subject Classes H.3.5, H.3.6, H.3.7, I.7.
*   **Discrete Mathematics (cs.DM)**  
    Covers combinatorics, graph theory, applications of probability. Roughly includes material in ACM Subject Classes G.2 and G.3.
*   **Data Structures and Algorithms (cs.DS)**  
    Covers data structures and analysis of algorithms. Roughly includes material in ACM Subject Classes E.1, E.2, F.2.1, and F.2.2.
*   **Emerging Technologies (cs.ET)**  
    Covers approaches to information processing (computing, communication, sensing) and bio-chemical analysis based on alternatives to silicon CMOS-based technologies, such as nanoscale electronic, photonic, spin-based, superconducting, mechanical, bio-chemical and quantum technologies (this list is not exclusive). Topics of interest include (1) building blocks for emerging technologies, their scalability and adoption in larger systems, including integration with traditional technologies, (2) modeling, design and optimization of novel devices and systems, (3) models of computation, algorithm design and programming for emerging technologies.
*   **Formal Languages and Automata Theory (cs.FL)**  
    Covers automata theory, formal language theory, grammars, and combinatorics on words. This roughly corresponds to ACM Subject Classes F.1.1, and F.4.3. Papers dealing with computational complexity should go to cs.CC; papers dealing with logic should go to cs.LO.
*   **General Literature (cs.GL)**  
    Covers introductory material, survey material, predictions of future trends, biographies, and miscellaneous computer-science related material. Roughly includes all of ACM Subject Class A, except it does not include conference proceedings (which will be listed in the appropriate subject area).
*   **Graphics (cs.GR)**  
    Covers all aspects of computer graphics. Roughly includes material in all of ACM Subject Class I.3, except that I.3.5 is is likely to have Computational Geometry as the primary subject area.
*   **Computer Science and Game Theory (cs.GT)**  
    Covers all theoretical and applied aspects at the intersection of computer science and game theory, including work in mechanism design, learning in games (which may overlap with Learning), foundations of agent modeling in games (which may overlap with Multiagent systems), coordination, specification and formal methods for non-cooperative computational environments. The area also deals with applications of game theory to areas such as electronic commerce.
*   **Human-Computer Interaction (cs.HC)**  
    Covers human factors, user interfaces, and collaborative computing. Roughly includes material in ACM Subject Classes H.1.2 and all of H.5, except for H.5.1, which is more likely to have Multimedia as the primary subject area.
*   **Information Retrieval (cs.IR)**  
    Covers indexing, dictionaries, retrieval, content and analysis. Roughly includes material in ACM Subject Classes H.3.0, H.3.1, H.3.2, H.3.3, and H.3.4.
*   **Information Theory (cs.IT)**  
    Covers theoretical and experimental aspects of information theory and coding. Includes material in ACM Subject Class E.4 and intersects with H.1.1.
*   **Machine Learning (cs.LG)**  
    Covers machine learning and computational (PAC) learning. Roughly includes material in ACM Subject Class I.2.6.
*   **Logic in Computer Science (cs.LO)**  
    Covers all aspects of logic in computer science, including finite model theory, logics of programs, modal logic, and program verification. Programming language semantics should have Programming Languages as the primary subject area. Roughly includes material in ACM Subject Classes D.2.4, F.3.1, F.4.0, F.4.1, and F.4.2; some material in F.4.3 (formal languages) may also be appropriate here, although Computational Complexity is typically the more appropriate subject area.
*   **Multiagent Systems (cs.MA)**  
    Covers multiagent systems, distributed artificial intelligence, intelligent agents, coordinated interactions. and practical applications. Roughly covers ACM Subject Class I.2.11.
*   **Multimedia (cs.MM)**  
    Roughly includes material in ACM Subject Class H.5.1.
*   **Mathematical Software (cs.MS)**  
    Roughly includes material in ACM Subject Class G.4.
*   **Numerical Analysis (cs.NA)**  
    Roughly includes material in ACM Subject Class G.1.
*   **Neural and Evolutionary Computing (cs.NE)**  
    Covers neural networks, connectionism, genetic algorithms, artificial life, adaptive behavior. Roughly includes some material in ACM Subject Class C.1.3, I.2.6, I.5.
*   **Networking and Internet Architecture (cs.NI)**  
    Covers all aspects of computer communication networks, including network architecture and design, network protocols, and internetwork standards (like TCP/IP). Also includes topics, such as web caching, that are directly relevant to Internet architecture and performance. Roughly includes all of ACM Subject Class C.2 except C.2.4, which is more likely to have Distributed, Parallel, and Cluster Computing as the primary subject area.
*   **Other Computer Science (cs.OH)**  
    This is the classification to use for documents that do not fit anywhere else.
*   **Operating Systems (cs.OS)**  
    Roughly includes material in ACM Subject Classes D.4.1, D.4.2., D.4.3, D.4.4, D.4.5, D.4.7, and D.4.9.
*   **Performance (cs.PF)**  
    Covers performance measurement and evaluation, queueing, and simulation. Roughly includes material in ACM Subject Classes D.4.8 and K.6.2.
*   **Programming Languages (cs.PL)**  
    Covers programming language semantics, language features, programming approaches (such as object-oriented programming, functional programming, logic programming). Also includes material on compilers oriented towards programming languages; other material on compilers may be more appropriate in Architecture (AR). Roughly includes material in ACM Subject Classes D.1 and D.3.
*   **Robotics (cs.RO)**  
    Roughly includes material in ACM Subject Class I.2.9.
*   **Symbolic Computation (cs.SC)**  
    Roughly includes material in ACM Subject Class I.1.
*   **Sound (cs.SD)**  
    Covers all aspects of computing with sound, and sound as an information channel. Includes models of sound, analysis and synthesis, audio user interfaces, sonification of data, computer music, and sound signal processing. Includes ACM Subject Class H.5.5, and intersects with H.1.2, H.5.1, H.5.2, I.2.7, I.5.4, I.6.3, J.5, K.4.2.
*   **Software Engineering (cs.SE)**  
    Covers design tools, software metrics, testing and debugging, programming environments, etc. Roughly includes material in all of ACM Subject Classes D.2, except that D.2.4 (program verification) should probably have Logics in Computer Science as the primary subject area.
*   **Social and Information Networks (cs.SI)**  
    Covers the design, analysis, and modeling of social and information networks, including their applications for on-line information access, communication, and interaction, and their roles as datasets in the exploration of questions in these and other domains, including connections to the social and biological sciences. Analysis and modeling of such networks includes topics in ACM Subject classes F.2, G.2, G.3, H.2, and I.2; applications in computing include topics in H.3, H.4, and H.5; and applications at the interface of computing and other disciplines include topics in J.1--J.7. Papers on computer communication systems and network protocols (e.g. TCP/IP) are generally a closer fit to the Networking and Internet Architecture (cs.NI) category.
*   **Systems and Control (cs.SY)**  
    This section includes theoretical and experimental research covering all facets of automatic control systems, having as focal point analysis and design methods using tools of modeling, simulation and optimization. Specific areas of research include nonlinear, distributed, adaptive, stochastic and robust control, hybrid and discrete event systems. Application areas include automotive, aerospace, process control, network control, biological systems, multiagent and cooperative control, sensor networks, control of cyberphysical and energy-related systems, control of computing systems.

### Economics (econ)

*   **Econometrics (econ.EM)**  
    Econometric Theory, Micro-Econometrics, Macro-Econometrics, Empirical Content of Economic Relations discovered via New Methods, Methodological Aspects of the Application of Statistical Inference to Economic Data.
*   **General Economics (econ.GN)**  
    General methodological and applied contributions to economics.
*   **Theoretical Economics (econ.TH)**  
    Includes theoretical contributions to Contract Theory, Decision Theory, Game Theory, General Equilibrium, Growth, Learning and Evolution, Macroeconomics, Market and Mechanism Design, and Social Choice.

### Electrical Engineering and Systems Science (eess)

*   **Audio and Speech Processing (eess.AS)**  
    Theory and methods for processing signals representing audio, speech, and language, and their applications. This includes analysis, synthesis, enhancement, transformation, classification and interpretation of such signals as well as the design, development, and evaluation of associated signal processing systems. Machine learning and pattern analysis applied to any of the above areas is also welcome. Specific topics of interest include: auditory modeling and hearing aids; acoustic beamforming and source localization; classification of acoustic scenes; speaker separation; active noise control and echo cancellation; enhancement; de-reverberation; bioacoustics; music signals analysis, synthesis and modification; music information retrieval; audio for multimedia and joint audio-video processing; spoken and written language modeling, segmentation, tagging, parsing, understanding, and translation; text mining; speech production, perception, and psychoacoustics; speech analysis, synthesis, and perceptual modeling and coding; robust speech recognition; speaker recognition and characterization; deep learning, online learning, and graphical models applied to speech, audio, and language signals; and implementation aspects ranging from system architecture to fast algorithms.
*   **Image and Video Processing (eess.IV)**  
    Theory, algorithms, and architectures for the formation, capture, processing, communication, analysis, and display of images, video, and multidimensional signals in a wide variety of applications. Topics of interest include: mathematical, statistical, and perceptual image and video modeling and representation; linear and nonlinear filtering, de-blurring, enhancement, restoration, and reconstruction from degraded, low-resolution or tomographic data; lossless and lossy compression and coding; segmentation, alignment, and recognition; image rendering, visualization, and printing; computational imaging, including ultrasound, tomographic and magnetic resonance imaging; and image and video analysis, synthesis, storage, search and retrieval.
*   **Signal Processing (eess.SP)**  
    Theory, algorithms, performance analysis and applications of signal and data analysis, including physical modeling, processing, detection and parameter estimation, learning, mining, retrieval, and information extraction. The term "signal" includes speech, audio, sonar, radar, geophysical, physiological, (bio-) medical, image, video, and multimodal natural and man-made signals, including communication signals and data. Topics of interest include: statistical signal processing, spectral estimation and system identification; filter design, adaptive filtering / stochastic learning; (compressive) sampling, sensing, and transform-domain methods including fast algorithms; signal processing for machine learning and machine learning for signal processing applications; in-network and graph signal processing; convex and nonconvex optimization methods for signal processing applications; radar, sonar, and sensor array beamforming and direction finding; communications signal processing; low power, multi-core and system-on-chip signal processing; sensing, communication, analysis and optimization for cyber-physical systems such as power grids and the Internet of Things.

### Mathematics (math)

*   **Commutative Algebra (math.AC)**  
    Commutative rings, modules, ideals, homological algebra, computational aspects, invariant theory, connections to algebraic geometry and combinatorics
*   **Algebraic Geometry (math.AG)**  
    Algebraic varieties, stacks, sheaves, schemes, moduli spaces, complex geometry, quantum cohomology
*   **Analysis of PDEs (math.AP)**  
    Existence and uniqueness, boundary conditions, linear and non-linear operators, stability, soliton theory, integrable PDE's, conservation laws, qualitative dynamics
*   **Algebraic Topology (math.AT)**  
    Homotopy theory, homological algebra, algebraic treatments of manifolds
*   **Classical Analysis and ODEs (math.CA)**  
    Special functions, orthogonal polynomials, harmonic analysis, ODE's, differential relations, calculus of variations, approximations, expansions, asymptotics
*   **Combinatorics (math.CO)**  
    Discrete mathematics, graph theory, enumeration, combinatorial optimization, Ramsey theory, combinatorial game theory
*   **Category Theory (math.CT)**  
    Enriched categories, topoi, abelian categories, monoidal categories, homological algebra
*   **Complex Variables (math.CV)**  
    Holomorphic functions, automorphic group actions and forms, pseudoconvexity, complex geometry, analytic spaces, analytic sheaves
*   **Differential Geometry (math.DG)**  
    Complex, contact, Riemannian, pseudo-Riemannian and Finsler geometry, relativity, gauge theory, global analysis
*   **Dynamical Systems (math.DS)**  
    Dynamics of differential equations and flows, mechanics, classical few-body problems, iterations, complex dynamics, delayed differential equations
*   **Functional Analysis (math.FA)**  
    Banach spaces, function spaces, real functions, integral transforms, theory of distributions, measure theory
*   **General Mathematics (math.GM)**  
    Mathematical material of general interest, topics not covered elsewhere
*   **General Topology (math.GN)**  
    Continuum theory, point-set topology, spaces with algebraic structure, foundations, dimension theory, local and global properties
*   **Group Theory (math.GR)**  
    Finite groups, topological groups, representation theory, cohomology, classification and structure
*   **Geometric Topology (math.GT)**  
    Manifolds, orbifolds, polyhedra, cell complexes, foliations, geometric structures
*   **History and Overview (math.HO)**  
    Biographies, philosophy of mathematics, mathematics education, recreational mathematics, communication of mathematics
*   **K-Theory and Homology (math.KT)**  
    Algebraic and topological K-theory, relations with topology, commutative algebra, and operator algebras
*   **Logic (math.LO)**  
    Logic, set theory, point-set topology, formal mathematics
*   **Metric Geometry (math.MG)**  
    Euclidean, hyperbolic, discrete, convex, coarse geometry, comparisons in Riemannian geometry, symmetric spaces
*   **Numerical Analysis (math.NA)**  
    Numerical algorithms for problems in analysis and algebra, scientific computation
*   **Number Theory (math.NT)**  
    Prime numbers, diophantine equations, analytic number theory, algebraic number theory, arithmetic geometry, Galois theory
*   **Operator Algebras (math.OA)**  
    Algebras of operators on Hilbert space, C^\*-algebras, von Neumann algebras, non-commutative geometry
*   **Optimization and Control (math.OC)**  
    Operations research, linear programming, control theory, systems theory, optimal control, game theory
*   **Probability (math.PR)**  
    Theory and applications of probability and stochastic processes: e.g. central limit theorems, large deviations, stochastic differential equations, models from statistical mechanics, queuing theory
*   **Quantum Algebra (math.QA)**  
    Quantum groups, skein theories, operadic and diagrammatic algebra, quantum field theory
*   **Rings and Algebras (math.RA)**  
    Non-commutative rings and algebras, non-associative algebras, universal algebra and lattice theory, linear algebra, semigroups
*   **Representation Theory (math.RT)**  
    Linear representations of algebras and groups, Lie theory, associative algebras, multilinear algebra
*   **Symplectic Geometry (math.SG)**  
    Hamiltonian systems, symplectic flows, classical integrable systems
*   **Spectral Theory (math.SP)**  
    Schrodinger operators, operators on manifolds, general differential operators, numerical studies, integral operators, discrete models, resonances, non-self-adjoint operators, random operators/matrices
*   **Statistics Theory (math.ST)**  
    math.ST is an alias for stat.TH. Applied, computational and theoretical statistics: e.g. statistical inference, regression, time series, multivariate analysis, data analysis, Markov chain Monte Carlo, design of experiments, case studies

### Physics (physics)

*   ### Astrophysics (astro-ph)
    

*   **Cosmology and Nongalactic Astrophysics (astro-ph.CO)**  
    Phenomenology of early universe, cosmic microwave background, cosmological parameters, primordial element abundances, extragalactic distance scale, large-scale structure of the universe. Groups, superclusters, voids, intergalactic medium. Particle astrophysics: dark energy, dark matter, baryogenesis, leptogenesis, inflationary models, reheating, monopoles, WIMPs, cosmic strings, primordial black holes, cosmological gravitational radiation
*   **Earth and Planetary Astrophysics (astro-ph.EP)**  
    Interplanetary medium, planetary physics, planetary astrobiology, extrasolar planets, comets, asteroids, meteorites. Structure and formation of the solar system
*   **Astrophysics of Galaxies (astro-ph.GA)**  
    Phenomena pertaining to galaxies or the Milky Way. Star clusters, HII regions and planetary nebulae, the interstellar medium, atomic and molecular clouds, dust. Stellar populations. Galactic structure, formation, dynamics. Galactic nuclei, bulges, disks, halo. Active Galactic Nuclei, supermassive black holes, quasars. Gravitational lens systems. The Milky Way and its contents
*   **High Energy Astrophysical Phenomena (astro-ph.HE)**  
    Cosmic ray production, acceleration, propagation, detection. Gamma ray astronomy and bursts, X-rays, charged particles, supernovae and other explosive phenomena, stellar remnants and accretion systems, jets, microquasars, neutron stars, pulsars, black holes
*   **Instrumentation and Methods for Astrophysics (astro-ph.IM)**  
    Detector and telescope design, experiment proposals. Laboratory Astrophysics. Methods for data analysis, statistical methods. Software, database design
*   **Solar and Stellar Astrophysics (astro-ph.SR)**  
    White dwarfs, brown dwarfs, cataclysmic variables. Star formation and protostellar systems, stellar astrobiology, binary and multiple systems of stars, stellar evolution and structure, coronas. Central stars of planetary nebulae. Helioseismology, solar neutrinos, production and detection of gravitational radiation from stellar systems

*   ### Condensed Matter (cond-mat)
    

*   **Disordered Systems and Neural Networks (cond-mat.dis-nn)**
*   **Mesoscale and Nanoscale Physics (cond-mat.mes-hall)**  
    Semiconducting nanostructures: quantum dots, wires, and wells. Single electronics, spintronics, 2d electron gases, quantum Hall effect, nanotubes, graphene, plasmonic nanostructures
*   **Materials Science (cond-mat.mtrl-sci)**  
    Techniques, synthesis, characterization, structure. Structural phase transitions, mechanical properties, phonons. Defects, adsorbates, interfaces
*   **Other Condensed Matter (cond-mat.other)**  
    Work in condensed matter that does not fit into the other cond-mat classifications
*   **Quantum Gases (cond-mat.quant-gas)**  
    Ultracold atomic and molecular gases, Bose-Einstein condensation, Feshbach resonances, spinor condensates, optical lattices, quantum simulation with cold atoms and molecules, macroscopic interference phenomena
*   **Soft Condensed Matter (cond-mat.soft)**  
    Membranes, polymers, liquid crystals, glasses, colloids, granular matter
*   **Statistical Mechanics (cond-mat.stat-mech)**  
    Phase transitions, thermodynamics, field theory, non-equilibrium phenomena, renormalization group and scaling, integrable models, turbulence
*   **Strongly Correlated Electrons (cond-mat.str-el)**  
    Quantum magnetism, non-Fermi liquids, spin liquids, quantum criticality, charge density waves, metal-insulator transitions
*   **Superconductivity (cond-mat.supr-con)**  
    Superconductivity: theory, models, experiment. Superflow in helium

*   ### General Relativity and Quantum Cosmology (gr-qc)
    

*   **General Relativity and Quantum Cosmology (gr-qc)**

*   ### High Energy Physics - Experiment (hep-ex)
    

*   **High Energy Physics - Experiment (hep-ex)**

*   ### High Energy Physics - Lattice (hep-lat)
    

*   **High Energy Physics - Lattice (hep-lat)**

*   ### High Energy Physics - Phenomenology (hep-ph)
    

*   **High Energy Physics - Phenomenology (hep-ph)**

*   ### High Energy Physics - Theory (hep-th)
    

*   **High Energy Physics - Theory (hep-th)**

*   ### Mathematical Physics (math-ph)
    

*   **Mathematical Physics (math-ph)**

*   ### Nonlinear Sciences (nlin)
    

*   **Adaptation and Self-Organizing Systems (nlin.AO)**  
    adaptation, self-organizing systems, statistical physics, fluctuating systems, stochastic processes, interacting particle systems, machine learning
*   **Chaotic Dynamics (nlin.CD)**  
    dynamical systems, chaos, quantum chaos, topological dynamics, cycle expansions, turbulence, propagation
*   **Cellular Automata and Lattice Gases (nlin.CG)**  
    computational methods, time series analysis, signal processing, wavelets, lattice gases
*   **Pattern Formation and Solitons (nlin.PS)**  
    pattern formation, coherent structures, solitons
*   **Exactly Solvable and Integrable Systems (nlin.SI)**  
    exactly solvable systems, integrable PDEs, integrable ODEs, Painleve analysis, integrable discrete maps, solvable lattice models, integrable quantum systems

*   ### Nuclear Experiment (nucl-ex)
    

*   **Nuclear Experiment (nucl-ex)**

*   ### Nuclear Theory (nucl-th)
    

*   **Nuclear Theory (nucl-th)**

*   ### Physics (physics)
    

*   **Accelerator Physics (physics.acc-ph)**
*   **Atmospheric and Oceanic Physics (physics.ao-ph)**
*   **Applied Physics (physics.app-ph)**
*   **Atomic and Molecular Clusters (physics.atm-clus)**
*   **Atomic Physics (physics.atom-ph)**
*   **Biological Physics (physics.bio-ph)**
*   **Chemical Physics (physics.chem-ph)**
*   **Classical Physics (physics.class-ph)**
*   **Computational Physics (physics.comp-ph)**
*   **Data Analysis, Statistics and Probability (physics.data-an)**
*   **Physics Education (physics.ed-ph)**
*   **Fluid Dynamics (physics.flu-dyn)**
*   **General Physics (physics.gen-ph)**
*   **Geophysics (physics.geo-ph)**
*   **History and Philosophy of Physics (physics.hist-ph)**
*   **Instrumentation and Detectors (physics.ins-det)**
*   **Medical Physics (physics.med-ph)**
*   **Optics (physics.optics)**
*   **Plasma Physics (physics.plasm-ph)**
*   **Popular Physics (physics.pop-ph)**
*   **Physics and Society (physics.soc-ph)**
*   **Space Physics (physics.space-ph)**

*   ### Quantum Physics (quant-ph)
    

*   **Quantum Physics (quant-ph)**

### Quantitative Biology (q-bio)

*   **Biomolecules (q-bio.BM)**  
    DNA, RNA, proteins, lipids, etc.; molecular structures and folding kinetics; molecular interactions; single-molecule manipulation.
*   **Cell Behavior (q-bio.CB)**  
    Cell-cell signaling and interaction; morphogenesis and development; apoptosis; bacterial conjugation; viral-host interaction; immunology
*   **Genomics (q-bio.GN)**  
    DNA sequencing and assembly; gene and motif finding; RNA editing and alternative splicing; genomic structure and processes (replication, transcription, methylation, etc); mutational processes.
*   **Molecular Networks (q-bio.MN)**  
    Gene regulation, signal transduction, proteomics, metabolomics, gene and enzymatic networks
*   **Neurons and Cognition (q-bio.NC)**  
    Synapse, cortex, neuronal dynamics, neural network, sensorimotor control, behavior, attention
*   **Other Quantitative Biology (q-bio.OT)**  
    Work in quantitative biology that does not fit into the other q-bio classifications
*   **Populations and Evolution (q-bio.PE)**  
    Population dynamics, spatio-temporal and epidemiological models, dynamic speciation, co-evolution, biodiversity, foodwebs, aging; molecular evolution and phylogeny; directed evolution; origin of life
*   **Quantitative Methods (q-bio.QM)**  
    All experimental, numerical, statistical and mathematical contributions of value to biology
*   **Subcellular Processes (q-bio.SC)**  
    Assembly and control of subcellular structures (channels, organelles, cytoskeletons, capsules, etc.); molecular motors, transport, subcellular localization; mitosis and meiosis
*   **Tissues and Organs (q-bio.TO)**  
    Blood flow in vessels, biomechanics of bones, electrical waves, endocrine system, tumor growth

### Quantitative Finance (q-fin)

*   **Computational Finance (q-fin.CP)**  
    Computational methods, including Monte Carlo, PDE, lattice and other numerical methods with applications to financial modeling
*   **General Finance (q-fin.GN)**  
    Development of general quantitative methodologies with applications in finance
*   **Mathematical Finance (q-fin.MF)**  
    Mathematical and analytical methods of finance, including stochastic, probabilistic and functional analysis, algebraic, geometric and other methods
*   **Portfolio Management (q-fin.PM)**  
    Security selection and optimization, capital allocation, investment strategies and performance measurement
*   **Pricing of Securities (q-fin.PR)**  
    Valuation and hedging of financial securities, their derivatives, and structured products
*   **Risk Management (q-fin.RM)**  
    Measurement and management of financial risks in trading, banking, insurance, corporate and other applications
*   **Statistical Finance (q-fin.ST)**  
    Statistical, econometric and econophysics analyses with applications to financial markets and economic data
*   **Trading and Market Microstructure (q-fin.TR)**  
    Market microstructure, liquidity, exchange and auction design, automated trading, agent-based modeling and market-making

### Statistics (stat)

*   **Applications (stat.AP)**  
    Biology, Education, Epidemiology, Engineering, Environmental Sciences, Medical, Physical Sciences, Quality Control, Social Sciences
*   **Computation (stat.CO)**  
    Algorithms, Simulation, Visualization
*   **Methodology (stat.ME)**  
    Design, Surveys, Model Selection, Multiple Testing, Multivariate Methods, Signal and Image Processing, Time Series, Smoothing, Spatial Statistics, Survival Analysis, Nonparametric and Semiparametric Methods
*   **Machine Learning (stat.ML)**  
    Classification, Graphical Models, High Dimensional Inference
*   **Other Statistics (stat.OT)**  
    Work in statistics that does not fit into the other stat classifications
