Third party submission
======================

In general [author self-submission](submit) is preferred because our
experience shows that there are far fewer errors and misunderstandings
than with submissions made by third-parties. However, arXiv does permit
and provide special facilities for third party submission by trusted
proxies in some circumstances. These circumstances include:

-   Proxy submissions from our partner site
    [HAL](http://hal.archives-ouvertes.fr/index.php?langue=en), operated
    by CCSD in France.
-   Open access archiving arrangements with recognized journals and
    societies such as the [Institute of Mathematical
    Statistics](http://www.imstat.org/publications/arxiv.html).
-   Automated deposit of conference proceedings from conference
    management systems. Such deposit is currently support by the
    Microsoft [Conference Management
    Toolkit](http://cmt.research.microsoft.com/cmt/) (e.g. articles from
    CIDR2007: [arXiv:cs/0612137](/abs/cs/0612137),
    [arXiv:cs/0612129](/abs/cs/0612129),...).
-   Proxy submissions from overlay journals such as
    [EPTCS](http://eptcs.org/).
-   Submissions by administrative assistants etc., though discouraged,
    are permitted. Please ensure that an author checks the submission is
    correct in time to notify arXiv administrators of any problem before
    announcement. In the case that the assistant uses the author's
    account then no special arrangements with arXiv need to be made.

Remember that [submissions cannot be removed once announced](versions),
changes may be made only by [replacement](replace) which creates a new
version and will not erase the original.

Proxy submission requirements
-----------------------------

arXiv has special facilities for **proxy** submitters. Potential proxy
submitters must [contact arXiv administrators](contact) explaining the
circumstances for their request of proxy privileges, and confirming that
the requirements below will be met.

-   Proxy submitters must provide a valid contact email address to a
    reliable and named contact person when creating an arXiv account.
-   Articles are subject to
    arXiv's [moderation](moderation) process.
-   Articles must be classified individually and carefully based on
    their content rather than being submitted to a category based solely
    on the focus of the conference or journal in which they appear.
-   Articles that are not appropriate to a category within arXiv must
    not be submitted.
-   Metadata must be validated by an author of the article prior to
    submission (provide details from, or links to, arXiv [preparation
    instructions](prep)).
-   Submissions may be made either manually via arXiv's normal
    submission interface (see [submission help](submit)) or via our
    automated SWORD interface (see [SWORD help](submit_sword) and
    [contact arXiv administrators](contact) for permission).
-   An email address for the corresponding author must be provided with
    each submission (this will be requested in addition to other
    metadata when submissions are made via proxy submission accounts; it
    is a separate metadata field for SWORD deposits).
-   Proxy submitters must not make more that 10 submissions in a day
    without prior approval from arXiv administrators (this rule avoids
    overloading arXiv administrators and moderators; excessive numbers
    of submissions may simply be removed from the queue *en masse*).
-   When submitting TeX source, the complete source files (see [TeX
    source help](submit_tex)) must be provided to enable processing .
    When author-produced PDF is submitted, *only* the PDF file should be
    uploaded ([PDF submission help](submit_pdf)).
-   There are some test facilities for those developing new SWORD upload
    software or to check particular TeX processing requirements.
    [Contact arXiv administrators](contact) if you have a need for these
    facilities.

Proxy submission privileges may be revoked temporarily or permanently if
a proxy submitter violates these rules or otherwise causes excessive
numbers of problems. If in doubt, please [ask arXiv
administrators](contact) and wait for a response before attempting
anything that might create additional work or disrupt arXiv operation.
