Submission Version Availability
===============================

In order to successfully complete a submission, a submitter agrees to
our policy that all submitted works cannot be removed once publicly
available. If an author needs to update the article after announcement,
they may replace or withdraw the article, which creates a new version.
This increments the version portion of the arXiv identifier. An example
article with multiple versions is [arXiv:1710.02185](/abs/1710.02185).

Making previous versions of submitted papers publicly available archives
the historical record of research work. As such, it is a useful aid to
peer review and verification of intellectual priority.

What does arXiv mean by versions?
---------------------------------

All submissions receive a "date stamp", recorded as the time the
submitter clicks "Submit article" at the end of the submission process.
Once a submission is made available, it receives a permanent [arXiv
identifier](arxiv_identifier). Any replacement or withdrawal of that
article generates a new version. This will increment its version number
by one, with the most recent version always being displayed, even when
the Abstract page is viewed without a version number at the end, such as
the above example, `https://arxiv.org/abs/1710.02185`. For information
on how to cite individual versions, please see the related
[references](faq/references) FAQ page.

What constitutes a version?
---------------------------

A version will be created once a [replacement](replace) or
[withdrawal](withdraw) submission is made public. The *Submission
history* section of the Abstract page indicates the version number being
viewed, as well as all available versions.

Replacements will contain the full text of the article. Withdrawals will
display the reason for withdrawal entered as a comment, without any
content download options for that version.

Can versions be removed?
------------------------

arXiv is intended as a historical collection of research works, and as
such, we do not consider removal from the repository an option. Once
made public, submissions are considered a permanent part of the
scientific record and may not be removed by user intervention.

<span id="pre9710"></span>

What is the historical context driving the versioning?
------------------------------------------------------

Beginning in October 1997, all official versions of papers submitted
were made publicly available from the website.

For submissions made before October 1997, only the latest version of
each paper was recorded and available. The dates of all revisions were,
however, stored and shown on the Abstract page.
