Cond-mat archive reorganization
===============================

Because of the continued growth of the cond-mat e-print archive (see the [monthly totals](http://xxx.lanl.gov/year/cond-mat/96)), many people have desired a bit of reorganization. This is now implemented.

Now on cond-mat you can include a **Subj-class:** header with submissions. This is most easily done with a select menu for [web submissions](/help/uploads), or alternatively it can be included in e-mail submissions; see our [abstract preparation help](/help/prep). Subject classes must be chosen from the list below. People who subscribe to cond-mat as is would see no difference, except the listings can be sorted by the subject classification. You may, however, subscribe to any subset of classifications; see our [physics subscription help](http://xxx.lanl.gov/new/physsub.html). In this sense, each subject class is like a new archive.

We believe that this is a more efficient method for expansion than adding new archives. As we've seen with supr-con, many don't necessarily use a new archive, and those who do typically cross-list to cond-mat anyway. This method also avoids the trauma of papers being redirected away from the cond-mat archive and moreover makes it easy to expand by adding a new Subj-class.

So we would like to hear what you think of this general reorganization, but we especially want comments on the list of subject classifications. This should not only effectively organize the current subject matters covered, but also encourage submissions from groups of people who currently don't use the archive (e.g. experimentalists).

The initial list of subject classes is:

*   **Disordered Systems and Neural Networks**
*   **Materials Science** (the mtrl-th archive is being moved into cond-mat)
*   **Mesoscopic Systems and Quantum Hall Effect**
*   **Soft Condensed Matter**
*   **Statistical Mechanics**
*   **Strongly Correlated Electrons**
*   **Superconductivity** (the supr-con archive is being moved into cond-mat)

Note in particular that there is no distinct Condensed Matter Experiment: experimentalists should feel actively encouraged to send their papers to the cond-mat archive with the appropriate Subj-class heading as above.

Surely we've missed some important areas and perhaps didn't pick the best names. Such oversights can easily be corrected; we await user feedback to correct these and other omissions. The idea is not to come up with a detailed classification like PACS, but just to provide a simple way to make perusing cond-mat easy. Submissions to cond-mat have steadily increased since its inception, and we think this is a good time to implement some order. Even with 300 papers a month, this is still a small fraction of the total papers in condensed matter physics so the problems will only worsen.

Initially, it may be necessary to add the appropriate Subj-class manually here. We hope, however, the authors will adapt quickly to the new scheme so that manual intervention will become unnecessary.

We are also starting a "physics" archive, which will cover fields not currently served by the archives, and will use a similar subject-classification scheme. For details, see the [physics archive introduction](physics).

The subject classification was introduced on October 1, so send your comments to [www-admin@xxx.lanl.gov](mailto:www-admin@xxx.lanl.gov (cond reorg RFC)) as soon as possible for maximal effect.
