# Introducing arXiv EESS (Electrical Engineering and Systems Science)

The [Electrical Engineering and Systems Science](/archive/eess) archive (eess) was introduced 18 September 2017.

## Initial Announcement for eess Launch

In recent years, more and more electrical and systems engineers have been 
turning to arXiv to keep up to date with fresh research results, and to 
disseminate their own research findings quickly and effectively to a broad 
cross-disciplinary audience. arXiv preprints appear within a few days 
after submission, and reach multiple research communities in a short 
time. Many electrical engineering researchers have been actively posting 
preprints on arXiv, but the existing structure did not offer a natural 
home for their contributions. Signal processing researchers have been 
particularly active in arXiv, albeit they had to post their work under 
sister categories, such as stat.ML, stat.ME, math.IT, math.OC, cs.IT, 
cs.SY, physics.data-an, or phyics.soc-ph. 

In May 2016, Ali Sayed, President-elect of the IEEE Signal Processing 
Society (SPS), created an ad-hoc committee chaired by Nikos Sidiropoulos, 
tasked with exploring the possibility of opening up a new signal processing 
domain under arXiv. After about a year of deliberations, the arXiv 
Scientific Advisory Board and the SPS Board of Governors reached an agreement 
to open up a new top-level archive, Electrical Engineering and Systems 
Science, next to the existing ones (Physics, Mathematics, Computer Science, 
Quantitative Biology, Quantitative Finance, and Statistics). 

The new Electrical Engineering and Systems Science (EESS) archive is designed 
to accommodate contributions addressing analytical and computational aspects 
of Electrical Engineering (including Signals, Systems, Communications, Networking, 
and Information Theory and Methods) and Systems Science in a broader sense that 
includes Dynamical Systems and Control research motivated by electrical, chemical, 
mechanical, aerospace and other cross-disciplinary (e.g., vehicular) engineering 
applications, as well as the analysis, optimization and control of cyber-physical 
systems such as power grids and the Internet of Things. 

Al Hero, the John H. Holland Distinguished University Professor of Electrical 
Engineering and Computer Science at the University of Michigan, has kindly agreed 
to serve as initial Chair for the new EESS archive, which will be seeded with 
three categories.

The above moderators are all highly appreciated researchers and volunteer leaders in their 
respective areas. We anticipate that additional categories will be added and/or 
cross-listed under EESS -- from information theory, control, and dynamical systems 
in the foreseeable future. 

Please see the descriptions of the subject categories and access papers from <a href="/archive/eess">https://arxiv.org/archive/eess</a>. New readers and authors to arXiv should see our help pages for [registration](/help/registerhelp), [submission](/help/submit) and [subscription](/help/subscribe).

We hope that this new archive will facilitate the rapid exchange of exciting signals, 
systems, communication, and information theory ideas; catalyze cross-disciplinary 
interactions; and enhance the visibility of EESS research. Please join us in 
contributing your work to EESS and following the work of your peers in EESS! 
