---
title: arXiv News and Announcements
---

What's been New on the [arXiv.org](/) e-print archives
======================================================

(Announcements since Summer 1996. See also more haphazard collections of messages from [1994-1996](/new/94-96) and [1991-1994](/new/91-94).)

#### November 2020
<span id="2020Nov13"></span>

13 November 2020


**November 2020 Holiday Schedule:** For the US Thanksgiving holiday there will be no new submission announcement and limited user support for Thursday 26 November 2020. 

Papers submitted after 14:00 Eastern on Wednesday 25 November and before 14:00 Eastern on Friday 27 November will be announced at 20:00 Eastern on Sunday 29 November. This only affects announcement of new submissions. We will still be accepting submissions and the arXiv site will continue to be available for browsing existing papers.

**December 2020 Holiday Schedule:** 

 - *No new submission announcement on 27 December 2020.* Our staff will be on holiday and there will be limited user support for Friday 25 December 2020. There will also be no new submission announcement at 20:00 Eastern Sunday 27 December. 
Papers submitted after 14:00 Eastern on Thursday 24 December and before 14:00 Eastern on Monday 28 December will be announced at 20:00 Eastern on Monday 28 December.
 - *No new submission announcement on 29 and 30 December 2020.* There will be no new submission announcement and limited user support for Tuesday 29 December and Wednesday 30 December 2020.
Papers submitted after 14:00 Eastern on Monday 28 December and before 14:00 Eastern on Thursday 31 December will be announced at 20:00 Eastern on Thursday 31 December.
 - *No new submission announcement on 01 January 2021.* There will be no new submission announcement and limited user support for Tuesday 29 December and Wednesday 30 December 2020.
Papers submitted after 14:00 Eastern on Monday 28 December and before 14:00 Eastern on Thursday 31 December will be announced at 20:00 Eastern on Thursday 31 December.

The staff holidays only affects announcement of new submissions. We will still be accepting submissions and the arXiv site will continue to be available for browsing existing papers.

#### June 2020
<span id="5June2020"></span>

5 June 2020

**5 June 2020 - Service notice for 9 June 2020 :** The mailings and the public announcement of new submissions will be deferred for Tuesday 9 June 2020. The arXiv servers will remain in operation. In addition, arXiv staff will provide limited service in response to queries during this time. 

- Articles received at or after 14:00 ET Monday 8 June 2020 and before 14:00 ET Wednesday 10 June 2020 will be announced at 20:00 ET Wednesday 10 June 2020.



#### January 2020
<span id="6Jan2020"></span>

6 January 2020

**20 January - Martin Luther King, Jr. Holiday Schedule:** The mailings and the public availability of new submissions will be deferred for 20 January 2020. The arXiv servers will otherwise remain in operation. In addition, arXiv staff will provide limited service in response to queries during the holiday. 

- Articles received at or after 14:00 ET Friday, 17 January 2020 and before 14:00 ET Tuesday, 21 January 2020 will be announced at 20:00 ET Tuesday, 21 January 2020.


#### October 2019
<span id="2019Oct31"></span>

31 October 2019


**November Holiday Schedule:** The mailings and the public availability of new submissions will be deferred
for 28 November 2019. The arXiv servers will otherwise remain in operation. In addition, arXiv staff will provide 
limited service in response to queries during this period.

- Articles received at or after 14:00 ET Wednesday, 27 November 2019 and before 14:00 ET Friday, 29 November 2019
 will be announced at 20:00 ET Sunday, 1 December 2019. 

**December Holiday Schedule** The mailings and the public availability of new submissions will be deferred for 
25 December, 26 December, and 30 December 2019, as well as 1 January 2020. The arXiv servers will otherwise remain 
in operation. In addition, arXiv staff will provide limited service in response to queries during these periods.

- Articles received at or after 14:00 ET Tuesday, 24 December 2019 and before 14:00 ET Friday, 27 December 2019 
  will be announced at 20:00 ET Sunday, 29 December 2019.
- Articles received at or after 14:00 ET Friday, 27 December 2019 and before 14:00 ET Tuesday, 31 December 2019 
  will be announced at 20:00 ET Tuesday, 31 December 2019.
- Articles received at or after 14:00 ET Tuesday, 31 December 2019 and before 14:00 ET Thursday, 2 January 2020
  will be announced at 20:00 ET 2 January 2020.
  -  **Note:** articles submitted at or after 14:00 ET Tuesday, 31 December 2019 will receive `arXiv:2001.NNNNN` identifiers.


#### September 2019
<span id="sep23_2019"></span>
23 September 2019

**Donate to arXiv:** arXiv is supported by a community of individuals, institutions, and organizations that depend on arXiv as an integral part of the scientific community. Join our supporters and [donate to arXiv](/about/donate) during our giving campaign September 23-27.



#### August 2019

<span id="august20_2019"></span>
19 August 2019

**2 September - Labor Day Holiday Schedule:** The mailings and the public availability of new submissions will be deferred for 2 September 2019. The arXiv servers will otherwise remain in operation. In addition, arXiv staff will provide limited service in response to queries during the holiday. 

- Articles received at or after 14:00 ET Friday, 30 August 2019 and before 14:00 ET Tuesday, 3 September 2019 will be announced at 20:00 ET Tuesday, 3 September 2019.
  


#### June 2019

<span id="june11_2019"></span>
11 June 2019

**arXiv created a Systems and Control category eess.SY that will merge with cs.SY. We also merged the existing Numerical Analysis categories math.NA/cs.NA**

Two changes to arXiv categories were made today. 

The category for Systems and Control is making the move from computer science to electrical engineering and systems science, where it is a better fit. Users can still submit and search for cs.SY, however the canonical display will be eess.SY. The full description for Systems and Control eess.SY is at https://arxiv.org/archive/eess.

arXiv is also merging the math and computer science categories for Numerical Analysis. The category description is: Numerical algorithms for problems in analysis and algebra, scientific computation. The merge will setup math.NA to be the canonical category for cs.NA. 

Thank you to arXiv moderators, subject advisory committees, and scientific advisory board members who provided leadership and input on these changes. Special thanks to our math.NA and cs.NA moderators for putting in extra effort over the past two month to pilot this move.

#### April 2019

<span id="apr22_2019"></span>
22 April 2019

**Donate to arXiv:** arXiv is supported by a community of individuals, institutions, and organizations that depend on arXiv as an integral part of the scientific community. Join our supporters and [donate to arXiv](/about/donate) during our giving campaign April 22–26.


#### February 2019

<span id="feb13_2019"></span>
13 February 2019

**Help and About Pages Updated:** We have begun the process of updating our Help and About pages in a new template as part of the Next Gen rebuild. For more information please see [our blog post](https://blogs.cornell.edu/arxiv/2019/02/14/help-pages-update/).


#### January 2019

<span id="jan14_2019"></span>
14 January 2019

**arXiv Update:** A project update, including a brief summary of activities in 2018, has been <a href="https://confluence.cornell.edu/x/rIzLFQ">posted</a>.

<span id="jan03_2019"></span>
3 January 2019

**21 January - Martin Luther King, Jr. Holiday Schedule:** The mailings and the public availability of new submissions will be deferred for 21 January 2019. The arXiv servers will otherwise remain in operation. In addition, arXiv staff will provide limited service in response to queries during the holiday. 

- Articles received at or after 14:00 ET Friday, 18 January 2019 and before 14:00 ET Tuesday, 22 January 2019 will be announced at 20:00 ET Tuesday, 22 January 2019.
  
  
#### Dec 2018

<span id="dec03_2018"></span>
3 Dec 2018

December 2018 Holiday Schedule:</b> The mailings and the public availability of new submissions will be deferred for 24 December, 25 December, and 27 December 2018, as well as 1 January 2019. The arXiv servers will otherwise remain in operation. In addition, arXiv staff will provide limited service in response to queries during these periods.

- Articles received at or after 14:00 ET Thursday, 20 December 2018 and before 14:00 ET Friday, 21 December 2018 will be announced at 20:00 ET Sunday, 23 December 2018.
- Articles received at or after 14:00 ET Friday, 21 December 2018 and before 14:00 ET Wednesday, 26 December 2018 will be announced at 20:00 ET Wednesday, 26 December 2018.
- Articles received at or after 14:00 ET Wednesday, 26 December 2018 and before 14:00 ET Friday, 28 December 2018 will be announced at 20:00 ET Sunday, 30 December 2018.
- Articles received at or after 14:00 ET Friday, 28 December 2018 and before 14:00 ET Monday, 31 December 2018 will be announced at 20:00 ET Monday, 31 December 2018.
- Articles received at or after 14:00 ET Monday, 31 December 2018 and before 14:00 ET  Wednesday, 2 January 2019 will be announced at 20:00 ET Wednesday, 2 January 2019.

   *Note:* articles submitted at or after 14:00 ET Monday, 31 December 2018 will receive arXiv:1901.nnnnn identifiers.
  
  
  
#### Nov 2018

<span id="nov06_2018"></span>
6 Nov 2018

**Thanksgiving Holiday Schedule:** The mailings and the public availability of new submissions will be deferred for 22 November 2018. The arXiv servers will otherwise remain in operation. In addition, arXiv staff will provide limited service in response to queries during this periods. 

- Articles received at or after 14:00 ET Wednesday, 21 November 2018 and before 14:00 ET Friday, 23 November 2018 will be announced at 20:00 ET Sunday, 25 November 2018.

#### Sept 2018

5 Sept 2018

**arXiv looks to the future with move to Cornell CIS**

We are pleased to announce that arXiv will move from the Cornell University Library (CUL) to Cornell Computing and Information Science (CIS) in January 2019. As far as researchers and arXiv users are concerned, the stewardship transition will be seamless and unnoticeable. Although the arXiv team is currently housed at the Library, the operation is independent of the Library's organizational, technical, and financial infrastructure. We have decided that CIS is better positioned to move arXiv forward into the next phase of the service's development after a careful assessment process. See [press release](https://cis.cornell.edu/arxiv-looks-future-move-cornell-cis ) and [transition FAQ](https://confluence.cornell.edu/x/qspyFQ ) for more information.

#### Jul 2018

23 Jul 2018

**Theoretical Economics and General Economics subject areas have been added:**

*   **econ.TH** - Theoretical Economics  
    Includes theoretical contributions to Contract Theory, Decision Theory, Game Theory, General Equilibrium, Growth, Learning and Evolution, Macroeconomics, Market and Mechanism Design, and Social Choice.
*   **econ.GN** - General Economics  
    General methodological and applied contributions to economics.

Additionally, **econ.GN** is now the canonical category for **q-fin.EC**.

To subscribe to the daily e-mail notifications for econ.TH or econ.GN, please see the [subscription instructions](/help/subscribe).

18 Jul 2018

**[Search interface updated to version 0.4](https://blogs.cornell.edu/arxiv/2018/07/18/search-v0-4-bug-fixes-date-related-searches/)**

#### Jun 2018

25 Jun 2018

**Holiday Schedule:** The mailings and the public availability of new submissions will be deferred for 3 September 2018. The arXiv servers will otherwise remain in operation, and user queries will receive responses the following business day.

*   Articles received at or after 14:00 EDT Friday, 31 August 2018 and before 14:00 EDT Tuesday, 4 September 2018 will be announced at 20:00 EST Tuesday, 4 September 2018.  
    **Note:** articles submitted at or after 14:00 EDT Friday, 31 August 2018 will receive arXiv:1809.nnnnn identifiers.

#### May 2018

14 May 2018

**[Search interface updated to version 0.3](https://confluence.cornell.edu/x/mBtOFQ)**

5 May 2018

**[New search interface updated to version 0.2](https://blogs.cornell.edu/arxiv/2018/05/04/release-search-v0-2-some-notes-on-names/)**

#### Apr 2018

17 Apr 2018

**[New search interface launched](https://arxiv.org/search)**

A [description](https://blogs.cornell.edu/arxiv/2018/04/17/new-release-arxiv-search-v0-1/) of the new system is available on the arXiv blog.

#### Mar 2018

26 Mar 2018

**ATTENTION SUBMITTERS AND READERS:** due to an unscheduled outage in our server farm late this afternoon, we have postponed tonight's mailing; it will be combined with the mailing tomorrow (Tuesday, March 27). We apologize for the interruption in service.

More information about the service outage is available [here](https://itservicealerts.hosting.cornell.edu/view/5163).

#### Jan 2018

05 Jan 2018

**ATTENTION SUBMITTERS AND READERS:** due to a technical problem last night, we will be combining yesterday's announcements and mailing with Sunday night's. We apologize for the delay.

02 Jan 2018

The [1991-2017 submission rate statistics](/help/stats/2017_by_area/index) are now available.

#### Nov 2017

15 Nov 2017

**Performance issues have been resolved:** arXiv.org has recovered from the effects of the [unplanned outage](https://itservicealerts.hosting.cornell.edu/view/4982) that occurred in our server farm.

If you sent an email to help or moderation between 7:00 EST Monday and 22:30 EST Tuesday, and did not receive an automated reply with a ticket ID, kindly resend your message. If you received an automated reply with a ticket ID, no further action is necessary and we will respond to your message as soon as possible.

13 Nov 2017

**arXiv.org is currently experiencing unexpected performance issues.** Please note that user support is temporarily unavailable. We will respond to emails to help and moderation as soon as possible once the issue is resolved.

#### Oct 2017

31 Oct 2017

**Holiday Schedule:** The mailings and the public availability of new submissions will be deferred for 23 November, 25 December, and 27 December 2017, as well as 1 January 2018. The arXiv servers will otherwise remain in operation. In addition, arXiv staff will provide limited service in response to queries during these periods.

*   Articles received at or after 14:00 EST Wednesday, 22 November 2017 and before 14:00 EST Friday, 24 November 2017 will be announced at 20:00 EST Sunday, 26 November 2017.
*   Articles received at or after 14:00 EST Friday, 22 December 2017 and before 14:00 EST Tuesday, 26 December 2017 will be announced at 20:00 EST Tuesday, 26 December 2017.
*   Articles received at or after 14:00 EST Tuesday, 26 December 2017 and before 14:00 EST Thursday, 28 December 2017 will be announced at 20:00 EST Thursday, 28 December 2017.
*   Articles received at or after 14:00 EST Friday, 29 December 2017 and before 14:00 EST Tuesday, 2 January 2018 will be announced at 20:00 EST Tuesday, 2 January 2018.  
    _Note:_ articles submitted at or after 14:00 EST Friday, 29 December 2017 will receive `arXiv:1801.nnnnn` identifiers.

11 Oct 2017

**Donate to arXiv Oct 16-19!**

arXiv is raising funds for [new initiatives](https://confluence.cornell.edu/x/y9ZRF), for more information see the [announcement](https://blogs.cornell.edu/arxiv/2017/10/11/donate-to-arxiv-2/).

#### Sep 2017

26 Sep 2017

**A new "Economics" (econ) archive has been launched.**

For more information, see the [announcement](/help/econ/announcement).

18 Sep 2017

**A new "Electrical Engineering and Systems Science" (eess) archive has been launched.**

For more information, see the [announcement](/help/eess/announcement).

11 Sep 2017

**Steinn Sigurdsson Appointed as arXiv Scientific Director**

We are pleased to announce that [Steinn Sigurdsson is arXiv's new Scientific Director](https://confluence.cornell.edu/display/arxivpub/2017/09/07/Steinn+Sigurdsson+Appointed+as+arXiv+Scientific+Director).

11 Sep 2017

**arXiv awarded grant from Heising-Simons Foundation**

[arXiv received $322,000 from the Heising-Simons Foundation](https://confluence.cornell.edu/display/arxivpub/2017/08/30/Grant+from+the+Heising-Simons+Foundation) to contribute to the arXiv-NG initiative, which aims to modernize arXiv's infrastructure and consider new models for the service's sustainability.

#### Aug 2017

08 Aug 2017

The arXiv team is gathering information on the use of the arXiv API and content in external applications. If you use the arXiv API or otherwise access arXiv content in a programmatic way, we invite you to take a [short survey](https://cornell.qualtrics.com/jfe/form/SV_4O4iQXSAYtQSyBD).

#### Apr 2017

20 Apr 2017

**A new Applied Physics subject area has been added:**

*   **physics.app-ph** - Applied Physics  
    Applications of physics to new technology, including: electronic devices; optics; photonics; microwaves; spintronics; advanced materials; metamaterials; nanotechnology; and energy sciences.

To subscribe to the daily e-mail notifications for physics.app-ph, please see the [subscription instructions](/help/subscribe).

#### Mar 2017

14 Mar 2017

**ATTENTION SUBMITTERS:** due to a temporary, unforeseen technical issue earlier today, we will be combining tonight's mailing with tomorrow night's mailing. We apologize for the inconvenience.

10 Mar 2017

New members join arXiv Member Advisory Board: As of 2017, arXiv's [Member Advisory Board](https://confluence.cornell.edu/x/NqlRF) has four new members:

*   Anne Langley, Associate Dean for Research, Collections, and Scholarly Communications, Penn State Libraries (Representing the Big Ten Academic Alliance)
*   Maria Heijne, Library Director, University of Amsterdam
*   Dr. Amberyn Thomas, Associate Director Scholarly Communication and Repository Services, University of Queensland
*   Anne Bell, University Librarian, University of Sydney

Our gratitude to outgoing MAB members Eva Isaksson, Philip Kent, Zhixiong Zhang and Jim Mullins for their service and their thoughtfulness.

06 Mar 2017

**arXiv Scientific Director Search:** arXiv seeks a Scientific Director to contribute to arXiv's scientific direction and policies. For additional information please see [the search posting](https://confluence.cornell.edu/x/JxVqF).

#### Feb 2017

22 Feb 2017

**DONATE to arXiv**

arXiv will run an online fundraising campaign for one week, from February 26 to March 4, 2017, to help raise additional funds (see [Donations to arXiv](https://arxiv.org/help/donate)). The baseline maintenance costs are sponsored by the 206 member organizations, the Simons Foundation, and Cornell University Library. This online campaign aims to garner additional resources from the program's active and supportive user base.

Stewardship of resources such as arXiv involves not only covering the operational costs but also continuing to enhance their value based on the needs of the user community and the evolving patterns and modes of scholarly communication. It is essential to raise additional funds in order to [fund new initiatives](https://confluence.cornell.edu/x/y9ZRF) that are beyond the routine operational work, and to robustly support arXiv's Open Access [mission](https://arxiv.org/help/primer). Donations to arXiv are [tax deductible](https://arxiv.org/help/support/faq#7C), eligible for employer matches, and easy to schedule. Donations can be made [here](https://goo.gl/QIgRpr). We thank you for your support.

10 Feb 2017

**Attention Submitters: Our TeX processing system has been updated**

The update includes a significantly upgraded TeX tree based on [TeX Live](https://www.tug.org/texlive/) 2016 and incorporates the latest versions of numerous local add-on packages. As of February 9, 2017 15:00 EST, new submissions will be processed with the updated tree.

#### Jan 2017

11 Jan 2017

**arXiv Update:** A project update, including a brief summary of activities in 2016, has been [posted online](https://confluence.cornell.edu/display/arxivpub/arXiv+Update+-+January+2017).

10 Jan 2017

New members join arXiv Scientific Advisory Board: As of 2017, arXiv's [Scientific Advisory Board](/help/scientific_ad_board) has two new members:

*   Tara Holm, Professor of Mathematics, Cornell University
*   Nicholas Read, the Henry Ford II Professor of Physics, Yale University  
    Nicholas Read has also replaced Daniel Gottesman as Chair of the arXiv Physics Advisory Committee

Our sincere gratitude to outgoing SAB member Karen Vogtmann. Thank you from all the arXiv SAB members and staff for your 12 years of service.

02 Jan 2017

The [1991-2016 submission rate statistics](/help/stats/2016_by_area/index) are now available.

#### Nov 2016

29 Nov 2016

**Alfred P. Sloan Foundation awards grant for arXiv upgrade**: see the [press release](https://www.library.cornell.edu/about/news/archive/alfred-p-sloan-foundation-awards-grant-arxiv-upgrade).

28 Nov 2016

**Attention Submitters: Submission Freeze Time is Changing**

Beginning January 2, 2017, the freeze time will change to 14:00 US Eastern time (EST/EDT).

The freeze time is the daily submission deadline. As of January 2, 2017, submissions received before 14:00 EST will be scheduled for the forthcoming announcement (usually the same day) and submissions received after 14:00 EST will be scheduled for the subsequent announcement. The reason for this change is the rising number of daily submissions and the need to give volunteer moderators and administrator staff time to complete their work.

Submissions to arXiv are normally announced Sunday - Thursday, with no announcments Friday - Saturday.

Submissions Received Between  
(all times Eastern US)

Will Be Announced  
(all times Eastern US)

Mailed to Subscribers

Monday 14:00 - Tuesday 14:00

Tuesday 20:00

Tuesday Night / Wednesday Morning

Tuesday 14:00 - Wednesday 14:00

Wednesday 20:00

Wednesday Night / Thursday Morning

Wednesday 14:00 - Thursday 14:00

Thursday 20:00

Thursday Night / Friday Morning

Thursday 14:00 - Friday 14:00

Sunday 20:00

Sunday Night / Monday Morning

Friday 14:00 - Monday 14:00

Monday 20:00

Monday Night / Tuesday Morning

14 Nov 2016

**Semantic Scholar Pilot for Computer Science Papers:** arXiv is collaborating on a [12-month pilot project](/help/semanticscholar) with the Allen Institute for Artificial Intelligence (AI2), making the AI-based semanticscholar.org search engine available to the arXiv community.

01 Nov 2016

**arXiv exceeds 10,000 submissions for October:** Last month was the first time in arXiv history that we exceeded 10,000 new submissions in one month. This milestone was predicted by Paul Ginsparg in 2014 based on historical growth trends and the numbers of weekdays per month. We thank our users for their continued support of arXiv!

**Projected and actual submissions ending Oct 31, 2016**  
![Projected and actual submissions ending Oct 31, 2016](https://static.arxiv.org/icons/oct_subs_2.png)

#### Oct 2016

25 Oct 2016

**Holiday Schedule:** To enable our administrators to spend local holidays with their families, mailings and the public availability of new submissions will be deferred for 24 Nov, 26 Dec, and 28 Dec; the arXiv servers will otherwise remain in operation. In addition, arXiv staff will provide limited service in response to queries during these periods.

*   Articles received at or after 16:00 EST Wed 23 Nov 2016 and before 16:00 EST Fri 25 Nov 2016 will be announced at 20:00 EST Sun 27 Nov 2016.
*   Articles received at or after 16:00 EST Fri 23 Dec 2016 and before 16:00 EST Tue 27 Dec 2016 will be announced at 20:00 EST Tue 27 Dec 2016.
*   Articles received at or after 16:00 EST Tue 27 Dec 2016 and before 16:00 EST Thu 29 Dec 2016 will be announced at 20:00 EST Thu 29 Dec 2016.
_Note:_ that articles submitted at or after 16:00 EST Fri 30 Dec 2016 will receive `arXiv:1701.nnnnn` identifiers.

#### Aug 2016

16 Aug 2016

arXiv.org will be down for maintenance August 18th 2016 from 8:20am to 9:20am EDT. To view articles please use [the mirrors.](/help/mirrors) The submission system and user log-in will be unavailable during the maintenance time.

#### Jul 2016

15 Jul 2016

arXiv.org will be down for maintenance July 24th 2016 from 10am til 11am EDT. To view articles please use [the mirrors.](/help/mirrors) The submission system and user log-in will be unavailable during the maintenance time.

#### Jun 2016

29 Jun 2016

We are pleased to share with you the [key findings of the arXiv user survey](https://confluence.cornell.edu/x/pLBRF). We were heartened to receive 36,000 responses, representing arXiv's diverse community. We express our deep gratitude to users who provided us with valuable input and thank each of you for making arXiv a part of your scholarship.

27 Jun 2016

**DONATE to arXiv:** arXiv will run an online fundraising campaign for one week, from June 27 to July 5, 2016, to help raise additional funds (see [Donations to arXiv](/help/donate)). The baseline maintenance costs are sponsored by the 190 member organizations, the Simons Foundation, and Cornell University Library. This new GIVE campaign aims to garner additional resources from the program's active and supportive user base. Stewardship of resources such as arXiv involves not only covering the operational costs but also continuing to enhance their value based on the needs of the user community and the evolving patterns and modes of scholarly communication. It is essential to raise additional funds in order to fund [new initiatives](https://confluence.cornell.edu/x/mbBRF) that are beyond the routine operational work. More information about this pilot is available in the [arXiv FAQ](http://arxiv.org/help/support/faq#personal). We thank you for your support.

#### Apr 2016

6 Apr 2016

**Take the arXiv user survey:** As an open-access site, arXiv serves people like you all over the world and your opinion counts. Please complete [this questionnaire](https://cornell.qualtrics.com/SE/?SID=SV_brM4ULfjHGClNJj) to help us improve arXiv and think of future directions for the service in a way that best serves users like you. The survey has four sections, and will take about 10 minutes to complete. We do not collect any information that can identify you and we will share only a summary of the results. Thank you!

#### Jan 2016

25 Jan 2016

**arXiv Update:** A project update, including a brief summary of activities in 2015, has been [posted online](https://confluence.cornell.edu/x/cKZRF).

1 Jan 2016

**New members join arXiv Scientific Advisory Board:** As of 2016, arXiv's [Scientific Advisory Board](/help/scientific_ad_board) has three new members:

*   David Eppstein, Chancellor's Professor of Computer Science, University of California, Irvine
*   Licia Verde, ICREA Research Professor, Universitat de Barcelona | University of Oslo
*   Andrew Millis, Professor of Physics, Columbia University | Associate Director for Physics, Simons Foundation

#### Dec 2015

8 Dec 2015

The Japan mirror (jp.arXiv.org) has been discontinued. We thank the [Yukawa Institute for Theoretical Physics](http://www.yukawa.kyoto-u.ac.jp/) for their support of arXiv.

#### Oct 2015

30 Oct 2015

**Holiday Schedule:** To enable our administrators to spend local holidays with their families, mailings and the public availability of new submissions will be deferred for 26 Nov, 25 Dec, 29 Dec, and 1 Jan; the arXiv servers will otherwise remain in operation. In addition, arXiv staff will provide limited service in response to queries during these periods.

*   Articles received at or after 16:00 EST Wed 25 Nov 2015 and before 16:00 EST Fri 27 Nov 2015 will be announced at 20:00 EST Sun 29 Nov 2015.
*   Articles received at or after 16:00 EST Thu 24 Dec 2015 and before 16:00 EST Mon 28 Dec 2015 will be announced at 20:00 EST Mon 28 Dec 2015.
*   Articles received at or after 16:00 EST Mon 28 Dec 2015 and before 16:00 EST Wed 30 Dec 2015 will be announced at 20:00 EST Wed 30 Dec 2015.
*   Articles received at or after 16:00 EST Thu 31 Dec 2015 and before 16:00 EST Mon 4 Jan 2016 will be announced at 20:00 EST Mon 4 Jan 2016.  
    _Note:_ that articles submitted at or after 16:00 EST Wed 30 Dec 2015 will receive `arXiv:1601.nnnnn` identifiers.

#### Sept 2015

10 Sept 2015

**arXiv online fund raising pilot:** arXiv will run a brief online fund raising campaign during September 2015 to explore ways to raise additional funds (see [donations to arXiv](/help/donate)). As described in arXiv's last [annual update](https://confluence.cornell.edu/x/bqZRF), the current business model is working well, sponsoring arXiv's baseline maintenance costs with support from 183 member libraries, the Simons Foundation, and Cornell University Library. This pilot will assess whether a give button placed prominently on arXiv's web pages will garner additional resources from the program's active and supportive user base. Stewardship of resources such as arXiv involves not only covering the operational costs but also continuing to enhance their value based on the needs of the user community and the evolving patterns and modes of scholarly communication. It is essential to raise additional funds in order to fund new initiatives that are beyond the routine operational work. More information about this pilot is available in the [arXiv FAQ](/help/support/faq). We thank you for your support.

#### Jan 2015

12 Jan 2015

**Reflections on the 1 million paper milestone:** See the [press release](https://www.library.cornell.edu/about/news/press-releases/arxiv-hits-1-million-submissions-0) and [watch a video of arXiv stakeholders reflecting on the 1 million paper milestone](https://www.youtube.com/watch?v=ntoxZzh0ha8).

**arXiv Update:** A project update, including a brief summary of activities in 2014, has been [posted online](https://confluence.cornell.edu/x/bqZRF).

1 Jan 2015

**New members join arXiv Scientific Advisory Board:** As of 2015, arXiv's [Scientific Advisory Board](/help/scientific_ad_board) has two new members:

*   Shude Mao, Professor of Astrophysics, Tsinghua University | National Astronomical Observatories of China | Jodrell Bank Centre for Astrophysics, Manchester
*   Jennifer Ross, Associate Professor of Physics, University of Massachusetts, Amherst

#### Dec 2014

19 Dec 2014

**arXiv identifiers will be extended by one digit:** Starting in January 2015, with article identifier arXiv:1501.00001, all identifiers will have 5-digits after the period. For more details see [Understanding the arXiv identifier](/help/arxiv_identifier).

10 Dec 2014

**Revised December Holiday Schedule:** (Revision to schedule announced 4 Nov: there will be a normal mailing and publication of submissions on 30 Dec.) To enable our administrators to spend local holidays with their families, mailings and the public availability of new submissions will be deferred for 25 Dec, 26 Dec, 31 Dec, and 1 Jan; the arXiv servers will otherwise remain in operation. In addition, arXiv staff will provide limited service in response to queries during these periods.

*   Articles received at or after 16:00 EST Wed 24 Dec 2014 and before 16:00 EST Mon 29 Dec 2014 will be announced at 20:00 EST Mon 29 Dec 2014.
*   Articles received at or after 16:00 EST Tue 30 Dec 2014 and before 16:00 EST Fri 2 Jan 2015 will be announced at 20:00 EST Sun 4 Jan 2015.  
    _Note:_ articles submitted at or after 16:00 EST Tue 30 Dec 2014 will receive `arXiv:1501.nnnnn` identifiers.

#### Nov 2014

19 Nov 2014

The United Kingdom mirror (uk.arXiv.org) has been discontinued. We thank the [Department of Electronics and Computer Science](http://www.ecs.soton.ac.uk/) at the [University of Southampton](http://www.southampton.ac.uk/) for their support of arXiv.

4 Nov 2014

**Holiday Schedule:** To enable our administrators to spend local holidays with their families, mailings and the public availability of new submissions will be deferred for 27 Nov, 25 Dec, 26 Dec, 30 Dec, 31 Dec, and 1 Jan; the arXiv servers will otherwise remain in operation. In addition, arXiv staff will provide limited service in response to queries during these periods.

*   Articles received at or after 16:00 EST Wed 26 Nov 2014 and before 16:00 EST Fri 28 Nov 2014 will be announced at 20:00 EST Sun 30 Nov 2014.
*   Articles received at or after 16:00 EST Wed 24 Dec 2014 and before 16:00 EST Mon 29 Dec 2014 will be announced at 20:00 EST Mon 29 Dec 2014.
*   Articles received at or after 16:00 EST Mon 29 Dec 2014 and before 16:00 EST Fri 2 Jan 2015 will be announced at 20:00 EST Sun 4 Jan 2015.  
    _Note:_ that articles submitted at or after 16:00 EST Mon 29 Dec 2014 will receive `arXiv:1501.nnnnn` identifiers.

#### May 2014

22 May 2014

**arXiv appoints Interim Scientific Director:** Dr. Chris Myers will serve as interim scientific director for arXiv. In this new position, Myers will contribute to arXiv's scientific direction and policies and serve on both the Scientific Advisory Board and the Member Advisory Board. See [press release](http://news.library.cornell.edu/news/140522/arXiv).

#### Apr 2014

15 Apr 2014

**Scheduled outage Wed 16 Apr:** The export.arxiv.org server is being replaced starting 9:00am EDT on Wed 16 Apr 2014. RSS, API and OAI-PMH services on export.arxiv.org will be unavailable for 2-3 hours. The main site will not be affected by this outage.

10 Apr 2014

**Two new Quantitative Finance subject areas have been added:**

*   **q-fin.EC** - Economics  
    Economics, including micro and macro economics, international economics, theory of the firm, labor economics, and other economic topics outside of finance
*   **q-fin.MF** - Mathematical Finance  
    Mathematical and analytical methods of finance, including stochastic, probabilistic and functional analysis, algebraic, geometric and other methods

For more information, see the complete list of [q-fin subcategory descriptions](/archive/q-fin). To subscribe to the daily e-mail notifications for q-fin.EC, q-fin.MF or other subcategories of q-fin, please see the [subscription instructions](/help/subscribe).

#### Jan 2014

7 Jan 2014

**arXiv 2013 Update:** A project update, including a brief summary of activities in 2013, has been [posted online](https://confluence.cornell.edu/x/bKZRF).

#### Oct 2013

15 Oct 2013

**Holiday Schedule:** To enable our administrators to spend local holidays with their families, mailings and the public availability of new submissions will be deferred for 28 Nov, 25 Dec, 26 Dec, 31 Dec, and 1 Jan; the arXiv servers will otherwise remain in operation.

*   Articles received at or after 16:00 EST Wed 27 Nov 2013 and before 16:00 EST Fri 29 Nov 2013 will be announced at 20:00 EST Sun 1 Dec 2013.
*   Articles received at or after 16:00 EST Tue 24 Dec 2013 and before 16:00 EST Fri 27 Dec 2013 will be announced at 20:00 EST Sun 29 Dec 2013.
*   Articles received at or after 16:00 EST Fri 27 Dec 2013 and before 16:00 EST Mon 30 Dec 2013 will be announced at 20:00 EST Mon 30 Dec 2013.
*   Articles received at or after 16:00 EST Mon 30 Dec 2013 and before 16:00 EST Thu 2 Jan 2014 will be announced at 20:00 EST Thu 2 Jan 2014.  
    _Note:_ that articles submitted at or after 16:00 EST Mon 30 Dec 2013 will receive `arXiv:1401.nnnn` identifiers.

15 Oct 2013

[MathJax](http://www.mathjax.org/) has been added to arXiv abstract pages to render TeX mathematics in titles and abstracts. For more information, please see the [help page](/help/mathjax).

#### Jun 2013

26 Jun 2013

**Scheduled outage Tue 2 July:** The arXiv web interface will be moved to new servers starting 8:00am EST on Tue 2 July 2013. Submission will be disabled for approximately 2 hours. Browse capabilities will be maintained for as much of the maintenance period as possible but there will be some time when the main server is unavailable. Mirror services will be unaffected. RSS, API and OAI-PMH services on export.arxiv.org will be unaffected.

#### Dec 2012

9 Dec 2012

**Scheduled outage Tue 11 Dec:** The arXiv database and export.arxiv.org servers are being replaced starting 9:30am EST on Tue 11 Dec 2012. Submission will be disabled for approximately 2 hours, and RSS, API and OAI-PMH services on export.arxiv.org will be unavailable. Browse capabilities will be maintained throughout. For a portion of the maintenance period, traffic will be redirected to our mirror sites.

6 Dec 2012

The [Nonlinear Sciences (nlin)](/archive/nlin) archive has been reorganized within the physics group. This means that nlin appears within physics on the arXiv [home page](/), in [search](/find), in [catchup](http://arxiv.org/catchup/grp_physics) and in the submission interfaces. Users who had the nlin group selected for submission now have the physics group selected. Existing [alert subscriptions](/help/subscribe#physics) are unaffected but it is now also possible to subscribe to nlin through physics.

#### Oct 2012

19 Oct 2012

**Holiday Schedule:** To enable our administrators to spend local holidays with their families, mailings and the public availability of new submissions will be deferred for 22 Nov, 24 Dec, 25 Dec, 27 Dec, 28 Dec and 1 Jan; the arXiv servers will otherwise remain in operation.

*   Articles received at or after 16:00 EST Wed 21 Nov 2012 and before 16:00 EST Fri 23 Nov 2012 will be announced at 20:00 EST Sun 25 Nov 2012.
*   Articles received at or after 16:00 EST Fri 21 Dec 2012 and before 16:00 EST Wed 26 Dec 2012 will be announced at 20:00 EST Wed 26 Dec 2012.
*   Articles received at or after 16:00 EST Wed 26 Dec 2012 and before 16:00 EST Mon 31 Dec 2012 will be announced at 20:00 EST Mon 31 Dec 2012.
*   Articles received at or after 16:00 EST Mon 31 Dec 2012 and before 16:00 EST Wed 2 Jan 2013 will be announced at 20:00 EST Wed 2 Jan 2013.  
    _Note:_ that articles submitted at or after 16:00 EST Wed 26 Dec 2012 will receive `arXiv:1301.nnnn` identifiers.

1 Oct 2012

The Israeli mirror (il.arXiv.org) has been discontinued. We thank the Israeli physics departments for their support of arXiv, and [Tel Aviv University](http://www.tau.ac.il/) for hosting the mirror server.

#### Aug 2012

29 Aug 2012

**Simons Foundation funds new arXiv sustainability model:** Thanks to an [operating grant from the Simons Foundation](http://news.library.cornell.edu/news/120828/arXiv), arXiv has taken a major step toward sustainability. Cornell University Library is adopting [a new membership and governance model](/help/support/faq) for arXiv that will allow it to continue to grow and succeed moving forward.

10 Aug 2012

The Taiwan mirror (tw.arXiv.org) has been discontinued. We thank the [National Center for High-Performance Computing](http://www.nchc.org.tw/en/) (NCHC), Taiwan for their support of arXiv.

#### Apr 2012

27 Apr 2012

The Brazilian mirror (br.arXiv.org) has been discontinued. We thank the [Instituto de Física at Universidade de São Paulo](http://web.if.usp.br/ifusp/) and the [Brazilian Physical Society](http://www.sbfisica.org.br/) for their support of arXiv.

24 Apr 2012

**arXiv Membership Model:** CUL has finalized a new membership model for the support of arXiv, including a set of operating principles. This five-year pledge model targets the top 200 libraries and research laboratories worldwide that represent arXiv's heaviest institutional users. Information about the membership model can be found at [arXiv Sustainability Initiative](https://confluence.cornell.edu/x/m4NRF).

18 Apr 2012

The Russian mirror (ru.arXiv.org) has been discontinued. We thank the [Alikhanov Institute for Theoretical and Experimental Physics (ITEP)](http://www.itep.ru/) for their support of arXiv.

#### Mar 2012

29 Mar 2012

The [Cultural Observatory](http://www.culturomics.org/cultural-observatory-at-harvard) has released a new tool for applying concept analysis to arXiv. Try Bookworm-arXiv at [http://arxiv.culturomics.org/](http://arxiv.culturomics.org).

#### Feb 2012

23 Feb 2012

**American Physical Society and Australian mirrors discontinued:** We are reducing the size of the arXiv mirror network to better focus available administrative effort. It is our goal to keep a handful of mirrors with wide geographic spread to help with network outage and disaster tolerance. However, current internet topology means that mirrors are no longer an effective way to improve arXiv access.

*   The [American Physical Society](http://www.aps.org/) mirror (aps.arXiv.org) has been discontinued. We are grateful for the longstanding and continuing support of the APS, and for help at critical junctures including using the mirror as primary backup during the fires that threatened Los Alamos in 2000.
    
*   The Australian mirror (au.arXiv.org) has been discontinued. We thank the [CSSM](http://www.physics.adelaide.edu.au/cssm/) at the University of Adelaide and the [ARC Centre of Excellence for Particle Physics at the Terascale](http://coepp.org.au/) (CoEPP) for their support of arXiv.
    

6 Feb 2012

**January arXiv Sustainability Initiative Update:** A report on recent developments in support and governance planning for arXiv is provided in the [January 2012 update](http://arxiv.org/help/support/arxiv_busplan_Jan2012).

#### Nov 2011

4 Nov 2011

**arXiv Sustainability Initiative Update:** A report on recent developments in support and governance planning for arXiv is provided in the [October 2011 update](http://arxiv.org/help/support/arxiv_busplan_Oct2011).

#### Oct 2011

28 Oct 2011

**arXiv receives support for governance planning:** Thanks to a generous award from the [Simons Foundation](https://simonsfoundation.org/), Cornell University Library will take a major step toward building a permanent governance model for arXiv, the free scientific repository that has revolutionized the way scientists share information. See the full [press release]( http://news.library.cornell.edu/news/111025/arXiv_governance ) for more information.

18 Oct 2011

**Holiday Schedule:** To enable our administrators to spend local holidays with their families, mailings and the public availability of new submissions will be deferred for 24 Nov, 26 Dec, 27 Dec, 28 Dec, Dec 30 and 2 Jan; the arXiv servers will otherwise remain in operation.

*   Articles received at or after 16:00 EST Wed 23 Nov 2011 and before 16:00 EST Fri 25 Nov 2011 will be announced at 20:00 EST Sun 27 Nov 2011.
*   Articles received at or after 16:00 EST Fri 23 Dec 2011 and before 16:00 EST Thu 29 Dec 2011 will be announced at 20:00 EST Thu 29 Dec 2011.
*   Articles received at or after 16:00 EST Thu 29 Dec 2011 and before 16:00 EST Tue 3 Jan 2012 will be announced at 20:00 EST Tue 3 Jan 2012.  
    _Note:_ that articles submitted at or after 16:00 EST Thu 29 Dec 2011 will receive `arXiv:1201.nnnn` identifiers.

#### Jul 2011

29 Jul 2011

**arXiv Sustainability Initiative Update:** An update on the effort to design a new collaborative support model for arXiv, including a short FAQ, is provided in the [July 2011 update](/help/support/arxiv_busplan_July2011).

#### Apr 2011

27 Apr 2011

**arXiv Sustainability Initiative Update:** It has been 15 months since we announced the collaborative arXiv business model. Current status of the initiative, including information about the upcoming open information sessions, is given in the [April 2011 update](/help/support/arxiv_busplan_Apr2011).

25 Apr 2011

**Data sets accepted as part of Data Conservancy pilot project:** In addition to the existing facilities for uploading [ancillary files](/help/ancillary_files) alongside articles submitted to arXiv, it is now possible to upload datasets of up to 1GB (100MB per file) for storage in the [Data Conservancy data repository](/help/data_conservancy). Data sets uploaded in this way will be linked from the arXiv article. This is a pilot project in collaboration with the US National Science Foundation (NSF) Data Conservancy project.

**ScienceWISE provides article annotation and social bookmarking:** Authors may now create annotated versions of their arXiv articles using the [ScienceWISE service](/help/sciencewise). Annotated PDF versions are linked from the arXiv abstract page. See, for example, [arXiv:1103.5989v1](http://arxiv.org/abs/1103.5989v1). ScienceWISE also provides [social bookmarking](/help/social_bookmarking) facilities and a link and icon have been added to the set of bookmarking providers displayed on all abstract pages.

#### Jan 2011

3 Jan 2011

**Scheduled outages Tue 4 Jan and Sat/Sun 8/9 Jan:** There will be a brief outage from 8am EST on Tue 4 Jan for server patching, accesses will be redirected to mirrors for most of this time. There will be a longer outage over the weekend of 8/9 Jan for major work on the power supplies for Cornell's hosting facility. The arXiv submission system and main server will be disabled at 7:30pm EST on Sat 8 Jan, existing articles will remain available from mirrors. Work is scheduled to be completed by 8am EST on Sun 9 Jan and the submission system will be available as soon as the work is complete.

**Bulk data available on Amazon S3:** The [bulk data available for download from Amazon S3](/help/bulk_data_s3) has been extended to include both PDF and source files of the latest versions of all arXiv articles.

#### Nov 2010

12 Nov 2010

**Holiday Schedule:** To enable our administrators to spend local holidays with their families, mailings and the public availability of new submissions will be deferred for 25 Nov, 27 Dec, 28 Dec, 30 Dec and 31 Dec 2010; the arXiv servers will otherwise remain in operation.

*   Articles received from 16:00 EST Wed 24 Nov 2010 through 16:00 EST Fri 26 Nov 2010 will be announced at 20:00 EST Sun 28 Nov 2010.
*   Articles received from 16:00 EST Fri 24 Dec 2010 through 16:00 EST Wed 29 Dec 2010 will be announced at 20:00 EST Wed 29 Dec 2010.
*   Articles received from 16:00 EST Wed 29 Dec 2010 through 16:00 EST Mon 3 Jan 2011 will be announced at 20:00 EST Mon 3 Jan 2011. _Note_ that articles submitted after 16:00 EST Wed 29 Dec 2010 will receive `arXiv:1101.nnnn` identifiers.

#### Mar 2010

5 Mar 2010

**New Submission System:** We are pleased to announce that arXiv has a new submission system. We hope that this will improve the submission process for users and streamline administrative operations to help us keep pace with the [ever increasing submission rate](http://arxiv.org/stats/monthly_submissions).

Note that with the new submission system permanent identifiers are assigned only at the time articles are publicly announced. Submitters may edit, delay or remove submissions up until that point but this may affect the announcement order. Those interested in the [announcement order](/help/submit#availability) should be aware that policies have changes such that:

*   An update before announcement will reset any article's position in the queue. Announcement order is based on the last "Submit" action.
*   An update after 16:00 EST/EDT will delay an article to the next day.

4 Mar 2010

**Scheduled outage 5 Mar:** The arXiv submission system will be disabled at 16:00 EST Fri, 5 Mar 2010 to allow software and hardware changes. The submission system and other facilities requiring login are expected to remain down for a few hours. Browsing will be supported at the main site for most of this time, and on our mirrors throughout.

**Delayed announcements 8 Mar:** On Mon, 8 Mar 2010 we will delay the publication of new listings and the mailing of email alerts for new submissions from 20:00 EST to approximately 22:00 EST to allow software upgrades to be tested.

#### Jan 2010

21 Jan 2010

**Collaborative Support Plan Announced:** Cornell University Library is beginning an effort to expand funding sources for arXiv to ensure its stability and continued development. We are working to establish a collaborative business model that will engage the institutions that benefit most from arXiv — academic institutions, research centers and government labs — by asking them for voluntary contributions. Our plans are outlined in the [press release](http://news.library.cornell.edu/news/arxiv) and in the [arXiv support](/help/support).

#### Nov 2009

17 Nov 2009

**Holiday Schedule:** To enable our administrators to spend local holidays with their families, mailings and the public availability of new submissions will be deferred for 26 Nov, 25 Dec, 28 Dec, 29 Dec, 31 Dec 2009 and 1 Jan 2010; the arXiv servers will otherwise remain in operation.

*   Articles received from 16:00 EST Wed 25 Nov 2009 through 16:00 EST Fri 27 Nov 2009 will be announced at 20:00 EST Sun 29 Nov 2009.
*   Articles received from 16:00 EST Thu 24 Dec 2009 through 16:00 EST Wed 30 Dec 2009 will be announced at 20:00 EST Wed 30 Dec 2009.
*   Articles received from 16:00 EST Wed 30 Dec 2009 through 16:00 EST Mon 4 Jan 2010 will be announced at 20:00 EST Mon 4 Jan 2010. _Note_ that articles submitted after 16:00 EST Wed 30 Dec 2009 will receive `arXiv:1001.nnnn` identifiers.

#### Jul 2009

9 Jul 2009

**No new papers or announcements for 9 Jul 2009.** arXiv administrators spent much of 8 Jul recovering from a problem with the main server (a corrupted database caused by human error on the evening of 7 Jul). During this time users were redirected to mirrors and submissions were not possible. We have thus deferred announcements of new submissions according to the following schedule:

*   Articles received from 16:00 EDT Tue 7 Jul 2009 through 16:00 EDT Thu 9 Jul 2009 will be announced at 20:00 EDT Thu 9 Jul 2009.

#### Apr 2009

8 Apr 2009

**Public author identifiers have been introduced.** If you are an author of articles on arXiv, you may opt-in to create a [public author identifier](/help/author_identifiers) which supports [interaction with Facebook](/help/facebook), a [`myarticles` widget](/help/myarticles) to allow dynamic inclusion of a list of your articles in web pages, and provides HTML and Atom feeds of your arXiv papers.

#### Mar 2009

31 Mar 2009

**A new Quantum Gases (cond-mat.quant-gas) subject area has been added:**

*   **cond-mat.quant-gas** - Quantum Gases  
    Ultracold atomic and molecular gases, Bose-Einstein condensation, Feshbach resonances, spinor condensates, optical lattices, quantum simulation with cold atoms and molecules, macroscopic interference phenomena

For more information, see the complete list of [cond-mat subcategory descriptions](/archive/cond-mat). To subscribe to the daily e-mail notifications for cond-mat.quant-gas or a set of subcategories of cond-mat, you should first [cancel](/help/subscribe#cancel) your existing subscription, and then [subscribe](/help/subscribe) only to the subcategories of interest via physics.

#### Jan 2009

20 Jan 2009

**By popular request, the Astrophysics (astro-ph) archive has been split into six subcategories:**

*   **astro-ph.CO** - Cosmology and Extragalactic Astrophysics
*   **astro-ph.EP** - Earth and Planetary Astrophysics
*   **astro-ph.GA** - Galaxy Astrophysics
*   **astro-ph.HE** - High Energy Astrophysical Phenomena
*   **astro-ph.IM** - Instrumentation and Methods for Astrophysics
*   **astro-ph.SR** - Solar and Stellar Astrophysics

For more information, see the [subcategory descriptions](/archive/astro-ph) (including links to subdivided new and recent listings). This split should make announcements of new papers more manageable for those interested only in subsets of astro-ph. New astro-ph submissions must be assigned one or more subcategories. (Existing astro-ph articles will be machine-classified according to the new scheme when enough training data has been collected.)

To subscribe to the daily e-mail notifications for only a set of subcategories, you should first [cancel](/help/subscribe#cancel) your existing subscription (either to astro-ph or physics), and then [subscribe](/help/subscribe) only to the subcategories of interest via physics.

#### Dec 2008

4 Dec 2008

**A new "Quantitative Finance" (q-fin) archive has been launched.** For more information, see the [announcement](/new/q-fin_announcement). It is partitioned into [7 subject categories](/archive/q-fin) and [e-mail subscriptions](/help/subscribe) can be made to any combination of subject categories. It has been "[preseeded](http://arxiv.org/Stats/q-fin_monthly.png)" with roughly 1700 relevant cross-listings and reclassification of articles from existing subject categories.

#### Nov 2008

19 Nov 2008

**Holiday Schedule:** To enable our administrators to spend local holidays with their families, mailings and the public availability of new submissions will be deferred for 27 Nov, 25 Dec, 26 Dec, 29 Dec, 31 Dec 2008 and 1 Jan 2009; the arXiv servers will otherwise remain in operation.

*   Articles received from 16:00 EST Wed 26 Nov 2008 through 16:00 EST Fri 28 Nov 2008 will be announced at 20:00 EST Sun 30 Nov 2008.
*   Articles received from 16:00 EST Wed 24 Dec 2008 through 16:00 EST Tue 30 Dec 2008 will be announced at 20:00 EST Tue 30 Dec 2008.
*   Articles received from 16:00 EST Tue 30 Dec 2008 through 16:00 EST Fri 2 Jan 2008 will be announced at 20:00 EST Sun 4 Jan 2008. _Note_ that articles submitted after 16:00 EST Tue 30 Dec 2008 will receive 0901 identifiers.

#### Oct 2008

3 Oct 2008

**arXiv passes half-million article milestone:** The 262 new submissions received between Wednesday 1 Oct and Thursday 2 Oct, announced Friday 3 Oct 2008, brought the total number of articles on arXiv past 500,000 -- all openly accessible. There are also more than 200,000 [old versions](/help/versions) of articles which record all public revisions since 1997. If the linear increase in [submission rate](http://arxiv.org/stats/monthly_submissions) continues, arXiv will pass the one million article mark in 2015. See [press release](http://communications.library.cornell.edu/com/news/PressReleases/arXiv-milestone.cfm) for more details.

#### Jun 2008

26 Jun 2008

**Increased Size Limits:** The automatic size limits have been significantly increased for all areas. They will now affect only a tiny fraction of submitters (<0.1%). We will continue to make exceptions for theses, dissertations and other necessarily large submissions, and offer advice on how to make large submissions more efficient (and thus more widely accessible).

**Holiday Schedule:** To enable our administrators to spend local holidays with their families, mailings and the public availability of new submissions will be deferred for 4 Jul; the arXiv servers will otherwise remain in operation.

*   Articles received from 16:00 EDT Thu 3 Jul 2008 through 16:00 EDT Mon 7 Jul 2008 will be announced at 20:00 EDT Mon 7 Jul 2008.

#### Mar 2008

12 Mar 2008

**US NIH public access mandate:** Recipients of funding from the US National Institutes of Health (NIH) funding should be aware of a new requirement that publications after 7 Apr 2008 must be deposited in [PubMed Central](http://www.pubmedcentral.nih.gov/) (PMC). See [Cornell University Library advice on the new NIH public access mandate](http://www.library.cornell.edu/scholarlycomm/nihmandate) for more information and links to NIH documentation. This reporting requirement does not affect your right to submit arXiv. However, submission to arXiv does not satisfy the NIH reporting requirement.

#### Feb 2008

16 Feb 2008

**Hardware and Software Upgrades:** Over the weekend of 1/2 Feb 2008 we moved arXiv to new hardware. This should allow us to keep up with the ever increasing traffic and make several improvements. One is that we now have a cache large enough to store processed PDF versions for all papers -- there should be far fewer "...processing..." responses. We have also put online several software improvements including:

*   arXiv now accepts [submissions in DOCX/OOXML format](/help/submit_docx) (from Word 2007 and other OOXML compliant applications).
*   We have implemented version control for papers submitted prior to November 1997 in the same way as for papers submitted later. In many cases the earlier versions were not recorded and are marked as such in the comments (e.g. [arXiv:hep-th/9108006v1](/abs/hep-th/9108006v1)). However, in some cases the earlier versions are now available in the usual way (e.g. [arXiv:hep-th/9108019v1](/abs/hep-th/9108019v1)).

#### Nov 2007

14 Nov 2007

**Holiday Schedule:** To enable our administrators to spend local holidays with their families, mailings and the public availability of new submissions will be deferred for 22 Nov, 24 Dec, 25 Dec, 31 Dec and 1 Jan; the arXiv servers will otherwise remain in operation.

*   Articles received from 16:00 EST Wed 21 Nov 2007 through 16:00 EST Fri 23 Nov 2007 will be announced at 20:00 EST Sun 25 Nov 2007.
*   Articles received from 16:00 EST Fri 21 Dec 2007 through 16:00 EST Wed 26 Dec 2007 will be announced at 20:00 EST Wed 26 Dec 2007.
*   Articles received from 16:00 EST Fri 28 Dec 2007 through 16:00 EST Wed 2 Jan 2008 will be announced at 20:00 EST Wed 2 Jan 2008. _Note_ that articles submitted after 16:00 EST Fri 28 Dec 2007 will receive 0801 identifiers.

#### Aug 2007

27 Aug 2007

Note on [recent administrative withdrawals](http://arxiv.org/new/withdrawals.aug.07) due to plagiarism.

#### Jul 2007

18 Jul 2007

There have been a number of upgrades to the arXiv interface and processing system since April 2007. These include:

*   _arXiv now supports [PDFLaTeX](/help/submit_tex#pdflatex)._ TeX submissions may now include PDF, JPG, or PNG figures using the standard `\includegraphics` command from the `graphics` or `graphicx` packages.
*   The article _[identifier system](/help/arxiv_identifier) has been updated_. The new scheme (which does not include subject information in the identifier) not only allows for a greater number of submissions each month, but it makes reclassification easier (old identifiers did not permit changes in primary classication after announcement). We also hope that the removal of optional subject-class information from the identifier will lead to more consistent citation and linking.
*   To find a specific paper for which you know the identifier, you may now simply type or paste the identifier (e.g. `hep-th/0501001`, `0704.0001` or `arXiv:0704.0002`) into the _search box at the top of every arXiv page_. This facility replaces the "abs" links for each archive that used to be on the main page.
*   The _abstract pages have been redesigned_ to more cleanly present the most important information (title, authors, abstract, etc.) and to allow more links to related services to be added in column on the right. See, for example, [arXiv:0704.1252](/abs/0704.1252)
*   The _Statistics archive_ was [introduced](/new/stat_announce) on 1 April 2007.
*   The category `math.IT` was created as an alias for _Information Theory_ (`cs.IT`) so that these papers will show in both math and cs searches.

#### Mar 2007

8 Mar 2007

**Change to arXiv identifiers now scheduled for 1 April 2007:** The format of arXiv identifiers will change on 1 April 2007 (postponed from 1 January 2007). See [Identifier scheme for new submissions beginning 1 April 2007](http://arxiv.org/help/arxiv_identifier#new) for details.

#### Dec 2006

21 Dec 2006

**Postponed change to arXiv identifiers:** The format of arXiv identifiers will change early in 2007 (exact transition date to be decided). We have postponed the change from 1 January 2007 to allow more time for us and our collaborators to implement the required software modifications. See [Identifier scheme for new submissions beginning early 2007](http://arxiv.org/help/arxiv_identifier#new) for details.

6 Dec 2006

**Revised Holiday Schedule:** To enable our administrators to spend local holidays with their families, mailings and the public availability of new submissions will be deferred for 25 Dec, 26 Dec and 1 Jan; the arXiv servers will otherwise remain in operation.

*   Articles received from 16:00 EST Fri 22 Dec 2006 through 16:00 EST Wed 27 Dec 2006 will be announced at 20:00 EST Wed 27 Dec 2006.
*   Articles received from 16:00 EST Fri 29 Dec 2006 through 16:00 EST Tue 2 Jan 2007 will be announced at 20:00 EST Tue 2 Jan 2007.

  

1 Dec 2006

**Change to arXiv identifiers:** The current form of arXiv identifiers (e.g. **`[arXiv:math.DG/0307245](/abs/math/0307245)`**) permits only 999 papers per month in any archive -- in October of this year we got to paper [989](/abs/math/0610989) in math, just 11 short of difficulty. We thus have an urgent need to extend the maximum number of submissions that can be handled in a month. We will certainly exceed 999 papers in some months for some archives next year.

To address this issue (and several others), we are going to change the format of identifiers for new papers starting in early 2007 (original 1 December announcement said 1 January 2007, since [postponed](#ids_2006)) to use the form **`arXiv:0706.0001`**.

#### Nov 2006

20 Nov 2006

**Holiday Schedule:** To enable our administrators to spend local holidays with their families, mailings and the public availability of new submissions will be deferred for 23 Nov, 25 Dec and 1 Jan; the arXiv servers will otherwise remain in operation.

*   Articles received from 16:00 EST Wed 22 Nov 2006 through 16:00 EST Fri 24 Nov 2006 will be announced at 20:00 EST Sun 26 Nov 2006.
*   Articles received from 16:00 EST Fri 22 Dec 2006 through 16:00 EST Tue 26 Dec 2006 will be announced at 20:00 EST Tue 26 Dec 2006.
*   Articles received from 16:00 EST Fri 29 Dec 2006 through 16:00 EST Tue 2 Jan 2007 will be announced at 20:00 EST Tue 2 Jan 2007.

#### August 2006

22 Aug 2006

Links to Grisha Perelman's papers, published only as arXiv.org e-prints are available below. Perelman was named a Fields Medalist at the opening ceremony of the International Mathematical Union.

arXiv.org moderator Terence Tao was also named a Fields Medalist. See [http://www.mathunion.org/medals/2006/](http://www.mathunion.org/medals/2006/) for information about the four medalists and their publications including arXiv.org e-prints.

**Grisha Perelman's papers on arXiv.org:**

**1\. math.DG/0307245** \[[abs](/abs/math.DG/0307245), [ps](/ps/math.DG/0307245), [pdf](/pdf/math.DG/0307245)\]:

Title: **Finite extinction time for the solutions to the Ricci flow on certain three-manifolds**  
Authors: **[Grisha Perelman](/find/math/1/au:+Perelman_G/0/1/0/all/0/1)**  

**2\. math.DG/0303109** \[[abs](/abs/math.DG/0303109), [ps](/ps/math.DG/0303109), [pdf](/pdf/math.DG/0303109)\]:

Title: **Ricci flow with surgery on three-manifolds**  
Authors: **[Grisha Perelman](/find/math/1/au:+Perelman_G/0/1/0/all/0/1)**  

**3\. math.DG/0211159** \[[abs](/abs/math.DG/0211159), [ps](/ps/math.DG/0211159), [pdf](/pdf/math.DG/0211159)\]:

Title: **The entropy formula for the Ricci flow and its geometric applications**  
Authors: **[Grisha Perelman](/find/math/1/au:+Perelman_G/0/1/0/all/0/1)**  

#### April 2006

4 Apr 2006

We added [access keys](/help/accesskeys) to our abstract and listing pages. Access keys allow users to activate certain links using keyboard shortcuts.

#### Nov 2005

15 Nov 2005

**Holiday Schedule:** To enable our administrators to spend local holidays with their families, mailings and the public availability of new submissions will be deferred for 24 Nov and 27 and 29 Dec; the arXiv servers will otherwise remain in operation.

*   Articles received from 16:00 EST Wed 23 Nov 2005 through 16:00 EST Fri 25 Nov 2005 will be announced at 20:00 EST Sun 27 Nov 2005.
*   Articles received from 16:00 EST Mon 26 Dec 2005 through 16:00 EST Wed 28 Dec 2005 will be announced at 20:00 EST Wed 28 Dec 2005
*   Articles received from 16:00 EST Wed 28 Dec 2005 through 16:00 EST Fri 30 Dec 2005 will be announced at 20:00 EST Sun 1 Jan 2006

**Note:** Submissions received after 16:00 EST Fri 30 Dec 2005 (21:00 GMT) will receive 0601... identifiers

#### Oct 2005

11 Oct 2005

**Software reversion**: For the past three weeks, arXiv has not functioned reliably. We sincerely apologize for not providing the outstanding level of service that users expect.

On 18 Sep 05, we installed new software to allow more flexible and robust classification of arXiv submissions. Unfortunately, the software did not perform as expected and resulted in difficulties and confusion for some of our users.

To restore stability, we reverted to the software used prior to 18 Sep 05. We sincerely regret all inconveniences and are taking steps to ensure that future arXiv developments will be reliable. Thank you for your patience with us.

#### Sep 2005

24 Sep 2005

**Scheduled outage:** At 4:00 p.m. EDT on Saturday, 24 Sep 2005, we expect an outage for improvements to Cornell University infrastructure. The outage is scheduled to last 18 hours.

All services related to the main site (submissions, user account info, viewing the e-mail addresses of paper authors, etc.) will be unavailable during this time. People planning to submit papers on that day should either submit them before noon or plan to submit them on the following Monday. Readers should use one of our [mirror sites](/servers) to view papers during the outage.

16 Sep 2005

**Software upgrade:** There will be a disruption in normal service at the main site beginning at 4 PM EST on Friday, 16 September in order to carry out several software upgrades. The disruption is expected to last less than 24 hours. During that time, the main site will be available for browsing, but the submission and replacement services will be unavailable. People planning to submit/replace papers should do so either early Friday or on the following Sunday.

In addition, papers received before 4 PM EST on 16 Sep will be announced at 8 PM EST _that same evening_, as opposed to the normal 8 PM EST Sunday time for papers received on a Friday. This will be done to minimize the possibility of errors with the software cutover.

7 Sep 2005

**Physics reorganization:** The physics section of arXiv will be undergoing an extensive reorganization. Over the last few months, the physics advisory committee members and section moderators have been extensively discussing [a new organization and classification scheme](http://arxiv.org/new/physics), which would hopefully be implemented within the next several months.

#### Jul 2005

25 Jul 2005

**BitTorrent version of [hep-th](/list/hep-th/recent):** From cartan.harvard.edu [torrent.rutgers.edu](http://torrent.rutgers.edu/) you may download PDFs and text abstracts of the entire hep-th archive. The download is facilitated by [BitTorrent technology](http://www.bittorrent.com/introduction) to distribute bandwidth. Monthly updates are also available.

Software for downloading torrents is available for Windows, Mac OS, and Linux at [BitTorrent.com](http://www.bittorrent.com/).  
Special thanks to [Joanna Karczmarek](http://www.physics.rutgers.edu/~karczmar/) for creating the BitTorrents, and Harvard for hosting them. _Note_: The BitTorrents are not supported by arXiv.org: send comments to Joanna Karczmarek.

#### Nov 2004

11 Nov 2004

**CoRR interface:** A new [interface](/corr) for the Computing Resource Repository (corresponding to the [cs archive](/archive/cs/intro)) was installed. It is still in the "beta" phase of production, but cs users are welcome to use it for uploading submissions, viewing listings, etc. Please report any bugs to www-admin@arxiv.org.

4 Nov 2004 _\[Modified 24 Nov 2004\]_

**Holiday Schedule:** To enable our administrators to spend local holidays with their families, mailings and the public availability of new submissions will be deferred for 25 Nov and 24, 28, and 30 Dec; the arXiv servers will otherwise remain in operation.

*   Articles received from 16:00 EST Wed 24 Nov 2004 through 16:00 EST Fri 26 Nov 2004 will be announced at 20:00 EST Sun 28 Nov 2004.
*   Articles received from 16:00 EST Thu 23 Dec 2004 through 16:00 EST Mon 27 Dec 2004 will be announced at 20:00 EST Mon 27 Dec 2004
*   Articles received from 16:00 EST Mon 27 Dec 2004 through 16:00 EST Wed 29 Dec 2004 will be announced at 20:00 EST Wed 29 Dec 2004
*   Articles received from 16:00 EST Wed 29 Dec 2004 through 16:00 EST Fri 31 Dec 2004 will be announced at 20:00 EST Sun 2 Jan 2005

#### Sep 2004

29 Sep 2004

**Search engine for user help pages:** A new [search engine](/help/search) for the user help pages was installed, with a search box provided at the top of each user [help](/help) page.

#### Jul 2004

23 Jul 2004

**Scheduled outage:**At noon EST on Sunday, 1 Aug 2004, we expect a scheduled outage for a planned hardware upgrade. Because we need to synchronize the database and other files between the two machines, we will need to disable incoming submissions for several hours. People planning to submit papers on that day should either submit them before noon or plan to submit them on the following Monday.

If all goes as planned, it should be possible to browse papers on arXiv during most of the upgrade. If you do have problems, we recommend that you use one of our [mirror sites.](http://arxiv.org/servers)

Features that require user login, such as viewing the e-mail addresses of paper authors, will be disabled during the upgrade.

We'd like to thank [Sun Microsystems](http://www.sun.com/) for the gracious donation of a new server. The increased performance of the new machine will help us handle our [continuing growth.](http://arxiv.org/stats/monthly_submissions)

#### Jan 2004

17 Jan 2004

**Endorsement System:** ArXiv initiates an endorsement system for new submitters. Initially, only a small fraction of submitters will be asked to provide endorsement. As the system is phased in, most new submitters will require endorsement. Existing submitters may not require endorsement for topics in which they have been active.

arXiv is an openly accessible, moderated repository for scholarly papers in specific scientific disciplines. Material submitted to arXiv is expected to be of interest, relevance, and value to those disciplines.

arXiv was developed to be, and remains, a means for specific communities of scientists to exchange information. Moderators and the arXiv administrative team have worked behind the scenes to ensure that content is appropriate to the user communities. The growth in number of submissions to arXiv necessitates an automated endorsement system. Current members of arXiv scientific communities will have the opportunity to endorse new submitters. This process will ensure that arXiv content is relevant to current research while controlling costs so we can continue to offer free and open Web access to all. For more information, see the [endorsement help page.](http://arxiv.org/help/endorsement)

#### Dec 2003

4 Dec 2003

**Holiday Schedule:** Mailings and the public availability of new submissions will be deferred for 25,26 Dec and 1,2 Jan; the arXiv servers will otherwise remain in operation. These are typically the lowest activity days throughout the year.  
Articles received from 16:00 EST Wed 24 Dec 2003 through 16:00 EST Mon 29 Dec 2003 will be announced at 20:00 EST Mon 29 Dec 2003, and similarly articles received from 16:00 EST Wed 31 Dec 2003 through 16:00 EST Mon 5 Jan 2004 will be announced at 20:00 EST Mon 5 Jan 2004. Replacements received during these periods will not generate a new version number.

#### Sep 2003

15 Sep 2003

A new "Quantitative Biology" archive, q-bio@arXiv.org, has been opened up for submissions. For more info, see this [announcement](/new/q-bio_announce). It is partitioned into [10 subject classes](/new/q-bio) and e-mail subscriptions can be made to any combination of subject classes. It has been "preseeded" with roughly 2000 relevant cross-listings from existing subject areas.

#### Jul 2003

6 Jul 2003

A new and more sophisticated author registration system has been put on-line. It provides greater administrative flexibility and better user support, including user ability to maintain past submissions. See [register help](/help/registerhelp) for updated information.

In order to improve the quality of the user-provided data, the legacy support for e-mail submissions has been phased out, in favor of exclusive support for web submissions. (The [percentage](http://arXiv.org/Stats/hcamonthly#upper) of non-web submissions had decreased continuously in the past seven years to under 16%.)

#### Dec 2001

13 Dec 2001

arXiv.org main site hardware operations transferred to the _Cornell University Library_ site _cul.arXiv.org = xxx.arXiv.cornell.edu_

#### Sep 2001

21 Sep 2001

_Minor policy change:_ Starting Mon 24 Sep 2001, the deadline for submissions to appear in the daily mailings will be moved **\*three hours earlier\***: to 16:00 US Eastern time (i.e., to 20:00 GMT, and 21:00 GMT during the winter) Monday through Friday, the first change in this time since [8 Jul '99](#8jul99). The start of the mailings (and web interface update) will be moved to four hours earlier: to shortly after 20:00 Eastern time on Sunday through Thursday (i.e., to 00:00 GMT Mon-Fri, and 01:00 GMT during winter; the first change in this time since [7 Oct '96](#7oct96)). Those submissions received between 16:00 and 20:00 EDT/EST will appear in the following day's mailing. Submissions received before the Friday 16:00 EDT/EST deadline will be announced on the following Sunday at 20:00 EDT/EST, and submissions received during the remainder of the weekend will be announced along with the Monday submissions (as since [15 May '97](#15may97)) on Monday night at 20:00 EDT/EST time.

As ever, whether or not a submission makes the deadline on any given weekday is unlikely to alter markedly the future evolution of the cosmos.

4 Sep 2001

Administrative oversight for arXiv operations transferred to the _Cornell University Library (CUL)_, and configuration of the _cul.arXiv.org = xxx.arXiv.cornell.edu_ mirror site proceeds.

#### Dec 2000

6 Dec 2000

The automated software now recognizes and processes Mathematica Notebook files. For more information, see [notebook submission help](/help/submit_nb).

#### Aug 2000

1 Aug 2000

South Africa users: note new South Africa mirror at [http://za.arXiv.org/](http://za.arXiv.org/) , hosted by Department of Physics, University of the Witwatersrand, Johannesburg

#### Jan 2000

6 Jan 2000

The nlin-sys archives have been reorganized starting 1 January, 2000. The archives adap-org, chao-dyn, comp-gas, patt-sol, and solv-int have been subsumed as subject classes in the new " [nlin](/archive/nlin)" archive (see [nlin info](http://arXiv.org/new/nlin) for more information). The intent is to bring these archives into conformity with the format of the newer archives, and to facilitate further expansion or reorganization. (Note that this also means these archives will now be updated -- and abstract mailings issued -- every weekday, rather than just once per week.) Beginning 1 Jan 2000, chao-dyn submissions for example should be sent To: nlin@arXiv.org with the added line (i.e. following Title:, Author:, etc.):

**Subj-class:** Chaotic Dynamics

and analogously for the other above subsumed archives. Submissions to chao-dyn@arXiv.org will be automatically rerouted as above, and assigned numbers beginning with nlin.CD/0001001. As a replacement for the cross-listing mechanism (between nlin archives), use multiple Subj-class: entries separated by ;'s (the first is the primary). It is also possible to subscribe to receive daily abstract notifications for any subset of the nlin-sys subject classes (see [nlin subscribe](http://arXiv.org/new/nlinsub) -- current e-mail subscribers have been automatically transferred). Comments or suggestions for possible reorganization of the subject classes can be sent to www-admin@arxiv.org.

1 Jan 2000

Survived [Y2K](/help/faq/y2k) hysteria

#### Dec 1999

31 Dec 1999

As previously [announced](#announce), the xxx Announcements Forum has shut down at the end of 1999.  
For more information, see [announcements](http://xxx.lanl.gov/Announce/).

1 Dec 1999

US users: note new US mirror at [http://aps.arXiv.org/](http://aps.arXiv.org/), hosted by Brookhaven National Laboratory for the American Physical Society.

#### Sep 1999

22 Sep 1999

New [search](http://arXiv.org/find/physics) interface at the main site. Incorporates better fielded searching, better boolean support, and much improved author name searching. The new search system will eventually propagate to the [mirror](/servers) network.

#### Jul 1999

8 Jul 1999

Minor policy change: the deadline for submissions to appear in the daily mailings has been moved one hour earlier, to 17:00 US Mountain time (i.e., currently 23:00 GMT, and 00:00 GMT during the winter) Monday through Friday (the first change in this time since [4 Aug '96](#4aug96)). The mailings will continue to commence (and web interface updated) shortly after 22:00 on Sunday through Thursday (i.e., currently 04:00 GMT Mon-Fri, and 05:00 GMT during winter, as since [7 Oct '96](#7oct96)). Those few submissions received between 17:00 and 22:00 mountain time will appear in the next day's mailing. Submissions received before the Friday 17:00 deadline will be announced on the following Sunday at 22:00, and submissions received during the remainder of the weekend will be announced along with the Monday submissions on Monday night at 22:00 mountain time (as since [15 May '97](#15may97)).

#### Jun 1999

29 Jun 1999

The xxx Announcements Forum is no longer accepting new registrations, and will shut down at the end of 1999. For more information, see [announcements](http://xxx.lanl.gov/Announce/).

17 Jun 1999

Due to circumstances beyond our control, the Los Alamos e-Print Archive will suspend the ordinary database updates and mailings on Monday and Tuesday the 21,22 June 1999. For more information, see "[security standdown](interruption)."

#### Apr 1999

20 Apr 1999

The number of accumulated submissions to the archive has reached 100,000. See [monthly submissions](http://arxiv.org/stats/monthly_submissions) for the running count.

#### Dec 1998

28 Dec 1998

New domain name arXiv.org registered. All of archive.org, archives.org, thearchive.org, thearchives.org were already taken. Since the word 'archive' has a Greek root, X indicates the Greek Chi, imitating Donald Knuth's usage in the scientific typesetting language TeX (pronounced Tech), also preserving at least one of the original three x's. Note also that the word archive itself goes back to the greek "archos" for ruler, or "arche" to begin or rule, where "archeion" was the government house, and led to the latin "archivum" as a place where public records or historical documents were preserved -- hence it was natural for what is now arXiv to have in the .gov domain.

#### Sep 1998

15 Sep 1998

A new Computer Science archive, **cs@xxx.lanl.gov**, has been opened up for submissions. For more info, see [CoRR](/archive/cs/intro). It is partitioned by Subject Classes (along the lines of the [math](/new/math) archive, inititated in Jan '98), with 32 [Subject Classes](/archive/cs/subj). E-mail [subscriptions](/archive/cs/cssub) can be made to any combination of Subject Classes.

The "Computation and Language" archive (cmp-lg) has been subsumed as one of the Subject Classes of the new cs archive. New submissions will be automatically directed to the new Subject Class (cs.CL), and e-mail subscribers have been automatically transferred to the new archive.

#### Apr 1998

2 Apr 1998

Announcement: The Banach archive run for many years by Dale Alspach at Oklahoma State University has been merged into the LANL math archive. As part of this merger, two math subject areas have been created within the LANL archive:

*   math.FA Functional Analysis  
    Banach spaces, function spaces, real functions, integral transforms, theory of distributions, measure theory
*   math.OA Operator Algebras  
    Algebras of operators on Hilbert space, C\*-algebras, von Neumann algebras, non-commutative geometry

Please take care when classifying papers which you submit to the archive.

Detailed instructions for modifying your set of subscription subject areas, adding or subtracting the above areas (or others), can be obtained by sending e-mail to math@xxx.lanl.gov with Subject: subscribe

#### Mar 1998

30 Mar 1998

Note on upcoming reorganization of Mathematical Physics section: At the behest of the IAMP (=International Association of Mathematical Physics), starting 1 April 1998 the Mathematical Physics section of the archives will be reorganized to bridge the physics and the recently reorganized math groupings. The current "Mathematical Methods in Physics" subject class of the physics archive will be subsumed into a new "Mathematical Physics" archive math-ph@xxx.lanl.gov , to which future submissions should be sent. (If you are not sure whether or not your submission is physics, then it should be sent to math-ph). Submissions will also automatically appear under a "MP = Mathematical Physics" subject class of the math archive, and as usual can be cross-listed elsewhere. Current e-mail subscribers to "Mathematical Methods in Physics" will automatically be subscribed to the new archive. Current math subscribers can add the MP subject class starting 1 Apr.

9 Mar 1998

India users: note new Indian mirror at [http://xxx.imsc.ernet.in/](http://xxx.imsc.ernet.in/)

#### Jan 1998

22 Jan 1998

The [PDF](/help/pdf) produced here now includes subsetted embedded fonts. This was made feasible by the new font compression format (CFF/Type 2) introduced in PDF-1.2 (see [13 Nov 1997](#pdf1.2)). This more compactified Type1 format reduced the byte cost of font inclusion by more than a factor of three.

Note that not all PDF viewers support the font compression format (e.g. under NeXTStep, only PDFView.app (1.7) supports it; while the current versions of OmniPDF.app (2.1.3) and PDFViewer.app do not support it).

#### Dec 1997

27 Dec 1997

The math archives will be reorganized starting 1 January, 1998. The archives alg-geom, dg-ga, funct-an, and q-alg will be subsumed as subject classes in the new "math" archive (started 12/97 -- see [math info](http://xxx.lanl.gov/new/math) for more information). The intent is to provide a better organized framework for coverage of additional mathematical subject areas. Beginning 1 Jan 1998, q-alg submissions for example should be sent to math@xxx.lanl.gov with the added line (i.e. following Title:, Author:, etc.):

**Subj-class:** Quantum Algebra  
(the AMS Mathematical Subject Classification(s) should now appear on an **MSC-class:** line). Submissions to q-alg@xxx.lanl.gov will be automatically rerouted as above, and assigned numbers beginning with math.QA/9801001. As a replacement for the cross-listing mechanism (between math archives), use multiple Subj-class: entries separated by ;'s (the first is the primary). It is also possible to subscribe to receive daily abstract notifications for any subset of the math subject classes (see [math subscribe](http://xxx.lanl.gov/new/mathsub) -- current e-mail subscribers will be automatically transferred).  
An external "front end" can be found at [UC Davis front](http://front.math.ucdavis.edu/).

5 Dec 1997

Due to the healthy growth of the astro-ph archive, we are considering a Subj-class: organization similar to that which exists for the cond-mat and and physics archives. Suggested subject classes include: Cosmology and Large Scale Structure, Extra-Galactic Astronomy, Galactic Astronomy, Stars and the Interstellar Medium, Compact Objects, Planetary Systems, Stellar and Galactic Dynamics, High Energy Astrophysics, Instrumentation and Methods, History and Education. (The subject classes function effectively as separate "archives", though the collective astro-ph archive will of course continue to exist as well.) Please read [astroreorg](http://xxx.lanl.gov/new/astroreorg) before sending comments.

#### Nov 1997

13 Nov

PDF is now produced with Adobe Distiller set to level 3.0. This produces smaller PDF files due to internal compression. Users of Acroread 2.1 and older need to upgrade to a more recent version of the PDF reader.

10 Nov

Completely reorganized [help texts](/help/) on-line.

#### Oct 1997

1 Oct 1997

All official versions of papers submitted starting in Oct '97 (i.e. with numbers >= 9710) are made publicly available through the archive Web interface. See [versions](/help/versions) for more information.

#### Sep 1997

11 Sep

The e-mail search and e-mail address databases at xxx.lanl.gov discontinued (due to limited usefulness and potential for abuse in accumulating bulk e-mail lists).

9 Sep

China users: note the new Chinese mirror, [http://xxx.itp.ac.cn/](http://xxx.itp.ac.cn/), at the [Institute of Theoretical Physics](http://www.itp.ac.cn/) in Beijing

#### July 1997

29 Jul

Australia users: note the new Australian mirror, [http://xxx.adelaide.edu.au/](http://xxx.adelaide.edu.au/), at the University of Adelaide.

21 Jul

Added description of [the correct way to refer to eprints within a paper](/help/submit_tex#refs).

11 Jul

Important news for Windows users: the latest version of GSview can now read compressed files (compensating for the deficiencies in Netscape and Internet Explorer which fail to uncompress them). See [Workaround solutions for Windows](/help/pswindows) for details.

#### June 1997

30 Jun

Frequent complaints re multipart and gzipped files, see [nota bene](/x-eprint).

30 Jun

Added information on the latest postscript drivers for Macintosh. These eliminate junk from the Macintosh postscript output. See the [psjunk FAQ](/help/faq/psjunk) for details.

30 Jun

Added a user-supplied .com file for automatically _[viewing compressed postscript on VMS](/help/psvms)_.

14 Jun

A user has kindly provided a Windows 95 batch file which automatically uncompresses postscript files for viewing, see _[Viewing compressed postscript - Workaround solutions for Windows](/help/pswindows)_.

13 Jun

Added some information about _[viewing compressed postscript on VMS](/help/psvms)_.

6 Jun

For users in Germany, PDF is available on [xxx.uni-augsburg.de](http://xxx.uni-augsburg.de/), thanks to local support at University of Augsburg. Other mirror sites redirect to xxx.lanl.gov for PDF. Before trying to download PDF read the [PDF setup instructions](/help/pdf) -- you need to download and install extra fonts to make the files viewable.

#### May 1997

16 May

Russia users: note the new mirror in Moscow, [xxx.itep.ru](http://xxx.itep.ru), at the Institute for Theoretical and Experimental Physics.

Japan users: note the new upgraded mirror in Kyoto, [xxx.yukawa.kyoto-u.ac.jp](http://xxx.yukawa.kyoto-u.ac.jp/), at the Yukawa Institute for Theoretical Physics. New papers arrive by 13:45 JST (within 1 hour of availability at LANL).

15 May

**Minor** change in policy (affects only weekend submissions): the deadline for submissions to appear in the Sunday night mailing is moved back to Friday 18:00 LANL time (currently 00:00 GMT). Submissions received during the rest of the weekend will appear with Monday submissions in the Monday night mailing. After consultation with a large segment of the relevant community, it was determined to continue to delay the announcements of papers received on Fridays until Sunday nights (Monday mornings in Europe), rather than shift the Sunday mailing to Friday night. In a related development, responses to any queries received during the weekend may also be deferred until Monday morning (9:00 LANL time = 1500 GMT) -- Note that 99.97% of all e-mail queries are already answered in our [comprehensive on-line help pages](/help) and [frequently asked questions](/help/faqindex) section. Recall also that any replacements received after the 18:00 LANL time deadline Mon-Fri constitute a new (revised) version. Please note that whether or not your submission makes the deadline on any given weekday is unlikely to alter markedly the future evolution of the cosmos.

11 May

Spain users, there is now a mirror site at the Universidad de Zaragoza, Spain, [xxx.unizar.es](http://xxx.unizar.es). Other users see our existing [list of mirror sites](/servers).

Updated information on [Macintosh postscript viewers](/help/psmacs) and added some info on a [Mac shortcut to getting a bitmap version of any figure](/help/bitmap#shortcuts)

#### April 1997

Added a [cookies form](/cookies) for selecting default viewing formats and classic icons.

Renovated FAQ area has more [_workarounds for Windows and Macintosh browsers_](/help/psnonunix).

#### March 1997

17 Mar

Brazil users: note new Brazilian mirror, [http://xxx.if.usp.br/](http://xxx.if.usp.br/), at the [Instituto de Física da Universidade de São Paulo](http://www.if.usp.br/).

Added the question _[How can I submit a paper if I don't use TeX?](/help/otherformats)_ to the FAQ.

We are now using Thomas Esser's [teTeX distribution](http://www.tug.org/tetex/) as the base of our tex system.

4 Mar

Israeli users: note the new mirror, [http://xxx.tau.ac.il/](http://xxx.tau.ac.il/), at the University of Tel-Aviv.

#### January 1997

19 Jan

Taiwan users: note the new Taiwan mirror, [http://xxx.sf.nchc.gov.tw/](http://xxx.sf.nchc.gov.tw/).

German users: note the new upgraded mirror site, [http://xxx.uni-augsburg.de/](http://xxx.uni-augsburg.de/), at the University of Augsburg,

#### December 1996

Added a [Space Physics](/archive/physics) subject class to the Physics archive.

#### November 1996

24 Nov

Korean users: note the Korean mirror, [http://xxx.snu.ac.kr/](http://xxx.snu.ac.kr/), at the [ICPR](http://icpr.snu.ac.kr).

15 Nov

New hardware for xxx.lanl.gov, provided under NSF contract.

#### October 1996

7 Oct

In order to facilitate feeding the european mirrors each night before the transatlantic links become congested, daily mailings and update of the web interface will now commence at 22:00 U.S. Mountain time Sunday through Thursday (currently 04:00 GMT Monday through Friday), i.e. two hours earlier. The deadline for submissions remains 18:00 US Mountain time (i.e., currently 00:00 GMT, and 01:00 GMT during the winter) Sunday through Thursday.

5 Oct

e-mail subscribers to the physics archives: note that by subscribing to the corresponding subject classes of the new "physics" archive, you have the option to receive a single combined daily mailing (e.g. hep-th, gr-qc, and cond-mat). The option to receive separate mailings will of course remain. For further instructions, e-mail To: physics@xxx.lanl.gov, Subject: subscribe  
For general information on the new physics archive (partitioned by keyword subject classification), see http://xxx.lanl.gov/new/

1 Oct

**1 Oct '96 Reorganization** -- Information on the following three topics is available:

*   [The physics archive](physics)
*   [Cond-mat archive reorganization](condreorg)
*   [Mailings from the physics archive](physsub)

as well as a brief philosophical [synopsis](/blurb/sep96news).

#### September 1996

24 Sep

Experimental mirror sites are now operating in France, [http://xxx.lpthe.jussieu.fr/](http://xxx.lpthe.jussieu.fr/) (Paris VI) and the U.K., [http://xxx.soton.ac.uk/](http://xxx.soton.ac.uk/) (Southampton) joining the existing mirrors in Germany ( [http://physinfo.uni-augsburg.de/](http://xxx.uni-augsburg.de/)) and Italy ( [http://babbage.sissa.it/](http://xxx.sissa.it/)) and Japan ( [xxx.yukawa.kyoto-u.ac.jp](http://xxx.yukawa.kyoto-u.ac.jp/)). The latter two will soon be upgraded, and additional mirror sites are anticipated within the next few months. The goal is a more robust global server system (to avoid relapse to the medieval days when hardcopy took days, weeks, or months to arrive...).

24 Sep

On 1 Oct '96, a new "physics" archive will go on-line, and is intended to facilitate growth into areas not currently covered. Submissions will be required to have a Subj-class: field that will effectively keyword partition the archive (for subscriptions, listings, and searches). Existing archives will for the most part remain unaffected. A very provisional list of canonical subject-classes be found at http://xxx.lanl.gov/new/physics , and can be modified as needed. Constructive suggestions solicited.

2 Sep

nlin-sys archives (adap-org chao-dyn comp-gas patt-sol solv-int) consolidated from xyz.lanl.gov to xxx.lanl.gov.

#### August 1996

4 Aug

Minor policy change: the deadline for submissions to appear in the daily mailings has been moved six hours earlier to 18:00 US Mountain time (i.e., currently 00:00 GMT, and 01:00 GMT during the winter) Sunday through Thursday. The mailings will continue to commence (and web interface updated) shortly after midnight on those days (i.e., currently 06:00 GMT Mon-Fri, and 07:00 GMT during winter). Those few submissions received between 18:00 and midnight mountain time will appear in the next day's mailing. For the most part, this change will be invisible (and will primarily affect late night submissions from the US east coast, sparing us all the 2 a.m. typos...).

(See also messages from [1994-1996](/new/94-96) and [1991-1994](/new/91-94).)
