### Announcement of new Quantitative Biology (q-bio) archive

15 Sept 2003

Dear Colleagues,

In recent years, an increasing number of researchers from mathematics, computer science, and the physical sciences have been joining biologists in the ongoing revolution in biology. In a variety of ways, these researchers are contributing towards making biology a quantitative science. With this letter, we announce the formation of the q-bio archive ([http://arXiv.org/archive/q-bio](/archive/q-bio), see also [http://arXiv.org/new/q-bio](/new/q-bio)), which aims to serve the need of this emerging community. If you and your colleagues have active interest in quantitative biology (including but not limited to biological physics, computational biology, neural science, systems biology, bioinformatics, mathematical biology, and theoretical biology), we urge you to subscribe to the archive and submit (p)reprints to it. Both theoretical and experimental contributions are welcome, and subscription is freely accessible over the internet to all members of the scientific community. Instructions for registration, submission, and subscription to the archive can be found at [http://arXiv.org/help/registerhelp](/help/registerhelp), [http://arXiv.org/help/uploads](/help/uploads), and [http://arXiv.org/help/subscribe](/help/subscribe).

The q-bio archive has grown out of a well-established series of e-Print archives accessible at [http://arxiv.org/](/). The number of biology-related submissions to these archives has risen steadily over the last several years, and is averaging over 40/month so far in 2003. Unfortunately, these submissions are currently scattered across a number of sub-archives (including physics, cond-mat, nonlinear science, math, etc.), reflecting mostly the "home field" of the contributors rather than the subject matters of their submissions. Many colleagues have expressed the desire to have a centralized archive to share their latest results, and to learn about related findings by others in this field. The q-bio archive is designed to address this problem. It is organized mainly according to different categories of biological processes and partitioned according to their scales in space and time. The categories [http://arXiv.org/new/q-bio](q-bio) range from molecular and sub-cellular structures to tissues and organs, from the kinetics of molecules to population and evolutionary dynamics. In addition, a separate category is devoted to method-dominated contributions, including computational algorithms, experimental methods, as well as novel approaches to analyzing experimental data. All submissions are required to choose a primary category, with the option for one or more secondary categories. Subscribers of the archive will receive by e-mail the title/abstracts of all submissions in their chosen categories on a regular basis. A large number of bio-related submissions to the e-Print archives during the past decade have already been identified and categorized according to the above scheme using an automated procedure. They can be accessed at [http://arxiv.org/archive/q-bio](/archive/q-bio).

Please note that the current list of categories is a compromise between the large number of active subject matters in biology and the areas of quantitative biology where the e-print archives have received significant contributions during the past several years. The subject list will undoubtedly be updated as the major active areas develop/shift in time. This continuous structuring of the archive is overseen by an advisory committee. It consists of a number of well-established biologists, [William F. Loomis](http://www-biology.ucsd.edu/faculty/loomis.html) (UCSD), [Chuck Stevens](http://www.salk.edu/faculty/faculty/details.php?id=50) (Salk), [Gary Stormo](http://ural.wustl.edu/stormo.html) (WUSTL), [Diethard Tautz](http://www.uni-koeln.de/math-nat-fak/genetik/groups/Tautz/cv.html) (Cologne), together with a number of dedicated volunteers who will serve as "moderators" for each category listed at [http://arXiv.org/new/q-bio](q-bio). If you have suggestions to improve the q-bio archive, please contact the coordinators or the relevant moderators by e-mail.

It is our hope that the q-bio archive can eventually provide a greater community benefit than just a depository of (p)reprints. So far, there lacks a coherent forum devoted to quantitative issues in biology. Consequently, it has been difficult to follow progress in this discipline. We hope that the q-bio archive will serve as a virtual meeting point for all quantitative-minded scientists with serious interest in biology. Alternatively, the archive may be viewed as a virtual "half-way" house through which quantitative scientists can interact and support each other as they find their ways into the complex world of biological science. If successful, the open but focused environment provided by the q-bio archive may facilitate the maturation and self-organization of quantitative biology into a coherent field that contributes positively to both biology and the traditional quantitative sciences. Reaching this goal will require participation from every individual in this discipline. We look forward to meeting you at the archive.

With best wishes,

  
[Terry Hwa](http://matisse.ucsd.edu/~hwa/) and [Michael Lässig](http://www.thp.Uni-Koeln.DE/~lassig/)  
q-bio coordinators
