# Announcement of new Quantitative Finance (q-fin) archive

1 December 2008

Dear Colleagues,

In the past decade, an increasing number of researchers from mathematics
and physical sciences have been contributing together with their peers
from economics and social sciences to the rapidly growing field of
quantitative finance. This field, whose creation was marked by such
important breakthroughs as the Modern Portfolio Theory of Markowitz,
Capital Asset Pricing Model of Sharpe, Lintner, Mossin and Treynor, and
Option Pricing Theory of Black, Scholes and Merton, has always relied on
the power of mathematical tools and methods to discover and describe the
mechanisms behind the workings of financial markets. This reliance has
continued to grow with the complexity of the problems considered, and
has led to many fruitful examples of cross-pollination of the ideas
between the fields. The rapid growth of the financial industry has
brought together many researchers with diverse scientific backgrounds
who now work in banks, investment management, insurance and other
companies which rely on innovation for the growth of their business. In
academia as well, we have seen a growing number of cross-disciplinary
efforts, from joint seminars and symposia to cross-departmental programs
such as those offering the increasingly popular financial engineering
degrees.

To further promote this convergence of ideas and stimulate the dialogue
between disciplines as well as between the academics and practitioners,
we announce the formation of the new [Quantitative Finance (q-fin)
archive](/archive/q-fin).

If you and your colleagues have active interest in quantitative finance,
we urge you to subscribe to the archive and submit (p)reprints to it.
Both theoretical contributions and those related to practical
applications are welcome, and subscription is freely accessible over the
internet to all members of the scientific community. Instructions for
registration, submission and subscription to the archive can be found at
[http://arxiv.org/help/registerhelp](/help/registerhelp),
[http://arxiv.org/help/uploads](/help/uploads), and
[http://arxiv.org/help/subscribe](/help/subscribe).

The q-fin archive has grown out of a well-established series of e-print
archives accessible at [http://arxiv.org/](/). The number of
finance-related submissions to these archives has risen steadily over
the last several years. Unfortunately, these submissions are currently
scattered across a number of sub-archives (including physics, cond-mat,
nonlinear science, math, etc.), reflecting mostly the "home field" of
the contributors rather than the subject matters of their submissions.
At the same time, well- established electronic repositories within the
social sciences field, such as SSRN, RepEc/IDEAS and others, while
containing a wealth of articles on quantitative finance, do not
generally offer as detailed a coverage and classification to this field
as its practical prominence and throughput of new papers would suggest.
As a result, while the existing repositories attract many academic
contributions, only a subset of practitioners tends to submit their work
to these sites. On the other hand, a handful of sites well-known amongst
practitioners, such as defaultrisk.com, wilmott.com, and others have
either been narrowly targeted at the particular subset of quantitative
finance or have not attracted many academic contributors.

Many colleagues have expressed the desire to have a centralized archive
with clear and concise content classification to share their latest
results, and to learn about related findings by others in this field. We
believe that both the organizational structure of arXiv.org, as well as
its functional flexibility and robustness, make it a natural fit for the
improved and extended repository of quantitative finance papers on the
internet that would be open to and actively used by researchers from all
academic backgrounds and from industry alike.

The new q-fin archive is organized mainly according to different
applications of methodologies within quantitative finance, broken out
into four main such applications - valuation, risk management, portfolio
management and trading. We have also included two separate categories
dedicated to the development of statistical and computational
methodologies since these methods often have significant importance by
themselves, and can have multiple applications in different areas.
Finally we have included a category for general methods which will serve
as an outlet for those contributions that do not easily fit in the other
categories.

The list below outlines the initial sub-categories and gives a brief
description of the types of contributions expected to be found in each
sub-category:

  - **q-fin.PR - Pricing of Securities**  
    Models for pricing, hedging and relative valuation of traded
    securities, their derivatives, and structured products.
  - **q-fin.RM - Risk Management**  
    Methodologies for measuring and managing financial risks in trading,
    banking, insurance, corporate and other applications.
  - **q-fin.PM - Portfolio Management**  
    Models for portfolio selection and optimization, capital allocation
    and investment strategies.
  - **q-fin.TR - Trading and Microstructure**  
    Market Models of market microstructure, liquidity, exchange and
    auction design, automated (electronic) trading, agent-based modeling
    and market-making.
  - **q-fin.ST - Statistical Finance**  
    Statistical, econometric and econophysics analyses with applications
    to financial markets and economic data.
  - **q-fin.CP - Computational Finance**  
    Development of computational methods and their applications to
    financial markets, including Monte Carlo, PDE, lattice and other
    analytical and numerical methods.
  - **q-fin.GN - General Finance**  
    Development of general quantitative methodologies with applications
    in financial markets and economics.

All submissions are required to choose a primary category, with the
option for one or more secondary categories. Subscribers of the archive
will receive by e-mail the title/abstracts of all submissions in their
chosen categories on a regular basis.

A [large number](/help/stats/2006_by_area/q-fin_monthly.png) of
finance-related submissions to the arXiv.org e-Print archives during the
past decade have already been identified and re-classified according to
the above scheme. We thank Pierre-Alain Reigneron (CFM) for helping with
this task. These earlier submissions will be accessible at
[http://arxiv.org/archive/q-fin](/archive/q-fin) along with new
Quantitative Finance submissions.

To further improve the flow of information within the quantitative
finance community, the preprints posted in the q-fin archive will be
eligible for direct online submission for publication in the following
print journals:

  - [Quantitative Finance](http://www.tandf.co.uk/journals/rquf)
  - [Journal of Derivatives](http://www.iijournals.com/JOD/)
  - [International Journal of Theoretical and Applied
    Finance](http://www.worldscinet.com/ijtaf/)
  - [Journal of Risk](http://www.thejournalofrisk.com/)
  - [Journal of Credit Risk](http://www.journalofcreditrisk.com/)
  - [Journal of Risk Model
    Validation](http://www.journalofriskmodelvalidation.com/)
  - [Journal of Operational
    Risk](http://www.journalofoperationalrisk.com/)
  - [Journal of Computational
    Finance](http://www.journalofcomputationalfinance.com/)
  - [Journal of Energy Markets](http://www.journalofenergymarkets.com/)

We express our gratitude to the editorial management of these journals
for their support and collaboration. The q-fin advisory committee will
also work with other publishers to make similar submissions available
for more journals in the future.

Please note that the current list of categories is a compromise between
the large number of active subject matters in quantitative finance and
the areas where the e-print archives have received significant
contributions during the past several years. The subject list will be
updated as the major active areas develop in time. This continuous
structuring of the archive is overseen by an advisory committee. It
consists of a number of well-known researchers representing both
academic institutions and the financial industry. A number of dedicated
volunteers will serve as "moderators" for each category listed at
[http://arxiv.org/help/q-fin](/help/q-fin). If you have suggestions to
improve the q-fin archive, please contact the coordinators by e-mail.

Arthur M. Berd and Jean-Philippe Bouchaud  
q-fin coordinators
