#ifndef NeedFunctionPrototypes
#if defined(FUNCPROTO) || defined(__STDC__) || defined(__cplusplus) || defined(c_plusplus)
#define NeedFunctionPrototypes 1
#else
#define NeedFunctionPrototypes 0
#endif /* __STDC__ */
#endif /* NeedFunctionPrototypes */

#include <sys/stat.h>

#if NeedFunctionPrototypes
#define P(x) x
#else
#define P(x) ()
#endif

typedef struct {
	int	statDone;
	char	*real;
	char	*shown;
} SFEntry;

typedef struct {
	char	*dir;
	char	*path;
	SFEntry	*entries;
	int	nEntries;
	int	vOrigin;
	int	nChars;
	int	hOrigin;
	int	changed;
	int	beginSelection;
	int	endSelection;
	time_t	mtime;
} SFDir;

extern void SFpositionWidget P((Widget w));
extern FILE * SFopenFile P((char *name, char *mode, char *prompt, char *failed));
extern void SFtextChanged P((void));
extern FILE * XsraSelFile P((Widget toplevel, char *prompt, char *ok, char *cancel,
			     char *failed, char *init_path, char *mode,
			     int(*show_entry)(char*, char**, struct stat *), char **name_return));

extern int SFcompareEntries P((const void *p, const void *q));
extern int SFgetDir P((SFDir *dir));
extern void SFinitFont P((void));
extern void SFcreateGC P((void));
extern void SFclearList P((int n, int doScroll));
extern void SFdrawList P((int n, int doScroll));
extern void SFdrawLists P((int doScroll));
extern void SFenterList P((Widget W, XtPointer n, XEvent *event, Boolean*));
extern void SFleaveList  P((Widget W, XtPointer n, XEvent *event, Boolean*));
extern void SFmotionList P((Widget W, XtPointer n, XEvent *event, Boolean*));
extern void SFvFloatSliderMovedCallback P((Widget W, XtPointer n, XtPointer fnew));
extern void SFvSliderMovedCallback P((Widget W, XtPointer n, XtPointer new));
extern void SFvAreaSelectedCallback P((Widget W, XtPointer n, XtPointer pnew));
extern void SFhSliderMovedCallback P((Widget W, XtPointer n, XtPointer fnew));
extern void SFhAreaSelectedCallback P((Widget W, XtPointer n, XtPointer pnew));
extern void SFpathSliderMovedCallback P((Widget W, XtPointer client_data, XtPointer fnew));
extern void SFpathAreaSelectedCallback P((Widget W, XtPointer client_data, XtPointer pnew));
extern Boolean SFworkProc P((XtPointer));
extern int SFchdir P((char*path));
extern void SFupdatePath P((void));
extern void SFsetText P((char *path));
extern void SFbuttonPressList P((Widget w, XtPointer n, XEvent *event, Boolean*));
extern void SFbuttonReleaseList P((Widget w, XtPointer n, XEvent *event, Boolean*));
extern void SFdirModTimer P((XtPointer cl, XtIntervalId *id));
extern char SFstatChar P((struct stat *statBuf));
