/*
 * gv.h -- Main include file for ghostview.
 * Copyright (C) 1992  Timothy O. Theisen
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *   Author: Tim Theisen           Systems Programmer
 * Internet: tim@cs.wisc.edu       Department of Computer Sciences
 *     UUCP: uwvax!tim             University of Wisconsin-Madison
 *    Phone: (608)262-0438         1210 West Dayton Street
 *      FAX: (608)262-9777         Madison, WI   53706
 */

/* This file is part of the hacked version of the ghostview package */
/* which is distributed under the terms of the gnu license. The */
/* modification referred to above is by Tanmoy Bhattacharya, */
/* <tanmoy@qcd.lanl.gov> on Nov 17, 1994 and Feb 14, 1995. Neither the */
/* modification, nor the original program provides any warranty. */

#ifndef NeedFunctionPrototypes
#if defined(FUNCPROTO) || defined(__STDC__) || defined(__cplusplus) || defined(c_plusplus)
#define NeedFunctionPrototypes 1
#else
#define NeedFunctionPrototypes 0
#endif /* __STDC__ */
#endif /* NeedFunctionPrototypes */

#if NeedFunctionPrototypes
#define P(x) x
#else
#define P(x) ()
#endif

#include <stdio.h>
#include <X11/Xos.h>
#include <sys/stat.h>
#include <X11/Intrinsic.h>
#define XtSetFloatArg(arg, n, d) \
    if (sizeof(float) > sizeof(XtArgVal)) { \
	XtSetArg(arg, n, &(d)); \
    } else { \
	XtArgVal *ld = (XtArgVal *)&(d); \
	XtSetArg(arg, n, *ld); \
    }
#include "Ghostview.h"

/* Application resources */
typedef struct _AppResources {
    Boolean show_title;		/* whether to show title */
    Boolean show_date;		/* whether to show date */
    Boolean show_locator;	/* whether to show locator */
    Boolean auto_center;	/* whether to automatically center the page */
    int wm_horiz_margin;	/* Space taken by window manager */
    int wm_vert_margin;		/* Space taken by window manager */
    int minimum_magstep;	/* smallest magstep allowed */
    int maximum_magstep;	/* largest magstep allowed */
    int magstep;		/* default magstep */
    XtPageOrientation orientation;	/* default orientation */
    String page;		/* first page to show */
    String pagemedia;		/* default page media */
    Boolean force_orientation;	/* use default to override document comments */
    Boolean force_pagemedia;	/* use default to override document comments */
    Boolean swap_landscape;	/* Landscape comment maps to Seascape */
    String print_command;	/* command used to print doc, usually "lpr" */
    String printer_variable;	/* env varaible to use, usually "PRINTER" */
    String default_printer;	/* printer to use if no PRINTER is not set*/
    String print_prompt;	/* string to prompt user for printer name */
    String print_fail;		/* string to inform user that print failed */
    String open_prompt;		/* string to prompt for file name to open */
    String open_fail;		/* string to inform user that open failed */
    String save_prompt;		/* string to prompt for file name to save */
    String save_fail;		/* string to inform user that save failed */
    String WWWBrowser;          /* The WWW Browser */
    /* Work arounds for others' bugs */
    Boolean openwindows;	/* whether to work around openwindow bug */
    Boolean ncdwm;		/* whether to work around ncdwm bug */
} AppResources;

extern float	default_xdpi;
extern float	default_ydpi;

extern int	num_ghosts;
extern FILE	*psfile;
extern char     zoomfilename[];
extern int      ispdf, iscompressed;
extern String	filename;
extern String	oldfilename;
extern int	current_page;
extern int	current_magstep;
extern XtPageOrientation	current_orientation;
extern int	default_pagemedia;
extern int	current_pagemedia;
extern Boolean	force_document_media;
extern int	document_media;
extern int	current_llx;
extern int	current_lly;
extern int	current_urx;
extern int	current_ury;
extern int	base_papersize;
extern Boolean	info_up;
extern int	force_setting;
extern Pixmap	dot_bitmap;
extern Pixmap	menu16_bitmap;
extern Pixmap	tie_fighter_bitmap;
extern String	toc_text;
extern int	toc_length;
extern int	toc_entry_length;
extern int	info_length;
extern time_t	mtime;
extern struct document *doc;
extern struct document *olddoc;
extern Atom	wm_delete_window;
extern XErrorHandler	old_Xerror;
extern Boolean	dying;
extern XErrorEvent	bomb;

enum {OPEN, PRINT_WHOLE, PRINT_MARKED, SAVE};
extern int	mode;

extern XtAppContext app_con;
extern AppResources app_res;

/* Widgets */
extern Widget toplevel;
extern Widget     form;
extern Widget         titlebutton;
extern Widget             titlemenu;
extern Widget         datebutton;
extern Widget             datemenu;
extern Widget         locator;
extern Widget         box;
extern Widget             filebutton;
extern Widget                 filemenu;
extern Widget                     openbutton;
extern Widget                     reopenbutton;
extern Widget                     printwholebutton;
extern Widget                     printmarkedbutton;
extern Widget                     savebutton;
extern Widget                     copyrightbutton;
extern Widget                     quitbutton;
extern Widget             pagebutton;
extern Widget                 pagemenu;
extern Widget                     nextbutton;
extern Widget                     showbutton;
extern Widget                     prevbutton;
extern Widget                     backbutton;
extern Widget                     centerbutton;
extern Widget                     markbutton;
extern Widget                     unmarkbutton;
extern Widget             magstepbutton;
extern Widget                 magstepmenu;
extern Widget                     *magstepentry;
extern Widget             orientationbutton;
extern Widget                 orientationmenu;
extern Widget                     portraitbutton;
extern Widget                     landscapebutton;
extern Widget                     upsidedownbutton;
extern Widget                     seascapebutton;
extern Widget                     swapbutton;
extern Widget             pagemediabutton;
extern Widget                 pagemediamenu;
extern Widget                     *pagemediaentry;
extern Widget         toc;
extern Widget         pageview;
extern Widget             page;

/* Popup widgets */
extern Widget infopopup;
extern Widget     infoform;
extern Widget         infotext;
extern Widget         infobutton;
extern Widget copyrightpopup;
extern Widget     copyrightform;
extern Widget         copyrighttext;
extern Widget         copyrightbutton;
extern Widget dialogpopup;
extern Widget     dialog;

#if NeedFunctionPrototypes
#define P(x) x
#else
#define P(x) ()
#endif

/* Dialogs */
extern Widget CreateDialog P((Widget parent, String name,
			      XtCallbackProc okay_callback, XtCallbackProc cancel_callback));
extern String GetDialogPrompt P((Widget w));
extern void SetDialogPrompt P((Widget w, String newprompt));
extern String GetDialogResponse P((Widget w));
extern void SetDialogResponse P((Widget w, String s));
extern void ClearDialogResponse P((Widget w));

/* Callbacks */
extern void quit_ghostview P((Widget w, XtPointer client_data, XtPointer call_data));
extern void popup P((Widget w, XtPointer client_data, XtPointer call_data));
extern void popup_dialog P((Widget w, XtPointer client_data, XtPointer call_data));
extern void reopen_file P((Widget w, XtPointer client_data, XtPointer call_data));
extern void prev_page P((Widget w, XtPointer client_data, XtPointer call_data));
extern void back_page P((Widget w, XtPointer client_data, XtPointer call_data));
extern void this_page P((Widget w, XtPointer client_data, XtPointer call_data));
extern void next_page P((Widget w, XtPointer client_data, XtPointer call_data));
extern void center_page P((Widget w, XtPointer client_data, XtPointer call_data));
extern void mark_page P((Widget w, XtPointer client_data, XtPointer call_data));
extern void unmark_page P((Widget w, XtPointer client_data, XtPointer call_data));
extern void set_magstep P((Widget w, XtPointer client_data, XtPointer call_data));
extern void set_orientation P((Widget w, XtPointer client_data, XtPointer call_data));
extern void swap_landscape P((Widget w, XtPointer client_data, XtPointer call_data));
extern void set_pagemedia P((Widget w, XtPointer client_data, XtPointer call_data));
extern void track_and_zoom P((Widget w, XtPointer client_data, XtPointer call_data));
extern void message P((Widget w, XtPointer client_data, XtPointer call_data));
extern void output P((Widget w, XtPointer client_data, XtPointer call_data));
extern void okay P((Widget w, XtPointer client_data, XtPointer call_data));
extern void dismiss P((Widget w, XtPointer client_data, XtPointer call_data));
extern void destroy P((Widget w, XtPointer client_data, XtPointer call_data));
extern void destroy_ghost P((Widget w, XtPointer client_data, XtPointer call_data));

/* Actions */
extern void gv_copyright P((Widget w, XEvent *event, String *params, Cardinal *num_params));
extern void gv_quit P((Widget w, XEvent *event, String *params, Cardinal *num_params));
extern void gv_open P((Widget w, XEvent *event, String *params, Cardinal *num_params));
extern void gv_reopen P((Widget w, XEvent *event, String *params, Cardinal *num_params));
extern void gv_save P((Widget w, XEvent *event, String *params, Cardinal *num_params));
extern void gv_print_whole P((Widget w, XEvent *event, String *params, Cardinal *num_params));
extern void gv_print_marked P((Widget w, XEvent *event, String *params, Cardinal *num_params));
extern void gv_prev P((Widget w, XEvent *event, String *params, Cardinal *num_params));
extern void gv_show P((Widget w, XEvent *event, String *params, Cardinal *num_params));
extern void gv_next P((Widget w, XEvent *event, String *params, Cardinal *num_params));
extern void gv_center P((Widget w, XEvent *event, String *params, Cardinal *num_params));
extern void gv_mark P((Widget w, XEvent *event, String *params, Cardinal *num_params));
extern void gv_unmark P((Widget w, XEvent *event, String *params, Cardinal *num_params));
extern void gv_set_magstep P((Widget w, XEvent *event, String *params, Cardinal *num_params));
extern void gv_increase_magstep P((Widget w, XEvent *event, String *params, Cardinal *num_params));
extern void gv_decrease_magstep P((Widget w, XEvent *event, String *params, Cardinal *num_params));
extern void gv_set_orientation P((Widget w, XEvent *event, String *params, Cardinal *num_params));
extern void gv_swap_landscape P((Widget w, XEvent *event, String *params, Cardinal *num_params));
extern void gv_set_pagemedia P((Widget w, XEvent *event, String *params, Cardinal *num_params));
extern void gv_default P((Widget w, XEvent *event, String *params, Cardinal *num_params));
extern void gv_force P((Widget w, XEvent *event, String *params, Cardinal *num_params));
extern void gv_delete_window P((Widget w, XEvent *event, String *params, Cardinal *num_params));
extern void gv_delete_zoom P((Widget w, XEvent *event, String *params, Cardinal *num_params));
extern void gv_dismiss P((Widget w, XEvent *event, String *params, Cardinal *num_params));
extern void gv_scroll_up P((Widget w, XEvent *event, String *params, Cardinal *num_params));
extern void gv_scroll_down P((Widget w, XEvent *event, String *params, Cardinal *num_params));
extern void gv_scroll_left P((Widget w, XEvent *event, String *params, Cardinal *num_params));
extern void gv_scroll_right P((Widget w, XEvent *event, String *params, Cardinal *num_params));
extern void gv_erase_locator P((Widget w, XEvent *event, String *params, Cardinal *num_params));
extern void gv_check_file P((Widget w, XEvent *event, String *params, Cardinal *num_params));
extern void gv_back P((Widget w, XEvent *event, String *params, Cardinal *num_params));

/* Misc */
extern void show_page P((int number,Widget w));
extern Boolean setup_ghostview P((Widget w));
extern int find_page P((String label));
extern void layout_ghostview  P((void));
extern void magnify P((float*dpi, int magstep));
extern String open_file P((String name, Widget w));
extern String save_file P((String name));
extern String print_file P((String name, int whole_mode));
extern void pscopydoc P((FILE*fp));
extern void positionpopup P((Widget w));
extern Boolean set_new_magstep P((void));
extern Boolean set_new_orientation P((int number));
extern Boolean set_new_pagemedia P((int number));
extern void build_pagemedia_menu P((void));
extern Widget build_label_menu P((Widget parent, String name, String label, Pixmap bitmap));
extern void new_file P((int number, Widget w));
extern int catch_Xerror P((Display *dpy, XErrorEvent *err));
extern char *fgetline P((char *s, size_t n, FILE *stream));
extern int getskipcount P((void));
void call_http P((char*url, Widget w));

/* setenv */
extern int setenv P((register const char *name, register const char *value, int rewrite));
extern void unsetenv P((const char *name));

/* strcasecmp */
extern int strcasecmp P((const char*s1, const char *s2));
extern int strncasecmp P((const char*s1, const char *s2, register size_t n));
