const Capability = require("./Capability");
const NotImplementedError = require("../NotImplementedError");

/**
 * List and restore map snapshots which are generated by the firmware
 * 
 * @template {import("../ValetudoRobot")} T
 * @extends Capability<T>
 */
class MapSnapshotCapability extends Capability {
    /**
     * @abstract
     * @returns {Promise<Array<import("../../entities/core/ValetudoMapSnapshot")>>}
     */
    async getSnapshots() {
        throw new NotImplementedError();
    }

    /**
     * @param {import("../../entities/core/ValetudoMapSnapshot")} snapshot
     * @returns {Promise<void>}
     */
    async restoreSnapshot(snapshot) {
        throw new NotImplementedError();
    }

    getType() {
        return MapSnapshotCapability.TYPE;
    }
}

MapSnapshotCapability.TYPE = "MapSnapshotCapability";

module.exports = MapSnapshotCapability;
