const entities = require("../../entities");
const MiioValetudoRobot = require("../MiioValetudoRobot");
const RoborockValetudoRobot = require("./RoborockValetudoRobot");



class RoborockV1ValetudoRobot extends RoborockValetudoRobot {
    /**
     *
     * @param {object} options
     * @param {import("../../Configuration")} options.config
     * @param {import("../../ValetudoEventStore")} options.valetudoEventStore
     */
    constructor(options) {
        super(Object.assign({}, options, {fanSpeeds: FAN_SPEEDS}));
    }

    getModelName() {
        return "Xiaomi Mi Robot Vacuum";
    }

    static IMPLEMENTATION_AUTO_DETECTION_HANDLER() {
        const deviceConf = MiioValetudoRobot.READ_DEVICE_CONF(RoborockValetudoRobot.DEVICE_CONF_PATH);

        return !!(deviceConf && deviceConf.model === "rockrobo.vacuum.v1");
    }
}

const FAN_SPEEDS = {
    [entities.state.attributes.PresetSelectionStateAttribute.INTENSITY.MIN]: 1,
    [entities.state.attributes.PresetSelectionStateAttribute.INTENSITY.LOW]: 38,
    [entities.state.attributes.PresetSelectionStateAttribute.INTENSITY.MEDIUM]: 60,
    [entities.state.attributes.PresetSelectionStateAttribute.INTENSITY.HIGH]: 75,
    [entities.state.attributes.PresetSelectionStateAttribute.INTENSITY.MAX]: 100
};

module.exports = RoborockV1ValetudoRobot;
