/* eslint-disable */
const fs = require("fs");
const path = require("path");

const Robots = require("../backend/lib/robots");
const Configuration = require("../backend/lib/Configuration");

function generateAnchor(str) {
    return str.replace(/[^0-9a-z-A-Z]/g, "").toLowerCase()
}

function generateCapabilityLink(capability) {
    return "[" + capability + "](https://valetudo.cloud/pages/general/capabilities-overview.html#" + capability + ")";
}

function generateTable(models, tableData) {
    let ret = "## Overview<a id='Overview'></a>\n\nCapability | ";
    ret += models.map((m) => {
        return "<a href='#" + m[1] + "'>" + m[0] + "</a>";
    }).join(" | ");
    ret += "\n----";
    models.forEach(() => {
        ret += " | ----";
    })
    ret += "\n";
    Object.keys(tableData).sort().forEach(capability => {
        ret += generateCapabilityLink(capability);
        models.forEach(m => {
            ret += " | ";
            if (tableData[capability].indexOf(m[0]) !== -1) {
                ret += "<span style=\"color:green;\">Yes</span>";
            } else {
                ret += "<span style=\"color:red\;\">No</span>";
            }
        });
        ret += "\n";
    });

    return ret;
}

process.on("uncaughtException", function(err) {
    if (err.errno === "EADDRINUSE") {
        //lol
    } else {
        console.log(err);
        process.exit(1);
    }
});

const vendors = {};

Object.values(Robots).forEach(robotClass => {
    const config = new Configuration();
    config.set("embedded", false);

    try {
        const instance = new robotClass({
            config: config
        });

        vendors[instance.getManufacturer()] = vendors[instance.getManufacturer()] ? vendors[instance.getManufacturer()] : {};

        vendors[instance.getManufacturer()][instance.constructor.name] = {
            modelName: instance.getModelName(),
            capabilities: Object.keys(instance.capabilities).sort()
        }
    } catch (e) {
        console.error(e);
    }
});

const header = `---
title: Supported Robots
category: General
order: 7
---

# Supported Robots

This page features an autogenerated overview of all robots supported by Valetudo including their supported capabilities.<br/>
To find out what those do, check out the [capabilities overview](https://valetudo.cloud/pages/general/capabilities-overview.html) section of the docs.

This is just the autogenerated overview because it's hard to write documentation for everything and keep that up to date. <br/>
Keep in mind that rooting instructions will differ for each of these **or might not even be available at all**.
Just because the code would - in theory - support a Robot doesn't necessarily mean that you can simply buy it and put Valetudo on it.<br/>

To find out if you can install Valetudo on your robot, check out the [Rooting Instructions](https://valetudo.cloud/pages/general/rooting-instructions.html).
If you can't find it there, it's most likely not possible (yet?).
Another source is [https://dontvacuum.me/robotinfo/](https://dontvacuum.me/robotinfo/). Search for "Root method public?".
If it's listed as "no", then it's certainly not possible for you to run Valetudo on it.


Again:<br/>
This is just an autogenerated overview based on the codebase at the time of generation.<br/>
Don't take this as "Everything listed here will be 100% available and work all the time".<br/>

`;

const ToC = [
    "## Table of Contents",
    "1. [Overview](#Overview)"
];
const VendorSections = [];

const SummaryTable = {};
const RobotModels = [];

Object.keys(vendors).filter(v => v !== "Valetudo").sort().forEach((vendor, i) => {
    let vendorTocEntry = [
        (i+2) + ". [" + vendor +"](#" + generateAnchor(vendor) + ")"
    ];

    // noinspection JSMismatchedCollectionQueryUpdate
    let vendorSection = [
        "## " + vendor + '<a id="'+generateAnchor(vendor)+'"></a>',
        ""
    ]


    const vendorRobots = vendors[vendor];

    Object.keys(vendorRobots).sort().forEach((robotImplName, i) => {
        const robot = vendorRobots[robotImplName];
        const robotAnchor = generateAnchor(vendor) + "_" + generateAnchor(robot.modelName);

        RobotModels.push([robot.modelName, robotAnchor]);

        vendorTocEntry.push("    " + (i+1) + ". [" + robot.modelName + "](#" + robotAnchor + ")");

        vendorSection.push(
            "### " + robot.modelName + '<a id="'+robotAnchor+'"></a>',
            "",
            "This model supports the following capabilities:"
        );

        robot.capabilities.forEach(capability => {
            vendorSection.push("  - " + generateCapabilityLink(capability));
            if (!SummaryTable.hasOwnProperty(capability)) {
                SummaryTable[capability] = [robot.modelName]
            } else {
                SummaryTable[capability].push(robot.modelName);
            }
        });

        vendorSection.push("", "");
    })


    ToC.push(vendorTocEntry.join("\n"));
    VendorSections.push(vendorSection.join("\n"));
});



const page = [
    header,
    ToC.join("\n"),
    "\n<br/>\n",
    generateTable(RobotModels, SummaryTable),
    "\n<br/>\n",
    VendorSections.join("\n"),
    "<br/><br/><br/><br/><br/>",
    "This page has been autogenerated.<br/>",
    "Autogeneration timestamp: " + new Date().toISOString()
]

fs.writeFileSync(path.join(__dirname, "../docs/_pages/general/supported-robots.md"), page.join("\n") + "\n")
process.exit(0);
