// Copyright 2022 The NativeLink Authors. All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//    http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// This file is @generated by prost-build.
/// Information about the action cache behavior during a single build.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ActionCacheStatistics {
    /// Size of the action cache in bytes.
    ///
    /// This is computed by the code that persists the action cache to disk and
    /// represents the size of the written files, which has no direct relation to
    /// the number of entries in the cache.
    #[prost(uint64, tag = "1")]
    pub size_in_bytes: u64,
    /// Time it took to save the action cache to disk.
    #[prost(uint64, tag = "2")]
    pub save_time_in_ms: u64,
    /// Cache counters.
    #[prost(int32, tag = "3")]
    pub hits: i32,
    #[prost(int32, tag = "4")]
    pub misses: i32,
    /// Breakdown of the cache misses based on the reasons behind them.
    #[prost(message, repeated, tag = "5")]
    pub miss_details: ::prost::alloc::vec::Vec<action_cache_statistics::MissDetail>,
    /// Time it took to load the action cache from disk. Reported as 0 if the
    /// action cache has not been loaded in this invocation.
    #[prost(uint64, tag = "6")]
    pub load_time_in_ms: u64,
}
/// Nested message and enum types in `ActionCacheStatistics`.
pub mod action_cache_statistics {
    /// Detailed information for a particular miss reason.
    #[derive(Clone, Copy, PartialEq, ::prost::Message)]
    pub struct MissDetail {
        #[prost(enumeration = "MissReason", tag = "1")]
        pub reason: i32,
        #[prost(int32, tag = "2")]
        pub count: i32,
    }
    /// Reasons for not finding an action in the cache.
    #[derive(
        Clone,
        Copy,
        Debug,
        PartialEq,
        Eq,
        Hash,
        PartialOrd,
        Ord,
        ::prost::Enumeration
    )]
    #[repr(i32)]
    pub enum MissReason {
        DifferentActionKey = 0,
        DifferentDeps = 1,
        DifferentEnvironment = 2,
        DifferentFiles = 3,
        CorruptedCacheEntry = 4,
        NotCached = 5,
        UnconditionalExecution = 6,
    }
    impl MissReason {
        /// String value of the enum field names used in the ProtoBuf definition.
        ///
        /// The values are not transformed in any way and thus are considered stable
        /// (if the ProtoBuf definition does not change) and safe for programmatic use.
        pub fn as_str_name(&self) -> &'static str {
            match self {
                Self::DifferentActionKey => "DIFFERENT_ACTION_KEY",
                Self::DifferentDeps => "DIFFERENT_DEPS",
                Self::DifferentEnvironment => "DIFFERENT_ENVIRONMENT",
                Self::DifferentFiles => "DIFFERENT_FILES",
                Self::CorruptedCacheEntry => "CORRUPTED_CACHE_ENTRY",
                Self::NotCached => "NOT_CACHED",
                Self::UnconditionalExecution => "UNCONDITIONAL_EXECUTION",
            }
        }
        /// Creates an enum from field names used in the ProtoBuf definition.
        pub fn from_str_name(value: &str) -> ::core::option::Option<Self> {
            match value {
                "DIFFERENT_ACTION_KEY" => Some(Self::DifferentActionKey),
                "DIFFERENT_DEPS" => Some(Self::DifferentDeps),
                "DIFFERENT_ENVIRONMENT" => Some(Self::DifferentEnvironment),
                "DIFFERENT_FILES" => Some(Self::DifferentFiles),
                "CORRUPTED_CACHE_ENTRY" => Some(Self::CorruptedCacheEntry),
                "NOT_CACHED" => Some(Self::NotCached),
                "UNCONDITIONAL_EXECUTION" => Some(Self::UnconditionalExecution),
                _ => None,
            }
        }
    }
}
