// Copyright 2022 The NativeLink Authors. All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//    http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// This file is @generated by prost-build.
/// Identifier for a build event. It is deliberately structured to also provide
/// information about which build target etc the event is related to.
///
/// Events are chained via the event id as follows: each event has an id and a
/// set of ids of children events such that apart from the initial event each
/// event has an id that is mentioned as child id in an earlier event and a build
/// invocation is complete if and only if all direct and indirect children of the
/// initial event have been posted.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct BuildEventId {
    #[prost(
        oneof = "build_event_id::Id",
        tags = "1, 2, 3, 11, 18, 14, 12, 17, 15, 16, 4, 10, 13, 5, 6, 19, 21, 8, 29, 7, 26, 9, 20, 22, 23, 24, 25, 28"
    )]
    pub id: ::core::option::Option<build_event_id::Id>,
}
/// Nested message and enum types in `BuildEventId`.
pub mod build_event_id {
    /// Generic identifier for a build event. This is the default type of
    /// BuildEventId, but should not be used outside testing; nevertheless,
    /// tools should handle build events with this kind of id gracefully.
    #[derive(Clone, PartialEq, ::prost::Message)]
    pub struct UnknownBuildEventId {
        #[prost(string, tag = "1")]
        pub details: ::prost::alloc::string::String,
    }
    /// Identifier of an event reporting progress. Those events are also used to
    /// chain in events that come early.
    #[derive(Clone, Copy, PartialEq, ::prost::Message)]
    pub struct ProgressId {
        /// Unique identifier. No assumption should be made about how the ids are
        /// assigned; the only meaningful operation on this field is test for
        /// equality.
        #[prost(int32, tag = "1")]
        pub opaque_count: i32,
    }
    /// Identifier of an event indicating the beginning of a build; this will
    /// normally be the first event.
    #[derive(Clone, Copy, PartialEq, ::prost::Message)]
    pub struct BuildStartedId {}
    /// Identifier on an event indicating the original commandline received by
    /// the bazel server.
    #[derive(Clone, Copy, PartialEq, ::prost::Message)]
    pub struct UnstructuredCommandLineId {}
    /// Identifier on an event describing the commandline received by Bazel.
    #[derive(Clone, PartialEq, ::prost::Message)]
    pub struct StructuredCommandLineId {
        /// A title for this command line value, as there may be multiple.
        /// For example, a single invocation may wish to report both the literal and
        /// canonical command lines, and this label would be used to differentiate
        /// between both versions.
        #[prost(string, tag = "1")]
        pub command_line_label: ::prost::alloc::string::String,
    }
    /// Identifier of an event indicating the workspace status.
    #[derive(Clone, Copy, PartialEq, ::prost::Message)]
    pub struct WorkspaceStatusId {}
    /// Identifier on an event reporting on the options included in the command
    /// line, both explicitly and implicitly.
    #[derive(Clone, Copy, PartialEq, ::prost::Message)]
    pub struct OptionsParsedId {}
    /// Identifier of an event reporting that an external resource was fetched
    /// from.
    #[derive(Clone, PartialEq, ::prost::Message)]
    pub struct FetchId {
        /// The external resource that was fetched from.
        #[prost(string, tag = "1")]
        pub url: ::prost::alloc::string::String,
    }
    /// Identifier of an event indicating that a target pattern has been expanded
    /// further.
    /// Messages of this shape are also used to describe parts of a pattern that
    /// have been skipped for some reason, if the actual expansion was still
    /// carried out (e.g., if keep_going is set). In this case, the
    /// pattern_skipped choice in the id field is to be made.
    #[derive(Clone, PartialEq, ::prost::Message)]
    pub struct PatternExpandedId {
        #[prost(string, repeated, tag = "1")]
        pub pattern: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
    }
    #[derive(Clone, Copy, PartialEq, ::prost::Message)]
    pub struct WorkspaceConfigId {}
    #[derive(Clone, Copy, PartialEq, ::prost::Message)]
    pub struct BuildMetadataId {}
    /// Identifier of an event indicating that a target has been expanded by
    /// identifying for which configurations it should be build.
    #[derive(Clone, PartialEq, ::prost::Message)]
    pub struct TargetConfiguredId {
        #[prost(string, tag = "1")]
        pub label: ::prost::alloc::string::String,
        /// If empty, the id refers to the expansion of the target. If not-empty,
        /// the id refers to the expansion of an aspect applied to the (already
        /// expanded) target.
        ///
        /// For example, when building an apple_binary that depends on proto_library
        /// "//:foo_proto", there will be two TargetConfigured events for
        /// "//:foo_proto":
        ///
        /// 1. An event with an empty aspect, corresponding to actions producing
        /// language-agnostic outputs from the proto_library; and
        /// 2. An event with aspect "ObjcProtoAspect", corresponding to Objective-C
        /// code generation.
        #[prost(string, tag = "2")]
        pub aspect: ::prost::alloc::string::String,
    }
    /// Identifier of an event introducing a named set of files (usually artifacts)
    /// to be referred to in later messages.
    #[derive(Clone, PartialEq, ::prost::Message)]
    pub struct NamedSetOfFilesId {
        /// Identifier of the file set; this is an opaque string valid only for the
        /// particular instance of the event stream.
        #[prost(string, tag = "1")]
        pub id: ::prost::alloc::string::String,
    }
    /// Identifier of an event introducing a configuration.
    #[derive(Clone, PartialEq, ::prost::Message)]
    pub struct ConfigurationId {
        /// Identifier of the configuration; users of the protocol should not make
        /// any assumptions about it having any structure, or equality of the
        /// identifier between different streams.
        ///
        /// A value of "none" means the null configuration. It is used for targets
        /// that are not configurable, for example, source files.
        #[prost(string, tag = "1")]
        pub id: ::prost::alloc::string::String,
    }
    /// Identifier of an event indicating that a target was built completely; this
    /// does not include running the test if the target is a test target.
    #[derive(Clone, PartialEq, ::prost::Message)]
    pub struct TargetCompletedId {
        #[prost(string, tag = "1")]
        pub label: ::prost::alloc::string::String,
        /// The configuration for which the target was built.
        #[prost(message, optional, tag = "3")]
        pub configuration: ::core::option::Option<ConfigurationId>,
        /// If empty, the id refers to the completion of the target. If not-empty,
        /// the id refers to the completion of an aspect applied to the (already
        /// completed) target.
        ///
        /// For example, when building an apple_binary that depends on proto_library
        /// "//:foo_proto", there will be two TargetCompleted events for
        /// "//:foo_proto":
        ///
        /// 1. An event with an empty aspect, corresponding to actions producing
        /// language-agnostic outputs from the proto_library; and
        /// 2. An event with aspect "ObjcProtoAspect", corresponding to Objective-C
        /// code generation.
        #[prost(string, tag = "2")]
        pub aspect: ::prost::alloc::string::String,
    }
    /// Identifier of an event reporting that an action was completed (not all
    /// actions are reported, only the ones that can be considered important;
    /// this includes all failed actions).
    #[derive(Clone, PartialEq, ::prost::Message)]
    pub struct ActionCompletedId {
        #[prost(string, tag = "1")]
        pub primary_output: ::prost::alloc::string::String,
        /// Optional, the label of the owner of the action, for reference.
        #[prost(string, tag = "2")]
        pub label: ::prost::alloc::string::String,
        /// Optional, the id of the configuration of the action owner.
        #[prost(message, optional, tag = "3")]
        pub configuration: ::core::option::Option<ConfigurationId>,
    }
    /// Identifier of an event reporting an event associated with an unconfigured
    /// label. Usually, this indicates a failure due to a missing input file. In
    /// any case, it will report some form of error (i.e., the payload will be an
    /// Aborted event); there are no regular events using this identifier. The
    /// purpose of those events is to serve as the root cause of a failed target.
    #[derive(Clone, PartialEq, ::prost::Message)]
    pub struct UnconfiguredLabelId {
        #[prost(string, tag = "1")]
        pub label: ::prost::alloc::string::String,
    }
    /// Identifier of an event reporting an event associated with a configured
    /// label, usually a visibility error. In any case, an event with such an
    /// id will always report some form of error (i.e., the payload will be an
    /// Aborted event); there are no regular events using this identifier.
    #[derive(Clone, PartialEq, ::prost::Message)]
    pub struct ConfiguredLabelId {
        #[prost(string, tag = "1")]
        pub label: ::prost::alloc::string::String,
        #[prost(message, optional, tag = "2")]
        pub configuration: ::core::option::Option<ConfigurationId>,
    }
    /// Identifier of an event reporting on an individual test run. The label
    /// identifies the test that is reported about, the remaining fields are
    /// in such a way as to uniquely identify the action within a build. In fact,
    /// attempts for the same test, run, shard triple are counted sequentially,
    /// starting with 1.
    #[derive(Clone, PartialEq, ::prost::Message)]
    pub struct TestResultId {
        #[prost(string, tag = "1")]
        pub label: ::prost::alloc::string::String,
        #[prost(message, optional, tag = "5")]
        pub configuration: ::core::option::Option<ConfigurationId>,
        #[prost(int32, tag = "2")]
        pub run: i32,
        #[prost(int32, tag = "3")]
        pub shard: i32,
        #[prost(int32, tag = "4")]
        pub attempt: i32,
    }
    /// Identifier of an event reporting progress of an individual test run.
    #[derive(Clone, PartialEq, ::prost::Message)]
    pub struct TestProgressId {
        /// The label of the target for the action.
        #[prost(string, tag = "1")]
        pub label: ::prost::alloc::string::String,
        /// The configuration under which the action is running.
        #[prost(message, optional, tag = "2")]
        pub configuration: ::core::option::Option<ConfigurationId>,
        /// The run number of the test action (e.g. for runs_per_test > 1).
        #[prost(int32, tag = "3")]
        pub run: i32,
        /// For sharded tests, the shard number of the test action.
        #[prost(int32, tag = "4")]
        pub shard: i32,
        /// The execution attempt number which may increase due to retries (e.g. for
        /// flaky tests).
        #[prost(int32, tag = "5")]
        pub attempt: i32,
        /// An incrementing count used to differentiate TestProgressIds for the same
        /// test attempt.
        #[prost(int32, tag = "6")]
        pub opaque_count: i32,
    }
    /// Identifier of an event reporting the summary of a test.
    #[derive(Clone, PartialEq, ::prost::Message)]
    pub struct TestSummaryId {
        #[prost(string, tag = "1")]
        pub label: ::prost::alloc::string::String,
        #[prost(message, optional, tag = "2")]
        pub configuration: ::core::option::Option<ConfigurationId>,
    }
    /// Identifier of an event reporting the summary of a target.
    #[derive(Clone, PartialEq, ::prost::Message)]
    pub struct TargetSummaryId {
        #[prost(string, tag = "1")]
        pub label: ::prost::alloc::string::String,
        #[prost(message, optional, tag = "2")]
        pub configuration: ::core::option::Option<ConfigurationId>,
    }
    /// Identifier of the BuildFinished event, indicating the end of a build.
    #[derive(Clone, Copy, PartialEq, ::prost::Message)]
    pub struct BuildFinishedId {}
    /// Identifier of an event providing additional logs/statistics after
    /// completion of the build.
    #[derive(Clone, Copy, PartialEq, ::prost::Message)]
    pub struct BuildToolLogsId {}
    /// Identifier of an event providing build metrics after completion
    /// of the build.
    #[derive(Clone, Copy, PartialEq, ::prost::Message)]
    pub struct BuildMetricsId {}
    /// Identifier of an event providing convenience symlinks information.
    #[derive(Clone, Copy, PartialEq, ::prost::Message)]
    pub struct ConvenienceSymlinksIdentifiedId {}
    /// Identifier of an event providing the ExecRequest of a run command.
    #[derive(Clone, Copy, PartialEq, ::prost::Message)]
    pub struct ExecRequestId {}
    #[derive(Clone, PartialEq, ::prost::Oneof)]
    pub enum Id {
        #[prost(message, tag = "1")]
        Unknown(UnknownBuildEventId),
        #[prost(message, tag = "2")]
        Progress(ProgressId),
        #[prost(message, tag = "3")]
        Started(BuildStartedId),
        #[prost(message, tag = "11")]
        UnstructuredCommandLine(UnstructuredCommandLineId),
        #[prost(message, tag = "18")]
        StructuredCommandLine(StructuredCommandLineId),
        #[prost(message, tag = "14")]
        WorkspaceStatus(WorkspaceStatusId),
        #[prost(message, tag = "12")]
        OptionsParsed(OptionsParsedId),
        #[prost(message, tag = "17")]
        Fetch(FetchId),
        #[prost(message, tag = "15")]
        Configuration(ConfigurationId),
        #[prost(message, tag = "16")]
        TargetConfigured(TargetConfiguredId),
        #[prost(message, tag = "4")]
        Pattern(PatternExpandedId),
        #[prost(message, tag = "10")]
        PatternSkipped(PatternExpandedId),
        #[prost(message, tag = "13")]
        NamedSet(NamedSetOfFilesId),
        #[prost(message, tag = "5")]
        TargetCompleted(TargetCompletedId),
        #[prost(message, tag = "6")]
        ActionCompleted(ActionCompletedId),
        #[prost(message, tag = "19")]
        UnconfiguredLabel(UnconfiguredLabelId),
        #[prost(message, tag = "21")]
        ConfiguredLabel(ConfiguredLabelId),
        #[prost(message, tag = "8")]
        TestResult(TestResultId),
        #[prost(message, tag = "29")]
        TestProgress(TestProgressId),
        #[prost(message, tag = "7")]
        TestSummary(TestSummaryId),
        #[prost(message, tag = "26")]
        TargetSummary(TargetSummaryId),
        #[prost(message, tag = "9")]
        BuildFinished(BuildFinishedId),
        #[prost(message, tag = "20")]
        BuildToolLogs(BuildToolLogsId),
        #[prost(message, tag = "22")]
        BuildMetrics(BuildMetricsId),
        #[prost(message, tag = "23")]
        Workspace(WorkspaceConfigId),
        #[prost(message, tag = "24")]
        BuildMetadata(BuildMetadataId),
        #[prost(message, tag = "25")]
        ConvenienceSymlinksIdentified(ConvenienceSymlinksIdentifiedId),
        #[prost(message, tag = "28")]
        ExecRequest(ExecRequestId),
    }
}
/// Payload of an event summarizing the progress of the build so far. Those
/// events are also used to be parents of events where the more logical parent
/// event cannot be posted yet as the needed information is not yet complete.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct Progress {
    /// The next chunk of stdout that bazel produced since the last progress event
    /// or the beginning of the build.
    /// Consumers that need to reason about the relative order of stdout and stderr
    /// can assume that stderr has been emitted before stdout if both are present,
    /// on a best-effort basis.
    #[prost(string, tag = "1")]
    pub stdout: ::prost::alloc::string::String,
    /// The next chunk of stderr that bazel produced since the last progress event
    /// or the beginning of the build.
    /// Consumers that need to reason about the relative order of stdout and stderr
    /// can assume that stderr has been emitted before stdout if both are present,
    /// on a best-effort basis.
    #[prost(string, tag = "2")]
    pub stderr: ::prost::alloc::string::String,
}
/// Payload of an event indicating that an expected event will not come, as
/// the build is aborted prematurely for some reason.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct Aborted {
    #[prost(enumeration = "aborted::AbortReason", tag = "1")]
    pub reason: i32,
    /// A human readable description with more details about there reason, where
    /// available and useful.
    #[prost(string, tag = "2")]
    pub description: ::prost::alloc::string::String,
}
/// Nested message and enum types in `Aborted`.
pub mod aborted {
    #[derive(
        Clone,
        Copy,
        Debug,
        PartialEq,
        Eq,
        Hash,
        PartialOrd,
        Ord,
        ::prost::Enumeration
    )]
    #[repr(i32)]
    pub enum AbortReason {
        Unknown = 0,
        /// The user requested the build to be aborted (e.g., by hitting Ctl-C).
        UserInterrupted = 1,
        /// The user requested that no analysis be performed.
        NoAnalyze = 8,
        /// The user requested that no build be carried out.
        NoBuild = 9,
        /// The build or target was aborted as a timeout was exceeded.
        TimeOut = 2,
        /// The build or target was aborted as some remote environment (e.g., for
        /// remote execution of actions) was not available in the expected way.
        RemoteEnvironmentFailure = 3,
        /// Failure due to reasons entirely internal to the build tool, i.e. an
        /// unexpected crash due to programmer error.
        Internal = 4,
        /// A Failure occurred in the loading phase of a target.
        LoadingFailure = 5,
        /// A Failure occurred in the analysis phase of a target.
        AnalysisFailure = 6,
        /// Target build was skipped (e.g. due to incompatible CPU constraints).
        Skipped = 7,
        /// Build incomplete due to an earlier build failure (e.g. --keep_going was
        /// set to false causing the build be ended upon failure).
        Incomplete = 10,
        /// The build tool ran out of memory and crashed.
        OutOfMemory = 11,
    }
    impl AbortReason {
        /// String value of the enum field names used in the ProtoBuf definition.
        ///
        /// The values are not transformed in any way and thus are considered stable
        /// (if the ProtoBuf definition does not change) and safe for programmatic use.
        pub fn as_str_name(&self) -> &'static str {
            match self {
                Self::Unknown => "UNKNOWN",
                Self::UserInterrupted => "USER_INTERRUPTED",
                Self::NoAnalyze => "NO_ANALYZE",
                Self::NoBuild => "NO_BUILD",
                Self::TimeOut => "TIME_OUT",
                Self::RemoteEnvironmentFailure => "REMOTE_ENVIRONMENT_FAILURE",
                Self::Internal => "INTERNAL",
                Self::LoadingFailure => "LOADING_FAILURE",
                Self::AnalysisFailure => "ANALYSIS_FAILURE",
                Self::Skipped => "SKIPPED",
                Self::Incomplete => "INCOMPLETE",
                Self::OutOfMemory => "OUT_OF_MEMORY",
            }
        }
        /// Creates an enum from field names used in the ProtoBuf definition.
        pub fn from_str_name(value: &str) -> ::core::option::Option<Self> {
            match value {
                "UNKNOWN" => Some(Self::Unknown),
                "USER_INTERRUPTED" => Some(Self::UserInterrupted),
                "NO_ANALYZE" => Some(Self::NoAnalyze),
                "NO_BUILD" => Some(Self::NoBuild),
                "TIME_OUT" => Some(Self::TimeOut),
                "REMOTE_ENVIRONMENT_FAILURE" => Some(Self::RemoteEnvironmentFailure),
                "INTERNAL" => Some(Self::Internal),
                "LOADING_FAILURE" => Some(Self::LoadingFailure),
                "ANALYSIS_FAILURE" => Some(Self::AnalysisFailure),
                "SKIPPED" => Some(Self::Skipped),
                "INCOMPLETE" => Some(Self::Incomplete),
                "OUT_OF_MEMORY" => Some(Self::OutOfMemory),
                _ => None,
            }
        }
    }
}
/// Payload of an event indicating the beginning of a new build. Usually, events
/// of those type start a new build-event stream. The target pattern requested
/// to be build is contained in one of the announced child events; it is an
/// invariant that precisely one of the announced child events has a non-empty
/// target pattern.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct BuildStarted {
    #[prost(string, tag = "1")]
    pub uuid: ::prost::alloc::string::String,
    /// Start of the build in ms since the epoch.
    ///
    /// Deprecated, use `start_time` instead.
    ///
    /// TODO(yannic): Remove.
    #[deprecated]
    #[prost(int64, tag = "2")]
    pub start_time_millis: i64,
    /// Start of the build.
    #[prost(message, optional, tag = "9")]
    pub start_time: ::core::option::Option<::prost_types::Timestamp>,
    /// Version of the build tool that is running.
    #[prost(string, tag = "3")]
    pub build_tool_version: ::prost::alloc::string::String,
    /// A human-readable description of all the non-default option settings
    #[prost(string, tag = "4")]
    pub options_description: ::prost::alloc::string::String,
    /// The name of the command that the user invoked.
    #[prost(string, tag = "5")]
    pub command: ::prost::alloc::string::String,
    /// The working directory from which the build tool was invoked.
    #[prost(string, tag = "6")]
    pub working_directory: ::prost::alloc::string::String,
    /// The directory of the workspace.
    #[prost(string, tag = "7")]
    pub workspace_directory: ::prost::alloc::string::String,
    /// The process ID of the Bazel server.
    #[prost(int64, tag = "8")]
    pub server_pid: i64,
}
/// Configuration related to the blaze workspace and output tree.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct WorkspaceConfig {
    /// The root of the local blaze exec root. All output files live underneath
    /// this at "blaze-out/".
    #[prost(string, tag = "1")]
    pub local_exec_root: ::prost::alloc::string::String,
}
/// Payload of an event reporting the command-line of the invocation as
/// originally received by the server. Note that this is not the command-line
/// given by the user, as the client adds information about the invocation,
/// like name and relevant entries of rc-files and client environment variables.
/// However, it does contain enough information to reproduce the build
/// invocation.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct UnstructuredCommandLine {
    #[prost(string, repeated, tag = "1")]
    pub args: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
}
/// Payload of an event reporting on the parsed options, grouped in various ways.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct OptionsParsed {
    #[prost(string, repeated, tag = "1")]
    pub startup_options: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
    #[prost(string, repeated, tag = "2")]
    pub explicit_startup_options: ::prost::alloc::vec::Vec<
        ::prost::alloc::string::String,
    >,
    #[prost(string, repeated, tag = "3")]
    pub cmd_line: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
    #[prost(string, repeated, tag = "4")]
    pub explicit_cmd_line: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
    #[prost(message, optional, tag = "5")]
    pub invocation_policy: ::core::option::Option<
        super::blaze::invocation_policy::InvocationPolicy,
    >,
    #[prost(string, tag = "6")]
    pub tool_tag: ::prost::alloc::string::String,
}
/// Payload of an event indicating that an external resource was fetched. This
/// event will only occur in streams where an actual fetch happened, not in ones
/// where a cached copy of the entity to be fetched was used.
#[derive(Clone, Copy, PartialEq, ::prost::Message)]
pub struct Fetch {
    #[prost(bool, tag = "1")]
    pub success: bool,
}
/// Payload of an event reporting the workspace status. Key-value pairs can be
/// provided by specifying the workspace_status_command to an executable that
/// returns one key-value pair per line of output (key and value separated by a
/// space).
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct WorkspaceStatus {
    #[prost(message, repeated, tag = "1")]
    pub item: ::prost::alloc::vec::Vec<workspace_status::Item>,
}
/// Nested message and enum types in `WorkspaceStatus`.
pub mod workspace_status {
    #[derive(Clone, PartialEq, ::prost::Message)]
    pub struct Item {
        #[prost(string, tag = "1")]
        pub key: ::prost::alloc::string::String,
        #[prost(string, tag = "2")]
        pub value: ::prost::alloc::string::String,
    }
}
/// Payload of an event reporting custom key-value metadata associated with the
/// build.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct BuildMetadata {
    /// Custom metadata for the build.
    #[prost(map = "string, string", tag = "1")]
    pub metadata: ::std::collections::HashMap<
        ::prost::alloc::string::String,
        ::prost::alloc::string::String,
    >,
}
/// Payload of an event reporting details of a given configuration.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct Configuration {
    #[prost(string, tag = "1")]
    pub mnemonic: ::prost::alloc::string::String,
    #[prost(string, tag = "2")]
    pub platform_name: ::prost::alloc::string::String,
    #[prost(string, tag = "3")]
    pub cpu: ::prost::alloc::string::String,
    #[prost(map = "string, string", tag = "4")]
    pub make_variable: ::std::collections::HashMap<
        ::prost::alloc::string::String,
        ::prost::alloc::string::String,
    >,
    /// Whether this configuration is used for building tools.
    #[prost(bool, tag = "5")]
    pub is_tool: bool,
}
/// Payload of the event indicating the expansion of a target pattern.
/// The main information is in the chaining part: the id will contain the
/// target pattern that was expanded and the children id will contain the
/// target or target pattern it was expanded to.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct PatternExpanded {
    /// All test suites requested via top-level target patterns. Does not include
    /// test suites whose label matched a negative pattern.
    #[prost(message, repeated, tag = "1")]
    pub test_suite_expansions: ::prost::alloc::vec::Vec<
        pattern_expanded::TestSuiteExpansion,
    >,
}
/// Nested message and enum types in `PatternExpanded`.
pub mod pattern_expanded {
    /// Represents a test_suite target and the tests that it expanded to. Nested
    /// test suites are recursively expanded. The test labels only contain the
    /// final test targets, not any nested suites.
    #[derive(Clone, PartialEq, ::prost::Message)]
    pub struct TestSuiteExpansion {
        /// The label of the test_suite rule.
        #[prost(string, tag = "1")]
        pub suite_label: ::prost::alloc::string::String,
        /// Labels of the test targets included in the suite. Includes all tests in
        /// the suite regardless of any filters or negative patterns which may result
        /// in the test not actually being run.
        #[prost(string, repeated, tag = "2")]
        pub test_labels: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
    }
}
/// Payload of the event indicating that the configurations for a target have
/// been identified. As with pattern expansion the main information is in the
/// chaining part: the id will contain the target that was configured and the
/// children id will contain the configured targets it was configured to.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct TargetConfigured {
    /// The kind of target (e.g.,  e.g. "cc_library rule", "source file",
    /// "generated file") where the completion is reported.
    #[prost(string, tag = "1")]
    pub target_kind: ::prost::alloc::string::String,
    /// The size of the test, if the target is a test target. Unset otherwise.
    #[prost(enumeration = "TestSize", tag = "2")]
    pub test_size: i32,
    /// List of all tags associated with this target (for all possible
    /// configurations).
    #[prost(string, repeated, tag = "3")]
    pub tag: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct File {
    /// A sequence of prefixes to apply to the file name to construct a full path.
    /// In most but not all cases, there will be 3 entries:
    ///   1. A root output directory, eg "bazel-out"
    ///   2. A configuration mnemonic, eg "k8-fastbuild"
    ///   3. An output category, eg "genfiles"
    #[prost(string, repeated, tag = "4")]
    pub path_prefix: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
    /// identifier indicating the nature of the file (e.g., "stdout", "stderr")
    #[prost(string, tag = "1")]
    pub name: ::prost::alloc::string::String,
    /// Digest of the file, using the build tool's configured digest algorithm,
    /// hex-encoded.
    #[prost(string, tag = "5")]
    pub digest: ::prost::alloc::string::String,
    /// Length of the file in bytes.
    #[prost(int64, tag = "6")]
    pub length: i64,
    #[prost(oneof = "file::File", tags = "2, 3, 7")]
    pub file: ::core::option::Option<file::File>,
}
/// Nested message and enum types in `File`.
pub mod file {
    #[derive(Clone, PartialEq, ::prost::Oneof)]
    pub enum File {
        /// A location where the contents of the file can be found. The string is
        /// encoded according to RFC2396.
        #[prost(string, tag = "2")]
        Uri(::prost::alloc::string::String),
        /// The contents of the file, if they are guaranteed to be short.
        #[prost(bytes, tag = "3")]
        Contents(::prost::bytes::Bytes),
        /// The symlink target path, if the file is an unresolved symlink.
        #[prost(string, tag = "7")]
        SymlinkTargetPath(::prost::alloc::string::String),
    }
}
/// Payload of a message to describe a set of files, usually build artifacts, to
/// be referred to later by their name. In this way, files that occur identically
/// as outputs of several targets have to be named only once.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct NamedSetOfFiles {
    /// Files that belong to this named set of files.
    #[prost(message, repeated, tag = "1")]
    pub files: ::prost::alloc::vec::Vec<File>,
    /// Other named sets whose members also belong to this set.
    #[prost(message, repeated, tag = "2")]
    pub file_sets: ::prost::alloc::vec::Vec<build_event_id::NamedSetOfFilesId>,
}
/// Payload of the event indicating the completion of an action. The main purpose
/// of posting those events is to provide details on the root cause for a target
/// failing; however, consumers of the build-event protocol must not assume
/// that only failed actions are posted.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ActionExecuted {
    #[prost(bool, tag = "1")]
    pub success: bool,
    /// The mnemonic of the action that was executed
    #[prost(string, tag = "8")]
    pub r#type: ::prost::alloc::string::String,
    /// The exit code of the action, if it is available.
    #[prost(int32, tag = "2")]
    pub exit_code: i32,
    /// Location where to find the standard output of the action
    /// (e.g., a file path).
    #[prost(message, optional, tag = "3")]
    pub stdout: ::core::option::Option<File>,
    /// Location where to find the standard error of the action
    /// (e.g., a file path).
    #[prost(message, optional, tag = "4")]
    pub stderr: ::core::option::Option<File>,
    /// Deprecated. This field is now present on ActionCompletedId.
    #[deprecated]
    #[prost(string, tag = "5")]
    pub label: ::prost::alloc::string::String,
    /// Deprecated. This field is now present on ActionCompletedId.
    #[deprecated]
    #[prost(message, optional, tag = "7")]
    pub configuration: ::core::option::Option<build_event_id::ConfigurationId>,
    /// Primary output; only provided for successful actions.
    #[prost(message, optional, tag = "6")]
    pub primary_output: ::core::option::Option<File>,
    /// The command-line of the action, if the action is a command.
    #[prost(string, repeated, tag = "9")]
    pub command_line: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
    /// List of paths to log files
    #[prost(message, repeated, tag = "10")]
    pub action_metadata_logs: ::prost::alloc::vec::Vec<File>,
    /// Only populated if success = false, and sometimes not even then.
    #[prost(message, optional, tag = "11")]
    pub failure_detail: ::core::option::Option<super::failure_details::FailureDetail>,
    /// Start of action execution, before any attempted execution begins.
    #[prost(message, optional, tag = "12")]
    pub start_time: ::core::option::Option<::prost_types::Timestamp>,
    /// End of action execution, after all attempted execution completes.
    #[prost(message, optional, tag = "13")]
    pub end_time: ::core::option::Option<::prost_types::Timestamp>,
    /// Additional details about action execution supplied by strategies. Bazel
    /// options will determine which strategy details are included when multiple
    /// strategies are involved in a single action's execution.
    ///
    /// The default type will be `tools.proto.SpawnExec` found in `spawn.proto`.
    #[prost(message, repeated, tag = "14")]
    pub strategy_details: ::prost::alloc::vec::Vec<::prost_types::Any>,
}
/// Collection of all output files belonging to that output group.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct OutputGroup {
    /// Name of the output group
    #[prost(string, tag = "1")]
    pub name: ::prost::alloc::string::String,
    /// List of file sets that belong to this output group as well.
    #[prost(message, repeated, tag = "3")]
    pub file_sets: ::prost::alloc::vec::Vec<build_event_id::NamedSetOfFilesId>,
    /// Indicates that one or more of the output group's files were not built
    /// successfully (the generating action failed).
    #[prost(bool, tag = "4")]
    pub incomplete: bool,
    /// Inlined files that belong to this output group, requested via
    /// --build_event_inline_output_groups.
    #[prost(message, repeated, tag = "5")]
    pub inline_files: ::prost::alloc::vec::Vec<File>,
}
/// Payload of the event indicating the completion of a target. The target is
/// specified in the id. If the target failed the root causes are provided as
/// children events.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct TargetComplete {
    #[prost(bool, tag = "1")]
    pub success: bool,
    /// The kind of target (e.g.,  e.g. "cc_library rule", "source file",
    /// "generated file") where the completion is reported.
    /// Deprecated: use the target_kind field in TargetConfigured instead.
    #[deprecated]
    #[prost(string, tag = "5")]
    pub target_kind: ::prost::alloc::string::String,
    /// The size of the test, if the target is a test target. Unset otherwise.
    /// Deprecated: use the test_size field in TargetConfigured instead.
    #[deprecated]
    #[prost(enumeration = "TestSize", tag = "6")]
    pub test_size: i32,
    /// The output files are arranged by their output group. If an output file
    /// is part of multiple output groups, it appears once in each output
    /// group.
    #[prost(message, repeated, tag = "2")]
    pub output_group: ::prost::alloc::vec::Vec<OutputGroup>,
    /// Temporarily, also report the important outputs directly. This is only to
    /// allow existing clients help transition to the deduplicated representation;
    /// new clients should not use it.
    #[deprecated]
    #[prost(message, repeated, tag = "4")]
    pub important_output: ::prost::alloc::vec::Vec<File>,
    /// Report output artifacts (referenced transitively via output_group) which
    /// emit directories instead of singleton files. These directory_output entries
    /// will never include a uri.
    #[prost(message, repeated, tag = "8")]
    pub directory_output: ::prost::alloc::vec::Vec<File>,
    /// List of tags associated with this configured target.
    #[prost(string, repeated, tag = "3")]
    pub tag: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
    /// The timeout specified for test actions under this configured target.
    ///
    /// Deprecated, use `test_timeout` instead.
    ///
    /// TODO(yannic): Remove.
    #[deprecated]
    #[prost(int64, tag = "7")]
    pub test_timeout_seconds: i64,
    /// The timeout specified for test actions under this configured target.
    #[prost(message, optional, tag = "10")]
    pub test_timeout: ::core::option::Option<::prost_types::Duration>,
    /// Failure information about the target, only populated if success is false,
    /// and sometimes not even then. Equal to one of the ActionExecuted
    /// failure_detail fields for one of the root cause ActionExecuted events.
    #[prost(message, optional, tag = "9")]
    pub failure_detail: ::core::option::Option<super::failure_details::FailureDetail>,
}
/// Payload on events reporting about individual test action.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct TestResult {
    /// The status of this test.
    #[prost(enumeration = "TestStatus", tag = "5")]
    pub status: i32,
    /// Additional details about the status of the test. This is intended for
    /// user display and must not be parsed.
    #[prost(string, tag = "9")]
    pub status_details: ::prost::alloc::string::String,
    /// True, if the reported attempt is taken from the tool's local cache.
    #[prost(bool, tag = "4")]
    pub cached_locally: bool,
    /// Time in milliseconds since the epoch at which the test attempt was started.
    /// Note: for cached test results, this is time can be before the start of the
    /// build.
    ///
    /// Deprecated, use `test_attempt_start` instead.
    ///
    /// TODO(yannic): Remove.
    #[deprecated]
    #[prost(int64, tag = "6")]
    pub test_attempt_start_millis_epoch: i64,
    /// Time at which the test attempt was started.
    /// Note: for cached test results, this is time can be before the start of the
    /// build.
    #[prost(message, optional, tag = "10")]
    pub test_attempt_start: ::core::option::Option<::prost_types::Timestamp>,
    /// Time the test took to run. For locally cached results, this is the time
    /// the cached invocation took when it was invoked.
    ///
    /// Deprecated, use `test_attempt_duration` instead.
    ///
    /// TODO(yannic): Remove.
    #[deprecated]
    #[prost(int64, tag = "3")]
    pub test_attempt_duration_millis: i64,
    /// Time the test took to run. For locally cached results, this is the time
    /// the cached invocation took when it was invoked.
    #[prost(message, optional, tag = "11")]
    pub test_attempt_duration: ::core::option::Option<::prost_types::Duration>,
    /// Files (logs, test.xml, undeclared outputs, etc) generated by that test
    /// action.
    #[prost(message, repeated, tag = "2")]
    pub test_action_output: ::prost::alloc::vec::Vec<File>,
    /// Warnings generated by that test action.
    #[prost(string, repeated, tag = "7")]
    pub warning: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
    #[prost(message, optional, tag = "8")]
    pub execution_info: ::core::option::Option<test_result::ExecutionInfo>,
}
/// Nested message and enum types in `TestResult`.
pub mod test_result {
    /// Message providing optional meta data on the execution of the test action,
    /// if available.
    #[derive(Clone, PartialEq, ::prost::Message)]
    pub struct ExecutionInfo {
        /// Deprecated, use TargetComplete.test_timeout instead.
        #[deprecated]
        #[prost(int32, tag = "1")]
        pub timeout_seconds: i32,
        /// Name of the strategy to execute this test action (e.g., "local",
        /// "remote")
        #[prost(string, tag = "2")]
        pub strategy: ::prost::alloc::string::String,
        /// True, if the reported attempt was a cache hit in a remote cache.
        #[prost(bool, tag = "6")]
        pub cached_remotely: bool,
        /// The exit code of the test action.
        #[prost(int32, tag = "7")]
        pub exit_code: i32,
        /// The hostname of the machine where the test action was executed (in case
        /// of remote execution), if known.
        #[prost(string, tag = "3")]
        pub hostname: ::prost::alloc::string::String,
        #[prost(message, optional, tag = "4")]
        pub timing_breakdown: ::core::option::Option<execution_info::TimingBreakdown>,
        #[prost(message, repeated, tag = "5")]
        pub resource_usage: ::prost::alloc::vec::Vec<execution_info::ResourceUsage>,
    }
    /// Nested message and enum types in `ExecutionInfo`.
    pub mod execution_info {
        /// Represents a hierarchical timing breakdown of an activity.
        /// The top level time should be the total time of the activity.
        /// Invariant: `time` >= sum of `time`s of all direct children.
        #[derive(Clone, PartialEq, ::prost::Message)]
        pub struct TimingBreakdown {
            #[prost(message, repeated, tag = "1")]
            pub child: ::prost::alloc::vec::Vec<TimingBreakdown>,
            #[prost(string, tag = "2")]
            pub name: ::prost::alloc::string::String,
            /// Deprecated, use `time` instead.
            ///
            /// TODO(yannic): Remove.
            #[deprecated]
            #[prost(int64, tag = "3")]
            pub time_millis: i64,
            #[prost(message, optional, tag = "4")]
            pub time: ::core::option::Option<::prost_types::Duration>,
        }
        #[derive(Clone, PartialEq, ::prost::Message)]
        pub struct ResourceUsage {
            #[prost(string, tag = "1")]
            pub name: ::prost::alloc::string::String,
            #[prost(int64, tag = "2")]
            pub value: i64,
        }
    }
}
/// Event payload providing information about an active, individual test run.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct TestProgress {
    /// Identifies a resource that may provide information about an active test
    /// run. The resource is not necessarily a file and may need to be queried
    /// for information. The URI is not guaranteed to be available after the test
    /// completes. The string is encoded according to RFC2396.
    #[prost(string, tag = "1")]
    pub uri: ::prost::alloc::string::String,
}
/// Payload of the event summarizing a test.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct TestSummary {
    /// Wrapper around BlazeTestStatus to support importing that enum to proto3.
    /// Overall status of test, accumulated over all runs, shards, and attempts.
    #[prost(enumeration = "TestStatus", tag = "5")]
    pub overall_status: i32,
    /// Total number of shard attempts.
    /// E.g., if a target has 4 runs, 3 shards, each with 2 attempts,
    /// then total_run_count will be 4*3*2 = 24.
    #[prost(int32, tag = "1")]
    pub total_run_count: i32,
    /// Value of runs_per_test for the test.
    #[prost(int32, tag = "10")]
    pub run_count: i32,
    /// Number of attempts.
    /// If there are a different number of attempts per shard, the highest attempt
    /// count across all shards for each run is used.
    #[prost(int32, tag = "15")]
    pub attempt_count: i32,
    /// Number of shards.
    #[prost(int32, tag = "11")]
    pub shard_count: i32,
    /// Path to logs of passed runs.
    #[prost(message, repeated, tag = "3")]
    pub passed: ::prost::alloc::vec::Vec<File>,
    /// Path to logs of failed runs;
    #[prost(message, repeated, tag = "4")]
    pub failed: ::prost::alloc::vec::Vec<File>,
    /// Total number of cached test actions
    #[prost(int32, tag = "6")]
    pub total_num_cached: i32,
    /// When the test first started running.
    ///
    /// Deprecated, use `first_start_time` instead.
    ///
    /// TODO(yannic): Remove.
    #[deprecated]
    #[prost(int64, tag = "7")]
    pub first_start_time_millis: i64,
    /// When the test first started running.
    #[prost(message, optional, tag = "13")]
    pub first_start_time: ::core::option::Option<::prost_types::Timestamp>,
    /// When the last test action completed.
    ///
    /// Deprecated, use `last_stop_time` instead.
    ///
    /// TODO(yannic): Remove.
    #[deprecated]
    #[prost(int64, tag = "8")]
    pub last_stop_time_millis: i64,
    /// When the test first started running.
    #[prost(message, optional, tag = "14")]
    pub last_stop_time: ::core::option::Option<::prost_types::Timestamp>,
    /// The total runtime of the test.
    ///
    /// Deprecated, use `total_run` instead.
    ///
    /// TODO(yannic): Remove.
    #[deprecated]
    #[prost(int64, tag = "9")]
    pub total_run_duration_millis: i64,
    /// The total runtime of the test.
    #[prost(message, optional, tag = "12")]
    pub total_run_duration: ::core::option::Option<::prost_types::Duration>,
}
/// Payload of the event summarizing a target (test or non-test).
#[derive(Clone, Copy, PartialEq, ::prost::Message)]
pub struct TargetSummary {
    /// Conjunction of TargetComplete events for this target, including aspects.
    #[prost(bool, tag = "1")]
    pub overall_build_success: bool,
    /// Repeats TestSummary's overall_status if available.
    #[prost(enumeration = "TestStatus", tag = "2")]
    pub overall_test_status: i32,
}
/// Event indicating the end of a build.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct BuildFinished {
    /// If the build succeeded or failed.
    #[deprecated]
    #[prost(bool, tag = "1")]
    pub overall_success: bool,
    /// The overall status of the build. A build was successful iff
    /// ExitCode.code equals 0.
    #[prost(message, optional, tag = "3")]
    pub exit_code: ::core::option::Option<build_finished::ExitCode>,
    /// End of the build in ms since the epoch.
    ///
    /// Deprecated, use `finish_time` instead.
    ///
    /// TODO(yannic): Remove.
    #[deprecated]
    #[prost(int64, tag = "2")]
    pub finish_time_millis: i64,
    /// End of the build.
    #[prost(message, optional, tag = "5")]
    pub finish_time: ::core::option::Option<::prost_types::Timestamp>,
    #[deprecated]
    #[prost(message, optional, tag = "4")]
    pub anomaly_report: ::core::option::Option<build_finished::AnomalyReport>,
    /// Only populated if success = false, and sometimes not even then.
    #[prost(message, optional, tag = "6")]
    pub failure_detail: ::core::option::Option<super::failure_details::FailureDetail>,
}
/// Nested message and enum types in `BuildFinished`.
pub mod build_finished {
    /// Exit code of a build. The possible values correspond to the predefined
    /// codes in bazel's lib.ExitCode class, as well as any custom exit code a
    /// module might define. The predefined exit codes are subject to change (but
    /// rarely do) and are not part of the public API.
    ///
    /// A build was successful iff ExitCode.code equals 0.
    #[derive(Clone, PartialEq, ::prost::Message)]
    pub struct ExitCode {
        /// The name of the exit code.
        #[prost(string, tag = "1")]
        pub name: ::prost::alloc::string::String,
        /// The exit code.
        #[prost(int32, tag = "2")]
        pub code: i32,
    }
    /// Things that happened during the build that could be of interest.
    #[derive(Clone, Copy, PartialEq, ::prost::Message)]
    pub struct AnomalyReport {
        /// Was the build suspended at any time during the build.
        /// Examples of suspensions are SIGSTOP, or the hardware being put to sleep.
        /// If was_suspended is true, then most of the timings for this build are
        /// suspect.
        /// NOTE: This is no longer set and is deprecated.
        #[prost(bool, tag = "1")]
        pub was_suspended: bool,
    }
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct BuildMetrics {
    #[prost(message, optional, tag = "1")]
    pub action_summary: ::core::option::Option<build_metrics::ActionSummary>,
    #[prost(message, optional, tag = "2")]
    pub memory_metrics: ::core::option::Option<build_metrics::MemoryMetrics>,
    #[prost(message, optional, tag = "3")]
    pub target_metrics: ::core::option::Option<build_metrics::TargetMetrics>,
    #[prost(message, optional, tag = "4")]
    pub package_metrics: ::core::option::Option<build_metrics::PackageMetrics>,
    #[prost(message, optional, tag = "5")]
    pub timing_metrics: ::core::option::Option<build_metrics::TimingMetrics>,
    #[prost(message, optional, tag = "6")]
    pub cumulative_metrics: ::core::option::Option<build_metrics::CumulativeMetrics>,
    #[prost(message, optional, tag = "7")]
    pub artifact_metrics: ::core::option::Option<build_metrics::ArtifactMetrics>,
    #[prost(message, optional, tag = "8")]
    pub build_graph_metrics: ::core::option::Option<build_metrics::BuildGraphMetrics>,
    #[prost(message, repeated, tag = "9")]
    pub worker_metrics: ::prost::alloc::vec::Vec<build_metrics::WorkerMetrics>,
    #[prost(message, optional, tag = "10")]
    pub network_metrics: ::core::option::Option<build_metrics::NetworkMetrics>,
    #[prost(message, optional, tag = "11")]
    pub worker_pool_metrics: ::core::option::Option<build_metrics::WorkerPoolMetrics>,
    #[prost(message, optional, tag = "12")]
    pub dynamic_execution_metrics: ::core::option::Option<
        build_metrics::DynamicExecutionMetrics,
    >,
}
/// Nested message and enum types in `BuildMetrics`.
pub mod build_metrics {
    #[derive(Clone, PartialEq, ::prost::Message)]
    pub struct ActionSummary {
        /// The total number of actions created and registered during the build,
        /// including both aspects and configured targets. This metric includes
        /// unused actions that were constructed but not executed during this build.
        /// It does not include actions that were created on prior builds that are
        /// still valid, even if those actions had to be re-executed on this build.
        /// For the total number of actions that would be created if this invocation
        /// were "clean", see BuildGraphMetrics below.
        #[prost(int64, tag = "1")]
        pub actions_created: i64,
        /// The total number of actions created this build just by configured
        /// targets. Used mainly to allow consumers of actions_created, which used to
        /// not include aspects' actions, to normalize across the Blaze release that
        /// switched actions_created to include all created actions.
        #[prost(int64, tag = "3")]
        pub actions_created_not_including_aspects: i64,
        /// The total number of actions executed during the build. This includes any
        /// remote cache hits, but excludes local action cache hits.
        #[prost(int64, tag = "2")]
        pub actions_executed: i64,
        /// Contains the top N actions by number of actions executed.
        #[prost(message, repeated, tag = "4")]
        pub action_data: ::prost::alloc::vec::Vec<action_summary::ActionData>,
        /// Deprecated. The total number of remote cache hits.
        #[deprecated]
        #[prost(int64, tag = "5")]
        pub remote_cache_hits: i64,
        #[prost(message, repeated, tag = "6")]
        pub runner_count: ::prost::alloc::vec::Vec<action_summary::RunnerCount>,
        #[prost(message, optional, tag = "7")]
        pub action_cache_statistics: ::core::option::Option<
            super::super::blaze::ActionCacheStatistics,
        >,
    }
    /// Nested message and enum types in `ActionSummary`.
    pub mod action_summary {
        #[derive(Clone, PartialEq, ::prost::Message)]
        pub struct ActionData {
            #[prost(string, tag = "1")]
            pub mnemonic: ::prost::alloc::string::String,
            /// The total number of actions of this type executed during the build. As
            /// above, includes remote cache hits but excludes local action cache hits.
            #[prost(int64, tag = "2")]
            pub actions_executed: i64,
            /// When the first action of this type started being executed, in
            /// milliseconds from the epoch.
            #[prost(int64, tag = "3")]
            pub first_started_ms: i64,
            /// When the last action of this type ended being executed, in
            /// milliseconds from the epoch.
            #[prost(int64, tag = "4")]
            pub last_ended_ms: i64,
            /// Accumulated CPU time of all spawned actions of this type.
            /// This is only set if all the actions reported a time
            #[prost(message, optional, tag = "5")]
            pub system_time: ::core::option::Option<::prost_types::Duration>,
            #[prost(message, optional, tag = "6")]
            pub user_time: ::core::option::Option<::prost_types::Duration>,
            /// The total number of actions of this type registered during the build.
            #[prost(int64, tag = "7")]
            pub actions_created: i64,
        }
        #[derive(Clone, PartialEq, ::prost::Message)]
        pub struct RunnerCount {
            #[prost(string, tag = "1")]
            pub name: ::prost::alloc::string::String,
            #[prost(int32, tag = "2")]
            pub count: i32,
            #[prost(string, tag = "3")]
            pub exec_kind: ::prost::alloc::string::String,
        }
    }
    #[derive(Clone, PartialEq, ::prost::Message)]
    pub struct MemoryMetrics {
        /// Size of the JVM heap post build in bytes. This is only collected if
        /// --memory_profile is set, since it forces a full GC.
        #[prost(int64, tag = "1")]
        pub used_heap_size_post_build: i64,
        /// Size of the peak JVM heap size in bytes post GC. Note that this reports 0
        /// if there was no major GC during the build.
        #[prost(int64, tag = "2")]
        pub peak_post_gc_heap_size: i64,
        /// Size of the peak tenured space JVM heap size event in bytes post GC. Note
        /// that this reports 0 if there was no major GC during the build.
        #[prost(int64, tag = "4")]
        pub peak_post_gc_tenured_space_heap_size: i64,
        #[prost(message, repeated, tag = "3")]
        pub garbage_metrics: ::prost::alloc::vec::Vec<memory_metrics::GarbageMetrics>,
    }
    /// Nested message and enum types in `MemoryMetrics`.
    pub mod memory_metrics {
        #[derive(Clone, PartialEq, ::prost::Message)]
        pub struct GarbageMetrics {
            /// Type of garbage collected, e.g. G1 Old Gen.
            #[prost(string, tag = "1")]
            pub r#type: ::prost::alloc::string::String,
            /// Number of bytes of garbage of the given type collected during this
            /// invocation.
            #[prost(int64, tag = "2")]
            pub garbage_collected: i64,
        }
    }
    #[derive(Clone, Copy, PartialEq, ::prost::Message)]
    pub struct TargetMetrics {
        /// DEPRECATED
        /// No longer populated. It never measured what it was supposed to (targets
        /// loaded): it counted targets that were analyzed even if the underlying
        /// package had not changed.
        /// TODO(janakr): rename and remove.
        #[prost(int64, tag = "1")]
        pub targets_loaded: i64,
        /// Number of targets/aspects configured during this build. Does not include
        /// targets/aspects that were configured on prior builds on this server and
        /// were cached. See BuildGraphMetrics below if you need that.
        #[prost(int64, tag = "2")]
        pub targets_configured: i64,
        /// Number of configured targets analyzed during this build. Does not include
        /// aspects. Used mainly to allow consumers of targets_configured, which used
        /// to not include aspects, to normalize across the Blaze release that
        /// switched targets_configured to include aspects.
        #[prost(int64, tag = "3")]
        pub targets_configured_not_including_aspects: i64,
    }
    #[derive(Clone, PartialEq, ::prost::Message)]
    pub struct PackageMetrics {
        /// Number of BUILD files (aka packages) successfully loaded during this
        /// build.
        ///
        /// \[For Bazel binaries built at source states\] Before Dec 2021, this value
        /// was the number of packages attempted to be loaded, for a particular
        /// definition of "attempted".
        ///
        /// After Dec 2021, this value would sometimes overcount because the same
        /// package could sometimes be attempted to be loaded multiple times due to
        /// memory pressure.
        ///
        /// After Feb 2022, this value is the number of packages successfully
        /// loaded.
        #[prost(int64, tag = "1")]
        pub packages_loaded: i64,
        /// Loading time metrics per package.
        #[prost(message, repeated, tag = "2")]
        pub package_load_metrics: ::prost::alloc::vec::Vec<
            super::super::devtools::build::lib::packages::metrics::PackageLoadMetrics,
        >,
    }
    #[derive(Clone, Copy, PartialEq, ::prost::Message)]
    pub struct TimingMetrics {
        /// For Skymeld, it's possible that
        /// analysis_phase_time_in_ms + execution_phase_time_in_ms >= wall_time_in_ms
        ///
        /// The CPU time in milliseconds consumed during this build.
        #[prost(int64, tag = "1")]
        pub cpu_time_in_ms: i64,
        /// The elapsed wall time in milliseconds during this build.
        #[prost(int64, tag = "2")]
        pub wall_time_in_ms: i64,
        /// The elapsed wall time in milliseconds during the analysis phase.
        /// When analysis and execution phases are interleaved, this measures the
        /// elapsed time from the first analysis work to the last.
        #[prost(int64, tag = "3")]
        pub analysis_phase_time_in_ms: i64,
        /// The elapsed wall time in milliseconds during the execution phase.
        /// When analysis and execution phases are interleaved, this measures the
        /// elapsed time from the first action execution (excluding workspace status
        /// actions) to the last.
        #[prost(int64, tag = "4")]
        pub execution_phase_time_in_ms: i64,
        /// The elapsed wall time in milliseconds until the first action execution
        /// started (excluding workspace status actions).
        #[prost(int64, tag = "5")]
        pub actions_execution_start_in_ms: i64,
    }
    #[derive(Clone, Copy, PartialEq, ::prost::Message)]
    pub struct CumulativeMetrics {
        /// One-indexed number of "analyses" the server has run, including the
        /// current one. Will be incremented for every build/test/cquery/etc. command
        /// that reaches the analysis phase.
        #[prost(int32, tag = "11")]
        pub num_analyses: i32,
        /// One-indexed number of "builds" the server has run, including the current
        /// one. Will be incremented for every build/test/run/etc. command that
        /// reaches the execution phase.
        #[prost(int32, tag = "12")]
        pub num_builds: i32,
    }
    #[derive(Clone, Copy, PartialEq, ::prost::Message)]
    pub struct ArtifactMetrics {
        /// Measures all source files newly read this build. Does not include
        /// unchanged sources on incremental builds.
        #[prost(message, optional, tag = "2")]
        pub source_artifacts_read: ::core::option::Option<artifact_metrics::FilesMetric>,
        /// Measures all output artifacts from executed actions. This includes
        /// actions that were cached locally (via the action cache) or remotely (via
        /// a remote cache or executor), but does *not* include outputs of actions
        /// that were cached internally in Skyframe.
        #[prost(message, optional, tag = "3")]
        pub output_artifacts_seen: ::core::option::Option<artifact_metrics::FilesMetric>,
        /// Measures all output artifacts from actions that were cached locally
        /// via the action cache. These artifacts were already present on disk at the
        /// start of the build. Does not include Skyframe-cached actions' outputs.
        #[prost(message, optional, tag = "4")]
        pub output_artifacts_from_action_cache: ::core::option::Option<
            artifact_metrics::FilesMetric,
        >,
        /// Measures all artifacts that belong to a top-level output group. Does not
        /// deduplicate, so if there are two top-level targets in this build that
        /// share an artifact, it will be counted twice.
        #[prost(message, optional, tag = "5")]
        pub top_level_artifacts: ::core::option::Option<artifact_metrics::FilesMetric>,
    }
    /// Nested message and enum types in `ArtifactMetrics`.
    pub mod artifact_metrics {
        #[derive(Clone, Copy, PartialEq, ::prost::Message)]
        pub struct FilesMetric {
            #[prost(int64, tag = "1")]
            pub size_in_bytes: i64,
            #[prost(int32, tag = "2")]
            pub count: i32,
        }
    }
    /// Data about the evaluation of Skyfunctions.
    #[derive(Clone, PartialEq, ::prost::Message)]
    pub struct EvaluationStat {
        /// Name of the Skyfunction.
        #[prost(string, tag = "1")]
        pub skyfunction_name: ::prost::alloc::string::String,
        /// How many times a given operation was carried out on a Skyfunction.
        #[prost(int64, tag = "2")]
        pub count: i64,
    }
    /// Information about the size and shape of the build graph. Some fields may
    /// not be populated if Bazel was able to skip steps due to caching.
    #[derive(Clone, PartialEq, ::prost::Message)]
    pub struct BuildGraphMetrics {
        /// How many configured targets/aspects were in this build, including any
        /// that were analyzed on a prior build and are still valid. May not be
        /// populated if analysis phase was fully cached. Note: for historical
        /// reasons this includes input/output files and other configured targets
        /// that do not actually have associated actions.
        #[prost(int32, tag = "1")]
        pub action_lookup_value_count: i32,
        /// How many configured targets alone were in this build: always at most
        /// action_lookup_value_count. Useful mainly for historical comparisons to
        /// TargetMetrics.targets_configured, which used to not count aspects. This
        /// also includes configured targets that do not have associated actions.
        #[prost(int32, tag = "5")]
        pub action_lookup_value_count_not_including_aspects: i32,
        /// How many actions belonged to the configured targets/aspects above. It may
        /// not be necessary to execute all of these actions to build the requested
        /// targets. May not be populated if analysis phase was fully cached.
        #[prost(int32, tag = "2")]
        pub action_count: i32,
        /// How many actions belonged to configured targets: always at most
        /// action_count. Useful mainly for historical comparisons to
        /// ActionMetrics.actions_created, which used to not count aspects' actions.
        #[prost(int32, tag = "6")]
        pub action_count_not_including_aspects: i32,
        /// How many "input file" configured targets there were: one per source file.
        /// Should agree with artifact_metrics.source_artifacts_read.count above,
        #[prost(int32, tag = "7")]
        pub input_file_configured_target_count: i32,
        /// How many "output file" configured targets there were: output files that
        /// are targets (not implicit outputs).
        #[prost(int32, tag = "8")]
        pub output_file_configured_target_count: i32,
        /// How many "other" configured targets there were (like alias,
        /// package_group, and other non-rule non-file configured targets).
        #[prost(int32, tag = "9")]
        pub other_configured_target_count: i32,
        /// How many artifacts are outputs of the above actions. May not be populated
        /// if analysis phase was fully cached.
        #[prost(int32, tag = "3")]
        pub output_artifact_count: i32,
        /// How many Skyframe nodes there are in memory at the end of the build. This
        /// may underestimate the number of nodes when running with memory-saving
        /// settings or with Skybuild, and may overestimate if there are nodes from
        /// prior evaluations still in the cache.
        #[prost(int32, tag = "4")]
        pub post_invocation_skyframe_node_count: i32,
        /// Number of SkyValues that were dirtied during the build. Dirtied nodes are
        /// those that transitively depend on a node that changed by itself (e.g. one
        /// representing a file in the file system)
        #[prost(message, repeated, tag = "10")]
        pub dirtied_values: ::prost::alloc::vec::Vec<EvaluationStat>,
        /// Number of SkyValues that changed by themselves. For example, when a file
        /// on the file system changes, the SkyValue representing it will change.
        #[prost(message, repeated, tag = "11")]
        pub changed_values: ::prost::alloc::vec::Vec<EvaluationStat>,
        /// Number of SkyValues that were built. This means that they were evaluated
        /// and were found to have changed from their previous version.
        #[prost(message, repeated, tag = "12")]
        pub built_values: ::prost::alloc::vec::Vec<EvaluationStat>,
        /// Number of SkyValues that were evaluated and found clean, i.e. equal to
        /// their previous version.
        #[prost(message, repeated, tag = "13")]
        pub cleaned_values: ::prost::alloc::vec::Vec<EvaluationStat>,
        /// Number of evaluations to build SkyValues. This includes restarted
        /// evaluations, which means there can be multiple evaluations per built
        /// SkyValue. Subtract built_values from this number to get the number of
        /// restarted evaluations.
        #[prost(message, repeated, tag = "17")]
        pub evaluated_values: ::prost::alloc::vec::Vec<EvaluationStat>,
        #[prost(message, repeated, tag = "14")]
        pub rule_class: ::prost::alloc::vec::Vec<build_graph_metrics::RuleClassCount>,
        #[prost(message, repeated, tag = "15")]
        pub aspect: ::prost::alloc::vec::Vec<build_graph_metrics::AspectCount>,
    }
    /// Nested message and enum types in `BuildGraphMetrics`.
    pub mod build_graph_metrics {
        /// For SkyKeys in 'done values' where the SkyValue is of type
        /// RuleConfiguredTargetValue, we pull those out separately and report the
        /// ruleClass and action count.
        #[derive(Clone, PartialEq, ::prost::Message)]
        pub struct RuleClassCount {
            /// Unique key for the rule class.
            #[prost(string, tag = "1")]
            pub key: ::prost::alloc::string::String,
            /// String name of the rule_class (not guaranteed unique)
            #[prost(string, tag = "2")]
            pub rule_class: ::prost::alloc::string::String,
            /// how many rule instances of this type were seen.
            #[prost(uint64, tag = "3")]
            pub count: u64,
            /// how many actions were created by this rule class.
            #[prost(uint64, tag = "4")]
            pub action_count: u64,
        }
        /// For SkyKeys whose function name is ASPECT break out that information
        #[derive(Clone, PartialEq, ::prost::Message)]
        pub struct AspectCount {
            /// Unique key for Aspect.
            #[prost(string, tag = "1")]
            pub key: ::prost::alloc::string::String,
            /// usually the same as above, but can differ in some cases.
            #[prost(string, tag = "2")]
            pub aspect_name: ::prost::alloc::string::String,
            /// number of aspects created of this type.
            #[prost(uint64, tag = "3")]
            pub count: u64,
            /// number of actions created by aspects of this type.
            #[prost(uint64, tag = "4")]
            pub action_count: u64,
        }
    }
    /// Information about all workers that were alive during the invocation.
    #[derive(Clone, PartialEq, ::prost::Message)]
    pub struct WorkerMetrics {
        /// Deprecated. Use worker_ids instead of this field.
        #[deprecated]
        #[prost(int32, tag = "1")]
        pub worker_id: i32,
        /// Ids of workers. Could be multiple in case of multiplex workers
        #[prost(uint32, repeated, tag = "8")]
        pub worker_ids: ::prost::alloc::vec::Vec<u32>,
        /// Worker process id. If there is no process for worker, equals to zero.
        #[prost(uint32, tag = "2")]
        pub process_id: u32,
        /// Mnemonic of running worker.
        #[prost(string, tag = "3")]
        pub mnemonic: ::prost::alloc::string::String,
        /// Multiplex or singleplex worker.
        #[prost(bool, tag = "4")]
        pub is_multiplex: bool,
        /// Using worker sandbox file system or not.
        #[prost(bool, tag = "5")]
        pub is_sandbox: bool,
        /// TODO(b/300067854): Deprecate since all worker metrics should have their
        /// WorkerStats set.
        #[prost(bool, tag = "6")]
        pub is_measurable: bool,
        /// Hash value of worker key. Needed to distinguish worker pools with same
        /// menmonic but with different worker keys.
        #[prost(int64, tag = "9")]
        pub worker_key_hash: i64,
        #[prost(enumeration = "worker_metrics::WorkerStatus", tag = "10")]
        pub worker_status: i32,
        #[prost(
            enumeration = "super::super::failure_details::worker::Code",
            optional,
            tag = "12"
        )]
        pub code: ::core::option::Option<i32>,
        #[prost(int64, tag = "11")]
        pub actions_executed: i64,
        #[prost(int64, tag = "13")]
        pub prior_actions_executed: i64,
        /// Combined workers statistics.
        #[prost(message, repeated, tag = "7")]
        pub worker_stats: ::prost::alloc::vec::Vec<worker_metrics::WorkerStats>,
    }
    /// Nested message and enum types in `WorkerMetrics`.
    pub mod worker_metrics {
        /// Information collected from worker at some point.
        #[derive(Clone, Copy, PartialEq, ::prost::Message)]
        pub struct WorkerStats {
            /// Epoch unix time of collection of metrics.
            #[prost(int64, tag = "1")]
            pub collect_time_in_ms: i64,
            /// Memory usage of worker process at the end of the build.
            #[prost(int32, tag = "2")]
            pub worker_memory_in_kb: i32,
            /// Memory usage of the worker process prior to the invocation.
            #[prost(int32, tag = "4")]
            pub prior_worker_memory_in_kb: i32,
            /// Epoch unix time of last action started on specific worker.
            #[prost(int64, tag = "3")]
            pub last_action_start_time_in_ms: i64,
        }
        #[derive(
            Clone,
            Copy,
            Debug,
            PartialEq,
            Eq,
            Hash,
            PartialOrd,
            Ord,
            ::prost::Enumeration
        )]
        #[repr(i32)]
        pub enum WorkerStatus {
            /// Used to indicate a worker instance where the process has not been
            /// created yet. In reality this isn't logged, but leaving this here as a
            /// possible option in the future.
            NotStarted = 0,
            Alive = 1,
            KilledDueToMemoryPressure = 2,
            /// Indicates that the worker process was killed due to a reason unknown to
            /// Bazel at the point of measurement; if a known cause (below) comes along
            /// later on, this field will be updated.
            KilledUnknown = 3,
            KilledDueToInterruptedException = 4,
            KilledDueToIoException = 5,
            KilledDueToUserExecException = 6,
        }
        impl WorkerStatus {
            /// String value of the enum field names used in the ProtoBuf definition.
            ///
            /// The values are not transformed in any way and thus are considered stable
            /// (if the ProtoBuf definition does not change) and safe for programmatic use.
            pub fn as_str_name(&self) -> &'static str {
                match self {
                    Self::NotStarted => "NOT_STARTED",
                    Self::Alive => "ALIVE",
                    Self::KilledDueToMemoryPressure => "KILLED_DUE_TO_MEMORY_PRESSURE",
                    Self::KilledUnknown => "KILLED_UNKNOWN",
                    Self::KilledDueToInterruptedException => {
                        "KILLED_DUE_TO_INTERRUPTED_EXCEPTION"
                    }
                    Self::KilledDueToIoException => "KILLED_DUE_TO_IO_EXCEPTION",
                    Self::KilledDueToUserExecException => {
                        "KILLED_DUE_TO_USER_EXEC_EXCEPTION"
                    }
                }
            }
            /// Creates an enum from field names used in the ProtoBuf definition.
            pub fn from_str_name(value: &str) -> ::core::option::Option<Self> {
                match value {
                    "NOT_STARTED" => Some(Self::NotStarted),
                    "ALIVE" => Some(Self::Alive),
                    "KILLED_DUE_TO_MEMORY_PRESSURE" => {
                        Some(Self::KilledDueToMemoryPressure)
                    }
                    "KILLED_UNKNOWN" => Some(Self::KilledUnknown),
                    "KILLED_DUE_TO_INTERRUPTED_EXCEPTION" => {
                        Some(Self::KilledDueToInterruptedException)
                    }
                    "KILLED_DUE_TO_IO_EXCEPTION" => Some(Self::KilledDueToIoException),
                    "KILLED_DUE_TO_USER_EXEC_EXCEPTION" => {
                        Some(Self::KilledDueToUserExecException)
                    }
                    _ => None,
                }
            }
        }
    }
    /// Information about host network.
    #[derive(Clone, Copy, PartialEq, ::prost::Message)]
    pub struct NetworkMetrics {
        #[prost(message, optional, tag = "1")]
        pub system_network_stats: ::core::option::Option<
            network_metrics::SystemNetworkStats,
        >,
    }
    /// Nested message and enum types in `NetworkMetrics`.
    pub mod network_metrics {
        /// Information for all the network traffic going on on the host machine
        /// during the invocation.
        #[derive(Clone, Copy, PartialEq, ::prost::Message)]
        pub struct SystemNetworkStats {
            /// Total bytes sent during the invocation.
            #[prost(uint64, tag = "1")]
            pub bytes_sent: u64,
            /// Total bytes received during the invocation.
            #[prost(uint64, tag = "2")]
            pub bytes_recv: u64,
            /// Total packets sent during the invocation.
            #[prost(uint64, tag = "3")]
            pub packets_sent: u64,
            /// Total packets received during the invocation.
            #[prost(uint64, tag = "4")]
            pub packets_recv: u64,
            /// Peak bytes/sec sent during the invocation.
            #[prost(uint64, tag = "5")]
            pub peak_bytes_sent_per_sec: u64,
            /// Peak bytes/sec received during the invocation.
            #[prost(uint64, tag = "6")]
            pub peak_bytes_recv_per_sec: u64,
            /// Peak packets/sec sent during the invocation.
            #[prost(uint64, tag = "7")]
            pub peak_packets_sent_per_sec: u64,
            /// Peak packets/sec received during the invocation.
            #[prost(uint64, tag = "8")]
            pub peak_packets_recv_per_sec: u64,
        }
    }
    /// Information about worker pool actions.
    #[derive(Clone, PartialEq, ::prost::Message)]
    pub struct WorkerPoolMetrics {
        /// Statistics of worker pool per worker pool hash. Basically it's a map from
        /// worker pool hash to statistics.
        #[prost(message, repeated, tag = "1")]
        pub worker_pool_stats: ::prost::alloc::vec::Vec<
            worker_pool_metrics::WorkerPoolStats,
        >,
    }
    /// Nested message and enum types in `WorkerPoolMetrics`.
    pub mod worker_pool_metrics {
        #[derive(Clone, PartialEq, ::prost::Message)]
        pub struct WorkerPoolStats {
            /// Hash of worker pool these stats are for. Contains information about
            /// startup flags.
            #[prost(int32, tag = "1")]
            pub hash: i32,
            /// Mnemonic of workers these stats are for.
            #[prost(string, tag = "2")]
            pub mnemonic: ::prost::alloc::string::String,
            /// Number of workers created during a build.
            #[prost(int64, tag = "3")]
            pub created_count: i64,
            /// Number of workers destroyed during a build (sum of all workers
            /// destroyed by eviction, UserExecException, IoException,
            /// InterruptedException and unknown reasons below).
            #[prost(int64, tag = "4")]
            pub destroyed_count: i64,
            /// Number of workers evicted during a build.
            #[prost(int64, tag = "5")]
            pub evicted_count: i64,
            /// Number of workers destroyed due to UserExecExceptions.
            #[prost(int64, tag = "6")]
            pub user_exec_exception_destroyed_count: i64,
            /// Number of workers destroyed due to IoExceptions.
            #[prost(int64, tag = "7")]
            pub io_exception_destroyed_count: i64,
            /// Number of workers destroyed due to InterruptedExceptions.
            #[prost(int64, tag = "8")]
            pub interrupted_exception_destroyed_count: i64,
            /// Number of workers destroyed due to an unknown reason.
            #[prost(int64, tag = "9")]
            pub unknown_destroyed_count: i64,
            /// Number of workers alive at the end of the build.
            #[prost(int64, tag = "10")]
            pub alive_count: i64,
        }
    }
    /// Information about dynamic execution.
    #[derive(Clone, PartialEq, ::prost::Message)]
    pub struct DynamicExecutionMetrics {
        /// Race statistics grouped by mnemonic, local_name, remote_name.
        #[prost(message, repeated, tag = "1")]
        pub race_statistics: ::prost::alloc::vec::Vec<
            dynamic_execution_metrics::RaceStatistics,
        >,
    }
    /// Nested message and enum types in `DynamicExecutionMetrics`.
    pub mod dynamic_execution_metrics {
        #[derive(Clone, PartialEq, ::prost::Message)]
        pub struct RaceStatistics {
            /// Mnemonic of the action.
            #[prost(string, tag = "1")]
            pub mnemonic: ::prost::alloc::string::String,
            /// Name of runner of local branch.
            #[prost(string, tag = "2")]
            pub local_runner: ::prost::alloc::string::String,
            /// Name of runner of remote branch.
            #[prost(string, tag = "3")]
            pub remote_runner: ::prost::alloc::string::String,
            /// Number of wins of local branch in race.
            #[prost(int32, tag = "4")]
            pub local_wins: i32,
            /// Number of wins of remote branch in race.
            #[prost(int32, tag = "5")]
            pub remote_wins: i32,
        }
    }
}
/// Event providing additional statistics/logs after completion of the build.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct BuildToolLogs {
    #[prost(message, repeated, tag = "1")]
    pub log: ::prost::alloc::vec::Vec<File>,
}
/// Event describing all convenience symlinks (i.e., workspace symlinks) to be
/// created or deleted once the execution phase has begun. Note that this event
/// does not say anything about whether or not the build tool actually executed
/// these filesystem operations; it only says what logical operations should be
/// performed. This event is emitted exactly once per build; if no symlinks are
/// to be modified, the event is still emitted with empty contents.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ConvenienceSymlinksIdentified {
    #[prost(message, repeated, tag = "1")]
    pub convenience_symlinks: ::prost::alloc::vec::Vec<ConvenienceSymlink>,
}
/// The message that contains what type of action to perform on a given path and
/// target of a symlink.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ConvenienceSymlink {
    /// The path of the symlink to be created or deleted, absolute or relative to
    /// the workspace, creating any directories necessary. If a symlink already
    /// exists at that location, then it should be replaced by a symlink pointing
    /// to the new target.
    #[prost(string, tag = "1")]
    pub path: ::prost::alloc::string::String,
    /// The operation we are performing on the symlink.
    #[prost(enumeration = "convenience_symlink::Action", tag = "2")]
    pub action: i32,
    /// If action is CREATE, this is the target path (relative to the output base)
    /// that the symlink should point to.
    ///
    /// If action is DELETE, this field is not set.
    #[prost(string, tag = "3")]
    pub target: ::prost::alloc::string::String,
}
/// Nested message and enum types in `ConvenienceSymlink`.
pub mod convenience_symlink {
    #[derive(
        Clone,
        Copy,
        Debug,
        PartialEq,
        Eq,
        Hash,
        PartialOrd,
        Ord,
        ::prost::Enumeration
    )]
    #[repr(i32)]
    pub enum Action {
        Unknown = 0,
        /// Indicates a symlink should be created, or overwritten if it already
        /// exists.
        Create = 1,
        /// Indicates a symlink should be deleted if it already exists.
        Delete = 2,
    }
    impl Action {
        /// String value of the enum field names used in the ProtoBuf definition.
        ///
        /// The values are not transformed in any way and thus are considered stable
        /// (if the ProtoBuf definition does not change) and safe for programmatic use.
        pub fn as_str_name(&self) -> &'static str {
            match self {
                Self::Unknown => "UNKNOWN",
                Self::Create => "CREATE",
                Self::Delete => "DELETE",
            }
        }
        /// Creates an enum from field names used in the ProtoBuf definition.
        pub fn from_str_name(value: &str) -> ::core::option::Option<Self> {
            match value {
                "UNKNOWN" => Some(Self::Unknown),
                "CREATE" => Some(Self::Create),
                "DELETE" => Some(Self::Delete),
                _ => None,
            }
        }
    }
}
/// Event that contains the ExecRequest of a run command announced only after a
/// successful build and before trying to execute the requested command-line.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ExecRequestConstructed {
    #[prost(bytes = "bytes", tag = "1")]
    pub working_directory: ::prost::bytes::Bytes,
    #[prost(bytes = "bytes", repeated, tag = "2")]
    pub argv: ::prost::alloc::vec::Vec<::prost::bytes::Bytes>,
    #[prost(message, repeated, tag = "3")]
    pub environment_variable: ::prost::alloc::vec::Vec<EnvironmentVariable>,
    #[prost(bytes = "bytes", repeated, tag = "4")]
    pub environment_variable_to_clear: ::prost::alloc::vec::Vec<::prost::bytes::Bytes>,
    #[prost(bool, tag = "5")]
    pub should_exec: bool,
}
/// An environment variable provided by a run command after a successful build.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct EnvironmentVariable {
    #[prost(bytes = "bytes", tag = "1")]
    pub name: ::prost::bytes::Bytes,
    #[prost(bytes = "bytes", tag = "2")]
    pub value: ::prost::bytes::Bytes,
}
/// Message describing a build event. Events will have an identifier that
/// is unique within a given build invocation; they also announce follow-up
/// events as children. More details, which are specific to the kind of event
/// that is observed, is provided in the payload. More options for the payload
/// might be added in the future.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct BuildEvent {
    #[prost(message, optional, tag = "1")]
    pub id: ::core::option::Option<BuildEventId>,
    #[prost(message, repeated, tag = "2")]
    pub children: ::prost::alloc::vec::Vec<BuildEventId>,
    #[prost(bool, tag = "20")]
    pub last_message: bool,
    #[prost(
        oneof = "build_event::Payload",
        tags = "3, 4, 5, 12, 22, 13, 16, 21, 17, 6, 18, 7, 15, 8, 10, 30, 9, 28, 14, 23, 24, 25, 26, 27, 29"
    )]
    pub payload: ::core::option::Option<build_event::Payload>,
}
/// Nested message and enum types in `BuildEvent`.
pub mod build_event {
    #[derive(Clone, PartialEq, ::prost::Oneof)]
    pub enum Payload {
        #[prost(message, tag = "3")]
        Progress(super::Progress),
        #[prost(message, tag = "4")]
        Aborted(super::Aborted),
        #[prost(message, tag = "5")]
        Started(super::BuildStarted),
        #[prost(message, tag = "12")]
        UnstructuredCommandLine(super::UnstructuredCommandLine),
        #[prost(message, tag = "22")]
        StructuredCommandLine(super::super::command_line::CommandLine),
        #[prost(message, tag = "13")]
        OptionsParsed(super::OptionsParsed),
        #[prost(message, tag = "16")]
        WorkspaceStatus(super::WorkspaceStatus),
        #[prost(message, tag = "21")]
        Fetch(super::Fetch),
        #[prost(message, tag = "17")]
        Configuration(super::Configuration),
        #[prost(message, tag = "6")]
        Expanded(super::PatternExpanded),
        #[prost(message, tag = "18")]
        Configured(super::TargetConfigured),
        #[prost(message, tag = "7")]
        Action(super::ActionExecuted),
        #[prost(message, tag = "15")]
        NamedSetOfFiles(super::NamedSetOfFiles),
        #[prost(message, tag = "8")]
        Completed(super::TargetComplete),
        #[prost(message, tag = "10")]
        TestResult(super::TestResult),
        #[prost(message, tag = "30")]
        TestProgress(super::TestProgress),
        #[prost(message, tag = "9")]
        TestSummary(super::TestSummary),
        #[prost(message, tag = "28")]
        TargetSummary(super::TargetSummary),
        #[prost(message, tag = "14")]
        Finished(super::BuildFinished),
        #[prost(message, tag = "23")]
        BuildToolLogs(super::BuildToolLogs),
        #[prost(message, tag = "24")]
        BuildMetrics(super::BuildMetrics),
        #[prost(message, tag = "25")]
        WorkspaceInfo(super::WorkspaceConfig),
        #[prost(message, tag = "26")]
        BuildMetadata(super::BuildMetadata),
        #[prost(message, tag = "27")]
        ConvenienceSymlinksIdentified(super::ConvenienceSymlinksIdentified),
        #[prost(message, tag = "29")]
        ExecRequest(super::ExecRequestConstructed),
    }
}
/// Enumeration type characterizing the size of a test, as specified by the
/// test rule.
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord, ::prost::Enumeration)]
#[repr(i32)]
pub enum TestSize {
    Unknown = 0,
    Small = 1,
    Medium = 2,
    Large = 3,
    Enormous = 4,
}
impl TestSize {
    /// String value of the enum field names used in the ProtoBuf definition.
    ///
    /// The values are not transformed in any way and thus are considered stable
    /// (if the ProtoBuf definition does not change) and safe for programmatic use.
    pub fn as_str_name(&self) -> &'static str {
        match self {
            Self::Unknown => "UNKNOWN",
            Self::Small => "SMALL",
            Self::Medium => "MEDIUM",
            Self::Large => "LARGE",
            Self::Enormous => "ENORMOUS",
        }
    }
    /// Creates an enum from field names used in the ProtoBuf definition.
    pub fn from_str_name(value: &str) -> ::core::option::Option<Self> {
        match value {
            "UNKNOWN" => Some(Self::Unknown),
            "SMALL" => Some(Self::Small),
            "MEDIUM" => Some(Self::Medium),
            "LARGE" => Some(Self::Large),
            "ENORMOUS" => Some(Self::Enormous),
            _ => None,
        }
    }
}
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord, ::prost::Enumeration)]
#[repr(i32)]
pub enum TestStatus {
    NoStatus = 0,
    Passed = 1,
    Flaky = 2,
    Timeout = 3,
    Failed = 4,
    Incomplete = 5,
    RemoteFailure = 6,
    FailedToBuild = 7,
    ToolHaltedBeforeTesting = 8,
}
impl TestStatus {
    /// String value of the enum field names used in the ProtoBuf definition.
    ///
    /// The values are not transformed in any way and thus are considered stable
    /// (if the ProtoBuf definition does not change) and safe for programmatic use.
    pub fn as_str_name(&self) -> &'static str {
        match self {
            Self::NoStatus => "NO_STATUS",
            Self::Passed => "PASSED",
            Self::Flaky => "FLAKY",
            Self::Timeout => "TIMEOUT",
            Self::Failed => "FAILED",
            Self::Incomplete => "INCOMPLETE",
            Self::RemoteFailure => "REMOTE_FAILURE",
            Self::FailedToBuild => "FAILED_TO_BUILD",
            Self::ToolHaltedBeforeTesting => "TOOL_HALTED_BEFORE_TESTING",
        }
    }
    /// Creates an enum from field names used in the ProtoBuf definition.
    pub fn from_str_name(value: &str) -> ::core::option::Option<Self> {
        match value {
            "NO_STATUS" => Some(Self::NoStatus),
            "PASSED" => Some(Self::Passed),
            "FLAKY" => Some(Self::Flaky),
            "TIMEOUT" => Some(Self::Timeout),
            "FAILED" => Some(Self::Failed),
            "INCOMPLETE" => Some(Self::Incomplete),
            "REMOTE_FAILURE" => Some(Self::RemoteFailure),
            "FAILED_TO_BUILD" => Some(Self::FailedToBuild),
            "TOOL_HALTED_BEFORE_TESTING" => Some(Self::ToolHaltedBeforeTesting),
            _ => None,
        }
    }
}
