// Copyright 2022 The NativeLink Authors. All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//    http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// This file is @generated by prost-build.
/// Representation of a Bazel command line.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct CommandLine {
    /// A title for this command line value, to differentiate it from others.
    /// In particular, a single invocation may wish to report both the literal and
    /// canonical command lines, and this label would be used to differentiate
    /// between both versions. This is a string for flexibility.
    #[prost(string, tag = "1")]
    pub command_line_label: ::prost::alloc::string::String,
    /// A Bazel command line is made of distinct parts. For example,
    ///     `bazel --nomaster_bazelrc test --nocache_test_results //foo:aTest`
    /// has the executable "bazel", a startup flag, a command "test", a command
    /// flag, and a test target. There could be many more flags and targets, or
    /// none (`bazel info` for example), but the basic structure is there. The
    /// command line should be broken down into these logical sections here.
    #[prost(message, repeated, tag = "2")]
    pub sections: ::prost::alloc::vec::Vec<CommandLineSection>,
}
/// A section of the Bazel command line.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct CommandLineSection {
    /// The name of this section, such as "startup_option" or "command".
    #[prost(string, tag = "1")]
    pub section_label: ::prost::alloc::string::String,
    #[prost(oneof = "command_line_section::SectionType", tags = "2, 3")]
    pub section_type: ::core::option::Option<command_line_section::SectionType>,
}
/// Nested message and enum types in `CommandLineSection`.
pub mod command_line_section {
    #[derive(Clone, PartialEq, ::prost::Oneof)]
    pub enum SectionType {
        /// Sections with non-options, such as the list of targets or the command,
        /// should use simple string chunks.
        #[prost(message, tag = "2")]
        ChunkList(super::ChunkList),
        /// Startup and command options are lists of options and belong here.
        #[prost(message, tag = "3")]
        OptionList(super::OptionList),
    }
}
/// Wrapper to allow a list of strings in the "oneof" section_type.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ChunkList {
    #[prost(string, repeated, tag = "1")]
    pub chunk: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
}
/// Wrapper to allow a list of options in the "oneof" section_type.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct OptionList {
    #[prost(message, repeated, tag = "1")]
    pub option: ::prost::alloc::vec::Vec<Option>,
}
/// A single command line option.
///
/// This represents the option itself, but does not take into account the type of
/// option or how the parser interpreted it. If this option is part of a command
/// line that represents the actual input that Bazel received, it would, for
/// example, include expansion flags as they are. However, if this option
/// represents the canonical form of the command line, with the values as Bazel
/// understands them, then the expansion flag, which has no value, would not
/// appear, and the flags it expands to would.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct Option {
    /// How the option looks with the option and its value combined. Depending on
    /// the purpose of this command line report, this could be the canonical
    /// form, or the way that the flag was set.
    ///
    /// Some examples: this might be `--foo=bar` form, or `--foo bar` with a space;
    /// for boolean flags, `--nobaz` is accepted on top of `--baz=false` and other
    /// negating values, or for a positive value, the unqualified `--baz` form
    /// is also accepted. This could also be a short `-b`, if the flag has an
    /// abbreviated form.
    #[prost(string, tag = "1")]
    pub combined_form: ::prost::alloc::string::String,
    /// The canonical name of the option, without the preceding dashes.
    #[prost(string, tag = "2")]
    pub option_name: ::prost::alloc::string::String,
    /// The value of the flag, or unset for flags that do not take values.
    /// Especially for boolean flags, this should be in canonical form, the
    /// combined_form field above gives room for showing the flag as it was set
    /// if that is preferred.
    #[prost(string, tag = "3")]
    pub option_value: ::prost::alloc::string::String,
    /// This flag's tagged effects. See OptionEffectTag's java documentation for
    /// details.
    #[prost(enumeration = "super::options::OptionEffectTag", repeated, tag = "4")]
    pub effect_tags: ::prost::alloc::vec::Vec<i32>,
    /// Metadata about the flag. See OptionMetadataTag's java documentation for
    /// details.
    #[prost(enumeration = "super::options::OptionMetadataTag", repeated, tag = "5")]
    pub metadata_tags: ::prost::alloc::vec::Vec<i32>,
}
