// Copyright 2022 The NativeLink Authors. All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//    http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// This file is @generated by prost-build.
/// Message used to concisely report all package metrics.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct PackageLoadMetrics {
    /// Name of the package.
    #[prost(string, optional, tag = "1")]
    pub name: ::core::option::Option<::prost::alloc::string::String>,
    /// Wall-time duration it took to construct the package.
    #[prost(message, optional, tag = "2")]
    pub load_duration: ::core::option::Option<::prost_types::Duration>,
    /// Number of targets created in the package.
    #[prost(uint64, optional, tag = "3")]
    pub num_targets: ::core::option::Option<u64>,
    /// Number of Starlark computation steps required to create the package.
    #[prost(uint64, optional, tag = "4")]
    pub computation_steps: ::core::option::Option<u64>,
    /// Number of transitive Starlark load()s required to create the package.
    #[prost(uint64, optional, tag = "5")]
    pub num_transitive_loads: ::core::option::Option<u64>,
    /// Numeric value given to the memory and general accounting costs associated
    /// with a loaded package. Values are an approximate but reasonable proxy for
    /// the real storage costs of a package.
    #[prost(uint64, optional, tag = "6")]
    pub package_overhead: ::core::option::Option<u64>,
}
