// Copyright 2022 The NativeLink Authors. All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//    http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// This file is @generated by prost-build.
#[derive(Clone, Copy, PartialEq, ::prost::Message)]
pub struct FailureDetailMetadata {
    #[prost(uint32, tag = "1")]
    pub exit_code: u32,
}
/// The FailureDetail message type is designed such that consumers can extract a
/// basic classification of a FailureDetail message even if the consumer was
/// built with a stale definition. This forward compatibility is implemented via
/// conventions on FailureDetail and its submessage types, as follows.
///
/// *** FailureDetail field numbers
///
/// Field numbers 1 through 100 (inclusive) are reserved for generally applicable
/// values. Any number of these fields may be set on a FailureDetail message.
///
/// Field numbers 101 through 10,000 (inclusive) are reserved for use inside the
/// "oneof" structure. Only one of these values should be set on a FailureDetail
/// message.
///
/// Additional fields numbers are unlikely to be needed, but, for extreme future-
/// proofing purposes, field numbers 10,001 through 1,000,000 (inclusive;
/// excluding protobuf's reserved range 19000 through 19999) are reserved for
/// additional generally applicable values.
///
/// *** FailureDetail's "oneof" submessages
///
/// Each field in the "oneof" structure is a submessage corresponding to a
/// category of failure.
///
/// In each of these submessage types, field number 1 is an enum whose values
/// correspond to a subcategory of the failure. Generally, the enum's constant
/// which maps to 0 should be interpreted as "unspecified", though this is not
/// required.
///
/// *** Recommended forward compatibility strategy
///
/// The recommended forward compatibility strategy is to reduce a FailureDetail
/// message to a pair of integers.
///
/// The first integer corresponds to the field number of the submessage set
/// inside FailureDetail's "oneof", which corresponds with the failure's
/// category.
///
/// The second integer corresponds to the value of the enum at field number 1
/// within that submessage, which corresponds with the failure's subcategory.
///
/// WARNING: This functionality is experimental and should not be relied on at
/// this time.
/// TODO(mschaller): remove experimental warning
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct FailureDetail {
    /// A short human-readable message describing the failure, for debugging.
    ///
    /// This value is *not* intended to be used algorithmically.
    #[prost(string, tag = "1")]
    pub message: ::prost::alloc::string::String,
    #[prost(
        oneof = "failure_detail::Category",
        tags = "101, 103, 104, 106, 107, 108, 110, 114, 115, 116, 117, 118, 119, 121, 122, 123, 124, 125, 126, 127, 129, 130, 132, 134, 135, 136, 137, 139, 140, 141, 142, 144, 145, 146, 147, 148, 150, 151, 152, 153, 154, 158, 159, 160, 161, 162, 163, 164, 166, 167, 168, 169, 172, 173, 174, 175, 177, 179, 181, 182, 183, 184, 185, 186"
    )]
    pub category: ::core::option::Option<failure_detail::Category>,
}
/// Nested message and enum types in `FailureDetail`.
pub mod failure_detail {
    #[derive(Clone, PartialEq, ::prost::Oneof)]
    pub enum Category {
        #[prost(message, tag = "101")]
        Interrupted(super::Interrupted),
        #[prost(message, tag = "103")]
        ExternalRepository(super::ExternalRepository),
        #[prost(message, tag = "104")]
        BuildProgress(super::BuildProgress),
        #[prost(message, tag = "106")]
        RemoteOptions(super::RemoteOptions),
        #[prost(message, tag = "107")]
        ClientEnvironment(super::ClientEnvironment),
        #[prost(message, tag = "108")]
        Crash(super::Crash),
        #[prost(message, tag = "110")]
        SymlinkForest(super::SymlinkForest),
        #[prost(message, tag = "114")]
        PackageOptions(super::PackageOptions),
        #[prost(message, tag = "115")]
        RemoteExecution(super::RemoteExecution),
        #[prost(message, tag = "116")]
        Execution(super::Execution),
        #[prost(message, tag = "117")]
        Workspaces(super::Workspaces),
        #[prost(message, tag = "118")]
        CrashOptions(super::CrashOptions),
        #[prost(message, tag = "119")]
        Filesystem(super::Filesystem),
        #[prost(message, tag = "121")]
        ExecutionOptions(super::ExecutionOptions),
        #[prost(message, tag = "122")]
        Command(super::Command),
        #[prost(message, tag = "123")]
        Spawn(super::Spawn),
        #[prost(message, tag = "124")]
        GrpcServer(super::GrpcServer),
        #[prost(message, tag = "125")]
        CanonicalizeFlags(super::CanonicalizeFlags),
        #[prost(message, tag = "126")]
        BuildConfiguration(super::BuildConfiguration),
        #[prost(message, tag = "127")]
        InfoCommand(super::InfoCommand),
        #[prost(message, tag = "129")]
        MemoryOptions(super::MemoryOptions),
        #[prost(message, tag = "130")]
        Query(super::Query),
        #[prost(message, tag = "132")]
        LocalExecution(super::LocalExecution),
        #[prost(message, tag = "134")]
        ActionCache(super::ActionCache),
        #[prost(message, tag = "135")]
        FetchCommand(super::FetchCommand),
        #[prost(message, tag = "136")]
        SyncCommand(super::SyncCommand),
        #[prost(message, tag = "137")]
        Sandbox(super::Sandbox),
        #[prost(message, tag = "139")]
        IncludeScanning(super::IncludeScanning),
        #[prost(message, tag = "140")]
        TestCommand(super::TestCommand),
        #[prost(message, tag = "141")]
        ActionQuery(super::ActionQuery),
        #[prost(message, tag = "142")]
        TargetPatterns(super::TargetPatterns),
        #[prost(message, tag = "144")]
        CleanCommand(super::CleanCommand),
        #[prost(message, tag = "145")]
        ConfigCommand(super::ConfigCommand),
        #[prost(message, tag = "146")]
        ConfigurableQuery(super::ConfigurableQuery),
        #[prost(message, tag = "147")]
        DumpCommand(super::DumpCommand),
        #[prost(message, tag = "148")]
        HelpCommand(super::HelpCommand),
        #[prost(message, tag = "150")]
        MobileInstall(super::MobileInstall),
        #[prost(message, tag = "151")]
        ProfileCommand(super::ProfileCommand),
        #[prost(message, tag = "152")]
        RunCommand(super::RunCommand),
        #[prost(message, tag = "153")]
        VersionCommand(super::VersionCommand),
        #[prost(message, tag = "154")]
        PrintActionCommand(super::PrintActionCommand),
        #[prost(message, tag = "158")]
        WorkspaceStatus(super::WorkspaceStatus),
        #[prost(message, tag = "159")]
        JavaCompile(super::JavaCompile),
        #[prost(message, tag = "160")]
        ActionRewinding(super::ActionRewinding),
        #[prost(message, tag = "161")]
        CppCompile(super::CppCompile),
        #[prost(message, tag = "162")]
        StarlarkAction(super::StarlarkAction),
        #[prost(message, tag = "163")]
        NinjaAction(super::NinjaAction),
        #[prost(message, tag = "164")]
        DynamicExecution(super::DynamicExecution),
        #[prost(message, tag = "166")]
        FailAction(super::FailAction),
        #[prost(message, tag = "167")]
        SymlinkAction(super::SymlinkAction),
        #[prost(message, tag = "168")]
        CppLink(super::CppLink),
        #[prost(message, tag = "169")]
        LtoAction(super::LtoAction),
        #[prost(message, tag = "172")]
        TestAction(super::TestAction),
        #[prost(message, tag = "173")]
        Worker(super::Worker),
        #[prost(message, tag = "174")]
        Analysis(super::Analysis),
        #[prost(message, tag = "175")]
        PackageLoading(super::PackageLoading),
        #[prost(message, tag = "177")]
        Toolchain(super::Toolchain),
        #[prost(message, tag = "179")]
        StarlarkLoading(super::StarlarkLoading),
        #[prost(message, tag = "181")]
        ExternalDeps(super::ExternalDeps),
        #[prost(message, tag = "182")]
        DiffAwareness(super::DiffAwareness),
        #[prost(message, tag = "183")]
        ModCommand(super::ModCommand),
        #[prost(message, tag = "184")]
        BuildReport(super::BuildReport),
        #[prost(message, tag = "185")]
        Skyfocus(super::Skyfocus),
        #[prost(message, tag = "186")]
        RemoteAnalysisCaching(super::RemoteAnalysisCaching),
    }
}
#[derive(Clone, Copy, PartialEq, ::prost::Message)]
pub struct Interrupted {
    #[prost(enumeration = "interrupted::Code", tag = "1")]
    pub code: i32,
}
/// Nested message and enum types in `Interrupted`.
pub mod interrupted {
    #[derive(
        Clone,
        Copy,
        Debug,
        PartialEq,
        Eq,
        Hash,
        PartialOrd,
        Ord,
        ::prost::Enumeration
    )]
    #[repr(i32)]
    pub enum Code {
        /// Unknown interrupt. Avoid using this code, instead use INTERRUPTED.
        InterruptedUnknown = 0,
        /// Command was interrupted (cancelled).
        Interrupted = 28,
        /// The following more specific interrupt codes have been deprecated and
        /// consolidated into INTERRUPTED.
        DeprecatedBuild = 4,
        DeprecatedBuildCompletion = 5,
        DeprecatedPackageLoadingSync = 6,
        DeprecatedExecutorCompletion = 7,
        DeprecatedCommandDispatch = 8,
        DeprecatedInfoItem = 9,
        DeprecatedAfterQuery = 10,
        DeprecatedFetchCommand = 17,
        DeprecatedSyncCommand = 18,
        DeprecatedCleanCommand = 20,
        DeprecatedMobileInstallCommand = 21,
        DeprecatedQuery = 22,
        DeprecatedRunCommand = 23,
        DeprecatedOptionsParsing = 27,
    }
    impl Code {
        /// String value of the enum field names used in the ProtoBuf definition.
        ///
        /// The values are not transformed in any way and thus are considered stable
        /// (if the ProtoBuf definition does not change) and safe for programmatic use.
        pub fn as_str_name(&self) -> &'static str {
            match self {
                Self::InterruptedUnknown => "INTERRUPTED_UNKNOWN",
                Self::Interrupted => "INTERRUPTED",
                Self::DeprecatedBuild => "DEPRECATED_BUILD",
                Self::DeprecatedBuildCompletion => "DEPRECATED_BUILD_COMPLETION",
                Self::DeprecatedPackageLoadingSync => "DEPRECATED_PACKAGE_LOADING_SYNC",
                Self::DeprecatedExecutorCompletion => "DEPRECATED_EXECUTOR_COMPLETION",
                Self::DeprecatedCommandDispatch => "DEPRECATED_COMMAND_DISPATCH",
                Self::DeprecatedInfoItem => "DEPRECATED_INFO_ITEM",
                Self::DeprecatedAfterQuery => "DEPRECATED_AFTER_QUERY",
                Self::DeprecatedFetchCommand => "DEPRECATED_FETCH_COMMAND",
                Self::DeprecatedSyncCommand => "DEPRECATED_SYNC_COMMAND",
                Self::DeprecatedCleanCommand => "DEPRECATED_CLEAN_COMMAND",
                Self::DeprecatedMobileInstallCommand => {
                    "DEPRECATED_MOBILE_INSTALL_COMMAND"
                }
                Self::DeprecatedQuery => "DEPRECATED_QUERY",
                Self::DeprecatedRunCommand => "DEPRECATED_RUN_COMMAND",
                Self::DeprecatedOptionsParsing => "DEPRECATED_OPTIONS_PARSING",
            }
        }
        /// Creates an enum from field names used in the ProtoBuf definition.
        pub fn from_str_name(value: &str) -> ::core::option::Option<Self> {
            match value {
                "INTERRUPTED_UNKNOWN" => Some(Self::InterruptedUnknown),
                "INTERRUPTED" => Some(Self::Interrupted),
                "DEPRECATED_BUILD" => Some(Self::DeprecatedBuild),
                "DEPRECATED_BUILD_COMPLETION" => Some(Self::DeprecatedBuildCompletion),
                "DEPRECATED_PACKAGE_LOADING_SYNC" => {
                    Some(Self::DeprecatedPackageLoadingSync)
                }
                "DEPRECATED_EXECUTOR_COMPLETION" => {
                    Some(Self::DeprecatedExecutorCompletion)
                }
                "DEPRECATED_COMMAND_DISPATCH" => Some(Self::DeprecatedCommandDispatch),
                "DEPRECATED_INFO_ITEM" => Some(Self::DeprecatedInfoItem),
                "DEPRECATED_AFTER_QUERY" => Some(Self::DeprecatedAfterQuery),
                "DEPRECATED_FETCH_COMMAND" => Some(Self::DeprecatedFetchCommand),
                "DEPRECATED_SYNC_COMMAND" => Some(Self::DeprecatedSyncCommand),
                "DEPRECATED_CLEAN_COMMAND" => Some(Self::DeprecatedCleanCommand),
                "DEPRECATED_MOBILE_INSTALL_COMMAND" => {
                    Some(Self::DeprecatedMobileInstallCommand)
                }
                "DEPRECATED_QUERY" => Some(Self::DeprecatedQuery),
                "DEPRECATED_RUN_COMMAND" => Some(Self::DeprecatedRunCommand),
                "DEPRECATED_OPTIONS_PARSING" => Some(Self::DeprecatedOptionsParsing),
                _ => None,
            }
        }
    }
}
#[derive(Clone, Copy, PartialEq, ::prost::Message)]
pub struct Spawn {
    #[prost(enumeration = "spawn::Code", tag = "1")]
    pub code: i32,
    /// For Codes describing generic failure to spawn (eg. EXECUTION_FAILED and
    /// EXECUTION_DENIED) the `catastrophic` field may be set to true indicating a
    /// failure that immediately terminated the entire build tool.
    #[prost(bool, tag = "2")]
    pub catastrophic: bool,
    /// If Code is NON_ZERO_EXIT, the `spawn_exit_code` field may be set to the
    /// non-zero exit code returned by the spawned process to the OS.
    ///
    /// NOTE: This field must not be confused with the build tool's overall
    /// exit code.
    #[prost(int32, tag = "3")]
    pub spawn_exit_code: i32,
}
/// Nested message and enum types in `Spawn`.
pub mod spawn {
    #[derive(
        Clone,
        Copy,
        Debug,
        PartialEq,
        Eq,
        Hash,
        PartialOrd,
        Ord,
        ::prost::Enumeration
    )]
    #[repr(i32)]
    pub enum Code {
        SpawnUnknown = 0,
        /// See the SpawnResult.Status Java enum for definitions of the following
        /// Spawn failure codes.
        NonZeroExit = 1,
        Timeout = 2,
        /// Note: Spawn OUT_OF_MEMORY leads to a BUILD_FAILURE exit_code because the
        /// build tool itself did not run out of memory.
        OutOfMemory = 3,
        ExecutionFailed = 4,
        ExecutionDenied = 5,
        RemoteCacheFailed = 6,
        CommandLineExpansionFailure = 7,
        ExecIoException = 8,
        InvalidTimeout = 9,
        InvalidRemoteExecutionProperties = 10,
        NoUsableStrategyFound = 11,
        /// TODO(b/138456686): this code should be deprecated when SpawnResult is
        ///    refactored to prohibit undetailed failures
        UnspecifiedExecutionFailure = 12,
        ForbiddenInput = 13,
        /// This also includes other remote cache errors, not just evictions,
        /// if --incompatible_remote_use_new_exit_code_for_lost_inputs is set.
        /// TODO: Rename it to a more general name when
        /// --experimental_remote_cache_eviction_retries is moved to
        /// non-experimental.
        RemoteCacheEvicted = 14,
        SpawnLogIoException = 15,
    }
    impl Code {
        /// String value of the enum field names used in the ProtoBuf definition.
        ///
        /// The values are not transformed in any way and thus are considered stable
        /// (if the ProtoBuf definition does not change) and safe for programmatic use.
        pub fn as_str_name(&self) -> &'static str {
            match self {
                Self::SpawnUnknown => "SPAWN_UNKNOWN",
                Self::NonZeroExit => "NON_ZERO_EXIT",
                Self::Timeout => "TIMEOUT",
                Self::OutOfMemory => "OUT_OF_MEMORY",
                Self::ExecutionFailed => "EXECUTION_FAILED",
                Self::ExecutionDenied => "EXECUTION_DENIED",
                Self::RemoteCacheFailed => "REMOTE_CACHE_FAILED",
                Self::CommandLineExpansionFailure => "COMMAND_LINE_EXPANSION_FAILURE",
                Self::ExecIoException => "EXEC_IO_EXCEPTION",
                Self::InvalidTimeout => "INVALID_TIMEOUT",
                Self::InvalidRemoteExecutionProperties => {
                    "INVALID_REMOTE_EXECUTION_PROPERTIES"
                }
                Self::NoUsableStrategyFound => "NO_USABLE_STRATEGY_FOUND",
                Self::UnspecifiedExecutionFailure => "UNSPECIFIED_EXECUTION_FAILURE",
                Self::ForbiddenInput => "FORBIDDEN_INPUT",
                Self::RemoteCacheEvicted => "REMOTE_CACHE_EVICTED",
                Self::SpawnLogIoException => "SPAWN_LOG_IO_EXCEPTION",
            }
        }
        /// Creates an enum from field names used in the ProtoBuf definition.
        pub fn from_str_name(value: &str) -> ::core::option::Option<Self> {
            match value {
                "SPAWN_UNKNOWN" => Some(Self::SpawnUnknown),
                "NON_ZERO_EXIT" => Some(Self::NonZeroExit),
                "TIMEOUT" => Some(Self::Timeout),
                "OUT_OF_MEMORY" => Some(Self::OutOfMemory),
                "EXECUTION_FAILED" => Some(Self::ExecutionFailed),
                "EXECUTION_DENIED" => Some(Self::ExecutionDenied),
                "REMOTE_CACHE_FAILED" => Some(Self::RemoteCacheFailed),
                "COMMAND_LINE_EXPANSION_FAILURE" => {
                    Some(Self::CommandLineExpansionFailure)
                }
                "EXEC_IO_EXCEPTION" => Some(Self::ExecIoException),
                "INVALID_TIMEOUT" => Some(Self::InvalidTimeout),
                "INVALID_REMOTE_EXECUTION_PROPERTIES" => {
                    Some(Self::InvalidRemoteExecutionProperties)
                }
                "NO_USABLE_STRATEGY_FOUND" => Some(Self::NoUsableStrategyFound),
                "UNSPECIFIED_EXECUTION_FAILURE" => {
                    Some(Self::UnspecifiedExecutionFailure)
                }
                "FORBIDDEN_INPUT" => Some(Self::ForbiddenInput),
                "REMOTE_CACHE_EVICTED" => Some(Self::RemoteCacheEvicted),
                "SPAWN_LOG_IO_EXCEPTION" => Some(Self::SpawnLogIoException),
                _ => None,
            }
        }
    }
}
#[derive(Clone, Copy, PartialEq, ::prost::Message)]
pub struct ExternalRepository {
    /// Additional data could include external repository names.
    #[prost(enumeration = "external_repository::Code", tag = "1")]
    pub code: i32,
}
/// Nested message and enum types in `ExternalRepository`.
pub mod external_repository {
    #[derive(
        Clone,
        Copy,
        Debug,
        PartialEq,
        Eq,
        Hash,
        PartialOrd,
        Ord,
        ::prost::Enumeration
    )]
    #[repr(i32)]
    pub enum Code {
        ExternalRepositoryUnknown = 0,
        OverrideDisallowedManagedDirectories = 1,
        BadDownloaderConfig = 2,
        RepositoryMappingResolutionFailed = 3,
        CredentialsInitFailure = 4,
    }
    impl Code {
        /// String value of the enum field names used in the ProtoBuf definition.
        ///
        /// The values are not transformed in any way and thus are considered stable
        /// (if the ProtoBuf definition does not change) and safe for programmatic use.
        pub fn as_str_name(&self) -> &'static str {
            match self {
                Self::ExternalRepositoryUnknown => "EXTERNAL_REPOSITORY_UNKNOWN",
                Self::OverrideDisallowedManagedDirectories => {
                    "OVERRIDE_DISALLOWED_MANAGED_DIRECTORIES"
                }
                Self::BadDownloaderConfig => "BAD_DOWNLOADER_CONFIG",
                Self::RepositoryMappingResolutionFailed => {
                    "REPOSITORY_MAPPING_RESOLUTION_FAILED"
                }
                Self::CredentialsInitFailure => "CREDENTIALS_INIT_FAILURE",
            }
        }
        /// Creates an enum from field names used in the ProtoBuf definition.
        pub fn from_str_name(value: &str) -> ::core::option::Option<Self> {
            match value {
                "EXTERNAL_REPOSITORY_UNKNOWN" => Some(Self::ExternalRepositoryUnknown),
                "OVERRIDE_DISALLOWED_MANAGED_DIRECTORIES" => {
                    Some(Self::OverrideDisallowedManagedDirectories)
                }
                "BAD_DOWNLOADER_CONFIG" => Some(Self::BadDownloaderConfig),
                "REPOSITORY_MAPPING_RESOLUTION_FAILED" => {
                    Some(Self::RepositoryMappingResolutionFailed)
                }
                "CREDENTIALS_INIT_FAILURE" => Some(Self::CredentialsInitFailure),
                _ => None,
            }
        }
    }
}
#[derive(Clone, Copy, PartialEq, ::prost::Message)]
pub struct BuildProgress {
    /// Additional data could include the build progress upload endpoint.
    #[prost(enumeration = "build_progress::Code", tag = "1")]
    pub code: i32,
}
/// Nested message and enum types in `BuildProgress`.
pub mod build_progress {
    #[derive(
        Clone,
        Copy,
        Debug,
        PartialEq,
        Eq,
        Hash,
        PartialOrd,
        Ord,
        ::prost::Enumeration
    )]
    #[repr(i32)]
    pub enum Code {
        BuildProgressUnknown = 0,
        OutputInitialization = 3,
        BesRunsPerTestLimitUnsupported = 4,
        BesLocalWriteError = 5,
        BesInitializationError = 6,
        BesUploadTimeoutError = 7,
        BesFileWriteTimeout = 8,
        BesFileWriteIoError = 9,
        BesFileWriteInterrupted = 10,
        BesFileWriteCanceled = 11,
        BesFileWriteUnknownError = 12,
        BesUploadLocalFileError = 13,
        BesStreamNotRetryingFailure = 14,
        BesStreamCompletedWithUnackEventsError = 15,
        BesStreamCompletedWithUnsentEventsError = 16,
        BesStreamCompletedWithRemoteError = 19,
        BesUploadRetryLimitExceededFailure = 17,
    }
    impl Code {
        /// String value of the enum field names used in the ProtoBuf definition.
        ///
        /// The values are not transformed in any way and thus are considered stable
        /// (if the ProtoBuf definition does not change) and safe for programmatic use.
        pub fn as_str_name(&self) -> &'static str {
            match self {
                Self::BuildProgressUnknown => "BUILD_PROGRESS_UNKNOWN",
                Self::OutputInitialization => "OUTPUT_INITIALIZATION",
                Self::BesRunsPerTestLimitUnsupported => {
                    "BES_RUNS_PER_TEST_LIMIT_UNSUPPORTED"
                }
                Self::BesLocalWriteError => "BES_LOCAL_WRITE_ERROR",
                Self::BesInitializationError => "BES_INITIALIZATION_ERROR",
                Self::BesUploadTimeoutError => "BES_UPLOAD_TIMEOUT_ERROR",
                Self::BesFileWriteTimeout => "BES_FILE_WRITE_TIMEOUT",
                Self::BesFileWriteIoError => "BES_FILE_WRITE_IO_ERROR",
                Self::BesFileWriteInterrupted => "BES_FILE_WRITE_INTERRUPTED",
                Self::BesFileWriteCanceled => "BES_FILE_WRITE_CANCELED",
                Self::BesFileWriteUnknownError => "BES_FILE_WRITE_UNKNOWN_ERROR",
                Self::BesUploadLocalFileError => "BES_UPLOAD_LOCAL_FILE_ERROR",
                Self::BesStreamNotRetryingFailure => "BES_STREAM_NOT_RETRYING_FAILURE",
                Self::BesStreamCompletedWithUnackEventsError => {
                    "BES_STREAM_COMPLETED_WITH_UNACK_EVENTS_ERROR"
                }
                Self::BesStreamCompletedWithUnsentEventsError => {
                    "BES_STREAM_COMPLETED_WITH_UNSENT_EVENTS_ERROR"
                }
                Self::BesStreamCompletedWithRemoteError => {
                    "BES_STREAM_COMPLETED_WITH_REMOTE_ERROR"
                }
                Self::BesUploadRetryLimitExceededFailure => {
                    "BES_UPLOAD_RETRY_LIMIT_EXCEEDED_FAILURE"
                }
            }
        }
        /// Creates an enum from field names used in the ProtoBuf definition.
        pub fn from_str_name(value: &str) -> ::core::option::Option<Self> {
            match value {
                "BUILD_PROGRESS_UNKNOWN" => Some(Self::BuildProgressUnknown),
                "OUTPUT_INITIALIZATION" => Some(Self::OutputInitialization),
                "BES_RUNS_PER_TEST_LIMIT_UNSUPPORTED" => {
                    Some(Self::BesRunsPerTestLimitUnsupported)
                }
                "BES_LOCAL_WRITE_ERROR" => Some(Self::BesLocalWriteError),
                "BES_INITIALIZATION_ERROR" => Some(Self::BesInitializationError),
                "BES_UPLOAD_TIMEOUT_ERROR" => Some(Self::BesUploadTimeoutError),
                "BES_FILE_WRITE_TIMEOUT" => Some(Self::BesFileWriteTimeout),
                "BES_FILE_WRITE_IO_ERROR" => Some(Self::BesFileWriteIoError),
                "BES_FILE_WRITE_INTERRUPTED" => Some(Self::BesFileWriteInterrupted),
                "BES_FILE_WRITE_CANCELED" => Some(Self::BesFileWriteCanceled),
                "BES_FILE_WRITE_UNKNOWN_ERROR" => Some(Self::BesFileWriteUnknownError),
                "BES_UPLOAD_LOCAL_FILE_ERROR" => Some(Self::BesUploadLocalFileError),
                "BES_STREAM_NOT_RETRYING_FAILURE" => {
                    Some(Self::BesStreamNotRetryingFailure)
                }
                "BES_STREAM_COMPLETED_WITH_UNACK_EVENTS_ERROR" => {
                    Some(Self::BesStreamCompletedWithUnackEventsError)
                }
                "BES_STREAM_COMPLETED_WITH_UNSENT_EVENTS_ERROR" => {
                    Some(Self::BesStreamCompletedWithUnsentEventsError)
                }
                "BES_STREAM_COMPLETED_WITH_REMOTE_ERROR" => {
                    Some(Self::BesStreamCompletedWithRemoteError)
                }
                "BES_UPLOAD_RETRY_LIMIT_EXCEEDED_FAILURE" => {
                    Some(Self::BesUploadRetryLimitExceededFailure)
                }
                _ => None,
            }
        }
    }
}
#[derive(Clone, Copy, PartialEq, ::prost::Message)]
pub struct RemoteOptions {
    #[prost(enumeration = "remote_options::Code", tag = "1")]
    pub code: i32,
}
/// Nested message and enum types in `RemoteOptions`.
pub mod remote_options {
    #[derive(
        Clone,
        Copy,
        Debug,
        PartialEq,
        Eq,
        Hash,
        PartialOrd,
        Ord,
        ::prost::Enumeration
    )]
    #[repr(i32)]
    pub enum Code {
        RemoteOptionsUnknown = 0,
        RemoteDefaultExecPropertiesLogicError = 1,
        /// Credentials could not be read from the requested file/socket/process/etc.
        CredentialsReadFailure = 2,
        /// Credentials could not be written to a shared, temporary file.
        CredentialsWriteFailure = 3,
        DownloaderWithoutGrpcCache = 4,
        ExecutionWithInvalidCache = 5,
    }
    impl Code {
        /// String value of the enum field names used in the ProtoBuf definition.
        ///
        /// The values are not transformed in any way and thus are considered stable
        /// (if the ProtoBuf definition does not change) and safe for programmatic use.
        pub fn as_str_name(&self) -> &'static str {
            match self {
                Self::RemoteOptionsUnknown => "REMOTE_OPTIONS_UNKNOWN",
                Self::RemoteDefaultExecPropertiesLogicError => {
                    "REMOTE_DEFAULT_EXEC_PROPERTIES_LOGIC_ERROR"
                }
                Self::CredentialsReadFailure => "CREDENTIALS_READ_FAILURE",
                Self::CredentialsWriteFailure => "CREDENTIALS_WRITE_FAILURE",
                Self::DownloaderWithoutGrpcCache => "DOWNLOADER_WITHOUT_GRPC_CACHE",
                Self::ExecutionWithInvalidCache => "EXECUTION_WITH_INVALID_CACHE",
            }
        }
        /// Creates an enum from field names used in the ProtoBuf definition.
        pub fn from_str_name(value: &str) -> ::core::option::Option<Self> {
            match value {
                "REMOTE_OPTIONS_UNKNOWN" => Some(Self::RemoteOptionsUnknown),
                "REMOTE_DEFAULT_EXEC_PROPERTIES_LOGIC_ERROR" => {
                    Some(Self::RemoteDefaultExecPropertiesLogicError)
                }
                "CREDENTIALS_READ_FAILURE" => Some(Self::CredentialsReadFailure),
                "CREDENTIALS_WRITE_FAILURE" => Some(Self::CredentialsWriteFailure),
                "DOWNLOADER_WITHOUT_GRPC_CACHE" => Some(Self::DownloaderWithoutGrpcCache),
                "EXECUTION_WITH_INVALID_CACHE" => Some(Self::ExecutionWithInvalidCache),
                _ => None,
            }
        }
    }
}
#[derive(Clone, Copy, PartialEq, ::prost::Message)]
pub struct ClientEnvironment {
    #[prost(enumeration = "client_environment::Code", tag = "1")]
    pub code: i32,
}
/// Nested message and enum types in `ClientEnvironment`.
pub mod client_environment {
    #[derive(
        Clone,
        Copy,
        Debug,
        PartialEq,
        Eq,
        Hash,
        PartialOrd,
        Ord,
        ::prost::Enumeration
    )]
    #[repr(i32)]
    pub enum Code {
        ClientEnvironmentUnknown = 0,
        ClientCwdMalformed = 1,
    }
    impl Code {
        /// String value of the enum field names used in the ProtoBuf definition.
        ///
        /// The values are not transformed in any way and thus are considered stable
        /// (if the ProtoBuf definition does not change) and safe for programmatic use.
        pub fn as_str_name(&self) -> &'static str {
            match self {
                Self::ClientEnvironmentUnknown => "CLIENT_ENVIRONMENT_UNKNOWN",
                Self::ClientCwdMalformed => "CLIENT_CWD_MALFORMED",
            }
        }
        /// Creates an enum from field names used in the ProtoBuf definition.
        pub fn from_str_name(value: &str) -> ::core::option::Option<Self> {
            match value {
                "CLIENT_ENVIRONMENT_UNKNOWN" => Some(Self::ClientEnvironmentUnknown),
                "CLIENT_CWD_MALFORMED" => Some(Self::ClientCwdMalformed),
                _ => None,
            }
        }
    }
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct Crash {
    #[prost(enumeration = "crash::Code", tag = "1")]
    pub code: i32,
    /// The cause chain of the crash, with the outermost throwable first. Limited
    /// to the outermost exception and at most 4 nested causes (so, max size of 5).
    #[prost(message, repeated, tag = "2")]
    pub causes: ::prost::alloc::vec::Vec<Throwable>,
    /// True when the root cause of the crash was not an OutOfMemoryError, but
    /// CRASH_OOM was chosen because an OutOfMemoryError was detected prior to the
    /// crash.
    #[prost(bool, tag = "3")]
    pub oom_detector_override: bool,
}
/// Nested message and enum types in `Crash`.
pub mod crash {
    #[derive(
        Clone,
        Copy,
        Debug,
        PartialEq,
        Eq,
        Hash,
        PartialOrd,
        Ord,
        ::prost::Enumeration
    )]
    #[repr(i32)]
    pub enum Code {
        CrashUnknown = 0,
        CrashOom = 1,
    }
    impl Code {
        /// String value of the enum field names used in the ProtoBuf definition.
        ///
        /// The values are not transformed in any way and thus are considered stable
        /// (if the ProtoBuf definition does not change) and safe for programmatic use.
        pub fn as_str_name(&self) -> &'static str {
            match self {
                Self::CrashUnknown => "CRASH_UNKNOWN",
                Self::CrashOom => "CRASH_OOM",
            }
        }
        /// Creates an enum from field names used in the ProtoBuf definition.
        pub fn from_str_name(value: &str) -> ::core::option::Option<Self> {
            match value {
                "CRASH_UNKNOWN" => Some(Self::CrashUnknown),
                "CRASH_OOM" => Some(Self::CrashOom),
                _ => None,
            }
        }
    }
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct Throwable {
    /// The class name of the java.lang.Throwable.
    #[prost(string, tag = "1")]
    pub throwable_class: ::prost::alloc::string::String,
    /// The throwable's message.
    #[prost(string, tag = "2")]
    pub message: ::prost::alloc::string::String,
    /// The result of calling toString on the deepest (i.e. closest to the
    /// throwable's construction site) 1000 (or fewer) StackTraceElements.
    /// Unstructured to simplify string matching.
    #[prost(string, repeated, tag = "3")]
    pub stack_trace: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
}
#[derive(Clone, Copy, PartialEq, ::prost::Message)]
pub struct SymlinkForest {
    #[prost(enumeration = "symlink_forest::Code", tag = "1")]
    pub code: i32,
}
/// Nested message and enum types in `SymlinkForest`.
pub mod symlink_forest {
    #[derive(
        Clone,
        Copy,
        Debug,
        PartialEq,
        Eq,
        Hash,
        PartialOrd,
        Ord,
        ::prost::Enumeration
    )]
    #[repr(i32)]
    pub enum Code {
        SymlinkForestUnknown = 0,
        ToplevelOutdirPackagePathConflict = 1,
        ToplevelOutdirUsedAsSource = 2,
        CreationFailed = 3,
    }
    impl Code {
        /// String value of the enum field names used in the ProtoBuf definition.
        ///
        /// The values are not transformed in any way and thus are considered stable
        /// (if the ProtoBuf definition does not change) and safe for programmatic use.
        pub fn as_str_name(&self) -> &'static str {
            match self {
                Self::SymlinkForestUnknown => "SYMLINK_FOREST_UNKNOWN",
                Self::ToplevelOutdirPackagePathConflict => {
                    "TOPLEVEL_OUTDIR_PACKAGE_PATH_CONFLICT"
                }
                Self::ToplevelOutdirUsedAsSource => "TOPLEVEL_OUTDIR_USED_AS_SOURCE",
                Self::CreationFailed => "CREATION_FAILED",
            }
        }
        /// Creates an enum from field names used in the ProtoBuf definition.
        pub fn from_str_name(value: &str) -> ::core::option::Option<Self> {
            match value {
                "SYMLINK_FOREST_UNKNOWN" => Some(Self::SymlinkForestUnknown),
                "TOPLEVEL_OUTDIR_PACKAGE_PATH_CONFLICT" => {
                    Some(Self::ToplevelOutdirPackagePathConflict)
                }
                "TOPLEVEL_OUTDIR_USED_AS_SOURCE" => {
                    Some(Self::ToplevelOutdirUsedAsSource)
                }
                "CREATION_FAILED" => Some(Self::CreationFailed),
                _ => None,
            }
        }
    }
}
#[derive(Clone, Copy, PartialEq, ::prost::Message)]
pub struct BuildReport {
    /// Additional data for partial failures might include the build report that
    /// failed to be written.
    #[prost(enumeration = "build_report::Code", tag = "1")]
    pub code: i32,
}
/// Nested message and enum types in `BuildReport`.
pub mod build_report {
    #[derive(
        Clone,
        Copy,
        Debug,
        PartialEq,
        Eq,
        Hash,
        PartialOrd,
        Ord,
        ::prost::Enumeration
    )]
    #[repr(i32)]
    pub enum Code {
        BuildReportUnknown = 0,
        BuildReportUploaderNeedsPackagePaths = 1,
        BuildReportWriteFailed = 2,
    }
    impl Code {
        /// String value of the enum field names used in the ProtoBuf definition.
        ///
        /// The values are not transformed in any way and thus are considered stable
        /// (if the ProtoBuf definition does not change) and safe for programmatic use.
        pub fn as_str_name(&self) -> &'static str {
            match self {
                Self::BuildReportUnknown => "BUILD_REPORT_UNKNOWN",
                Self::BuildReportUploaderNeedsPackagePaths => {
                    "BUILD_REPORT_UPLOADER_NEEDS_PACKAGE_PATHS"
                }
                Self::BuildReportWriteFailed => "BUILD_REPORT_WRITE_FAILED",
            }
        }
        /// Creates an enum from field names used in the ProtoBuf definition.
        pub fn from_str_name(value: &str) -> ::core::option::Option<Self> {
            match value {
                "BUILD_REPORT_UNKNOWN" => Some(Self::BuildReportUnknown),
                "BUILD_REPORT_UPLOADER_NEEDS_PACKAGE_PATHS" => {
                    Some(Self::BuildReportUploaderNeedsPackagePaths)
                }
                "BUILD_REPORT_WRITE_FAILED" => Some(Self::BuildReportWriteFailed),
                _ => None,
            }
        }
    }
}
/// Failure details for errors produced when using Skyfocus
#[derive(Clone, Copy, PartialEq, ::prost::Message)]
pub struct Skyfocus {
    #[prost(enumeration = "skyfocus::Code", tag = "1")]
    pub code: i32,
}
/// Nested message and enum types in `Skyfocus`.
pub mod skyfocus {
    #[derive(
        Clone,
        Copy,
        Debug,
        PartialEq,
        Eq,
        Hash,
        PartialOrd,
        Ord,
        ::prost::Enumeration
    )]
    #[repr(i32)]
    pub enum Code {
        /// The defined working set cannot be used for the focused targets. For
        /// example, this happens when the intersection of the working set and the
        /// transitive closure of the focused target is empty.
        InvalidWorkingSet = 0,
        /// The user needs to augment their working set to include the new file(s).
        NonWorkingSetChange = 1,
        ConfigurationChange = 2,
        DisallowedOperationOnFocusedGraph = 3,
    }
    impl Code {
        /// String value of the enum field names used in the ProtoBuf definition.
        ///
        /// The values are not transformed in any way and thus are considered stable
        /// (if the ProtoBuf definition does not change) and safe for programmatic use.
        pub fn as_str_name(&self) -> &'static str {
            match self {
                Self::InvalidWorkingSet => "INVALID_WORKING_SET",
                Self::NonWorkingSetChange => "NON_WORKING_SET_CHANGE",
                Self::ConfigurationChange => "CONFIGURATION_CHANGE",
                Self::DisallowedOperationOnFocusedGraph => {
                    "DISALLOWED_OPERATION_ON_FOCUSED_GRAPH"
                }
            }
        }
        /// Creates an enum from field names used in the ProtoBuf definition.
        pub fn from_str_name(value: &str) -> ::core::option::Option<Self> {
            match value {
                "INVALID_WORKING_SET" => Some(Self::InvalidWorkingSet),
                "NON_WORKING_SET_CHANGE" => Some(Self::NonWorkingSetChange),
                "CONFIGURATION_CHANGE" => Some(Self::ConfigurationChange),
                "DISALLOWED_OPERATION_ON_FOCUSED_GRAPH" => {
                    Some(Self::DisallowedOperationOnFocusedGraph)
                }
                _ => None,
            }
        }
    }
}
/// Failure details for errors produced during remote analysis caching.
#[derive(Clone, Copy, PartialEq, ::prost::Message)]
pub struct RemoteAnalysisCaching {
    #[prost(enumeration = "remote_analysis_caching::Code", tag = "1")]
    pub code: i32,
}
/// Nested message and enum types in `RemoteAnalysisCaching`.
pub mod remote_analysis_caching {
    #[derive(
        Clone,
        Copy,
        Debug,
        PartialEq,
        Eq,
        Hash,
        PartialOrd,
        Ord,
        ::prost::Enumeration
    )]
    #[repr(i32)]
    pub enum Code {
        RemoteAnalysisCachingUnknown = 0,
        SerializedFrontierProfileFailed = 1,
        ProjectFileNotFound = 2,
    }
    impl Code {
        /// String value of the enum field names used in the ProtoBuf definition.
        ///
        /// The values are not transformed in any way and thus are considered stable
        /// (if the ProtoBuf definition does not change) and safe for programmatic use.
        pub fn as_str_name(&self) -> &'static str {
            match self {
                Self::RemoteAnalysisCachingUnknown => "REMOTE_ANALYSIS_CACHING_UNKNOWN",
                Self::SerializedFrontierProfileFailed => {
                    "SERIALIZED_FRONTIER_PROFILE_FAILED"
                }
                Self::ProjectFileNotFound => "PROJECT_FILE_NOT_FOUND",
            }
        }
        /// Creates an enum from field names used in the ProtoBuf definition.
        pub fn from_str_name(value: &str) -> ::core::option::Option<Self> {
            match value {
                "REMOTE_ANALYSIS_CACHING_UNKNOWN" => {
                    Some(Self::RemoteAnalysisCachingUnknown)
                }
                "SERIALIZED_FRONTIER_PROFILE_FAILED" => {
                    Some(Self::SerializedFrontierProfileFailed)
                }
                "PROJECT_FILE_NOT_FOUND" => Some(Self::ProjectFileNotFound),
                _ => None,
            }
        }
    }
}
#[derive(Clone, Copy, PartialEq, ::prost::Message)]
pub struct PackageOptions {
    #[prost(enumeration = "package_options::Code", tag = "1")]
    pub code: i32,
}
/// Nested message and enum types in `PackageOptions`.
pub mod package_options {
    #[derive(
        Clone,
        Copy,
        Debug,
        PartialEq,
        Eq,
        Hash,
        PartialOrd,
        Ord,
        ::prost::Enumeration
    )]
    #[repr(i32)]
    pub enum Code {
        PackageOptionsUnknown = 0,
        PackagePathInvalid = 1,
        NonsingletonPackagePath = 4,
    }
    impl Code {
        /// String value of the enum field names used in the ProtoBuf definition.
        ///
        /// The values are not transformed in any way and thus are considered stable
        /// (if the ProtoBuf definition does not change) and safe for programmatic use.
        pub fn as_str_name(&self) -> &'static str {
            match self {
                Self::PackageOptionsUnknown => "PACKAGE_OPTIONS_UNKNOWN",
                Self::PackagePathInvalid => "PACKAGE_PATH_INVALID",
                Self::NonsingletonPackagePath => "NONSINGLETON_PACKAGE_PATH",
            }
        }
        /// Creates an enum from field names used in the ProtoBuf definition.
        pub fn from_str_name(value: &str) -> ::core::option::Option<Self> {
            match value {
                "PACKAGE_OPTIONS_UNKNOWN" => Some(Self::PackageOptionsUnknown),
                "PACKAGE_PATH_INVALID" => Some(Self::PackagePathInvalid),
                "NONSINGLETON_PACKAGE_PATH" => Some(Self::NonsingletonPackagePath),
                _ => None,
            }
        }
    }
}
#[derive(Clone, Copy, PartialEq, ::prost::Message)]
pub struct RemoteExecution {
    #[prost(enumeration = "remote_execution::Code", tag = "1")]
    pub code: i32,
}
/// Nested message and enum types in `RemoteExecution`.
pub mod remote_execution {
    /// The association of some of these options with exit code 2, "command line
    /// error", seems sketchy. Especially worth reconsidering are the channel init
    /// failure modes, which can correspond to failures occurring in gRPC setup.
    /// These all correspond with current Bazel behavior.
    #[derive(
        Clone,
        Copy,
        Debug,
        PartialEq,
        Eq,
        Hash,
        PartialOrd,
        Ord,
        ::prost::Enumeration
    )]
    #[repr(i32)]
    pub enum Code {
        RemoteExecutionUnknown = 0,
        CapabilitiesQueryFailure = 1,
        CredentialsInitFailure = 2,
        CacheInitFailure = 3,
        RpcLogFailure = 4,
        ExecChannelInitFailure = 5,
        CacheChannelInitFailure = 6,
        DownloaderChannelInitFailure = 7,
        LogDirCleanupFailure = 8,
        ClientServerIncompatible = 9,
        DownloadedInputsDeletionFailure = 10,
        RemoteDownloadOutputsMinimalWithoutInmemoryDotd = 11,
        RemoteDownloadOutputsMinimalWithoutInmemoryJdeps = 12,
        IncompleteOutputDownloadCleanupFailure = 13,
        RemoteDefaultPlatformPropertiesParseFailure = 14,
        IllegalOutput = 15,
        InvalidExecAndPlatformProperties = 16,
        ToplevelOutputsDownloadFailure = 17,
    }
    impl Code {
        /// String value of the enum field names used in the ProtoBuf definition.
        ///
        /// The values are not transformed in any way and thus are considered stable
        /// (if the ProtoBuf definition does not change) and safe for programmatic use.
        pub fn as_str_name(&self) -> &'static str {
            match self {
                Self::RemoteExecutionUnknown => "REMOTE_EXECUTION_UNKNOWN",
                Self::CapabilitiesQueryFailure => "CAPABILITIES_QUERY_FAILURE",
                Self::CredentialsInitFailure => "CREDENTIALS_INIT_FAILURE",
                Self::CacheInitFailure => "CACHE_INIT_FAILURE",
                Self::RpcLogFailure => "RPC_LOG_FAILURE",
                Self::ExecChannelInitFailure => "EXEC_CHANNEL_INIT_FAILURE",
                Self::CacheChannelInitFailure => "CACHE_CHANNEL_INIT_FAILURE",
                Self::DownloaderChannelInitFailure => "DOWNLOADER_CHANNEL_INIT_FAILURE",
                Self::LogDirCleanupFailure => "LOG_DIR_CLEANUP_FAILURE",
                Self::ClientServerIncompatible => "CLIENT_SERVER_INCOMPATIBLE",
                Self::DownloadedInputsDeletionFailure => {
                    "DOWNLOADED_INPUTS_DELETION_FAILURE"
                }
                Self::RemoteDownloadOutputsMinimalWithoutInmemoryDotd => {
                    "REMOTE_DOWNLOAD_OUTPUTS_MINIMAL_WITHOUT_INMEMORY_DOTD"
                }
                Self::RemoteDownloadOutputsMinimalWithoutInmemoryJdeps => {
                    "REMOTE_DOWNLOAD_OUTPUTS_MINIMAL_WITHOUT_INMEMORY_JDEPS"
                }
                Self::IncompleteOutputDownloadCleanupFailure => {
                    "INCOMPLETE_OUTPUT_DOWNLOAD_CLEANUP_FAILURE"
                }
                Self::RemoteDefaultPlatformPropertiesParseFailure => {
                    "REMOTE_DEFAULT_PLATFORM_PROPERTIES_PARSE_FAILURE"
                }
                Self::IllegalOutput => "ILLEGAL_OUTPUT",
                Self::InvalidExecAndPlatformProperties => {
                    "INVALID_EXEC_AND_PLATFORM_PROPERTIES"
                }
                Self::ToplevelOutputsDownloadFailure => {
                    "TOPLEVEL_OUTPUTS_DOWNLOAD_FAILURE"
                }
            }
        }
        /// Creates an enum from field names used in the ProtoBuf definition.
        pub fn from_str_name(value: &str) -> ::core::option::Option<Self> {
            match value {
                "REMOTE_EXECUTION_UNKNOWN" => Some(Self::RemoteExecutionUnknown),
                "CAPABILITIES_QUERY_FAILURE" => Some(Self::CapabilitiesQueryFailure),
                "CREDENTIALS_INIT_FAILURE" => Some(Self::CredentialsInitFailure),
                "CACHE_INIT_FAILURE" => Some(Self::CacheInitFailure),
                "RPC_LOG_FAILURE" => Some(Self::RpcLogFailure),
                "EXEC_CHANNEL_INIT_FAILURE" => Some(Self::ExecChannelInitFailure),
                "CACHE_CHANNEL_INIT_FAILURE" => Some(Self::CacheChannelInitFailure),
                "DOWNLOADER_CHANNEL_INIT_FAILURE" => {
                    Some(Self::DownloaderChannelInitFailure)
                }
                "LOG_DIR_CLEANUP_FAILURE" => Some(Self::LogDirCleanupFailure),
                "CLIENT_SERVER_INCOMPATIBLE" => Some(Self::ClientServerIncompatible),
                "DOWNLOADED_INPUTS_DELETION_FAILURE" => {
                    Some(Self::DownloadedInputsDeletionFailure)
                }
                "REMOTE_DOWNLOAD_OUTPUTS_MINIMAL_WITHOUT_INMEMORY_DOTD" => {
                    Some(Self::RemoteDownloadOutputsMinimalWithoutInmemoryDotd)
                }
                "REMOTE_DOWNLOAD_OUTPUTS_MINIMAL_WITHOUT_INMEMORY_JDEPS" => {
                    Some(Self::RemoteDownloadOutputsMinimalWithoutInmemoryJdeps)
                }
                "INCOMPLETE_OUTPUT_DOWNLOAD_CLEANUP_FAILURE" => {
                    Some(Self::IncompleteOutputDownloadCleanupFailure)
                }
                "REMOTE_DEFAULT_PLATFORM_PROPERTIES_PARSE_FAILURE" => {
                    Some(Self::RemoteDefaultPlatformPropertiesParseFailure)
                }
                "ILLEGAL_OUTPUT" => Some(Self::IllegalOutput),
                "INVALID_EXEC_AND_PLATFORM_PROPERTIES" => {
                    Some(Self::InvalidExecAndPlatformProperties)
                }
                "TOPLEVEL_OUTPUTS_DOWNLOAD_FAILURE" => {
                    Some(Self::ToplevelOutputsDownloadFailure)
                }
                _ => None,
            }
        }
    }
}
#[derive(Clone, Copy, PartialEq, ::prost::Message)]
pub struct Execution {
    #[prost(enumeration = "execution::Code", tag = "1")]
    pub code: i32,
}
/// Nested message and enum types in `Execution`.
pub mod execution {
    #[derive(
        Clone,
        Copy,
        Debug,
        PartialEq,
        Eq,
        Hash,
        PartialOrd,
        Ord,
        ::prost::Enumeration
    )]
    #[repr(i32)]
    pub enum Code {
        ExecutionUnknown = 0,
        ExecutionLogInitializationFailure = 1,
        ExecutionLogWriteFailure = 2,
        ExecrootCreationFailure = 3,
        TempActionOutputDirectoryDeletionFailure = 4,
        TempActionOutputDirectoryCreationFailure = 5,
        PersistentActionOutputDirectoryCreationFailure = 6,
        LocalOutputDirectorySymlinkFailure = 7,
        /// SOURCE_INPUT_MISSING
        LocalTemplateExpansionFailure = 9,
        InputDirectoryCheckIoException = 10,
        ExtraActionOutputCreationFailure = 11,
        TestRunnerIoException = 12,
        FileWriteIoException = 13,
        TestOutErrIoException = 14,
        SymlinkTreeManifestCopyIoException = 15,
        SymlinkTreeManifestLinkIoException = 16,
        SymlinkTreeCreationIoException = 17,
        SymlinkTreeCreationCommandException = 18,
        ActionInputReadIoException = 19,
        ActionNotUpToDate = 20,
        PseudoActionExecutionProhibited = 21,
        DiscoveredInputDoesNotExist = 22,
        ActionOutputsDeletionFailure = 23,
        ActionOutputsNotCreated = 24,
        ActionFinalizationFailure = 25,
        ActionInputLost = 26,
        FilesystemContextUpdateFailure = 27,
        ActionOutputCloseFailure = 28,
        InputDiscoveryIoException = 29,
        TreeArtifactDirectoryCreationFailure = 30,
        ActionOutputDirectoryCreationFailure = 31,
        ActionFsOutputDirectoryCreationFailure = 32,
        ActionFsOutErrDirectoryCreationFailure = 33,
        NonActionExecutionFailure = 34,
        Cycle = 35,
        SourceInputMissing = 36,
        UnexpectedException = 37,
        SourceInputIoException = 39,
        SymlinkTreeDeletionIoException = 40,
    }
    impl Code {
        /// String value of the enum field names used in the ProtoBuf definition.
        ///
        /// The values are not transformed in any way and thus are considered stable
        /// (if the ProtoBuf definition does not change) and safe for programmatic use.
        pub fn as_str_name(&self) -> &'static str {
            match self {
                Self::ExecutionUnknown => "EXECUTION_UNKNOWN",
                Self::ExecutionLogInitializationFailure => {
                    "EXECUTION_LOG_INITIALIZATION_FAILURE"
                }
                Self::ExecutionLogWriteFailure => "EXECUTION_LOG_WRITE_FAILURE",
                Self::ExecrootCreationFailure => "EXECROOT_CREATION_FAILURE",
                Self::TempActionOutputDirectoryDeletionFailure => {
                    "TEMP_ACTION_OUTPUT_DIRECTORY_DELETION_FAILURE"
                }
                Self::TempActionOutputDirectoryCreationFailure => {
                    "TEMP_ACTION_OUTPUT_DIRECTORY_CREATION_FAILURE"
                }
                Self::PersistentActionOutputDirectoryCreationFailure => {
                    "PERSISTENT_ACTION_OUTPUT_DIRECTORY_CREATION_FAILURE"
                }
                Self::LocalOutputDirectorySymlinkFailure => {
                    "LOCAL_OUTPUT_DIRECTORY_SYMLINK_FAILURE"
                }
                Self::LocalTemplateExpansionFailure => "LOCAL_TEMPLATE_EXPANSION_FAILURE",
                Self::InputDirectoryCheckIoException => {
                    "INPUT_DIRECTORY_CHECK_IO_EXCEPTION"
                }
                Self::ExtraActionOutputCreationFailure => {
                    "EXTRA_ACTION_OUTPUT_CREATION_FAILURE"
                }
                Self::TestRunnerIoException => "TEST_RUNNER_IO_EXCEPTION",
                Self::FileWriteIoException => "FILE_WRITE_IO_EXCEPTION",
                Self::TestOutErrIoException => "TEST_OUT_ERR_IO_EXCEPTION",
                Self::SymlinkTreeManifestCopyIoException => {
                    "SYMLINK_TREE_MANIFEST_COPY_IO_EXCEPTION"
                }
                Self::SymlinkTreeManifestLinkIoException => {
                    "SYMLINK_TREE_MANIFEST_LINK_IO_EXCEPTION"
                }
                Self::SymlinkTreeCreationIoException => {
                    "SYMLINK_TREE_CREATION_IO_EXCEPTION"
                }
                Self::SymlinkTreeCreationCommandException => {
                    "SYMLINK_TREE_CREATION_COMMAND_EXCEPTION"
                }
                Self::ActionInputReadIoException => "ACTION_INPUT_READ_IO_EXCEPTION",
                Self::ActionNotUpToDate => "ACTION_NOT_UP_TO_DATE",
                Self::PseudoActionExecutionProhibited => {
                    "PSEUDO_ACTION_EXECUTION_PROHIBITED"
                }
                Self::DiscoveredInputDoesNotExist => "DISCOVERED_INPUT_DOES_NOT_EXIST",
                Self::ActionOutputsDeletionFailure => "ACTION_OUTPUTS_DELETION_FAILURE",
                Self::ActionOutputsNotCreated => "ACTION_OUTPUTS_NOT_CREATED",
                Self::ActionFinalizationFailure => "ACTION_FINALIZATION_FAILURE",
                Self::ActionInputLost => "ACTION_INPUT_LOST",
                Self::FilesystemContextUpdateFailure => {
                    "FILESYSTEM_CONTEXT_UPDATE_FAILURE"
                }
                Self::ActionOutputCloseFailure => "ACTION_OUTPUT_CLOSE_FAILURE",
                Self::InputDiscoveryIoException => "INPUT_DISCOVERY_IO_EXCEPTION",
                Self::TreeArtifactDirectoryCreationFailure => {
                    "TREE_ARTIFACT_DIRECTORY_CREATION_FAILURE"
                }
                Self::ActionOutputDirectoryCreationFailure => {
                    "ACTION_OUTPUT_DIRECTORY_CREATION_FAILURE"
                }
                Self::ActionFsOutputDirectoryCreationFailure => {
                    "ACTION_FS_OUTPUT_DIRECTORY_CREATION_FAILURE"
                }
                Self::ActionFsOutErrDirectoryCreationFailure => {
                    "ACTION_FS_OUT_ERR_DIRECTORY_CREATION_FAILURE"
                }
                Self::NonActionExecutionFailure => "NON_ACTION_EXECUTION_FAILURE",
                Self::Cycle => "CYCLE",
                Self::SourceInputMissing => "SOURCE_INPUT_MISSING",
                Self::UnexpectedException => "UNEXPECTED_EXCEPTION",
                Self::SourceInputIoException => "SOURCE_INPUT_IO_EXCEPTION",
                Self::SymlinkTreeDeletionIoException => {
                    "SYMLINK_TREE_DELETION_IO_EXCEPTION"
                }
            }
        }
        /// Creates an enum from field names used in the ProtoBuf definition.
        pub fn from_str_name(value: &str) -> ::core::option::Option<Self> {
            match value {
                "EXECUTION_UNKNOWN" => Some(Self::ExecutionUnknown),
                "EXECUTION_LOG_INITIALIZATION_FAILURE" => {
                    Some(Self::ExecutionLogInitializationFailure)
                }
                "EXECUTION_LOG_WRITE_FAILURE" => Some(Self::ExecutionLogWriteFailure),
                "EXECROOT_CREATION_FAILURE" => Some(Self::ExecrootCreationFailure),
                "TEMP_ACTION_OUTPUT_DIRECTORY_DELETION_FAILURE" => {
                    Some(Self::TempActionOutputDirectoryDeletionFailure)
                }
                "TEMP_ACTION_OUTPUT_DIRECTORY_CREATION_FAILURE" => {
                    Some(Self::TempActionOutputDirectoryCreationFailure)
                }
                "PERSISTENT_ACTION_OUTPUT_DIRECTORY_CREATION_FAILURE" => {
                    Some(Self::PersistentActionOutputDirectoryCreationFailure)
                }
                "LOCAL_OUTPUT_DIRECTORY_SYMLINK_FAILURE" => {
                    Some(Self::LocalOutputDirectorySymlinkFailure)
                }
                "LOCAL_TEMPLATE_EXPANSION_FAILURE" => {
                    Some(Self::LocalTemplateExpansionFailure)
                }
                "INPUT_DIRECTORY_CHECK_IO_EXCEPTION" => {
                    Some(Self::InputDirectoryCheckIoException)
                }
                "EXTRA_ACTION_OUTPUT_CREATION_FAILURE" => {
                    Some(Self::ExtraActionOutputCreationFailure)
                }
                "TEST_RUNNER_IO_EXCEPTION" => Some(Self::TestRunnerIoException),
                "FILE_WRITE_IO_EXCEPTION" => Some(Self::FileWriteIoException),
                "TEST_OUT_ERR_IO_EXCEPTION" => Some(Self::TestOutErrIoException),
                "SYMLINK_TREE_MANIFEST_COPY_IO_EXCEPTION" => {
                    Some(Self::SymlinkTreeManifestCopyIoException)
                }
                "SYMLINK_TREE_MANIFEST_LINK_IO_EXCEPTION" => {
                    Some(Self::SymlinkTreeManifestLinkIoException)
                }
                "SYMLINK_TREE_CREATION_IO_EXCEPTION" => {
                    Some(Self::SymlinkTreeCreationIoException)
                }
                "SYMLINK_TREE_CREATION_COMMAND_EXCEPTION" => {
                    Some(Self::SymlinkTreeCreationCommandException)
                }
                "ACTION_INPUT_READ_IO_EXCEPTION" => {
                    Some(Self::ActionInputReadIoException)
                }
                "ACTION_NOT_UP_TO_DATE" => Some(Self::ActionNotUpToDate),
                "PSEUDO_ACTION_EXECUTION_PROHIBITED" => {
                    Some(Self::PseudoActionExecutionProhibited)
                }
                "DISCOVERED_INPUT_DOES_NOT_EXIST" => {
                    Some(Self::DiscoveredInputDoesNotExist)
                }
                "ACTION_OUTPUTS_DELETION_FAILURE" => {
                    Some(Self::ActionOutputsDeletionFailure)
                }
                "ACTION_OUTPUTS_NOT_CREATED" => Some(Self::ActionOutputsNotCreated),
                "ACTION_FINALIZATION_FAILURE" => Some(Self::ActionFinalizationFailure),
                "ACTION_INPUT_LOST" => Some(Self::ActionInputLost),
                "FILESYSTEM_CONTEXT_UPDATE_FAILURE" => {
                    Some(Self::FilesystemContextUpdateFailure)
                }
                "ACTION_OUTPUT_CLOSE_FAILURE" => Some(Self::ActionOutputCloseFailure),
                "INPUT_DISCOVERY_IO_EXCEPTION" => Some(Self::InputDiscoveryIoException),
                "TREE_ARTIFACT_DIRECTORY_CREATION_FAILURE" => {
                    Some(Self::TreeArtifactDirectoryCreationFailure)
                }
                "ACTION_OUTPUT_DIRECTORY_CREATION_FAILURE" => {
                    Some(Self::ActionOutputDirectoryCreationFailure)
                }
                "ACTION_FS_OUTPUT_DIRECTORY_CREATION_FAILURE" => {
                    Some(Self::ActionFsOutputDirectoryCreationFailure)
                }
                "ACTION_FS_OUT_ERR_DIRECTORY_CREATION_FAILURE" => {
                    Some(Self::ActionFsOutErrDirectoryCreationFailure)
                }
                "NON_ACTION_EXECUTION_FAILURE" => Some(Self::NonActionExecutionFailure),
                "CYCLE" => Some(Self::Cycle),
                "SOURCE_INPUT_MISSING" => Some(Self::SourceInputMissing),
                "UNEXPECTED_EXCEPTION" => Some(Self::UnexpectedException),
                "SOURCE_INPUT_IO_EXCEPTION" => Some(Self::SourceInputIoException),
                "SYMLINK_TREE_DELETION_IO_EXCEPTION" => {
                    Some(Self::SymlinkTreeDeletionIoException)
                }
                _ => None,
            }
        }
    }
}
/// Failure details about Bazel's WORKSPACE features.
#[derive(Clone, Copy, PartialEq, ::prost::Message)]
pub struct Workspaces {
    #[prost(enumeration = "workspaces::Code", tag = "1")]
    pub code: i32,
}
/// Nested message and enum types in `Workspaces`.
pub mod workspaces {
    #[derive(
        Clone,
        Copy,
        Debug,
        PartialEq,
        Eq,
        Hash,
        PartialOrd,
        Ord,
        ::prost::Enumeration
    )]
    #[repr(i32)]
    pub enum Code {
        WorkspacesUnknown = 0,
        WorkspacesLogInitializationFailure = 1,
        WorkspacesLogWriteFailure = 2,
        /// See `managed_directories` in
        /// <https://bazel.build/rules/lib/globals#workspace.>
        IllegalWorkspaceFileSymlinkWithManagedDirectories = 3,
        WorkspaceFileReadFailureWithManagedDirectories = 4,
    }
    impl Code {
        /// String value of the enum field names used in the ProtoBuf definition.
        ///
        /// The values are not transformed in any way and thus are considered stable
        /// (if the ProtoBuf definition does not change) and safe for programmatic use.
        pub fn as_str_name(&self) -> &'static str {
            match self {
                Self::WorkspacesUnknown => "WORKSPACES_UNKNOWN",
                Self::WorkspacesLogInitializationFailure => {
                    "WORKSPACES_LOG_INITIALIZATION_FAILURE"
                }
                Self::WorkspacesLogWriteFailure => "WORKSPACES_LOG_WRITE_FAILURE",
                Self::IllegalWorkspaceFileSymlinkWithManagedDirectories => {
                    "ILLEGAL_WORKSPACE_FILE_SYMLINK_WITH_MANAGED_DIRECTORIES"
                }
                Self::WorkspaceFileReadFailureWithManagedDirectories => {
                    "WORKSPACE_FILE_READ_FAILURE_WITH_MANAGED_DIRECTORIES"
                }
            }
        }
        /// Creates an enum from field names used in the ProtoBuf definition.
        pub fn from_str_name(value: &str) -> ::core::option::Option<Self> {
            match value {
                "WORKSPACES_UNKNOWN" => Some(Self::WorkspacesUnknown),
                "WORKSPACES_LOG_INITIALIZATION_FAILURE" => {
                    Some(Self::WorkspacesLogInitializationFailure)
                }
                "WORKSPACES_LOG_WRITE_FAILURE" => Some(Self::WorkspacesLogWriteFailure),
                "ILLEGAL_WORKSPACE_FILE_SYMLINK_WITH_MANAGED_DIRECTORIES" => {
                    Some(Self::IllegalWorkspaceFileSymlinkWithManagedDirectories)
                }
                "WORKSPACE_FILE_READ_FAILURE_WITH_MANAGED_DIRECTORIES" => {
                    Some(Self::WorkspaceFileReadFailureWithManagedDirectories)
                }
                _ => None,
            }
        }
    }
}
#[derive(Clone, Copy, PartialEq, ::prost::Message)]
pub struct CrashOptions {
    #[prost(enumeration = "crash_options::Code", tag = "1")]
    pub code: i32,
}
/// Nested message and enum types in `CrashOptions`.
pub mod crash_options {
    #[derive(
        Clone,
        Copy,
        Debug,
        PartialEq,
        Eq,
        Hash,
        PartialOrd,
        Ord,
        ::prost::Enumeration
    )]
    #[repr(i32)]
    pub enum Code {
        CrashOptionsUnknown = 0,
    }
    impl Code {
        /// String value of the enum field names used in the ProtoBuf definition.
        ///
        /// The values are not transformed in any way and thus are considered stable
        /// (if the ProtoBuf definition does not change) and safe for programmatic use.
        pub fn as_str_name(&self) -> &'static str {
            match self {
                Self::CrashOptionsUnknown => "CRASH_OPTIONS_UNKNOWN",
            }
        }
        /// Creates an enum from field names used in the ProtoBuf definition.
        pub fn from_str_name(value: &str) -> ::core::option::Option<Self> {
            match value {
                "CRASH_OPTIONS_UNKNOWN" => Some(Self::CrashOptionsUnknown),
                _ => None,
            }
        }
    }
}
#[derive(Clone, Copy, PartialEq, ::prost::Message)]
pub struct Filesystem {
    #[prost(enumeration = "filesystem::Code", tag = "1")]
    pub code: i32,
}
/// Nested message and enum types in `Filesystem`.
pub mod filesystem {
    #[derive(
        Clone,
        Copy,
        Debug,
        PartialEq,
        Eq,
        Hash,
        PartialOrd,
        Ord,
        ::prost::Enumeration
    )]
    #[repr(i32)]
    pub enum Code {
        FilesystemUnknown = 0,
        EmbeddedBinariesEnumerationFailure = 3,
        ServerPidTxtFileReadFailure = 4,
        ServerFileWriteFailure = 5,
        DefaultDigestHashFunctionInvalidValue = 6,
        FilesystemJniNotAvailable = 8,
    }
    impl Code {
        /// String value of the enum field names used in the ProtoBuf definition.
        ///
        /// The values are not transformed in any way and thus are considered stable
        /// (if the ProtoBuf definition does not change) and safe for programmatic use.
        pub fn as_str_name(&self) -> &'static str {
            match self {
                Self::FilesystemUnknown => "FILESYSTEM_UNKNOWN",
                Self::EmbeddedBinariesEnumerationFailure => {
                    "EMBEDDED_BINARIES_ENUMERATION_FAILURE"
                }
                Self::ServerPidTxtFileReadFailure => "SERVER_PID_TXT_FILE_READ_FAILURE",
                Self::ServerFileWriteFailure => "SERVER_FILE_WRITE_FAILURE",
                Self::DefaultDigestHashFunctionInvalidValue => {
                    "DEFAULT_DIGEST_HASH_FUNCTION_INVALID_VALUE"
                }
                Self::FilesystemJniNotAvailable => "FILESYSTEM_JNI_NOT_AVAILABLE",
            }
        }
        /// Creates an enum from field names used in the ProtoBuf definition.
        pub fn from_str_name(value: &str) -> ::core::option::Option<Self> {
            match value {
                "FILESYSTEM_UNKNOWN" => Some(Self::FilesystemUnknown),
                "EMBEDDED_BINARIES_ENUMERATION_FAILURE" => {
                    Some(Self::EmbeddedBinariesEnumerationFailure)
                }
                "SERVER_PID_TXT_FILE_READ_FAILURE" => {
                    Some(Self::ServerPidTxtFileReadFailure)
                }
                "SERVER_FILE_WRITE_FAILURE" => Some(Self::ServerFileWriteFailure),
                "DEFAULT_DIGEST_HASH_FUNCTION_INVALID_VALUE" => {
                    Some(Self::DefaultDigestHashFunctionInvalidValue)
                }
                "FILESYSTEM_JNI_NOT_AVAILABLE" => Some(Self::FilesystemJniNotAvailable),
                _ => None,
            }
        }
    }
}
#[derive(Clone, Copy, PartialEq, ::prost::Message)]
pub struct ExecutionOptions {
    #[prost(enumeration = "execution_options::Code", tag = "1")]
    pub code: i32,
}
/// Nested message and enum types in `ExecutionOptions`.
pub mod execution_options {
    /// All numerical exit code associations correspond to pre-existing Bazel
    /// behavior. These associations are suspicious:
    /// - REQUESTED_STRATEGY_INCOMPATIBLE_WITH_SANDBOXING (instead: 2?)
    /// - DEPRECATED_LOCAL_RESOURCES_USED (instead: 2?)
    /// TODO(b/138456686): Revise these after the (intentionally non-breaking)
    ///   initial rollout of FailureDetail-based encoding.
    #[derive(
        Clone,
        Copy,
        Debug,
        PartialEq,
        Eq,
        Hash,
        PartialOrd,
        Ord,
        ::prost::Enumeration
    )]
    #[repr(i32)]
    pub enum Code {
        ExecutionOptionsUnknown = 0,
        InvalidStrategy = 3,
        RequestedStrategyIncompatibleWithSandboxing = 4,
        DeprecatedLocalResourcesUsed = 5,
        InvalidCyclicDynamicStrategy = 6,
        RestrictionUnmatchedToActionContext = 7,
        RemoteFallbackStrategyNotAbstractSpawn = 8,
        StrategyNotFound = 9,
        DynamicStrategyNotSandboxed = 10,
        MultipleExecutionLogFormats = 11,
    }
    impl Code {
        /// String value of the enum field names used in the ProtoBuf definition.
        ///
        /// The values are not transformed in any way and thus are considered stable
        /// (if the ProtoBuf definition does not change) and safe for programmatic use.
        pub fn as_str_name(&self) -> &'static str {
            match self {
                Self::ExecutionOptionsUnknown => "EXECUTION_OPTIONS_UNKNOWN",
                Self::InvalidStrategy => "INVALID_STRATEGY",
                Self::RequestedStrategyIncompatibleWithSandboxing => {
                    "REQUESTED_STRATEGY_INCOMPATIBLE_WITH_SANDBOXING"
                }
                Self::DeprecatedLocalResourcesUsed => "DEPRECATED_LOCAL_RESOURCES_USED",
                Self::InvalidCyclicDynamicStrategy => "INVALID_CYCLIC_DYNAMIC_STRATEGY",
                Self::RestrictionUnmatchedToActionContext => {
                    "RESTRICTION_UNMATCHED_TO_ACTION_CONTEXT"
                }
                Self::RemoteFallbackStrategyNotAbstractSpawn => {
                    "REMOTE_FALLBACK_STRATEGY_NOT_ABSTRACT_SPAWN"
                }
                Self::StrategyNotFound => "STRATEGY_NOT_FOUND",
                Self::DynamicStrategyNotSandboxed => "DYNAMIC_STRATEGY_NOT_SANDBOXED",
                Self::MultipleExecutionLogFormats => "MULTIPLE_EXECUTION_LOG_FORMATS",
            }
        }
        /// Creates an enum from field names used in the ProtoBuf definition.
        pub fn from_str_name(value: &str) -> ::core::option::Option<Self> {
            match value {
                "EXECUTION_OPTIONS_UNKNOWN" => Some(Self::ExecutionOptionsUnknown),
                "INVALID_STRATEGY" => Some(Self::InvalidStrategy),
                "REQUESTED_STRATEGY_INCOMPATIBLE_WITH_SANDBOXING" => {
                    Some(Self::RequestedStrategyIncompatibleWithSandboxing)
                }
                "DEPRECATED_LOCAL_RESOURCES_USED" => {
                    Some(Self::DeprecatedLocalResourcesUsed)
                }
                "INVALID_CYCLIC_DYNAMIC_STRATEGY" => {
                    Some(Self::InvalidCyclicDynamicStrategy)
                }
                "RESTRICTION_UNMATCHED_TO_ACTION_CONTEXT" => {
                    Some(Self::RestrictionUnmatchedToActionContext)
                }
                "REMOTE_FALLBACK_STRATEGY_NOT_ABSTRACT_SPAWN" => {
                    Some(Self::RemoteFallbackStrategyNotAbstractSpawn)
                }
                "STRATEGY_NOT_FOUND" => Some(Self::StrategyNotFound),
                "DYNAMIC_STRATEGY_NOT_SANDBOXED" => {
                    Some(Self::DynamicStrategyNotSandboxed)
                }
                "MULTIPLE_EXECUTION_LOG_FORMATS" => {
                    Some(Self::MultipleExecutionLogFormats)
                }
                _ => None,
            }
        }
    }
}
#[derive(Clone, Copy, PartialEq, ::prost::Message)]
pub struct Command {
    #[prost(enumeration = "command::Code", tag = "1")]
    pub code: i32,
}
/// Nested message and enum types in `Command`.
pub mod command {
    #[derive(
        Clone,
        Copy,
        Debug,
        PartialEq,
        Eq,
        Hash,
        PartialOrd,
        Ord,
        ::prost::Enumeration
    )]
    #[repr(i32)]
    pub enum Code {
        /// The name "COMMAND_UNKNOWN" might reasonably be interpreted as "command
        /// not found". The enum's default value should represent a lack of knowledge
        /// about the failure instead.
        CommandFailureUnknown = 0,
        CommandNotFound = 1,
        AnotherCommandRunning = 2,
        PreviouslyShutdown = 3,
        StarlarkCpuProfileFileInitializationFailure = 4,
        StarlarkCpuProfilingInitializationFailure = 5,
        StarlarkCpuProfileFileWriteFailure = 6,
        InvocationPolicyParseFailure = 7,
        InvocationPolicyInvalid = 8,
        OptionsParseFailure = 9,
        StarlarkOptionsParseFailure = 10,
        ArgumentsNotRecognized = 11,
        NotInWorkspace = 12,
        InOutputDirectory = 14,
    }
    impl Code {
        /// String value of the enum field names used in the ProtoBuf definition.
        ///
        /// The values are not transformed in any way and thus are considered stable
        /// (if the ProtoBuf definition does not change) and safe for programmatic use.
        pub fn as_str_name(&self) -> &'static str {
            match self {
                Self::CommandFailureUnknown => "COMMAND_FAILURE_UNKNOWN",
                Self::CommandNotFound => "COMMAND_NOT_FOUND",
                Self::AnotherCommandRunning => "ANOTHER_COMMAND_RUNNING",
                Self::PreviouslyShutdown => "PREVIOUSLY_SHUTDOWN",
                Self::StarlarkCpuProfileFileInitializationFailure => {
                    "STARLARK_CPU_PROFILE_FILE_INITIALIZATION_FAILURE"
                }
                Self::StarlarkCpuProfilingInitializationFailure => {
                    "STARLARK_CPU_PROFILING_INITIALIZATION_FAILURE"
                }
                Self::StarlarkCpuProfileFileWriteFailure => {
                    "STARLARK_CPU_PROFILE_FILE_WRITE_FAILURE"
                }
                Self::InvocationPolicyParseFailure => "INVOCATION_POLICY_PARSE_FAILURE",
                Self::InvocationPolicyInvalid => "INVOCATION_POLICY_INVALID",
                Self::OptionsParseFailure => "OPTIONS_PARSE_FAILURE",
                Self::StarlarkOptionsParseFailure => "STARLARK_OPTIONS_PARSE_FAILURE",
                Self::ArgumentsNotRecognized => "ARGUMENTS_NOT_RECOGNIZED",
                Self::NotInWorkspace => "NOT_IN_WORKSPACE",
                Self::InOutputDirectory => "IN_OUTPUT_DIRECTORY",
            }
        }
        /// Creates an enum from field names used in the ProtoBuf definition.
        pub fn from_str_name(value: &str) -> ::core::option::Option<Self> {
            match value {
                "COMMAND_FAILURE_UNKNOWN" => Some(Self::CommandFailureUnknown),
                "COMMAND_NOT_FOUND" => Some(Self::CommandNotFound),
                "ANOTHER_COMMAND_RUNNING" => Some(Self::AnotherCommandRunning),
                "PREVIOUSLY_SHUTDOWN" => Some(Self::PreviouslyShutdown),
                "STARLARK_CPU_PROFILE_FILE_INITIALIZATION_FAILURE" => {
                    Some(Self::StarlarkCpuProfileFileInitializationFailure)
                }
                "STARLARK_CPU_PROFILING_INITIALIZATION_FAILURE" => {
                    Some(Self::StarlarkCpuProfilingInitializationFailure)
                }
                "STARLARK_CPU_PROFILE_FILE_WRITE_FAILURE" => {
                    Some(Self::StarlarkCpuProfileFileWriteFailure)
                }
                "INVOCATION_POLICY_PARSE_FAILURE" => {
                    Some(Self::InvocationPolicyParseFailure)
                }
                "INVOCATION_POLICY_INVALID" => Some(Self::InvocationPolicyInvalid),
                "OPTIONS_PARSE_FAILURE" => Some(Self::OptionsParseFailure),
                "STARLARK_OPTIONS_PARSE_FAILURE" => {
                    Some(Self::StarlarkOptionsParseFailure)
                }
                "ARGUMENTS_NOT_RECOGNIZED" => Some(Self::ArgumentsNotRecognized),
                "NOT_IN_WORKSPACE" => Some(Self::NotInWorkspace),
                "IN_OUTPUT_DIRECTORY" => Some(Self::InOutputDirectory),
                _ => None,
            }
        }
    }
}
#[derive(Clone, Copy, PartialEq, ::prost::Message)]
pub struct GrpcServer {
    #[prost(enumeration = "grpc_server::Code", tag = "1")]
    pub code: i32,
}
/// Nested message and enum types in `GrpcServer`.
pub mod grpc_server {
    #[derive(
        Clone,
        Copy,
        Debug,
        PartialEq,
        Eq,
        Hash,
        PartialOrd,
        Ord,
        ::prost::Enumeration
    )]
    #[repr(i32)]
    pub enum Code {
        GrpcServerUnknown = 0,
        GrpcServerNotCompiledIn = 1,
        ServerBindFailure = 2,
        BadCookie = 3,
        NoClientDescription = 4,
    }
    impl Code {
        /// String value of the enum field names used in the ProtoBuf definition.
        ///
        /// The values are not transformed in any way and thus are considered stable
        /// (if the ProtoBuf definition does not change) and safe for programmatic use.
        pub fn as_str_name(&self) -> &'static str {
            match self {
                Self::GrpcServerUnknown => "GRPC_SERVER_UNKNOWN",
                Self::GrpcServerNotCompiledIn => "GRPC_SERVER_NOT_COMPILED_IN",
                Self::ServerBindFailure => "SERVER_BIND_FAILURE",
                Self::BadCookie => "BAD_COOKIE",
                Self::NoClientDescription => "NO_CLIENT_DESCRIPTION",
            }
        }
        /// Creates an enum from field names used in the ProtoBuf definition.
        pub fn from_str_name(value: &str) -> ::core::option::Option<Self> {
            match value {
                "GRPC_SERVER_UNKNOWN" => Some(Self::GrpcServerUnknown),
                "GRPC_SERVER_NOT_COMPILED_IN" => Some(Self::GrpcServerNotCompiledIn),
                "SERVER_BIND_FAILURE" => Some(Self::ServerBindFailure),
                "BAD_COOKIE" => Some(Self::BadCookie),
                "NO_CLIENT_DESCRIPTION" => Some(Self::NoClientDescription),
                _ => None,
            }
        }
    }
}
#[derive(Clone, Copy, PartialEq, ::prost::Message)]
pub struct CanonicalizeFlags {
    #[prost(enumeration = "canonicalize_flags::Code", tag = "1")]
    pub code: i32,
}
/// Nested message and enum types in `CanonicalizeFlags`.
pub mod canonicalize_flags {
    #[derive(
        Clone,
        Copy,
        Debug,
        PartialEq,
        Eq,
        Hash,
        PartialOrd,
        Ord,
        ::prost::Enumeration
    )]
    #[repr(i32)]
    pub enum Code {
        CanonicalizeFlagsUnknown = 0,
        ForCommandInvalid = 1,
    }
    impl Code {
        /// String value of the enum field names used in the ProtoBuf definition.
        ///
        /// The values are not transformed in any way and thus are considered stable
        /// (if the ProtoBuf definition does not change) and safe for programmatic use.
        pub fn as_str_name(&self) -> &'static str {
            match self {
                Self::CanonicalizeFlagsUnknown => "CANONICALIZE_FLAGS_UNKNOWN",
                Self::ForCommandInvalid => "FOR_COMMAND_INVALID",
            }
        }
        /// Creates an enum from field names used in the ProtoBuf definition.
        pub fn from_str_name(value: &str) -> ::core::option::Option<Self> {
            match value {
                "CANONICALIZE_FLAGS_UNKNOWN" => Some(Self::CanonicalizeFlagsUnknown),
                "FOR_COMMAND_INVALID" => Some(Self::ForCommandInvalid),
                _ => None,
            }
        }
    }
}
/// Failure modes described by this category pertain to the Bazel invocation
/// configuration consumed by Bazel's analysis phase. This category is not
/// intended as a grab-bag for all Bazel flag value constraint violations, which
/// instead generally belong in the category for the subsystem whose flag values
/// participate in the constraint.
#[derive(Clone, Copy, PartialEq, ::prost::Message)]
pub struct BuildConfiguration {
    #[prost(enumeration = "build_configuration::Code", tag = "1")]
    pub code: i32,
}
/// Nested message and enum types in `BuildConfiguration`.
pub mod build_configuration {
    #[derive(
        Clone,
        Copy,
        Debug,
        PartialEq,
        Eq,
        Hash,
        PartialOrd,
        Ord,
        ::prost::Enumeration
    )]
    #[repr(i32)]
    pub enum Code {
        BuildConfigurationUnknown = 0,
        PlatformMappingEvaluationFailure = 1,
        PlatformMappingsFileIsDirectory = 2,
        PlatformMappingsFileNotFound = 3,
        TopLevelConfigurationCreationFailure = 4,
        InvalidConfiguration = 5,
        InvalidBuildOptions = 6,
        MultiCpuPrereqUnmet = 7,
        HeuristicInstrumentationFilterInvalid = 8,
        Cycle = 9,
        ConflictingConfigurations = 10,
        /// This can come from either an invalid user-specified option or a
        /// configuration transition. There's no sure-fire way to distinguish the two
        /// possibilities in Bazel, so we go with the more straightforward
        /// command-line error exit code 2.
        InvalidOutputDirectoryMnemonic = 11,
        ConfigurationDiscardedAnalysisCache = 12,
        /// Failure modes specific to PROJECT.scl files.
        InvalidProject = 13,
    }
    impl Code {
        /// String value of the enum field names used in the ProtoBuf definition.
        ///
        /// The values are not transformed in any way and thus are considered stable
        /// (if the ProtoBuf definition does not change) and safe for programmatic use.
        pub fn as_str_name(&self) -> &'static str {
            match self {
                Self::BuildConfigurationUnknown => "BUILD_CONFIGURATION_UNKNOWN",
                Self::PlatformMappingEvaluationFailure => {
                    "PLATFORM_MAPPING_EVALUATION_FAILURE"
                }
                Self::PlatformMappingsFileIsDirectory => {
                    "PLATFORM_MAPPINGS_FILE_IS_DIRECTORY"
                }
                Self::PlatformMappingsFileNotFound => "PLATFORM_MAPPINGS_FILE_NOT_FOUND",
                Self::TopLevelConfigurationCreationFailure => {
                    "TOP_LEVEL_CONFIGURATION_CREATION_FAILURE"
                }
                Self::InvalidConfiguration => "INVALID_CONFIGURATION",
                Self::InvalidBuildOptions => "INVALID_BUILD_OPTIONS",
                Self::MultiCpuPrereqUnmet => "MULTI_CPU_PREREQ_UNMET",
                Self::HeuristicInstrumentationFilterInvalid => {
                    "HEURISTIC_INSTRUMENTATION_FILTER_INVALID"
                }
                Self::Cycle => "CYCLE",
                Self::ConflictingConfigurations => "CONFLICTING_CONFIGURATIONS",
                Self::InvalidOutputDirectoryMnemonic => {
                    "INVALID_OUTPUT_DIRECTORY_MNEMONIC"
                }
                Self::ConfigurationDiscardedAnalysisCache => {
                    "CONFIGURATION_DISCARDED_ANALYSIS_CACHE"
                }
                Self::InvalidProject => "INVALID_PROJECT",
            }
        }
        /// Creates an enum from field names used in the ProtoBuf definition.
        pub fn from_str_name(value: &str) -> ::core::option::Option<Self> {
            match value {
                "BUILD_CONFIGURATION_UNKNOWN" => Some(Self::BuildConfigurationUnknown),
                "PLATFORM_MAPPING_EVALUATION_FAILURE" => {
                    Some(Self::PlatformMappingEvaluationFailure)
                }
                "PLATFORM_MAPPINGS_FILE_IS_DIRECTORY" => {
                    Some(Self::PlatformMappingsFileIsDirectory)
                }
                "PLATFORM_MAPPINGS_FILE_NOT_FOUND" => {
                    Some(Self::PlatformMappingsFileNotFound)
                }
                "TOP_LEVEL_CONFIGURATION_CREATION_FAILURE" => {
                    Some(Self::TopLevelConfigurationCreationFailure)
                }
                "INVALID_CONFIGURATION" => Some(Self::InvalidConfiguration),
                "INVALID_BUILD_OPTIONS" => Some(Self::InvalidBuildOptions),
                "MULTI_CPU_PREREQ_UNMET" => Some(Self::MultiCpuPrereqUnmet),
                "HEURISTIC_INSTRUMENTATION_FILTER_INVALID" => {
                    Some(Self::HeuristicInstrumentationFilterInvalid)
                }
                "CYCLE" => Some(Self::Cycle),
                "CONFLICTING_CONFIGURATIONS" => Some(Self::ConflictingConfigurations),
                "INVALID_OUTPUT_DIRECTORY_MNEMONIC" => {
                    Some(Self::InvalidOutputDirectoryMnemonic)
                }
                "CONFIGURATION_DISCARDED_ANALYSIS_CACHE" => {
                    Some(Self::ConfigurationDiscardedAnalysisCache)
                }
                "INVALID_PROJECT" => Some(Self::InvalidProject),
                _ => None,
            }
        }
    }
}
#[derive(Clone, Copy, PartialEq, ::prost::Message)]
pub struct InfoCommand {
    #[prost(enumeration = "info_command::Code", tag = "1")]
    pub code: i32,
}
/// Nested message and enum types in `InfoCommand`.
pub mod info_command {
    /// The distinction between a failure to write a single info item and a failure
    /// to write them all seems sketchy. Why do they have different exit codes?
    /// This reflects current Bazel behavior, but deserves more thought.
    #[derive(
        Clone,
        Copy,
        Debug,
        PartialEq,
        Eq,
        Hash,
        PartialOrd,
        Ord,
        ::prost::Enumeration
    )]
    #[repr(i32)]
    pub enum Code {
        InfoCommandUnknown = 0,
        TooManyKeys = 1,
        KeyNotRecognized = 2,
        InfoBlockWriteFailure = 3,
        AllInfoWriteFailure = 4,
    }
    impl Code {
        /// String value of the enum field names used in the ProtoBuf definition.
        ///
        /// The values are not transformed in any way and thus are considered stable
        /// (if the ProtoBuf definition does not change) and safe for programmatic use.
        pub fn as_str_name(&self) -> &'static str {
            match self {
                Self::InfoCommandUnknown => "INFO_COMMAND_UNKNOWN",
                Self::TooManyKeys => "TOO_MANY_KEYS",
                Self::KeyNotRecognized => "KEY_NOT_RECOGNIZED",
                Self::InfoBlockWriteFailure => "INFO_BLOCK_WRITE_FAILURE",
                Self::AllInfoWriteFailure => "ALL_INFO_WRITE_FAILURE",
            }
        }
        /// Creates an enum from field names used in the ProtoBuf definition.
        pub fn from_str_name(value: &str) -> ::core::option::Option<Self> {
            match value {
                "INFO_COMMAND_UNKNOWN" => Some(Self::InfoCommandUnknown),
                "TOO_MANY_KEYS" => Some(Self::TooManyKeys),
                "KEY_NOT_RECOGNIZED" => Some(Self::KeyNotRecognized),
                "INFO_BLOCK_WRITE_FAILURE" => Some(Self::InfoBlockWriteFailure),
                "ALL_INFO_WRITE_FAILURE" => Some(Self::AllInfoWriteFailure),
                _ => None,
            }
        }
    }
}
#[derive(Clone, Copy, PartialEq, ::prost::Message)]
pub struct MemoryOptions {
    #[prost(enumeration = "memory_options::Code", tag = "1")]
    pub code: i32,
}
/// Nested message and enum types in `MemoryOptions`.
pub mod memory_options {
    #[derive(
        Clone,
        Copy,
        Debug,
        PartialEq,
        Eq,
        Hash,
        PartialOrd,
        Ord,
        ::prost::Enumeration
    )]
    #[repr(i32)]
    pub enum Code {
        MemoryOptionsUnknown = 0,
        /// Deprecated: validation is now implemented by the option converter.
        DeprecatedExperimentalOomMoreEagerlyThresholdInvalidValue = 1,
        /// Deprecated: no tenured collectors found is now a crash on startup.
        DeprecatedExperimentalOomMoreEagerlyNoTenuredCollectorsFound = 2,
    }
    impl Code {
        /// String value of the enum field names used in the ProtoBuf definition.
        ///
        /// The values are not transformed in any way and thus are considered stable
        /// (if the ProtoBuf definition does not change) and safe for programmatic use.
        pub fn as_str_name(&self) -> &'static str {
            match self {
                Self::MemoryOptionsUnknown => "MEMORY_OPTIONS_UNKNOWN",
                Self::DeprecatedExperimentalOomMoreEagerlyThresholdInvalidValue => {
                    "DEPRECATED_EXPERIMENTAL_OOM_MORE_EAGERLY_THRESHOLD_INVALID_VALUE"
                }
                Self::DeprecatedExperimentalOomMoreEagerlyNoTenuredCollectorsFound => {
                    "DEPRECATED_EXPERIMENTAL_OOM_MORE_EAGERLY_NO_TENURED_COLLECTORS_FOUND"
                }
            }
        }
        /// Creates an enum from field names used in the ProtoBuf definition.
        pub fn from_str_name(value: &str) -> ::core::option::Option<Self> {
            match value {
                "MEMORY_OPTIONS_UNKNOWN" => Some(Self::MemoryOptionsUnknown),
                "DEPRECATED_EXPERIMENTAL_OOM_MORE_EAGERLY_THRESHOLD_INVALID_VALUE" => {
                    Some(Self::DeprecatedExperimentalOomMoreEagerlyThresholdInvalidValue)
                }
                "DEPRECATED_EXPERIMENTAL_OOM_MORE_EAGERLY_NO_TENURED_COLLECTORS_FOUND" => {
                    Some(
                        Self::DeprecatedExperimentalOomMoreEagerlyNoTenuredCollectorsFound,
                    )
                }
                _ => None,
            }
        }
    }
}
#[derive(Clone, Copy, PartialEq, ::prost::Message)]
pub struct Query {
    #[prost(enumeration = "query::Code", tag = "1")]
    pub code: i32,
}
/// Nested message and enum types in `Query`.
pub mod query {
    #[derive(
        Clone,
        Copy,
        Debug,
        PartialEq,
        Eq,
        Hash,
        PartialOrd,
        Ord,
        ::prost::Enumeration
    )]
    #[repr(i32)]
    pub enum Code {
        QueryUnknown = 0,
        QueryFileWithCommandLineExpression = 1,
        QueryFileReadFailure = 2,
        CommandLineExpressionMissing = 3,
        OutputFormatInvalid = 4,
        GraphlessPrereqUnmet = 5,
        QueryOutputWriteFailure = 6,
        QueryStdoutFlushFailure = 13,
        AnalysisQueryPrereqUnmet = 14,
        QueryResultsFlushFailure = 15,
        /// Deprecated - folded into SYNTAX_ERROR.
        DeprecatedUnclosedQuotationExpressionError = 16,
        VariableNameInvalid = 17,
        VariableUndefined = 18,
        BuildfilesAndLoadfilesCannotUseOutputLocationError = 19,
        BuildFileError = 20,
        Cycle = 21,
        UniqueSkykeyThresholdExceeded = 22,
        TargetNotInUniverseScope = 23,
        InvalidFullUniverseExpression = 24,
        UniverseScopeLimitExceeded = 25,
        InvalidationLimitExceeded = 26,
        OutputFormatPrereqUnmet = 27,
        ArgumentsMissing = 28,
        RbuildfilesFunctionRequiresSkyquery = 29,
        FullTargetsNotSupported = 30,
        /// Deprecated - folded into SYNTAX_ERROR.
        DeprecatedUnexpectedTokenError = 31,
        /// Deprecated - folded into SYNTAX_ERROR.
        DeprecatedIntegerLiteralMissing = 32,
        /// Deprecated - folded into SYNTAX_ERROR.
        DeprecatedInvalidStartingCharacterError = 33,
        /// Deprecated - folded into SYNTAX_ERROR.
        DeprecatedPrematureEndOfInputError = 34,
        /// Indicates the user specified invalid query syntax.
        SyntaxError = 35,
        OutputFormatterIoException = 36,
        SkyqueryTransitiveTargetError = 37,
        SkyqueryTargetException = 38,
        InvalidLabelInTestSuite = 39,
        /// Indicates any usage of flags that must not be combined.
        IllegalFlagCombination = 40,
        /// Indicates a non-detailed exception that halted a query. This is a
        /// deficiency in Blaze/Bazel and code should be changed to attach a detailed
        /// exit code to this failure mode.
        NonDetailedError = 41,
    }
    impl Code {
        /// String value of the enum field names used in the ProtoBuf definition.
        ///
        /// The values are not transformed in any way and thus are considered stable
        /// (if the ProtoBuf definition does not change) and safe for programmatic use.
        pub fn as_str_name(&self) -> &'static str {
            match self {
                Self::QueryUnknown => "QUERY_UNKNOWN",
                Self::QueryFileWithCommandLineExpression => {
                    "QUERY_FILE_WITH_COMMAND_LINE_EXPRESSION"
                }
                Self::QueryFileReadFailure => "QUERY_FILE_READ_FAILURE",
                Self::CommandLineExpressionMissing => "COMMAND_LINE_EXPRESSION_MISSING",
                Self::OutputFormatInvalid => "OUTPUT_FORMAT_INVALID",
                Self::GraphlessPrereqUnmet => "GRAPHLESS_PREREQ_UNMET",
                Self::QueryOutputWriteFailure => "QUERY_OUTPUT_WRITE_FAILURE",
                Self::QueryStdoutFlushFailure => "QUERY_STDOUT_FLUSH_FAILURE",
                Self::AnalysisQueryPrereqUnmet => "ANALYSIS_QUERY_PREREQ_UNMET",
                Self::QueryResultsFlushFailure => "QUERY_RESULTS_FLUSH_FAILURE",
                Self::DeprecatedUnclosedQuotationExpressionError => {
                    "DEPRECATED_UNCLOSED_QUOTATION_EXPRESSION_ERROR"
                }
                Self::VariableNameInvalid => "VARIABLE_NAME_INVALID",
                Self::VariableUndefined => "VARIABLE_UNDEFINED",
                Self::BuildfilesAndLoadfilesCannotUseOutputLocationError => {
                    "BUILDFILES_AND_LOADFILES_CANNOT_USE_OUTPUT_LOCATION_ERROR"
                }
                Self::BuildFileError => "BUILD_FILE_ERROR",
                Self::Cycle => "CYCLE",
                Self::UniqueSkykeyThresholdExceeded => "UNIQUE_SKYKEY_THRESHOLD_EXCEEDED",
                Self::TargetNotInUniverseScope => "TARGET_NOT_IN_UNIVERSE_SCOPE",
                Self::InvalidFullUniverseExpression => "INVALID_FULL_UNIVERSE_EXPRESSION",
                Self::UniverseScopeLimitExceeded => "UNIVERSE_SCOPE_LIMIT_EXCEEDED",
                Self::InvalidationLimitExceeded => "INVALIDATION_LIMIT_EXCEEDED",
                Self::OutputFormatPrereqUnmet => "OUTPUT_FORMAT_PREREQ_UNMET",
                Self::ArgumentsMissing => "ARGUMENTS_MISSING",
                Self::RbuildfilesFunctionRequiresSkyquery => {
                    "RBUILDFILES_FUNCTION_REQUIRES_SKYQUERY"
                }
                Self::FullTargetsNotSupported => "FULL_TARGETS_NOT_SUPPORTED",
                Self::DeprecatedUnexpectedTokenError => {
                    "DEPRECATED_UNEXPECTED_TOKEN_ERROR"
                }
                Self::DeprecatedIntegerLiteralMissing => {
                    "DEPRECATED_INTEGER_LITERAL_MISSING"
                }
                Self::DeprecatedInvalidStartingCharacterError => {
                    "DEPRECATED_INVALID_STARTING_CHARACTER_ERROR"
                }
                Self::DeprecatedPrematureEndOfInputError => {
                    "DEPRECATED_PREMATURE_END_OF_INPUT_ERROR"
                }
                Self::SyntaxError => "SYNTAX_ERROR",
                Self::OutputFormatterIoException => "OUTPUT_FORMATTER_IO_EXCEPTION",
                Self::SkyqueryTransitiveTargetError => "SKYQUERY_TRANSITIVE_TARGET_ERROR",
                Self::SkyqueryTargetException => "SKYQUERY_TARGET_EXCEPTION",
                Self::InvalidLabelInTestSuite => "INVALID_LABEL_IN_TEST_SUITE",
                Self::IllegalFlagCombination => "ILLEGAL_FLAG_COMBINATION",
                Self::NonDetailedError => "NON_DETAILED_ERROR",
            }
        }
        /// Creates an enum from field names used in the ProtoBuf definition.
        pub fn from_str_name(value: &str) -> ::core::option::Option<Self> {
            match value {
                "QUERY_UNKNOWN" => Some(Self::QueryUnknown),
                "QUERY_FILE_WITH_COMMAND_LINE_EXPRESSION" => {
                    Some(Self::QueryFileWithCommandLineExpression)
                }
                "QUERY_FILE_READ_FAILURE" => Some(Self::QueryFileReadFailure),
                "COMMAND_LINE_EXPRESSION_MISSING" => {
                    Some(Self::CommandLineExpressionMissing)
                }
                "OUTPUT_FORMAT_INVALID" => Some(Self::OutputFormatInvalid),
                "GRAPHLESS_PREREQ_UNMET" => Some(Self::GraphlessPrereqUnmet),
                "QUERY_OUTPUT_WRITE_FAILURE" => Some(Self::QueryOutputWriteFailure),
                "QUERY_STDOUT_FLUSH_FAILURE" => Some(Self::QueryStdoutFlushFailure),
                "ANALYSIS_QUERY_PREREQ_UNMET" => Some(Self::AnalysisQueryPrereqUnmet),
                "QUERY_RESULTS_FLUSH_FAILURE" => Some(Self::QueryResultsFlushFailure),
                "DEPRECATED_UNCLOSED_QUOTATION_EXPRESSION_ERROR" => {
                    Some(Self::DeprecatedUnclosedQuotationExpressionError)
                }
                "VARIABLE_NAME_INVALID" => Some(Self::VariableNameInvalid),
                "VARIABLE_UNDEFINED" => Some(Self::VariableUndefined),
                "BUILDFILES_AND_LOADFILES_CANNOT_USE_OUTPUT_LOCATION_ERROR" => {
                    Some(Self::BuildfilesAndLoadfilesCannotUseOutputLocationError)
                }
                "BUILD_FILE_ERROR" => Some(Self::BuildFileError),
                "CYCLE" => Some(Self::Cycle),
                "UNIQUE_SKYKEY_THRESHOLD_EXCEEDED" => {
                    Some(Self::UniqueSkykeyThresholdExceeded)
                }
                "TARGET_NOT_IN_UNIVERSE_SCOPE" => Some(Self::TargetNotInUniverseScope),
                "INVALID_FULL_UNIVERSE_EXPRESSION" => {
                    Some(Self::InvalidFullUniverseExpression)
                }
                "UNIVERSE_SCOPE_LIMIT_EXCEEDED" => Some(Self::UniverseScopeLimitExceeded),
                "INVALIDATION_LIMIT_EXCEEDED" => Some(Self::InvalidationLimitExceeded),
                "OUTPUT_FORMAT_PREREQ_UNMET" => Some(Self::OutputFormatPrereqUnmet),
                "ARGUMENTS_MISSING" => Some(Self::ArgumentsMissing),
                "RBUILDFILES_FUNCTION_REQUIRES_SKYQUERY" => {
                    Some(Self::RbuildfilesFunctionRequiresSkyquery)
                }
                "FULL_TARGETS_NOT_SUPPORTED" => Some(Self::FullTargetsNotSupported),
                "DEPRECATED_UNEXPECTED_TOKEN_ERROR" => {
                    Some(Self::DeprecatedUnexpectedTokenError)
                }
                "DEPRECATED_INTEGER_LITERAL_MISSING" => {
                    Some(Self::DeprecatedIntegerLiteralMissing)
                }
                "DEPRECATED_INVALID_STARTING_CHARACTER_ERROR" => {
                    Some(Self::DeprecatedInvalidStartingCharacterError)
                }
                "DEPRECATED_PREMATURE_END_OF_INPUT_ERROR" => {
                    Some(Self::DeprecatedPrematureEndOfInputError)
                }
                "SYNTAX_ERROR" => Some(Self::SyntaxError),
                "OUTPUT_FORMATTER_IO_EXCEPTION" => Some(Self::OutputFormatterIoException),
                "SKYQUERY_TRANSITIVE_TARGET_ERROR" => {
                    Some(Self::SkyqueryTransitiveTargetError)
                }
                "SKYQUERY_TARGET_EXCEPTION" => Some(Self::SkyqueryTargetException),
                "INVALID_LABEL_IN_TEST_SUITE" => Some(Self::InvalidLabelInTestSuite),
                "ILLEGAL_FLAG_COMBINATION" => Some(Self::IllegalFlagCombination),
                "NON_DETAILED_ERROR" => Some(Self::NonDetailedError),
                _ => None,
            }
        }
    }
}
#[derive(Clone, Copy, PartialEq, ::prost::Message)]
pub struct LocalExecution {
    #[prost(enumeration = "local_execution::Code", tag = "1")]
    pub code: i32,
}
/// Nested message and enum types in `LocalExecution`.
pub mod local_execution {
    #[derive(
        Clone,
        Copy,
        Debug,
        PartialEq,
        Eq,
        Hash,
        PartialOrd,
        Ord,
        ::prost::Enumeration
    )]
    #[repr(i32)]
    pub enum Code {
        LocalExecutionUnknown = 0,
        LockfreeOutputPrereqUnmet = 1,
        UntrackedResource = 2,
    }
    impl Code {
        /// String value of the enum field names used in the ProtoBuf definition.
        ///
        /// The values are not transformed in any way and thus are considered stable
        /// (if the ProtoBuf definition does not change) and safe for programmatic use.
        pub fn as_str_name(&self) -> &'static str {
            match self {
                Self::LocalExecutionUnknown => "LOCAL_EXECUTION_UNKNOWN",
                Self::LockfreeOutputPrereqUnmet => "LOCKFREE_OUTPUT_PREREQ_UNMET",
                Self::UntrackedResource => "UNTRACKED_RESOURCE",
            }
        }
        /// Creates an enum from field names used in the ProtoBuf definition.
        pub fn from_str_name(value: &str) -> ::core::option::Option<Self> {
            match value {
                "LOCAL_EXECUTION_UNKNOWN" => Some(Self::LocalExecutionUnknown),
                "LOCKFREE_OUTPUT_PREREQ_UNMET" => Some(Self::LockfreeOutputPrereqUnmet),
                "UNTRACKED_RESOURCE" => Some(Self::UntrackedResource),
                _ => None,
            }
        }
    }
}
#[derive(Clone, Copy, PartialEq, ::prost::Message)]
pub struct ActionCache {
    #[prost(enumeration = "action_cache::Code", tag = "1")]
    pub code: i32,
}
/// Nested message and enum types in `ActionCache`.
pub mod action_cache {
    #[derive(
        Clone,
        Copy,
        Debug,
        PartialEq,
        Eq,
        Hash,
        PartialOrd,
        Ord,
        ::prost::Enumeration
    )]
    #[repr(i32)]
    pub enum Code {
        ActionCacheUnknown = 0,
        InitializationFailure = 1,
    }
    impl Code {
        /// String value of the enum field names used in the ProtoBuf definition.
        ///
        /// The values are not transformed in any way and thus are considered stable
        /// (if the ProtoBuf definition does not change) and safe for programmatic use.
        pub fn as_str_name(&self) -> &'static str {
            match self {
                Self::ActionCacheUnknown => "ACTION_CACHE_UNKNOWN",
                Self::InitializationFailure => "INITIALIZATION_FAILURE",
            }
        }
        /// Creates an enum from field names used in the ProtoBuf definition.
        pub fn from_str_name(value: &str) -> ::core::option::Option<Self> {
            match value {
                "ACTION_CACHE_UNKNOWN" => Some(Self::ActionCacheUnknown),
                "INITIALIZATION_FAILURE" => Some(Self::InitializationFailure),
                _ => None,
            }
        }
    }
}
#[derive(Clone, Copy, PartialEq, ::prost::Message)]
pub struct FetchCommand {
    #[prost(enumeration = "fetch_command::Code", tag = "1")]
    pub code: i32,
}
/// Nested message and enum types in `FetchCommand`.
pub mod fetch_command {
    #[derive(
        Clone,
        Copy,
        Debug,
        PartialEq,
        Eq,
        Hash,
        PartialOrd,
        Ord,
        ::prost::Enumeration
    )]
    #[repr(i32)]
    pub enum Code {
        FetchCommandUnknown = 0,
        ExpressionMissing = 1,
        OptionsInvalid = 2,
        QueryParseError = 3,
        QueryEvaluationError = 4,
    }
    impl Code {
        /// String value of the enum field names used in the ProtoBuf definition.
        ///
        /// The values are not transformed in any way and thus are considered stable
        /// (if the ProtoBuf definition does not change) and safe for programmatic use.
        pub fn as_str_name(&self) -> &'static str {
            match self {
                Self::FetchCommandUnknown => "FETCH_COMMAND_UNKNOWN",
                Self::ExpressionMissing => "EXPRESSION_MISSING",
                Self::OptionsInvalid => "OPTIONS_INVALID",
                Self::QueryParseError => "QUERY_PARSE_ERROR",
                Self::QueryEvaluationError => "QUERY_EVALUATION_ERROR",
            }
        }
        /// Creates an enum from field names used in the ProtoBuf definition.
        pub fn from_str_name(value: &str) -> ::core::option::Option<Self> {
            match value {
                "FETCH_COMMAND_UNKNOWN" => Some(Self::FetchCommandUnknown),
                "EXPRESSION_MISSING" => Some(Self::ExpressionMissing),
                "OPTIONS_INVALID" => Some(Self::OptionsInvalid),
                "QUERY_PARSE_ERROR" => Some(Self::QueryParseError),
                "QUERY_EVALUATION_ERROR" => Some(Self::QueryEvaluationError),
                _ => None,
            }
        }
    }
}
#[derive(Clone, Copy, PartialEq, ::prost::Message)]
pub struct SyncCommand {
    #[prost(enumeration = "sync_command::Code", tag = "1")]
    pub code: i32,
}
/// Nested message and enum types in `SyncCommand`.
pub mod sync_command {
    #[derive(
        Clone,
        Copy,
        Debug,
        PartialEq,
        Eq,
        Hash,
        PartialOrd,
        Ord,
        ::prost::Enumeration
    )]
    #[repr(i32)]
    pub enum Code {
        SyncCommandUnknown = 0,
        PackageLookupError = 1,
        WorkspaceEvaluationError = 2,
        RepositoryFetchErrors = 3,
        RepositoryNameInvalid = 4,
    }
    impl Code {
        /// String value of the enum field names used in the ProtoBuf definition.
        ///
        /// The values are not transformed in any way and thus are considered stable
        /// (if the ProtoBuf definition does not change) and safe for programmatic use.
        pub fn as_str_name(&self) -> &'static str {
            match self {
                Self::SyncCommandUnknown => "SYNC_COMMAND_UNKNOWN",
                Self::PackageLookupError => "PACKAGE_LOOKUP_ERROR",
                Self::WorkspaceEvaluationError => "WORKSPACE_EVALUATION_ERROR",
                Self::RepositoryFetchErrors => "REPOSITORY_FETCH_ERRORS",
                Self::RepositoryNameInvalid => "REPOSITORY_NAME_INVALID",
            }
        }
        /// Creates an enum from field names used in the ProtoBuf definition.
        pub fn from_str_name(value: &str) -> ::core::option::Option<Self> {
            match value {
                "SYNC_COMMAND_UNKNOWN" => Some(Self::SyncCommandUnknown),
                "PACKAGE_LOOKUP_ERROR" => Some(Self::PackageLookupError),
                "WORKSPACE_EVALUATION_ERROR" => Some(Self::WorkspaceEvaluationError),
                "REPOSITORY_FETCH_ERRORS" => Some(Self::RepositoryFetchErrors),
                "REPOSITORY_NAME_INVALID" => Some(Self::RepositoryNameInvalid),
                _ => None,
            }
        }
    }
}
#[derive(Clone, Copy, PartialEq, ::prost::Message)]
pub struct Sandbox {
    #[prost(enumeration = "sandbox::Code", tag = "1")]
    pub code: i32,
}
/// Nested message and enum types in `Sandbox`.
pub mod sandbox {
    #[derive(
        Clone,
        Copy,
        Debug,
        PartialEq,
        Eq,
        Hash,
        PartialOrd,
        Ord,
        ::prost::Enumeration
    )]
    #[repr(i32)]
    pub enum Code {
        SandboxFailureUnknown = 0,
        InitializationFailure = 1,
        ExecutionIoException = 2,
        DockerCommandFailure = 3,
        NoDockerImage = 4,
        DockerImagePreparationFailure = 5,
        BindMountAnalysisFailure = 6,
        MountSourceDoesNotExist = 7,
        MountSourceTargetTypeMismatch = 8,
        MountTargetDoesNotExist = 9,
        SubprocessStartFailed = 10,
        ForbiddenInput = 11,
        CopyInputsIoException = 12,
        CopyOutputsIoException = 13,
    }
    impl Code {
        /// String value of the enum field names used in the ProtoBuf definition.
        ///
        /// The values are not transformed in any way and thus are considered stable
        /// (if the ProtoBuf definition does not change) and safe for programmatic use.
        pub fn as_str_name(&self) -> &'static str {
            match self {
                Self::SandboxFailureUnknown => "SANDBOX_FAILURE_UNKNOWN",
                Self::InitializationFailure => "INITIALIZATION_FAILURE",
                Self::ExecutionIoException => "EXECUTION_IO_EXCEPTION",
                Self::DockerCommandFailure => "DOCKER_COMMAND_FAILURE",
                Self::NoDockerImage => "NO_DOCKER_IMAGE",
                Self::DockerImagePreparationFailure => "DOCKER_IMAGE_PREPARATION_FAILURE",
                Self::BindMountAnalysisFailure => "BIND_MOUNT_ANALYSIS_FAILURE",
                Self::MountSourceDoesNotExist => "MOUNT_SOURCE_DOES_NOT_EXIST",
                Self::MountSourceTargetTypeMismatch => {
                    "MOUNT_SOURCE_TARGET_TYPE_MISMATCH"
                }
                Self::MountTargetDoesNotExist => "MOUNT_TARGET_DOES_NOT_EXIST",
                Self::SubprocessStartFailed => "SUBPROCESS_START_FAILED",
                Self::ForbiddenInput => "FORBIDDEN_INPUT",
                Self::CopyInputsIoException => "COPY_INPUTS_IO_EXCEPTION",
                Self::CopyOutputsIoException => "COPY_OUTPUTS_IO_EXCEPTION",
            }
        }
        /// Creates an enum from field names used in the ProtoBuf definition.
        pub fn from_str_name(value: &str) -> ::core::option::Option<Self> {
            match value {
                "SANDBOX_FAILURE_UNKNOWN" => Some(Self::SandboxFailureUnknown),
                "INITIALIZATION_FAILURE" => Some(Self::InitializationFailure),
                "EXECUTION_IO_EXCEPTION" => Some(Self::ExecutionIoException),
                "DOCKER_COMMAND_FAILURE" => Some(Self::DockerCommandFailure),
                "NO_DOCKER_IMAGE" => Some(Self::NoDockerImage),
                "DOCKER_IMAGE_PREPARATION_FAILURE" => {
                    Some(Self::DockerImagePreparationFailure)
                }
                "BIND_MOUNT_ANALYSIS_FAILURE" => Some(Self::BindMountAnalysisFailure),
                "MOUNT_SOURCE_DOES_NOT_EXIST" => Some(Self::MountSourceDoesNotExist),
                "MOUNT_SOURCE_TARGET_TYPE_MISMATCH" => {
                    Some(Self::MountSourceTargetTypeMismatch)
                }
                "MOUNT_TARGET_DOES_NOT_EXIST" => Some(Self::MountTargetDoesNotExist),
                "SUBPROCESS_START_FAILED" => Some(Self::SubprocessStartFailed),
                "FORBIDDEN_INPUT" => Some(Self::ForbiddenInput),
                "COPY_INPUTS_IO_EXCEPTION" => Some(Self::CopyInputsIoException),
                "COPY_OUTPUTS_IO_EXCEPTION" => Some(Self::CopyOutputsIoException),
                _ => None,
            }
        }
    }
}
#[derive(Clone, Copy, PartialEq, ::prost::Message)]
pub struct IncludeScanning {
    #[prost(enumeration = "include_scanning::Code", tag = "1")]
    pub code: i32,
    #[prost(enumeration = "package_loading::Code", tag = "2")]
    pub package_loading_code: i32,
}
/// Nested message and enum types in `IncludeScanning`.
pub mod include_scanning {
    #[derive(
        Clone,
        Copy,
        Debug,
        PartialEq,
        Eq,
        Hash,
        PartialOrd,
        Ord,
        ::prost::Enumeration
    )]
    #[repr(i32)]
    pub enum Code {
        IncludeScanningUnknown = 0,
        InitializeIncludeHintsError = 1,
        ScanningIoException = 2,
        IncludeHintsFileNotInPackage = 3,
        IncludeHintsReadFailure = 4,
        IllegalAbsolutePath = 5,
        /// TODO(b/166268889): this code should be deprecated in favor of more finely
        ///   resolved loading-phase codes.
        PackageLoadFailure = 6,
        UserPackageLoadFailure = 7,
        SystemPackageLoadFailure = 8,
        UndifferentiatedPackageLoadFailure = 9,
    }
    impl Code {
        /// String value of the enum field names used in the ProtoBuf definition.
        ///
        /// The values are not transformed in any way and thus are considered stable
        /// (if the ProtoBuf definition does not change) and safe for programmatic use.
        pub fn as_str_name(&self) -> &'static str {
            match self {
                Self::IncludeScanningUnknown => "INCLUDE_SCANNING_UNKNOWN",
                Self::InitializeIncludeHintsError => "INITIALIZE_INCLUDE_HINTS_ERROR",
                Self::ScanningIoException => "SCANNING_IO_EXCEPTION",
                Self::IncludeHintsFileNotInPackage => "INCLUDE_HINTS_FILE_NOT_IN_PACKAGE",
                Self::IncludeHintsReadFailure => "INCLUDE_HINTS_READ_FAILURE",
                Self::IllegalAbsolutePath => "ILLEGAL_ABSOLUTE_PATH",
                Self::PackageLoadFailure => "PACKAGE_LOAD_FAILURE",
                Self::UserPackageLoadFailure => "USER_PACKAGE_LOAD_FAILURE",
                Self::SystemPackageLoadFailure => "SYSTEM_PACKAGE_LOAD_FAILURE",
                Self::UndifferentiatedPackageLoadFailure => {
                    "UNDIFFERENTIATED_PACKAGE_LOAD_FAILURE"
                }
            }
        }
        /// Creates an enum from field names used in the ProtoBuf definition.
        pub fn from_str_name(value: &str) -> ::core::option::Option<Self> {
            match value {
                "INCLUDE_SCANNING_UNKNOWN" => Some(Self::IncludeScanningUnknown),
                "INITIALIZE_INCLUDE_HINTS_ERROR" => {
                    Some(Self::InitializeIncludeHintsError)
                }
                "SCANNING_IO_EXCEPTION" => Some(Self::ScanningIoException),
                "INCLUDE_HINTS_FILE_NOT_IN_PACKAGE" => {
                    Some(Self::IncludeHintsFileNotInPackage)
                }
                "INCLUDE_HINTS_READ_FAILURE" => Some(Self::IncludeHintsReadFailure),
                "ILLEGAL_ABSOLUTE_PATH" => Some(Self::IllegalAbsolutePath),
                "PACKAGE_LOAD_FAILURE" => Some(Self::PackageLoadFailure),
                "USER_PACKAGE_LOAD_FAILURE" => Some(Self::UserPackageLoadFailure),
                "SYSTEM_PACKAGE_LOAD_FAILURE" => Some(Self::SystemPackageLoadFailure),
                "UNDIFFERENTIATED_PACKAGE_LOAD_FAILURE" => {
                    Some(Self::UndifferentiatedPackageLoadFailure)
                }
                _ => None,
            }
        }
    }
}
#[derive(Clone, Copy, PartialEq, ::prost::Message)]
pub struct TestCommand {
    #[prost(enumeration = "test_command::Code", tag = "1")]
    pub code: i32,
}
/// Nested message and enum types in `TestCommand`.
pub mod test_command {
    #[derive(
        Clone,
        Copy,
        Debug,
        PartialEq,
        Eq,
        Hash,
        PartialOrd,
        Ord,
        ::prost::Enumeration
    )]
    #[repr(i32)]
    pub enum Code {
        TestCommandUnknown = 0,
        NoTestTargets = 1,
        TestWithNoanalyze = 2,
        TestsFailed = 3,
    }
    impl Code {
        /// String value of the enum field names used in the ProtoBuf definition.
        ///
        /// The values are not transformed in any way and thus are considered stable
        /// (if the ProtoBuf definition does not change) and safe for programmatic use.
        pub fn as_str_name(&self) -> &'static str {
            match self {
                Self::TestCommandUnknown => "TEST_COMMAND_UNKNOWN",
                Self::NoTestTargets => "NO_TEST_TARGETS",
                Self::TestWithNoanalyze => "TEST_WITH_NOANALYZE",
                Self::TestsFailed => "TESTS_FAILED",
            }
        }
        /// Creates an enum from field names used in the ProtoBuf definition.
        pub fn from_str_name(value: &str) -> ::core::option::Option<Self> {
            match value {
                "TEST_COMMAND_UNKNOWN" => Some(Self::TestCommandUnknown),
                "NO_TEST_TARGETS" => Some(Self::NoTestTargets),
                "TEST_WITH_NOANALYZE" => Some(Self::TestWithNoanalyze),
                "TESTS_FAILED" => Some(Self::TestsFailed),
                _ => None,
            }
        }
    }
}
#[derive(Clone, Copy, PartialEq, ::prost::Message)]
pub struct ActionQuery {
    #[prost(enumeration = "action_query::Code", tag = "1")]
    pub code: i32,
}
/// Nested message and enum types in `ActionQuery`.
pub mod action_query {
    /// All numerical exit code associations correspond to pre-existing Bazel
    /// behavior. These associations are suspicious:
    /// - COMMAND_LINE_EXPANSION_FAILURE: this is associated with 2, the numerical
    ///      exit code for "bad Bazel command line", but is generated when an
    ///      action's command line fails to expand, which sounds similar but is
    ///      completely different.
    /// - OUTPUT_FAILURE: this is associated with 6, an undocumented exit code.
    /// - INVALID_AQUERY_EXPRESSION: this is associate with 1, which is not
    ///     documented for (a)query.
    /// TODO(b/138456686): Revise these after the (intentionally non-breaking)
    ///   initial rollout of FailureDetail-based encoding.
    #[derive(
        Clone,
        Copy,
        Debug,
        PartialEq,
        Eq,
        Hash,
        PartialOrd,
        Ord,
        ::prost::Enumeration
    )]
    #[repr(i32)]
    pub enum Code {
        ActionQueryUnknown = 0,
        CommandLineExpansionFailure = 1,
        OutputFailure = 2,
        CommandLineExpressionMissing = 3,
        ExpressionParseFailure = 4,
        SkyframeStateWithCommandLineExpression = 5,
        InvalidAqueryExpression = 6,
        SkyframeStatePrereqUnmet = 7,
        AqueryOutputTooBig = 8,
        IllegalPatternSyntax = 9,
        IncorrectArguments = 10,
        TopLevelTargetsWithSkyframeStateNotSupported = 11,
        SkyframeStateAfterExecution = 12,
        LabelsFunctionNotSupported = 13,
        TemplateExpansionFailure = 14,
    }
    impl Code {
        /// String value of the enum field names used in the ProtoBuf definition.
        ///
        /// The values are not transformed in any way and thus are considered stable
        /// (if the ProtoBuf definition does not change) and safe for programmatic use.
        pub fn as_str_name(&self) -> &'static str {
            match self {
                Self::ActionQueryUnknown => "ACTION_QUERY_UNKNOWN",
                Self::CommandLineExpansionFailure => "COMMAND_LINE_EXPANSION_FAILURE",
                Self::OutputFailure => "OUTPUT_FAILURE",
                Self::CommandLineExpressionMissing => "COMMAND_LINE_EXPRESSION_MISSING",
                Self::ExpressionParseFailure => "EXPRESSION_PARSE_FAILURE",
                Self::SkyframeStateWithCommandLineExpression => {
                    "SKYFRAME_STATE_WITH_COMMAND_LINE_EXPRESSION"
                }
                Self::InvalidAqueryExpression => "INVALID_AQUERY_EXPRESSION",
                Self::SkyframeStatePrereqUnmet => "SKYFRAME_STATE_PREREQ_UNMET",
                Self::AqueryOutputTooBig => "AQUERY_OUTPUT_TOO_BIG",
                Self::IllegalPatternSyntax => "ILLEGAL_PATTERN_SYNTAX",
                Self::IncorrectArguments => "INCORRECT_ARGUMENTS",
                Self::TopLevelTargetsWithSkyframeStateNotSupported => {
                    "TOP_LEVEL_TARGETS_WITH_SKYFRAME_STATE_NOT_SUPPORTED"
                }
                Self::SkyframeStateAfterExecution => "SKYFRAME_STATE_AFTER_EXECUTION",
                Self::LabelsFunctionNotSupported => "LABELS_FUNCTION_NOT_SUPPORTED",
                Self::TemplateExpansionFailure => "TEMPLATE_EXPANSION_FAILURE",
            }
        }
        /// Creates an enum from field names used in the ProtoBuf definition.
        pub fn from_str_name(value: &str) -> ::core::option::Option<Self> {
            match value {
                "ACTION_QUERY_UNKNOWN" => Some(Self::ActionQueryUnknown),
                "COMMAND_LINE_EXPANSION_FAILURE" => {
                    Some(Self::CommandLineExpansionFailure)
                }
                "OUTPUT_FAILURE" => Some(Self::OutputFailure),
                "COMMAND_LINE_EXPRESSION_MISSING" => {
                    Some(Self::CommandLineExpressionMissing)
                }
                "EXPRESSION_PARSE_FAILURE" => Some(Self::ExpressionParseFailure),
                "SKYFRAME_STATE_WITH_COMMAND_LINE_EXPRESSION" => {
                    Some(Self::SkyframeStateWithCommandLineExpression)
                }
                "INVALID_AQUERY_EXPRESSION" => Some(Self::InvalidAqueryExpression),
                "SKYFRAME_STATE_PREREQ_UNMET" => Some(Self::SkyframeStatePrereqUnmet),
                "AQUERY_OUTPUT_TOO_BIG" => Some(Self::AqueryOutputTooBig),
                "ILLEGAL_PATTERN_SYNTAX" => Some(Self::IllegalPatternSyntax),
                "INCORRECT_ARGUMENTS" => Some(Self::IncorrectArguments),
                "TOP_LEVEL_TARGETS_WITH_SKYFRAME_STATE_NOT_SUPPORTED" => {
                    Some(Self::TopLevelTargetsWithSkyframeStateNotSupported)
                }
                "SKYFRAME_STATE_AFTER_EXECUTION" => {
                    Some(Self::SkyframeStateAfterExecution)
                }
                "LABELS_FUNCTION_NOT_SUPPORTED" => Some(Self::LabelsFunctionNotSupported),
                "TEMPLATE_EXPANSION_FAILURE" => Some(Self::TemplateExpansionFailure),
                _ => None,
            }
        }
    }
}
#[derive(Clone, Copy, PartialEq, ::prost::Message)]
pub struct TargetPatterns {
    #[prost(enumeration = "target_patterns::Code", tag = "1")]
    pub code: i32,
}
/// Nested message and enum types in `TargetPatterns`.
pub mod target_patterns {
    #[derive(
        Clone,
        Copy,
        Debug,
        PartialEq,
        Eq,
        Hash,
        PartialOrd,
        Ord,
        ::prost::Enumeration
    )]
    #[repr(i32)]
    pub enum Code {
        TargetPatternsUnknown = 0,
        TargetPatternFileWithCommandLinePattern = 1,
        TargetPatternFileReadFailure = 2,
        TargetPatternParseFailure = 3,
        PackageNotFound = 4,
        TargetFormatInvalid = 5,
        AbsoluteTargetPatternInvalid = 6,
        CannotDetermineTargetFromFilename = 7,
        LabelSyntaxError = 8,
        TargetCannotBeEmptyString = 9,
        PackagePartCannotEndInSlash = 10,
        Cycle = 11,
        CannotPreloadTarget = 12,
        TargetsMissing = 13,
        RecursiveTargetPatternsNotAllowed = 14,
        UpLevelReferencesNotAllowed = 15,
        NegativeTargetPatternNotAllowed = 16,
        TargetMustBeAFile = 17,
        DependencyNotFound = 18,
        PackageNameInvalid = 19,
    }
    impl Code {
        /// String value of the enum field names used in the ProtoBuf definition.
        ///
        /// The values are not transformed in any way and thus are considered stable
        /// (if the ProtoBuf definition does not change) and safe for programmatic use.
        pub fn as_str_name(&self) -> &'static str {
            match self {
                Self::TargetPatternsUnknown => "TARGET_PATTERNS_UNKNOWN",
                Self::TargetPatternFileWithCommandLinePattern => {
                    "TARGET_PATTERN_FILE_WITH_COMMAND_LINE_PATTERN"
                }
                Self::TargetPatternFileReadFailure => "TARGET_PATTERN_FILE_READ_FAILURE",
                Self::TargetPatternParseFailure => "TARGET_PATTERN_PARSE_FAILURE",
                Self::PackageNotFound => "PACKAGE_NOT_FOUND",
                Self::TargetFormatInvalid => "TARGET_FORMAT_INVALID",
                Self::AbsoluteTargetPatternInvalid => "ABSOLUTE_TARGET_PATTERN_INVALID",
                Self::CannotDetermineTargetFromFilename => {
                    "CANNOT_DETERMINE_TARGET_FROM_FILENAME"
                }
                Self::LabelSyntaxError => "LABEL_SYNTAX_ERROR",
                Self::TargetCannotBeEmptyString => "TARGET_CANNOT_BE_EMPTY_STRING",
                Self::PackagePartCannotEndInSlash => "PACKAGE_PART_CANNOT_END_IN_SLASH",
                Self::Cycle => "CYCLE",
                Self::CannotPreloadTarget => "CANNOT_PRELOAD_TARGET",
                Self::TargetsMissing => "TARGETS_MISSING",
                Self::RecursiveTargetPatternsNotAllowed => {
                    "RECURSIVE_TARGET_PATTERNS_NOT_ALLOWED"
                }
                Self::UpLevelReferencesNotAllowed => "UP_LEVEL_REFERENCES_NOT_ALLOWED",
                Self::NegativeTargetPatternNotAllowed => {
                    "NEGATIVE_TARGET_PATTERN_NOT_ALLOWED"
                }
                Self::TargetMustBeAFile => "TARGET_MUST_BE_A_FILE",
                Self::DependencyNotFound => "DEPENDENCY_NOT_FOUND",
                Self::PackageNameInvalid => "PACKAGE_NAME_INVALID",
            }
        }
        /// Creates an enum from field names used in the ProtoBuf definition.
        pub fn from_str_name(value: &str) -> ::core::option::Option<Self> {
            match value {
                "TARGET_PATTERNS_UNKNOWN" => Some(Self::TargetPatternsUnknown),
                "TARGET_PATTERN_FILE_WITH_COMMAND_LINE_PATTERN" => {
                    Some(Self::TargetPatternFileWithCommandLinePattern)
                }
                "TARGET_PATTERN_FILE_READ_FAILURE" => {
                    Some(Self::TargetPatternFileReadFailure)
                }
                "TARGET_PATTERN_PARSE_FAILURE" => Some(Self::TargetPatternParseFailure),
                "PACKAGE_NOT_FOUND" => Some(Self::PackageNotFound),
                "TARGET_FORMAT_INVALID" => Some(Self::TargetFormatInvalid),
                "ABSOLUTE_TARGET_PATTERN_INVALID" => {
                    Some(Self::AbsoluteTargetPatternInvalid)
                }
                "CANNOT_DETERMINE_TARGET_FROM_FILENAME" => {
                    Some(Self::CannotDetermineTargetFromFilename)
                }
                "LABEL_SYNTAX_ERROR" => Some(Self::LabelSyntaxError),
                "TARGET_CANNOT_BE_EMPTY_STRING" => Some(Self::TargetCannotBeEmptyString),
                "PACKAGE_PART_CANNOT_END_IN_SLASH" => {
                    Some(Self::PackagePartCannotEndInSlash)
                }
                "CYCLE" => Some(Self::Cycle),
                "CANNOT_PRELOAD_TARGET" => Some(Self::CannotPreloadTarget),
                "TARGETS_MISSING" => Some(Self::TargetsMissing),
                "RECURSIVE_TARGET_PATTERNS_NOT_ALLOWED" => {
                    Some(Self::RecursiveTargetPatternsNotAllowed)
                }
                "UP_LEVEL_REFERENCES_NOT_ALLOWED" => {
                    Some(Self::UpLevelReferencesNotAllowed)
                }
                "NEGATIVE_TARGET_PATTERN_NOT_ALLOWED" => {
                    Some(Self::NegativeTargetPatternNotAllowed)
                }
                "TARGET_MUST_BE_A_FILE" => Some(Self::TargetMustBeAFile),
                "DEPENDENCY_NOT_FOUND" => Some(Self::DependencyNotFound),
                "PACKAGE_NAME_INVALID" => Some(Self::PackageNameInvalid),
                _ => None,
            }
        }
    }
}
#[derive(Clone, Copy, PartialEq, ::prost::Message)]
pub struct CleanCommand {
    #[prost(enumeration = "clean_command::Code", tag = "1")]
    pub code: i32,
}
/// Nested message and enum types in `CleanCommand`.
pub mod clean_command {
    #[derive(
        Clone,
        Copy,
        Debug,
        PartialEq,
        Eq,
        Hash,
        PartialOrd,
        Ord,
        ::prost::Enumeration
    )]
    #[repr(i32)]
    pub enum Code {
        CleanCommandUnknown = 0,
        OutputServiceCleanFailure = 1,
        ActionCacheCleanFailure = 2,
        OutErrCloseFailure = 3,
        OutputBaseDeleteFailure = 4,
        OutputBaseTempMoveFailure = 5,
        AsyncOutputBaseDeleteFailure = 6,
        ExecrootDeleteFailure = 7,
        ExecrootTempMoveFailure = 8,
        AsyncExecrootDeleteFailure = 9,
        ArgumentsNotRecognized = 10,
    }
    impl Code {
        /// String value of the enum field names used in the ProtoBuf definition.
        ///
        /// The values are not transformed in any way and thus are considered stable
        /// (if the ProtoBuf definition does not change) and safe for programmatic use.
        pub fn as_str_name(&self) -> &'static str {
            match self {
                Self::CleanCommandUnknown => "CLEAN_COMMAND_UNKNOWN",
                Self::OutputServiceCleanFailure => "OUTPUT_SERVICE_CLEAN_FAILURE",
                Self::ActionCacheCleanFailure => "ACTION_CACHE_CLEAN_FAILURE",
                Self::OutErrCloseFailure => "OUT_ERR_CLOSE_FAILURE",
                Self::OutputBaseDeleteFailure => "OUTPUT_BASE_DELETE_FAILURE",
                Self::OutputBaseTempMoveFailure => "OUTPUT_BASE_TEMP_MOVE_FAILURE",
                Self::AsyncOutputBaseDeleteFailure => "ASYNC_OUTPUT_BASE_DELETE_FAILURE",
                Self::ExecrootDeleteFailure => "EXECROOT_DELETE_FAILURE",
                Self::ExecrootTempMoveFailure => "EXECROOT_TEMP_MOVE_FAILURE",
                Self::AsyncExecrootDeleteFailure => "ASYNC_EXECROOT_DELETE_FAILURE",
                Self::ArgumentsNotRecognized => "ARGUMENTS_NOT_RECOGNIZED",
            }
        }
        /// Creates an enum from field names used in the ProtoBuf definition.
        pub fn from_str_name(value: &str) -> ::core::option::Option<Self> {
            match value {
                "CLEAN_COMMAND_UNKNOWN" => Some(Self::CleanCommandUnknown),
                "OUTPUT_SERVICE_CLEAN_FAILURE" => Some(Self::OutputServiceCleanFailure),
                "ACTION_CACHE_CLEAN_FAILURE" => Some(Self::ActionCacheCleanFailure),
                "OUT_ERR_CLOSE_FAILURE" => Some(Self::OutErrCloseFailure),
                "OUTPUT_BASE_DELETE_FAILURE" => Some(Self::OutputBaseDeleteFailure),
                "OUTPUT_BASE_TEMP_MOVE_FAILURE" => Some(Self::OutputBaseTempMoveFailure),
                "ASYNC_OUTPUT_BASE_DELETE_FAILURE" => {
                    Some(Self::AsyncOutputBaseDeleteFailure)
                }
                "EXECROOT_DELETE_FAILURE" => Some(Self::ExecrootDeleteFailure),
                "EXECROOT_TEMP_MOVE_FAILURE" => Some(Self::ExecrootTempMoveFailure),
                "ASYNC_EXECROOT_DELETE_FAILURE" => Some(Self::AsyncExecrootDeleteFailure),
                "ARGUMENTS_NOT_RECOGNIZED" => Some(Self::ArgumentsNotRecognized),
                _ => None,
            }
        }
    }
}
#[derive(Clone, Copy, PartialEq, ::prost::Message)]
pub struct ConfigCommand {
    #[prost(enumeration = "config_command::Code", tag = "1")]
    pub code: i32,
}
/// Nested message and enum types in `ConfigCommand`.
pub mod config_command {
    #[derive(
        Clone,
        Copy,
        Debug,
        PartialEq,
        Eq,
        Hash,
        PartialOrd,
        Ord,
        ::prost::Enumeration
    )]
    #[repr(i32)]
    pub enum Code {
        ConfigCommandUnknown = 0,
        TooManyConfigIds = 1,
        ConfigurationNotFound = 2,
    }
    impl Code {
        /// String value of the enum field names used in the ProtoBuf definition.
        ///
        /// The values are not transformed in any way and thus are considered stable
        /// (if the ProtoBuf definition does not change) and safe for programmatic use.
        pub fn as_str_name(&self) -> &'static str {
            match self {
                Self::ConfigCommandUnknown => "CONFIG_COMMAND_UNKNOWN",
                Self::TooManyConfigIds => "TOO_MANY_CONFIG_IDS",
                Self::ConfigurationNotFound => "CONFIGURATION_NOT_FOUND",
            }
        }
        /// Creates an enum from field names used in the ProtoBuf definition.
        pub fn from_str_name(value: &str) -> ::core::option::Option<Self> {
            match value {
                "CONFIG_COMMAND_UNKNOWN" => Some(Self::ConfigCommandUnknown),
                "TOO_MANY_CONFIG_IDS" => Some(Self::TooManyConfigIds),
                "CONFIGURATION_NOT_FOUND" => Some(Self::ConfigurationNotFound),
                _ => None,
            }
        }
    }
}
#[derive(Clone, Copy, PartialEq, ::prost::Message)]
pub struct ConfigurableQuery {
    #[prost(enumeration = "configurable_query::Code", tag = "1")]
    pub code: i32,
}
/// Nested message and enum types in `ConfigurableQuery`.
pub mod configurable_query {
    #[derive(
        Clone,
        Copy,
        Debug,
        PartialEq,
        Eq,
        Hash,
        PartialOrd,
        Ord,
        ::prost::Enumeration
    )]
    #[repr(i32)]
    pub enum Code {
        ConfigurableQueryUnknown = 0,
        CommandLineExpressionMissing = 1,
        ExpressionParseFailure = 2,
        FiltersNotSupported = 3,
        BuildfilesFunctionNotSupported = 4,
        SiblingsFunctionNotSupported = 5,
        VisibleFunctionNotSupported = 6,
        AttributeMissing = 7,
        IncorrectConfigArgumentError = 8,
        TargetMissing = 9,
        StarlarkSyntaxError = 10,
        StarlarkEvalError = 11,
        /// Indicates failure to correctly define a format function
        FormatFunctionError = 12,
    }
    impl Code {
        /// String value of the enum field names used in the ProtoBuf definition.
        ///
        /// The values are not transformed in any way and thus are considered stable
        /// (if the ProtoBuf definition does not change) and safe for programmatic use.
        pub fn as_str_name(&self) -> &'static str {
            match self {
                Self::ConfigurableQueryUnknown => "CONFIGURABLE_QUERY_UNKNOWN",
                Self::CommandLineExpressionMissing => "COMMAND_LINE_EXPRESSION_MISSING",
                Self::ExpressionParseFailure => "EXPRESSION_PARSE_FAILURE",
                Self::FiltersNotSupported => "FILTERS_NOT_SUPPORTED",
                Self::BuildfilesFunctionNotSupported => {
                    "BUILDFILES_FUNCTION_NOT_SUPPORTED"
                }
                Self::SiblingsFunctionNotSupported => "SIBLINGS_FUNCTION_NOT_SUPPORTED",
                Self::VisibleFunctionNotSupported => "VISIBLE_FUNCTION_NOT_SUPPORTED",
                Self::AttributeMissing => "ATTRIBUTE_MISSING",
                Self::IncorrectConfigArgumentError => "INCORRECT_CONFIG_ARGUMENT_ERROR",
                Self::TargetMissing => "TARGET_MISSING",
                Self::StarlarkSyntaxError => "STARLARK_SYNTAX_ERROR",
                Self::StarlarkEvalError => "STARLARK_EVAL_ERROR",
                Self::FormatFunctionError => "FORMAT_FUNCTION_ERROR",
            }
        }
        /// Creates an enum from field names used in the ProtoBuf definition.
        pub fn from_str_name(value: &str) -> ::core::option::Option<Self> {
            match value {
                "CONFIGURABLE_QUERY_UNKNOWN" => Some(Self::ConfigurableQueryUnknown),
                "COMMAND_LINE_EXPRESSION_MISSING" => {
                    Some(Self::CommandLineExpressionMissing)
                }
                "EXPRESSION_PARSE_FAILURE" => Some(Self::ExpressionParseFailure),
                "FILTERS_NOT_SUPPORTED" => Some(Self::FiltersNotSupported),
                "BUILDFILES_FUNCTION_NOT_SUPPORTED" => {
                    Some(Self::BuildfilesFunctionNotSupported)
                }
                "SIBLINGS_FUNCTION_NOT_SUPPORTED" => {
                    Some(Self::SiblingsFunctionNotSupported)
                }
                "VISIBLE_FUNCTION_NOT_SUPPORTED" => {
                    Some(Self::VisibleFunctionNotSupported)
                }
                "ATTRIBUTE_MISSING" => Some(Self::AttributeMissing),
                "INCORRECT_CONFIG_ARGUMENT_ERROR" => {
                    Some(Self::IncorrectConfigArgumentError)
                }
                "TARGET_MISSING" => Some(Self::TargetMissing),
                "STARLARK_SYNTAX_ERROR" => Some(Self::StarlarkSyntaxError),
                "STARLARK_EVAL_ERROR" => Some(Self::StarlarkEvalError),
                "FORMAT_FUNCTION_ERROR" => Some(Self::FormatFunctionError),
                _ => None,
            }
        }
    }
}
#[derive(Clone, Copy, PartialEq, ::prost::Message)]
pub struct DumpCommand {
    #[prost(enumeration = "dump_command::Code", tag = "1")]
    pub code: i32,
}
/// Nested message and enum types in `DumpCommand`.
pub mod dump_command {
    #[derive(
        Clone,
        Copy,
        Debug,
        PartialEq,
        Eq,
        Hash,
        PartialOrd,
        Ord,
        ::prost::Enumeration
    )]
    #[repr(i32)]
    pub enum Code {
        DumpCommandUnknown = 0,
        NoOutputSpecified = 1,
        ActionCacheDumpFailed = 2,
        CommandLineExpansionFailure = 3,
        ActionGraphDumpFailed = 4,
        StarlarkHeapDumpFailed = 5,
        SkyframeMemoryDumpFailed = 7,
    }
    impl Code {
        /// String value of the enum field names used in the ProtoBuf definition.
        ///
        /// The values are not transformed in any way and thus are considered stable
        /// (if the ProtoBuf definition does not change) and safe for programmatic use.
        pub fn as_str_name(&self) -> &'static str {
            match self {
                Self::DumpCommandUnknown => "DUMP_COMMAND_UNKNOWN",
                Self::NoOutputSpecified => "NO_OUTPUT_SPECIFIED",
                Self::ActionCacheDumpFailed => "ACTION_CACHE_DUMP_FAILED",
                Self::CommandLineExpansionFailure => "COMMAND_LINE_EXPANSION_FAILURE",
                Self::ActionGraphDumpFailed => "ACTION_GRAPH_DUMP_FAILED",
                Self::StarlarkHeapDumpFailed => "STARLARK_HEAP_DUMP_FAILED",
                Self::SkyframeMemoryDumpFailed => "SKYFRAME_MEMORY_DUMP_FAILED",
            }
        }
        /// Creates an enum from field names used in the ProtoBuf definition.
        pub fn from_str_name(value: &str) -> ::core::option::Option<Self> {
            match value {
                "DUMP_COMMAND_UNKNOWN" => Some(Self::DumpCommandUnknown),
                "NO_OUTPUT_SPECIFIED" => Some(Self::NoOutputSpecified),
                "ACTION_CACHE_DUMP_FAILED" => Some(Self::ActionCacheDumpFailed),
                "COMMAND_LINE_EXPANSION_FAILURE" => {
                    Some(Self::CommandLineExpansionFailure)
                }
                "ACTION_GRAPH_DUMP_FAILED" => Some(Self::ActionGraphDumpFailed),
                "STARLARK_HEAP_DUMP_FAILED" => Some(Self::StarlarkHeapDumpFailed),
                "SKYFRAME_MEMORY_DUMP_FAILED" => Some(Self::SkyframeMemoryDumpFailed),
                _ => None,
            }
        }
    }
}
#[derive(Clone, Copy, PartialEq, ::prost::Message)]
pub struct HelpCommand {
    #[prost(enumeration = "help_command::Code", tag = "1")]
    pub code: i32,
}
/// Nested message and enum types in `HelpCommand`.
pub mod help_command {
    #[derive(
        Clone,
        Copy,
        Debug,
        PartialEq,
        Eq,
        Hash,
        PartialOrd,
        Ord,
        ::prost::Enumeration
    )]
    #[repr(i32)]
    pub enum Code {
        HelpCommandUnknown = 0,
        MissingArgument = 1,
        CommandNotFound = 2,
    }
    impl Code {
        /// String value of the enum field names used in the ProtoBuf definition.
        ///
        /// The values are not transformed in any way and thus are considered stable
        /// (if the ProtoBuf definition does not change) and safe for programmatic use.
        pub fn as_str_name(&self) -> &'static str {
            match self {
                Self::HelpCommandUnknown => "HELP_COMMAND_UNKNOWN",
                Self::MissingArgument => "MISSING_ARGUMENT",
                Self::CommandNotFound => "COMMAND_NOT_FOUND",
            }
        }
        /// Creates an enum from field names used in the ProtoBuf definition.
        pub fn from_str_name(value: &str) -> ::core::option::Option<Self> {
            match value {
                "HELP_COMMAND_UNKNOWN" => Some(Self::HelpCommandUnknown),
                "MISSING_ARGUMENT" => Some(Self::MissingArgument),
                "COMMAND_NOT_FOUND" => Some(Self::CommandNotFound),
                _ => None,
            }
        }
    }
}
#[derive(Clone, Copy, PartialEq, ::prost::Message)]
pub struct MobileInstall {
    #[prost(enumeration = "mobile_install::Code", tag = "1")]
    pub code: i32,
}
/// Nested message and enum types in `MobileInstall`.
pub mod mobile_install {
    #[derive(
        Clone,
        Copy,
        Debug,
        PartialEq,
        Eq,
        Hash,
        PartialOrd,
        Ord,
        ::prost::Enumeration
    )]
    #[repr(i32)]
    pub enum Code {
        MobileInstallUnknown = 0,
        ClassicUnsupported = 1,
        NoTargetSpecified = 2,
        MultipleTargetsSpecified = 3,
        TargetTypeInvalid = 4,
        NonZeroExit = 5,
        ErrorRunningProgram = 6,
    }
    impl Code {
        /// String value of the enum field names used in the ProtoBuf definition.
        ///
        /// The values are not transformed in any way and thus are considered stable
        /// (if the ProtoBuf definition does not change) and safe for programmatic use.
        pub fn as_str_name(&self) -> &'static str {
            match self {
                Self::MobileInstallUnknown => "MOBILE_INSTALL_UNKNOWN",
                Self::ClassicUnsupported => "CLASSIC_UNSUPPORTED",
                Self::NoTargetSpecified => "NO_TARGET_SPECIFIED",
                Self::MultipleTargetsSpecified => "MULTIPLE_TARGETS_SPECIFIED",
                Self::TargetTypeInvalid => "TARGET_TYPE_INVALID",
                Self::NonZeroExit => "NON_ZERO_EXIT",
                Self::ErrorRunningProgram => "ERROR_RUNNING_PROGRAM",
            }
        }
        /// Creates an enum from field names used in the ProtoBuf definition.
        pub fn from_str_name(value: &str) -> ::core::option::Option<Self> {
            match value {
                "MOBILE_INSTALL_UNKNOWN" => Some(Self::MobileInstallUnknown),
                "CLASSIC_UNSUPPORTED" => Some(Self::ClassicUnsupported),
                "NO_TARGET_SPECIFIED" => Some(Self::NoTargetSpecified),
                "MULTIPLE_TARGETS_SPECIFIED" => Some(Self::MultipleTargetsSpecified),
                "TARGET_TYPE_INVALID" => Some(Self::TargetTypeInvalid),
                "NON_ZERO_EXIT" => Some(Self::NonZeroExit),
                "ERROR_RUNNING_PROGRAM" => Some(Self::ErrorRunningProgram),
                _ => None,
            }
        }
    }
}
#[derive(Clone, Copy, PartialEq, ::prost::Message)]
pub struct ProfileCommand {
    #[prost(enumeration = "profile_command::Code", tag = "1")]
    pub code: i32,
}
/// Nested message and enum types in `ProfileCommand`.
pub mod profile_command {
    #[derive(
        Clone,
        Copy,
        Debug,
        PartialEq,
        Eq,
        Hash,
        PartialOrd,
        Ord,
        ::prost::Enumeration
    )]
    #[repr(i32)]
    pub enum Code {
        ProfileCommandUnknown = 0,
        OldBinaryFormatUnsupported = 1,
        FileReadFailure = 2,
    }
    impl Code {
        /// String value of the enum field names used in the ProtoBuf definition.
        ///
        /// The values are not transformed in any way and thus are considered stable
        /// (if the ProtoBuf definition does not change) and safe for programmatic use.
        pub fn as_str_name(&self) -> &'static str {
            match self {
                Self::ProfileCommandUnknown => "PROFILE_COMMAND_UNKNOWN",
                Self::OldBinaryFormatUnsupported => "OLD_BINARY_FORMAT_UNSUPPORTED",
                Self::FileReadFailure => "FILE_READ_FAILURE",
            }
        }
        /// Creates an enum from field names used in the ProtoBuf definition.
        pub fn from_str_name(value: &str) -> ::core::option::Option<Self> {
            match value {
                "PROFILE_COMMAND_UNKNOWN" => Some(Self::ProfileCommandUnknown),
                "OLD_BINARY_FORMAT_UNSUPPORTED" => Some(Self::OldBinaryFormatUnsupported),
                "FILE_READ_FAILURE" => Some(Self::FileReadFailure),
                _ => None,
            }
        }
    }
}
#[derive(Clone, Copy, PartialEq, ::prost::Message)]
pub struct RunCommand {
    #[prost(enumeration = "run_command::Code", tag = "1")]
    pub code: i32,
}
/// Nested message and enum types in `RunCommand`.
pub mod run_command {
    #[derive(
        Clone,
        Copy,
        Debug,
        PartialEq,
        Eq,
        Hash,
        PartialOrd,
        Ord,
        ::prost::Enumeration
    )]
    #[repr(i32)]
    pub enum Code {
        RunCommandUnknown = 0,
        NoTargetSpecified = 1,
        TooManyTargetsSpecified = 2,
        TargetNotExecutable = 3,
        TargetBuiltButPathNotExecutable = 4,
        TargetBuiltButPathValidationFailed = 5,
        RunUnderTargetNotBuilt = 6,
        RunPrereqUnmet = 7,
        TooManyTestShardsOrRuns = 8,
        TestEnvironmentSetupFailure = 9,
        CommandLineExpansionFailure = 10,
        NoShellSpecified = 11,
        ScriptWriteFailure = 12,
        RunfilesDirectoriesCreationFailure = 13,
        RunfilesSymlinksCreationFailure = 14,
        TestEnvironmentSetupInterrupted = 15,
    }
    impl Code {
        /// String value of the enum field names used in the ProtoBuf definition.
        ///
        /// The values are not transformed in any way and thus are considered stable
        /// (if the ProtoBuf definition does not change) and safe for programmatic use.
        pub fn as_str_name(&self) -> &'static str {
            match self {
                Self::RunCommandUnknown => "RUN_COMMAND_UNKNOWN",
                Self::NoTargetSpecified => "NO_TARGET_SPECIFIED",
                Self::TooManyTargetsSpecified => "TOO_MANY_TARGETS_SPECIFIED",
                Self::TargetNotExecutable => "TARGET_NOT_EXECUTABLE",
                Self::TargetBuiltButPathNotExecutable => {
                    "TARGET_BUILT_BUT_PATH_NOT_EXECUTABLE"
                }
                Self::TargetBuiltButPathValidationFailed => {
                    "TARGET_BUILT_BUT_PATH_VALIDATION_FAILED"
                }
                Self::RunUnderTargetNotBuilt => "RUN_UNDER_TARGET_NOT_BUILT",
                Self::RunPrereqUnmet => "RUN_PREREQ_UNMET",
                Self::TooManyTestShardsOrRuns => "TOO_MANY_TEST_SHARDS_OR_RUNS",
                Self::TestEnvironmentSetupFailure => "TEST_ENVIRONMENT_SETUP_FAILURE",
                Self::CommandLineExpansionFailure => "COMMAND_LINE_EXPANSION_FAILURE",
                Self::NoShellSpecified => "NO_SHELL_SPECIFIED",
                Self::ScriptWriteFailure => "SCRIPT_WRITE_FAILURE",
                Self::RunfilesDirectoriesCreationFailure => {
                    "RUNFILES_DIRECTORIES_CREATION_FAILURE"
                }
                Self::RunfilesSymlinksCreationFailure => {
                    "RUNFILES_SYMLINKS_CREATION_FAILURE"
                }
                Self::TestEnvironmentSetupInterrupted => {
                    "TEST_ENVIRONMENT_SETUP_INTERRUPTED"
                }
            }
        }
        /// Creates an enum from field names used in the ProtoBuf definition.
        pub fn from_str_name(value: &str) -> ::core::option::Option<Self> {
            match value {
                "RUN_COMMAND_UNKNOWN" => Some(Self::RunCommandUnknown),
                "NO_TARGET_SPECIFIED" => Some(Self::NoTargetSpecified),
                "TOO_MANY_TARGETS_SPECIFIED" => Some(Self::TooManyTargetsSpecified),
                "TARGET_NOT_EXECUTABLE" => Some(Self::TargetNotExecutable),
                "TARGET_BUILT_BUT_PATH_NOT_EXECUTABLE" => {
                    Some(Self::TargetBuiltButPathNotExecutable)
                }
                "TARGET_BUILT_BUT_PATH_VALIDATION_FAILED" => {
                    Some(Self::TargetBuiltButPathValidationFailed)
                }
                "RUN_UNDER_TARGET_NOT_BUILT" => Some(Self::RunUnderTargetNotBuilt),
                "RUN_PREREQ_UNMET" => Some(Self::RunPrereqUnmet),
                "TOO_MANY_TEST_SHARDS_OR_RUNS" => Some(Self::TooManyTestShardsOrRuns),
                "TEST_ENVIRONMENT_SETUP_FAILURE" => {
                    Some(Self::TestEnvironmentSetupFailure)
                }
                "COMMAND_LINE_EXPANSION_FAILURE" => {
                    Some(Self::CommandLineExpansionFailure)
                }
                "NO_SHELL_SPECIFIED" => Some(Self::NoShellSpecified),
                "SCRIPT_WRITE_FAILURE" => Some(Self::ScriptWriteFailure),
                "RUNFILES_DIRECTORIES_CREATION_FAILURE" => {
                    Some(Self::RunfilesDirectoriesCreationFailure)
                }
                "RUNFILES_SYMLINKS_CREATION_FAILURE" => {
                    Some(Self::RunfilesSymlinksCreationFailure)
                }
                "TEST_ENVIRONMENT_SETUP_INTERRUPTED" => {
                    Some(Self::TestEnvironmentSetupInterrupted)
                }
                _ => None,
            }
        }
    }
}
#[derive(Clone, Copy, PartialEq, ::prost::Message)]
pub struct VersionCommand {
    #[prost(enumeration = "version_command::Code", tag = "1")]
    pub code: i32,
}
/// Nested message and enum types in `VersionCommand`.
pub mod version_command {
    #[derive(
        Clone,
        Copy,
        Debug,
        PartialEq,
        Eq,
        Hash,
        PartialOrd,
        Ord,
        ::prost::Enumeration
    )]
    #[repr(i32)]
    pub enum Code {
        VersionCommandUnknown = 0,
        NotAvailable = 1,
    }
    impl Code {
        /// String value of the enum field names used in the ProtoBuf definition.
        ///
        /// The values are not transformed in any way and thus are considered stable
        /// (if the ProtoBuf definition does not change) and safe for programmatic use.
        pub fn as_str_name(&self) -> &'static str {
            match self {
                Self::VersionCommandUnknown => "VERSION_COMMAND_UNKNOWN",
                Self::NotAvailable => "NOT_AVAILABLE",
            }
        }
        /// Creates an enum from field names used in the ProtoBuf definition.
        pub fn from_str_name(value: &str) -> ::core::option::Option<Self> {
            match value {
                "VERSION_COMMAND_UNKNOWN" => Some(Self::VersionCommandUnknown),
                "NOT_AVAILABLE" => Some(Self::NotAvailable),
                _ => None,
            }
        }
    }
}
#[derive(Clone, Copy, PartialEq, ::prost::Message)]
pub struct PrintActionCommand {
    #[prost(enumeration = "print_action_command::Code", tag = "1")]
    pub code: i32,
}
/// Nested message and enum types in `PrintActionCommand`.
pub mod print_action_command {
    #[derive(
        Clone,
        Copy,
        Debug,
        PartialEq,
        Eq,
        Hash,
        PartialOrd,
        Ord,
        ::prost::Enumeration
    )]
    #[repr(i32)]
    pub enum Code {
        PrintActionCommandUnknown = 0,
        TargetNotFound = 1,
        CommandLineExpansionFailure = 2,
        TargetKindUnsupported = 3,
        ActionsNotFound = 4,
    }
    impl Code {
        /// String value of the enum field names used in the ProtoBuf definition.
        ///
        /// The values are not transformed in any way and thus are considered stable
        /// (if the ProtoBuf definition does not change) and safe for programmatic use.
        pub fn as_str_name(&self) -> &'static str {
            match self {
                Self::PrintActionCommandUnknown => "PRINT_ACTION_COMMAND_UNKNOWN",
                Self::TargetNotFound => "TARGET_NOT_FOUND",
                Self::CommandLineExpansionFailure => "COMMAND_LINE_EXPANSION_FAILURE",
                Self::TargetKindUnsupported => "TARGET_KIND_UNSUPPORTED",
                Self::ActionsNotFound => "ACTIONS_NOT_FOUND",
            }
        }
        /// Creates an enum from field names used in the ProtoBuf definition.
        pub fn from_str_name(value: &str) -> ::core::option::Option<Self> {
            match value {
                "PRINT_ACTION_COMMAND_UNKNOWN" => Some(Self::PrintActionCommandUnknown),
                "TARGET_NOT_FOUND" => Some(Self::TargetNotFound),
                "COMMAND_LINE_EXPANSION_FAILURE" => {
                    Some(Self::CommandLineExpansionFailure)
                }
                "TARGET_KIND_UNSUPPORTED" => Some(Self::TargetKindUnsupported),
                "ACTIONS_NOT_FOUND" => Some(Self::ActionsNotFound),
                _ => None,
            }
        }
    }
}
#[derive(Clone, Copy, PartialEq, ::prost::Message)]
pub struct WorkspaceStatus {
    #[prost(enumeration = "workspace_status::Code", tag = "1")]
    pub code: i32,
}
/// Nested message and enum types in `WorkspaceStatus`.
pub mod workspace_status {
    #[derive(
        Clone,
        Copy,
        Debug,
        PartialEq,
        Eq,
        Hash,
        PartialOrd,
        Ord,
        ::prost::Enumeration
    )]
    #[repr(i32)]
    pub enum Code {
        WorkspaceStatusUnknown = 0,
        NonZeroExit = 1,
        AbnormalTermination = 2,
        ExecFailed = 3,
        ParseFailure = 4,
        ValidationFailure = 5,
        ContentUpdateIoException = 6,
        StderrIoException = 7,
    }
    impl Code {
        /// String value of the enum field names used in the ProtoBuf definition.
        ///
        /// The values are not transformed in any way and thus are considered stable
        /// (if the ProtoBuf definition does not change) and safe for programmatic use.
        pub fn as_str_name(&self) -> &'static str {
            match self {
                Self::WorkspaceStatusUnknown => "WORKSPACE_STATUS_UNKNOWN",
                Self::NonZeroExit => "NON_ZERO_EXIT",
                Self::AbnormalTermination => "ABNORMAL_TERMINATION",
                Self::ExecFailed => "EXEC_FAILED",
                Self::ParseFailure => "PARSE_FAILURE",
                Self::ValidationFailure => "VALIDATION_FAILURE",
                Self::ContentUpdateIoException => "CONTENT_UPDATE_IO_EXCEPTION",
                Self::StderrIoException => "STDERR_IO_EXCEPTION",
            }
        }
        /// Creates an enum from field names used in the ProtoBuf definition.
        pub fn from_str_name(value: &str) -> ::core::option::Option<Self> {
            match value {
                "WORKSPACE_STATUS_UNKNOWN" => Some(Self::WorkspaceStatusUnknown),
                "NON_ZERO_EXIT" => Some(Self::NonZeroExit),
                "ABNORMAL_TERMINATION" => Some(Self::AbnormalTermination),
                "EXEC_FAILED" => Some(Self::ExecFailed),
                "PARSE_FAILURE" => Some(Self::ParseFailure),
                "VALIDATION_FAILURE" => Some(Self::ValidationFailure),
                "CONTENT_UPDATE_IO_EXCEPTION" => Some(Self::ContentUpdateIoException),
                "STDERR_IO_EXCEPTION" => Some(Self::StderrIoException),
                _ => None,
            }
        }
    }
}
#[derive(Clone, Copy, PartialEq, ::prost::Message)]
pub struct JavaCompile {
    #[prost(enumeration = "java_compile::Code", tag = "1")]
    pub code: i32,
}
/// Nested message and enum types in `JavaCompile`.
pub mod java_compile {
    #[derive(
        Clone,
        Copy,
        Debug,
        PartialEq,
        Eq,
        Hash,
        PartialOrd,
        Ord,
        ::prost::Enumeration
    )]
    #[repr(i32)]
    pub enum Code {
        JavaCompileUnknown = 0,
        ReducedClasspathFailure = 1,
        CommandLineExpansionFailure = 2,
        JdepsReadIoException = 3,
        ReducedClasspathFallbackCleanupFailure = 4,
    }
    impl Code {
        /// String value of the enum field names used in the ProtoBuf definition.
        ///
        /// The values are not transformed in any way and thus are considered stable
        /// (if the ProtoBuf definition does not change) and safe for programmatic use.
        pub fn as_str_name(&self) -> &'static str {
            match self {
                Self::JavaCompileUnknown => "JAVA_COMPILE_UNKNOWN",
                Self::ReducedClasspathFailure => "REDUCED_CLASSPATH_FAILURE",
                Self::CommandLineExpansionFailure => "COMMAND_LINE_EXPANSION_FAILURE",
                Self::JdepsReadIoException => "JDEPS_READ_IO_EXCEPTION",
                Self::ReducedClasspathFallbackCleanupFailure => {
                    "REDUCED_CLASSPATH_FALLBACK_CLEANUP_FAILURE"
                }
            }
        }
        /// Creates an enum from field names used in the ProtoBuf definition.
        pub fn from_str_name(value: &str) -> ::core::option::Option<Self> {
            match value {
                "JAVA_COMPILE_UNKNOWN" => Some(Self::JavaCompileUnknown),
                "REDUCED_CLASSPATH_FAILURE" => Some(Self::ReducedClasspathFailure),
                "COMMAND_LINE_EXPANSION_FAILURE" => {
                    Some(Self::CommandLineExpansionFailure)
                }
                "JDEPS_READ_IO_EXCEPTION" => Some(Self::JdepsReadIoException),
                "REDUCED_CLASSPATH_FALLBACK_CLEANUP_FAILURE" => {
                    Some(Self::ReducedClasspathFallbackCleanupFailure)
                }
                _ => None,
            }
        }
    }
}
#[derive(Clone, Copy, PartialEq, ::prost::Message)]
pub struct ActionRewinding {
    #[prost(enumeration = "action_rewinding::Code", tag = "1")]
    pub code: i32,
}
/// Nested message and enum types in `ActionRewinding`.
pub mod action_rewinding {
    #[derive(
        Clone,
        Copy,
        Debug,
        PartialEq,
        Eq,
        Hash,
        PartialOrd,
        Ord,
        ::prost::Enumeration
    )]
    #[repr(i32)]
    pub enum Code {
        ActionRewindingUnknown = 0,
        LostInputTooManyTimes = 1,
        RewindLostInputsPrereqUnmet = 3,
        LostOutputTooManyTimes = 4,
        LostInputRewindingDisabled = 5,
        LostOutputRewindingDisabled = 6,
        /// Deprecated: attempting to rewind a source artifact is now a hard crash.
        DeprecatedLostInputIsSource = 2,
    }
    impl Code {
        /// String value of the enum field names used in the ProtoBuf definition.
        ///
        /// The values are not transformed in any way and thus are considered stable
        /// (if the ProtoBuf definition does not change) and safe for programmatic use.
        pub fn as_str_name(&self) -> &'static str {
            match self {
                Self::ActionRewindingUnknown => "ACTION_REWINDING_UNKNOWN",
                Self::LostInputTooManyTimes => "LOST_INPUT_TOO_MANY_TIMES",
                Self::RewindLostInputsPrereqUnmet => "REWIND_LOST_INPUTS_PREREQ_UNMET",
                Self::LostOutputTooManyTimes => "LOST_OUTPUT_TOO_MANY_TIMES",
                Self::LostInputRewindingDisabled => "LOST_INPUT_REWINDING_DISABLED",
                Self::LostOutputRewindingDisabled => "LOST_OUTPUT_REWINDING_DISABLED",
                Self::DeprecatedLostInputIsSource => "DEPRECATED_LOST_INPUT_IS_SOURCE",
            }
        }
        /// Creates an enum from field names used in the ProtoBuf definition.
        pub fn from_str_name(value: &str) -> ::core::option::Option<Self> {
            match value {
                "ACTION_REWINDING_UNKNOWN" => Some(Self::ActionRewindingUnknown),
                "LOST_INPUT_TOO_MANY_TIMES" => Some(Self::LostInputTooManyTimes),
                "REWIND_LOST_INPUTS_PREREQ_UNMET" => {
                    Some(Self::RewindLostInputsPrereqUnmet)
                }
                "LOST_OUTPUT_TOO_MANY_TIMES" => Some(Self::LostOutputTooManyTimes),
                "LOST_INPUT_REWINDING_DISABLED" => Some(Self::LostInputRewindingDisabled),
                "LOST_OUTPUT_REWINDING_DISABLED" => {
                    Some(Self::LostOutputRewindingDisabled)
                }
                "DEPRECATED_LOST_INPUT_IS_SOURCE" => {
                    Some(Self::DeprecatedLostInputIsSource)
                }
                _ => None,
            }
        }
    }
}
#[derive(Clone, Copy, PartialEq, ::prost::Message)]
pub struct CppCompile {
    #[prost(enumeration = "cpp_compile::Code", tag = "1")]
    pub code: i32,
}
/// Nested message and enum types in `CppCompile`.
pub mod cpp_compile {
    #[derive(
        Clone,
        Copy,
        Debug,
        PartialEq,
        Eq,
        Hash,
        PartialOrd,
        Ord,
        ::prost::Enumeration
    )]
    #[repr(i32)]
    pub enum Code {
        CppCompileUnknown = 0,
        FindUsedHeadersIoException = 1,
        CopyOutErrFailure = 2,
        DFileReadFailure = 3,
        CommandGenerationFailure = 4,
        ModuleExpansionTimeout = 5,
        IncludePathOutsideExecRoot = 6,
        FakeCommandGenerationFailure = 7,
        UndeclaredInclusions = 8,
        DFileParseFailure = 9,
        CoverageNotesCreationFailure = 10,
        ModuleExpansionMissingData = 11,
    }
    impl Code {
        /// String value of the enum field names used in the ProtoBuf definition.
        ///
        /// The values are not transformed in any way and thus are considered stable
        /// (if the ProtoBuf definition does not change) and safe for programmatic use.
        pub fn as_str_name(&self) -> &'static str {
            match self {
                Self::CppCompileUnknown => "CPP_COMPILE_UNKNOWN",
                Self::FindUsedHeadersIoException => "FIND_USED_HEADERS_IO_EXCEPTION",
                Self::CopyOutErrFailure => "COPY_OUT_ERR_FAILURE",
                Self::DFileReadFailure => "D_FILE_READ_FAILURE",
                Self::CommandGenerationFailure => "COMMAND_GENERATION_FAILURE",
                Self::ModuleExpansionTimeout => "MODULE_EXPANSION_TIMEOUT",
                Self::IncludePathOutsideExecRoot => "INCLUDE_PATH_OUTSIDE_EXEC_ROOT",
                Self::FakeCommandGenerationFailure => "FAKE_COMMAND_GENERATION_FAILURE",
                Self::UndeclaredInclusions => "UNDECLARED_INCLUSIONS",
                Self::DFileParseFailure => "D_FILE_PARSE_FAILURE",
                Self::CoverageNotesCreationFailure => "COVERAGE_NOTES_CREATION_FAILURE",
                Self::ModuleExpansionMissingData => "MODULE_EXPANSION_MISSING_DATA",
            }
        }
        /// Creates an enum from field names used in the ProtoBuf definition.
        pub fn from_str_name(value: &str) -> ::core::option::Option<Self> {
            match value {
                "CPP_COMPILE_UNKNOWN" => Some(Self::CppCompileUnknown),
                "FIND_USED_HEADERS_IO_EXCEPTION" => {
                    Some(Self::FindUsedHeadersIoException)
                }
                "COPY_OUT_ERR_FAILURE" => Some(Self::CopyOutErrFailure),
                "D_FILE_READ_FAILURE" => Some(Self::DFileReadFailure),
                "COMMAND_GENERATION_FAILURE" => Some(Self::CommandGenerationFailure),
                "MODULE_EXPANSION_TIMEOUT" => Some(Self::ModuleExpansionTimeout),
                "INCLUDE_PATH_OUTSIDE_EXEC_ROOT" => {
                    Some(Self::IncludePathOutsideExecRoot)
                }
                "FAKE_COMMAND_GENERATION_FAILURE" => {
                    Some(Self::FakeCommandGenerationFailure)
                }
                "UNDECLARED_INCLUSIONS" => Some(Self::UndeclaredInclusions),
                "D_FILE_PARSE_FAILURE" => Some(Self::DFileParseFailure),
                "COVERAGE_NOTES_CREATION_FAILURE" => {
                    Some(Self::CoverageNotesCreationFailure)
                }
                "MODULE_EXPANSION_MISSING_DATA" => Some(Self::ModuleExpansionMissingData),
                _ => None,
            }
        }
    }
}
#[derive(Clone, Copy, PartialEq, ::prost::Message)]
pub struct StarlarkAction {
    #[prost(enumeration = "starlark_action::Code", tag = "1")]
    pub code: i32,
}
/// Nested message and enum types in `StarlarkAction`.
pub mod starlark_action {
    #[derive(
        Clone,
        Copy,
        Debug,
        PartialEq,
        Eq,
        Hash,
        PartialOrd,
        Ord,
        ::prost::Enumeration
    )]
    #[repr(i32)]
    pub enum Code {
        StarlarkActionUnknown = 0,
        UnusedInputListReadFailure = 1,
        UnusedInputListFileNotFound = 2,
    }
    impl Code {
        /// String value of the enum field names used in the ProtoBuf definition.
        ///
        /// The values are not transformed in any way and thus are considered stable
        /// (if the ProtoBuf definition does not change) and safe for programmatic use.
        pub fn as_str_name(&self) -> &'static str {
            match self {
                Self::StarlarkActionUnknown => "STARLARK_ACTION_UNKNOWN",
                Self::UnusedInputListReadFailure => "UNUSED_INPUT_LIST_READ_FAILURE",
                Self::UnusedInputListFileNotFound => "UNUSED_INPUT_LIST_FILE_NOT_FOUND",
            }
        }
        /// Creates an enum from field names used in the ProtoBuf definition.
        pub fn from_str_name(value: &str) -> ::core::option::Option<Self> {
            match value {
                "STARLARK_ACTION_UNKNOWN" => Some(Self::StarlarkActionUnknown),
                "UNUSED_INPUT_LIST_READ_FAILURE" => {
                    Some(Self::UnusedInputListReadFailure)
                }
                "UNUSED_INPUT_LIST_FILE_NOT_FOUND" => {
                    Some(Self::UnusedInputListFileNotFound)
                }
                _ => None,
            }
        }
    }
}
#[derive(Clone, Copy, PartialEq, ::prost::Message)]
pub struct NinjaAction {
    #[prost(enumeration = "ninja_action::Code", tag = "1")]
    pub code: i32,
}
/// Nested message and enum types in `NinjaAction`.
pub mod ninja_action {
    #[derive(
        Clone,
        Copy,
        Debug,
        PartialEq,
        Eq,
        Hash,
        PartialOrd,
        Ord,
        ::prost::Enumeration
    )]
    #[repr(i32)]
    pub enum Code {
        NinjaActionUnknown = 0,
        InvalidDepfileDeclaredDependency = 1,
        DFileParseFailure = 2,
    }
    impl Code {
        /// String value of the enum field names used in the ProtoBuf definition.
        ///
        /// The values are not transformed in any way and thus are considered stable
        /// (if the ProtoBuf definition does not change) and safe for programmatic use.
        pub fn as_str_name(&self) -> &'static str {
            match self {
                Self::NinjaActionUnknown => "NINJA_ACTION_UNKNOWN",
                Self::InvalidDepfileDeclaredDependency => {
                    "INVALID_DEPFILE_DECLARED_DEPENDENCY"
                }
                Self::DFileParseFailure => "D_FILE_PARSE_FAILURE",
            }
        }
        /// Creates an enum from field names used in the ProtoBuf definition.
        pub fn from_str_name(value: &str) -> ::core::option::Option<Self> {
            match value {
                "NINJA_ACTION_UNKNOWN" => Some(Self::NinjaActionUnknown),
                "INVALID_DEPFILE_DECLARED_DEPENDENCY" => {
                    Some(Self::InvalidDepfileDeclaredDependency)
                }
                "D_FILE_PARSE_FAILURE" => Some(Self::DFileParseFailure),
                _ => None,
            }
        }
    }
}
#[derive(Clone, Copy, PartialEq, ::prost::Message)]
pub struct DynamicExecution {
    #[prost(enumeration = "dynamic_execution::Code", tag = "1")]
    pub code: i32,
}
/// Nested message and enum types in `DynamicExecution`.
pub mod dynamic_execution {
    #[derive(
        Clone,
        Copy,
        Debug,
        PartialEq,
        Eq,
        Hash,
        PartialOrd,
        Ord,
        ::prost::Enumeration
    )]
    #[repr(i32)]
    pub enum Code {
        DynamicExecutionUnknown = 0,
        XcodeRelatedPrereqUnmet = 1,
        ActionLogMoveFailure = 2,
        RunFailure = 3,
        NoUsableStrategyFound = 4,
    }
    impl Code {
        /// String value of the enum field names used in the ProtoBuf definition.
        ///
        /// The values are not transformed in any way and thus are considered stable
        /// (if the ProtoBuf definition does not change) and safe for programmatic use.
        pub fn as_str_name(&self) -> &'static str {
            match self {
                Self::DynamicExecutionUnknown => "DYNAMIC_EXECUTION_UNKNOWN",
                Self::XcodeRelatedPrereqUnmet => "XCODE_RELATED_PREREQ_UNMET",
                Self::ActionLogMoveFailure => "ACTION_LOG_MOVE_FAILURE",
                Self::RunFailure => "RUN_FAILURE",
                Self::NoUsableStrategyFound => "NO_USABLE_STRATEGY_FOUND",
            }
        }
        /// Creates an enum from field names used in the ProtoBuf definition.
        pub fn from_str_name(value: &str) -> ::core::option::Option<Self> {
            match value {
                "DYNAMIC_EXECUTION_UNKNOWN" => Some(Self::DynamicExecutionUnknown),
                "XCODE_RELATED_PREREQ_UNMET" => Some(Self::XcodeRelatedPrereqUnmet),
                "ACTION_LOG_MOVE_FAILURE" => Some(Self::ActionLogMoveFailure),
                "RUN_FAILURE" => Some(Self::RunFailure),
                "NO_USABLE_STRATEGY_FOUND" => Some(Self::NoUsableStrategyFound),
                _ => None,
            }
        }
    }
}
#[derive(Clone, Copy, PartialEq, ::prost::Message)]
pub struct FailAction {
    #[prost(enumeration = "fail_action::Code", tag = "1")]
    pub code: i32,
}
/// Nested message and enum types in `FailAction`.
pub mod fail_action {
    #[derive(
        Clone,
        Copy,
        Debug,
        PartialEq,
        Eq,
        Hash,
        PartialOrd,
        Ord,
        ::prost::Enumeration
    )]
    #[repr(i32)]
    pub enum Code {
        FailActionUnknown = 0,
        IntentionalFailure = 1,
        IncorrectPythonVersion = 2,
        ProguardSpecsMissing = 3,
        DynamicLinkingNotSupported = 4,
        SourceFilesMissing = 5,
        IncorrectToolchain = 6,
        FragmentClassMissing = 7,
        CantBuildIncompatibleTarget = 10,
    }
    impl Code {
        /// String value of the enum field names used in the ProtoBuf definition.
        ///
        /// The values are not transformed in any way and thus are considered stable
        /// (if the ProtoBuf definition does not change) and safe for programmatic use.
        pub fn as_str_name(&self) -> &'static str {
            match self {
                Self::FailActionUnknown => "FAIL_ACTION_UNKNOWN",
                Self::IntentionalFailure => "INTENTIONAL_FAILURE",
                Self::IncorrectPythonVersion => "INCORRECT_PYTHON_VERSION",
                Self::ProguardSpecsMissing => "PROGUARD_SPECS_MISSING",
                Self::DynamicLinkingNotSupported => "DYNAMIC_LINKING_NOT_SUPPORTED",
                Self::SourceFilesMissing => "SOURCE_FILES_MISSING",
                Self::IncorrectToolchain => "INCORRECT_TOOLCHAIN",
                Self::FragmentClassMissing => "FRAGMENT_CLASS_MISSING",
                Self::CantBuildIncompatibleTarget => "CANT_BUILD_INCOMPATIBLE_TARGET",
            }
        }
        /// Creates an enum from field names used in the ProtoBuf definition.
        pub fn from_str_name(value: &str) -> ::core::option::Option<Self> {
            match value {
                "FAIL_ACTION_UNKNOWN" => Some(Self::FailActionUnknown),
                "INTENTIONAL_FAILURE" => Some(Self::IntentionalFailure),
                "INCORRECT_PYTHON_VERSION" => Some(Self::IncorrectPythonVersion),
                "PROGUARD_SPECS_MISSING" => Some(Self::ProguardSpecsMissing),
                "DYNAMIC_LINKING_NOT_SUPPORTED" => Some(Self::DynamicLinkingNotSupported),
                "SOURCE_FILES_MISSING" => Some(Self::SourceFilesMissing),
                "INCORRECT_TOOLCHAIN" => Some(Self::IncorrectToolchain),
                "FRAGMENT_CLASS_MISSING" => Some(Self::FragmentClassMissing),
                "CANT_BUILD_INCOMPATIBLE_TARGET" => {
                    Some(Self::CantBuildIncompatibleTarget)
                }
                _ => None,
            }
        }
    }
}
#[derive(Clone, Copy, PartialEq, ::prost::Message)]
pub struct SymlinkAction {
    #[prost(enumeration = "symlink_action::Code", tag = "1")]
    pub code: i32,
}
/// Nested message and enum types in `SymlinkAction`.
pub mod symlink_action {
    #[derive(
        Clone,
        Copy,
        Debug,
        PartialEq,
        Eq,
        Hash,
        PartialOrd,
        Ord,
        ::prost::Enumeration
    )]
    #[repr(i32)]
    pub enum Code {
        SymlinkActionUnknown = 0,
        ExecutableInputNotFile = 1,
        ExecutableInputIsNot = 2,
        ExecutableInputCheckIoException = 3,
        LinkCreationIoException = 4,
        LinkTouchIoException = 5,
        LinkLogIoException = 6,
    }
    impl Code {
        /// String value of the enum field names used in the ProtoBuf definition.
        ///
        /// The values are not transformed in any way and thus are considered stable
        /// (if the ProtoBuf definition does not change) and safe for programmatic use.
        pub fn as_str_name(&self) -> &'static str {
            match self {
                Self::SymlinkActionUnknown => "SYMLINK_ACTION_UNKNOWN",
                Self::ExecutableInputNotFile => "EXECUTABLE_INPUT_NOT_FILE",
                Self::ExecutableInputIsNot => "EXECUTABLE_INPUT_IS_NOT",
                Self::ExecutableInputCheckIoException => {
                    "EXECUTABLE_INPUT_CHECK_IO_EXCEPTION"
                }
                Self::LinkCreationIoException => "LINK_CREATION_IO_EXCEPTION",
                Self::LinkTouchIoException => "LINK_TOUCH_IO_EXCEPTION",
                Self::LinkLogIoException => "LINK_LOG_IO_EXCEPTION",
            }
        }
        /// Creates an enum from field names used in the ProtoBuf definition.
        pub fn from_str_name(value: &str) -> ::core::option::Option<Self> {
            match value {
                "SYMLINK_ACTION_UNKNOWN" => Some(Self::SymlinkActionUnknown),
                "EXECUTABLE_INPUT_NOT_FILE" => Some(Self::ExecutableInputNotFile),
                "EXECUTABLE_INPUT_IS_NOT" => Some(Self::ExecutableInputIsNot),
                "EXECUTABLE_INPUT_CHECK_IO_EXCEPTION" => {
                    Some(Self::ExecutableInputCheckIoException)
                }
                "LINK_CREATION_IO_EXCEPTION" => Some(Self::LinkCreationIoException),
                "LINK_TOUCH_IO_EXCEPTION" => Some(Self::LinkTouchIoException),
                "LINK_LOG_IO_EXCEPTION" => Some(Self::LinkLogIoException),
                _ => None,
            }
        }
    }
}
#[derive(Clone, Copy, PartialEq, ::prost::Message)]
pub struct CppLink {
    #[prost(enumeration = "cpp_link::Code", tag = "1")]
    pub code: i32,
}
/// Nested message and enum types in `CppLink`.
pub mod cpp_link {
    #[derive(
        Clone,
        Copy,
        Debug,
        PartialEq,
        Eq,
        Hash,
        PartialOrd,
        Ord,
        ::prost::Enumeration
    )]
    #[repr(i32)]
    pub enum Code {
        CppLinkUnknown = 0,
        CommandGenerationFailure = 1,
        FakeCommandGenerationFailure = 2,
    }
    impl Code {
        /// String value of the enum field names used in the ProtoBuf definition.
        ///
        /// The values are not transformed in any way and thus are considered stable
        /// (if the ProtoBuf definition does not change) and safe for programmatic use.
        pub fn as_str_name(&self) -> &'static str {
            match self {
                Self::CppLinkUnknown => "CPP_LINK_UNKNOWN",
                Self::CommandGenerationFailure => "COMMAND_GENERATION_FAILURE",
                Self::FakeCommandGenerationFailure => "FAKE_COMMAND_GENERATION_FAILURE",
            }
        }
        /// Creates an enum from field names used in the ProtoBuf definition.
        pub fn from_str_name(value: &str) -> ::core::option::Option<Self> {
            match value {
                "CPP_LINK_UNKNOWN" => Some(Self::CppLinkUnknown),
                "COMMAND_GENERATION_FAILURE" => Some(Self::CommandGenerationFailure),
                "FAKE_COMMAND_GENERATION_FAILURE" => {
                    Some(Self::FakeCommandGenerationFailure)
                }
                _ => None,
            }
        }
    }
}
#[derive(Clone, Copy, PartialEq, ::prost::Message)]
pub struct LtoAction {
    #[prost(enumeration = "lto_action::Code", tag = "1")]
    pub code: i32,
}
/// Nested message and enum types in `LtoAction`.
pub mod lto_action {
    #[derive(
        Clone,
        Copy,
        Debug,
        PartialEq,
        Eq,
        Hash,
        PartialOrd,
        Ord,
        ::prost::Enumeration
    )]
    #[repr(i32)]
    pub enum Code {
        LtoActionUnknown = 0,
        InvalidAbsolutePathInImports = 1,
        MissingBitcodeFiles = 2,
        ImportsReadIoException = 3,
    }
    impl Code {
        /// String value of the enum field names used in the ProtoBuf definition.
        ///
        /// The values are not transformed in any way and thus are considered stable
        /// (if the ProtoBuf definition does not change) and safe for programmatic use.
        pub fn as_str_name(&self) -> &'static str {
            match self {
                Self::LtoActionUnknown => "LTO_ACTION_UNKNOWN",
                Self::InvalidAbsolutePathInImports => "INVALID_ABSOLUTE_PATH_IN_IMPORTS",
                Self::MissingBitcodeFiles => "MISSING_BITCODE_FILES",
                Self::ImportsReadIoException => "IMPORTS_READ_IO_EXCEPTION",
            }
        }
        /// Creates an enum from field names used in the ProtoBuf definition.
        pub fn from_str_name(value: &str) -> ::core::option::Option<Self> {
            match value {
                "LTO_ACTION_UNKNOWN" => Some(Self::LtoActionUnknown),
                "INVALID_ABSOLUTE_PATH_IN_IMPORTS" => {
                    Some(Self::InvalidAbsolutePathInImports)
                }
                "MISSING_BITCODE_FILES" => Some(Self::MissingBitcodeFiles),
                "IMPORTS_READ_IO_EXCEPTION" => Some(Self::ImportsReadIoException),
                _ => None,
            }
        }
    }
}
#[derive(Clone, Copy, PartialEq, ::prost::Message)]
pub struct TestAction {
    #[prost(enumeration = "test_action::Code", tag = "1")]
    pub code: i32,
}
/// Nested message and enum types in `TestAction`.
pub mod test_action {
    #[derive(
        Clone,
        Copy,
        Debug,
        PartialEq,
        Eq,
        Hash,
        PartialOrd,
        Ord,
        ::prost::Enumeration
    )]
    #[repr(i32)]
    pub enum Code {
        TestActionUnknown = 0,
        NoKeepGoingTestFailure = 1,
        LocalTestPrereqUnmet = 2,
        CommandLineExpansionFailure = 3,
        DuplicateCpuTags = 4,
        InvalidCpuTag = 5,
    }
    impl Code {
        /// String value of the enum field names used in the ProtoBuf definition.
        ///
        /// The values are not transformed in any way and thus are considered stable
        /// (if the ProtoBuf definition does not change) and safe for programmatic use.
        pub fn as_str_name(&self) -> &'static str {
            match self {
                Self::TestActionUnknown => "TEST_ACTION_UNKNOWN",
                Self::NoKeepGoingTestFailure => "NO_KEEP_GOING_TEST_FAILURE",
                Self::LocalTestPrereqUnmet => "LOCAL_TEST_PREREQ_UNMET",
                Self::CommandLineExpansionFailure => "COMMAND_LINE_EXPANSION_FAILURE",
                Self::DuplicateCpuTags => "DUPLICATE_CPU_TAGS",
                Self::InvalidCpuTag => "INVALID_CPU_TAG",
            }
        }
        /// Creates an enum from field names used in the ProtoBuf definition.
        pub fn from_str_name(value: &str) -> ::core::option::Option<Self> {
            match value {
                "TEST_ACTION_UNKNOWN" => Some(Self::TestActionUnknown),
                "NO_KEEP_GOING_TEST_FAILURE" => Some(Self::NoKeepGoingTestFailure),
                "LOCAL_TEST_PREREQ_UNMET" => Some(Self::LocalTestPrereqUnmet),
                "COMMAND_LINE_EXPANSION_FAILURE" => {
                    Some(Self::CommandLineExpansionFailure)
                }
                "DUPLICATE_CPU_TAGS" => Some(Self::DuplicateCpuTags),
                "INVALID_CPU_TAG" => Some(Self::InvalidCpuTag),
                _ => None,
            }
        }
    }
}
#[derive(Clone, Copy, PartialEq, ::prost::Message)]
pub struct Worker {
    #[prost(enumeration = "worker::Code", tag = "1")]
    pub code: i32,
}
/// Nested message and enum types in `Worker`.
pub mod worker {
    #[derive(
        Clone,
        Copy,
        Debug,
        PartialEq,
        Eq,
        Hash,
        PartialOrd,
        Ord,
        ::prost::Enumeration
    )]
    #[repr(i32)]
    pub enum Code {
        WorkerUnknown = 0,
        MultiplexerInstanceRemovalFailure = 1,
        MultiplexerDoesNotExist = 2,
        NoTools = 3,
        NoFlagfile = 4,
        VirtualInputMaterializationFailure = 5,
        BorrowFailure = 6,
        PrefetchFailure = 7,
        PrepareFailure = 8,
        RequestFailure = 9,
        ParseResponseFailure = 10,
        NoResponse = 11,
        FinishFailure = 12,
        ForbiddenInput = 13,
    }
    impl Code {
        /// String value of the enum field names used in the ProtoBuf definition.
        ///
        /// The values are not transformed in any way and thus are considered stable
        /// (if the ProtoBuf definition does not change) and safe for programmatic use.
        pub fn as_str_name(&self) -> &'static str {
            match self {
                Self::WorkerUnknown => "WORKER_UNKNOWN",
                Self::MultiplexerInstanceRemovalFailure => {
                    "MULTIPLEXER_INSTANCE_REMOVAL_FAILURE"
                }
                Self::MultiplexerDoesNotExist => "MULTIPLEXER_DOES_NOT_EXIST",
                Self::NoTools => "NO_TOOLS",
                Self::NoFlagfile => "NO_FLAGFILE",
                Self::VirtualInputMaterializationFailure => {
                    "VIRTUAL_INPUT_MATERIALIZATION_FAILURE"
                }
                Self::BorrowFailure => "BORROW_FAILURE",
                Self::PrefetchFailure => "PREFETCH_FAILURE",
                Self::PrepareFailure => "PREPARE_FAILURE",
                Self::RequestFailure => "REQUEST_FAILURE",
                Self::ParseResponseFailure => "PARSE_RESPONSE_FAILURE",
                Self::NoResponse => "NO_RESPONSE",
                Self::FinishFailure => "FINISH_FAILURE",
                Self::ForbiddenInput => "FORBIDDEN_INPUT",
            }
        }
        /// Creates an enum from field names used in the ProtoBuf definition.
        pub fn from_str_name(value: &str) -> ::core::option::Option<Self> {
            match value {
                "WORKER_UNKNOWN" => Some(Self::WorkerUnknown),
                "MULTIPLEXER_INSTANCE_REMOVAL_FAILURE" => {
                    Some(Self::MultiplexerInstanceRemovalFailure)
                }
                "MULTIPLEXER_DOES_NOT_EXIST" => Some(Self::MultiplexerDoesNotExist),
                "NO_TOOLS" => Some(Self::NoTools),
                "NO_FLAGFILE" => Some(Self::NoFlagfile),
                "VIRTUAL_INPUT_MATERIALIZATION_FAILURE" => {
                    Some(Self::VirtualInputMaterializationFailure)
                }
                "BORROW_FAILURE" => Some(Self::BorrowFailure),
                "PREFETCH_FAILURE" => Some(Self::PrefetchFailure),
                "PREPARE_FAILURE" => Some(Self::PrepareFailure),
                "REQUEST_FAILURE" => Some(Self::RequestFailure),
                "PARSE_RESPONSE_FAILURE" => Some(Self::ParseResponseFailure),
                "NO_RESPONSE" => Some(Self::NoResponse),
                "FINISH_FAILURE" => Some(Self::FinishFailure),
                "FORBIDDEN_INPUT" => Some(Self::ForbiddenInput),
                _ => None,
            }
        }
    }
}
#[derive(Clone, Copy, PartialEq, ::prost::Message)]
pub struct Analysis {
    #[prost(enumeration = "analysis::Code", tag = "1")]
    pub code: i32,
}
/// Nested message and enum types in `Analysis`.
pub mod analysis {
    #[derive(
        Clone,
        Copy,
        Debug,
        PartialEq,
        Eq,
        Hash,
        PartialOrd,
        Ord,
        ::prost::Enumeration
    )]
    #[repr(i32)]
    pub enum Code {
        AnalysisUnknown = 0,
        LoadFailure = 1,
        /// TODO(b/138456686): this code should be deprecated in favor of more finely
        ///    resolved loading-phase codes.
        GenericLoadingPhaseFailure = 2,
        NotAllTargetsAnalyzed = 3,
        Cycle = 4,
        ParameterizedTopLevelAspectInvalid = 5,
        AspectLabelSyntaxError = 6,
        AspectPrereqUnmet = 7,
        AspectNotFound = 8,
        ActionConflict = 9,
        ArtifactPrefixConflict = 10,
        UnexpectedAnalysisException = 11,
        TargetsMissingEnvironments = 12,
        InvalidEnvironment = 13,
        EnvironmentMissingFromGroups = 14,
        ExecGroupMissing = 15,
        InvalidExecutionPlatform = 16,
        AspectCreationFailed = 17,
        ConfiguredValueCreationFailed = 18,
        IncompatibleTargetRequested = 19,
        AnalysisFailurePropagationFailed = 20,
        AnalysisCacheDiscarded = 21,
    }
    impl Code {
        /// String value of the enum field names used in the ProtoBuf definition.
        ///
        /// The values are not transformed in any way and thus are considered stable
        /// (if the ProtoBuf definition does not change) and safe for programmatic use.
        pub fn as_str_name(&self) -> &'static str {
            match self {
                Self::AnalysisUnknown => "ANALYSIS_UNKNOWN",
                Self::LoadFailure => "LOAD_FAILURE",
                Self::GenericLoadingPhaseFailure => "GENERIC_LOADING_PHASE_FAILURE",
                Self::NotAllTargetsAnalyzed => "NOT_ALL_TARGETS_ANALYZED",
                Self::Cycle => "CYCLE",
                Self::ParameterizedTopLevelAspectInvalid => {
                    "PARAMETERIZED_TOP_LEVEL_ASPECT_INVALID"
                }
                Self::AspectLabelSyntaxError => "ASPECT_LABEL_SYNTAX_ERROR",
                Self::AspectPrereqUnmet => "ASPECT_PREREQ_UNMET",
                Self::AspectNotFound => "ASPECT_NOT_FOUND",
                Self::ActionConflict => "ACTION_CONFLICT",
                Self::ArtifactPrefixConflict => "ARTIFACT_PREFIX_CONFLICT",
                Self::UnexpectedAnalysisException => "UNEXPECTED_ANALYSIS_EXCEPTION",
                Self::TargetsMissingEnvironments => "TARGETS_MISSING_ENVIRONMENTS",
                Self::InvalidEnvironment => "INVALID_ENVIRONMENT",
                Self::EnvironmentMissingFromGroups => "ENVIRONMENT_MISSING_FROM_GROUPS",
                Self::ExecGroupMissing => "EXEC_GROUP_MISSING",
                Self::InvalidExecutionPlatform => "INVALID_EXECUTION_PLATFORM",
                Self::AspectCreationFailed => "ASPECT_CREATION_FAILED",
                Self::ConfiguredValueCreationFailed => "CONFIGURED_VALUE_CREATION_FAILED",
                Self::IncompatibleTargetRequested => "INCOMPATIBLE_TARGET_REQUESTED",
                Self::AnalysisFailurePropagationFailed => {
                    "ANALYSIS_FAILURE_PROPAGATION_FAILED"
                }
                Self::AnalysisCacheDiscarded => "ANALYSIS_CACHE_DISCARDED",
            }
        }
        /// Creates an enum from field names used in the ProtoBuf definition.
        pub fn from_str_name(value: &str) -> ::core::option::Option<Self> {
            match value {
                "ANALYSIS_UNKNOWN" => Some(Self::AnalysisUnknown),
                "LOAD_FAILURE" => Some(Self::LoadFailure),
                "GENERIC_LOADING_PHASE_FAILURE" => Some(Self::GenericLoadingPhaseFailure),
                "NOT_ALL_TARGETS_ANALYZED" => Some(Self::NotAllTargetsAnalyzed),
                "CYCLE" => Some(Self::Cycle),
                "PARAMETERIZED_TOP_LEVEL_ASPECT_INVALID" => {
                    Some(Self::ParameterizedTopLevelAspectInvalid)
                }
                "ASPECT_LABEL_SYNTAX_ERROR" => Some(Self::AspectLabelSyntaxError),
                "ASPECT_PREREQ_UNMET" => Some(Self::AspectPrereqUnmet),
                "ASPECT_NOT_FOUND" => Some(Self::AspectNotFound),
                "ACTION_CONFLICT" => Some(Self::ActionConflict),
                "ARTIFACT_PREFIX_CONFLICT" => Some(Self::ArtifactPrefixConflict),
                "UNEXPECTED_ANALYSIS_EXCEPTION" => {
                    Some(Self::UnexpectedAnalysisException)
                }
                "TARGETS_MISSING_ENVIRONMENTS" => Some(Self::TargetsMissingEnvironments),
                "INVALID_ENVIRONMENT" => Some(Self::InvalidEnvironment),
                "ENVIRONMENT_MISSING_FROM_GROUPS" => {
                    Some(Self::EnvironmentMissingFromGroups)
                }
                "EXEC_GROUP_MISSING" => Some(Self::ExecGroupMissing),
                "INVALID_EXECUTION_PLATFORM" => Some(Self::InvalidExecutionPlatform),
                "ASPECT_CREATION_FAILED" => Some(Self::AspectCreationFailed),
                "CONFIGURED_VALUE_CREATION_FAILED" => {
                    Some(Self::ConfiguredValueCreationFailed)
                }
                "INCOMPATIBLE_TARGET_REQUESTED" => {
                    Some(Self::IncompatibleTargetRequested)
                }
                "ANALYSIS_FAILURE_PROPAGATION_FAILED" => {
                    Some(Self::AnalysisFailurePropagationFailed)
                }
                "ANALYSIS_CACHE_DISCARDED" => Some(Self::AnalysisCacheDiscarded),
                _ => None,
            }
        }
    }
}
#[derive(Clone, Copy, PartialEq, ::prost::Message)]
pub struct PackageLoading {
    #[prost(enumeration = "package_loading::Code", tag = "1")]
    pub code: i32,
}
/// Nested message and enum types in `PackageLoading`.
pub mod package_loading {
    #[derive(
        Clone,
        Copy,
        Debug,
        PartialEq,
        Eq,
        Hash,
        PartialOrd,
        Ord,
        ::prost::Enumeration
    )]
    #[repr(i32)]
    pub enum Code {
        PackageLoadingUnknown = 0,
        WorkspaceFileError = 1,
        MaxComputationStepsExceeded = 2,
        BuildFileMissing = 3,
        RepositoryMissing = 4,
        PersistentInconsistentFilesystemError = 5,
        TransientInconsistentFilesystemError = 6,
        InvalidName = 7,
        EvalGlobsSymlinkError = 9,
        ImportStarlarkFileError = 10,
        PackageMissing = 11,
        TargetMissing = 12,
        NoSuchThing = 13,
        GlobIoException = 14,
        DuplicateLabel = 15,
        InvalidPackageSpecification = 16,
        SyntaxError = 17,
        EnvironmentInDifferentPackage = 18,
        DefaultEnvironmentUndeclared = 19,
        EnvironmentInMultipleGroups = 20,
        EnvironmentDoesNotExist = 21,
        EnvironmentInvalid = 22,
        EnvironmentNotInGroup = 23,
        PackageNameInvalid = 24,
        StarlarkEvalError = 25,
        LicenseParseFailure = 26,
        DistributionsParseFailure = 27,
        LabelCrossesPackageBoundary = 28,
        /// Failure while evaluating or applying @_builtins injection. Since the
        /// builtins .bzl files are always packaged with Blaze in production, a
        /// failure here generally indicates a bug in Blaze.
        BuiltinsInjectionFailure = 29,
        SymlinkCycleOrInfiniteExpansion = 30,
        OtherIoException = 31,
        BadRepoFile = 32,
    }
    impl Code {
        /// String value of the enum field names used in the ProtoBuf definition.
        ///
        /// The values are not transformed in any way and thus are considered stable
        /// (if the ProtoBuf definition does not change) and safe for programmatic use.
        pub fn as_str_name(&self) -> &'static str {
            match self {
                Self::PackageLoadingUnknown => "PACKAGE_LOADING_UNKNOWN",
                Self::WorkspaceFileError => "WORKSPACE_FILE_ERROR",
                Self::MaxComputationStepsExceeded => "MAX_COMPUTATION_STEPS_EXCEEDED",
                Self::BuildFileMissing => "BUILD_FILE_MISSING",
                Self::RepositoryMissing => "REPOSITORY_MISSING",
                Self::PersistentInconsistentFilesystemError => {
                    "PERSISTENT_INCONSISTENT_FILESYSTEM_ERROR"
                }
                Self::TransientInconsistentFilesystemError => {
                    "TRANSIENT_INCONSISTENT_FILESYSTEM_ERROR"
                }
                Self::InvalidName => "INVALID_NAME",
                Self::EvalGlobsSymlinkError => "EVAL_GLOBS_SYMLINK_ERROR",
                Self::ImportStarlarkFileError => "IMPORT_STARLARK_FILE_ERROR",
                Self::PackageMissing => "PACKAGE_MISSING",
                Self::TargetMissing => "TARGET_MISSING",
                Self::NoSuchThing => "NO_SUCH_THING",
                Self::GlobIoException => "GLOB_IO_EXCEPTION",
                Self::DuplicateLabel => "DUPLICATE_LABEL",
                Self::InvalidPackageSpecification => "INVALID_PACKAGE_SPECIFICATION",
                Self::SyntaxError => "SYNTAX_ERROR",
                Self::EnvironmentInDifferentPackage => "ENVIRONMENT_IN_DIFFERENT_PACKAGE",
                Self::DefaultEnvironmentUndeclared => "DEFAULT_ENVIRONMENT_UNDECLARED",
                Self::EnvironmentInMultipleGroups => "ENVIRONMENT_IN_MULTIPLE_GROUPS",
                Self::EnvironmentDoesNotExist => "ENVIRONMENT_DOES_NOT_EXIST",
                Self::EnvironmentInvalid => "ENVIRONMENT_INVALID",
                Self::EnvironmentNotInGroup => "ENVIRONMENT_NOT_IN_GROUP",
                Self::PackageNameInvalid => "PACKAGE_NAME_INVALID",
                Self::StarlarkEvalError => "STARLARK_EVAL_ERROR",
                Self::LicenseParseFailure => "LICENSE_PARSE_FAILURE",
                Self::DistributionsParseFailure => "DISTRIBUTIONS_PARSE_FAILURE",
                Self::LabelCrossesPackageBoundary => "LABEL_CROSSES_PACKAGE_BOUNDARY",
                Self::BuiltinsInjectionFailure => "BUILTINS_INJECTION_FAILURE",
                Self::SymlinkCycleOrInfiniteExpansion => {
                    "SYMLINK_CYCLE_OR_INFINITE_EXPANSION"
                }
                Self::OtherIoException => "OTHER_IO_EXCEPTION",
                Self::BadRepoFile => "BAD_REPO_FILE",
            }
        }
        /// Creates an enum from field names used in the ProtoBuf definition.
        pub fn from_str_name(value: &str) -> ::core::option::Option<Self> {
            match value {
                "PACKAGE_LOADING_UNKNOWN" => Some(Self::PackageLoadingUnknown),
                "WORKSPACE_FILE_ERROR" => Some(Self::WorkspaceFileError),
                "MAX_COMPUTATION_STEPS_EXCEEDED" => {
                    Some(Self::MaxComputationStepsExceeded)
                }
                "BUILD_FILE_MISSING" => Some(Self::BuildFileMissing),
                "REPOSITORY_MISSING" => Some(Self::RepositoryMissing),
                "PERSISTENT_INCONSISTENT_FILESYSTEM_ERROR" => {
                    Some(Self::PersistentInconsistentFilesystemError)
                }
                "TRANSIENT_INCONSISTENT_FILESYSTEM_ERROR" => {
                    Some(Self::TransientInconsistentFilesystemError)
                }
                "INVALID_NAME" => Some(Self::InvalidName),
                "EVAL_GLOBS_SYMLINK_ERROR" => Some(Self::EvalGlobsSymlinkError),
                "IMPORT_STARLARK_FILE_ERROR" => Some(Self::ImportStarlarkFileError),
                "PACKAGE_MISSING" => Some(Self::PackageMissing),
                "TARGET_MISSING" => Some(Self::TargetMissing),
                "NO_SUCH_THING" => Some(Self::NoSuchThing),
                "GLOB_IO_EXCEPTION" => Some(Self::GlobIoException),
                "DUPLICATE_LABEL" => Some(Self::DuplicateLabel),
                "INVALID_PACKAGE_SPECIFICATION" => {
                    Some(Self::InvalidPackageSpecification)
                }
                "SYNTAX_ERROR" => Some(Self::SyntaxError),
                "ENVIRONMENT_IN_DIFFERENT_PACKAGE" => {
                    Some(Self::EnvironmentInDifferentPackage)
                }
                "DEFAULT_ENVIRONMENT_UNDECLARED" => {
                    Some(Self::DefaultEnvironmentUndeclared)
                }
                "ENVIRONMENT_IN_MULTIPLE_GROUPS" => {
                    Some(Self::EnvironmentInMultipleGroups)
                }
                "ENVIRONMENT_DOES_NOT_EXIST" => Some(Self::EnvironmentDoesNotExist),
                "ENVIRONMENT_INVALID" => Some(Self::EnvironmentInvalid),
                "ENVIRONMENT_NOT_IN_GROUP" => Some(Self::EnvironmentNotInGroup),
                "PACKAGE_NAME_INVALID" => Some(Self::PackageNameInvalid),
                "STARLARK_EVAL_ERROR" => Some(Self::StarlarkEvalError),
                "LICENSE_PARSE_FAILURE" => Some(Self::LicenseParseFailure),
                "DISTRIBUTIONS_PARSE_FAILURE" => Some(Self::DistributionsParseFailure),
                "LABEL_CROSSES_PACKAGE_BOUNDARY" => {
                    Some(Self::LabelCrossesPackageBoundary)
                }
                "BUILTINS_INJECTION_FAILURE" => Some(Self::BuiltinsInjectionFailure),
                "SYMLINK_CYCLE_OR_INFINITE_EXPANSION" => {
                    Some(Self::SymlinkCycleOrInfiniteExpansion)
                }
                "OTHER_IO_EXCEPTION" => Some(Self::OtherIoException),
                "BAD_REPO_FILE" => Some(Self::BadRepoFile),
                _ => None,
            }
        }
    }
}
#[derive(Clone, Copy, PartialEq, ::prost::Message)]
pub struct Toolchain {
    #[prost(enumeration = "toolchain::Code", tag = "1")]
    pub code: i32,
}
/// Nested message and enum types in `Toolchain`.
pub mod toolchain {
    #[derive(
        Clone,
        Copy,
        Debug,
        PartialEq,
        Eq,
        Hash,
        PartialOrd,
        Ord,
        ::prost::Enumeration
    )]
    #[repr(i32)]
    pub enum Code {
        ToolchainUnknown = 0,
        MissingProvider = 1,
        InvalidConstraintValue = 2,
        InvalidPlatformValue = 3,
        InvalidToolchain = 4,
        NoMatchingExecutionPlatform = 5,
        NoMatchingToolchain = 6,
        InvalidToolchainType = 7,
    }
    impl Code {
        /// String value of the enum field names used in the ProtoBuf definition.
        ///
        /// The values are not transformed in any way and thus are considered stable
        /// (if the ProtoBuf definition does not change) and safe for programmatic use.
        pub fn as_str_name(&self) -> &'static str {
            match self {
                Self::ToolchainUnknown => "TOOLCHAIN_UNKNOWN",
                Self::MissingProvider => "MISSING_PROVIDER",
                Self::InvalidConstraintValue => "INVALID_CONSTRAINT_VALUE",
                Self::InvalidPlatformValue => "INVALID_PLATFORM_VALUE",
                Self::InvalidToolchain => "INVALID_TOOLCHAIN",
                Self::NoMatchingExecutionPlatform => "NO_MATCHING_EXECUTION_PLATFORM",
                Self::NoMatchingToolchain => "NO_MATCHING_TOOLCHAIN",
                Self::InvalidToolchainType => "INVALID_TOOLCHAIN_TYPE",
            }
        }
        /// Creates an enum from field names used in the ProtoBuf definition.
        pub fn from_str_name(value: &str) -> ::core::option::Option<Self> {
            match value {
                "TOOLCHAIN_UNKNOWN" => Some(Self::ToolchainUnknown),
                "MISSING_PROVIDER" => Some(Self::MissingProvider),
                "INVALID_CONSTRAINT_VALUE" => Some(Self::InvalidConstraintValue),
                "INVALID_PLATFORM_VALUE" => Some(Self::InvalidPlatformValue),
                "INVALID_TOOLCHAIN" => Some(Self::InvalidToolchain),
                "NO_MATCHING_EXECUTION_PLATFORM" => {
                    Some(Self::NoMatchingExecutionPlatform)
                }
                "NO_MATCHING_TOOLCHAIN" => Some(Self::NoMatchingToolchain),
                "INVALID_TOOLCHAIN_TYPE" => Some(Self::InvalidToolchainType),
                _ => None,
            }
        }
    }
}
#[derive(Clone, Copy, PartialEq, ::prost::Message)]
pub struct StarlarkLoading {
    #[prost(enumeration = "starlark_loading::Code", tag = "1")]
    pub code: i32,
}
/// Nested message and enum types in `StarlarkLoading`.
pub mod starlark_loading {
    #[derive(
        Clone,
        Copy,
        Debug,
        PartialEq,
        Eq,
        Hash,
        PartialOrd,
        Ord,
        ::prost::Enumeration
    )]
    #[repr(i32)]
    pub enum Code {
        StarlarkLoadingUnknown = 0,
        Cycle = 1,
        CompileError = 2,
        ParseError = 3,
        EvalError = 4,
        ContainingPackageNotFound = 5,
        PackageNotFound = 6,
        IoError = 7,
        LabelCrossesPackageBoundary = 8,
        BuiltinsError = 9,
        VisibilityError = 10,
    }
    impl Code {
        /// String value of the enum field names used in the ProtoBuf definition.
        ///
        /// The values are not transformed in any way and thus are considered stable
        /// (if the ProtoBuf definition does not change) and safe for programmatic use.
        pub fn as_str_name(&self) -> &'static str {
            match self {
                Self::StarlarkLoadingUnknown => "STARLARK_LOADING_UNKNOWN",
                Self::Cycle => "CYCLE",
                Self::CompileError => "COMPILE_ERROR",
                Self::ParseError => "PARSE_ERROR",
                Self::EvalError => "EVAL_ERROR",
                Self::ContainingPackageNotFound => "CONTAINING_PACKAGE_NOT_FOUND",
                Self::PackageNotFound => "PACKAGE_NOT_FOUND",
                Self::IoError => "IO_ERROR",
                Self::LabelCrossesPackageBoundary => "LABEL_CROSSES_PACKAGE_BOUNDARY",
                Self::BuiltinsError => "BUILTINS_ERROR",
                Self::VisibilityError => "VISIBILITY_ERROR",
            }
        }
        /// Creates an enum from field names used in the ProtoBuf definition.
        pub fn from_str_name(value: &str) -> ::core::option::Option<Self> {
            match value {
                "STARLARK_LOADING_UNKNOWN" => Some(Self::StarlarkLoadingUnknown),
                "CYCLE" => Some(Self::Cycle),
                "COMPILE_ERROR" => Some(Self::CompileError),
                "PARSE_ERROR" => Some(Self::ParseError),
                "EVAL_ERROR" => Some(Self::EvalError),
                "CONTAINING_PACKAGE_NOT_FOUND" => Some(Self::ContainingPackageNotFound),
                "PACKAGE_NOT_FOUND" => Some(Self::PackageNotFound),
                "IO_ERROR" => Some(Self::IoError),
                "LABEL_CROSSES_PACKAGE_BOUNDARY" => {
                    Some(Self::LabelCrossesPackageBoundary)
                }
                "BUILTINS_ERROR" => Some(Self::BuiltinsError),
                "VISIBILITY_ERROR" => Some(Self::VisibilityError),
                _ => None,
            }
        }
    }
}
#[derive(Clone, Copy, PartialEq, ::prost::Message)]
pub struct ExternalDeps {
    #[prost(enumeration = "external_deps::Code", tag = "1")]
    pub code: i32,
}
/// Nested message and enum types in `ExternalDeps`.
pub mod external_deps {
    #[derive(
        Clone,
        Copy,
        Debug,
        PartialEq,
        Eq,
        Hash,
        PartialOrd,
        Ord,
        ::prost::Enumeration
    )]
    #[repr(i32)]
    pub enum Code {
        ExternalDepsUnknown = 0,
        ModuleNotFound = 1,
        BadModule = 2,
        VersionResolutionError = 3,
        InvalidRegistryUrl = 4,
        ErrorAccessingRegistry = 5,
        InvalidExtensionImport = 6,
        BadLockfile = 7,
    }
    impl Code {
        /// String value of the enum field names used in the ProtoBuf definition.
        ///
        /// The values are not transformed in any way and thus are considered stable
        /// (if the ProtoBuf definition does not change) and safe for programmatic use.
        pub fn as_str_name(&self) -> &'static str {
            match self {
                Self::ExternalDepsUnknown => "EXTERNAL_DEPS_UNKNOWN",
                Self::ModuleNotFound => "MODULE_NOT_FOUND",
                Self::BadModule => "BAD_MODULE",
                Self::VersionResolutionError => "VERSION_RESOLUTION_ERROR",
                Self::InvalidRegistryUrl => "INVALID_REGISTRY_URL",
                Self::ErrorAccessingRegistry => "ERROR_ACCESSING_REGISTRY",
                Self::InvalidExtensionImport => "INVALID_EXTENSION_IMPORT",
                Self::BadLockfile => "BAD_LOCKFILE",
            }
        }
        /// Creates an enum from field names used in the ProtoBuf definition.
        pub fn from_str_name(value: &str) -> ::core::option::Option<Self> {
            match value {
                "EXTERNAL_DEPS_UNKNOWN" => Some(Self::ExternalDepsUnknown),
                "MODULE_NOT_FOUND" => Some(Self::ModuleNotFound),
                "BAD_MODULE" => Some(Self::BadModule),
                "VERSION_RESOLUTION_ERROR" => Some(Self::VersionResolutionError),
                "INVALID_REGISTRY_URL" => Some(Self::InvalidRegistryUrl),
                "ERROR_ACCESSING_REGISTRY" => Some(Self::ErrorAccessingRegistry),
                "INVALID_EXTENSION_IMPORT" => Some(Self::InvalidExtensionImport),
                "BAD_LOCKFILE" => Some(Self::BadLockfile),
                _ => None,
            }
        }
    }
}
#[derive(Clone, Copy, PartialEq, ::prost::Message)]
pub struct DiffAwareness {
    #[prost(enumeration = "diff_awareness::Code", tag = "1")]
    pub code: i32,
}
/// Nested message and enum types in `DiffAwareness`.
pub mod diff_awareness {
    #[derive(
        Clone,
        Copy,
        Debug,
        PartialEq,
        Eq,
        Hash,
        PartialOrd,
        Ord,
        ::prost::Enumeration
    )]
    #[repr(i32)]
    pub enum Code {
        DiffAwarenessUnknown = 0,
        DiffStatFailed = 1,
    }
    impl Code {
        /// String value of the enum field names used in the ProtoBuf definition.
        ///
        /// The values are not transformed in any way and thus are considered stable
        /// (if the ProtoBuf definition does not change) and safe for programmatic use.
        pub fn as_str_name(&self) -> &'static str {
            match self {
                Self::DiffAwarenessUnknown => "DIFF_AWARENESS_UNKNOWN",
                Self::DiffStatFailed => "DIFF_STAT_FAILED",
            }
        }
        /// Creates an enum from field names used in the ProtoBuf definition.
        pub fn from_str_name(value: &str) -> ::core::option::Option<Self> {
            match value {
                "DIFF_AWARENESS_UNKNOWN" => Some(Self::DiffAwarenessUnknown),
                "DIFF_STAT_FAILED" => Some(Self::DiffStatFailed),
                _ => None,
            }
        }
    }
}
#[derive(Clone, Copy, PartialEq, ::prost::Message)]
pub struct ModCommand {
    #[prost(enumeration = "mod_command::Code", tag = "1")]
    pub code: i32,
}
/// Nested message and enum types in `ModCommand`.
pub mod mod_command {
    #[derive(
        Clone,
        Copy,
        Debug,
        PartialEq,
        Eq,
        Hash,
        PartialOrd,
        Ord,
        ::prost::Enumeration
    )]
    #[repr(i32)]
    pub enum Code {
        ModCommandUnknown = 0,
        MissingArguments = 1,
        TooManyArguments = 2,
        InvalidArguments = 3,
        BuildozerFailed = 4,
    }
    impl Code {
        /// String value of the enum field names used in the ProtoBuf definition.
        ///
        /// The values are not transformed in any way and thus are considered stable
        /// (if the ProtoBuf definition does not change) and safe for programmatic use.
        pub fn as_str_name(&self) -> &'static str {
            match self {
                Self::ModCommandUnknown => "MOD_COMMAND_UNKNOWN",
                Self::MissingArguments => "MISSING_ARGUMENTS",
                Self::TooManyArguments => "TOO_MANY_ARGUMENTS",
                Self::InvalidArguments => "INVALID_ARGUMENTS",
                Self::BuildozerFailed => "BUILDOZER_FAILED",
            }
        }
        /// Creates an enum from field names used in the ProtoBuf definition.
        pub fn from_str_name(value: &str) -> ::core::option::Option<Self> {
            match value {
                "MOD_COMMAND_UNKNOWN" => Some(Self::ModCommandUnknown),
                "MISSING_ARGUMENTS" => Some(Self::MissingArguments),
                "TOO_MANY_ARGUMENTS" => Some(Self::TooManyArguments),
                "INVALID_ARGUMENTS" => Some(Self::InvalidArguments),
                "BUILDOZER_FAILED" => Some(Self::BuildozerFailed),
                _ => None,
            }
        }
    }
}
