// Copyright 2022 The NativeLink Authors. All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//    http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// This file is @generated by prost-build.
/// Status used for both invocation attempt and overall build completion.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct BuildStatus {
    /// The end result.
    #[prost(enumeration = "build_status::Result", tag = "1")]
    pub result: i32,
    /// Final invocation ID of the build, if there was one.
    /// This field is only set on a status in BuildFinished event.
    #[prost(string, tag = "3")]
    pub final_invocation_id: ::prost::alloc::string::String,
    /// Build tool exit code. Integer value returned by the executed build tool.
    /// Might not be available in some cases, e.g., a build timeout.
    #[prost(message, optional, tag = "4")]
    pub build_tool_exit_code: ::core::option::Option<i32>,
    /// Human-readable error message. Do not use for programmatic purposes.
    #[prost(string, tag = "5")]
    pub error_message: ::prost::alloc::string::String,
    /// Fine-grained diagnostic information to complement the status.
    #[prost(message, optional, tag = "2")]
    pub details: ::core::option::Option<::prost_types::Any>,
}
/// Nested message and enum types in `BuildStatus`.
pub mod build_status {
    /// The end result of the Build.
    #[derive(
        Clone,
        Copy,
        Debug,
        PartialEq,
        Eq,
        Hash,
        PartialOrd,
        Ord,
        ::prost::Enumeration
    )]
    #[repr(i32)]
    pub enum Result {
        /// Unspecified or unknown.
        UnknownStatus = 0,
        /// Build was successful and tests (if requested) all pass.
        CommandSucceeded = 1,
        /// Build error and/or test failure.
        CommandFailed = 2,
        /// Unable to obtain a result due to input provided by the user.
        UserError = 3,
        /// Unable to obtain a result due to a failure within the build system.
        SystemError = 4,
        /// Build required too many resources, such as build tool RAM.
        ResourceExhausted = 5,
        /// An invocation attempt time exceeded its deadline.
        InvocationDeadlineExceeded = 6,
        /// Build request time exceeded the request_deadline
        RequestDeadlineExceeded = 8,
        /// The build was cancelled by a call to CancelBuild.
        Cancelled = 7,
    }
    impl Result {
        /// String value of the enum field names used in the ProtoBuf definition.
        ///
        /// The values are not transformed in any way and thus are considered stable
        /// (if the ProtoBuf definition does not change) and safe for programmatic use.
        pub fn as_str_name(&self) -> &'static str {
            match self {
                Self::UnknownStatus => "UNKNOWN_STATUS",
                Self::CommandSucceeded => "COMMAND_SUCCEEDED",
                Self::CommandFailed => "COMMAND_FAILED",
                Self::UserError => "USER_ERROR",
                Self::SystemError => "SYSTEM_ERROR",
                Self::ResourceExhausted => "RESOURCE_EXHAUSTED",
                Self::InvocationDeadlineExceeded => "INVOCATION_DEADLINE_EXCEEDED",
                Self::RequestDeadlineExceeded => "REQUEST_DEADLINE_EXCEEDED",
                Self::Cancelled => "CANCELLED",
            }
        }
        /// Creates an enum from field names used in the ProtoBuf definition.
        pub fn from_str_name(value: &str) -> ::core::option::Option<Self> {
            match value {
                "UNKNOWN_STATUS" => Some(Self::UnknownStatus),
                "COMMAND_SUCCEEDED" => Some(Self::CommandSucceeded),
                "COMMAND_FAILED" => Some(Self::CommandFailed),
                "USER_ERROR" => Some(Self::UserError),
                "SYSTEM_ERROR" => Some(Self::SystemError),
                "RESOURCE_EXHAUSTED" => Some(Self::ResourceExhausted),
                "INVOCATION_DEADLINE_EXCEEDED" => Some(Self::InvocationDeadlineExceeded),
                "REQUEST_DEADLINE_EXCEEDED" => Some(Self::RequestDeadlineExceeded),
                "CANCELLED" => Some(Self::Cancelled),
                _ => None,
            }
        }
    }
}
/// An event representing some state change that occurred in the build. This
/// message does not include field for uniquely identifying an event.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct BuildEvent {
    /// This should be precisely the time when this event happened, and not when
    /// the event proto was created or sent.
    #[prost(message, optional, tag = "1")]
    pub event_time: ::core::option::Option<::prost_types::Timestamp>,
    /// //////////////////////////////////////////////////////////////////////////
    /// Events that indicate a state change of a build request in the build
    /// queue.
    #[prost(oneof = "build_event::Event", tags = "51, 52, 53, 55, 56, 59, 60, 61, 62")]
    pub event: ::core::option::Option<build_event::Event>,
}
/// Nested message and enum types in `BuildEvent`.
pub mod build_event {
    /// Notification that the build system has attempted to run the build tool.
    #[derive(Clone, PartialEq, ::prost::Message)]
    pub struct InvocationAttemptStarted {
        /// The number of the invocation attempt, starting at 1 and increasing by 1
        /// for each new attempt. Can be used to determine if there is a later
        /// invocation attempt replacing the current one a client is processing.
        #[prost(int64, tag = "1")]
        pub attempt_number: i64,
        /// Arbitrary details about the invocation attempt.
        #[prost(message, optional, tag = "2")]
        pub details: ::core::option::Option<::prost_types::Any>,
    }
    /// Notification that an invocation attempt has finished.
    #[derive(Clone, PartialEq, ::prost::Message)]
    pub struct InvocationAttemptFinished {
        /// Final status of the invocation.
        #[prost(message, optional, tag = "3")]
        pub invocation_status: ::core::option::Option<super::BuildStatus>,
        /// Arbitrary details about the invocation attempt.
        #[prost(message, optional, tag = "4")]
        pub details: ::core::option::Option<::prost_types::Any>,
    }
    /// Notification that the build request is enqueued.
    #[derive(Clone, PartialEq, ::prost::Message)]
    pub struct BuildEnqueued {
        /// Additional details about the Build.
        #[prost(message, optional, tag = "1")]
        pub details: ::core::option::Option<::prost_types::Any>,
    }
    /// Notification that the build request has finished, and no further
    /// invocations will occur.  Note that this applies to the entire Build.
    /// Individual invocations trigger InvocationFinished when they finish.
    #[derive(Clone, PartialEq, ::prost::Message)]
    pub struct BuildFinished {
        /// Final status of the build.
        #[prost(message, optional, tag = "1")]
        pub status: ::core::option::Option<super::BuildStatus>,
        /// Additional details about the Build.
        #[prost(message, optional, tag = "2")]
        pub details: ::core::option::Option<::prost_types::Any>,
    }
    /// Textual output written to standard output or standard error.
    #[derive(Clone, PartialEq, ::prost::Message)]
    pub struct ConsoleOutput {
        /// The output stream type.
        #[prost(enumeration = "super::ConsoleOutputStream", tag = "1")]
        pub r#type: i32,
        /// The output stream content.
        #[prost(oneof = "console_output::Output", tags = "2, 3")]
        pub output: ::core::option::Option<console_output::Output>,
    }
    /// Nested message and enum types in `ConsoleOutput`.
    pub mod console_output {
        /// The output stream content.
        #[derive(Clone, PartialEq, ::prost::Oneof)]
        pub enum Output {
            /// Regular UTF-8 output; normal text.
            #[prost(string, tag = "2")]
            TextOutput(::prost::alloc::string::String),
            /// Used if the output is not UTF-8 text (for example, a binary proto).
            #[prost(bytes, tag = "3")]
            BinaryOutput(::prost::bytes::Bytes),
        }
    }
    /// Notification of the end of a build event stream published by a build
    /// component other than CONTROLLER (See StreamId.BuildComponents).
    #[derive(Clone, Copy, PartialEq, ::prost::Message)]
    pub struct BuildComponentStreamFinished {
        /// How the event stream finished.
        #[prost(enumeration = "build_component_stream_finished::FinishType", tag = "1")]
        pub r#type: i32,
    }
    /// Nested message and enum types in `BuildComponentStreamFinished`.
    pub mod build_component_stream_finished {
        /// How did the event stream finish.
        #[derive(
            Clone,
            Copy,
            Debug,
            PartialEq,
            Eq,
            Hash,
            PartialOrd,
            Ord,
            ::prost::Enumeration
        )]
        #[repr(i32)]
        pub enum FinishType {
            /// Unknown or unspecified; callers should never set this value.
            Unspecified = 0,
            /// Set by the event publisher to indicate a build event stream is
            /// finished.
            Finished = 1,
            /// Set by the WatchBuild RPC server when the publisher of a build event
            /// stream stops publishing events without publishing a
            /// BuildComponentStreamFinished event whose type equals FINISHED.
            Expired = 2,
        }
        impl FinishType {
            /// String value of the enum field names used in the ProtoBuf definition.
            ///
            /// The values are not transformed in any way and thus are considered stable
            /// (if the ProtoBuf definition does not change) and safe for programmatic use.
            pub fn as_str_name(&self) -> &'static str {
                match self {
                    Self::Unspecified => "FINISH_TYPE_UNSPECIFIED",
                    Self::Finished => "FINISHED",
                    Self::Expired => "EXPIRED",
                }
            }
            /// Creates an enum from field names used in the ProtoBuf definition.
            pub fn from_str_name(value: &str) -> ::core::option::Option<Self> {
                match value {
                    "FINISH_TYPE_UNSPECIFIED" => Some(Self::Unspecified),
                    "FINISHED" => Some(Self::Finished),
                    "EXPIRED" => Some(Self::Expired),
                    _ => None,
                }
            }
        }
    }
    /// //////////////////////////////////////////////////////////////////////////
    /// Events that indicate a state change of a build request in the build
    /// queue.
    #[derive(Clone, PartialEq, ::prost::Oneof)]
    pub enum Event {
        /// An invocation attempt has started.
        #[prost(message, tag = "51")]
        InvocationAttemptStarted(InvocationAttemptStarted),
        /// An invocation attempt has finished.
        #[prost(message, tag = "52")]
        InvocationAttemptFinished(InvocationAttemptFinished),
        /// The build is enqueued.
        #[prost(message, tag = "53")]
        BuildEnqueued(BuildEnqueued),
        /// The build has finished. Set when the build is terminated.
        #[prost(message, tag = "55")]
        BuildFinished(BuildFinished),
        /// An event containing printed text.
        #[prost(message, tag = "56")]
        ConsoleOutput(ConsoleOutput),
        /// Indicates the end of a build event stream (with the same StreamId) from
        /// a build component executing the requested build task.
        /// *** This field does not indicate the WatchBuild RPC is finished. ***
        #[prost(message, tag = "59")]
        ComponentStreamFinished(BuildComponentStreamFinished),
        /// Structured build event generated by Bazel about its execution progress.
        #[prost(message, tag = "60")]
        BazelEvent(::prost_types::Any),
        /// An event that contains supplemental tool-specific information about
        /// build execution.
        #[prost(message, tag = "61")]
        BuildExecutionEvent(::prost_types::Any),
        /// An event that contains supplemental tool-specific information about
        /// source fetching.
        #[prost(message, tag = "62")]
        SourceFetchEvent(::prost_types::Any),
    }
}
/// Unique identifier for a build event stream.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct StreamId {
    /// The id of a Build message.
    #[prost(string, tag = "1")]
    pub build_id: ::prost::alloc::string::String,
    /// The unique invocation ID within this build.
    /// It should be the same as {invocation} (below) during the migration.
    #[prost(string, tag = "6")]
    pub invocation_id: ::prost::alloc::string::String,
    /// The component that emitted this event.
    #[prost(enumeration = "stream_id::BuildComponent", tag = "3")]
    pub component: i32,
}
/// Nested message and enum types in `StreamId`.
pub mod stream_id {
    /// Which build component generates this event stream. Each build component
    /// may generate one event stream.
    #[derive(
        Clone,
        Copy,
        Debug,
        PartialEq,
        Eq,
        Hash,
        PartialOrd,
        Ord,
        ::prost::Enumeration
    )]
    #[repr(i32)]
    pub enum BuildComponent {
        /// Unknown or unspecified; callers should never set this value.
        UnknownComponent = 0,
        /// A component that coordinates builds.
        Controller = 1,
        /// A component that runs executables needed to complete a build.
        Worker = 2,
        /// A component that builds something.
        Tool = 3,
    }
    impl BuildComponent {
        /// String value of the enum field names used in the ProtoBuf definition.
        ///
        /// The values are not transformed in any way and thus are considered stable
        /// (if the ProtoBuf definition does not change) and safe for programmatic use.
        pub fn as_str_name(&self) -> &'static str {
            match self {
                Self::UnknownComponent => "UNKNOWN_COMPONENT",
                Self::Controller => "CONTROLLER",
                Self::Worker => "WORKER",
                Self::Tool => "TOOL",
            }
        }
        /// Creates an enum from field names used in the ProtoBuf definition.
        pub fn from_str_name(value: &str) -> ::core::option::Option<Self> {
            match value {
                "UNKNOWN_COMPONENT" => Some(Self::UnknownComponent),
                "CONTROLLER" => Some(Self::Controller),
                "WORKER" => Some(Self::Worker),
                "TOOL" => Some(Self::Tool),
                _ => None,
            }
        }
    }
}
/// The type of console output stream.
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord, ::prost::Enumeration)]
#[repr(i32)]
pub enum ConsoleOutputStream {
    /// Unspecified or unknown.
    Unknown = 0,
    /// Normal output stream.
    Stdout = 1,
    /// Error output stream.
    Stderr = 2,
}
impl ConsoleOutputStream {
    /// String value of the enum field names used in the ProtoBuf definition.
    ///
    /// The values are not transformed in any way and thus are considered stable
    /// (if the ProtoBuf definition does not change) and safe for programmatic use.
    pub fn as_str_name(&self) -> &'static str {
        match self {
            Self::Unknown => "UNKNOWN",
            Self::Stdout => "STDOUT",
            Self::Stderr => "STDERR",
        }
    }
    /// Creates an enum from field names used in the ProtoBuf definition.
    pub fn from_str_name(value: &str) -> ::core::option::Option<Self> {
        match value {
            "UNKNOWN" => Some(Self::Unknown),
            "STDOUT" => Some(Self::Stdout),
            "STDERR" => Some(Self::Stderr),
            _ => None,
        }
    }
}
/// Publishes 'lifecycle events' that update the high-level state of a build:
/// - BuildEnqueued: When a build is scheduled.
/// - InvocationAttemptStarted: When work for a build starts; there can be
///      multiple invocations for a build (e.g. retries).
/// - InvocationAttemptCompleted: When work for a build finishes.
/// - BuildFinished: When a build is finished.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct PublishLifecycleEventRequest {
    /// The interactivity of this build.
    #[prost(enumeration = "publish_lifecycle_event_request::ServiceLevel", tag = "1")]
    pub service_level: i32,
    /// Required. The lifecycle build event. If this is a build tool event, the RPC
    /// will fail with INVALID_REQUEST.
    #[prost(message, optional, tag = "2")]
    pub build_event: ::core::option::Option<OrderedBuildEvent>,
    /// If the next event for this build or invocation (depending on the event
    /// type) hasn't been published after this duration from when {build_event}
    /// is written to BES, consider this stream expired. If this field is not set,
    /// BES backend will use its own default value.
    #[prost(message, optional, tag = "3")]
    pub stream_timeout: ::core::option::Option<::prost_types::Duration>,
    /// Additional information about a build request. These are define by the event
    /// publishers, and the Build Event Service does not validate or interpret
    /// them. They are used while notifying internal systems of new builds and
    /// invocations if the OrderedBuildEvent.event type is
    /// BuildEnqueued/InvocationAttemptStarted.
    #[prost(string, repeated, tag = "4")]
    pub notification_keywords: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
    /// Required. The project this build is associated with.
    /// This should match the project used for the initial call to
    /// PublishLifecycleEvent (containing a BuildEnqueued message).
    #[prost(string, tag = "6")]
    pub project_id: ::prost::alloc::string::String,
    /// Whether to require a previously received matching parent lifecycle event
    /// for the current request's event before continuing processing.
    /// - InvocationAttemptStarted and BuildFinished events require a BuildEnqueued
    ///    parent event.
    /// - InvocationAttemptFinished events require an InvocationAttemptStarted
    ///    parent event.
    #[prost(bool, tag = "7")]
    pub check_preceding_lifecycle_events_present: bool,
}
/// Nested message and enum types in `PublishLifecycleEventRequest`.
pub mod publish_lifecycle_event_request {
    /// The service level of the build request. Backends only uses this value when
    /// the BuildEnqueued event is published to determine what level of service
    /// this build should receive.
    #[derive(
        Clone,
        Copy,
        Debug,
        PartialEq,
        Eq,
        Hash,
        PartialOrd,
        Ord,
        ::prost::Enumeration
    )]
    #[repr(i32)]
    pub enum ServiceLevel {
        /// Non-interactive builds can tolerate longer event latencies. This is the
        /// default ServiceLevel if callers do not specify one.
        Noninteractive = 0,
        /// The events of an interactive build should be delivered with low latency.
        Interactive = 1,
    }
    impl ServiceLevel {
        /// String value of the enum field names used in the ProtoBuf definition.
        ///
        /// The values are not transformed in any way and thus are considered stable
        /// (if the ProtoBuf definition does not change) and safe for programmatic use.
        pub fn as_str_name(&self) -> &'static str {
            match self {
                Self::Noninteractive => "NONINTERACTIVE",
                Self::Interactive => "INTERACTIVE",
            }
        }
        /// Creates an enum from field names used in the ProtoBuf definition.
        pub fn from_str_name(value: &str) -> ::core::option::Option<Self> {
            match value {
                "NONINTERACTIVE" => Some(Self::Noninteractive),
                "INTERACTIVE" => Some(Self::Interactive),
                _ => None,
            }
        }
    }
}
/// States which event has been committed. Any failure to commit will cause
/// RPC errors, hence not recorded by this proto.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct PublishBuildToolEventStreamResponse {
    /// The stream that contains this event.
    #[prost(message, optional, tag = "1")]
    pub stream_id: ::core::option::Option<StreamId>,
    /// The sequence number of this event that has been committed.
    #[prost(int64, tag = "2")]
    pub sequence_number: i64,
}
/// Build event with contextual information about the stream it belongs to and
/// its position in that stream.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct OrderedBuildEvent {
    /// Which build event stream this event belongs to.
    #[prost(message, optional, tag = "1")]
    pub stream_id: ::core::option::Option<StreamId>,
    /// The position of this event in the stream. The sequence numbers for a build
    /// event stream should be a sequence of consecutive natural numbers starting
    /// from one. (1, 2, 3, ...)
    #[prost(int64, tag = "2")]
    pub sequence_number: i64,
    /// The actual event.
    #[prost(message, optional, tag = "3")]
    pub event: ::core::option::Option<BuildEvent>,
}
/// Streaming request message for PublishBuildToolEventStream.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct PublishBuildToolEventStreamRequest {
    /// Required. The build event with position info.
    /// New publishing clients should use this field rather than the 3 above.
    #[prost(message, optional, tag = "4")]
    pub ordered_build_event: ::core::option::Option<OrderedBuildEvent>,
    /// The keywords to be attached to the notification which notifies the start
    /// of a new build event stream. BES only reads this field when sequence_number
    /// or ordered_build_event.sequence_number is 1 in this message. If this field
    /// is empty, BES will not publish notification messages for this stream.
    #[prost(string, repeated, tag = "5")]
    pub notification_keywords: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
    /// Required. The project this build is associated with.
    /// This should match the project used for the initial call to
    /// PublishLifecycleEvent (containing a BuildEnqueued message).
    #[prost(string, tag = "6")]
    pub project_id: ::prost::alloc::string::String,
    /// Whether to require a previously received matching InvocationAttemptStarted
    /// event before continuing event processing for the event in the current
    /// request. BES only performs this check for events with sequence_number 1
    /// i.e. the first event in the stream.
    #[prost(bool, tag = "7")]
    pub check_preceding_lifecycle_events_present: bool,
}
/// Generated client implementations.
pub mod publish_build_event_client {
    #![allow(
        unused_variables,
        dead_code,
        missing_docs,
        clippy::wildcard_imports,
        clippy::let_unit_value,
    )]
    use tonic::codegen::*;
    use tonic::codegen::http::Uri;
    /// A service for publishing BuildEvents. BuildEvents are generated by Build
    /// Systems to record actions taken during a Build. Events occur in streams,
    /// are identified by a StreamId, and ordered by sequence number in a stream.
    ///
    /// A Build may contain several streams of BuildEvents, depending on the systems
    /// that are involved in the Build. Some BuildEvents are used to declare the
    /// beginning and end of major portions of a Build; these are called
    /// LifecycleEvents, and are used (for example) to indicate the beginning or end
    /// of a Build, and the beginning or end of an Invocation attempt (there can be
    /// more than 1 Invocation in a Build if, for example, a failure occurs somewhere
    /// and it needs to be retried).
    ///
    /// Other, build-tool events represent actions taken by the Build tool, such as
    /// target objects produced via compilation, tests run, et cetera. There could be
    /// more than one build tool stream for an invocation attempt of a build.
    #[derive(Debug, Clone)]
    pub struct PublishBuildEventClient<T> {
        inner: tonic::client::Grpc<T>,
    }
    impl<T> PublishBuildEventClient<T>
    where
        T: tonic::client::GrpcService<tonic::body::BoxBody>,
        T::Error: Into<StdError>,
        T::ResponseBody: Body<Data = Bytes> + std::marker::Send + 'static,
        <T::ResponseBody as Body>::Error: Into<StdError> + std::marker::Send,
    {
        pub fn new(inner: T) -> Self {
            let inner = tonic::client::Grpc::new(inner);
            Self { inner }
        }
        pub fn with_origin(inner: T, origin: Uri) -> Self {
            let inner = tonic::client::Grpc::with_origin(inner, origin);
            Self { inner }
        }
        pub fn with_interceptor<F>(
            inner: T,
            interceptor: F,
        ) -> PublishBuildEventClient<InterceptedService<T, F>>
        where
            F: tonic::service::Interceptor,
            T::ResponseBody: Default,
            T: tonic::codegen::Service<
                http::Request<tonic::body::BoxBody>,
                Response = http::Response<
                    <T as tonic::client::GrpcService<tonic::body::BoxBody>>::ResponseBody,
                >,
            >,
            <T as tonic::codegen::Service<
                http::Request<tonic::body::BoxBody>,
            >>::Error: Into<StdError> + std::marker::Send + std::marker::Sync,
        {
            PublishBuildEventClient::new(InterceptedService::new(inner, interceptor))
        }
        /// Compress requests with the given encoding.
        ///
        /// This requires the server to support it otherwise it might respond with an
        /// error.
        #[must_use]
        pub fn send_compressed(mut self, encoding: CompressionEncoding) -> Self {
            self.inner = self.inner.send_compressed(encoding);
            self
        }
        /// Enable decompressing responses.
        #[must_use]
        pub fn accept_compressed(mut self, encoding: CompressionEncoding) -> Self {
            self.inner = self.inner.accept_compressed(encoding);
            self
        }
        /// Limits the maximum size of a decoded message.
        ///
        /// Default: `4MB`
        #[must_use]
        pub fn max_decoding_message_size(mut self, limit: usize) -> Self {
            self.inner = self.inner.max_decoding_message_size(limit);
            self
        }
        /// Limits the maximum size of an encoded message.
        ///
        /// Default: `usize::MAX`
        #[must_use]
        pub fn max_encoding_message_size(mut self, limit: usize) -> Self {
            self.inner = self.inner.max_encoding_message_size(limit);
            self
        }
        /// Publish a build event stating the new state of a build (typically from the
        /// build queue). The BuildEnqueued event must be published before all other
        /// events for the same build ID.
        ///
        /// The backend will persist the event and deliver it to registered frontend
        /// jobs immediately without batching.
        ///
        /// The commit status of the request is reported by the RPC's util_status()
        /// function. The error code is the canonical error code defined in
        /// //util/task/codes.proto.
        pub async fn publish_lifecycle_event(
            &mut self,
            request: impl tonic::IntoRequest<super::PublishLifecycleEventRequest>,
        ) -> std::result::Result<tonic::Response<()>, tonic::Status> {
            self.inner
                .ready()
                .await
                .map_err(|e| {
                    tonic::Status::unknown(
                        format!("Service was not ready: {}", e.into()),
                    )
                })?;
            let codec = tonic::codec::ProstCodec::default();
            let path = http::uri::PathAndQuery::from_static(
                "/google.devtools.build.v1.PublishBuildEvent/PublishLifecycleEvent",
            );
            let mut req = request.into_request();
            req.extensions_mut()
                .insert(
                    GrpcMethod::new(
                        "google.devtools.build.v1.PublishBuildEvent",
                        "PublishLifecycleEvent",
                    ),
                );
            self.inner.unary(req, path, codec).await
        }
        /// Publish build tool events belonging to the same stream to a backend job
        /// using bidirectional streaming.
        pub async fn publish_build_tool_event_stream(
            &mut self,
            request: impl tonic::IntoStreamingRequest<
                Message = super::PublishBuildToolEventStreamRequest,
            >,
        ) -> std::result::Result<
            tonic::Response<
                tonic::codec::Streaming<super::PublishBuildToolEventStreamResponse>,
            >,
            tonic::Status,
        > {
            self.inner
                .ready()
                .await
                .map_err(|e| {
                    tonic::Status::unknown(
                        format!("Service was not ready: {}", e.into()),
                    )
                })?;
            let codec = tonic::codec::ProstCodec::default();
            let path = http::uri::PathAndQuery::from_static(
                "/google.devtools.build.v1.PublishBuildEvent/PublishBuildToolEventStream",
            );
            let mut req = request.into_streaming_request();
            req.extensions_mut()
                .insert(
                    GrpcMethod::new(
                        "google.devtools.build.v1.PublishBuildEvent",
                        "PublishBuildToolEventStream",
                    ),
                );
            self.inner.streaming(req, path, codec).await
        }
    }
}
/// Generated server implementations.
pub mod publish_build_event_server {
    #![allow(
        unused_variables,
        dead_code,
        missing_docs,
        clippy::wildcard_imports,
        clippy::let_unit_value,
    )]
    use tonic::codegen::*;
    /// Generated trait containing gRPC methods that should be implemented for use with PublishBuildEventServer.
    #[async_trait]
    pub trait PublishBuildEvent: std::marker::Send + std::marker::Sync + 'static {
        /// Publish a build event stating the new state of a build (typically from the
        /// build queue). The BuildEnqueued event must be published before all other
        /// events for the same build ID.
        ///
        /// The backend will persist the event and deliver it to registered frontend
        /// jobs immediately without batching.
        ///
        /// The commit status of the request is reported by the RPC's util_status()
        /// function. The error code is the canonical error code defined in
        /// //util/task/codes.proto.
        async fn publish_lifecycle_event(
            &self,
            request: tonic::Request<super::PublishLifecycleEventRequest>,
        ) -> std::result::Result<tonic::Response<()>, tonic::Status>;
        /// Server streaming response type for the PublishBuildToolEventStream method.
        type PublishBuildToolEventStreamStream: tonic::codegen::tokio_stream::Stream<
                Item = std::result::Result<
                    super::PublishBuildToolEventStreamResponse,
                    tonic::Status,
                >,
            >
            + std::marker::Send
            + 'static;
        /// Publish build tool events belonging to the same stream to a backend job
        /// using bidirectional streaming.
        async fn publish_build_tool_event_stream(
            &self,
            request: tonic::Request<
                tonic::Streaming<super::PublishBuildToolEventStreamRequest>,
            >,
        ) -> std::result::Result<
            tonic::Response<Self::PublishBuildToolEventStreamStream>,
            tonic::Status,
        >;
    }
    /// A service for publishing BuildEvents. BuildEvents are generated by Build
    /// Systems to record actions taken during a Build. Events occur in streams,
    /// are identified by a StreamId, and ordered by sequence number in a stream.
    ///
    /// A Build may contain several streams of BuildEvents, depending on the systems
    /// that are involved in the Build. Some BuildEvents are used to declare the
    /// beginning and end of major portions of a Build; these are called
    /// LifecycleEvents, and are used (for example) to indicate the beginning or end
    /// of a Build, and the beginning or end of an Invocation attempt (there can be
    /// more than 1 Invocation in a Build if, for example, a failure occurs somewhere
    /// and it needs to be retried).
    ///
    /// Other, build-tool events represent actions taken by the Build tool, such as
    /// target objects produced via compilation, tests run, et cetera. There could be
    /// more than one build tool stream for an invocation attempt of a build.
    #[derive(Debug)]
    pub struct PublishBuildEventServer<T> {
        inner: Arc<T>,
        accept_compression_encodings: EnabledCompressionEncodings,
        send_compression_encodings: EnabledCompressionEncodings,
        max_decoding_message_size: Option<usize>,
        max_encoding_message_size: Option<usize>,
    }
    impl<T> PublishBuildEventServer<T> {
        pub fn new(inner: T) -> Self {
            Self::from_arc(Arc::new(inner))
        }
        pub fn from_arc(inner: Arc<T>) -> Self {
            Self {
                inner,
                accept_compression_encodings: Default::default(),
                send_compression_encodings: Default::default(),
                max_decoding_message_size: None,
                max_encoding_message_size: None,
            }
        }
        pub fn with_interceptor<F>(
            inner: T,
            interceptor: F,
        ) -> InterceptedService<Self, F>
        where
            F: tonic::service::Interceptor,
        {
            InterceptedService::new(Self::new(inner), interceptor)
        }
        /// Enable decompressing requests with the given encoding.
        #[must_use]
        pub fn accept_compressed(mut self, encoding: CompressionEncoding) -> Self {
            self.accept_compression_encodings.enable(encoding);
            self
        }
        /// Compress responses with the given encoding, if the client supports it.
        #[must_use]
        pub fn send_compressed(mut self, encoding: CompressionEncoding) -> Self {
            self.send_compression_encodings.enable(encoding);
            self
        }
        /// Limits the maximum size of a decoded message.
        ///
        /// Default: `4MB`
        #[must_use]
        pub fn max_decoding_message_size(mut self, limit: usize) -> Self {
            self.max_decoding_message_size = Some(limit);
            self
        }
        /// Limits the maximum size of an encoded message.
        ///
        /// Default: `usize::MAX`
        #[must_use]
        pub fn max_encoding_message_size(mut self, limit: usize) -> Self {
            self.max_encoding_message_size = Some(limit);
            self
        }
    }
    impl<T, B> tonic::codegen::Service<http::Request<B>> for PublishBuildEventServer<T>
    where
        T: PublishBuildEvent,
        B: Body + std::marker::Send + 'static,
        B::Error: Into<StdError> + std::marker::Send + 'static,
    {
        type Response = http::Response<tonic::body::BoxBody>;
        type Error = std::convert::Infallible;
        type Future = BoxFuture<Self::Response, Self::Error>;
        fn poll_ready(
            &mut self,
            _cx: &mut Context<'_>,
        ) -> Poll<std::result::Result<(), Self::Error>> {
            Poll::Ready(Ok(()))
        }
        fn call(&mut self, req: http::Request<B>) -> Self::Future {
            match req.uri().path() {
                "/google.devtools.build.v1.PublishBuildEvent/PublishLifecycleEvent" => {
                    #[allow(non_camel_case_types)]
                    struct PublishLifecycleEventSvc<T: PublishBuildEvent>(pub Arc<T>);
                    impl<
                        T: PublishBuildEvent,
                    > tonic::server::UnaryService<super::PublishLifecycleEventRequest>
                    for PublishLifecycleEventSvc<T> {
                        type Response = ();
                        type Future = BoxFuture<
                            tonic::Response<Self::Response>,
                            tonic::Status,
                        >;
                        fn call(
                            &mut self,
                            request: tonic::Request<super::PublishLifecycleEventRequest>,
                        ) -> Self::Future {
                            let inner = Arc::clone(&self.0);
                            let fut = async move {
                                <T as PublishBuildEvent>::publish_lifecycle_event(
                                        &inner,
                                        request,
                                    )
                                    .await
                            };
                            Box::pin(fut)
                        }
                    }
                    let accept_compression_encodings = self.accept_compression_encodings;
                    let send_compression_encodings = self.send_compression_encodings;
                    let max_decoding_message_size = self.max_decoding_message_size;
                    let max_encoding_message_size = self.max_encoding_message_size;
                    let inner = self.inner.clone();
                    let fut = async move {
                        let method = PublishLifecycleEventSvc(inner);
                        let codec = tonic::codec::ProstCodec::default();
                        let mut grpc = tonic::server::Grpc::new(codec)
                            .apply_compression_config(
                                accept_compression_encodings,
                                send_compression_encodings,
                            )
                            .apply_max_message_size_config(
                                max_decoding_message_size,
                                max_encoding_message_size,
                            );
                        let res = grpc.unary(method, req).await;
                        Ok(res)
                    };
                    Box::pin(fut)
                }
                "/google.devtools.build.v1.PublishBuildEvent/PublishBuildToolEventStream" => {
                    #[allow(non_camel_case_types)]
                    struct PublishBuildToolEventStreamSvc<T: PublishBuildEvent>(
                        pub Arc<T>,
                    );
                    impl<
                        T: PublishBuildEvent,
                    > tonic::server::StreamingService<
                        super::PublishBuildToolEventStreamRequest,
                    > for PublishBuildToolEventStreamSvc<T> {
                        type Response = super::PublishBuildToolEventStreamResponse;
                        type ResponseStream = T::PublishBuildToolEventStreamStream;
                        type Future = BoxFuture<
                            tonic::Response<Self::ResponseStream>,
                            tonic::Status,
                        >;
                        fn call(
                            &mut self,
                            request: tonic::Request<
                                tonic::Streaming<super::PublishBuildToolEventStreamRequest>,
                            >,
                        ) -> Self::Future {
                            let inner = Arc::clone(&self.0);
                            let fut = async move {
                                <T as PublishBuildEvent>::publish_build_tool_event_stream(
                                        &inner,
                                        request,
                                    )
                                    .await
                            };
                            Box::pin(fut)
                        }
                    }
                    let accept_compression_encodings = self.accept_compression_encodings;
                    let send_compression_encodings = self.send_compression_encodings;
                    let max_decoding_message_size = self.max_decoding_message_size;
                    let max_encoding_message_size = self.max_encoding_message_size;
                    let inner = self.inner.clone();
                    let fut = async move {
                        let method = PublishBuildToolEventStreamSvc(inner);
                        let codec = tonic::codec::ProstCodec::default();
                        let mut grpc = tonic::server::Grpc::new(codec)
                            .apply_compression_config(
                                accept_compression_encodings,
                                send_compression_encodings,
                            )
                            .apply_max_message_size_config(
                                max_decoding_message_size,
                                max_encoding_message_size,
                            );
                        let res = grpc.streaming(method, req).await;
                        Ok(res)
                    };
                    Box::pin(fut)
                }
                _ => {
                    Box::pin(async move {
                        let mut response = http::Response::new(empty_body());
                        let headers = response.headers_mut();
                        headers
                            .insert(
                                tonic::Status::GRPC_STATUS,
                                (tonic::Code::Unimplemented as i32).into(),
                            );
                        headers
                            .insert(
                                http::header::CONTENT_TYPE,
                                tonic::metadata::GRPC_CONTENT_TYPE,
                            );
                        Ok(response)
                    })
                }
            }
        }
    }
    impl<T> Clone for PublishBuildEventServer<T> {
        fn clone(&self) -> Self {
            let inner = self.inner.clone();
            Self {
                inner,
                accept_compression_encodings: self.accept_compression_encodings,
                send_compression_encodings: self.send_compression_encodings,
                max_decoding_message_size: self.max_decoding_message_size,
                max_encoding_message_size: self.max_encoding_message_size,
            }
        }
    }
    /// Generated gRPC service name
    pub const SERVICE_NAME: &str = "google.devtools.build.v1.PublishBuildEvent";
    impl<T> tonic::server::NamedService for PublishBuildEventServer<T> {
        const NAME: &'static str = SERVICE_NAME;
    }
}
