import type { PropsOf } from "@builder.io/qwik";

export const Toyota = (props: PropsOf<"svg">, key: string) => {
  return (
    <svg
      {...props}
      key={key}
      preserveAspectRatio="xMidYMid meet"
      data-bbox="0.231 0.137 168.537 27.726"
      xmlns="http://www.w3.org/2000/svg"
      viewBox="0.231 0.137 168.537 27.726"
      height="28"
      width="169"
      data-type="color"
      role="presentation"
      aria-hidden="true"
      aria-label="Toyota"
    >
      <g>
        <path
          fill="#8280A6"
          d="M20.178 26.452c-2.23-1.398-3.875-6.221-3.875-11.953 0-.21.001-.418.006-.625l.002.003c-6.206-.975-10.69-3.647-10.806-6.808l-.018.037c-1.518 1.888-2.385 4.07-2.385 6.395 0 6.842 7.51 12.447 17.037 12.944l.04.007ZM.232 14C.232 6.345 9.76.137 21.512.137S42.792 6.345 42.792 14c0 7.655-9.528 13.863-21.28 13.863C9.758 27.863.231 21.654.231 14Zm21.28-11.862c2.27 0 4.2 3.442 4.915 8.245l.001-.008c4.415-.687 7.505-2.272 7.505-4.117 0-2.475-5.561-4.48-12.42-4.48-6.86 0-12.42 2.005-12.42 4.48 0 1.845 3.09 3.429 7.503 4.116l.003.008c.715-4.802 2.645-8.244 4.913-8.244Zm1.374 24.306c9.526-.496 17.037-6.102 17.037-12.944 0-2.325-.868-4.507-2.385-6.395l-.019-.037c-.114 3.161-4.598 5.833-10.806 6.808l.003-.002c.004.206.006.414.006.624 0 5.732-1.645 10.555-3.875 11.953l.039-.007Zm-1.374-15.706c.985.002 1.97-.04 2.95-.126v.001c-.47-3.077-1.613-5.25-2.949-5.25-1.336 0-2.478 2.173-2.949 5.25.98.084 1.964.126 2.948.125Zm0 11.4c1.708 0 3.103-3.555 3.176-8.012l.01.002c-2.12.195-4.251.195-6.37 0l.01-.002c.073 4.457 1.466 8.012 3.174 8.012ZM108.817 14c0-5.851 4.744-10.595 10.594-10.595 5.854 0 10.597 4.744 10.597 10.595 0 5.852-4.744 10.594-10.597 10.594-5.85 0-10.594-4.742-10.594-10.594Zm10.594 6.71c3.268 0 5.917-3.006 5.917-6.711 0-3.705-2.649-6.71-5.917-6.71-3.267 0-5.915 3.005-5.915 6.71 0 3.706 2.649 6.71 5.915 6.71ZM142.03 7.818v16.294h-4.465V7.82h.016-6.243V4.135h16.919V7.82h-6.227Zm11.628 11.8-.004.004-1.712 4.491h-5.216l8.243-19.979h5.557l8.242 19.98h-5.214l-1.712-4.492-.006-.004h-8.178Zm4.09-3.372h2.809-.001l-2.789-7.312h-.039l-2.789 7.312h-.001 2.81Zm-98.01-8.428v16.294h-4.464V7.82h.016-6.243V4.135h16.92V7.82h-6.228Zm7.37 6.18c0-5.85 4.745-10.594 10.597-10.594 5.852 0 10.596 4.744 10.596 10.595 0 5.852-4.744 10.594-10.596 10.594S67.11 19.852 67.11 14Zm10.597 6.71c3.267 0 5.916-3.005 5.916-6.71s-2.65-6.71-5.916-6.71c-3.267 0-5.916 3.005-5.916 6.71 0 3.706 2.649 6.71 5.916 6.71Zm20.852 3.404h2.264v-7.585l7.789-12.393h-5.214l-4.839 8.398-4.837-8.398h-5.213l7.787 12.393v7.585h2.263Z"
          clip-rule="evenodd"
          fill-rule="evenodd"
          data-color="1"
        />
      </g>
    </svg>
  );
};

export const Cruise = (props: PropsOf<"svg">, key: string) => {
  return (
    <svg
      {...props}
      key={key}
      preserveAspectRatio="xMidYMid meet"
      data-bbox="0.203 0.325 129.594 37.35"
      xmlns="http://www.w3.org/2000/svg"
      viewBox="0.203 0.325 129.594 37.35"
      height="38"
      width="130"
      data-type="color"
      role="presentation"
      aria-hidden="true"
      aria-label="Cruise"
    >
      <g>
        <path
          fill="#8280A6"
          d="M33.353 14.545s3.51-2.97 7.77-2.97v5.67c-8.31-.12-7.77 6.57-7.77 6.57v13.14h-5.13v-24.96h5.13v2.55Zm30.21-2.49h5.07v13.89c0 6.36-5.04 11.73-11.4 11.73s-11.4-5.34-11.4-11.73v-13.89h5.04v13.89c0 3.51 2.85 6.48 6.36 6.48 3.51 0 6.36-2.97 6.36-6.48l-.03-13.89Zm10.08 24.93v-24.96h5.13v25.05h-5.13v-.09Zm-60.63-20.34c-4.26 0-7.77 3.51-7.77 7.77s3.48 7.77 7.77 7.77c2.64 0 4.92-1.29 6.48-3.39l4.05 3.06c-2.52 3.39-6.36 5.46-10.53 5.46-7.11.12-12.81-5.67-12.81-12.9s5.79-12.9 12.81-12.9c4.17 0 8.22 2.07 10.53 5.46l-4.05 3.06c-1.47-2.1-3.84-3.39-6.48-3.39Zm96.96 5.46h14.91c-1.41-6.12-7.44-5.88-7.44-5.88s-5.49-.45-7.47 5.88Zm7.32-10.5s13.14-.42 12.48 14.79h-19.92c.42 1.83 1.29 3.39 2.76 4.71 1.41 1.29 3.3 1.95 5.34 1.95 0 0 4.26.21 6.81-3.39l3.72 2.76c-.99 1.41-2.64 2.64-4.8 3.72-1.83.87-4.05 1.41-6.12 1.41-7.11 0-12.48-5.79-12.48-12.9-.15-7.26 5.34-13.05 12.21-13.05Zm-18.03 12.81s2.76 1.62 2.64 5.46c0 0 .21 5.34-5.67 7.11 0 0-7.02 2.31-12.69-3.39l2.64-3.63c5.79 4.8 9.63 2.07 9.63 2.07.66-.54.99-1.2.99-1.95 0-1.95-2.52-2.64-2.52-2.64-.75-.21-1.53-.54-2.52-.75 0 0-3.06-.75-5.34-2.22-.75-.54-1.41-1.2-1.95-2.07-.54-.87-.75-1.95-.75-3.3 0 0-.21-4.92 4.38-7.02 0 0 6.48-2.76 12.48 2.07l-2.64 3.84c-2.76-2.07-5.46-1.95-5.46-1.95-1.2 0-1.95.21-2.64.75-.54.54-.87.99-.87 1.62 0 0-.21 1.53 2.52 2.64.75.21 1.53.54 2.52.75.87.21 1.83.66 2.76.87.81.75 1.71 1.29 2.49 1.74ZM76.133.325c1.95 0 3.51 1.53 3.51 3.63 0 2.07-1.53 3.63-3.51 3.63-1.98 0-3.51-1.53-3.51-3.63.06-2.1 1.56-3.63 3.51-3.63Z"
          data-color="1"
        />
      </g>
    </svg>
  );
};
export const MongoDB = (props: PropsOf<"svg">, key: string) => {
  return (
    <svg
      {...props}
      key={key}
      preserveAspectRatio="xMidYMid meet"
      data-bbox="0.75 0.125 165.5 41.75"
      xmlns="http://www.w3.org/2000/svg"
      viewBox="0.75 0.125 165.5 41.75"
      height="42"
      width="167"
      data-type="color"
      role="presentation"
      aria-hidden="true"
      aria-label="MongoDB"
    >
      <g>
        <path
          fill="#8280A6"
          d="M13.113 4.427a68.486 68.486 0 0 1-3.3-4.28.072.072 0 0 0-.104 0 68.471 68.471 0 0 1-3.3 4.28c-13.904 17.733 2.19 29.7 2.19 29.7l.135.09c.12 1.846.42 4.504.42 4.504h1.2s.3-2.642.42-4.504l.135-.105c.014.015 16.108-11.953 2.204-29.685Zm-3.36 29.43s-.72-.616-.914-.931v-.03l.87-19.31c0-.06.09-.06.09 0l.87 19.31v.03c-.196.315-.915.93-.915.93Z"
          data-color="1"
        />
        <path
          fill="#8280A6"
          d="m39.873 29.916-6.707-16.38-.015-.045h-5.218v1.1h.842a.955.955 0 0 1 .948.966l-.15 16.486a.962.962 0 0 1-.933.95l-.857.015v1.086h5.082v-1.086l-.526-.015a.962.962 0 0 1-.932-.95V16.507l7.308 17.587a.667.667 0 0 0 .616.422.668.668 0 0 0 .617-.422l7.142-17.195.106 15.144c0 .528-.421.95-.948.965h-.541v1.086h5.955v-1.086h-.812c-.511 0-.933-.437-.948-.95l-.045-16.486c0-.528.421-.95.933-.965l.872-.015V13.49h-5.083l-6.706 16.425Z"
          data-color="1"
        />
        <path
          fill="#8280A6"
          d="M86.634 32.721a.911.911 0 0 1-.257-.665v-8.098c0-1.541-.452-2.75-1.357-3.61-.889-.862-2.125-1.3-3.663-1.3-2.156 0-3.86.876-5.05 2.599-.016.03-.06.045-.106.045-.045 0-.075-.03-.075-.076l-.558-2.16h-.935l-2.397 1.375v.755h.618c.287 0 .528.076.694.227.165.15.256.377.256.695v9.533c0 .272-.09.499-.256.665a.909.909 0 0 1-.664.257h-.603v1.103H77.8v-1.103h-.603a.909.909 0 0 1-.663-.257.913.913 0 0 1-.257-.665v-6.315c0-.8.181-1.602.513-2.387.347-.77.86-1.42 1.538-1.92.678-.498 1.492-.74 2.427-.74 1.055 0 1.854.333 2.352.998.497.665.754 1.526.754 2.553v7.796c0 .272-.09.499-.257.665a.908.908 0 0 1-.663.257h-.603v1.103h5.518v-1.103h-.603c-.226.03-.438-.06-.618-.227Z"
          data-color="1"
        />
        <path
          fill="#8280A6"
          d="M137.047 14.724c-1.526-.812-3.23-1.233-5.07-1.233H124.8v1.098h.703c.269 0 .508.105.747.346.225.225.344.481.344.752V31.87c0 .27-.119.526-.344.752-.224.225-.478.346-.747.346h-.703v1.098h7.177c1.84 0 3.544-.421 5.07-1.234 1.525-.812 2.766-2.015 3.663-3.549.897-1.534 1.361-3.384 1.361-5.49 0-2.105-.464-3.94-1.361-5.49-.912-1.563-2.138-2.752-3.663-3.579Zm2.138 9.04c0 1.924-.344 3.549-1.017 4.857-.673 1.309-1.57 2.286-2.677 2.918-1.106.632-2.332.947-3.648.947h-1.451c-.269 0-.508-.105-.747-.345-.225-.226-.344-.482-.344-.752V16.123c0-.27.104-.511.344-.752.224-.226.478-.346.747-.346h1.451c1.316 0 2.542.316 3.648.947 1.107.632 2.004 1.61 2.677 2.918.673 1.324 1.017 2.963 1.017 4.873Z"
          data-color="1"
        />
        <path
          fill="#8280A6"
          d="M159.037 24.861c-.664-.767-1.945-1.414-3.451-1.76 2.08-1.037 3.149-2.496 3.149-4.376 0-1.023-.27-1.94-.814-2.723-.542-.781-1.311-1.413-2.29-1.85-.981-.436-2.127-.661-3.423-.661h-8.124v1.098h.648c.271 0 .512.105.754.346.226.225.346.481.346.752V31.87c0 .27-.12.526-.346.752-.226.225-.483.346-.754.346h-.709v1.098h8.819c1.341 0 2.592-.226 3.723-.677 1.131-.451 2.035-1.113 2.684-1.985.662-.873.994-1.94.994-3.174-.015-1.323-.407-2.451-1.206-3.369Zm-10.114 7.295c-.227-.226-.347-.482-.347-.752v-7.265h4.191c1.476 0 2.607.376 3.391 1.128.784.752 1.176 1.73 1.176 2.933 0 .722-.182 1.429-.512 2.076-.347.661-.861 1.188-1.553 1.594-.679.406-1.523.616-2.502.616h-3.091c-.271 0-.512-.105-.753-.33Zm-.332-9.566v-6.452c0-.27.105-.511.347-.752.226-.226.482-.346.753-.346h1.99c1.431 0 2.487.361 3.151 1.053.662.707.994 1.61.994 2.722 0 1.143-.317 2.06-.934 2.752-.619.677-1.553 1.023-2.789 1.023h-3.512Z"
          data-color="1"
        />
        <path
          fill="#8280A6"
          d="M65.628 20.007a7.891 7.891 0 0 0-3.83-.96c-1.39 0-2.692.316-3.829.96-1.152.63-2.064 1.544-2.737 2.698s-1.017 2.503-1.017 4.002c0 1.499.344 2.848 1.017 4.002.673 1.154 1.585 2.069 2.737 2.698a7.89 7.89 0 0 0 3.83.96c1.39 0 2.692-.316 3.83-.96 1.151-.63 2.064-1.544 2.737-2.698s1.017-2.503 1.017-4.002c0-1.499-.344-2.848-1.017-4.002-.673-1.154-1.586-2.068-2.738-2.698Zm1.107 6.7c0 1.844-.448 3.342-1.346 4.422-.883 1.079-2.094 1.633-3.59 1.633s-2.708-.554-3.59-1.633c-.898-1.08-1.347-2.578-1.347-4.422 0-1.844.45-3.343 1.347-4.422.882-1.079 2.094-1.634 3.59-1.634s2.707.555 3.59 1.634c.898 1.08 1.346 2.578 1.346 4.422Z"
          data-color="1"
        />
        <path
          fill="#8280A6"
          d="M118.642 20.007a7.89 7.89 0 0 0-3.829-.96c-1.392 0-2.693.316-3.83.96-1.152.63-2.064 1.544-2.737 2.698-.674 1.154-1.018 2.503-1.018 4.002 0 1.499.344 2.848 1.018 4.002.673 1.154 1.585 2.069 2.737 2.698 1.152.63 2.438.96 3.83.96 1.391 0 2.692-.316 3.829-.96 1.152-.63 2.064-1.544 2.738-2.698.673-1.154 1.017-2.503 1.017-4.002 0-1.499-.344-2.848-1.017-4.002a7.18 7.18 0 0 0-2.738-2.698Zm1.107 6.7c0 1.844-.449 3.342-1.346 4.422-.883 1.079-2.095 1.633-3.59 1.633-1.496 0-2.708-.554-3.591-1.633-.897-1.08-1.346-2.578-1.346-4.422 0-1.859.449-3.343 1.346-4.422.883-1.079 2.095-1.634 3.591-1.634 1.495 0 2.707.555 3.59 1.634.882 1.08 1.346 2.578 1.346 4.422Z"
          data-color="1"
        />
        <path
          fill="#8280A6"
          d="M97.263 19.048c-1.206 0-2.305.256-3.3.768-.994.512-1.777 1.204-2.335 2.093a5.31 5.31 0 0 0-.843 2.89c0 .934.21 1.793.648 2.56a5.794 5.794 0 0 0 1.717 1.868l-2.154 2.921a1.182 1.182 0 0 0 .949 1.882h.618c-.603.407-1.085.889-1.417 1.46-.391.648-.587 1.326-.587 2.018 0 1.295.572 2.365 1.702 3.163 1.115.798 2.682 1.204 4.655 1.204a11.24 11.24 0 0 0 3.872-.662c1.205-.437 2.185-1.084 2.908-1.928.738-.843 1.115-1.867 1.115-3.041 0-1.235-.452-2.108-1.507-2.952-.904-.707-2.32-1.084-4.083-1.084h-6.026c-.015 0-.03-.015-.03-.015s-.015-.03 0-.045l1.567-2.108c.422.196.813.316 1.16.391a6.03 6.03 0 0 0 1.22.106c1.266 0 2.41-.256 3.405-.768.994-.512 1.793-1.205 2.365-2.093a5.195 5.195 0 0 0 .859-2.891c0-1.114-.542-3.147-2.019-4.186 0-.015.015-.015.015-.015l3.239.361v-1.49h-5.182a8.402 8.402 0 0 0-2.531-.407Zm1.808 9.426a3.893 3.893 0 0 1-1.808.467c-1.01 0-1.898-.362-2.652-1.07-.753-.707-1.13-1.746-1.13-3.071 0-1.325.377-2.364 1.13-3.072.754-.708 1.642-1.07 2.652-1.07.633 0 1.235.151 1.808.468.572.3 1.039.768 1.416 1.385.361.617.557 1.385.557 2.289 0 .918-.181 1.686-.557 2.289-.362.617-.844 1.084-1.416 1.385Zm-4.083 5.541h4.083c1.13 0 1.853.226 2.335.708s.723 1.13.723 1.882c0 1.1-.437 2.003-1.311 2.68-.874.678-2.049 1.024-3.495 1.024-1.265 0-2.32-.286-3.088-.828-.769-.542-1.16-1.37-1.16-2.424 0-.663.18-1.28.542-1.822a3.447 3.447 0 0 1 1.371-1.22Z"
          data-color="1"
        />
        <path
          fill="#8280A6"
          d="M163.299 33.815a1.933 1.933 0 0 1-.7-.68 1.914 1.914 0 0 1-.254-.947c0-.34.09-.665.254-.945.164-.296.403-.518.7-.68a2.04 2.04 0 0 1 .999-.252c.372 0 .7.089.998.252.298.162.522.399.7.68.164.295.254.606.254.945 0 .34-.09.666-.254.947a1.711 1.711 0 0 1-.7.68 2.042 2.042 0 0 1-.998.25c-.358 0-.7-.073-.999-.25Zm1.834-.207c.252-.133.432-.34.581-.577.134-.251.209-.532.209-.843 0-.31-.075-.59-.209-.842a1.374 1.374 0 0 0-.581-.576 1.75 1.75 0 0 0-.835-.207c-.313 0-.582.073-.835.207-.253.133-.433.34-.582.576a1.778 1.778 0 0 0-.208.842c0 .311.075.592.208.843.136.251.329.444.582.577.253.133.522.207.835.207.312 0 .596-.074.835-.207Zm-1.64-.518v-.133l.03-.014h.09a.115.115 0 0 0 .073-.03c.031-.03.03-.044.03-.074v-1.375a.112.112 0 0 0-.03-.074c-.03-.03-.045-.03-.073-.03h-.09l-.03-.014v-.133l.03-.015h.775c.223 0 .387.045.521.148a.482.482 0 0 1 .194.414.455.455 0 0 1-.149.355.59.59 0 0 1-.373.177l.179.06.343.546c.03.044.06.06.105.06h.088l.015.014v.133l-.015.015h-.461l-.03-.015-.477-.798h-.119v.532c0 .03.015.059.03.074.03.03.045.03.074.03h.09l.03.014v.133l-.03.015h-.79l-.03-.015Zm.76-.975c.12 0 .223-.03.283-.104a.406.406 0 0 0 .104-.28.427.427 0 0 0-.089-.282c-.06-.073-.15-.103-.253-.103h-.06a.112.112 0 0 0-.074.03c-.03.03-.03.044-.03.073v.666h.119Z"
          data-color="1"
        />
      </g>
    </svg>
  );
};
export const Apple = (props: PropsOf<"svg">, key: string) => {
  return (
    <svg
      {...props}
      key={key}
      preserveAspectRatio="xMidYMid meet"
      data-bbox="0.502 0.477 119.996 41.046"
      xmlns="http://www.w3.org/2000/svg"
      viewBox="0.502 0.477 119.996 41.046"
      height="42"
      width="121"
      data-type="color"
      role="presentation"
      aria-hidden="true"
      aria-label="Apple"
    >
      <g>
        <path
          fill="#8280A6"
          d="M28.415 22.288c-.05-5.194 4.243-7.69 4.437-7.808-2.417-3.53-6.17-4.016-7.507-4.07-3.194-.327-6.234 1.881-7.858 1.881-1.624 0-4.125-1.837-6.774-1.782-3.486.05-6.7 2.025-8.496 5.144-3.615 6.269-.921 15.578 2.609 20.673 1.728 2.49 3.778 5.298 6.481 5.194 2.605-.104 3.585-1.684 6.725-1.684 3.139 0 4.025 1.684 6.773 1.634 2.798-.054 4.57-2.545 6.284-5.045 1.97-2.897 2.788-5.694 2.837-5.843-.064-.025-5.452-2.09-5.511-8.294Z"
          data-color="1"
        />
        <path
          fill="#8280A6"
          d="M23.25 7.033c1.436-1.738 2.402-4.15 2.14-6.556-2.066.084-4.566 1.377-6.047 3.115-1.326 1.535-2.49 3.99-2.173 6.348 2.292.178 4.65-1.174 6.08-2.907Zm23.272 20.36-2.376 7.205H41.09l7.778-22.896h3.566l7.808 22.896h-3.159l-2.446-7.204h-8.116Zm7.507-2.312-2.238-6.59c-.51-1.496-.847-2.852-1.189-4.18h-.064a72.794 72.794 0 0 1-1.154 4.145l-2.238 6.62 6.883.005Zm8.531-1.56c0-2.104-.064-3.807-.138-5.367h2.683l.14 2.823h.063c1.223-2.006 3.16-3.194 5.843-3.194 3.976 0 6.962 3.362 6.962 8.358 0 5.912-3.6 8.828-7.472 8.828-2.174 0-4.075-.95-5.06-2.58h-.065v8.933H62.56v-17.8Zm2.951 4.383c0 .445.065.846.14 1.223.544 2.07 2.341 3.5 4.485 3.5 3.16 0 4.996-2.58 4.996-6.352 0-3.298-1.733-6.11-4.892-6.11-2.035 0-3.936 1.46-4.52 3.703-.105.372-.204.817-.204 1.223l-.005 2.813Zm15.692-4.383a108.5 108.5 0 0 0-.139-5.367h2.684l.138 2.823h.065c1.223-2.006 3.159-3.194 5.843-3.194 3.976 0 6.962 3.362 6.962 8.358 0 5.912-3.6 8.828-7.472 8.828-2.174 0-4.075-.95-5.06-2.58h-.065v8.933h-2.956v-17.8Zm2.956 4.383c0 .445.064.846.138 1.223.545 2.07 2.343 3.5 4.487 3.5 3.159 0 4.996-2.58 4.996-6.352 0-3.298-1.733-6.11-4.892-6.11-2.035 0-3.937 1.46-4.521 3.703-.104.372-.203.817-.203 1.223l-.005 2.813ZM99.85 10.479h2.991v24.114h-2.99V10.48Zm9.002 16.44c.064 4.04 2.649 5.708 5.635 5.708 2.139 0 3.431-.371 4.55-.846l.51 2.139c-1.049.475-2.852 1.02-5.466 1.02-5.061 0-8.086-3.328-8.086-8.29 0-4.96 2.921-8.867 7.71-8.867 5.367 0 6.793 4.718 6.793 7.744 0 .614-.064 1.084-.104 1.391h-11.542Zm8.764-2.14c.035-1.901-.782-4.857-4.144-4.857-3.026 0-4.348 2.787-4.585 4.857h8.729Z"
          data-color="1"
        />
      </g>
    </svg>
  );
};
export const Roblox = (props: PropsOf<"svg">, key: string) => {
  return (
    <svg
      {...props}
      key={key}
      preserveAspectRatio="xMidYMid meet"
      data-bbox="0.5 0 159.94 27.97"
      xmlns="http://www.w3.org/2000/svg"
      viewBox="0.5 0 159.94 27.97"
      height="28"
      width="161"
      data-type="color"
      role="presentation"
      aria-hidden="true"
      aria-label="Roblox"
    >
      <g>
        <g clip-path="url(#4326a056-ee4d-4093-b00d-1ee7aa3079c1_comp-lx8o9j2e)">
          <path
            fill="#8280A6"
            d="M54.31 5.761 48.58 27.97l-22.07-5.761L32.24 0l22.07 5.761ZM15.46 2.468c2.587 0 4.623.658 6.11 1.974 1.48 1.31 2.22 2.95 2.22 4.925 0 2.169-.87 3.867-2.61 5.096 2.467 2.84 3.94 6.52 4.42 11.04H15.08c-.187-2.908-.62-5.057-1.3-6.447-.673-1.39-1.723-2.085-3.15-2.085v8.531H.5V2.468h14.96Zm55.45 0c2.933 0 5.143.577 6.63 1.732 1.5 1.148 2.25 2.713 2.25 4.694 0 2.162-.993 3.813-2.98 4.955 1.18.624 2.073 1.353 2.68 2.186.613.825.92 1.856.92 3.092 0 1.933-.69 3.481-2.07 4.643-1.373 1.155-3.3 1.732-5.78 1.732H56.58V2.468h14.33Zm22.7 0V19.72h8.89v5.781H83.47V2.468h10.14Zm48.67 0 3.38 4.24 3.22-4.24h11l-8.66 11.32 9.22 11.714h-11.09l-3.63-4.572-3.5 4.572h-11.01l8.94-11.653-8.94-11.381h11.07Zm-13.83.04v22.944h-22.8V2.508h22.8Zm-61.74 9.075h.26c1.1 0 1.88-.165 2.34-.494.46-.342.69-.926.69-1.752 0-1.491-.89-2.236-2.67-2.236h-.62v4.482Zm-56.09.06h.28c1.82 0 2.73-.718 2.73-2.155 0-.605-.183-1.135-.55-1.592-.373-.463-.99-.695-1.85-.695h-.61v4.442Zm27.09 3.928 4.26 1.118 1.11-4.29-4.26-1.118-1.11 4.29Zm77.13.625h4.41v-4.422h-4.41v4.422Zm-48.13 4.23h.32c1.16 0 1.983-.178 2.47-.534.5-.363.75-.98.75-1.853 0-1.733-.943-2.599-2.83-2.599h-.71v4.986Z"
            clip-rule="evenodd"
            fill-rule="evenodd"
            data-color="1"
          />
        </g>
        <defs fill="none">
          <clipPath id="4326a056-ee4d-4093-b00d-1ee7aa3079c1_comp-lx8o9j2e">
            <path
              transform="translate(.5)"
              fill="#ffffff"
              d="M160 0v28H0V0h160z"
            />
          </clipPath>
        </defs>
      </g>
    </svg>
  );
};
export const Google = (props: PropsOf<"svg">, key: string) => {
  return (
    <svg
      {...props}
      key={key}
      preserveAspectRatio="xMidYMid meet"
      data-bbox="0.499 0.415 120.002 39.17"
      xmlns="http://www.w3.org/2000/svg"
      viewBox="0.499 0.415 120.002 39.17"
      height="40"
      width="121"
      data-type="color"
      role="presentation"
      aria-hidden="true"
      aria-label="Google"
    >
      <g>
        <path
          fill="#8280A6"
          d="M15.279.415h1.067c3.704.08 7.349 1.57 9.966 4.208-.966.987-1.953 1.933-2.9 2.92-1.469-1.33-3.24-2.356-5.174-2.719-2.859-.604-5.94-.06-8.335 1.57-2.618 1.712-4.39 4.612-4.772 7.712-.423 3.06.443 6.282 2.436 8.658 1.913 2.315 4.832 3.765 7.853 3.866 2.818.16 5.758-.705 7.812-2.678 1.61-1.39 2.355-3.504 2.597-5.557-3.342 0-6.685.02-10.027 0v-4.148h14.074c.725 4.45-.322 9.463-3.705 12.645-2.255 2.255-5.376 3.583-8.557 3.845-3.08.302-6.262-.282-9-1.772-3.282-1.751-5.9-4.711-7.188-8.194-1.208-3.202-1.228-6.826-.1-10.047 1.026-2.94 3-5.537 5.537-7.35C9.299 1.584 12.258.597 15.279.416Z"
          data-color="1"
        />
        <path
          fill="#8280A6"
          d="M96.017 1.462h4.309v28.751c-1.43 0-2.88.02-4.309-.02.02-9.563 0-19.147 0-28.731Z"
          data-color="1"
        />
        <path
          fill="#8280A6"
          d="M39.46 11.428c2.658-.503 5.537.06 7.731 1.652 1.994 1.409 3.383 3.624 3.806 6.04.544 2.799-.141 5.859-1.953 8.074-1.953 2.476-5.154 3.805-8.275 3.604-2.86-.161-5.638-1.59-7.33-3.926-1.912-2.578-2.375-6.121-1.328-9.141 1.047-3.242 4.007-5.719 7.349-6.303Zm.604 3.826a5.413 5.413 0 0 0-2.819 1.792c-1.953 2.336-1.832 6.14.322 8.315 1.228 1.249 3.08 1.833 4.792 1.49 1.59-.281 2.98-1.349 3.745-2.758 1.33-2.396.947-5.698-1.087-7.57-1.309-1.208-3.222-1.712-4.953-1.269Z"
          data-color="1"
        />
        <path
          fill="#8280A6"
          d="M60.802 11.429c3.04-.584 6.363.261 8.638 2.396 3.704 3.322 4.107 9.543.946 13.369-1.913 2.416-5.013 3.745-8.074 3.604-2.92-.08-5.798-1.53-7.53-3.926-1.953-2.638-2.376-6.262-1.268-9.343 1.107-3.14 4.006-5.537 7.288-6.1Zm.604 3.825a5.505 5.505 0 0 0-2.819 1.772c-1.932 2.295-1.852 6.04.222 8.235 1.228 1.309 3.14 1.953 4.913 1.59 1.57-.302 2.98-1.349 3.745-2.758 1.308-2.416.926-5.718-1.128-7.59-1.309-1.209-3.221-1.692-4.933-1.249Z"
          data-color="1"
        />
        <path
          fill="#8280A6"
          d="M78.903 12.596c2.316-1.45 5.396-1.852 7.893-.604.785.342 1.43.926 2.054 1.51.02-.544 0-1.107.02-1.671 1.349.02 2.698 0 4.067.02v17.758c-.02 2.678-.705 5.517-2.638 7.47-2.114 2.155-5.355 2.819-8.275 2.376-3.12-.463-5.839-2.738-7.047-5.617 1.208-.584 2.477-1.047 3.725-1.591.705 1.651 2.134 3.06 3.926 3.383 1.792.322 3.866-.121 5.034-1.611 1.248-1.53 1.248-3.624 1.188-5.497-.927.906-1.994 1.712-3.282 2.014-2.799.785-5.88-.182-8.034-2.074-2.174-1.893-3.463-4.812-3.342-7.712.06-3.282 1.913-6.443 4.711-8.154Zm4.168 2.577c-1.228.201-2.376.886-3.161 1.832-1.893 2.255-1.893 5.86.02 8.074 1.087 1.309 2.84 2.034 4.53 1.853 1.591-.162 3.06-1.168 3.846-2.557 1.329-2.356 1.107-5.558-.685-7.611a4.955 4.955 0 0 0-4.55-1.59Z"
          data-color="1"
        />
        <path
          fill="#8280A6"
          d="M105.501 13.623c2.416-2.255 6.14-3.02 9.241-1.832 2.94 1.107 4.812 3.906 5.759 6.785-4.37 1.812-8.719 3.604-13.088 5.416.604 1.148 1.53 2.195 2.779 2.618 1.751.624 3.845.402 5.315-.765.584-.443 1.047-1.027 1.49-1.59 1.108.744 2.215 1.469 3.322 2.214-1.57 2.355-4.208 4.007-7.047 4.268-3.141.383-6.483-.825-8.516-3.282-3.343-3.865-3.021-10.349.745-13.832Zm2.154 3.725c-.685.987-.967 2.195-.946 3.383 2.919-1.209 5.838-2.417 8.758-3.645-.483-1.127-1.651-1.812-2.839-1.993-1.913-.342-3.906.685-4.973 2.255Z"
          data-color="1"
        />
      </g>
    </svg>
  );
};
export const Tesla = (props: PropsOf<"svg">, key: string) => {
  return (
    <svg
      {...props}
      key={key}
      preserveAspectRatio="xMidYMid meet"
      data-bbox="0 0 2499.1 325.619"
      xmlns="http://www.w3.org/2000/svg"
      viewBox="0 0 2499.1 325.619"
      data-type="color"
      role="presentation"
      aria-hidden="true"
      aria-label="Tesla"
    >
      <g>
        <path
          fill="#8280A6"
          d="M2135.81 129.171v196.448h62.79V194.654h229.64v130.965h62.79V129.171h-355.22Zm55.61-63.688h242.2c34.09-6.28 58.31-36.778 65.48-65.483h-373.16c7.18 28.705 32.29 58.306 65.48 65.483Zm-246.68 260.136c31.4-13.455 48.44-36.778 55.62-63.689H1717.8V.897h-63.69v324.722h290.63ZM1183.17 64.586h224.26c34.08-9.868 61.89-35.881 69.07-63.689h-355.22V192.86h290.63v67.276h-227.84c-35.88 9.868-66.38 34.087-81.63 65.483h372.26V129.171h-290.63l-.9-64.585Zm-552.564.897h242.196c34.087-6.28 59.204-36.778 65.483-65.483H564.227c7.176 28.705 32.293 58.306 66.379 65.483Zm0 128.274h242.196c34.087-6.279 59.204-36.778 65.483-65.483H564.227c7.176 28.705 32.293 58.307 66.379 65.483Zm0 131.862h242.196c34.087-6.279 59.204-36.778 65.483-65.483H564.227c7.176 28.705 32.293 59.204 66.379 65.483Z"
          data-color="1"
        />
        <path
          fill="#8280A6"
          d="M0 .897c7.176 28.705 32.293 57.41 65.483 64.586h102.26l5.382 1.794v257.445h63.689V67.277l5.382-1.794h102.26c34.087-8.97 58.307-35.881 65.483-64.586V0L0 .897Z"
          data-color="1"
        />
      </g>
    </svg>
  );
};
