import type { PropsOf } from "@builder.io/qwik";

export const Slack = (props: PropsOf<"svg">, key: string) => {
  return (
    <svg
      {...props}
      key={key}
      preserveAspectRatio="xMidYMid meet"
      data-bbox="0 0 111 42"
      xmlns="http://www.w3.org/2000/svg"
      viewBox="0 0 111 42"
      height="37"
      width="97"
      data-type="ugc"
      role="presentation"
      aria-hidden="true"
      aria-label="Slack"
    >
      <g>
        <path
          fill="url(#f9de4de1-1e5c-4c35-a7c2-1ed69da1b1b3_comp-lx8rfjhg)"
          d="M111 18.989v4.022C111 33.498 102.498 42 92.011 42H18.989C8.502 42 0 33.498 0 23.011v-4.022C0 8.502 8.502 0 18.989 0h73.022C102.498 0 111 8.502 111 18.989z"
        />
        <path
          stroke-opacity=".11"
          stroke="#ffffff"
          d="M110.5 18.989v4.022c0 10.211-8.278 18.489-18.489 18.489H18.989C8.778 41.5.5 33.222.5 23.011v-4.022C.5 8.778 8.778.5 18.989.5h73.022C102.222.5 110.5 8.778 110.5 18.989z"
          fill="none"
        />
        <path
          fill="#ffffff"
          d="m39.837 27.236 1.085-2.494c1.172.866 2.73 1.316 4.27 1.316 1.138 0 1.855-.433 1.855-1.091-.017-1.836-6.808-.399-6.86-5.006-.018-2.339 2.082-4.14 5.058-4.14 1.767 0 3.535.432 4.795 1.42l-1.015 2.546c-1.155-.727-2.59-1.247-3.956-1.247-.927 0-1.54.433-1.54.988.018 1.801 6.86.814 6.93 5.214 0 2.39-2.047 4.07-4.987 4.07-2.153 0-4.13-.502-5.635-1.576Zm41.634-3.395a3.154 3.154 0 0 1-2.73 1.576c-1.733 0-3.133-1.386-3.133-3.1 0-1.715 1.4-3.101 3.133-3.101 1.173 0 2.188.64 2.73 1.576l2.993-1.646a6.591 6.591 0 0 0-5.723-3.326c-3.623 0-6.563 2.91-6.563 6.496 0 3.586 2.94 6.497 6.563 6.497a6.534 6.534 0 0 0 5.723-3.326L81.47 23.84ZM51.965 10.433h3.745V28.57h-3.745V10.433Zm33.969 0V28.57h3.745v-5.44l4.445 5.44h4.795l-5.652-6.461 5.232-6.029h-4.585l-4.235 5.007V10.433h-3.745ZM66.84 23.875c-.543.884-1.663 1.542-2.923 1.542-1.733 0-3.133-1.386-3.133-3.1 0-1.715 1.4-3.101 3.133-3.101 1.26 0 2.38.693 2.923 1.593v3.066Zm0-7.795v1.473c-.613-1.022-2.136-1.733-3.728-1.733-3.29 0-5.88 2.876-5.88 6.48 0 3.602 2.59 6.512 5.88 6.512 1.592 0 3.115-.71 3.728-1.732v1.473h3.745V16.08H66.84Z"
        />
        <path
          fill="#E01E5A"
          d="M16.683 23.858a2.296 2.296 0 0 1-2.31 2.287 2.296 2.296 0 0 1-2.31-2.287 2.296 2.296 0 0 1 2.31-2.286h2.31v2.286Zm1.155 0a2.296 2.296 0 0 1 2.31-2.286 2.296 2.296 0 0 1 2.31 2.286v5.717a2.296 2.296 0 0 1-2.31 2.286 2.296 2.296 0 0 1-2.31-2.286v-5.717Z"
        />
        <path
          fill="#36C5F0"
          d="M20.148 14.677a2.296 2.296 0 0 1-2.31-2.287 2.296 2.296 0 0 1 2.31-2.286 2.296 2.296 0 0 1 2.31 2.287v2.286h-2.31Zm0 1.16a2.296 2.296 0 0 1 2.31 2.287 2.296 2.296 0 0 1-2.31 2.287h-5.792a2.296 2.296 0 0 1-2.31-2.287 2.296 2.296 0 0 1 2.31-2.286h5.792Z"
        />
        <path
          fill="#2EB67D"
          d="M29.406 18.124a2.296 2.296 0 0 1 2.31-2.286 2.296 2.296 0 0 1 2.31 2.286 2.296 2.296 0 0 1-2.31 2.287h-2.31v-2.287Zm-1.155 0a2.296 2.296 0 0 1-2.31 2.287 2.296 2.296 0 0 1-2.31-2.287v-5.733a2.296 2.296 0 0 1 2.31-2.287 2.296 2.296 0 0 1 2.31 2.287v5.733Z"
        />
        <path
          fill="#ECB22E"
          d="M25.941 27.288a2.296 2.296 0 0 1 2.31 2.287 2.296 2.296 0 0 1-2.31 2.286 2.296 2.296 0 0 1-2.31-2.286v-2.287h2.31Zm0-1.143a2.296 2.296 0 0 1-2.31-2.287 2.296 2.296 0 0 1 2.31-2.286h5.793a2.296 2.296 0 0 1 2.31 2.286 2.296 2.296 0 0 1-2.31 2.287h-5.793Z"
        />
        <defs fill="none">
          <radialGradient
            gradientTransform="matrix(0 21 -55.5 0 55.5 21)"
            gradientUnits="userSpaceOnUse"
            r="1"
            cy="0"
            cx="0"
            id="f9de4de1-1e5c-4c35-a7c2-1ed69da1b1b3_comp-lx8rfjhg"
          >
            <stop stop-opacity="0" stop-color="#ffffff" offset=".734" />
            <stop stop-opacity=".06" stop-color="#ffffff" offset="1" />
          </radialGradient>
        </defs>
      </g>
    </svg>
  );
};

export const GitHub = (props: PropsOf<"svg">, key: string) => {
  return (
    <svg
      {...props}
      key={key}
      preserveAspectRatio="xMidYMid meet"
      data-bbox="0 0 111 42"
      xmlns="http://www.w3.org/2000/svg"
      viewBox="0 0 111 42"
      height="37"
      width="97"
      data-type="ugc"
      role="presentation"
      aria-hidden="true"
      aria-label="GitHub"
    >
      <g>
        <path
          fill="url(#fb9790ad-7b1b-472f-bf15-78aefe72a4d4_comp-lx8rfjhl)"
          d="M111 18.989v4.022C111 33.498 102.498 42 92.011 42H18.989C8.502 42 0 33.498 0 23.011v-4.022C0 8.502 8.502 0 18.989 0h73.022C102.498 0 111 8.502 111 18.989z"
        />
        <path
          stroke-opacity=".11"
          stroke="#ffffff"
          d="M110.5 18.989v4.022c0 10.211-8.278 18.489-18.489 18.489H18.989C8.778 41.5.5 33.222.5 23.011v-4.022C.5 8.778 8.778.5 18.989.5h73.022C102.222.5 110.5 8.778 110.5 18.989z"
          fill="none"
        />
        <path
          fill="#ffffff"
          d="M56.078 20.026h-4.435a.209.209 0 0 0-.147.06.203.203 0 0 0-.06.145v2.14c0 .113.093.205.207.205h1.73v2.66s-.388.13-1.462.13c-1.268 0-3.038-.457-3.038-4.299 0-3.843 1.844-4.349 3.574-4.349 1.498 0 2.143.26 2.554.386.129.04.248-.088.248-.2l.495-2.069a.19.19 0 0 0-.079-.16c-.167-.117-1.184-.679-3.754-.679-2.961 0-5.999 1.244-5.999 7.22 0 5.978 3.478 6.869 6.408 6.869 2.426 0 3.898-1.023 3.898-1.023.06-.033.067-.117.067-.155V20.23a.201.201 0 0 0-.06-.145.208.208 0 0 0-.147-.06Zm22.858-5.314a.203.203 0 0 0-.127-.19.209.209 0 0 0-.079-.015h-2.497a.21.21 0 0 0-.192.127.202.202 0 0 0-.015.078v4.764h-3.892v-4.764a.206.206 0 0 0-.206-.205H69.43a.21.21 0 0 0-.147.06.203.203 0 0 0-.06.145v12.899c0 .114.093.206.207.206h2.497a.206.206 0 0 0 .206-.206v-5.517h3.893l-.007 5.517c0 .114.092.206.207.206h2.503a.206.206 0 0 0 .206-.206V14.712Zm-18.145 1.693c0-.888-.721-1.605-1.61-1.605a1.606 1.606 0 1 0 0 3.211c.889 0 1.61-.72 1.61-1.606Zm-.179 8.485v-5.954a.206.206 0 0 0-.206-.205h-2.49c-.114 0-.216.116-.216.229v8.53c0 .25.158.326.363.326h2.243c.246 0 .306-.12.306-.33V24.89Zm27.815-6.14h-2.478a.206.206 0 0 0-.206.206v6.325s-.63.454-1.524.454c-.893 0-1.13-.4-1.13-1.263v-5.516a.206.206 0 0 0-.206-.206h-2.515a.207.207 0 0 0-.207.206v5.933c0 2.565 1.448 3.193 3.44 3.193 1.636 0 2.954-.892 2.954-.892s.062.47.09.526a.218.218 0 0 0 .183.112l1.6-.007a.207.207 0 0 0 .207-.206l-.001-8.659a.206.206 0 0 0-.207-.206Zm5.796 6.978a3 3 0 0 1-1.443-.411v-4.085s.575-.348 1.281-.41c.893-.079 1.752.187 1.752 2.288 0 2.216-.388 2.654-1.59 2.618Zm.977-7.268c-1.407 0-2.365.62-2.365.62v-4.368a.206.206 0 0 0-.206-.205h-2.504a.21.21 0 0 0-.146.06.206.206 0 0 0-.06.145v12.899c0 .114.092.206.206.206h1.738c.078 0 .137-.04.181-.11.043-.069.106-.594.106-.594s1.024.958 2.962.958c2.276 0 3.582-1.14 3.582-5.115 0-3.976-2.085-4.496-3.494-4.496Zm-27.41.27h-1.874l-.002-2.443c0-.093-.049-.139-.157-.139h-2.553c-.099 0-.152.043-.152.137v2.525s-1.28.304-1.366.33a.203.203 0 0 0-.15.197v1.585c0 .114.093.206.207.206h1.309v3.816c0 2.835 2.014 3.113 3.373 3.113.621 0 1.364-.197 1.487-.242.074-.027.117-.102.117-.184l.002-1.745a.21.21 0 0 0-.207-.207c-.109 0-.388.044-.676.044-.92 0-1.232-.422-1.232-.968v-3.627h1.874a.212.212 0 0 0 .146-.06.205.205 0 0 0 .06-.146v-1.987a.206.206 0 0 0-.206-.205Z"
        />
        <path
          fill="#ffffff"
          d="M25.649 8c-7.56 0-13.343 5.661-13.343 13.118 0 5.962 3.805 11.064 9.239 12.86.697.124.942-.301.942-.65 0-.334-.016-2.172-.016-3.302 0 0-3.815.807-4.616-1.602 0 0-.622-1.564-1.515-1.967 0 0-1.248-.844.087-.828 0 0 1.357.107 2.104 1.387 1.193 2.075 3.193 1.478 3.973 1.124.125-.86.48-1.457.872-1.812-3.047-.334-6.12-.77-6.12-5.941 0-1.479.413-2.22 1.285-3.167-.141-.35-.605-1.79.142-3.65 1.14-.35 3.76 1.451 3.76 1.451a12.969 12.969 0 0 1 3.424-.457c1.16 0 2.332.156 3.422.457 0 0 2.622-1.806 3.761-1.451.747 1.865.283 3.3.142 3.65.872.952 1.406 1.694 1.406 3.167 0 5.188-3.21 5.602-6.257 5.94.501.425.926 1.232.926 2.495 0 1.812-.016 4.054-.016 4.495 0 .35.25.774.943.65 5.45-1.785 9.146-6.887 9.146-12.849C39.34 13.661 33.208 8 25.648 8Z"
        />
        <defs fill="none">
          <radialGradient
            gradientTransform="matrix(0 21 -55.5 0 55.5 21)"
            gradientUnits="userSpaceOnUse"
            r="1"
            cy="0"
            cx="0"
            id="fb9790ad-7b1b-472f-bf15-78aefe72a4d4_comp-lx8rfjhl"
          >
            <stop stop-opacity="0" stop-color="#ffffff" offset=".734" />
            <stop stop-opacity=".06" stop-color="#ffffff" offset="1" />
          </radialGradient>
        </defs>
      </g>
    </svg>
  );
};

export const Cloud = (props: PropsOf<"svg">, key: string) => {
  return (
    <svg
      {...props}
      key={key}
      role="presentation"
      aria-hidden="true"
      aria-label="GitHub"
      data-bbox="0.139 0.322 20.698 13.356"
      xmlns="http://www.w3.org/2000/svg"
      viewBox="0 0 21 14"
      height="14"
      width="21"
      data-type="ugc"
    >
      <g>
        <g filter="url(#9ce59d9b-9b10-4d57-950d-bd73ae64554a)">
          <path
            fill="url(#005ff554-ffb9-49ab-ada2-c9b58beba57c)"
            d="M7.837.322c1.643 0 3.067.938 3.767 2.307q.226-.024.46-.024a4.23 4.23 0 0 1 3.93 2.667 4.226 4.226 0 1 1 .889 8.398v.008H4.456v-.001h-.085a4.226 4.226 0 0 1-.698-8.395A4.226 4.226 0 0 1 7.837.322"
            clip-rule="evenodd"
            fill-rule="evenodd"
          />
        </g>
        <defs fill="none">
          <linearGradient
            gradientUnits="userSpaceOnUse"
            y2="7.839"
            x2="25.069"
            y1="7"
            x1="-.898"
            id="005ff554-ffb9-49ab-ada2-c9b58beba57c"
          >
            <stop stop-color="#724FBA" />
            <stop stop-color="#292C9F" offset="1" />
          </linearGradient>
          <filter
            filterUnits="userSpaceOnUse"
            height="59.356"
            width="66.71"
            y="-22.678"
            x="-22.855"
            id="9ce59d9b-9b10-4d57-950d-bd73ae64554a"
          >
            <feFlood result="BackgroundImageFix" flood-opacity="0" />
            <feGaussianBlur stdDeviation="11.5" in="BackgroundImageFix" />
            <feComposite
              result="effect1_backgroundBlur_4011_1317"
              operator="in"
              in2="SourceAlpha"
            />
            <feBlend
              result="shape"
              in2="effect1_backgroundBlur_4011_1317"
              in="SourceGraphic"
            />
          </filter>
        </defs>
      </g>
    </svg>
  );
};

export const Background = (props: PropsOf<"svg">, key: string) => {
  return (
    <svg
      {...props}
      key={key}
      data-bbox="-459.414 -704.781 2722.618 1778.042"
      xmlns="http://www.w3.org/2000/svg"
      viewBox="0 0 1698 1622"
      height="1622"
      width="1698"
      data-type="ugc"
      role="img"
      aria-label="Frame 119"
    >
      <g>
        <g clip-path="url(#ec984b32-57aa-4140-89a4-b9ba23ef67e9_comp-lz3yof9j)">
          <g filter="url(#c7aa8839-77ab-4b66-ab72-db217a318933_comp-lz3yof9j)">
            <path
              fill="#2B1B73"
              d="M810.796 48.167c76.075-257.237 459.924-370.488 857.35-252.953s657.933 421.346 581.858 678.583-459.924 370.488-857.35 252.953S734.721 305.404 810.796 48.167"
            />
          </g>
          <g filter="url(#be10ce3b-bdc2-43f7-a324-c8aea570fba4_comp-lz3yof9j)">
            <path
              fill="#ADD7FC"
              d="M1577.41 632.191c169.3 102.155 303.21 60.146 376.46-61.259C2106.73 317.605 666.576-674.219 312.788-599.514 52.786-544.613-57.8-313.122 70.68-129.708 215.874 77.567 194.932 90.947 431.432 139.051c197.331 40.138 436.41 58.957 644.328 117.85 194.61 55.124 351.26 284.55 501.65 375.29"
            />
          </g>
          <g filter="url(#730b40f7-3907-45a6-95f4-9cc3ab7c24c7_comp-lz3yof9j)">
            <path
              fill="#0420B8"
              d="M-75.188 542.257C498.438 247.911 974.88 672.643 1159.75 545.134c232.4-160.289-99.05-625.826-406.044-698.096C391.843-238.149-463.926 741.73-75.188 542.257"
            />
          </g>
          <g
            filter="url(#48638e9b-c5db-4c3a-88a4-c8d290b537e1_comp-lz3yof9j)"
            opacity=".46"
          >
            <path
              fill="url(#8c0b126f-5502-45c6-85db-b34a929f44ae_comp-lz3yof9j)"
              d="M1788.598 377.331c0 42.282-34.276 76.558-76.558 76.558s-76.558-34.276-76.558-76.558 34.276-76.558 76.558-76.558 76.558 34.276 76.558 76.558"
            />
          </g>
          <g filter="url(#c435d7b9-09e8-401e-98c3-c27582fd72a3_comp-lz3yof9j)">
            <path
              fill="#9F6BFE"
              d="M-455.853-68.009c40.951-393.99 424.3-676.986 856.235-632.09 431.934 44.894 748.888 400.68 707.937 794.67s-424.3 676.986-856.235 632.09c-431.934-44.894-748.888-400.68-707.937-794.67"
            />
          </g>
          <g filter="url(#941b391b-6a96-49cc-8314-099967b9cbf9_comp-lz3yof9j)">
            <path
              fill="#060606"
              d="M841.706 83.189 3.026 1073.26V.3H1679.81l57.56 1006.76h-78.28z"
            />
          </g>
          <g opacity=".4">
            <path
              fill="#ffffff"
              opacity=".8"
              d="M690.128 401.725a.725.725 0 1 1-1.45 0 .725.725 0 0 1 1.45 0"
            />
            <path
              fill="#ffffff"
              opacity=".8"
              d="M613.267 414.777a.725.725 0 1 1-1.45 0 .725.725 0 0 1 1.45 0"
            />
            <path
              fill="#ffffff"
              opacity=".8"
              d="M637.919 501.791a.725.725 0 1 1-1.45 0 .725.725 0 0 1 1.45 0"
            />
            <path
              fill="#ffffff"
              opacity=".8"
              d="M706.08 459.01a1.45 1.45 0 1 1-2.9 0 1.45 1.45 0 0 1 2.9 0"
            />
            <path
              fill="#ffffff"
              opacity=".8"
              d="M650.971 448.857a1.45 1.45 0 1 1-2.9 0 1.45 1.45 0 0 1 2.9 0"
            />
            <path
              fill="#ffffff"
              opacity=".8"
              d="M722.032 440.881a.725.725 0 1 1-1.45 0 .725.725 0 0 1 1.45 0"
            />
            <path
              fill="#ffffff"
              opacity=".8"
              d="M848.204 501.791a.725.725 0 1 1-1.45 0 .725.725 0 0 1 1.45 0"
            />
            <path
              fill="#ffffff"
              opacity=".8"
              d="M775.692 491.64a.725.725 0 1 1-1.45 0 .725.725 0 0 1 1.45 0"
            />
            <path
              fill="#ffffff"
              opacity=".8"
              d="M795.995 498.891a.725.725 0 1 1-1.45 0 .725.725 0 0 1 1.45 0"
            />
            <path
              fill="#ffffff"
              opacity=".8"
              d="M854.005 542.398a.725.725 0 1 1-1.45 0 .725.725 0 0 1 1.45 0"
            />
            <path
              fill="#ffffff"
              opacity=".8"
              d="M896.061 581.554a.725.725 0 1 1-1.45 0 .725.725 0 0 1 1.45 0"
            />
            <path
              fill="#ffffff"
              opacity=".8"
              d="M938.118 594.607a.725.725 0 1 1-1.45 0 .725.725 0 0 1 1.45 0"
            />
            <path
              fill="#ffffff"
              opacity=".8"
              d="M633.569 490.19a.725.725 0 1 1-1.45 0 .725.725 0 0 1 1.45 0"
            />
            <path
              fill="#ffffff"
              opacity=".8"
              d="M566.856 510.493a.725.725 0 1 1-1.45 0 .725.725 0 0 1 1.45 0"
            />
            <path
              fill="#ffffff"
              opacity=".8"
              d="M597.313 540.948a.725.725 0 1 1-1.45 0 .725.725 0 0 1 1.45 0"
            />
            <path
              fill="#ffffff"
              opacity=".8"
              d="M994.677 591.707a.725.725 0 1 1-1.45 0 .725.725 0 0 1 1.45 0"
            />
            <path
              fill="#ffffff"
              opacity=".8"
              d="M1004.83 599.683a1.45 1.45 0 1 1-2.9 0 1.45 1.45 0 0 1 2.9 0"
            />
            <path
              fill="#ffffff"
              opacity=".8"
              d="M994.677 591.707a.725.725 0 1 1-1.45 0 .725.725 0 0 1 1.45 0"
            />
            <path
              fill="#ffffff"
              opacity=".8"
              d="M1004.83 599.683a1.45 1.45 0 1 1-2.9 0 1.45 1.45 0 0 1 2.9 0"
            />
            <path
              fill="#ffffff"
              opacity=".8"
              d="M527.702 564.152a.725.725 0 1 1-1.45 0 .725.725 0 0 1 1.45 0"
            />
            <path
              fill="#ffffff"
              opacity=".8"
              d="M706.079 606.208a.725.725 0 1 1-1.45 0 .725.725 0 0 1 1.45 0"
            />
            <path
              fill="#ffffff"
              opacity=".8"
              d="M749.587 661.318a.725.725 0 1 1-1.45 0 .725.725 0 0 1 1.45 0"
            />
            <path
              fill="#ffffff"
              opacity=".8"
              d="M781.493 678.72a.725.725 0 1 1-1.45 0 .725.725 0 0 1 1.45 0"
            />
            <path
              fill="#ffffff"
              opacity=".8"
              d="M737.985 622.161a.725.725 0 1 1-1.45 0 .725.725 0 0 1 1.45 0"
            />
            <path
              fill="#ffffff"
              opacity=".8"
              d="M745.237 619.26a.725.725 0 1 1-1.45 0 .725.725 0 0 1 1.45 0"
            />
            <path
              fill="#ffffff"
              opacity=".8"
              d="M871.407 735.28a.725.725 0 1 1-1.45 0 .725.725 0 0 1 1.45 0"
            />
            <path
              fill="#ffffff"
              opacity=".8"
              d="M807.597 752.682a.725.725 0 1 1-1.45 0 .725.725 0 0 1 1.45 0"
            />
            <path
              fill="#ffffff"
              opacity=".8"
              d="M752.488 692.497a1.45 1.45 0 1 1-2.9 0 1.45 1.45 0 0 1 2.9 0"
            />
            <path
              fill="#ffffff"
              opacity=".8"
              d="M737.985 709.175a.725.725 0 1 1-1.45 0 .725.725 0 0 1 1.45 0"
            />
            <path
              fill="#ffffff"
              opacity=".8"
              d="M758.288 607.659a.725.725 0 1 1-1.45 0 .725.725 0 0 1 1.45 0"
            />
            <path
              fill="#ffffff"
              opacity=".8"
              d="M755.388 597.507a.725.725 0 1 1-1.45 0 .725.725 0 0 1 1.45 0"
            />
            <path
              fill="#ffffff"
              opacity=".8"
              d="M520.45 604.758a.725.725 0 1 1-1.45 0 .725.725 0 0 1 1.45 0"
            />
            <path
              fill="#ffffff"
              opacity=".8"
              d="M665.474 627.237a1.45 1.45 0 1 1-2.9 0 1.45 1.45 0 0 1 2.9 0"
            />
            <path
              fill="#ffffff"
              opacity=".8"
              d="M726.383 659.143a1.45 1.45 0 1 1-2.9 0 1.45 1.45 0 0 1 2.9 0"
            />
            <path
              fill="#ffffff"
              opacity=".8"
              d="M662.574 403.9a1.45 1.45 0 1 1-2.9 0 1.45 1.45 0 0 1 2.9 0"
            />
            <path
              fill="#ffffff"
              opacity=".8"
              d="M946.819 554a.725.725 0 1 1-1.45 0 .725.725 0 0 1 1.45 0"
            />
            <path
              fill="#ffffff"
              opacity=".8"
              d="M930.866 580.104a.725.725 0 1 1-1.45 0 .725.725 0 0 1 1.45 0"
            />
          </g>
        </g>
        <defs fill="none">
          <filter
            color-interpolation-filters="s-rGB"
            filterUnits="userSpaceOnUse"
            height="1864.42"
            width="2305.61"
            y="-671.227"
            x="377.593"
            id="c7aa8839-77ab-4b66-ab72-db217a318933_comp-lz3yof9j"
          >
            <feFlood result="BackgroundImageFix" flood-opacity="0" />
            <feBlend
              result="shape"
              in2="BackgroundImageFix"
              in="SourceGraphic"
            />
            <feGaussianBlur
              result="effect1_foregroundBlur_4011_1223"
              stdDeviation="210"
            />
          </filter>
          <filter
            color-interpolation-filters="s-rGB"
            filterUnits="userSpaceOnUse"
            height="1933.29"
            width="2588.18"
            y="-923.52"
            x="-302.992"
            id="be10ce3b-bdc2-43f7-a324-c8aea570fba4_comp-lz3yof9j"
          >
            <feFlood result="BackgroundImageFix" flood-opacity="0" />
            <feBlend
              result="shape"
              in2="BackgroundImageFix"
              in="SourceGraphic"
            />
            <feGaussianBlur
              result="effect1_foregroundBlur_4011_1223"
              stdDeviation="160"
            />
          </filter>
          <filter
            color-interpolation-filters="s-rGB"
            filterUnits="userSpaceOnUse"
            height="1367.94"
            width="2052.1"
            y="-478.226"
            x="-494.286"
            id="730b40f7-3907-45a6-95f4-9cc3ab7c24c7_comp-lz3yof9j"
          >
            <feFlood result="BackgroundImageFix" flood-opacity="0" />
            <feBlend
              result="shape"
              in2="BackgroundImageFix"
              in="SourceGraphic"
            />
            <feGaussianBlur
              result="effect1_foregroundBlur_4011_1223"
              stdDeviation="160"
            />
          </filter>
          <filter
            color-interpolation-filters="s-rGB"
            filterUnits="userSpaceOnUse"
            height="281.115"
            width="281.115"
            y="236.774"
            x="1571.49"
            id="48638e9b-c5db-4c3a-88a4-c8d290b537e1_comp-lz3yof9j"
          >
            <feFlood result="BackgroundImageFix" flood-opacity="0" />
            <feBlend
              result="shape"
              in2="BackgroundImageFix"
              in="SourceGraphic"
            />
            <feGaussianBlur
              result="effect1_foregroundBlur_4011_1223"
              stdDeviation="32"
            />
          </filter>
          <filter
            color-interpolation-filters="s-rGB"
            filterUnits="userSpaceOnUse"
            height="2036.13"
            width="2171.29"
            y="-1004.78"
            x="-759.414"
            id="c435d7b9-09e8-401e-98c3-c27582fd72a3_comp-lz3yof9j"
          >
            <feFlood result="BackgroundImageFix" flood-opacity="0" />
            <feBlend
              result="shape"
              in2="BackgroundImageFix"
              in="SourceGraphic"
            />
            <feGaussianBlur
              result="effect1_foregroundBlur_4011_1223"
              stdDeviation="150"
            />
          </filter>
          <filter
            color-interpolation-filters="s-rGB"
            filterUnits="userSpaceOnUse"
            height="1264.44"
            width="1918.35"
            y="-91.701"
            x="-88.975"
            id="941b391b-6a96-49cc-8314-099967b9cbf9_comp-lz3yof9j"
          >
            <feFlood result="BackgroundImageFix" flood-opacity="0" />
            <feBlend
              result="shape"
              in2="BackgroundImageFix"
              in="SourceGraphic"
            />
            <feGaussianBlur
              result="effect1_foregroundBlur_4011_1223"
              stdDeviation="46"
            />
          </filter>
          <linearGradient
            gradientUnits="userSpaceOnUse"
            y2="320.331"
            x2="1804.09"
            y1="300.774"
            x1="1635.49"
            id="8c0b126f-5502-45c6-85db-b34a929f44ae_comp-lz3yof9j"
          >
            <stop stop-color="#020F65" />
            <stop stop-color="#0239D6" offset=".567" />
            <stop stop-color="#0DB5DD" offset="1" />
          </linearGradient>
          <clipPath id="ec984b32-57aa-4140-89a4-b9ba23ef67e9_comp-lz3yof9j">
            <path fill="#ffffff" d="M1698 0v1622H0V0z" />
          </clipPath>
        </defs>
      </g>
    </svg>
  );
};

export const SlackIcon = (_props: PropsOf<"svg">, _key: string) => {
  return (
    <svg
      preserveAspectRatio="xMidYMid meet"
      data-bbox="0 0.62 21.998 21.759"
      xmlns="http://www.w3.org/2000/svg"
      viewBox="0 0.62 21.998 21.759"
      height="23"
      width="22"
      data-type="color"
      role="img"
      aria-label="Group"
    >
      <defs />
      <g>
        <path
          fill="#E01E5A"
          d="M4.638 14.376a2.296 2.296 0 0 1-2.31 2.286 2.296 2.296 0 0 1-2.31-2.286 2.296 2.296 0 0 1 2.31-2.287h2.31zm1.155 0a2.296 2.296 0 0 1 2.31-2.287 2.296 2.296 0 0 1 2.31 2.287v5.716a2.296 2.296 0 0 1-2.31 2.287 2.296 2.296 0 0 1-2.31-2.287z"
          data-color="1"
        />
        <path
          fill="#36C5F0"
          d="M8.103 5.194a2.296 2.296 0 0 1-2.31-2.286A2.296 2.296 0 0 1 8.103.62a2.296 2.296 0 0 1 2.31 2.287v2.286zm0 1.161a2.296 2.296 0 0 1 2.31 2.287 2.296 2.296 0 0 1-2.31 2.286H2.31A2.296 2.296 0 0 1 0 8.642a2.296 2.296 0 0 1 2.31-2.287z"
          data-color="2"
        />
        <path
          fill="#2EB67D"
          d="M17.36 8.642a2.296 2.296 0 0 1 2.31-2.287 2.296 2.296 0 0 1 2.311 2.287 2.296 2.296 0 0 1-2.31 2.286h-2.31zm-1.154 0a2.296 2.296 0 0 1-2.31 2.286 2.296 2.296 0 0 1-2.31-2.286V2.908A2.296 2.296 0 0 1 13.896.62a2.296 2.296 0 0 1 2.31 2.287z"
          data-color="3"
        />
        <path
          fill="#ECB22E"
          d="M13.896 17.806a2.296 2.296 0 0 1 2.31 2.286 2.296 2.296 0 0 1-2.31 2.287 2.296 2.296 0 0 1-2.31-2.287v-2.286zm0-1.144a2.296 2.296 0 0 1-2.31-2.286 2.296 2.296 0 0 1 2.31-2.287h5.792a2.296 2.296 0 0 1 2.31 2.287 2.296 2.296 0 0 1-2.31 2.286z"
          data-color="4"
        />
      </g>
    </svg>
  );
};

export const GitHubIcon = (_props: PropsOf<"svg">, _key: string) => {
  return (
    <svg
      preserveAspectRatio="xMidYMid meet"
      data-bbox="-0.001 0.5 27.034 26"
      xmlns="http://www.w3.org/2000/svg"
      viewBox="-0.001 0.5 27.034 26"
      height="27"
      width="28"
      data-type="color"
      role="img"
      aria-label="Vector"
    >
      <defs />
      <g>
        <path
          fill="#ffffff"
          d="M13.34.5C5.782.5-.001 6.161-.001 13.618c0 5.962 3.805 11.064 9.239 12.86.697.124.943-.301.943-.65 0-.334-.017-2.172-.017-3.302 0 0-3.815.807-4.616-1.602 0 0-.622-1.564-1.515-1.967 0 0-1.248-.844.087-.828 0 0 1.357.107 2.104 1.387 1.193 2.075 3.193 1.478 3.973 1.124.125-.86.48-1.457.872-1.812-3.047-.334-6.12-.77-6.12-5.941 0-1.479.413-2.22 1.286-3.167-.142-.35-.605-1.79.141-3.65 1.14-.35 3.76 1.451 3.76 1.451a13 13 0 0 1 3.424-.457c1.16 0 2.332.156 3.422.457 0 0 2.622-1.806 3.761-1.451.747 1.865.283 3.3.142 3.65.872.952 1.406 1.694 1.406 3.167 0 5.188-3.21 5.602-6.257 5.94.501.425.926 1.232.926 2.495 0 1.812-.016 4.054-.016 4.495 0 .35.25.774.943.65 5.45-1.785 9.146-6.887 9.146-12.849C27.032 6.161 20.9.5 13.34.5"
          data-color="1"
        />
      </g>
    </svg>
  );
};
