import type { PropsOf } from "@builder.io/qwik";

export const CAS = (props: PropsOf<"svg">, key: string) => {
  return (
    <svg
      {...props}
      key={key}
      preserveAspectRatio="xMidYMid meet"
      data-bbox="0 0 48 48"
      xmlns="http://www.w3.org/2000/svg"
      viewBox="0 0 48 48"
      height="48"
      width="48"
      data-type="ugc"
      role="presentation"
      aria-hidden="true"
      aria-label="CAS"
    >
      <g>
        <path
          fill="url(#f7e70482-34f4-4f56-ad38-b9c76e9f45bd_comp-lx8pqlu4)"
          d="M48 8v32a8 8 0 0 1-8 8H8a8 8 0 0 1-8-8V8a8 8 0 0 1 8-8h32a8 8 0 0 1 8 8z"
        />
        <path
          fill="#7148FA"
          d="M22.91 25.032a7.5 7.5 0 1 1-10.606 10.606A7.5 7.5 0 0 1 22.91 25.032z"
        />
        <path
          fill="#9272FF"
          d="M29.275 18.667a7.5 7.5 0 1 1-10.607 10.606 7.5 7.5 0 0 1 10.607-10.606z"
        />
        <path
          fill="#AD96FF"
          d="M35.638 12.304A7.5 7.5 0 1 1 25.032 22.91a7.5 7.5 0 0 1 10.606-10.606z"
        />
        <defs fill="none">
          <radialGradient
            gradientTransform="matrix(0 23.4146 -23.4084 0 24 24.585)"
            gradientUnits="userSpaceOnUse"
            r="1"
            cy="0"
            cx="0"
            id="f7e70482-34f4-4f56-ad38-b9c76e9f45bd_comp-lx8pqlu4"
          >
            <stop stop-opacity="0" stop-color="#ffffff" offset=".15" />
            <stop stop-opacity=".15" stop-color="#A6A6FF" offset="1" />
          </radialGradient>
        </defs>
      </g>
    </svg>
  );
};

export const Security = (props: PropsOf<"svg">, key: string) => {
  return (
    <svg
      {...props}
      key={key}
      preserveAspectRatio="xMidYMid meet"
      data-bbox="0 0 48 48"
      xmlns="http://www.w3.org/2000/svg"
      viewBox="0 0 48 48"
      height="48"
      width="48"
      data-type="ugc"
      role="presentation"
      aria-hidden="true"
      aria-label="Security"
    >
      <g>
        <path
          fill="url(#3b976c43-9c05-4210-9e4c-bbc21ec80250_comp-lx8pthsn1)"
          d="M48 8v32a8 8 0 0 1-8 8H8a8 8 0 0 1-8-8V8a8 8 0 0 1 8-8h32a8 8 0 0 1 8 8z"
        />
        <path
          fill="#7148FA"
          d="M21.91 25.304A7.5 7.5 0 1 1 11.304 35.91 7.5 7.5 0 0 1 21.91 25.304z"
        />
        <path
          fill="#AD96FF"
          d="M35.91 11.304A7.5 7.5 0 1 1 25.304 21.91 7.5 7.5 0 0 1 35.91 11.304z"
        />
        <path
          fill="#9272FF"
          d="M35.91 25.576a7.5 7.5 0 1 1-10.606 10.606A7.5 7.5 0 0 1 35.91 25.576z"
        />
        <defs fill="none">
          <radialGradient
            gradientTransform="matrix(0 23.4146 -23.4084 0 24 24.585)"
            gradientUnits="userSpaceOnUse"
            r="1"
            cy="0"
            cx="0"
            id="3b976c43-9c05-4210-9e4c-bbc21ec80250_comp-lx8pthsn1"
          >
            <stop stop-opacity="0" stop-color="#ffffff" offset=".15" />
            <stop stop-opacity=".15" stop-color="#A6A6FF" offset="1" />
          </radialGradient>
        </defs>
      </g>
    </svg>
  );
};

export const RBE = (props: PropsOf<"svg">, key: string) => {
  return (
    <svg
      {...props}
      key={key}
      preserveAspectRatio="xMidYMid meet"
      data-bbox="0 0 48 48"
      xmlns="http://www.w3.org/2000/svg"
      viewBox="0 0 48 48"
      height="48"
      width="48"
      data-type="ugc"
      role="presentation"
      aria-hidden="true"
      aria-label="RBE"
    >
      <g>
        <path
          fill="url(#8cedbf8e-d233-421a-b46a-7ea0facde8e3_comp-lx8pwl493)"
          d="M48 8v32a8 8 0 0 1-8 8H8a8 8 0 0 1-8-8V8a8 8 0 0 1 8-8h32a8 8 0 0 1 8 8z"
        />
        <path
          fill="#7148FA"
          d="M22.91 25.032a7.5 7.5 0 1 1-10.606 10.606A7.5 7.5 0 0 1 22.91 25.032z"
        />
        <path
          fill="#9272FF"
          d="M22.91 12.304A7.5 7.5 0 1 1 12.304 22.91 7.5 7.5 0 0 1 22.91 12.304z"
        />
        <path
          fill="#AD96FF"
          d="M35.638 12.303a7.5 7.5 0 1 1-10.606 10.606 7.5 7.5 0 0 1 10.606-10.606z"
        />
        <defs fill="none">
          <radialGradient
            gradientTransform="matrix(0 23.4146 -23.4084 0 24 24.585)"
            gradientUnits="userSpaceOnUse"
            r="1"
            cy="0"
            cx="0"
            id="8cedbf8e-d233-421a-b46a-7ea0facde8e3_comp-lx8pwl493"
          >
            <stop stop-opacity="0" stop-color="#ffffff" offset=".15" />
            <stop stop-opacity=".15" stop-color="#A6A6FF" offset="1" />
          </radialGradient>
        </defs>
      </g>
    </svg>
  );
};

export const FreeCloud = (props: PropsOf<"svg">, key: string) => {
  return (
    <svg
      {...props}
      key={key}
      preserveAspectRatio="xMidYMid meet"
      data-bbox="0 0 48 48"
      xmlns="http://www.w3.org/2000/svg"
      viewBox="0 0 48 48"
      height="48"
      width="48"
      data-type="ugc"
      role="presentation"
      aria-hidden="true"
      aria-label="FreeCloud"
    >
      <g>
        <path
          fill="url(#46b256a6-fdda-4ffb-9d32-540a664ed4ed_comp-lx8pzixu2)"
          d="M48 8v32a8 8 0 0 1-8 8H8a8 8 0 0 1-8-8V8a8 8 0 0 1 8-8h32a8 8 0 0 1 8 8z"
        />
        <path
          fill="#7148FA"
          d="M36.91 25.304A7.5 7.5 0 1 1 26.304 35.91 7.5 7.5 0 0 1 36.91 25.304z"
        />
        <path
          fill="#9272FF"
          d="M29.275 18.667a7.5 7.5 0 1 1-10.607 10.606 7.5 7.5 0 0 1 10.607-10.606z"
        />
        <path
          fill="#AD96FF"
          d="M20.91 12.304A7.5 7.5 0 1 1 10.304 22.91 7.5 7.5 0 0 1 20.91 12.304z"
        />
        <defs fill="none">
          <radialGradient
            gradientTransform="matrix(0 23.4146 -23.4084 0 24 24.585)"
            gradientUnits="userSpaceOnUse"
            r="1"
            cy="0"
            cx="0"
            id="46b256a6-fdda-4ffb-9d32-540a664ed4ed_comp-lx8pzixu2"
          >
            <stop stop-opacity="0" stop-color="#ffffff" offset=".15" />
            <stop stop-opacity=".15" stop-color="#A6A6FF" offset="1" />
          </radialGradient>
        </defs>
      </g>
    </svg>
  );
};
