---
title: "Fortune 50 Manufacturer Uses NativeLink For 20x Accelerated Build Speed and 30x Improved Storage Density"
tags: ["news", "case-studies"]
image: https://nativelink-cdn.s3.us-east-1.amazonaws.com/nativelink_logo.webp
slug: case-study-fortune-50-manufacturer
pubDate: 2025-01-21
readTime: 3 minutes
---

# Background

A Fortune 50 Manufacturer builds a Chromium-based browser, and it has been an integral part of their product lineup, requiring robust and efficient build infrastructure to keep up with its evolving complexity. With a need for more advanced solutions due to increasing build complexity and domain variety, the Fortune 50 Manufacturer sought a tool that could provide remote execution and build caching at scale.

## Challenges

Increased build complexity. The heterogeneous nature of our customer’s builds required a solution capable of handling complex compositions across different executors. Existing solutions became inefficient and unscalable with increasing complexity of build domains, and the team needed a remote execution solution to push tasks to the right environments at the right time.

## Solution

Integrating with NativeLink’s remote execution platform and build caching capabilities, our client swiftly streamlined their build processes and reduced build times from 2 days to 2 **hours. Furthermore,** the customer team positioned itself to better handle future development needs, especially with the potential to improve storage density and overall system efficiency.

Future-proofing development. By adopting NativeLink, our customer positioned itself to better handle future development needs, with the potential to improve storage density and overall system efficiency. In early tests, the customer team was able to achieve a 1:4 compression ratio on compressed content and a 30x increase on the storage density of edited CAS content by extending NativeLink's [Dedup store](https://github.com/TraceMachina/nativelink/blob/main/nativelink-store/src/dedup_store.rs).

## Conclusion

The adoption of NativeLink by the Fortune 50 Manufacturer has proven to be a game-changer, enabling the team to efficiently manage complex builds, reduce build times, and scale their infrastructure effectively. This integration highlights the potential of NativeLink to significantly enhance development processes for large-scale projects.

To learn more about NativeLink, read our documentation, check out our GitHub Repository, or contact our team directly at [hello@nativelink.com](mailto:hello@nativelink.com).
